/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptGeneralLedgerCondition;

public class GLRptGeneralLedgerAccBalQueryHelper {
    private GLRptGeneralLedgerCondition cond;

    public GLRptGeneralLedgerAccBalQueryHelper(GLRptGeneralLedgerCondition cond) {
        this.cond = cond;
    }

    public String getFromSQL(boolean isAsstBal, String dsTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" from ").append(this.getAccountBalanceTableName()).append(" b ");
        sql.append(" inner join ").append(dsTableName).append(" t on b.faccountid = t.faccountid");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(" and b.").append(this.getBalCompanyFiledName()).append(" = t.").append(this.getBalCompanyFiledName()).append(" ");
        }
        if (this.cond.isAllCurrency()) {
            sql.append(" and b.fcurrencyid = t.fcurrencyid ");
        } else if (SQLUtil.isQueryByCurrency(this.cond)) {
            sql.append(" and b.fcurrencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        sql.append(" and t.fisaccounttotal = 0 ");
        sql.append(this.getJoinSysStatusCrol());
        return sql.toString();
    }

    public String getWhereSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" where b.").append(this.getBalCompanyFiledName()).append(" in ").append(this.cond.getCompanyIdsStr());
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        if (beginPeriod > this.cond.getCurrPeriod().getNumber()) {
            sql.append(" and b.fperiod <= ").append(endPeriod).append(" and (b.fperiod>= ").append(beginPeriod).append(" or b.fperiod >= ssc.currPeriod) ");
        } else {
            sql.append(" and b.fperiod in ");
            sql.append(SQLUtil.buildPeriodNumbersInSql(false, this.cond));
        }
        if (this.cond.isAfterCurrPeriod()) {
            sql.append(" and b.fperiod >= ssc.startPeriod ");
        }
        return sql.toString();
    }

    public String getAmountSelectSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.isShowFor()) {
            sql.append(this.getAmountSelectSQL("For"));
        }
        if (this.cond.isShowLocal()) {
            sql.append(this.getAmountSelectSQL("Local"));
        }
        if (this.cond.isShowRpt()) {
            sql.append(this.getAmountSelectSQL("Rpt"));
        }
        if (this.cond.isShowQty()) {
            sql.append(this.getQtySelectSQL());
        }
        return sql.toString();
    }

    private String getAmountSelectSQL(String suffix) throws EASBizException, BOSException {
        Integer startPeriod = new Integer(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
        Integer endPeriod = new Integer(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
        Integer endPeriodYear = new Integer(this.cond.getPeriodYearEnd());
        boolean isAfterPeriodIncluded = this.cond.isAfterCurrPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append(" ,sum(case ");
        sql.append(" when ").append(startPeriod).append(" < ssc.startPeriod and b.fperiod = ssc.startPeriod then b.fbeginbalance").append(suffix).append(" \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(startPeriod).append(" >= ssc.startPeriod and ").append(startPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(startPeriod).append(" then b.fbeginbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod then b.fendbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod and b.fperiod < ").append(startPeriod).append(" then b.fdebit").append(suffix).append(" - b.fcredit").append(suffix).append(" \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(startPeriod).append(" and b.fperiod >= ssc.startPeriod then b.fbeginbalance").append(suffix).append(" \r\n");
        }
        sql.append(" else 0 end) fbeginbalance").append(suffix);
        sql.append(",sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.startPeriod then b.FDebit").append(suffix).append(" else 0 end").append(") FDebit").append(suffix);
        sql.append(",sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >= ssc.startPeriod then b.FCredit").append(suffix).append(" else 0 end").append(") FCredit").append(suffix);
        sql.append(",sum(case ");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyeardebit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod> ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fdebit").append(suffix).append(" \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyeardebit").append(suffix).append(" \r\n");
        }
        sql.append(" else 0 end) fyeardebit").append(suffix).append(", \r\n");
        sql.append(" sum(case ");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyearcredit").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fcredit").append(suffix).append(" \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyearcredit").append(suffix).append(" \r\n");
        }
        sql.append(" else 0 end) fyearcredit").append(suffix).append(", \r\n");
        sql.append(" sum(case ");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fendbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod  then b.fendbalance").append(suffix).append(" \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod then b.fdebit").append(suffix).append(" - b.fcredit").append(suffix).append(" \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fendbalance").append(suffix).append(" \r\n");
        }
        sql.append(" else 0 end) fendbalance").append(suffix).append(" \r\n");
        return sql.toString();
    }

    private String getQtySelectSQL() throws EASBizException, BOSException {
        Integer startPeriod = new Integer(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
        Integer endPeriod = new Integer(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
        Integer endPeriodYear = new Integer(this.cond.getPeriodYearEnd());
        boolean isAfterPeriodIncluded = this.cond.isAfterCurrPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append(" ,sum(case \r\n");
        sql.append(" when ").append(startPeriod).append(" < ssc.startPeriod and b.fperiod = ssc.startPeriod then b.fbeginQty \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(startPeriod).append(" >= ssc.startPeriod and ").append(startPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(startPeriod).append(" then b.fbeginQty \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod then b.fendQty \r\n");
            sql.append(" when ").append(startPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod and b.fperiod < ").append(startPeriod).append(" then b.fdebitQty - b.fcreditQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(startPeriod).append(" then b.fbeginqty").append(" \r\n");
        }
        sql.append(" else 0 end) fbeginQty,\r\n");
        sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >=ssc.startPeriod then b.FDebitQty").append(" else 0 end").append(") FDebitQty,");
        sql.append(" sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod <= ").append(endPeriod).append(" and b.fperiod >=ssc.startPeriod then b.FCreditQty").append(" else 0 end").append(") FCreditQty,");
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyeardebitQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyeardebitQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fdebitQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyeardebitQty \r\n");
        }
        sql.append(" else 0 end) fyeardebitQty, \r\n");
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fyearcreditQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append(" then b.fyearcreditQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod and TO_INT(b.fperiod/100) = ").append(endPeriodYear).append("  then b.fcreditQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fyearcreditQty \r\n");
        }
        sql.append(" else 0 end) fyearcreditQty, \r\n");
        sql.append(" sum(case \r\n");
        if (isAfterPeriodIncluded) {
            sql.append(" when ").append(endPeriod).append(" >= ssc.startPeriod and ").append(endPeriod).append(" <= ssc.currPeriod and b.fperiod = ").append(endPeriod).append(" then b.fendQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod = ssc.currPeriod then b.fendQty \r\n");
            sql.append(" when ").append(endPeriod).append(" > ssc.currPeriod and b.fperiod > ssc.currPeriod then b.fdebitQty - b.fcreditQty \r\n");
        } else {
            sql.append(" when b.fperiod = ").append(endPeriod).append(" then b.fendQty \r\n");
        }
        sql.append(" else 0 end) fendQty \r\n");
        return sql.toString();
    }

    protected String getJoinSysStatusCrol() {
        StringBuffer sql = new StringBuffer();
        sql.append(" inner join (select ssc.").append(this.getSysStatusCompanyFiledName()).append(" fcompanyid, spd.fnumber startPeriod, cpd.fnumber currPeriod ");
        sql.append(" from t_bd_SystemStatusCtrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(this.getSystemEnum());
        sql.append(" inner join t_bd_period spd on spd.fid = ssc.fstartperiodid ");
        sql.append(" inner join t_bd_period cpd on cpd.fid = ssc.fcurrentperiodid) ssc on ssc.fcompanyid = b.").append(this.getBalCompanyFiledName()).append(" ");
        return sql.toString();
    }

    protected String getSysStatusCompanyFiledName() {
        return "fcompanyid";
    }

    protected String getBalCompanyFiledName() {
        return "forgunitid";
    }

    protected int getSystemEnum() {
        return 6;
    }

    protected String getAccountBalanceTableName() {
        return GLBalanceUtils.getAccountBalanceTable(this.cond);
    }
}

