/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptCompanyFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPeriodFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;

public class GLRptPLVoucherAccountBalQuery
extends GLRptQuery {
    private GLRptBaseCondition cond;
    private String alias = "ve";

    public GLRptPLVoucherAccountBalQuery(Context ctx, GLRptBaseCondition cond) {
        super(ctx, cond);
        this.cond = cond;
        this.setMainTable(GLRptDataTable.VOUCHERENTRY);
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select v.fcompanyid ").append(GLRptField.orgUnitID).append(",v.fperiodid,ve.faccountid,r.fassgrpid ").append(GLRptField.HG);
        if (this.cond.isAllCurrency()) {
            sql.append(",ve.fcurrencyid");
        }
        if (this.cond.isShowFor()) {
            this.appendAmountForField(sql);
        }
        if (this.cond.isShowLocal()) {
            this.appendAmountLocalField(sql);
        }
        if (this.cond.isShowRpt()) {
            this.appendAmountRptField(sql);
        }
        if (this.cond.isShowQty()) {
            this.appendQtyField(sql);
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" inner join t_gl_voucher v on ve.fbillid = v.fid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
        sql.append(" and v.fsourcetype = ").append(1);
        GLRptFilter cpFilter = this.getOrgFilter(this.cond);
        sql.append(cpFilter.getSQL());
        sql.append(" and av.faccounttableid = '").append(this.cond.getAccountTableId()).append("'");
        GLRptPeriodFilter pdFilter = new GLRptPeriodFilter(this.cond);
        sql.append(" and ").append(pdFilter.getSQL());
        if (!(this.cond.isAllCurrency() || this.cond.getCurrencyID().equals("11111111-1111-1111-1111-111111111111DEB58FDC") || this.cond.getCurrencyID().equals("22222222-2222-2222-2222-222222222222DEB58FDC"))) {
            sql.append(" and ve.fcurrencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        return sql.toString();
    }

    protected GLRptFilter getOrgFilter(GLRptBaseCondition cond) throws BOSException, EASBizException {
        GLRptCompanyFilter cpFilter = new GLRptCompanyFilter(cond, "v.fcompanyid");
        return cpFilter;
    }

    @Override
    protected String getGroupSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("v.fcompanyid,v.fperiodid,ve.faccountid,r.fassgrpid");
        if (this.cond.isAllCurrency()) {
            sql.append(",ve.fcurrencyid");
        }
        return sql.toString();
    }

    protected void appendAmountForField(StringBuffer sql) {
        sql.append(", sum(case ve.FEntryDC when ").append(1).append(" then ").append(this.alias).append(".FOriginalAmount else 0 end) ").append(GLRptField.debitFor);
        sql.append(", sum(case ve.FEntryDC when ").append(0).append(" then ").append(this.alias).append(".FOriginalAmount else 0 end) ").append(GLRptField.creditFor);
    }

    protected void appendAmountLocalField(StringBuffer sql) {
        sql.append(", sum(case ve.FEntryDC when ").append(1).append(" then ").append(this.alias).append(".FLocalAmount else 0 end) ").append(GLRptField.debitLocal);
        sql.append(", sum(case ve.FEntryDC when ").append(0).append(" then ").append(this.alias).append(".FLocalAmount else 0 end) ").append(GLRptField.creditLocal);
    }

    protected void appendAmountRptField(StringBuffer sql) {
        sql.append(", sum(case ve.FEntryDC when ").append(1).append(" then ").append(this.alias).append(".FReportingAmount else 0 end) ").append(GLRptField.debitRpt);
        sql.append(", sum(case ve.FEntryDC when ").append(0).append(" then ").append(this.alias).append(".FReportingAmount else 0 end) ").append(GLRptField.creditRpt);
    }

    protected void appendQtyField(StringBuffer sql) {
        sql.append(", sum(case ve.FEntryDC when ").append(1).append(" then ").append(this.alias).append(".FStandardQuantity else 0 end) ").append(GLRptField.debitQty);
        sql.append(", sum(case ve.FEntryDC when ").append(0).append(" then ").append(this.alias).append(".FStandardQuantity else 0 end) ").append(GLRptField.creditQty);
    }
}

