/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;

public class GLRptPLVoucherAsstactBalQuery
extends GLRptVoucherAssistQuery {
    private boolean isGroupByPAccount = false;
    private String accountTmpTable;
    private boolean isPLYear = false;

    public boolean isPLYear() {
        return this.isPLYear;
    }

    public void setPLYear(boolean PLYear) {
        this.isPLYear = PLYear;
    }

    public GLRptPLVoucherAsstactBalQuery(Context ctx, GLRptAsstactBaseCondition cond) throws EASBizException, BOSException {
        super(ctx, cond, false);
    }

    public void setGroupByPAccount(boolean isGroupByPAccount) {
        this.isGroupByPAccount = isGroupByPAccount;
        this.setAccountFilter(!isGroupByPAccount);
    }

    public void setAccountTmpTable(String accountTmpTable) {
        this.accountTmpTable = accountTmpTable;
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            sql.append(this.getSelectField(field));
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        if (this.isGroupByPAccount && this.accountTmpTable != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(super.getJoinSQL());
            sql.append(" inner join ").append(this.accountTmpTable).append(" av on av.fid = ").append(GLRptVoucherField.accountID.getSelect());
            return sql.toString();
        }
        return super.getJoinSQL();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String where = super.getWhereSQL();
        return where;
    }

    protected String getAccountFilterSQL() throws EASBizException, BOSException {
        GLRptAsstactBaseCondition cond = this.getCond();
        StringBuffer sql = new StringBuffer();
        sql.append(GLRptDataTable.ACCOUNT.getAlias()).append(".fcompanyid in ").append(cond.getCompanyIdsStr());
        sql.append(" and ").append(GLRptDataTable.ACCOUNT.getAlias()).append(".faccounttableid = '").append(cond.getAccountTableId()).append("'");
        String accFilter = this.getAccountFilter().getSQL();
        if (!StringUtils.isEmpty((String)accFilter)) {
            sql.append(" and ").append(accFilter);
        }
        return sql.toString();
    }

    protected GLRptFilter getAccountFilter() throws BOSException {
        return new GLRptAccountFilter(this.getCtx(), this.getCond(), "account", GLRptVoucherField.accountID.getSelect(), GLRptVoucherField.companyID.getSelect(), false, true, this.getCond().getCompanyIdsStr());
    }

    @Override
    protected String getSelectField(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (this.isGroupByPAccount && field == GLRptVoucherField.accountID) {
            sql.append(" av.fparentid ").append(field.getName());
        } else if (this.isGroupByPAccount && GLRptVoucherField.accountNumberMerger == field) {
            sql.append(" pav.fnumber ").append(field.getName());
        } else if (this.isGroupByPAccount && GLRptVoucherField.accountNameMerger == field) {
            sql.append(" pav.fname");
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
            sql.append(" ").append(field.getName());
        } else if (field.getType() == "NUMERIC(29,10)" && this.isGroupByPAccount) {
            sql.append(" sum(").append(field.getSelect()).append(") ").append(field.getName());
        } else {
            sql.append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale());
            }
            sql.append(" ").append(field.getName());
        }
        return sql.toString();
    }

    protected String getAmountSelectSQL(GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("sum(").append(field.getSelect()).append(") ").append(field);
        return sql.toString();
    }

    @Override
    protected void setSourceTypeFilter(StringBuffer sql) {
        sql.append(" AND ").append("voucher").append(".FSourceType = ").append(1);
    }

    @Override
    protected String getGroupSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || field.getType().equals("NUMERIC(29,10)")) continue;
            if (!first) {
                sql.append(",");
            } else {
                first = false;
            }
            sql.append(this.getGroupField(field));
        }
        return sql.toString();
    }

    protected String getGroupField(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (field == GLRptVoucherField.accountID && this.isGroupByPAccount) {
            sql.append("av.fparentid");
        } else if (this.isGroupByPAccount && GLRptVoucherField.accountNumberMerger == field) {
            sql.append(" pav.fnumber ");
        } else if (this.isGroupByPAccount && GLRptVoucherField.accountNameMerger == field) {
            sql.append(" pav.fname");
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
        } else {
            sql.append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale());
            }
        }
        return sql.toString();
    }

    @Override
    protected void setPeriodFilter(StringBuffer filter, boolean isFromBeginPeriod) throws BOSException, EASBizException {
        if (this.isPLYear) {
            int endPeriod;
            int startPeriod;
            if (this.getCond() instanceof GLRptAsstActTypeBalanceCondition) {
                startPeriod = this.getCond().getPeriodYearEnd() * 100 + 1;
                endPeriod = this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd();
            } else {
                startPeriod = this.getCond().getPeriodYearStart() * 100 + 1;
                endPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart() - 1;
            }
            Set<String> periodIdSet = this.getCond().getPeriodIdSetByRange(startPeriod, endPeriod);
            this.addFilterItem(filter, GLRptVoucherField.periodID.getSelect() + " in " + GLRptDaoUtil.set2String(periodIdSet));
            if (this.getCtx().get((Object)"isPca") == null) {
                this.addFilterItem(filter, "entries." + GLRptVoucherField.periodID + " in " + GLRptDaoUtil.set2String(periodIdSet));
            }
        } else {
            super.setPeriodFilter(filter, isFromBeginPeriod);
        }
    }
}

