/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTableJoin;
import java.util.ArrayList;
import java.util.List;

public class GLRptQuery {
    private Context ctx;
    private GLRptBaseCondition cond;
    private GLRptSelector selector;
    private GLRptDataTable mainTable;
    private GLRptTableJoin join;
    private boolean isOptimize = true;
    private List<GLRptFilter> filters = new ArrayList<GLRptFilter>();

    public GLRptQuery(Context ctx, GLRptBaseCondition cond) {
        this.ctx = ctx;
        this.cond = cond;
    }

    public GLRptSelector getSelector() {
        if (this.selector == null) {
            this.selector = new GLRptSelector();
        }
        return this.selector;
    }

    public void setSelector(GLRptSelector selector) {
        this.selector = selector;
    }

    public void setOptimize(boolean isOptimize) {
        this.isOptimize = isOptimize;
    }

    public boolean isOptimize() {
        return this.isOptimize;
    }

    public GLRptDataTable getMainTable() {
        return this.mainTable;
    }

    public void setMainTable(GLRptDataTable mainTable) {
        this.mainTable = mainTable;
    }

    protected String getSelectSQL() throws BOSException, EASBizException {
        return null;
    }

    protected String getFromSQL() throws BOSException, EASBizException {
        return this.mainTable.getTableName() + " " + this.mainTable.getAlias();
    }

    protected String getJoinSQL() throws BOSException, EASBizException {
        if (this.join != null && !this.join.isEmpty()) {
            return this.join.getSQL();
        }
        return "";
    }

    protected String getJoinPLYearSQL() throws BOSException, EASBizException {
        return null;
    }

    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        return null;
    }

    protected String getWhereSQL() throws BOSException, EASBizException {
        return null;
    }

    protected String getGroupSQL() throws BOSException, EASBizException {
        return null;
    }

    protected String getHavingSQL() throws BOSException, EASBizException {
        return null;
    }

    public void addGLRptFilter(GLRptFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public String getSQL() throws EASBizException, BOSException {
        GLRptSQLOrder order;
        String havingSQL;
        String groupSQL;
        String whereSQL;
        String joinPLYearSql;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ").append(this.getSelectSQL());
        sql.append(" FROM ").append(this.getFromSQL());
        String joinSql = this.getJoinSQL();
        if (joinSql != null && joinSql.trim().length() > 0) {
            sql.append(" ").append(joinSql);
        }
        if (this.cond != null && this.cond.isNotIncluePLVoucher() && (this.cond.getPeriodNumberStart() != 1 || this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd()) && (joinPLYearSql = this.getJoinPLYearSQL()) != null && joinPLYearSql.trim().length() > 0) {
            sql.append(joinPLYearSql);
        }
        if ((whereSQL = this.getWhereSQL()) != null && whereSQL.trim().length() > 0) {
            sql.append(" WHERE ").append(whereSQL);
        }
        if (!this.filters.isEmpty()) {
            for (GLRptFilter glRptFilter : this.filters) {
                String filter = glRptFilter.getSQL();
                if (filter == null || filter.trim().length() <= 0) continue;
                sql.append(whereSQL != null && whereSQL.trim().length() > 0 ? " AND " : " WHERE ");
                sql.append(filter);
            }
        }
        if ((groupSQL = this.getGroupSQL()) != null && groupSQL.trim().length() > 0) {
            sql.append(" GROUP BY ").append(groupSQL);
        }
        if ((havingSQL = this.getHavingSQL()) != null && havingSQL.trim().length() > 0) {
            sql.append(" HAVING ").append(havingSQL);
        }
        if ((order = this.getOrder()) != null && !order.isEmpty()) {
            sql.append(order.getOrderSQL());
        }
        try {
            return this.isOptimize ? KSqlUtil.optimize((String)sql.toString()) : sql.toString();
        }
        catch (SqlTranslateException e) {
            throw new BOSException("Sql optimize error!" + sql, (Throwable)e);
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public GLRptBaseCondition getCond() {
        return this.cond;
    }

    public void setJoin(GLRptTableJoin join) {
        this.join = join;
    }

    public List<GLRptFilter> getFilters() {
        return this.filters;
    }

    protected String getAccountBalanceTable() {
        return GLBalanceUtils.getAccountBalanceTable(this.getCond());
    }

    protected String getAssistBalanceTable() {
        return GLBalanceUtils.getAssistBalanceTable(this.getCond());
    }

    protected String getAssistMeasureBalanceTable() {
        return GLBalanceUtils.getAssistMeasureBalanceTable(this.getCond());
    }

    protected String getHint() {
        return "";
    }
}

