/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountNotHasAsstBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerSpliter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerVoucherQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherDetailDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptSubLedgerDao
extends GLRptVoucherDetailDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptSubLedgerDao");
    private GLRptSubLedgerCondition cond;
    private boolean isShowAccount;
    private int assistCount;
    private int oppAssistCount;
    private Map<String, Integer> actTypeMap;
    private int assistColumnCount = -1;
    private int insertDateType = -1;
    private boolean bizUnit = true;
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();

    public GLRptSubLedgerDao(Context ctx) throws EASBizException, BOSException {
        super(ctx, false);
        if (this.actTypeMap == null) {
            this.actTypeMap = GLRptHelper.initAcctTypeMap(ctx);
        }
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptSubLedgerCondition)this.getQueryCondition();
        this.cond.setShowQty(this.cond.isQty());
        Object isShowAccountObj = ev.get("isShowAccount");
        if (isShowAccountObj != null && isShowAccountObj instanceof Boolean) {
            this.isShowAccount = (Boolean)isShowAccountObj;
        }
        if (this.cond.getCtx().get((Object)"isPca") == null) {
            if (this.cond.getCompany() != null && !this.cond.getCompany().isIsBizUnit()) {
                this.bizUnit = false;
            }
        } else if (this.cond.getProfitCenter() != null && !this.cond.getProfitCenter().isIsBizUnit()) {
            this.bizUnit = false;
        }
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        this.insertDateType = -1;
        if (this.cond.isAcctAndAsst()) {
            GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
            this.insertDateType = 0;
            this.setGLRptSelector(this.initSelector());
            if (this.cond.isShowOppAccount()) {
                this.insertOtherAccountVoucher();
            } else {
                this.insertVoucher();
            }
            GLRptTempTableInfo mainTable = this.getDataSourceTable();
            this.clearAsstHgIdAndHgName(mainTable);
            this.insertBalance(false);
            if (this.cond.isShowDailyTotal()) {
                this.insertDailySum();
            }
            this.setGLRptSelector(this.initSelector());
            Set accountSet = this.getAccountHasCAA(this.cond.getAccountIdSet());
            boolean notNeedInsertPavAcctDate = true;
            if (this.isHasNotLeafAccount(this.cond) && this.getAssistColumnCount() > 1) {
                notNeedInsertPavAcctDate = false;
            }
            if ((accountSet == null || accountSet.size() == 0) && this.getAssistColumnCount() > 0 && notNeedInsertPavAcctDate) {
                return;
            }
            GLRptTempTableInfo tempTable = this.createDataTempTable();
            this.setDataSourceTable(tempTable);
            this.insertDateType = 1;
            if (this.cond.isShowOppAccount()) {
                this.insertOtherAccountVoucher();
            } else {
                this.insertVoucher();
            }
            this.insertBalance(true);
            if (this.cond.isShowDailyTotal()) {
                this.insertDailySum();
            }
            this.setDataSourceTable(mainTable);
            String[] fs = this.getTempTableStruct().getFieldNames();
            this.insertData(fs, this.getSql(tempTable.getTableName(), fs));
            this.cond.setAccountIdSet((Set)condition.getAccountIdSet());
            this.cond.setAccounts(condition.getAccounts());
        } else {
            if (this.cond.isShowOppAccount()) {
                this.insertOtherAccountVoucher();
            } else {
                this.insertVoucher();
            }
            this.insertBalance(false);
            if (this.cond.isShowDailyTotal()) {
                this.insertDailySum();
            }
        }
    }

    private void clearAsstHgIdAndHgName(GLRptTempTableInfo mainTable) throws BOSException {
        DbUtil.execute((Context)this.getContex(), (String)(" update " + mainTable.getTableName() + " SET FAssGrpId = null "));
    }

    @Override
    protected boolean isCreateDataTempTable() {
        return this.cond.isShowOppAccount() || this.cond.isGroupVoucher();
    }

    @Override
    protected boolean isCreateFiled(GLRptField field, boolean isCreateDataTempTable) {
        return field.isTempTableField() || this.cond.isShowOppAccount() && field.getSelect() != null && field.getType() == "NUMERIC(29,10)";
    }

    private boolean isAsstactTypeHasDetail(GLRptSubLedgerCondition cond, boolean isAsstActDetail) throws BOSException {
        if (cond.isShowDisplayAsstDetail() && !cond.isSumByAsstact() || isAsstActDetail) {
            List asstactList = cond.getAsstActList();
            if (asstactList == null) {
                return false;
            }
            if (asstactList.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private String getSql(String tableName, String[] fs) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String assGrpField = null;
        if (fs != null && fs.length > 0) {
            sql.append("select ");
            sql.append("tp.").append(fs[0]);
            for (int i = 1; i < fs.length; ++i) {
                if (fs[i].equals(GLRptField.isPeriodTotal.getName())) {
                    sql.append(", 2 ").append(fs[i]);
                    continue;
                }
                sql.append(",tp.").append(fs[i]);
                if (!fs[i].equalsIgnoreCase("FAssGrpId")) continue;
                assGrpField = "tp." + fs[i];
            }
            sql.append(" from ").append(tableName).append(" tp");
        }
        if (assGrpField != null) {
            sql.append("\r\n where ").append(assGrpField).append(" is not null");
        }
        return sql.toString();
    }

    private Set getAccountHasCAA(Set accountIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        AccountViewCollection acCol = AccountViewFactory.getLocalInstance((Context)this.cond.getCtx()).getAccountViewCollection(view);
        return this.getAccountIDSet(acCol);
    }

    private Set getAccountIDSet(AccountViewCollection accountColl) {
        if (accountColl == null || accountColl.isEmpty()) {
            return null;
        }
        this.cond.setAccounts(accountColl);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < accountColl.size(); ++i) {
            idSet.add(accountColl.get(i).getId().toString());
        }
        return idSet;
    }

    protected void insertOtherAccountVoucher() throws EASBizException, BOSException {
        this.getSpliter().split(this.getDataSourceTableName());
    }

    protected void insertVoucher() throws EASBizException, BOSException {
        if (this.cond.isShowDisplayAsstDetail() && !this.cond.isShowAccountAttribute()) {
            this.insertVoucher(0);
        } else if (!this.cond.isShowDisplayAsstDetail() && this.cond.isShowAccountAttribute()) {
            this.insertVoucher(1);
        } else if (this.cond.isShowDisplayAsstDetail() && this.cond.isShowAccountAttribute()) {
            this.insertVoucher(2);
        } else {
            this.insertVoucher(this.cond, false);
        }
    }

    private void insertVoucher(int accoutnType) throws EASBizException, BOSException {
        Set<String> accountIds2;
        if ((accoutnType == 0 || accoutnType == 2) && this.getAssistColumnCount() > 0) {
            AccountViewCollection coll = this.cond.getAccounts();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                ids.add(coll.get(i).getId().toString());
            }
            GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
            condition.setAccountIdSet(ids);
            this.insertVoucher(condition, false);
            return;
        }
        Set<String> accountIds1 = this.cond.getAccountIds(accoutnType, false);
        if (!accountIds1.isEmpty()) {
            GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
            condition.setAccountIdSet((Set)accountIds1);
            this.insertVoucher(condition, false);
        }
        if (!(accountIds2 = this.cond.getAccountIds(accoutnType, true)).isEmpty()) {
            GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
            condition.setAccountIdSet((Set)accountIds2);
            this.insertVoucher(condition, true);
        }
    }

    private void insertVoucher(GLRptSubLedgerCondition condition, boolean isVoucherEntry) throws EASBizException, BOSException {
        GLRptSubLedgerVoucherQuery query = this.getRptSubLedgerVoucherQuery(this.getContex(), this.getCompany(), condition, false);
        GLRptSelector selector = isVoucherEntry ? this.getEntrySelector() : this.getVoucherSelector();
        GLRptSelector insertSelector = new GLRptSelector();
        Iterator<GLRptField> it = selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.isTempTableField()) continue;
            insertSelector.add(field);
        }
        query.setSelector(insertSelector);
        query.setOrder(this.getVoucherSorter());
        this.insertData(this.getVoucherFields(isVoucherEntry), query.getSQL());
    }

    protected GLRptSQLOrder getVoucherSorter() throws BOSException, EASBizException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        this.addSelfOrder(order);
        if (!this.cond.isShowDailyTotal() && !this.isIncludeOrderItem("bookedDate")) {
            order.add(GLRptVoucherField.bookDate.getSelect());
        }
        order.add("voucher.FCreateTime");
        if (!this.isIncludeOrderItem("number")) {
            order.add("voucher.FNumber");
        }
        order.add("voucher.FID");
        if (!this.cond.isGroupVoucher()) {
            order.add("entries.FSeq");
            if (this.cond.isAcctAndAsst() || this.cond.isSumByAsstact()) {
                order.add("assistRecords.FSeq");
            }
        }
        return order;
    }

    private void addSelfOrder(GLRptSQLOrder order) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if ("number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherNumber.getSelect(), sorter.getSortType());
                    continue;
                }
                if ("bookedDate".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.bookDate.getSelect(), sorter.getSortType());
                    continue;
                }
                if ("voucherType.number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherTypeNumber.getSelect(), sorter.getSortType());
                    continue;
                }
                if (!"bizDate".equalsIgnoreCase(sorter.getPropertyName())) continue;
                order.add(GLRptVoucherField.voucherBizdate.getSelect(), sorter.getSortType());
            }
        }
    }

    private boolean isIncludeOrderItem(String propName) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if (!propName.equalsIgnoreCase(sorter.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    private GLRptSelector getEntrySelector() throws EASBizException, BOSException {
        GLRptSelector sic = new GLRptSelector();
        Iterator<GLRptField> it = this.getVoucherSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (GLRptVoucherField.isVoucherAssstField(field)) {
                GLRptField entryField = GLRptVoucherField.getVoucherEntryField(field);
                if (entryField == null) continue;
                sic.add(entryField);
                continue;
            }
            sic.add(field);
        }
        return sic;
    }

    private String[] getVoucherFields(boolean isVoucherEntry) throws EASBizException, BOSException {
        Iterator<GLRptField> it = this.getVoucherSelector().iterator();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("KSQL_SEQ");
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.isTempTableField() && field.getSelect() != null) {
                if (isVoucherEntry && GLRptVoucherField.isVoucherAssstField(field)) {
                    GLRptField entryField = GLRptVoucherField.getVoucherEntryField(field);
                    if (entryField == null) continue;
                    fields.add(entryField.getName());
                    continue;
                }
                fields.add(field.getName());
                continue;
            }
            if (!this.cond.isGroupVoucherByAccount() || !field.getName().equalsIgnoreCase("FDescription")) continue;
            fields.add(field.getName());
        }
        return fields.toArray(new String[fields.size()]);
    }

    protected GLRptSelector getVoucherSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptVoucherField.accountID);
        if (this.isShowAccount) {
            selector.add(GLRptVoucherField.accountNumber);
            if (this.cond.getRptParams().isAccountShowLongName()) {
                selector.add(GLRptVoucherField.accountDisplayName);
            } else {
                selector.add(GLRptVoucherField.accountName);
            }
        }
        if (this.cond.isSumByAsstact()) {
            selector.add(GLRptVoucherField.HGID);
            selector.add(GLRptVoucherField.HGName);
        }
        selector.add(GLRptVoucherField.bookDate);
        selector.add(GLRptVoucherField.createTime);
        if (!this.cond.isGroupVoucher()) {
            selector.add(this.isQueryEntryAssistField() ? GLRptVoucherField.entryAsstRecordBizdate : GLRptVoucherField.voucherBizdate);
            selector.add(GLRptVoucherField.entryID);
            selector.add(GLRptVoucherField.entrySeq);
        }
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            this.setOrgUnitSelector(selector);
        }
        selector.add(GLRptVoucherField.period);
        selector.add(GLRptVoucherField.voucherTypeName);
        selector.add(GLRptVoucherField.voucherTypeNumber);
        selector.add(GLRptVoucherField.voucherID);
        selector.add(GLRptVoucherField.voucherNumber);
        selector.add(GLRptVoucherField.voucherDescription);
        if (!this.cond.isGroupVoucher() && (this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute()) || this.cond.isAcctAndAsst()) {
            selector.add(GLRptVoucherField.asstRecordID);
        }
        GLRptField descField = null;
        descField = this.cond.queryVoucherAssistRecordField() || this.cond.isAcctAndAsst() && this.cond.getAsstActList() != null && this.cond.getAsstActList().size() != 0 ? (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact() ? GLRptVoucherField.OppEntryAsstRecordDesc : GLRptVoucherField.entryAsstRecordDesc) : (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact() ? GLRptVoucherField.oppEntryDesc : GLRptVoucherField.entryDesc);
        if (this.cond.isShowOppAccount()) {
            selector.add(GLRptVoucherField.oppEntrySeq);
        }
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact()) {
            selector.add(GLRptVoucherField.asstRecordSeq);
        }
        if (this.cond.isGroupVoucher()) {
            if (!this.cond.isGroupVoucherByAccount()) {
                this.addTempTableField(selector, descField);
            } else {
                selector.add(new GLRptField(descField.getName(), "NVARCHAR(512)", true));
            }
        } else {
            selector.add(descField);
        }
        if (this.cond.isShowOppAccount() || this.cond.isShowOppAsstact()) {
            selector.add(new GLRptField("FSelfDescription", "NVARCHAR(512)", "selfDescription", 100, true));
        }
        GLRptVoucherField.creatorName.setTempTableField(true);
        selector.add(GLRptVoucherField.creatorName);
        if (this.cond.isShowDisplayAsstDetail() && !this.cond.isSumByAsstact()) {
            selector.add(GLRptVoucherField.HGID);
            selector.add(GLRptVoucherField.HGName);
        }
        if (this.cond.isShowOppAccount()) {
            selector.add(GLRptVoucherField.oppAccountID);
            selector.add(GLRptVoucherField.oppAccountNumber);
            selector.add(GLRptVoucherField.oppAccountName);
        }
        if (this.cond.isShowOppAsstact()) {
            selector.add(GLRptVoucherField.oppHGID);
            selector.add(GLRptVoucherField.oppHGName);
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptVoucherField.currencyID);
            selector.add(GLRptVoucherField.currencyName);
            selector.add(GLRptVoucherField.currencyPre);
        }
        if (this.isShowFor() && this.isShowLocal() && !this.cond.isGroupVoucher()) {
            selector.add(GLRptVoucherField.localExRate);
            selector.add(GLRptVoucherField.localExRatePre);
        }
        if (this.isShowFor() && this.isShowRpt() && !this.cond.isGroupVoucher()) {
            selector.add(GLRptVoucherField.rptExRate);
            selector.add(GLRptVoucherField.rptExRatePre);
        }
        if (this.cond.isGroupByMU()) {
            selector.add(GLRptVoucherField.asstMeasureUnitID);
        }
        this.addDebitSelector(selector);
        this.addCreditSelector(selector);
        selector.add(GLRptVoucherField.voucherType);
        selector.add(GLRptVoucherField.accountDC);
        return selector;
    }

    protected void insertBalance(Boolean isAsstBal) throws EASBizException, BOSException {
        this.insertPeriodBeginBalance(isAsstBal);
        this.insertPeriodAndYearBalance();
        this.insertPeriodSumBalance();
    }

    protected void insertPeriodBeginBalance(Boolean isAsstBal) throws BOSException, EASBizException {
        if (this.cond.isShowDisplayAsstDetail() && this.cond.isAcctAndAsst() || this.cond.isSumByAsstact() || this.isAsstactTypeHasDetail(this.cond, false)) {
            Set<String> accountIds2;
            Set<String> accountIds1;
            GLRptSubLedgerCondition queryCond = this.cond;
            if (this.cond.getAsstActList() != null && !this.cond.getAsstActList().isEmpty()) {
                GLRptAsstactBeginPeriodBalQuery query = this.getRptAsstactBeginPeriodBalQuery(this.getContex(), this.getCompany(), this.cond, this.cond.isGroupByMU(), true);
                if (this.cond.getProfitCenter() != null && !this.cond.getProfitCenter().isIsBizUnit() || this.cond.getCompany() != null && !this.cond.getCompany().isIsBizUnit() || !this.cond.isLeafAccount() || !this.cond.isShowLeafAccount()) {
                    query.setGroupByPAccount(true);
                }
                this.insertBeginBalance(query, this.cond.isSumByAsstact() || isAsstBal != false);
                return;
            }
            boolean isUnion = this.cond.getCompanyIds().size() > 1;
            boolean hasNoLeafAccount = false;
            if (!this.cond.getCompany().isIsBizUnit() && this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                queryCond = (GLRptSubLedgerCondition)this.cond.clone();
                HashSet<String> numberSet = new HashSet<String>();
                AccountViewInfo account = this.cond.getAccounts().get(0);
                numberSet.add(account.getNumber());
                EntityViewInfo acctview = new EntityViewInfo();
                acctview.getSelector().add(new SelectorItemInfo("id"));
                acctview.getSelector().add(new SelectorItemInfo("CAA.id"));
                acctview.getSelector().add(new SelectorItemInfo("companyID.id"));
                acctview.getSelector().add(new SelectorItemInfo("hasUserProperty"));
                acctview.getSelector().add(new SelectorItemInfo("isLeaf"));
                acctview.getSelector().add(new SelectorItemInfo("level"));
                acctview.getSelector().add(new SelectorItemInfo("isQty"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.cond.getAccountTableId()));
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.cond.getCompanyIds(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
                acctview.setFilter(filter);
                AccountViewCollection accounts = AccountViewFactory.getLocalInstance((Context)this.cond.getCtx()).getAccountViewCollection(acctview);
                HashMap<String, String> bizAccountVirtualAccountMap = new HashMap<String, String>();
                for (int i = 0; i < accounts.size(); ++i) {
                    bizAccountVirtualAccountMap.put(accounts.get(i).getId().toString(), account.getId().toString());
                }
                this.cond.setBizAccountVirtualAccountMap(bizAccountVirtualAccountMap);
                HashSet<String> accountIds = new HashSet<String>();
                for (int i = 0; i < accounts.size(); ++i) {
                    accountIds.add(accounts.get(i).getId().toString());
                }
                Map result = AccountFacadeFactory.getLocalInstance((Context)this.cond.getCtx()).getCAAIdsByPeriodRange(accountIds, this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart(), this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
                Set caas = null;
                for (int i = 0; i < accounts.size(); ++i) {
                    AccountViewInfo ac = accounts.get(i);
                    caas = (Set)result.get(ac.getId().toString());
                    if (!hasNoLeafAccount) {
                        boolean bl = hasNoLeafAccount = !ac.isIsLeaf();
                    }
                    if (caas != null && caas.size() > 0) {
                        AsstAccountInfo asstAccount = new AsstAccountInfo();
                        asstAccount.setId(BOSUuid.read((String)((String)caas.iterator().next())));
                        ac.setCAA(asstAccount);
                        continue;
                    }
                    ac.setCAA(null);
                }
                queryCond.setAccounts(accounts);
            }
            if (!(accountIds1 = queryCond.getAccountIds(0, false)).isEmpty()) {
                GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
                condition.setAccountIdSet((Set)accountIds1);
                GLRptAsstactBeginPeriodBalQuery query = this.getRptAsstactBeginPeriodBalQuery(this.getContex(), this.getCompany(), condition, false, true);
                query.setGroupByPAccount(!condition.isLeafAccount());
                if (this.cond.isSumByAsstact() && this.insertDateType != 0 || this.insertDateType == 1) {
                    this.insertBeginBalance(query, true);
                } else {
                    this.insertBeginBalance(query, false);
                }
            }
            if (!(isUnion && this.isAsstactTypeHasDetail(this.cond, false) || (accountIds2 = queryCond.getAccountIds(0, true)).isEmpty())) {
                GLRptQuery query;
                GLRptSubLedgerCondition condition = (GLRptSubLedgerCondition)this.cond.clone();
                condition.setAccountIdSet((Set)accountIds2);
                if (!hasNoLeafAccount && !this.isHasNotLeafAccount(this.cond)) {
                    query = this.getRptAccountBeginPeriodBalQuery(this.getContex(), this.getCompany(), condition, true);
                    ((GLRptAccountBeginPeriodBalQuery)query).setGetAccoutBalWithNoAcct(true);
                    this.insertBeginBalance(query, false);
                } else {
                    query = this.getRptAsstactBeginPeriodBalQuery(this.getContex(), this.getCompany(), condition, false, true);
                    query.setGroupByPAccount(!condition.isLeafAccount());
                    if (this.cond.isSumByAsstact() && this.insertDateType != 0 || this.insertDateType == 1) {
                        this.insertBeginBalance(query, true);
                    } else {
                        this.insertBeginBalance(query, false);
                    }
                    if (!this.isAsstactTypeHasDetail(this.cond, true)) {
                        GLRptQuery queryAccout = this.getRptAccountBeginPeriodBalQuery(this.getContex(), this.getCompany(), condition, true);
                        ((GLRptAccountBeginPeriodBalQuery)queryAccout).setGetAccoutBalWithNoAcct(true);
                        this.insertBeginBalance(queryAccout, false);
                    }
                }
            }
        } else {
            GLRptQuery query = null;
            boolean isAccountNotHasAsst = this.isAccountNotHasAsst();
            query = isAccountNotHasAsst ? this.getRptAccountNotHasAsstBeginPeriodBalQuery(this.getContex(), this.getCompany(), this.cond, true) : this.getRptAccountBeginPeriodBalQuery(this.getContex(), this.getCompany(), this.cond, true);
            this.insertBeginBalance(query, false);
        }
        if (this.cond.isNoAmountShow()) {
            GLRptQuery queryAccount = this.getRptAccountBeginPeriodBalQuery(this.getContex(), this.getCompany(), this.cond, true);
            this.insertBeginBalanceForNoAmountAccount(queryAccount);
        }
    }

    protected boolean isHasNotLeafAccount(GLRptSubLedgerCondition cond) throws BOSException {
        Iterator<String> ite = cond.getAccountIdSet().iterator();
        StringBuffer sb = new StringBuffer("(");
        while (ite.hasNext()) {
            sb.append("'").append(ite.next().toString()).append("',");
        }
        if (sb.lastIndexOf(",") < 0) {
            return false;
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append(")");
        StringBuffer select = new StringBuffer();
        select.append("select top 1 1 from t_bd_accountview av where av.fisleaf=0 and av.fid in").append(sb);
        IRowSet result = this.executeQuery(select.toString());
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return false;
    }

    protected int getAssistColumnCount(String fieldName) throws BOSException, EASBizException {
        String sql = "SELECT MAX(FCount) fcount FROM T_BD_AssistantHG where fid in (select " + fieldName + " from " + this.getDataSourceTableName() + ")";
        IRowSet rs = this.executeQuery(sql);
        int assCount = 0;
        try {
            if (rs.next()) {
                assCount = rs.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return assCount;
    }

    private boolean isIncludeNullFAssGrpidData() throws BOSException {
        String sql = " SELECT top 1 FAssGrpID FROM  " + this.getDataSourceTableName() + "  where fbalseq = '2' AND FAssGrpID is null ";
        IRowSet rs = this.executeQuery(sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private boolean isAccountNotHasAsst() {
        AccountViewInfo account;
        boolean isAccountNotHasAsst = false;
        AccountViewCollection accountColl = this.cond.getAccounts();
        if (accountColl != null && accountColl.size() == 1 && this.cond.getCompany() != null && this.cond.getCompany().isIsBizUnit() && (account = accountColl.get(0)).getCAA() == null) {
            List asstList = this.cond.getAsstActList();
            for (int i = 0; i < asstList.size(); ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)asstList.get(i);
                if (!at.isSelected()) continue;
                isAccountNotHasAsst = true;
                break;
            }
        }
        return isAccountNotHasAsst;
    }

    protected void insertPeriodSumBalance() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ");
        sql.append("6 ").append("FBalSeq");
        sql.append(", t.").append(GLRptVoucherField.accountID.getName());
        if (this.isAllCurrency()) {
            sql.append(", t.").append(GLRptField.currencyID.getName());
        }
        sql.append(", ").append("1 ").append(GLRptField.isPeriodTotal.getName());
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("FBalSeq");
        fields.add(GLRptVoucherField.accountID.getName());
        if (this.isAllCurrency()) {
            fields.add(GLRptField.currencyID.getName());
        }
        fields.add(GLRptField.isPeriodTotal.getName());
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        this.insertData(fs, sql.toString());
    }

    protected void insertBeginBalance(GLRptQuery query, boolean isAsstBal) throws EASBizException, BOSException {
        query.setSelector(this.getBeginBalQuerySelector(isAsstBal));
        query.addGLRptFilter(new AmountFilter(isAsstBal));
        List fields = this.getInsertBalField(isAsstBal);
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        if (!this.cond.getCompany().isIsBizUnit() && this.cond.getSelectedCompanys().length > 1) {
            Iterator<GLRptField> it = query.getSelector().iterator();
            StringBuffer sql = new StringBuffer();
            StringBuffer orderBy = new StringBuffer();
            sql.append("select ");
            while (it.hasNext()) {
                GLRptField field = it.next();
                if ("NUMERIC(29,10)".equals(field.getType())) {
                    sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName()).append(", ");
                    continue;
                }
                if (GLRptField.periodBeginDate.getName().equals(field.getName())) {
                    sql.append("min(t.").append(field.getName()).append(") ").append(field.getName()).append(", ");
                    continue;
                }
                if (GLRptField.orgUnitID.getName().equals(field.getName())) continue;
                orderBy.append("t.").append(field.getName()).append(", ");
                sql.append("t.").append(field.getName()).append(", ");
            }
            sql.delete(sql.length() - 2, sql.length());
            orderBy.delete(orderBy.length() - 2, orderBy.length());
            sql.append(" from (" + query.getSQL() + ") t");
            sql.append(" group by " + orderBy);
            this.insertData(fs, sql.toString());
        } else {
            this.insertData(fs, query.getSQL());
        }
    }

    protected void insertBeginBalanceForNoAmountAccount(GLRptQuery query) throws EASBizException, BOSException {
        query.setSelector(this.getBeginBalQuerySelector(false));
        query.addGLRptFilter(new AmountFilter(false));
        List fields = this.getInsertBalField(false);
        int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> insertCols = new ArrayList<String>();
        sql.append(" select ");
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.get(i).toString().toLowerCase(Locale.ENGLISH);
            if (name.endsWith("qty") || name.endsWith("for") || name.endsWith("rpt") || name.endsWith("local")) {
                sql.append("0.00 ").append(name).append(", ");
                insertCols.add(name);
                continue;
            }
            if ("fperiod".equals(name)) {
                sql.append("'").append(startPeriod).append("' ").append(name).append(", ");
                insertCols.add(name);
                continue;
            }
            if ("fbookeddate".equals(name)) {
                sql.append("min(pd.FBeginDate) ").append(name).append(", ");
                insertCols.add(name);
                continue;
            }
            if ("fcurrencyid".equals(name)) {
                sql.append("'").append(this.cond.getCurrencyID()).append("' ").append(name).append(", ");
                insertCols.add(name);
                continue;
            }
            if ("faccountid".equals(name)) {
                sql.append("av.fid").append(", ");
                insertCols.add(name);
                continue;
            }
            if (!"fbalseq".equals(name)) continue;
            sql.append("1");
            insertCols.add(name);
        }
        sql.append(" from t_bd_accountview av ");
        sql.append(" inner join t_bd_period pd on 1 = 1 ");
        sql.append(" where pd.Fnumber >= " + startPeriod);
        sql.append(" and pd.Fnumber <= " + endPeriod);
        sql.append(" and av.fid IN ( " + this.cond.getAccountIdFilter() + ")");
        sql.append(" and not exists (select 1 from " + this.getDataSourceTableName() + " t1 where t1.faccountid = av.fid) ");
        sql.append(" group by av.fid");
        String[] fs = new String[insertCols.size()];
        this.insertData(insertCols.toArray(fs), sql.toString());
    }

    protected void insertPeriodAndYearBalance() throws BOSException, EASBizException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("FBalSeq");
        fields.add(GLRptVoucherField.accountID.getName());
        if (this.cond.isAcctAndAsst() && this.cond.isShowDisplayAsstDetail() || this.cond.isSumByAsstact()) {
            fields.add(GLRptVoucherField.HGID.getName());
        }
        fields.add(GLRptVoucherField.period.getName());
        fields.add(GLRptVoucherField.bookDate.getName());
        if (this.isAllCurrency()) {
            fields.add(GLRptField.currencyID.getName());
        }
        if (this.cond.isGroupByMU()) {
            fields.add(GLRptField.measureUnitID.getName());
        }
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        this.insertData(fs, this.getPeriodAndYearBalSql());
    }

    private String getPeriodAndYearBalSql() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (this.cond.isNoDisplayZeroTotal()) {
            sql.append(" distinct ");
        }
        sql.append(" t1.").append("FBalSeq");
        sql.append(", t.").append(GLRptVoucherField.accountID.getName());
        if (this.cond.isAcctAndAsst() && this.cond.isShowDisplayAsstDetail() || this.cond.isSumByAsstact()) {
            sql.append(", t.").append(GLRptVoucherField.HGID.getName());
        }
        sql.append(", pd.fnumber ").append(GLRptField.period.getName());
        sql.append(", pd.fenddate ").append(GLRptVoucherField.bookDate.getName());
        if (this.isAllCurrency()) {
            sql.append(", t.").append(GLRptField.currencyID.getName());
        }
        if (this.cond.isGroupByMU()) {
            sql.append(", t.").append(GLRptField.measureUnitID.getName());
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        if (this.isShowQty()) {
            sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        }
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        sql.append(" inner join t_bd_period pd on ").append(this.cond.isNoDisplayZeroTotal() ? "pd.fnumber = t.fperiod" : " pd.fnumber >= " + beginPeriod + " and pd.fnumber <= " + endPeriod);
        sql.append(" and pd.ftypeid = '").append(this.cond.getPeriodTypeId()).append("'");
        sql.append(" inner join (");
        sql.append(" select ").append(4).append(" ").append("FBalSeq");
        sql.append(" union all ");
        sql.append(" select ").append(5).append(" ").append("FBalSeq");
        sql.append(") t1 on 1=1");
        sql.append(" where t.").append("FBalSeq").append(" = ").append(this.cond.isNoDisplayZeroTotal() ? 2 : 1);
        return sql.toString();
    }

    protected List getInsertBalField(boolean isAsstBal) throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(GLRptVoucherField.accountID.getName());
        if (isAsstBal) {
            fields.add(GLRptVoucherField.HGID.getName());
        }
        fields.add(GLRptVoucherField.period.getName());
        fields.add(GLRptVoucherField.bookDate.getName());
        if (this.isAllCurrency()) {
            fields.add(GLRptVoucherField.currencyID.getName());
        }
        if (this.cond.isGroupByMU()) {
            fields.add(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        Iterator it = this.getBalAmountFields().iterator();
        while (it.hasNext()) {
            fields.add(((GLRptField)it.next()).getName());
        }
        fields.add(GLRptVoucherField.beginBalType.getName());
        return fields;
    }

    private List getBalAmountFields() throws EASBizException, BOSException {
        ArrayList<GLRptField> fields = new ArrayList<GLRptField>();
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.endQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.endBalanceRpt);
        }
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.yearDebitQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.yearCreditQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.yearCreditRpt);
        }
        return fields;
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        if (this.cond.isShowDisplayAsstDetail()) {
            this.assistCount = this.getAssistColumnCount("fassgrpid");
        }
        if (this.cond.isShowOppAsstact()) {
            this.oppAssistCount = this.getOppAssistColumnCount();
        }
        GLRptTableHeadInfo headInfo = super.initTableHeadInfo();
        return headInfo;
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.HGName) {
            for (int i = 0; i < this.assistCount; ++i) {
                GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
                colInfo.setColName("FAsstAccountName" + i);
                colInfo.setWidth(120);
                if (this.getFreezeField() != field) continue;
                colInfo.setFreeze(true);
            }
        } else if (field == GLRptVoucherField.oppHGName) {
            for (int i = 0; i < this.oppAssistCount; ++i) {
                GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
                colInfo.setColName("FOppAsstAccountName" + i);
                colInfo.setWidth(120);
                if (this.getFreezeField() != field) continue;
                colInfo.setFreeze(true);
            }
        } else if (field == GLRptVoucherField.voucherTypeName) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setHide(true);
            colInfo.setWidth(-1);
        } else if (field == GLRptVoucherField.creatorName) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(70);
        } else if (field == GLRptVoucherField.voucherDescription) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setHide(true);
            colInfo.setWidth(field.getLength());
        } else if (field == GLRptVoucherField.period || StringUtils.equals((String)field.getName(), (String)"FSelfDescription")) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setHide(true);
            colInfo.setWidth(field.getLength());
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field == GLRptVoucherField.HGName) {
            for (int i = 0; i < this.assistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (field == GLRptVoucherField.oppHGName) {
            for (int i = 0; i < this.oppAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (field == GLRptVoucherField.voucherNumber) {
            colTitles.add("voucher_type_number");
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.HGName) {
            for (int i = 0; i < this.assistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (field == GLRptVoucherField.oppHGName) {
            for (int i = 0; i < this.oppAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (this.isShowQty() && ("debitMeasureUnitName".equals(field.getName()) || "creditMeasureUnitName".equals(field.getName()) || "endMeasureUnitName".equals(field.getName()))) {
            colTitles.add("unit");
        } else if (field == GLRptVoucherField.voucherNumber) {
            colTitles.add("voucher_type_number");
        } else {
            super.setRow2Title(colTitles, field);
        }
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        super.toGLRptRowData(rs, rowData);
        String[] asstItemNames = new String[]{"FLongNameGroup", "FdisplaynameGroup", "FNumberGroup"};
        String asstName = "FAsstAccountName";
        this.setAsstItemName(rs, rowData, this.assistCount, asstItemNames, asstName);
        if (this.cond.isShowOppAsstact()) {
            String[] oppAsstItemNames = new String[]{"FOppLongNameGroup", "FOppdisplaynameGroup", "FOppNumberGroup"};
            String oppAsstName = "FOppAsstAccountName";
            this.setAsstItemName(rs, rowData, this.oppAssistCount, oppAsstItemNames, oppAsstName);
        }
        this.setOppAccountName(rs, rowData);
        boolean isPeriodSum = "1".equals(rs.getString(GLRptField.isPeriodTotal.getName()));
        if (isPeriodSum) {
            String periodSumName = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "period_sum", this.getContex());
            rowData.updateObject(GLRptVoucherField.asstRecordDesc.getName(), periodSumName);
            this.setPeriodSumBalance(rowData);
        }
    }

    private void setPeriodSumBalance(GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        int i;
        boolean isOnlyGroupByMU;
        ArrayList<String> names = new ArrayList<String>();
        GLRptPageQuery query = this.getGLRptDataQuery();
        boolean isQtyAsst = GlUtils.getQtyAsstParam(this.getContex());
        query.setDataSourceTable(this.getDataSourceTable());
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        GLRptSelector selectors = new GLRptSelector();
        boolean bl = isOnlyGroupByMU = this.cond.getMeasureUnitId() == null && this.cond.isGroupByMU();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (isOnlyGroupByMU && ("FBalSeq".equals(field.getName()) || GLRptVoucherField.asstMeasureUnitID.getName().equals(field.getName()))) {
                selectors.add(field);
                continue;
            }
            if (!"NUMERIC(29,10)".equals(field.getType())) continue;
            selectors.add(field);
        }
        query.setSelector(selectors);
        String querySql = query.getSQL();
        if (!isQtyAsst) {
            querySql = querySql.replace("assistRecords.FPrice", "entries.FPrice");
        }
        if (!StringUtils.isEmpty((String)this.cond.getMeasureUnitId())) {
            querySql = querySql.replace("account.FMeasureUnitID", "'" + this.cond.getMeasureUnitId() + "' ");
        }
        String accountId = rowData.getString("FAccountID");
        String accountFilter = " t.FAccountID = '" + accountId + "' ";
        int index = querySql.toLowerCase().indexOf("where");
        if (index != -1) {
            querySql = querySql.substring(0, index + 5) + accountFilter + " and " + querySql.substring(index + 5);
            index = 0;
        } else {
            index = querySql.toLowerCase().indexOf("group by");
        }
        if (index == -1) {
            index = querySql.toLowerCase().indexOf("order by");
        }
        if (index > 0) {
            querySql = querySql.substring(0, index) + " where " + accountFilter + querySql.substring(index);
        }
        String filter = " t.fbalSeq in (1,2) ";
        index = querySql.indexOf("where");
        querySql = querySql.substring(0, index + 5) + filter + " and " + querySql.substring(index + 5);
        if (this.isAllCurrency()) {
            String currencyId = rowData.getString("FCurrencyID");
            String currencyFilter = " t.FCurrencyID = '" + currencyId + "' ";
            index = querySql.indexOf("where");
            querySql = querySql.substring(0, index + 5) + currencyFilter + " and " + querySql.substring(index + 5);
        }
        if (this.cond.isAcctAndAsst()) {
            index = querySql.indexOf("where");
            String periodTotalFilter = " t." + GLRptField.isPeriodTotal.getName() + " is null ";
            querySql = querySql.substring(0, index + 5) + periodTotalFilter + " and " + querySql.substring(index + 5);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContex(), (String)querySql);
        ResultSetMetaData rsm = rs.getMetaData();
        for (int i2 = 1; i2 <= rsm.getColumnCount(); ++i2) {
            String name = rsm.getColumnName(i2);
            if (rsm.getColumnType(i2) != 2 && rsm.getColumnType(i2) != 3 || "fbalseq".equalsIgnoreCase(name)) continue;
            names.add(name.toLowerCase());
        }
        BigDecimal[] result = new BigDecimal[names.size()];
        while (rs.next()) {
            for (i = 0; i < names.size(); ++i) {
                BigDecimal amount;
                if (result[i] == null) {
                    result[i] = BigDecimal.ZERO;
                }
                if (isOnlyGroupByMU && "1".equals(rs.getString("FBalSeq")) && GLRptVoucherField.endQty.getName().equalsIgnoreCase((String)names.get(i))) {
                    BigDecimal endQty = rs.getBigDecimal(GLRptVoucherField.endQty.getName());
                    String measureId = rs.getString(GLRptVoucherField.asstMeasureUnitID.getName());
                    if (endQty != null && measureId != null && !"00000000-0000-0000-0000-0000000000005B825C57".equals(measureId)) {
                        endQty = endQty.multiply(this.getAsstQtyCoefficient(measureId)).divide(this.getAccountQtyCoefficient(accountId), 10, 4);
                    }
                    amount = endQty;
                } else {
                    amount = this.cond.getMeasureUnitId() == null && GLRptVoucherField.entryDebitQty.getName().equalsIgnoreCase((String)names.get(i)) ? rs.getBigDecimal(GLRptVoucherField.entryAsstStandDebitQty.getName()) : (this.cond.getMeasureUnitId() == null && GLRptVoucherField.entryCreditQty.getName().equalsIgnoreCase((String)names.get(i)) ? rs.getBigDecimal(GLRptVoucherField.entryAsstStandCreditQty.getName()) : rs.getBigDecimal((String)names.get(i)));
                }
                if (amount == null) continue;
                result[i] = result[i].add(amount);
            }
        }
        for (i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String debitName = null;
            String creditName = null;
            if (name.endsWith("BalanceFor".toLowerCase(Locale.ENGLISH))) {
                debitName = GLRptVoucherField.asstRecordDebitFor.getName();
                creditName = GLRptVoucherField.asstRecordCreditFor.getName();
            } else if (name.endsWith("BalanceLocal".toLowerCase(Locale.ENGLISH))) {
                debitName = GLRptVoucherField.asstRecordDebitLocal.getName();
                creditName = GLRptVoucherField.asstRecordCreditLocal.getName();
            } else if (name.endsWith("BalanceRpt".toLowerCase(Locale.ENGLISH))) {
                debitName = GLRptVoucherField.asstRecordDebitRpt.getName();
                creditName = GLRptVoucherField.asstRecordCreditRpt.getName();
            } else if (name.endsWith(GLRptField.endQty.getName().toLowerCase(Locale.ENGLISH))) {
                debitName = GLRptVoucherField.asstRecordDebitQty.getName();
                creditName = GLRptVoucherField.asstRecordCreditQty.getName();
            }
            if (debitName != null && creditName != null) {
                result[i] = result[names.indexOf(debitName.toLowerCase())].subtract(result[names.indexOf(creditName.toLowerCase())]).add(result[i]);
            }
            rowData.updateBigDecimal((String)names.get(i), result[i]);
        }
    }

    @Override
    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null && !this.cond.getRptParams().isQtyAsst() && this.cond.isGroupByMU() && this.cond.getMeasureUnitId() == null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = super.getAccountQtyCoefficient(accountId);
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.getContex()).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.getContex()).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return super.getAccountQtyCoefficient(accountId);
    }

    protected BigDecimal getAsstQtyCoefficient(String measureId) throws BOSException, EASBizException {
        MeasureUnitInfo measureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)this.getContex()).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureId));
        BigDecimal convsRate = measureUnitInfo.getBigDecimal("coefficient");
        return convsRate == null ? BigDecimal.ONE : convsRate;
    }

    private void setAsstItemName(IRowSet rs, GLRptRowSet rowData, int assistCount, String[] asstItemNames, String asstName) throws SQLException, EASBizException, BOSException {
        if (assistCount <= 0) {
            return;
        }
        String asstNameL = rs.getString(asstItemNames[0]);
        String asstNameD = rs.getString(asstItemNames[1]);
        String asstNameN = rs.getString(asstItemNames[2]);
        try {
            if (asstNameL != null) {
                asstNameL = asstNameL.substring(0, asstNameL.length() - 1);
                asstNameD = asstNameD.substring(0, asstNameD.length() - 1);
                asstNameN = asstNameN.substring(0, asstNameN.length() - 1);
            }
            String[] strAsstNameL = StringUtil.split((String)asstNameL, (String)";");
            String[] strAsstNameD = StringUtil.split((String)asstNameD, (String)";");
            String[] strAsstNameN = StringUtil.split((String)asstNameN, (String)";");
            String number = null;
            int acctTypeFlag = 0;
            if (strAsstNameL == null) {
                return;
            }
            if (!this.cond.isSumByAsstact()) {
                StringBuffer asstant = new StringBuffer();
                for (int i = 0; i < strAsstNameL.length; ++i) {
                    if (number == null && this.actTypeMap.get(number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"))) != null) {
                        acctTypeFlag = this.actTypeMap.get(number);
                    }
                    String assistItemName = GLRptHelper.getAssDisplayName(this.cond.getRptParams().isAssitemShowNumber(), this.cond.getRptParams().isShowLongNameForGeneral(), this.cond.getRptParams().isShowLongNumberForGeneral(), acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                    rowData.updateString(asstName + i, assistItemName);
                }
            } else {
                for (int i = 0; i < assistCount; ++i) {
                    if (strAsstNameL.length <= i) continue;
                    if (number == null && this.actTypeMap.get(number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"))) != null) {
                        acctTypeFlag = this.actTypeMap.get(number);
                    }
                    String assistItemName = GLRptHelper.getAssDisplayName(this.cond.getRptParams().isAssitemShowNumber(), this.cond.getRptParams().isShowLongNameForGeneral(), this.cond.getRptParams().isShowLongNumberForGeneral(), acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                    rowData.updateString(asstName + i, assistItemName);
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("FAccountID:" + rs.getString("FAccountID") + ", FAssGrpId:" + rs.getString("FAssGrpId") + ", asstNameL:" + asstNameL + " asstNameD:" + asstNameD + " asstNameN:" + asstNameN, e);
        }
    }

    private void setOppAccountName(IRowSet rs, GLRptRowSet rowSet) throws BOSException, SQLException {
        if (this.cond.isShowOppAccount()) {
            String oppAccountNumber = rs.getString(GLRptVoucherField.oppAccountNumber.getName());
            String oppAccountName = rs.getString(GLRptVoucherField.oppAccountName.getName());
            if (oppAccountNumber != null) {
                rowSet.updateString(GLRptVoucherField.oppAccountName.getName(), oppAccountNumber + "-" + oppAccountName);
            }
        }
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        String vtName = rowSet.getString(GLRptVoucherField.voucherTypeName.getName());
        String vNumber = rowSet.getString(GLRptVoucherField.voucherNumber.getName());
        if (vtName != null) {
            rowSet.updateString(GLRptVoucherField.voucherNumber.getName(), "[" + vtName + "]" + vNumber);
        }
        if (rowSet.getInt("FBalSeq") == 1) {
            rowSet.updateObject(GLRptField.period.getName(), null);
            rowSet.updateObject(GLRptVoucherField.bookDate.getName(), null);
        }
        if (this.cond.isShowAccountAttribute() && rowSet.getObject(GLRptVoucherField.feeType.getName()) != null) {
            rowSet.updateObject(GLRptVoucherField.feeType.getName(), FeeTypeEnum.getEnum((int)rowSet.getInt(GLRptVoucherField.feeType.getName())));
        }
        int rowType = rowSet.getInt("FBalSeq");
        if (rowSet.indexOf("endMeasureUnitName") != -1 && (4 == rowType || 5 == rowType || 3 == rowType)) {
            rowSet.updateString("debitMeasureUnitName", rowSet.getString("endMeasureUnitName"));
            rowSet.updateString("creditMeasureUnitName", rowSet.getString("endMeasureUnitName"));
        }
    }

    @Override
    protected void doRowSet(GLRptRowSet rs, GLRptRowSet preRs, String endSuf, String sufifx) throws BOSException, EASBizException {
        super.doRowSet(rs, preRs, endSuf, sufifx);
        if (this.cond.isShowDailyTotal()) {
            this.setDayTotal(rs, preRs, sufifx);
        }
    }

    private void setDayTotal(GLRptRowSet rs, GLRptRowSet preRs, String sufifx) throws BOSException {
        int rowType = rs.getInt("FBalSeq");
        if (rowType == 1 || rowType == 4 || rowType == 5) {
            return;
        }
        BigDecimal debit = GlUtils.zero;
        BigDecimal credit = GlUtils.zero;
        if (rs.getInt("FBalSeq") == 2) {
            debit = this.getDebit(rs, sufifx);
            credit = this.getCredit(rs, sufifx);
        }
        BigDecimal lastDayDebit = preRs.getBigDecimal("FDayDebit" + sufifx);
        BigDecimal lastDayCredit = preRs.getBigDecimal("FDayCredit" + sufifx);
        rs.updateBigDecimal("FDayDebit" + sufifx, this.add(lastDayDebit, debit));
        rs.updateBigDecimal("FDayCredit" + sufifx, this.add(lastDayCredit, credit));
        if (3 == rowType) {
            rs.updateBigDecimal("FSubDebit" + sufifx, rs.getBigDecimal("FDayDebit" + sufifx));
            rs.updateBigDecimal("FSubCredit" + sufifx, rs.getBigDecimal("FDayCredit" + sufifx));
            rs.updateBigDecimal("FDayDebit" + sufifx, null);
            rs.updateBigDecimal("FDayCredit" + sufifx, null);
        }
    }

    protected int getAssistColumnCount() throws BOSException, EASBizException {
        if (this.assistColumnCount >= 0) {
            return this.assistColumnCount;
        }
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(this.getContex());
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(asst.fcount) fcount");
        sql.append(" from t_bd_accountview av");
        sql.append(" inner join t_bd_accountview pav on pav.faccounttableid = av.faccounttableid");
        if (isSupportCharIndexToLike) {
            sql.append(" and av.flongnumber like concat(pav.flongnumber, '%') ");
        } else {
            sql.append(" and charindex(pav.flongnumber,av.flongnumber) = 1 ");
        }
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and pav.fcompanyid = av.fcompanyid");
        }
        sql.append(" inner join t_bd_asstaccount asst on asst.fid = av.fcaa");
        sql.append(" where av.fisleaf = 1");
        sql.append(" and av.fcompanyid in ").append(this.cond.getCompanyIdsStr());
        String accountIds = this.cond.getAccountIdFilter();
        sql.append(" and pav.fid in (").append(accountIds).append(")");
        IRowSet result = DbUtil.executeQuery((Context)this.getContex(), (String)sql.toString());
        this.assistColumnCount = 0;
        try {
            if (result.next()) {
                this.assistColumnCount = result.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        sql.setLength(0);
        sql.append("SELECT \n");
        sql.append("max(case when be.fid is null then 0 else be.FCOUNT end) FBCount, \n");
        sql.append("max(case when af.fid is null then 0 else af.FCOUNT end) FACount \n");
        sql.append("FROM T_BD_AsstAccountChange aac \n");
        sql.append("join T_BD_AccountView av on av.fid = aac.FAccountID \n");
        sql.append("left join T_BD_ASSTACCOUNT be on be.FID = aac.FBeforeID \n");
        sql.append("left join T_BD_ASSTACCOUNT af on af.FID = aac.FAfterID \n");
        sql.append("join t_bd_accountview pav on pav.faccounttableid = av.faccounttableid ");
        if (isSupportCharIndexToLike) {
            sql.append("and av.flongnumber like concat(pav.flongnumber, '%') \n");
        } else {
            sql.append("and charindex(pav.flongnumber,av.flongnumber) = 1 \n");
        }
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and pav.fcompanyid = av.fcompanyid \n");
        }
        sql.append("where av.fisleaf = 1");
        sql.append("   and av.fcompanyid in ").append(this.cond.getCompanyIdsStr()).append(" \n");
        sql.append("   and pav.fid in (").append(accountIds).append(") \n");
        result = DbUtil.executeQuery((Context)this.getContex(), (String)sql.toString());
        try {
            if (result.next()) {
                int c = result.getInt("FBCount");
                if (c > this.assistColumnCount) {
                    this.assistColumnCount = c;
                }
                if ((c = result.getInt("FACount")) > this.assistColumnCount) {
                    this.assistColumnCount = c;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return this.assistColumnCount;
    }

    protected int getOppAssistColumnCount() throws BOSException, EASBizException {
        String sql = "SELECT MAX(FCount) fcount FROM T_BD_AssistantHG where fid in (select FOppAssGrpId from " + this.getDataSourceTableName() + ")";
        IRowSet rs = this.executeQuery(sql);
        int assCount = 0;
        try {
            if (rs.next()) {
                assCount = rs.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return assCount;
    }

    protected GLRptSelector getBeginBalQuerySelector(boolean isAsstBal) throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        if (!this.cond.getCompany().isIsBizUnit() && this.cond.getSelectedCompanys().length > 1) {
            selector.add(GLRptField.orgUnitID);
        }
        if (isAsstBal) {
            selector.add(GLRptField.HG);
        }
        selector.add(GLRptField.period);
        selector.add(GLRptField.periodBeginDate);
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
        }
        if (this.cond.isGroupByMU()) {
            selector.add(GLRptField.measureUnitID);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        selector.add(GLRptVoucherField.beginBalType);
        return selector;
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = this.getVoucherSelector();
        this.addEndBalSelector(selector);
        selector.add(GLRptVoucherField.creatorName);
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.yearCreditRpt);
        }
        if (this.cond.isShowDailyTotal()) {
            if (this.isShowQty()) {
                selector.add(GLRptVoucherField.dayDebitQty);
            }
            if (this.isShowFor()) {
                selector.add(GLRptVoucherField.dayDebitFor);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptVoucherField.dayDebitLocal);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptVoucherField.dayDebitRpt);
            }
            if (this.isShowQty()) {
                selector.add(GLRptVoucherField.dayCreditQty);
            }
            if (this.isShowFor()) {
                selector.add(GLRptVoucherField.dayCreditFor);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptVoucherField.dayCreditLocal);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptVoucherField.dayCreditRpt);
            }
        }
        if (this.cond.isShowAccountAttribute() && !this.cond.isGroupVoucher()) {
            this.addCustomizedPropertySelector(selector);
        }
        selector.add(GLRptField.isPeriodTotal);
        return selector;
    }

    private void addEndBalSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.endMeasureUnitName);
            selector.add(GLRptVoucherField.endQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.endPrice);
            }
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.endBalanceRpt);
        }
    }

    private void addCreditSelector(GLRptSelector selector) throws EASBizException, BOSException {
        if (this.isShowQty() && !this.cond.isGroupVoucher()) {
            String loc = this.cond.getCtx().getLocale().toString();
            if (this.cond.isShowDisplayAsstDetail() && this.cond.getRptParams().isQtyAsst()) {
                selector.add(new GLRptField("creditMeasureUnitName", "case entries.FEntryDC when 0 then measureUnit.fname_" + loc + " else null end", "NVARCHAR(500)", "dir_credit", 60, false));
            } else {
                selector.add(new GLRptField("creditMeasureUnitName", "case entries.FEntryDC when 0 then measureUnit.fname_" + loc + " else null end", "NVARCHAR(500)", "dir_credit", 60, false));
            }
        }
        if (this.cond.isShowOppAccount()) {
            this.addOppCreditSelector(selector);
        } else if (this.isQueryEntryAssistField()) {
            this.addAsstCreditSelector(selector);
        } else {
            this.addEntryCreditSelector(selector);
        }
    }

    private void addDebitSelector(GLRptSelector selector) throws EASBizException, BOSException {
        if (this.isShowQty() && !this.cond.isGroupVoucher()) {
            String loc = this.cond.getCtx().getLocale().toString();
            if (this.cond.isShowDisplayAsstDetail() && this.cond.getRptParams().isQtyAsst()) {
                selector.add(new GLRptField("debitMeasureUnitName", "case entries.FEntryDC when 1 then measureUnit.fname_" + loc + " else null end", "NVARCHAR(500)", "dir_debit", 60, false));
            } else {
                selector.add(new GLRptField("debitMeasureUnitName", "case entries.FEntryDC when 1 then measureUnit.fname_" + loc + " else null end", "NVARCHAR(500)", "dir_debit", 60, false));
            }
        }
        if (this.cond.isShowOppAccount()) {
            this.addOppDebitSelector(selector);
        } else if (this.isQueryEntryAssistField()) {
            this.addAsstDebitSelector(selector);
        } else {
            this.addEntryDebitSelector(selector);
        }
    }

    private boolean isQueryEntryAssistField() {
        return this.cond.queryVoucherAssistRecordField() || this.cond.isAcctAndAsst() && this.cond.getAsstActList() != null && this.cond.getAsstActList().size() != 0;
    }

    private void addOppDebitSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            selector.add(new GLRptField(GLRptVoucherField.entryStandDebitQty.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryStandDebitQty.getTitle(), GLRptVoucherField.entryStandDebitQty.getLength(), true));
            selector.add(new GLRptField(GLRptVoucherField.entryDebitQty.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryDebitQty.getTitle(), GLRptVoucherField.entryDebitQty.getLength(), true));
            if (isShowPrice) {
                if (this.isQueryEntryAssistField()) {
                    selector.add(GLRptVoucherField.entryAsstDebitPrice);
                } else {
                    selector.add(GLRptVoucherField.entryDebitPrice);
                }
            }
        }
        if (this.isShowFor()) {
            selector.add(new GLRptField(GLRptVoucherField.entryDebitFor.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryDebitFor.getTitle(), GLRptVoucherField.entryDebitFor.getLength(), true));
        }
        if (this.isShowLocal()) {
            selector.add(new GLRptField(GLRptVoucherField.entryDebitLocal.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryDebitLocal.getTitle(), GLRptVoucherField.entryDebitLocal.getLength(), true));
        }
        if (this.isShowRpt()) {
            selector.add(new GLRptField(GLRptVoucherField.entryDebitRpt.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryDebitRpt.getTitle(), GLRptVoucherField.entryDebitRpt.getLength(), true));
        }
    }

    private void addOppCreditSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            selector.add(new GLRptField(GLRptVoucherField.entryStandCreditQty.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryStandCreditQty.getTitle(), GLRptVoucherField.entryStandCreditQty.getLength(), true));
            selector.add(new GLRptField(GLRptVoucherField.entryCreditQty.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryCreditQty.getTitle(), GLRptVoucherField.entryCreditQty.getLength(), true));
            if (isShowPrice) {
                if (this.isQueryEntryAssistField()) {
                    selector.add(GLRptVoucherField.entryAsstCreditPrice);
                } else {
                    selector.add(GLRptVoucherField.entryCreditPrice);
                }
            }
        }
        if (this.isShowFor()) {
            selector.add(new GLRptField(GLRptVoucherField.entryCreditFor.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryCreditFor.getTitle(), GLRptVoucherField.entryCreditFor.getLength(), true));
        }
        if (this.isShowLocal()) {
            selector.add(new GLRptField(GLRptVoucherField.entryCreditLocal.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryCreditLocal.getTitle(), GLRptVoucherField.entryCreditLocal.getLength(), true));
        }
        if (this.isShowRpt()) {
            selector.add(new GLRptField(GLRptVoucherField.entryCreditRpt.getName(), "NUMERIC(29,10)", GLRptVoucherField.entryCreditRpt.getTitle(), GLRptVoucherField.entryCreditRpt.getLength(), true));
        }
    }

    private void addAsstDebitSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstStandDebitQty);
            this.addTempTableField(selector, GLRptVoucherField.entryAsstDebitQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.entryAsstDebitPrice);
            }
        }
        if (this.isShowFor()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstDebitFor);
        }
        if (this.isShowLocal()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstDebitLocal);
        }
        if (this.isShowRpt()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstDebitRpt);
        }
    }

    private void addAsstCreditSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstStandCreditQty);
            this.addTempTableField(selector, GLRptVoucherField.entryAsstCreditQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.entryAsstCreditPrice);
            }
        }
        if (this.isShowFor()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstCreditFor);
        }
        if (this.isShowLocal()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstCreditLocal);
        }
        if (this.isShowRpt()) {
            this.addTempTableField(selector, GLRptVoucherField.entryAsstCreditRpt);
        }
    }

    private void addEntryDebitSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            this.addTempTableField(selector, GLRptVoucherField.entryStandDebitQty);
            this.addTempTableField(selector, GLRptVoucherField.entryDebitQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.entryDebitPrice);
            }
        }
        if (this.isShowFor()) {
            this.addTempTableField(selector, GLRptVoucherField.entryDebitFor);
        }
        if (this.isShowLocal()) {
            this.addTempTableField(selector, GLRptVoucherField.entryDebitLocal);
        }
        if (this.isShowRpt()) {
            this.addTempTableField(selector, GLRptVoucherField.entryDebitRpt);
        }
    }

    private void addEntryCreditSelector(GLRptSelector selector) throws EASBizException, BOSException {
        boolean isShowPrice;
        boolean bl = isShowPrice = this.isShowQty() && !this.cond.isGroupVoucher();
        if (this.isShowQty()) {
            this.addTempTableField(selector, GLRptVoucherField.entryStandCreditQty);
            this.addTempTableField(selector, GLRptVoucherField.entryCreditQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.entryCreditPrice);
            }
        }
        if (this.isShowFor()) {
            this.addTempTableField(selector, GLRptVoucherField.entryCreditFor);
        }
        if (this.isShowLocal()) {
            this.addTempTableField(selector, GLRptVoucherField.entryCreditLocal);
        }
        if (this.isShowRpt()) {
            this.addTempTableField(selector, GLRptVoucherField.entryCreditRpt);
        }
    }

    private void addTempTableField(GLRptSelector selector, GLRptField field) {
        if (this.cond.isGroupVoucher()) {
            GLRptField newFiled = field.clone();
            newFiled.setTempTableField(true);
            selector.add(newFiled);
        } else {
            selector.add(field);
        }
    }

    protected void addCustomizedPropertySelector(GLRptSelector selector) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("customizedtype.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(this.getAccountIDFilterItemInfo());
        view.setFilter(filter);
        AssistCustomizedPropertyCollection coll = AssistCustomizedPropertyFactory.getLocalInstance(this.getContex()).getAssistCustomizedPropertyCollection(view);
        if (this.contains(coll, "bizNumber")) {
            selector.add(GLRptVoucherField.bizNumber);
        }
        if (this.contains(coll, "invoiceNumber")) {
            selector.add(GLRptVoucherField.invoiceNumber);
        }
        if (this.contains(coll, "settlementCode")) {
            selector.add(GLRptVoucherField.settlementCode);
        }
        if (this.contains(coll, "settlementType")) {
            selector.add(GLRptVoucherField.settleTypeID);
            selector.add(GLRptVoucherField.settleTypeName);
        }
        if (this.contains(coll, "ticketNumber")) {
            selector.add(GLRptVoucherField.ticketNumber);
        }
        if (this.contains(coll, "feeType")) {
            selector.add(GLRptVoucherField.feeType);
        }
        if (this.contains(coll, "handler")) {
            selector.add(GLRptVoucherField.receiverID);
            selector.add(GLRptVoucherField.receiverName);
        }
        if (this.contains(coll, "customer")) {
            selector.add(GLRptVoucherField.customer);
        }
        if (this.contains(coll, "supplier")) {
            selector.add(GLRptVoucherField.supplier);
        }
        if (this.contains(coll, "material")) {
            selector.add(GLRptVoucherField.material);
        }
    }

    private FilterItemInfo getAccountIDFilterItemInfo() throws BOSException {
        Set<String> accountIdSet = this.cond.getAccountIdSet();
        if (accountIdSet.size() > 500 || this.isBizUnit()) {
            return new FilterItemInfo("account.id", (Object)this.cond.getAccountIdFilter(), CompareType.INNER);
        }
        return new FilterItemInfo("account.number", (Object)this.cond.getAccounts().get(0).getNumber(), CompareType.INCLUDE);
    }

    protected boolean contains(AbstractObjectCollection coll, String prop) {
        if (prop == null) {
            return false;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (!prop.equals(((AssistCustomizedPropertyInfo)it.next()).getCustomizedType().getNumber())) continue;
            return true;
        }
        return false;
    }

    protected void insertDailySum() throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuffer select = new StringBuffer();
        StringBuffer group = new StringBuffer();
        fields.add(GLRptVoucherField.bookDate.getName());
        fields.add(GLRptVoucherField.period.getName());
        fields.add("FBalSeq");
        select.append(" select ").append(GLRptVoucherField.bookDate.getName()).append(",").append(GLRptVoucherField.period.getName());
        select.append(", ").append(3).append(" ").append("FBalSeq");
        group.append(" group by ").append(GLRptVoucherField.bookDate.getName()).append(",").append(GLRptVoucherField.period.getName());
        fields.add(GLRptVoucherField.accountID.getName());
        select.append(",").append(GLRptVoucherField.accountID.getName());
        group.append(",").append(GLRptVoucherField.accountID.getName());
        if (this.cond.isShowDisplayAsstDetail() && this.cond.isAcctAndAsst() || this.cond.isSumByAsstact()) {
            fields.add(GLRptVoucherField.HGID.getName());
            select.append(",").append(GLRptVoucherField.HGID.getName());
            group.append(",").append(GLRptVoucherField.HGID.getName());
        }
        if (this.cond.isAllCurrency()) {
            fields.add(GLRptVoucherField.currencyID.getName());
            select.append(",").append(GLRptVoucherField.currencyID.getName());
            group.append(",").append(GLRptVoucherField.currencyID.getName());
        }
        if (this.cond.isGroupByMU()) {
            fields.add(GLRptVoucherField.asstMeasureUnitID.getName());
            select.append(",").append(GLRptVoucherField.asstMeasureUnitID.getName());
            group.append(",").append(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || "NUMERIC(29,10)" != field.getType()) continue;
            select.append(",sum(").append(field.getName()).append(") ").append(field.getName());
            fields.add(field.getName());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(select);
        sql.append(" FROM ").append(this.getDataSourceTableName());
        sql.append(" WHERE ").append("FBalSeq").append(" = ").append(2);
        sql.append(group);
        this.insertData(fields.toArray(new String[fields.size()]), sql.toString());
    }

    @Override
    protected GLRptTempTableInfo createDataTempTable() throws BOSException, EASBizException {
        return new GLRptTempTableInfo(GLTempTableUtil.createDBSysTempTable(this.getContex(), "KSQL_SEQ INT IDENTITY (1, 1)," + this.getTempTableStruct().getDataTableDesc()));
    }

    @Override
    protected BigDecimal getDebit(GLRptRowSet rs, String sufifx) throws BOSException {
        BigDecimal debit = rs.getBigDecimal("FSubDebit" + sufifx);
        if (sufifx.equals("Qty") && rs.getInt("FBalSeq") == 2 && !this.cond.isGroupByMU()) {
            debit = rs.getBigDecimal(GLRptVoucherField.entryAsstStandDebitQty.getName());
        }
        return debit;
    }

    @Override
    protected BigDecimal getCredit(GLRptRowSet rs, String sufifx) throws BOSException {
        BigDecimal credit = rs.getBigDecimal("FSubCredit" + sufifx);
        if (sufifx.equals("Qty") && rs.getInt("FBalSeq") == 2 && !this.cond.isGroupByMU()) {
            credit = rs.getBigDecimal(GLRptVoucherField.entryAsstStandCreditQty.getName());
        }
        return credit;
    }

    @Override
    protected GLRptRowSet getPreRowData(GLRptRowSet rs) throws EASBizException, BOSException {
        GLRptRowSet preRs = super.getPreRowData(rs);
        if (preRs.indexOf("FDebitQty") != -1) {
            preRs.updateBigDecimal("FDebitQty", preRs.getBigDecimal("FStandardDebitQty"));
            preRs.updateBigDecimal("FCreditQty", preRs.getBigDecimal("FStandardCreditQty"));
        }
        return preRs;
    }

    @Override
    protected String[] getPreRowSetCols() throws EASBizException, BOSException {
        String[] cols = super.getPreRowSetCols();
        String[] cols_new = new String[cols.length + 2];
        System.arraycopy(cols, 0, cols_new, 0, cols.length);
        cols_new[cols.length] = "FStandardDebitQty";
        cols_new[cols.length + 1] = "FStandardCreditQty";
        return cols_new;
    }

    @Override
    public GLRptField getTreeColmun() {
        return null;
    }

    @Override
    protected boolean isUseRptID() {
        return super.isUseRptID();
    }

    public boolean getIsShowAccount() {
        return this.isShowAccount;
    }

    protected GLRptSubLedgerVoucherQuery getRptSubLedgerVoucherQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond, boolean isOnlyQty) {
        return new GLRptSubLedgerVoucherQuery(ctx, company, cond, isOnlyQty);
    }

    protected GLRptAsstactBeginPeriodBalQuery getRptAsstactBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMu, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactBeginPeriodBalQuery(ctx, company, cond, isMu, isCreateDataTempTable);
    }

    protected GLRptQuery getRptAccountBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAccountBeginPeriodBalQuery(ctx, company, cond, isCreateDataTempTable);
    }

    protected GLRptQuery getRptAccountNotHasAsstBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAccountNotHasAsstBeginPeriodBalQuery(ctx, company, cond, isCreateDataTempTable);
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptSubLedgerPageQuery(this.getContex(), this.cond, this.isShowAccount);
    }

    protected GLRptSubLedgerSpliter getSpliter() {
        return new GLRptSubLedgerSpliter(this.getContex(), this, (OrgUnitInfo)this.getCompany(), this.cond);
    }

    protected void setOrgUnitSelector(GLRptSelector selector) {
        selector.add(GLRptVoucherField.companyID);
        selector.add(GLRptVoucherField.companyName);
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptSubLedgerDao";
    }

    public boolean isBizUnit() {
        return this.bizUnit;
    }

    public void setBizUnit(boolean bizUnit) {
        this.bizUnit = bizUnit;
    }

    public class AmountFilter
    implements GLRptFilter {
        private boolean isAsstBal;

        public AmountFilter(boolean isAsstBal) {
            this.isAsstBal = isAsstBal;
        }

        @Override
        public String getSQL() throws EASBizException, BOSException {
            if (GLRptSubLedgerDao.this.cond.isOptionAmountZero()) {
                return this.getVoucherFilter();
            }
            if (GLRptSubLedgerDao.this.cond.isOptionAmountAndBalZero()) {
                StringBuffer sql = new StringBuffer();
                sql.append("(").append(this.getVoucherFilter()).append(" or ").append(this.getBalFilter()).append(")");
                return sql.toString();
            }
            return null;
        }

        private String getVoucherFilter() throws BOSException {
            StringBuffer sql = new StringBuffer();
            sql.append(" exists (select 1 from ").append(GLRptSubLedgerDao.this.getDataSourceTableName()).append(" t ");
            sql.append(" where t.FAccountId = t1.FAccountId ");
            if (!GLRptSubLedgerDao.this.isAsstactTypeHasDetail(GLRptSubLedgerDao.this.cond, false) && this.isAsstBal) {
                sql.append(" and t.FAssGrpId = t1.FAssistGrpId ");
            }
            if (GLRptSubLedgerDao.this.isAllCurrency()) {
                sql.append(" and t.FCurrencyId = t1.FCurrencyId ");
            }
            sql.append(")");
            return sql.toString();
        }

        private String getBalFilter() throws EASBizException, BOSException {
            StringBuffer sql = new StringBuffer();
            sql.append(" (");
            if (GLRptSubLedgerDao.this.isShowFor()) {
                sql.append(" t1.").append(GLRptField.beginBalanceFor).append("<>0");
            }
            if (GLRptSubLedgerDao.this.isShowLocal()) {
                if (GLRptSubLedgerDao.this.isShowFor()) {
                    sql.append(" or ");
                }
                sql.append(" t1.").append(GLRptField.beginBalanceLocal).append("<>0");
            }
            if (GLRptSubLedgerDao.this.isShowRpt()) {
                if (GLRptSubLedgerDao.this.isShowFor() || GLRptSubLedgerDao.this.isShowLocal()) {
                    sql.append(" or ");
                }
                sql.append(" t1.").append(GLRptField.beginBalanceRpt).append("<>0");
            }
            sql.append(")");
            return sql.toString();
        }
    }
}

