/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherDetailPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.util.HashMap;

public class GLRptSubLedgerPageQuery
extends GLRptVoucherDetailPageQuery {
    private GLRptSubLedgerCondition cond;
    private boolean isShowAccount;

    public GLRptSubLedgerPageQuery(Context ctx, GLRptSubLedgerCondition cond, boolean isShowAccount) {
        super(ctx, cond);
        this.cond = cond;
        this.isShowAccount = isShowAccount;
    }

    @Override
    protected GLRptField getSubSelect(GLRptField field) {
        GLRptField select = field;
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute()) {
            if (field.isQty()) {
                if (GLRptVoucherField.entryAsstDebitQty == field) {
                    select = GLRptVoucherField.entryAsstStandDebitQty;
                } else if (GLRptVoucherField.entryAsstCreditQty == field) {
                    select = GLRptVoucherField.entryAsstStandCreditQty;
                }
            }
        } else {
            select = super.getSubSelect(field);
        }
        if (this.cond.isShowOppAccount()) {
            select = new GLRptField(select.getName(), this.getMainTable().getAlias() + "." + select.getName(), select.getQueryField(), select.getType());
        }
        return select;
    }

    @Override
    protected GLRptField getDebitSelect(GLRptField field) {
        GLRptField select = null;
        select = this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute() ? (field.isQty() ? (field.isStandardQty() ? GLRptVoucherField.entryAsstStandDebitQty : GLRptVoucherField.entryAsstDebitQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.entryAsstDebitFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.entryAsstDebitLocal : GLRptVoucherField.entryAsstDebitRpt))) : super.getDebitSelect(field);
        if (this.cond.isShowOppAccount()) {
            select = new GLRptField(select.getName(), this.getMainTable().getAlias() + "." + select.getName(), select.getQueryField(), select.getType());
        }
        return select;
    }

    @Override
    protected GLRptField getCreditSelect(GLRptField field) {
        GLRptField select = null;
        select = this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute() ? (field.isQty() ? (field.isStandardQty() ? GLRptVoucherField.entryAsstStandCreditQty : GLRptVoucherField.entryAsstCreditQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.entryAsstCreditFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.entryAsstCreditLocal : GLRptVoucherField.entryAsstCreditRpt))) : super.getCreditSelect(field);
        if (this.cond.isShowOppAccount()) {
            select = new GLRptField(select.getName(), this.getMainTable().getAlias() + "." + select.getName(), select.getQueryField(), select.getType());
        }
        return select;
    }

    @Override
    protected String getSelectField(GLRptField field, GLRptField select) {
        String selectedField = super.getSelectField(field, select);
        if (field.isStandardQty()) {
            selectedField = selectedField + "*1.0000/ISNULL(endMU.FCoefficient,1) ";
        }
        return selectedField;
    }

    @Override
    protected String getSelectField(GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.HGName) {
            String loc = this.getCtx().getLocale().toString();
            if (this.cond.isAcctAndAsst()) {
                return "case when assGrp.flongnamegroup_" + loc + " is not null then assGrp.flongnamegroup_" + loc + " else assGrp4acctAndAsst.flongnamegroup_" + loc + " end flongnamegroup,case when assGrp.FdisplaynameGroup_" + loc + " is not null then assGrp.FdisplaynameGroup_" + loc + " else assGrp4acctAndAsst.FdisplaynameGroup_" + loc + " end FdisplaynameGroup,case when assGrp.FNumberGroup_" + loc + " is not null then assGrp.FNumberGroup_" + loc + " else assGrp4acctAndAsst.FNumberGroup_" + loc + " end FNumberGroup";
            }
            return "assGrp.flongnamegroup_" + loc + " flongnamegroup, assGrp.FdisplaynameGroup_" + loc + " FdisplaynameGroup, assGrp.FNumberGroup_" + loc + " FNumberGroup";
        }
        if (field == GLRptVoucherField.oppHGName) {
            String loc = this.getCtx().getLocale().toString();
            return "ohg.flongnamegroup_" + loc + " fopplongnamegroup, ohg.FdisplaynameGroup_" + loc + " FoppdisplaynameGroup, ohg.FNumberGroup_" + loc + " FoppNumberGroup";
        }
        if (field.isStandardQty()) {
            if (this.cond != null && this.cond.isGroupByMU()) {
                return (field.isTempTableField() ? "t." + field.getName() : "(" + field.getSelect() + ")") + " " + field.getName();
            }
            return (field.isTempTableField() ? "t." + field.getName() : "(" + field.getSelect() + ")") + "*1.0000/ISNULL(endMU.FCoefficient,1) " + field.getName();
        }
        if (field == GLRptVoucherField.oppAccountName) {
            String name = field.getSelect();
            if (this.getCond().isAccountShowLongName()) {
                name = "oav.fdisplayName";
            }
            return name + "_" + this.getCtx().getLocale().toString() + " " + field.getName();
        }
        return super.getSelectField(field);
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinDataBaseSQL());
        if (this.cond.isShowOppAccount()) {
            sql.append(" left outer join t_bd_accountview oav on oav.fid = t.FOppAccountID ");
        }
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowAccountAttribute() || this.cond.isAcctAndAsst()) {
            sql.append(" left outer join ").append(this.getVoucherAssistRecordTable()).append(" assistRecords on assistRecords.fid = t.assistRecordID ");
        }
        if (this.cond.isShowDisplayAsstDetail()) {
            sql.append(" left outer join t_bd_assistanthg assGrp on assGrp.fid = t.FAssGrpId ");
        }
        if (this.cond.isAcctAndAsst()) {
            sql.append(" left outer join t_bd_assistanthg assGrp4acctAndAsst on assGrp4acctAndAsst.fid = assistRecords.FAssGrpId ");
        }
        if (this.cond.isShowOppAsstact()) {
            sql.append(" left outer join t_bd_assistanthg ohg on ohg.fid = t.FOppAssGrpId ");
        }
        if (this.cond.isShowAccountAttribute()) {
            sql.append(" left outer join T_BD_SettlementType settlementType on assistRecords.FSettlementTypeID= settlementType.fid");
            sql.append(" left outer join T_PM_USER receiver on assistRecords.FHandlerID = receiver.fid");
            sql.append(" left outer join T_BD_CUSTOMER accountAttributeCustomer on accountAttributeCustomer.fid = assistRecords.FCustomerID");
            sql.append(" left outer join T_BD_SUPPLIER accountAttributeSupplier on accountAttributeSupplier.fid = assistRecords.FSupplierID");
            sql.append(" left outer join T_BD_MATERIAL accountAttributeMaterial on accountAttributeMaterial.fid = assistRecords.FMaterialID");
        }
        if (this.cond.isShowQty()) {
            if (!this.cond.isGroupVoucher()) {
                if (this.cond.isShowDisplayAsstDetail() && this.cond.getRptParams().isQtyAsst()) {
                    sql.append(" left outer join t_bd_measureunit measureUnit on measureUnit.fid = ").append(this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null ? "t" : "assistRecords").append(".FMeasureUnitID");
                } else {
                    sql.append(" left outer join t_bd_measureunit measureUnit on measureUnit.fid = entries.FMeasureUnitID");
                }
            }
            sql.append(" left outer join t_bd_measureunit endMU on endMU.fid = account.FMeasureUnitID");
        }
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getCtx().get((Object)OrgType.Company);
        HashMap<String, BOSUuid> hmParamIn = new HashMap<String, BOSUuid>();
        hmParamIn.put("GL_113", company.getId());
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.getCtx());
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Object pss = hmAllParam.get("GL_113");
        boolean isTimeOrder = false;
        if (pss != null) {
            isTimeOrder = Integer.parseInt(pss.toString()) == 0;
        }
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (this.isShowAccount) {
            order.add("account.fnumber");
        }
        order.add("(case when t." + GLRptField.isPeriodTotal + " is null then 0 else t." + GLRptField.isPeriodTotal + " end)");
        if (this.cond.isAcctAndAsst() && this.cond.isShowDisplayAsstDetail() || this.cond.isSumByAsstact()) {
            order.add("(case when " + GLRptVoucherField.HGName.getSelect() + "_" + this.getCtx().getLocale().toString() + " is null then N'0' else " + GLRptVoucherField.HGName.getSelect() + "_" + this.getCtx().getLocale().toString() + " end )");
        }
        if (this.cond.isAllCurrency()) {
            order.add("currency.FNumber");
        }
        if (this.cond.isGroupByMU()) {
            order.add(this.cond.isShowQty() ? "measureUnit.fnumber" : "t.FMeasureUnitID");
        }
        order.add("t." + GLRptField.period.getName());
        if (this.cond.isShowDailyTotal()) {
            order.add("t." + GLRptVoucherField.bookDate.getName());
        }
        order.add("t.FBalSeq");
        this.addSelfOrder(order);
        if (!this.cond.isShowDailyTotal() && !this.isIncludeOrderItem("bookedDate")) {
            order.add("t." + GLRptVoucherField.bookDate.getName());
        }
        if (isTimeOrder) {
            order.add("t." + GLRptVoucherField.createTime.getName());
        }
        if (!this.isIncludeOrderItem("voucherType.number")) {
            order.add("t." + GLRptVoucherField.voucherTypeNumber.getName());
        }
        if (!this.isIncludeOrderItem("number")) {
            order.add("t." + GLRptVoucherField.voucherNumber.getName());
        }
        if (!isTimeOrder) {
            order.add("t." + GLRptVoucherField.createTime.getName());
        }
        if (!this.cond.isGroupVoucher()) {
            order.add("t." + GLRptVoucherField.entrySeq.getName());
        }
        if (this.cond.isShowOppAccount()) {
            order.add("t." + GLRptVoucherField.oppEntrySeq.getName());
        }
        if (this.cond.isShowDisplayAsstDetail() || this.cond.isShowOppAsstact()) {
            order.add("t." + GLRptVoucherField.asstRecordSeq.getName());
        }
        return order;
    }

    private void addSelfOrder(GLRptSQLOrder order) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                String propName = sorter.getPropertyName();
                if ("number".equalsIgnoreCase(propName)) {
                    order.add("t." + GLRptVoucherField.voucherNumber.getName(), sorter.getSortType());
                    continue;
                }
                if ("voucherType.number".equalsIgnoreCase(propName)) {
                    order.add("t." + GLRptVoucherField.voucherTypeNumber.getName(), sorter.getSortType());
                    continue;
                }
                if ("bookedDate".equalsIgnoreCase(propName) && !this.cond.isShowDailyTotal()) {
                    order.add("t." + GLRptVoucherField.bookDate.getName(), sorter.getSortType());
                    continue;
                }
                if (!"bizDate".equalsIgnoreCase(sorter.getPropertyName())) continue;
                order.add(GLRptVoucherField.voucherBizdate.getSelect(), sorter.getSortType());
            }
        }
    }

    private boolean isIncludeOrderItem(String propName) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if (!propName.equalsIgnoreCase(sorter.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getCurrRowHGID(GLRptRowSet rs) throws BOSException {
        return this.cond.isShowDisplayAsstDetail() ? rs.getString(GLRptVoucherField.HGID.getName()) : null;
    }
}

