/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptSubLedgerVoucherQuery
extends GLRptVoucherAssistQuery {
    private static final Logger logger = CoreUIObject.getLogger(GLRptSubLedgerVoucherQuery.class);
    private String accountTmpTable;

    public GLRptSubLedgerVoucherQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond, boolean isOnlyQty) {
        super(ctx, cond, isOnlyQty);
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        GLRptSubLedgerCondition cond = this.getCond();
        if (cond == null) {
            return super.getSQL();
        }
        if (!cond.isLeafAccount() || cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            this.setAccountFilter(false);
            this.accountTmpTable = this.createAccountTmpTable(cond);
        }
        return super.getSQL();
    }

    @Override
    public String getQueryFilter() throws EASBizException, BOSException {
        String filter = super.getQueryFilter();
        if (this.getCond().isAcctAndAsst() && !this.getCond().isShowDisplayAsstDetail()) {
            String string = filter.length() > 0 ? "and" : "";
        }
        return filter;
    }

    public String createAccountTmpTable(GLRptSubLedgerCondition cond) throws BOSException, EASBizException {
        String tmpTable = GLTempTableUtil.createDBSysTempTable(this.getCtx(), "FID varchar(44),FParentID varchar(44)" + (cond.isGroupVoucher() ? ",FSParentID varchar(44)" : ""), "FID");
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(this.getCtx());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tmpTable).append("(FID,FParentID").append(cond.isGroupVoucher() ? ",FSParentID" : "").append(")");
        sql.append(" select account.fid, pav.fid").append(cond.isGroupVoucher() ? ",sav.fid" : "");
        sql.append(" from t_bd_accountview account ");
        sql.append(" inner join t_bd_accountview pav on account.faccounttableid = pav.faccounttableid ");
        if (isSupportCharIndexToLike) {
            sql.append(" and (account.flongnumber like concat(pav.flongnumber, '!%')");
        } else {
            sql.append(" and (charindex(pav.flongnumber||'!', account.flongnumber) = 1");
        }
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(" or pav.fnumber = account.fnumber) ");
            sql.append(" and account.fcompanyid in ").append(cond.getCompanyIdsStr());
        } else {
            sql.append(" or pav.fid = account.fid) ");
            sql.append(" and account.fcompanyid = pav.fcompanyid ");
        }
        if (cond.isGroupVoucher()) {
            sql.append(" inner join t_bd_accountview sav on ( ");
            if (isSupportCharIndexToLike) {
                sql.append(" account.flongnumber like concat(sav.flongnumber, '!%') ");
            } else {
                sql.append(" charindex(sav.flongnumber||'!', account.flongnumber) = 1 ");
            }
            sql.append(" or sav.fid = account.fid) ");
            sql.append(" and sav.faccounttableid = account.faccounttableid and sav.fcompanyid = account.fcompanyid ");
            sql.append(" and (sav.flevel = ").append(cond.getGroupVoucherAccLevel()).append(" or (sav.fisleaf = 1 and sav.flevel < ").append(cond.getGroupVoucherAccLevel()).append("))");
        }
        sql.append(" where pav.fid in (").append(cond.getAccountIdFilter()).append(") and account.fisleaf = 1");
        this.setAccountTableFilter(sql);
        this.setAccountCompanyFilter(sql);
        this.setAccountDataPermFilter(sql, "account.fid");
        Set asstAccountIdSet = this.getCond().getAsstAccountIdSet();
        if (!asstAccountIdSet.isEmpty()) {
            StringBuffer caaFilter = new StringBuffer();
            String asstAccIdStr = GLRptDaoUtil.set2String(asstAccountIdSet);
            caaFilter.append("( \n");
            caaFilter.append("account.FCAA in " + asstAccIdStr + " or \n");
            caaFilter.append("account.FID in (select FAccountID From T_BD_AsstAccountChange aac where aac.FBeforeID in " + asstAccIdStr + ") \n");
            caaFilter.append(") \n");
            this.addFilterItem(sql, caaFilter.toString());
        }
        DbUtil.execute((Context)this.getCtx(), (String)sql.toString());
        return tmpTable;
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() != null) {
                if (first) {
                    first = false;
                } else {
                    sql.append(",");
                }
                sql.append(this.getSelectField(field));
                continue;
            }
            if (!this.getCond().isGroupVoucherByAccount() || !field.getName().equalsIgnoreCase("FDescription")) continue;
            sql.append(", substring(min( toChar (entries.FSEQ) || entries.FDESCRIPTION),len(min( toChar(entries.FSEQ) ))+1,len(min( toChar(entries.FSEQ) || entries.FDESCRIPTION)) -1) as fdesc");
        }
        return sql.toString();
    }

    private String getNotZeroAmountFilter() {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null || !this.isAmount(field.getName())) continue;
            if (sql.length() > 0) {
                sql.append(" or ");
            }
            sql.append("v.").append(field.getName()).append(" <> 0");
        }
        return sql.toString();
    }

    @Override
    protected String getSelectField(GLRptField field) {
        if (!(this.getCond() == null || field != GLRptVoucherField.accountID || this.getCond().isLeafAccount() && this.getCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.details)) {
            return "av.FParentID " + field.getName();
        }
        if (this.getCond() != null && this.getCond().isGroupVoucher() && this.isAmount(field.getName())) {
            return "sum(" + field.getSelect() + ") " + field.getName();
        }
        return super.getSelectField(field);
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        String fr = super.getJoinSQL();
        GLRptSubLedgerCondition cond = this.getCond();
        if (cond == null) {
            return fr;
        }
        StringBuffer joinSql = new StringBuffer();
        if (!cond.isLeafAccount() || cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            fr = fr.replace("CAA", "CAA1");
        }
        joinSql.append(fr);
        if (this.accountTmpTable != null) {
            joinSql.append(" inner join ").append(this.accountTmpTable).append(" av on av.FID = entries.FAccountID ");
        }
        return joinSql.toString();
    }

    @Override
    public boolean isUseHint() {
        GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
        String hint = null;
        if (threadCondition != null) {
            hint = threadCondition.getExtendParam("VoucherQuery_Hint");
        }
        if (hint != null && hint.trim().length() > 0) {
            return true;
        }
        if (this.accountTmpTable != null) {
            return false;
        }
        return super.isUseHint();
    }

    @Override
    protected String getHint() {
        String hint = null;
        GLRptBaseCondition threadCondition = GLTempTableUtil.getCondition();
        if (threadCondition != null) {
            hint = threadCondition.getExtendParam("VoucherQuery_Hint");
        }
        if (hint != null && hint.trim().length() > 0) {
            return SQLUtil.buildHint(hint);
        }
        return super.getHint();
    }

    @Override
    protected String getGroupSQL() {
        GLRptSubLedgerCondition cond = this.getCond();
        if (cond == null || !cond.isGroupVoucher()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null) continue;
            if (!(field != GLRptVoucherField.accountID || cond.isLeafAccount() && cond.getCompanyDisplayMode() != CompanyDisplayModeEnum.details)) {
                sql.append("av.FParentID").append(",");
                continue;
            }
            if (this.isAmount(field.getName()) || "FBalSeq".equalsIgnoreCase(field.getName()) || cond.isGroupVoucherByAccount() && field.getName().equalsIgnoreCase("FDescription")) continue;
            if (field.isMultiLang()) {
                sql.append(field.getSelect()).append("_").append(this.getCtx().getLocale()).append(",");
                continue;
            }
            sql.append(field.getSelect()).append(",");
        }
        return sql.substring(0, sql.length() - 1).toString();
    }

    @Override
    protected String composeSQL(String selectSql, String fromSql, String whereSql, String groupSql, String orderSql) throws BOSException, EASBizException {
        GLRptSubLedgerCondition cond = this.getCond();
        String sql = super.composeSQL(selectSql, fromSql, whereSql, groupSql, (String)(cond != null && cond.isGroupVoucher() ? null : orderSql));
        if (cond != null && cond.isGroupVoucher()) {
            StringBuffer s = new StringBuffer();
            s.append(" select v.* from (").append(sql).append(") v ");
            s.append(" left outer join t_gl_voucher voucher on v.voucherId = voucher.fid");
            s.append(" left outer join t_bd_vouchertypes voucherType on voucherType.fid = voucher.fvouchertypeid ");
            s.append(" left outer join t_bd_accountview account on account.fid = v.FAccountID");
            if (cond.isAllCurrency()) {
                s.append(" left outer join t_bd_currency currency on currency.fid = v.FCurrencyID ");
            }
            if (cond.isGroupVoucherZeroNotShow()) {
                s.append(" WHERE ").append(this.getNotZeroAmountFilter());
            }
            orderSql = this.getOrder().getOrderSQL();
            orderSql = orderSql + ",account.FNumber";
            if (!cond.isGroupVoucherByAccount()) {
                orderSql = orderSql + ",v.FDescription";
            }
            if (cond.isAllCurrency()) {
                orderSql = orderSql + ",currency.FNumber";
            }
            s.append(" ").append(orderSql);
            sql = s.toString();
        }
        return sql;
    }

    private boolean isAmount(String field) {
        return field.trim().toUpperCase().matches(".*(DEBIT|CREDIT)(FOR|LOCAL|RPT|QTY)");
    }

    @Override
    protected void setAsstactFilter(StringBuffer filter) throws BOSException, EASBizException {
        if (this.getCond() == null || !this.getCond().isShowDisplayAsstDetail()) {
            return;
        }
        super.setAsstactFilter(filter);
    }

    @Override
    protected boolean setAsstDataPermissionFilter(StringBuffer filter) throws EASBizException, BOSException {
        GLRptSubLedgerCondition cond = this.getCond();
        if (cond == null || !cond.getRptParams().useAccountPermission() || !cond.isShowDisplayAsstDetail()) {
            return false;
        }
        AsstAccountCollection asstAccountColl = this.getAsstAccountCollection();
        StringBuffer sql = new StringBuffer();
        boolean existPermSql = false;
        for (int m = 0; m < asstAccountColl.size(); ++m) {
            AsstAccountInfo caa = asstAccountColl.get(m);
            if (m > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            StringBuffer assgrpSql = new StringBuffer();
            this.addFilterItem(assgrpSql, "assGrp.FAsstAccountID = '" + caa.getId().toString() + "'");
            sql.append(assgrpSql);
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            for (int n = 0; n < detailColl.size(); ++n) {
                AsstActTypeInfo at = detailColl.get(n).getAsstActType();
                if (at.getPermissionItem() == null) continue;
                try {
                    String permSql;
                    String strPermItem = at.getPermissionItem();
                    boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(this.getCtx(), strPermItem);
                    String companyId = cond.getCompany().getId().toString();
                    if (isPermissionByCU) {
                        companyId = cond.getCompany().getCU().getId().toString();
                    }
                    if ((permSql = GLRptDaoUtil.getDataPermissionSQL(this.getCtx(), companyId, at.getPermissionItem())) == null) continue;
                    this.addFilterItem(sql, "assGrp." + at.getMappingFieldName() + " in (" + permSql + ")");
                    existPermSql = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Get permission sql error!", (Throwable)e);
                }
            }
            sql.append(")");
        }
        if (existPermSql) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append("(").append(sql).append(" OR ").append("assGrp").append(".FAsstAccountID is null").append(")");
        }
        return existPermSql;
    }

    private AsstAccountCollection getAsstAccountCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
        FilterInfo filter = new FilterInfo();
        StringBuffer accountIdSql = new StringBuffer();
        accountIdSql.append(" select lav.fid from t_bd_accountview lav ");
        accountIdSql.append(" inner join t_bd_accountview av ");
        accountIdSql.append(" on lav.faccounttableid = av.faccounttableid ");
        if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
            accountIdSql.append(" and (lav.flongnumber like concat(av.flongnumber, '!%') or av.fnumber = lav.fnumber) ");
        } else {
            accountIdSql.append(" and (charindex(av.flongnumber||'!', lav.flongnumber) = 1 or av.fnumber = lav.fnumber) ");
        }
        this.getJoinOrgUnitSql(accountIdSql);
        accountIdSql.append(" where av.fid in (").append(this.getCond().getAccountIdFilter()).append(")");
        accountIdSql.append(this.getAccountFilterSQL());
        accountIdSql.append(" and lav.fcaa is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
        AsstAccountCollection asstAccountColl = new AsstAccountCollection();
        for (int i = 0; i < accountColl.size(); ++i) {
            AsstAccountInfo caa = accountColl.get(i).getCAA();
            if (asstAccountColl.contains((Object)caa.getId())) continue;
            asstAccountColl.add(caa);
        }
        return asstAccountColl;
    }

    protected void getJoinOrgUnitSql(StringBuffer sql) {
        GLRptSubLedgerCondition cond = this.getCond();
        if (cond.getProfitCenter() != null && !cond.getProfitCenter().isIsBizUnit() || !cond.getCompany().isIsBizUnit()) {
            sql.append(" and lav.fisLeaf = 1 ");
            if (cond.isShowLeafAccount()) {
                sql.append(" and av.fisLeaf = 1 ");
            } else {
                sql.append(" and av.flevel <= ").append(cond.getAccountLevelEnd());
            }
        } else {
            sql.append(" and av.fcompanyid = lav.fcompanyid ");
        }
    }

    protected String getAccountFilterSQL() throws BOSException {
        GLRptSubLedgerCondition cond = this.getCond();
        StringBuilder sql = new StringBuilder();
        if (cond.getCtx().get((Object)"isPca") == null) {
            sql.append(" and lav.fcompanyid in ").append(cond.getCompanyIdsStr());
        }
        if (cond.getCtx().get((Object)"isPca") == null) {
            sql.append(" and lav.fisProfitCenter <>  '1' ");
        }
        return sql.toString();
    }

    @Override
    public GLRptSubLedgerCondition getCond() {
        return (GLRptSubLedgerCondition)super.getCond();
    }
}

