/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptTableJoin {
    List joinTables = new ArrayList();

    public void add(GLRptDataTable table, String field, boolean innerJoin) {
        this.joinTables.add(new JoinItem(table, field, innerJoin));
    }

    public void add(GLRptDataTable table, String joinField, String field, boolean innerJoin) {
        this.joinTables.add(new JoinItem(table, joinField, field, innerJoin));
    }

    public void add(GLRptDataTable table, String field) {
        this.joinTables.add(new JoinItem(table, field));
    }

    public boolean contains(GLRptDataTable table) {
        Iterator it = this.joinTables.iterator();
        while (it.hasNext()) {
            GLRptDataTable t = ((JoinItem)it.next()).getTable();
            if (!table.getTableName().equalsIgnoreCase(t.getTableName()) || !table.getAlias().equalsIgnoreCase(t.getAlias())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.joinTables.isEmpty();
    }

    public String getSQL() {
        StringBuffer sql = new StringBuffer();
        for (JoinItem join : this.joinTables) {
            sql.append(join.getJoinSql());
        }
        return sql.toString();
    }

    public class JoinItem {
        private GLRptDataTable table;
        private boolean innerJoin = false;
        private String joinField;
        private String field;

        public JoinItem(GLRptDataTable table, String joinField, String field, boolean innerJoin) {
            this.table = table;
            this.field = field;
            this.joinField = joinField;
            this.innerJoin = innerJoin;
        }

        public JoinItem(GLRptDataTable table, String field, boolean innerJoin) {
            this.table = table;
            this.field = field;
            this.innerJoin = innerJoin;
        }

        public JoinItem(GLRptDataTable table, String field) {
            this(table, field, false);
        }

        public GLRptDataTable getTable() {
            return this.table;
        }

        public String getField() {
            return this.field;
        }

        public String getJoinSql() {
            return new StringBuffer().append(this.innerJoin ? " inner join " : " left outer join ").append(this.table.getTableName()).append(" ").append(this.table.getAlias()).append(" on ").append(this.table.getAlias()).append(".").append(this.joinField == null ? "FID" : this.joinField).append(" = ").append(this.field).toString();
        }
    }
}

