/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptTempTableStruct {
    private List<GLRptTempTableField> fieldList = new ArrayList<GLRptTempTableField>();

    public void addField(String fieldName, String fielType) {
        this.addField(fieldName, fielType, null);
    }

    public void addField(GLRptField field) {
        this.addField(field.getName(), field.getType());
    }

    public void addField(GLRptField field, String defaultValue) {
        this.addField(field.getName(), field.getType(), defaultValue);
    }

    public void addField(String fieldName, String fielType, String defaultValue) {
        this.fieldList.add(new GLRptTempTableField(fieldName, fielType, defaultValue));
    }

    public GLRptField[] getFields() {
        GLRptField[] fields = new GLRptField[this.fieldList.size()];
        for (int i = 0; i < fields.length; ++i) {
            GLRptTempTableField f = this.fieldList.get(i);
            fields[i] = new GLRptField(f.getFieldName(), f.getFieldType());
        }
        return fields;
    }

    public String[] getFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (GLRptTempTableField field : this.fieldList) {
            names.add(field.getFieldName());
        }
        String[] items = new String[names.size()];
        return names.toArray(items);
    }

    public String getDataTableDesc() {
        StringBuffer desc = new StringBuffer();
        Iterator<GLRptTempTableField> it = this.fieldList.iterator();
        GLRptTempTableField field = it.next();
        desc.append(field.getFieldName()).append(" ").append(field.getFieldType());
        if (field.getDefaultValue() != null) {
            desc.append(" default ").append(field.getDefaultValue());
        }
        while (it.hasNext()) {
            desc.append(",");
            field = it.next();
            desc.append(field.getFieldName()).append(" ").append(field.getFieldType());
            if (field.getDefaultValue() == null) continue;
            desc.append(" default ").append(field.getDefaultValue());
        }
        return desc.toString();
    }

    private class GLRptTempTableField {
        private String fieldName;
        private String fieldType;
        private String defaultValue;

        private GLRptTempTableField(String fieldName, String fieldType, String defaultValue) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.defaultValue = defaultValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

