/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxCollection;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.TOTAL;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherDetailPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class GLRptVoucherDetailDao
extends AbstractGLRptDao {
    protected static final String voucher = "\"VOUCHER\"";
    protected static final String entry = "\"ENTRIES\"";
    protected static final String asstRecord = "\"ASSISTRECORDS\"";
    protected static final String voucherType = "\"VOUCHERTYPE\"";
    private Map exRateMap = new HashMap();
    private GLRptRowSet preRowSet;
    private Context ctx;
    protected boolean isQtyAsst;
    protected boolean showAssist;
    private boolean isSkipPageQuery = false;

    public GLRptVoucherDetailDao(Context ctx, boolean isAssist) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        HashMap hmParam = this.getHmParam(this.ctx);
        this.isQtyAsst = Boolean.parseBoolean(hmParam.get("G010") == null ? "false" : hmParam.get("G010").toString());
        GLRptBaseCondition cond = this.getQueryCondition();
        this.showAssist = cond instanceof GLRptAsstactGDCondition || cond instanceof GLRptSubLedgerCondition && ((GLRptSubLedgerCondition)cond).isShowDisplayAsstDetail();
    }

    private HashMap getHmParam(Context ctx) {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        HashMap hmAllParam = new HashMap();
        try {
            HashMap<String, BOSUuid> hmParamIn = new HashMap<String, BOSUuid>();
            hmParamIn.put("G010", company.getId());
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            hmAllParam = pc.getParamHashMap(hmParamIn);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return hmAllParam;
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.localExRate || field == GLRptVoucherField.rptExRate) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setNumeral(true);
            CurrencyInfo currency = this.getQueryCurrencyInfo();
            if (currency != null) {
                boolean isSettleByLocal;
                boolean bl = this.getCompany().getReportConvertMode() == null ? true : (isSettleByLocal = 3 == this.getCompany().getReportConvertMode().getValue());
                if (isSettleByLocal && field == GLRptVoucherField.rptExRate) {
                    colInfo.setScale(this.getEx(this.getCompany().getBaseCurrency(), this.getCompany().getReportCurrency()));
                } else {
                    colInfo.setScale(this.getEx(currency, field == GLRptVoucherField.localExRate ? this.getCompany().getBaseCurrency() : this.getCompany().getReportCurrency()));
                }
            }
            colInfo.setColName(field.getName());
            colInfo.setWidth(field.getLength());
            if (colInfo != null && this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    public CompanyOrgUnitInfo getCompanyInfoById(String id) {
        CompanyOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            try {
                info = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
            catch (Exception e) {
                return null;
            }
        }
        return info;
    }

    private int getEx(CurrencyInfo sourceCurrency, CurrencyInfo targetCurrency) throws BOSException {
        Object betid = null;
        if (sourceCurrency == null || targetCurrency == null || this.getCompany().getBaseExchangeTable() == null) {
            CompanyOrgUnitInfo tc;
            if (sourceCurrency != null && targetCurrency != null && this.getCompany() != null && this.getCompany().getBaseExchangeTable() == null && this.getCompany().isIsBizUnit() && (tc = this.getCompanyInfoById(this.getCompany().getId().toString())) != null && tc.getBaseExchangeTable() != null && tc.getBaseExchangeTable().getId() != null) {
                betid = tc.getBaseExchangeTable().getId().toString();
            }
            if (betid == null) {
                return 3;
            }
        }
        if (sourceCurrency.getId().equals((Object)targetCurrency.getId())) {
            return targetCurrency.getPrecision();
        }
        String key = (betid != null ? betid : this.getCompany().getBaseExchangeTable().getId()) + "||" + sourceCurrency.getId() + "||" + targetCurrency.getId();
        Object pre = this.exRateMap.get(key);
        if (pre != null) {
            return (Integer)pre;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("precision"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeTable.id", betid != null ? betid : this.getCompany().getBaseExchangeTable().getId().toString()));
        fic.add(new FilterItemInfo("sourceCurrency.id", (Object)sourceCurrency.getId().toString()));
        fic.add(new FilterItemInfo("targetCurrency.id", (Object)targetCurrency.getId().toString()));
        ExchangeAuxCollection exAuxCol = ExchangeAuxFactory.getLocalInstance((Context)this.getContex()).getExchangeAuxCollection(view);
        Iterator itrEx = exAuxCol.iterator();
        int precision = 2;
        if (itrEx.hasNext()) {
            ExchangeAuxInfo aux = (ExchangeAuxInfo)itrEx.next();
            precision = aux.getPrecision();
        }
        this.exRateMap.put(key, new Integer(precision));
        return precision;
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        this.setExRatePre(rowSet);
        this.calLastPeriodBalance(rowSet);
        this.setBalanceDC(rowSet);
        this.setDescription(rowSet);
        this.setPrice(rowSet, this.isShowFor() ? "For" : (this.isShowLocal() ? "Local" : "Rpt"));
    }

    private void setPrice(GLRptRowSet rs, String sufifx) throws BOSException, EASBizException {
        if (!this.isShowQty()) {
            return;
        }
        GLRptBaseCondition cond = this.getQueryCondition();
        int balType = rs.getInt("FBalSeq");
        if (balType != 2 || rs.getString("voucherID") == null || this.isGeneralLocalCurrency() || this.isGeneralReportCurrency() || !this.isQtyAsst && this.showAssist) {
            BigDecimal debitBal = rs.getBigDecimal("FSubDebit" + sufifx);
            BigDecimal debitQty = rs.getBigDecimal("FSubDebitQty");
            if (debitBal != null && debitQty != null && debitQty.doubleValue() != 0.0 && rs.indexOf("FDebitPrice") != -1) {
                rs.updateBigDecimal("FDebitPrice", debitBal.divide(debitQty, cond.getPriceScale(), 4).abs());
            }
            BigDecimal creditBal = rs.getBigDecimal("FSubCredit" + sufifx);
            BigDecimal creditQty = rs.getBigDecimal("FSubCreditQty");
            if (creditBal != null && creditQty != null && creditQty.doubleValue() != 0.0 && rs.indexOf("FCreditPrice") != -1) {
                rs.updateBigDecimal("FCreditPrice", creditBal.divide(creditQty, cond.getPriceScale(), 4).abs());
            }
        }
        BigDecimal endBal = rs.getBigDecimal("FEndBalance" + sufifx);
        BigDecimal endQty = rs.getBigDecimal("FEndQty");
        if (balType == 1) {
            String accountId = rs.getString(GLRptField.accountID.getName());
            endQty = endQty.divide(this.getAsstQtyCoefficient(rs), 10, 4).divide(this.getAccountQtyCoefficient(accountId), 10, 4);
        }
        if (endBal != null && endQty != null && endQty.doubleValue() != 0.0 && rs.indexOf("FEndPrice") != -1) {
            rs.updateBigDecimal("FEndPrice", endBal.divide(endQty, cond.getPriceScale(), 4).abs());
        }
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (GLRptVoucherField.accountDC.getName().equalsIgnoreCase(colName) && value != null) {
            boolean sameDC = this.getQueryCondition().getRptParams().isBalanceDirSamAsAccount();
            int dc = Integer.parseInt(value.toString());
            rowData.updateObject(colName, sameDC ? BalanceDirectionEnum.getEnum((int)dc) : null);
        } else if (value != null && GLRptField.period.getName().equalsIgnoreCase(colName)) {
            int period = Integer.parseInt(value.toString());
            rowData.updateObject(colName, period / 100 + "." + period % 100);
        }
    }

    private void setExRatePre(GLRptRowSet rowSet) throws BOSException, EASBizException {
        if (!this.isShowFor() || !this.isAllCurrency()) {
            return;
        }
        String currencyId = rowSet.getString(GLRptVoucherField.currencyID.getName());
        if (currencyId == null) {
            return;
        }
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        if (this.isShowLocal() && rowSet.indexOf(GLRptVoucherField.localExRatePre.getName()) != -1) {
            rowSet.updateInt(GLRptVoucherField.localExRatePre.getName(), this.getEx(currency, this.getCompany().getBaseCurrency()));
        }
        if (this.isShowRpt() && rowSet.indexOf(GLRptVoucherField.rptExRatePre.getName()) != -1) {
            boolean isSettleByLocal;
            boolean bl = this.getCompany().getReportConvertMode() == null ? true : (isSettleByLocal = 3 == this.getCompany().getReportConvertMode().getValue());
            if (isSettleByLocal) {
                rowSet.updateInt(GLRptVoucherField.rptExRatePre.getName(), this.getEx(this.getCompany().getBaseCurrency(), this.getCompany().getReportCurrency()));
            } else {
                rowSet.updateInt(GLRptVoucherField.rptExRatePre.getName(), this.getEx(currency, this.getCompany().getReportCurrency()));
            }
        }
    }

    private void calLastPeriodBalance(GLRptRowSet rs) throws BOSException, EASBizException {
        int seq = rs.getInt("FBalSeq");
        if (seq == 2 || seq == 3 || seq == 4 || seq == 5) {
            GLRptRowSet preRowSet = this.getPreRowSet();
            if (preRowSet == null || !preRowSet.next() || rs.getRowIndex() != preRowSet.getRowIndex() + 1) {
                if (preRowSet != null) {
                    this.isSkipPageQuery = true;
                }
                preRowSet = this.getPreRowData(rs);
            }
            this.fillRowData(rs, preRowSet);
        }
    }

    protected boolean isBalanceDirSamAsAccount(GLRptRowSet rs) throws EASBizException, BOSException {
        String dc = GLRptVoucherField.accountDC.getName();
        return this.getQueryCondition().getRptParams().isBalanceDirSamAsAccount() && rs.getObject(dc) instanceof BalanceDirectionEnum;
    }

    private void setBalanceDC(GLRptRowSet rs) throws BOSException, EASBizException {
        BigDecimal amount = this.getDCAmount(rs);
        String dc = GLRptVoucherField.accountDC.getName();
        if (amount == null || amount.doubleValue() == 0.0) {
            rs.updateObject(dc, GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "dir_equal", this.ctx));
        } else if (this.isBalanceDirSamAsAccount(rs)) {
            if (rs.getObject(dc) == BalanceDirectionEnum.CREDIT) {
                this.negateBalance(rs);
            }
        } else if (amount.doubleValue() < 0.0) {
            this.negateBalance(rs);
            rs.updateObject(dc, BalanceDirectionEnum.CREDIT);
        } else {
            rs.updateObject(dc, BalanceDirectionEnum.DEBIT);
        }
    }

    private void setDescription(GLRptRowSet rowData) throws BOSException {
        String desc = GLRptVoucherField.asstRecordDesc.getName();
        int balSq = rowData.getInt("FBalSeq");
        String YEAR_BEGIN = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "balance_year_begin", this.ctx);
        String PERIOD_BEGIN = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "balance_period_begin", this.ctx);
        String DAY_TOTAL = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "dailyTotal", this.ctx);
        String PERIOD_TOTAL = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "period_total", this.ctx);
        String YEAR_TOTAL = GLResUtil.getRes("com.kingdee.eas.fi.gl.GLXResource", "sum_year", this.ctx);
        if (balSq == 1) {
            String period = rowData.getString(GLRptField.period.getName());
            if (period != null) {
                rowData.updateObject(desc, period.endsWith(".1") ? YEAR_BEGIN : PERIOD_BEGIN);
            }
        } else if (balSq == 4) {
            rowData.updateObject(desc, PERIOD_TOTAL);
        } else if (balSq == 5) {
            rowData.updateObject(desc, YEAR_TOTAL);
        } else if (balSq == 3) {
            rowData.updateObject(desc, DAY_TOTAL);
        } else if (rowData.getInt("isTotal") == 1) {
            rowData.updateObject(desc, TOTAL.getTotal(this.getContex()));
        } else if (this.isAllCurrency() && rowData.getInt("currencyIsTotal") == 1) {
            rowData.updateObject(desc, TOTAL.getSubTotal(this.getContex()));
        }
    }

    protected GLRptRowSet getPreRowData(GLRptRowSet rs) throws EASBizException, BOSException {
        GLRptVoucherDetailPageQuery query = (GLRptVoucherDetailPageQuery)this.getGLRptDataQuery();
        query.setSelector(this.getGLRptSelector());
        query.setDataSourceTable(this.getDataSourceTable());
        Object periodObj = rs.getObject(GLRptVoucherField.period.getName());
        if (periodObj != null) {
            rs.updateString(GLRptVoucherField.HGID.getName(), null);
            query.setCurrRow(rs);
        }
        IRowSet rowSet = this.executeQuery(query.getSQL(), query.getSQLParams().toArray());
        String[] cols_new = this.getPreRowSetCols();
        GLRptRowSet preRs = new GLRptRowSet(cols_new, 1);
        try {
            if (rowSet.next()) {
                preRs.insertRow();
                ResultSetMetaData md = rowSet.getMetaData();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String colName = md.getColumnName(i);
                    preRs.updateObject(colName, rowSet.getObject(i));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return preRs;
    }

    protected String[] getPreRowSetCols() throws EASBizException, BOSException {
        return this.getTableHeadInfo().getColNames();
    }

    private void fillRowData(GLRptRowSet rs, GLRptRowSet preRowSet) throws BOSException, EASBizException {
        if (this.isShowQty()) {
            this.doRowSet(rs, preRowSet, "Qty", "Qty");
        }
        if (this.isShowFor()) {
            this.doRowSet(rs, preRowSet, "BalanceFor", "For");
        }
        if (this.isShowLocal()) {
            this.doRowSet(rs, preRowSet, "BalanceLocal", "Local");
        }
        if (this.isShowRpt()) {
            this.doRowSet(rs, preRowSet, "BalanceRpt", "Rpt");
        }
    }

    protected void doRowSet(GLRptRowSet rs, GLRptRowSet preRs, String endSuf, String sufifx) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getQueryCondition();
        BigDecimal debit = GlUtils.zero;
        BigDecimal credit = GlUtils.zero;
        if (rs.getInt("FBalSeq") != 3) {
            debit = this.getDebit(rs, sufifx);
            credit = this.getCredit(rs, sufifx);
        }
        if ("Qty".equals(endSuf)) {
            String accountId = rs.getString(GLRptField.accountID.getName());
            if (debit != null) {
                debit = debit.divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4);
            }
            if (credit != null) {
                credit = credit.divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4);
            }
            if (preRs.getInt("FBalSeq") == 1 || this.isSkipPageQuery) {
                preRs.updateBigDecimal("FEnd" + endSuf, preRs.getBigDecimal("FEnd" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                if (this.isSkipPageQuery) {
                    preRs.updateBigDecimal("FDebit" + endSuf, preRs.getBigDecimal("FDebit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                    preRs.updateBigDecimal("FCredit" + endSuf, preRs.getBigDecimal("FCredit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                }
                preRs.updateBigDecimal("FYearDebit" + endSuf, preRs.getBigDecimal("FYearDebit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                preRs.updateBigDecimal("FYearCredit" + endSuf, preRs.getBigDecimal("FYearCredit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                if (this.isSkipPageQuery && cond instanceof GLRptAsstactGDCondition && ((GLRptAsstactGDCondition)cond).isShowDailyTotal()) {
                    preRs.updateBigDecimal("FDayDebit" + endSuf, preRs.getBigDecimal("FDayDebit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                    preRs.updateBigDecimal("FDayCredit" + endSuf, preRs.getBigDecimal("FDayCredit" + endSuf).divide(this.getAsstQtyCoefficient(rs), cond.getQtyScale(), 4).divide(this.getAccountQtyCoefficient(accountId), cond.getQtyScale(), 4));
                }
                this.isSkipPageQuery = false;
            }
        }
        this.setBalance(rs, preRs, endSuf, debit, credit);
        this.setPeriodTotal(rs, preRs, sufifx, debit, credit);
        this.setYearTotal(rs, preRs, sufifx, debit, credit);
    }

    protected BigDecimal getDebit(GLRptRowSet rs, String sufifx) throws BOSException {
        return rs.getBigDecimal("FSubDebit" + sufifx);
    }

    protected BigDecimal getCredit(GLRptRowSet rs, String sufifx) throws BOSException {
        return rs.getBigDecimal("FSubCredit" + sufifx);
    }

    private void setPeriodTotal(GLRptRowSet rs, GLRptRowSet preRs, String sufifx, BigDecimal debit, BigDecimal credit) throws BOSException, EASBizException {
        int rowType = rs.getInt("FBalSeq");
        BigDecimal lastDebit = preRs.getBigDecimal("FDebit" + sufifx);
        BigDecimal lastCredit = preRs.getBigDecimal("FCredit" + sufifx);
        if (4 == rowType) {
            rs.updateBigDecimal("FSubDebit" + sufifx, lastDebit);
            rs.updateBigDecimal("FSubCredit" + sufifx, lastCredit);
            rs.updateBigDecimal("FDebit" + sufifx, null);
            rs.updateBigDecimal("FCredit" + sufifx, null);
        } else {
            rs.updateBigDecimal("FDebit" + sufifx, this.add(lastDebit, debit));
            rs.updateBigDecimal("FCredit" + sufifx, this.add(lastCredit, credit));
        }
    }

    private void setYearTotal(GLRptRowSet rs, GLRptRowSet preRs, String sufifx, BigDecimal debit, BigDecimal credit) throws BOSException, EASBizException {
        int rowType = rs.getInt("FBalSeq");
        BigDecimal lastYearDebit = GlUtils.zero;
        BigDecimal lastYearCredit = GlUtils.zero;
        Object period = rs.getObject(GLRptVoucherField.period.getName());
        Object prePeriod = preRs.getObject(GLRptVoucherField.period.getName());
        if (period == null || prePeriod == null || prePeriod != null && period.toString().substring(0, 4).equals(prePeriod.toString().substring(0, 4))) {
            lastYearDebit = preRs.getBigDecimal("FYearDebit" + sufifx);
            lastYearCredit = preRs.getBigDecimal("FYearCredit" + sufifx);
        }
        rs.updateBigDecimal("FYearDebit" + sufifx, this.add(lastYearDebit, debit));
        rs.updateBigDecimal("FYearCredit" + sufifx, this.add(lastYearCredit, credit));
        if (5 == rowType) {
            rs.updateBigDecimal("FSubDebit" + sufifx, rs.getBigDecimal("FYearDebit" + sufifx));
            rs.updateBigDecimal("FSubCredit" + sufifx, rs.getBigDecimal("FYearCredit" + sufifx));
            rs.updateBigDecimal("FDebit" + sufifx, null);
            rs.updateBigDecimal("FCredit" + sufifx, null);
        }
    }

    private void setBalance(GLRptRowSet rs, GLRptRowSet preRs, String endSuf, BigDecimal debit, BigDecimal credit) throws BOSException {
        BigDecimal lastEnd = preRs.getBigDecimal("FEnd" + endSuf);
        Object lastDc = preRs.getObject(GLRptVoucherField.accountDC.getName());
        if (lastDc == BalanceDirectionEnum.CREDIT && lastEnd != null) {
            lastEnd = lastEnd.negate();
        }
        rs.updateBigDecimal("FEnd" + endSuf, this.subtract(this.add(lastEnd, debit), credit));
    }

    private BigDecimal getDCAmount(GLRptRowSet rs) throws BOSException, EASBizException {
        BigDecimal amount = null;
        if (this.isShowFor()) {
            amount = rs.getBigDecimal(GLRptVoucherField.endBalanceFor.getName());
        }
        if (this.isShowLocal() && (amount == null || amount.doubleValue() == 0.0)) {
            amount = rs.getBigDecimal(GLRptVoucherField.endBalanceLocal.getName());
        }
        if (this.isShowRpt() && (amount == null || amount.doubleValue() == 0.0)) {
            amount = rs.getBigDecimal(GLRptVoucherField.endBalanceRpt.getName());
        }
        if (this.isShowQty() && (amount == null || amount.doubleValue() == 0.0)) {
            amount = rs.getBigDecimal(GLRptVoucherField.endQty.getName());
        }
        return amount;
    }

    private void negateBalance(GLRptRowSet rs) throws BOSException, EASBizException {
        if (this.isShowQty()) {
            this.negateBalance(rs, "Qty", "Qty");
        }
        if (this.isShowFor()) {
            this.negateBalance(rs, "BalanceFor", "For");
        }
        if (this.isShowLocal()) {
            this.negateBalance(rs, "BalanceLocal", "Local");
        }
        if (this.isShowRpt()) {
            this.negateBalance(rs, "BalanceRpt", "Rpt");
        }
    }

    protected void negateBalance(GLRptRowSet rs, String endSuf, String sufifx) throws BOSException {
        BigDecimal endBal = rs.getBigDecimal("FEnd" + endSuf);
        if (endBal != null) {
            rs.updateBigDecimal("FEnd" + endSuf, endBal.negate());
        }
    }

    protected BigDecimal add(BigDecimal amount1, BigDecimal amount2) {
        if (amount1 == null) {
            return amount2 == null ? GlUtils.zero : amount2;
        }
        return amount2 == null ? amount1 : amount1.add(amount2);
    }

    protected BigDecimal subtract(BigDecimal amount1, BigDecimal amount2) {
        if (amount1 == null) {
            return amount2 == null ? GlUtils.zero : amount2.negate();
        }
        return amount2 == null ? amount1 : amount1.subtract(amount2);
    }

    @Override
    protected void doDetailRowSet(GLRptRowSet rowSet) throws EASBizException, BOSException {
        this.preRowSet = rowSet.getRow(rowSet.getCurrRowIndex());
    }

    protected GLRptRowSet getPreRowSet() throws EASBizException, BOSException {
        return this.preRowSet;
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.accountDC) {
            colTitles.add("direction");
        } else if (field.getType() == "NUMERIC(27,10)") {
            colTitles.add("price");
        } else {
            super.setRow2Title(colTitles, field);
        }
    }

    protected BigDecimal getAsstQtyCoefficient(GLRptRowSet rs) throws BOSException, EASBizException {
        return GlUtils.one;
    }

    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        return GlUtils.one;
    }
}

