/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerSplitEntryInfo;
import java.math.BigDecimal;

public class GLRptVoucherEntryInfo {
    private static final int DEBIT = 1;
    private String voucherId;
    private String entryId;
    private String assitRecordId;
    private String accountId;
    private String hgId;
    private String currencyId;
    private int period;
    private int entriesSeq;
    private int asstRecSeq;
    private BigDecimal localExRate;
    private BigDecimal rptExRate;
    private BigDecimal originalAmount;
    private BigDecimal localAmount;
    private BigDecimal reportingAmount;
    private BigDecimal quantity;
    private BigDecimal standardQuantity;
    private int entryDC = 0;
    private int currencyScale = 0;
    private int rptCurrencyScale = 0;
    private int qtyScale = 0;
    private boolean isBaseLocalExRate = false;
    private int entriesSeqReal;
    private String entryDesc;
    private String assistDesc;

    public int getEntriesSeqReal() {
        return this.entriesSeqReal;
    }

    public void setEntriesSeqReal(int entriesSeqReal) {
        this.entriesSeqReal = entriesSeqReal;
    }

    public GLRptVoucherEntryInfo(boolean isBaseLocalExRate) {
        this.isBaseLocalExRate = isBaseLocalExRate;
    }

    public String getVoucherId() {
        return this.voucherId;
    }

    public void setVoucherId(String voucherId) {
        this.voucherId = voucherId;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public String getAssitRecordId() {
        return this.assitRecordId;
    }

    public void setAssitRecordId(String assitRecordId) {
        this.assitRecordId = assitRecordId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getHgId() {
        return this.hgId;
    }

    public void setHgId(String hgId) {
        this.hgId = hgId;
    }

    public BigDecimal getLocalExRate() {
        return this.localExRate;
    }

    public void setLocalExRate(BigDecimal localExRate) {
        this.localExRate = localExRate;
    }

    public BigDecimal getRptExRate() {
        return this.rptExRate;
    }

    public void setRptExRate(BigDecimal rptExRate) {
        this.rptExRate = rptExRate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public int getCurrencyScale() {
        return this.getRptCurrencyScale();
    }

    public void setCurrencyScale(int currencyScale) {
        this.currencyScale = currencyScale;
    }

    public int getRptCurrencyScale() {
        return this.rptCurrencyScale;
    }

    public void setRptCurrencyScale(int rptCurrencyScale) {
        this.rptCurrencyScale = rptCurrencyScale;
    }

    public int getQtyScale() {
        return this.qtyScale;
    }

    public void setQtyScale(int qtyScale) {
        this.qtyScale = qtyScale;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    public BigDecimal getLocalAmount() {
        return this.localAmount;
    }

    public void setLocalAmount(BigDecimal localAmount) {
        this.localAmount = localAmount;
    }

    public BigDecimal getReportingAmount() {
        return this.reportingAmount;
    }

    public void setReportingAmount(BigDecimal reportingAmount) {
        this.reportingAmount = reportingAmount;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getStandardQuantity() {
        return this.standardQuantity;
    }

    public void setStandardQuantity(BigDecimal standardQuantity) {
        this.standardQuantity = standardQuantity;
    }

    public int getEntryDC() {
        return this.entryDC;
    }

    public void setEntryDC(int entryDC) {
        this.entryDC = entryDC;
    }

    public int getEntriesSeq() {
        return this.entriesSeq;
    }

    public void setEntriesSeq(int entriesSeq) {
        this.entriesSeq = entriesSeq;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getAsstRecSeq() {
        return this.asstRecSeq;
    }

    public void setAsstRecSeq(int asstRecSeq) {
        this.asstRecSeq = asstRecSeq;
    }

    public void add(GLRptVoucherEntryInfo entry) {
        this.setLocalAmount(this.getLocalAmount().add(entry.getLocalAmount()));
        this.setOriginalAmount(this.getOriginalAmount().add(entry.getOriginalAmount()));
        this.setReportingAmount(this.getReportingAmount().add(entry.getReportingAmount()));
        this.setQuantity(this.getQuantity().add(entry.getQuantity()));
        this.setStandardQuantity(this.getStandardQuantity().add(entry.getStandardQuantity()));
    }

    public GLRptSubLedgerSplitEntryInfo merge(GLRptVoucherEntryInfo entry) {
        GLRptVoucherEntryInfo subEntry = new GLRptVoucherEntryInfo(this.isBaseLocalExRate);
        subEntry.setQtyScale(this.getQtyScale());
        subEntry.setVoucherId(this.getVoucherId());
        subEntry.setPeriod(this.getPeriod());
        subEntry.setAccountId(this.getAccountId());
        subEntry.setEntryId(this.getEntryId());
        subEntry.setAssitRecordId(this.getAssitRecordId());
        subEntry.setCurrencyId(this.getCurrencyId());
        subEntry.setHgId(this.getHgId());
        subEntry.setLocalExRate(this.getLocalExRate());
        subEntry.setRptExRate(this.getRptExRate());
        subEntry.setEntriesSeq(this.getEntriesSeq());
        subEntry.setEntryDesc(this.getEntryDesc());
        subEntry.setAssistDesc(this.getAssistDesc());
        subEntry.setEntriesSeqReal(this.getEntriesSeqReal());
        subEntry.setAsstRecSeq(this.getAsstRecSeq());
        BigDecimal origAmount = this.getLocalAmount();
        BigDecimal splitRate = entry.getLocalAmount().divide(this.getLocalAmount(), 20, 4);
        this.mergeLocalAmount(entry, subEntry);
        this.mergeQuantity(subEntry, origAmount);
        this.mergeOrigAmount(entry, subEntry, splitRate);
        this.mergeRptAmount(entry, subEntry, splitRate);
        GLRptSubLedgerSplitEntryInfo splitEntry = new GLRptSubLedgerSplitEntryInfo();
        splitEntry.setEntryInfo(subEntry);
        splitEntry.setOppEntryInfo(entry);
        return splitEntry;
    }

    private void mergeLocalAmount(GLRptVoucherEntryInfo entry, GLRptVoucherEntryInfo subEntry) {
        if (this.getEntryDC() == 1) {
            this.setLocalAmount(this.getLocalAmount().add(entry.getEntryDC() == -1 ? entry.getLocalAmount().negate() : entry.getLocalAmount()));
            subEntry.setLocalAmount(entry.getEntryDC() == -1 ? entry.getLocalAmount() : entry.getLocalAmount().negate());
        } else {
            this.setLocalAmount(this.getLocalAmount().add(entry.getEntryDC() == -1 ? entry.getLocalAmount() : entry.getLocalAmount().negate()));
            subEntry.setLocalAmount(entry.getEntryDC() == -1 ? entry.getLocalAmount().negate() : entry.getLocalAmount());
        }
    }

    private void mergeOrigAmount(GLRptVoucherEntryInfo entry, GLRptVoucherEntryInfo subEntry, BigDecimal splitRate) {
        BigDecimal splitForAmount = this.getOriginalAmount().multiply(splitRate).setScale(this.currencyScale, 4);
        if (this.getEntryDC() == 1) {
            this.setOriginalAmount(this.getOriginalAmount().add(entry.getEntryDC() == -1 ? splitForAmount.negate() : splitForAmount));
            subEntry.setOriginalAmount(entry.getEntryDC() == -1 ? splitForAmount : splitForAmount.negate());
        } else {
            this.setOriginalAmount(this.getOriginalAmount().add(entry.getEntryDC() == -1 ? splitForAmount : splitForAmount.negate()));
            subEntry.setOriginalAmount(entry.getEntryDC() == -1 ? splitForAmount.negate() : splitForAmount);
        }
    }

    private void mergeRptAmount(GLRptVoucherEntryInfo entry, GLRptVoucherEntryInfo subEntry, BigDecimal splitRate) {
        BigDecimal splitRptAmount = this.getReportingAmount().multiply(splitRate).setScale(this.rptCurrencyScale, 4);
        if (this.getEntryDC() == 1) {
            this.setReportingAmount(this.getReportingAmount().add(entry.getEntryDC() == -1 ? splitRptAmount.negate() : splitRptAmount));
            subEntry.setReportingAmount(entry.getEntryDC() == -1 ? splitRptAmount : splitRptAmount.negate());
        } else {
            this.setReportingAmount(this.getReportingAmount().add(entry.getEntryDC() == -1 ? splitRptAmount : splitRptAmount.negate()));
            subEntry.setReportingAmount(entry.getEntryDC() == -1 ? splitRptAmount.negate() : splitRptAmount);
        }
    }

    private void mergeQuantity(GLRptVoucherEntryInfo subEntry, BigDecimal origAmount) {
        if (origAmount.doubleValue() != 0.0) {
            BigDecimal origStandQty;
            BigDecimal origQty = this.getQuantity();
            if (origQty != null) {
                BigDecimal origQuantity = this.getQuantity();
                this.setQuantity(origQty.multiply(this.getLocalAmount()).divide(origAmount, this.getQtyScale(), 4));
                subEntry.setQuantity(origQuantity.subtract(this.getQuantity()));
            }
            if ((origStandQty = this.getStandardQuantity()) != null) {
                this.setStandardQuantity(origStandQty.multiply(this.getLocalAmount()).divide(origAmount, this.getQtyScale(), 4));
                subEntry.setStandardQuantity(origStandQty.subtract(this.getStandardQuantity()));
            }
        }
    }

    public boolean isCredit() {
        if (this.getEntryDC() == 1) {
            return this.getLocalAmount().signum() < 0;
        }
        return this.getLocalAmount().signum() > 0;
    }

    public boolean isCreditSubLedgerSpliter() {
        if (this.getEntryDC() == 1) {
            if (this.getLocalAmount().signum() != 0) {
                return this.getLocalAmount().signum() < 0;
            }
            if (this.getReportingAmount().signum() != 0) {
                return this.getReportingAmount().signum() < 0;
            }
            return this.getOriginalAmount().signum() < 0;
        }
        if (this.getLocalAmount().signum() != 0) {
            return this.getLocalAmount().signum() > 0;
        }
        if (this.getReportingAmount().signum() != 0) {
            return this.getReportingAmount().signum() > 0;
        }
        return this.getOriginalAmount().signum() > 0;
    }

    public int compareTo(GLRptVoucherEntryInfo entry) {
        return this.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
    }

    public GLRptVoucherEntryInfo clone() {
        GLRptVoucherEntryInfo entry = new GLRptVoucherEntryInfo(this.isBaseLocalExRate);
        entry.setAccountId(this.getAccountId());
        entry.setAssitRecordId(this.getAssitRecordId());
        entry.setAsstRecSeq(this.getAsstRecSeq());
        entry.setCurrencyId(this.getCurrencyId());
        entry.setCurrencyScale(this.getCurrencyScale());
        entry.setEntriesSeq(this.getEntriesSeq());
        entry.setEntryDC(this.getEntryDC());
        entry.setEntryId(this.getEntryId());
        entry.setHgId(this.getHgId());
        entry.setLocalAmount(this.getLocalAmount());
        entry.setLocalExRate(this.getLocalExRate());
        entry.setOriginalAmount(this.getOriginalAmount());
        entry.setPeriod(this.getPeriod());
        entry.setQtyScale(this.getQtyScale());
        entry.setQuantity(this.getQuantity());
        entry.setReportingAmount(this.getReportingAmount());
        entry.setRptCurrencyScale(this.getRptCurrencyScale());
        entry.setRptExRate(this.getRptExRate());
        entry.setStandardQuantity(this.getStandardQuantity());
        entry.setVoucherId(this.getVoucherId());
        entry.setEntryDesc(this.getEntryDesc());
        entry.setAssistDesc(this.getAssistDesc());
        entry.setEntriesSeqReal(this.getEntriesSeqReal());
        return entry;
    }

    public String getEntryDesc() {
        return this.entryDesc;
    }

    public void setEntryDesc(String entryDesc) {
        this.entryDesc = entryDesc;
    }

    public String getAssistDesc() {
        return this.assistDesc;
    }

    public void setAssistDesc(String assistDesc) {
        this.assistDesc = assistDesc;
    }
}

