/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.rpt.app.dao.SimpleRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.SimpleRowSetMetaData;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.log4j.Logger;

public class RptFileStorage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.RptFile");
    private static final String FILE_PATH = "./glrpt/tmpfile";
    private Context ctx;
    private String function;
    private String fileName;
    private int rowCount = -1;
    private SimpleRowSetMetaData rowSetMeta;

    public RptFileStorage(Context ctx, String function) {
        this.ctx = ctx;
        this.function = function;
    }

    public IRowSet readRowSet(int start, int length) throws BOSException {
        RandomAccessFile file = null;
        AbstractInterruptibleChannel channel = null;
        try {
            SimpleRowSet rowSet = new SimpleRowSet(this.rowSetMeta, length);
            file = new RandomAccessFile("./glrpt/tmpfile/" + this.fileName, "r");
            channel = file.getChannel();
            if (start + length > this.rowCount) {
                length = this.rowCount - start;
            }
            int RowByteNum = this.rowSetMeta.getColTotalLength();
            MappedByteBuffer buf = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, start * RowByteNum, length * RowByteNum);
            int rowIndex = 0;
            while (buf.position() < buf.limit()) {
                rowSet.insertRow();
                block20: for (int i = 1; i <= this.rowSetMeta.getColumnCount(); ++i) {
                    String colName = this.rowSetMeta.getColumnName(i);
                    switch (this.rowSetMeta.getColumnType(i)) {
                        case 2: {
                            double value = buf.getDouble();
                            rowSet.updateBigDecimal(colName, BigDecimal.valueOf(value));
                            continue block20;
                        }
                        case 12: {
                            byte[] data = new byte[this.rowSetMeta.getColumnDisplaySize(i)];
                            buf.get(data);
                            rowSet.updateString(colName, new String(data, "UTF-8").trim());
                            continue block20;
                        }
                        case 91: {
                            rowSet.updateDate(colName, new Date(buf.getLong()));
                            continue block20;
                        }
                        case 4: {
                            rowSet.updateInt(colName, buf.getInt());
                            continue block20;
                        }
                        default: {
                            byte[] d = new byte[this.rowSetMeta.getColumnDisplaySize(i)];
                            buf.get(d);
                            rowSet.updateString(colName, new String(d, "UTF-8").trim());
                        }
                    }
                }
                ++rowIndex;
            }
            rowSet.beforeFirst();
            SimpleRowSet simpleRowSet = rowSet;
            return simpleRowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"read file data close stream error!");
            }
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"read file data close stream error!");
            }
        }
    }

    public void store(ResultSet rs) throws BOSException {
        this.fileName = System.currentTimeMillis() + "_" + this.function + "_" + ContextUtil.getCurrentUserInfo((Context)this.ctx).getNumber();
        FileOutputStream outStream = null;
        FilterOutputStream buffStream = null;
        FilterOutputStream dataSteam = null;
        try {
            long ct = System.currentTimeMillis();
            File file = new File(FILE_PATH);
            if (!file.exists()) {
                file.mkdirs();
            }
            outStream = new FileOutputStream("./glrpt/tmpfile/" + this.fileName, true);
            buffStream = new BufferedOutputStream(outStream);
            dataSteam = new DataOutputStream(buffStream);
            ResultSetMetaData meta = rs.getMetaData();
            this.rowSetMeta = new SimpleRowSetMetaData(meta);
            this.rowCount = 0;
            while (rs.next()) {
                block16: for (int i = 1; i <= this.rowSetMeta.getColumnCount(); ++i) {
                    int colType = this.rowSetMeta.getColumnType(i);
                    switch (colType) {
                        case 2: {
                            BigDecimal val = rs.getBigDecimal(i);
                            ((DataOutputStream)dataSteam).writeDouble(val == null ? 0.0 : val.doubleValue());
                            continue block16;
                        }
                        case 12: {
                            String str = rs.getString(i);
                            byte[] data = new byte[this.rowSetMeta.getColumnDisplaySize(i)];
                            if (str != null) {
                                byte[] original = str.getBytes("UTF-8");
                                System.arraycopy(original, 0, data, 0, original.length);
                            }
                            dataSteam.write(data);
                            continue block16;
                        }
                        case 91: {
                            Date date = rs.getDate(i);
                            ((DataOutputStream)dataSteam).writeLong(date == null ? 0L : date.getTime());
                            continue block16;
                        }
                        case 4: {
                            int intVal = rs.getInt(i);
                            ((DataOutputStream)dataSteam).writeInt(intVal);
                        }
                    }
                }
                ++this.rowCount;
            }
            logger.info((Object)("------------persist data take " + (System.currentTimeMillis() - ct) + " ms.----------"));
        }
        catch (Exception e) {
            throw new BOSException("persist data error!", (Throwable)e);
        }
        finally {
            try {
                if (dataSteam != null) {
                    dataSteam.close();
                }
                if (buffStream != null) {
                    buffStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"persist data close stream error!");
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

