/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleRowSetMetaData
implements ResultSetMetaData {
    private ColInfo[] cols;

    public SimpleRowSetMetaData(ResultSetMetaData meta) throws SQLException {
        this.cols = this.getColInfos(meta);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    public int getColIndex(String columnName) {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return String.valueOf(this.cols[column - 1].getType());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.cols.length;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.cols[column - 1].getLength();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.cols[column - 1].getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.cols[column - 1].getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.cols[column - 1].getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return String.valueOf(this.cols[column - 1].getType());
    }

    public int getColTotalLength() throws SQLException {
        int byteNum = 0;
        for (int i = 0; i < this.cols.length; ++i) {
            byteNum += this.cols[i].length;
        }
        return byteNum;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private ColInfo[] getColInfos(ResultSetMetaData meta) throws SQLException {
        ColInfo[] colInfos = new ColInfo[meta.getColumnCount()];
        block6: for (int i = 0; i < colInfos.length; ++i) {
            String colName = meta.getColumnName(i + 1);
            switch (meta.getColumnType(i + 1)) {
                case 2: 
                case 3: {
                    colInfos[i] = meta.getScale(i + 1) == 0 ? new ColInfo(colName, 4, 4) : new ColInfo(colName, 2, 8);
                    continue block6;
                }
                case -9: 
                case 12: {
                    colInfos[i] = new ColInfo(colName, 12, meta.getColumnDisplaySize(i + 1));
                    continue block6;
                }
                case 91: 
                case 93: {
                    colInfos[i] = new ColInfo(colName, 91, 8);
                    continue block6;
                }
                case 4: {
                    colInfos[i] = new ColInfo(colName, 4, 4);
                }
            }
        }
        return colInfos;
    }

    class ColInfo {
        private String name;
        private int type;
        private int length;

        ColInfo(String name, int type, int length) {
            this.name = name;
            this.type = type;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }
    }
}

