/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.DataMergeEntryCollection;
import com.kingdee.eas.basedata.master.cssp.DataMergeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssistantHGRepairUtils {
    private static Logger logger = Logger.getLogger(AssistantHGRepairUtils.class);

    public static List<String> getFnamel2FromAsstAccount(Context ctx) {
        String sql = "select fname_l2 from T_BD_ASSTACCOUNT group by fname_l2";
        ArrayList<String> result = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            Object number = null;
            while (rs.next()) {
                result.add(rs.getString("fname_l2"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static List<String> getFidByFname12FromAsstAccount() {
        String sql = "SELECT aa.Fid FROM T_BD_ASSTACCOUNT aa where aa.FCREATORID in (select FCREATORID  from T_BD_ASSTACCOUNT group by FCREATORID having count(*) > 1)";
        try {
            IRowSet iRowSet = DbUtil.executeQuery(null, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static List<Map<String, String>> getFidAndFMappingFieldNameByFname12(Context ctx, String fName12) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(fName12);
        String sql = "select aa.fid, t.FMappingFieldName from T_BD_ASSTACCOUNT aa join T_BD_ASSTACTGROUPDETAIL d on d.FASSTACCOUNTID = aa.fid join T_BD_ASSTACTTYPE t on t.fid = d.FASSTACTTYPEID where aa.fname_l2 = ?";
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramList.toArray());
            HashMap<String, String> map = new HashMap<String, String>();
            String fid = "fid";
            String fMappingFieldName = "FMappingFieldName";
            while (rs.next()) {
                map.put(fid, rs.getString(fid));
                map.put(fMappingFieldName, rs.getString(fMappingFieldName));
                result.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static List<Map<String, String>> getFMappingFieldNameByFidFrom(Context ctx, String fName12) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(fName12);
        String sql = "select aa.fid, t.FMappingFieldName from T_BD_ASSTACCOUNT aa join T_BD_ASSTACTGROUPDETAIL d on d.FASSTACCOUNTID = aa.fid join T_BD_ASSTACTTYPE t on t.fid = d.FASSTACTTYPEID where aa.fname_l2 = ?";
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramList.toArray());
            HashMap<String, String> map = new HashMap<String, String>();
            String fid = "fid";
            String fMappingFieldName = "FMappingFieldName";
            while (rs.next()) {
                map.put(fid, rs.getString(fid));
                map.put(fMappingFieldName, rs.getString(fMappingFieldName));
                result.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static List<Map<String, String>> getParamsFromAssistantHG(Context ctx, String fid, List<Map<String, String>> params) {
        String fMappingFieId = "FMappingFieldName";
        String tableName = "hg.";
        String and = " is not null and ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(fid);
        StringBuffer selectParams = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < params.size(); ++i) {
            selectParams.append(tableName).append(params.get(i).get(fMappingFieId)).append(", ");
            filter.append(tableName).append(params.get(i).get(fMappingFieId)).append(and);
        }
        String selectParamsString = selectParams.toString();
        selectParamsString = selectParamsString.substring(0, selectParamsString.length() - 2);
        String filterString = filter.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(selectParamsString).append(" FROM T_BD_ASSISTANTHG hg where ").append(filterString).append(" hg.FASSTACCOUNTID = ? ").append("group by ").append(selectParamsString).append(" having count(*) > 1");
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            while (rs.next()) {
                AssistantHGRepairUtils.getMapFromRs(result, rs, params);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    private static void getMapFromRs(List<Map<String, String>> result, IRowSet rs, List<Map<String, String>> params) {
        String fMappingFieId = "FMappingFieldName";
        String key = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (int i = 0; i < params.size(); ++i) {
                key = params.get(i).get(fMappingFieId);
                map.put(key, rs.getString(key));
            }
            result.add(map);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static List<String> getFidByParamsFromAssistantHG(Context ctx, String fid, Map<String, String> params) {
        Set<String> keySets = params.keySet();
        StringBuffer filter = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        filter.append(" FASSTACCOUNTID = ? and ");
        paramList.add(fid);
        for (String keySet : keySets) {
            filter.append(keySet).append(" = ? and ");
            paramList.add(params.get(keySet));
        }
        String filterString = filter.toString();
        filterString = filterString.substring(0, filterString.length() - 4);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fid FROM T_BD_ASSISTANTHG where ").append(filterString);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static List<String> getFassgrpIdByFid(Context ctx, List fids) {
        StringBuffer filter = new StringBuffer();
        String union = " union ";
        ArrayList<String> result = new ArrayList<String>();
        String filterString = AssistantHGRepairUtils.getInFilter(fids);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FASSGRPID FROM T_GL_VOUCHERASSISTRECORD where FASSGRPID").append(filterString).append(union).append("SELECT FASSISTGRPID FROM T_GL_INITASSISTBALANCE where FASSISTGRPID").append(filterString).append(union).append("SELECT FASSGRPID FROM T_pca_pcvoucherassistrecord where FASSGRPID").append(filterString).append(union).append("SELECT FASSISTGRPID FROM T_pca_InitPcAssistBalance where FASSISTGRPID").append(filterString);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                result.add(rs.getString("FASSGRPID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static boolean updateFassgrpId(Context ctx, String fAssgrpId, List<String> fids) {
        String voucherTable = "T_GL_VOUCHERASSISTRECORD";
        String pcVoucherTable = "T_pca_pcvoucherassistrecord";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(fAssgrpId);
        String inFilter = AssistantHGRepairUtils.getInFilter(fids);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(voucherTable).append(" set FASSGRPID = ?").append(" where FASSGRPID ").append(inFilter);
        String sqlString = sql.toString();
        try {
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])paramList.toArray());
            sqlString = sqlString.replace(voucherTable, pcVoucherTable);
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])paramList.toArray());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return true;
    }

    public static boolean deleteByFassgrpIdFromAssistantHG(Context ctx, List<String> fids) throws BOSException {
        String inFilter = AssistantHGRepairUtils.getInFilter(fids);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BD_ASSISTANTHG where fid").append(inFilter);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static String[] selectMergeCustomerId(Context ctx, String[] hgidArrar, String tmpTableName, String destName) throws BOSException, SQLException {
        String filter = AssistantHGRepairUtils.getInFilter(hgidArrar);
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from ").append(tmpTableName).append(" ");
        sb.append("where fid ").append(filter).append("and FNAME_L2 = '").append(destName).append("'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.size() == 0) {
                return hgidArrar;
            }
            String[] result = new String[hgidArrar.length];
            String fid = "FID";
            if (rs.next()) {
                result[0] = rs.getString(fid);
            }
            List<String> hgIds = Arrays.asList(hgidArrar);
            int j = 1;
            for (int i = 0; i < hgIds.size(); ++i) {
                if (result[0].equals(hgIds.get(i))) continue;
                result[j] = hgIds.get(i);
                ++j;
            }
            return result;
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
    }

    public static String getInFilter(String[] hgidArrar) {
        if (null == hgidArrar || hgidArrar.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append(" in (");
        for (int i = 0; i < hgidArrar.length; ++i) {
            result.append("'").append(hgidArrar[i]).append("', ");
        }
        String filter = result.toString();
        filter = filter.substring(0, filter.length() - 2) + ") ";
        return filter;
    }

    public static boolean selectFidAndNameByCustomer(Context ctx, String tmpTableName, DataMergeInfo mergeInfo) throws Exception {
        DataMergeEntryCollection entries = mergeInfo.getEntries();
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 0; i < entries.size(); ++i) {
            filters.add(entries.get(i).getSrcId());
        }
        filters.add(mergeInfo.getDestId());
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tmpTableName);
        sb.append(" SELECT a.FID, c.FNAME_l2 FROM t_bd_assistanthg a JOIN T_BD_CUSTOMER c on c.FID = a.FCUSTOMERID where a.FCustomerID  ").append(AssistantHGRepairUtils.getInFilter(filters));
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
            return true;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static String getInFilter(List<String> fids) {
        StringBuffer filter = new StringBuffer();
        filter.append(" in (");
        for (int i = 0; i < fids.size(); ++i) {
            filter.append("'").append(fids.get(i)).append("'").append(", ");
        }
        String filterString = filter.toString();
        filterString = filterString.substring(0, filterString.length() - 2) + ") ";
        return filterString;
    }

    public static IRowSet executeSelectSql(Context ctx, String sql) {
        return AssistantHGRepairUtils.executeSelectSql(ctx, sql, null);
    }

    public static IRowSet executeSelectSql(Context ctx, String sql, ArrayList paramList) {
        if (null == sql || sql.length() == 0) {
            logger.error((Object)"sql is null");
        }
        IRowSet rs = null;
        try {
            rs = null == paramList ? DbUtil.executeQuery((Context)ctx, (String)sql) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramList.toArray());
            try {
                while (rs.next()) {
                    System.out.println();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return rs;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static String[] uniteArray(String[] oldArray, String[] newArray, boolean operation) {
        if (oldArray.length == 0 && newArray.length == 0) {
            return newArray;
        }
        String[] result = null;
        int oldSize = oldArray.length;
        int newSize = newArray.length;
        if (operation) {
            int i;
            result = new String[oldSize + newSize];
            for (i = 0; i < oldSize; ++i) {
                result[i] = oldArray[i];
            }
            for (i = 0; i < newSize; ++i) {
                result[oldSize] = newArray[i];
                ++oldSize;
            }
        } else {
            ArrayList<String> equalStrings = AssistantHGRepairUtils.getEqualStrings(oldArray, newArray);
            if (equalStrings.size() == 0) {
                return oldArray;
            }
            int resultSize = 0;
            result = new String[oldSize - equalStrings.size()];
            for (int i = 0; i < oldSize; ++i) {
                if (equalStrings.contains(oldArray[i])) continue;
                result[resultSize] = oldArray[i];
                ++resultSize;
            }
        }
        return result;
    }

    private static ArrayList<String> getEqualStrings(String[] oldArray, String[] newArray) {
        ArrayList<String> equalStrings = new ArrayList<String>();
        int oldSize = oldArray.length;
        int newSize = newArray.length;
        String equalStr = null;
        if (oldSize > newSize) {
            for (int i = 0; i < newSize; ++i) {
                equalStr = newArray[i];
                for (int j = 0; j < oldSize; ++j) {
                    if (!equalStr.equals(oldArray[j])) continue;
                    equalStrings.add(equalStr);
                }
            }
        } else {
            for (int i = 0; i < oldSize; ++i) {
                equalStr = oldArray[i];
                for (int j = 0; j < newSize; ++j) {
                    if (!equalStr.equals(newArray[j])) continue;
                    equalStrings.add(equalStr);
                }
            }
        }
        return equalStrings;
    }
}

