/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentCheckFacadeFactory;
import com.kingdee.eas.fi.gl.app.InitHelp;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SqlUtils {
    private static Logger logger = Logger.getLogger(SqlUtils.class);

    public static String getInFilter(Set<String> fids) {
        StringBuffer filter = new StringBuffer();
        filter.append(" in (");
        Iterator<String> fid = fids.iterator();
        while (fid.hasNext()) {
            filter.append("'").append(fid.next()).append("'").append(", ");
        }
        String filterString = filter.toString();
        filterString = filterString.substring(0, filterString.length() - 2) + ") ";
        return filterString;
    }

    public static String createTempTableByDDL(TempTablePool iPool, Connection con, String keyDesc, StringBuffer strFields, boolean isNewTable) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        String tempateTable = null;
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
            if (!isNewTable) {
                InitHelp.truncate(con, tempateTable);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return tempateTable;
    }

    public static String createTempTableByDDL(TempTablePool iPool, Connection con, String keyDesc, StringBuffer strFields) throws BOSException, EASBizException {
        return SqlUtils.createTempTableByDDL(iPool, con, keyDesc, strFields, true);
    }

    public static void releaseTable(String tableName) {
        try {
            AcctCussentCheckFacadeFactory.getRemoteInstance().cleanup(tableName);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }
}

