/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class AssistCuSuStatusValidator {
    protected static final Logger logger = CoreUIObject.getLogger(AssistCuSuStatusValidator.class);
    private Context ctx = null;

    public AssistCuSuStatusValidator(Context ctx) {
        this.ctx = ctx;
    }

    public int validator(String asstId, String companyId, int asstFlag) {
        int result = 0;
        switch (asstFlag) {
            case 0: {
                result = this.customerValidator(asstId, companyId);
                break;
            }
            case 1: {
                result = this.supplierValidator(asstId, companyId);
                break;
            }
        }
        return result;
    }

    public int customerValidator(String customerId, String companyId) {
        int result = 0;
        ObjectUuidPK customerPK = new ObjectUuidPK(BOSUuid.read((String)customerId));
        try {
            ICustomer iCustomer = null;
            iCustomer = this.ctx != null ? CustomerFactory.getLocalInstance((Context)this.ctx) : CustomerFactory.getRemoteInstance();
            CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)customerPK);
            if (customerInfo.getUsedStatus().getValue() == 2 || customerInfo.getUsedStatus().getValue() == 3) {
                result = 1;
            } else {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection customerCompanySic = new SelectorItemCollection();
                customerCompanySic.add(new SelectorItemInfo("id"));
                customerCompanySic.add(new SelectorItemInfo("usingStatus"));
                view.setSelector(customerCompanySic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerPK.toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId.toString(), CompareType.INCLUDE));
                filterInfo.setMaskString("#0 and #1");
                view.setFilter(filterInfo);
                ICustomerCompanyInfo iCustomerCompanyInfo = null;
                iCustomerCompanyInfo = this.ctx != null ? CustomerCompanyInfoFactory.getLocalInstance((Context)this.ctx) : CustomerCompanyInfoFactory.getRemoteInstance();
                CustomerCompanyInfoCollection customerCompanycollection = iCustomerCompanyInfo.getCustomerCompanyInfoCollection(view);
                CustomerCompanyInfoInfo customerCompanyInfo = null;
                if (customerCompanycollection.size() > 0) {
                    customerCompanyInfo = customerCompanycollection.get(0);
                }
                if (customerCompanyInfo != null && customerCompanyInfo.getUsingStatus().getValue() == 1) {
                    result = 1;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"483_AssistCuSuStatusValidator"), (Throwable)e);
        }
        return result;
    }

    public int supplierValidator(String supplierId, String companyId) {
        int result = 0;
        ObjectUuidPK supplierPK = new ObjectUuidPK(BOSUuid.read((String)supplierId));
        try {
            ISupplier iSupplier = null;
            iSupplier = this.ctx != null ? SupplierFactory.getLocalInstance((Context)this.ctx) : SupplierFactory.getRemoteInstance();
            SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)supplierPK);
            if (supplierInfo.getUsedStatus().getValue() == 2 || supplierInfo.getUsedStatus().getValue() == 3) {
                result = 1;
            } else {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection supplierCompanySic = new SelectorItemCollection();
                supplierCompanySic.add(new SelectorItemInfo("id"));
                supplierCompanySic.add(new SelectorItemInfo("usingStatus"));
                view.setSelector(supplierCompanySic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierPK.toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.INCLUDE));
                filterInfo.setMaskString("#0 and #1");
                view.setFilter(filterInfo);
                ISupplierCompanyInfo iSupplierCompanyInfo = null;
                iSupplierCompanyInfo = this.ctx != null ? SupplierCompanyInfoFactory.getLocalInstance((Context)this.ctx) : SupplierCompanyInfoFactory.getRemoteInstance();
                SupplierCompanyInfoCollection supplierCompanycollection = iSupplierCompanyInfo.getSupplierCompanyInfoCollection(view);
                SupplierCompanyInfoInfo supplierCompanyInfo = null;
                if (supplierCompanycollection.size() > 0) {
                    supplierCompanyInfo = supplierCompanycollection.get(0);
                }
                if (supplierCompanyInfo != null && supplierCompanyInfo.getUsingStatus().getValue() == 1) {
                    result = 1;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"484_AssistCuSuStatusValidator"), (Throwable)e);
        }
        return result;
    }

    public int customerValidator(CustomerCompanyInfoInfo custCompanyInfo) {
        if (custCompanyInfo.getUsingStatus() == UsingStatusEnum.FREEZED || custCompanyInfo.getCustomer().getUsedStatus() == UsedStatusEnum.FREEZED || custCompanyInfo.getCustomer().getUsedStatus() == UsedStatusEnum.UNAPPROVE) {
            return 1;
        }
        return 0;
    }

    public int supplierValidator(SupplierCompanyInfoInfo suppCompanyInfo) {
        if (suppCompanyInfo.getUsingStatus() == UsingStatusEnum.FREEZED || suppCompanyInfo.getSupplier().getUsedStatus() == UsedStatusEnum.FREEZED || suppCompanyInfo.getSupplier().getUsedStatus() == UsedStatusEnum.UNAPPROVE) {
            return 1;
        }
        return 0;
    }

    public int customerValidator(CustomerInfo customer) {
        if (customer.getUsedStatus() == UsedStatusEnum.FREEZED) {
            return 1;
        }
        return 0;
    }

    public int supplierValidator(SupplierInfo supplierInfo) {
        if (supplierInfo.getUsedStatus() == UsedStatusEnum.FREEZED) {
            return 1;
        }
        return 0;
    }
}

