/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.framework.DataBaseDUtil;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorOperatorSharer;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class VoucherAssistRecordSubmitValidator
extends VoucherValidatorOperatorSharer
implements IVoucherAssistRecordValidator {
    protected static final Logger logger = Logger.getLogger(VoucherAssistRecordSubmitValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;
    protected VoucherEntryInfo entryInfo;
    protected VoucherAssistRecordInfo recordInfo;

    public VoucherAssistRecordSubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo, BaseVoucherAssistRecordInfo baseRecordInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        VoucherEntryInfo entryInfo = (VoucherEntryInfo)baseEntryInfo;
        VoucherAssistRecordInfo recordInfo = (VoucherAssistRecordInfo)baseRecordInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.entryInfo = entryInfo;
        this.recordInfo = recordInfo;
        this.checkRecordDate(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordUserProperty(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordAmount(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordVerify(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordMeasureUnit(ctx, voucherInfo, entryInfo, recordInfo);
    }

    private void checkRecordDate(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        Date bookDate;
        if (entryInfo.getAccount().isAC() && recordInfo.getEndDate() == null) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_NOT_ENDDATE : VoucherException.RECORD_NOT_ENDDATE, this.getSeq());
        }
        Date bizDate = DateTimeUtils.truncateDate((Date)recordInfo.getBizDate());
        if (bizDate.after(bookDate = DateTimeUtils.truncateDate((Date)voucherInfo.getBookedDate()))) {
            if (voucherInfo.isWebVoucher()) {
                throw new VoucherException(VoucherException.WEB_NOTALLOWEDBIZAFTBOOK, this.getSeq());
            }
            throw new VoucherException(VoucherException.NOTALLOWEDBIZAFTBOOK);
        }
    }

    private void checkRecordMeasureUnit(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (useQtyAsst && entryInfo.getAccount().isIsQty() && entryInfo.getCAA() != null && entryInfo.getCAA().isIsQty() && recordInfo.getQuantity() != null && GlUtils.zero.compareTo(recordInfo.getQuantity()) != 0 && recordInfo.getMeasureUnit() == null) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.ENTRY_NEED_MU : VoucherException.ASST_NEED_MU, this.getSeq());
        }
    }

    private void checkRecordVerify(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean isAdj;
        boolean allowCussent = this.sysParam.getBoolean("GL_028");
        if (!allowCussent) {
            return;
        }
        boolean isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
        AcctCussentInfo aci = recordInfo.getVerifiedCussent();
        boolean noAc = aci == null;
        boolean bl = isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        if (isInTimeVerify && !isAdj && !voucherInfo.isIsReverseVoucher()) {
            boolean isVer;
            boolean bl2 = isVer = allowCussent && this.isVerify(entryInfo.getAccount(), entryInfo.getEntryDC());
            if (isVer == noAc) {
                if (isVer) {
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_VERIFY_NO_CUSSENT : VoucherException.RECORD_VERIFY_NO_CUSSENT, this.getSeq());
                }
                throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_NOT_VERIFY_BUT_HAS_CUSSENT : VoucherException.RECORD_NOT_VERIFY_BUT_HAS_CUSSENT, this.getSeq());
            }
        }
    }

    private void checkRecordAmount(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean checkAmount = this.isCheckBalance(voucherInfo.getSourceType(), !voucherInfo.isPostedByUI() && !"WebService".equals(voucherInfo.getString("entrance")));
        boolean canSaveZero = this.sysParam.getBoolean("GL_0301");
        if (!canSaveZero && checkAmount && GlUtils.isAllZeroOrNull(new BigDecimal[]{recordInfo.getLocalAmount(), recordInfo.getOriginalAmount(), recordInfo.getReportingAmount(), recordInfo.getQuantity()})) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.ENTRY_ZERO_AMOUNT : VoucherException.RECORD_ZERO_AMOUNT, this.getSeq());
        }
    }

    private void checkRecordUserProperty(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        List list;
        boolean isAsstChange;
        boolean isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        boolean bl = isAsstChange = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.ASST_ACCOUNT_CHANGE);
        if (!isAdj && !isAsstChange && entryInfo.getAccount().isHasUserProperty() && (list = (List)voucherInfo.getAccountUserProperty().get(entryInfo.getAccount().getId().toString())) != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object[] obj = (Object[])list.get(i);
                Object val = recordInfo.get((String)obj[2]);
                if ((!entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !((Boolean)obj[1]).booleanValue()) && (!entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !((Boolean)obj[0]).booleanValue()) || !(val instanceof String ? val == null || ((String)val).length() == 0 : val == null)) continue;
                throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_USERPROPERTY_IS_NULL : VoucherException.USERPROPERTY_IS_NULL, this.getSeq());
            }
        }
    }

    private boolean isCheckBalance(SourceType sourceType, boolean zeroRowRemoved) {
        boolean isPL;
        boolean checkAmount = !zeroRowRemoved;
        boolean adjEx = SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT == sourceType;
        boolean bl = isPL = SourceType.PROFIT_AND_LOSS == sourceType;
        if (adjEx || isPL) {
            checkAmount = false;
        }
        return checkAmount;
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC) {
        BalanceDirectionEnum accDC;
        return acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    private Integer[] getSeq() {
        Integer[] assistSeq = new Integer[this.voucherInfo.isWebVoucher() ? 1 : 2];
        assistSeq[0] = new Integer(this.entryInfo.getSeq());
        if (!this.voucherInfo.isWebVoucher()) {
            assistSeq[1] = new Integer(this.recordInfo.getSeq());
        }
        return assistSeq;
    }

    protected FilterInfo getDatabaseDFilter(CompanyOrgUnitInfo[] companys) {
        IObjectPK[] ctrlUnitPKs = new IObjectPK[companys.length];
        for (int i = 0; i < companys.length; ++i) {
            ctrlUnitPKs[i] = new ObjectUuidPK(companys[i].getCU().getId().toString());
        }
        String idFieldName = "id";
        String adminCUFieldName = "cu.id";
        FilterInfo filter = new FilterInfo();
        try {
            filter = DataBaseDUtil.getDatabaseDFilter(null, null, (IObjectPK[])ctrlUnitPKs, (String)idFieldName, (String)adminCUFieldName);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return filter;
    }
}

