/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VchAmortUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;

public class VoucherBaseAntiCancelValidator
extends AbstractVoucherBaseValidator {
    private GlParam sysParam = null;

    public VoucherBaseAntiCancelValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkExchangeRateAdjustmentVoucher(ctx, voucherInfo);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkOriginalIsBalanced(ctx, voucherInfo);
        this.checkIsVerifyVoucher(ctx, voucherInfo, this.sysParam);
        this.checkACVoucher(ctx, voucherInfo);
        this.checkAmortVoucher(ctx, voucherInfo);
        this.checkAcNoticeVch(ctx, voucherInfo);
    }

    private void checkAcNoticeVch(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean isGlStart;
        boolean isNoticeBySubmit;
        if (!voucherInfo.isIsACNotice()) {
            return;
        }
        boolean useACNotice = this.sysParam.getBoolean("GLG01");
        boolean bl = isNoticeBySubmit = this.sysParam.getInt("GLG01_2") == 2;
        if (useACNotice && isNoticeBySubmit && !(isGlStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)voucherInfo.getCompany()))) {
            throw new VoucherException(VoucherException.GLNOTSTART);
        }
    }

    private void checkAmortVoucher(Context ctx, VoucherInfo voucherInfo) throws GLException, BOSException, EASBizException, VoucherException {
        if (!VoucherUtil.isAmortVoucher(voucherInfo)) {
            return;
        }
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        StringBuffer sqlAmort = new StringBuffer();
        sqlAmort.append(" SELECT vlog.famortschemeid FROM  t_gl_vchamortlog vlog where vlog.FVoucherID = ?");
        IRowSet rsAmort = DbUtil.executeQuery((Context)ctx, (String)sqlAmort.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rsAmort.size() != 1) {
                throw new EASBizException(new NumericExceptionSubItem("", VchAmortUtils.getResource(ctx, "SCHEME_DELETED", null)));
            }
            if (rsAmort.next()) {
                String amortSchemeId = rsAmort.getString("famortschemeid");
                StringBuffer sqlAmortLog = new StringBuffer();
                sqlAmortLog.append(" SELECT vs.fnumber,vs.fname FROM t_gl_vchamortlog vlog ");
                sqlAmortLog.append(" inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid  \r\t");
                sqlAmortLog.append(" INNER join t_gl_vchamortpolicy policy on policy.famortschemeid = vs.fid and policy.fperiodid=vlog.fperiodid \r\t");
                sqlAmortLog.append(" INNER JOIN t_gl_voucher vo on  vo.fid = vlog.FVoucherID  \r\t");
                sqlAmortLog.append(" WHERE vo.fbizstatus <> 2 and vlog.fperiodid = ? and vs.fid = ?");
                IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog.toString(), (Object[])new Object[]{voucherInfo.getPeriod().getId().toString(), amortSchemeId});
                if (rsAmortLog.next()) {
                    String fname = rsAmortLog.getString("fname");
                    throw new EASBizException(new NumericExceptionSubItem("", VchAmortUtils.getResource(ctx, "SCHEME_VOUCHER_ERROR", new Object[]{fname})));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkOriginalIsBalanced(Context ctx, VoucherInfo voucherInfo) throws GLException, BOSException, EASBizException, VoucherException {
        boolean isValidatorOriginalCurrency = this.sysParam.getBoolean("GL_101");
        boolean isFz = this.sysParam.getBoolean("GL_008");
        if (!isFz && isValidatorOriginalCurrency) {
            VoucherInfo info = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
            this.checkOriginalAmount(ctx, info);
        }
    }

    private void checkExchangeRateAdjustmentVoucher(Context ctx, VoucherInfo voucherInfo) throws BOSException, VoucherException {
        if (voucherInfo.getSourceType().getValue() == 2) {
            String sql = "select 1 from t_gl_AdjExchRateHistory where FVoucherId=? ";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
            try {
                if (rowset == null || !rowset.next()) {
                    throw new VoucherException(VoucherException.CANTCANCELCANCEL_ADJRATE);
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
        }
    }

    private void checkIsVerifyVoucher(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws GLException, BOSException, VoucherException {
        boolean isInTimeVerify;
        boolean allowcuss = sysParam.getBoolean("GL_028");
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (allowcuss && isInTimeVerify) {
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 v.fid from t_gl_voucher v\n inner join t_gl_voucherentry ve on ve.fbillid = v.fid");
            sql.append("\r\ninner join t_bd_accountview av on ve.faccountid = av.fid");
            sql.append("\r\nwhere av.fac = 1 and v.fid = ? and ve.FIsVerify = 1 and v.fbizstatus = 2 ");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
            try {
                if (rowset.next()) {
                    throw new VoucherException(VoucherException.ACVOUCHER_CANOT_ANTICANCEL);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkACVoucher(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean isInTimeVerify;
        boolean allowcuss = this.sysParam.getBoolean("GL_028");
        boolean bl = isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
        if (allowcuss && voucherInfo.isIsAC() && voucherInfo.getId() != null && isInTimeVerify) {
            StringBuffer sql = new StringBuffer();
            String vchid = voucherInfo.getId().toString();
            sql.append("select FID\t\r\n");
            sql.append("from t_gl_Voucherentry                  \r\n");
            sql.append("\t              \r\n");
            sql.append("\twhere FBillID = ?   and FIsVerify=1                         \r\n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchid});
            try {
                if (rowset == null || !rowset.next()) {
                    return;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sql = new StringBuffer();
            sql.append("select vast.FID\t\r\n");
            sql.append("from t_gl_VoucherAssistRecord vast,                 \r\n");
            sql.append("\tt_GL_AcctCussent cust                          \r\n");
            sql.append("\twhere vast.FVerifiedCussentID = cust.FID            \r\n");
            sql.append("\tand vast.FBillID = ?                            \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchid});
            try {
                if (rowset == null || !rowset.next()) {
                    throw new VoucherException(VoucherException.VOUVHACHASUNPOST);
                }
            }
            catch (SQLException e) {
                new BOSException((Throwable)e);
            }
        }
    }
}

