/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.fi.gl.validator.ValidatorCollection;
import com.kingdee.eas.fi.gl.validator.ValidatorInfo;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class VoucherValidatorFactory {
    protected static final Logger logger = Logger.getLogger(VoucherValidatorFactory.class);
    private static HashMap validatorMap = new HashMap();

    public static void getVoucherValidator(Context ctx, String callClassName, VoucherValidator voucherValidator) throws BOSException, EASBizException {
        HashMap classNameMap = null;
        ArrayList baseList = null;
        ArrayList entryList = null;
        ArrayList recordList = null;
        if (validatorMap.get(callClassName) != null) {
            classNameMap = (HashMap)validatorMap.get(callClassName);
            baseList = VoucherValidatorFactory.getValidatorList("base", classNameMap);
            entryList = VoucherValidatorFactory.getValidatorList("entry", classNameMap);
            recordList = VoucherValidatorFactory.getValidatorList("record", classNameMap);
        }
        if (baseList != null && baseList.size() > 0 || entryList != null && entryList.size() > 0 || recordList != null && recordList.size() > 0) {
            VoucherValidatorFactory.initVoucherValidatorBase(voucherValidator, baseList);
            VoucherValidatorFactory.initVoucherValidatorEntry(voucherValidator, entryList);
            VoucherValidatorFactory.initVoucherValidatorRecord(voucherValidator, recordList);
        } else {
            ValidatorCollection vc = VoucherProcessCache.getValidators(ctx, callClassName);
            baseList = new ArrayList();
            entryList = new ArrayList();
            recordList = new ArrayList();
            VoucherValidatorFactory.populateValidatorCollection(vc, baseList, entryList, recordList);
            VoucherValidatorFactory.cacheValidator(callClassName, baseList, entryList, recordList);
            VoucherValidatorFactory.initVoucherValidatorBase(voucherValidator, baseList);
            VoucherValidatorFactory.initVoucherValidatorEntry(voucherValidator, entryList);
            VoucherValidatorFactory.initVoucherValidatorRecord(voucherValidator, recordList);
        }
    }

    private static void cacheValidator(String callClassName, List baseList, List entryList, List recordList) {
        LinkedHashMap<String, List> calssNameMap = new LinkedHashMap<String, List>();
        calssNameMap.put("base", baseList);
        calssNameMap.put("entry", entryList);
        calssNameMap.put("record", recordList);
        validatorMap.put(callClassName, calssNameMap);
    }

    private static void populateValidatorCollection(ValidatorCollection vc, List baseList, List entryList, List recordList) {
        int size = vc.size();
        for (int i = 0; i < size; ++i) {
            ValidatorInfo validatorInfo = vc.get(i);
            if ("com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator".equalsIgnoreCase(validatorInfo.getValidatorInterface())) {
                baseList.add(validatorInfo.getValidatorClassName());
                continue;
            }
            if ("com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator".equalsIgnoreCase(validatorInfo.getValidatorInterface())) {
                entryList.add(validatorInfo.getValidatorClassName());
                continue;
            }
            if (!"com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator".equalsIgnoreCase(validatorInfo.getValidatorInterface())) continue;
            recordList.add(validatorInfo.getValidatorClassName());
        }
    }

    private static List getValidatorList(String key, HashMap calssNameMap) {
        return calssNameMap.get(key) != null ? (List)calssNameMap.get(key) : new ArrayList();
    }

    private static void initVoucherValidatorRecord(VoucherValidator voucherValidator, List recordList) throws BOSException {
        int size = recordList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherAssistRecordValidator recordValidator;
            String validatorClassName = (String)recordList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                recordValidator = (IVoucherAssistRecordValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherAssistRecordValidator(recordValidator);
        }
    }

    private static void initVoucherValidatorEntry(VoucherValidator voucherValidator, List entryList) throws BOSException {
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherEntryValidator entryValidator;
            String validatorClassName = (String)entryList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                entryValidator = (IVoucherEntryValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherEntryValidator(entryValidator);
        }
    }

    private static void initVoucherValidatorBase(VoucherValidator voucherValidator, List baseList) throws BOSException {
        String validatorClassName = null;
        int size = baseList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherBaseValidator baseValidator;
            validatorClassName = (String)baseList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                baseValidator = (IVoucherBaseValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherBaseValidator(baseValidator);
        }
    }
}

