/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InitCashFlow
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        if (!this.isNeedClean(context)) {
            context.getLogger().println("\u5f53\u524d\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u672a\u7ed3\u675f\uff0c\u4e0d\u7ed3\u8f6c\u73b0\u91d1\u6d41\u91cf\uff01");
            return true;
        }
        this.deleteInitCashFlowAsst(context);
        this.insertNotExistedCashFlowItem(context);
        this.clearInitCashflow(context);
        if (context.getPeriod() == 1) {
            context.getLogger().println("\u5e74\u521d\u7ed3\u8f6c\uff0c\u6e05\u7a7a\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e\uff01");
            return true;
        }
        this.initCashFlow(context);
        this.initCashFlowAsst(context);
        return true;
    }

    private boolean isNeedClean(JZContext ctx) throws JZTaskException {
        ResultSet rs;
        PreparedStatement pst;
        block4: {
            boolean bl;
            pst = null;
            rs = null;
            String sql = "select * from t_gl_Flag where forgunitid = ? and fname = 'cashflowInit' and fvalue = 'true'";
            try {
                KDConnection con = ctx.getDbConn();
                pst = con.prepareStatement(sql);
                pst.setString(1, ctx.getOrgFId());
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new JZTaskException("\u5224\u65ad\u662f\u5426\u9700\u8981\u7ed3\u8f6c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u4f59\u989d\u65f6\u53d1\u751f\u9519\u8bef\uff01", 5);
                }
                catch (Throwable throwable) {
                    JZContext.closeStatment(pst);
                    JZContext.closeResultSet(rs);
                    throw throwable;
                }
            }
            JZContext.closeStatment((Statement)pst);
            JZContext.closeResultSet((ResultSet)rs);
            return bl;
        }
        JZContext.closeStatment((Statement)pst);
        JZContext.closeResultSet((ResultSet)rs);
        return false;
    }

    private void clearInitCashflow(JZContext ctx) throws JZTaskException {
        PreparedStatement pstClear = null;
        String sqlClear = "update t_gl_cashflowinit set foriginalamount = 0 , flocalamount = 0 , freportingamount = 0 where fcompanyid = ?";
        try {
            KDConnection con = ctx.getDbConn();
            pstClear = con.prepareStatement(sqlClear);
            pstClear.setString(1, ctx.getOrgFId());
            pstClear.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException("\u6e05\u7a7a\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e\u53d1\u751f\u9519\u8bef\uff01", 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pstClear);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pstClear);
    }

    private void deleteInitCashFlowAsst(JZContext ctx) throws JZTaskException {
        PreparedStatement pstDeleteAsst = null;
        StringBuffer sqlDeleteAsst = new StringBuffer();
        sqlDeleteAsst.append("delete from t_gl_cashflowgrpasst where fid in \r\n");
        sqlDeleteAsst.append("( \r\n");
        sqlDeleteAsst.append("  select ca.fid from t_gl_cashflowgrpasst ca \r\n");
        sqlDeleteAsst.append("  inner join t_gl_cashflowinit cf on ca.fcflowinitid = cf.fid \r\n");
        sqlDeleteAsst.append("  where cf.fcompanyid = ? \r\n");
        sqlDeleteAsst.append(") \r\n");
        try {
            KDConnection con = ctx.getDbConn();
            pstDeleteAsst = con.prepareStatement(sqlDeleteAsst.toString());
            pstDeleteAsst.setString(1, ctx.getOrgFId());
            pstDeleteAsst.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException("\u5220\u9664\u73b0\u91d1\u6d41\u91cf\u8f85\u52a9\u8d26\u521d\u59cb\u5316\u6570\u636e\u53d1\u751f\u9519\u8bef\uff01", 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pstDeleteAsst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pstDeleteAsst);
    }

    private void insertNotExistedCashFlowItem(JZContext ctx) throws JZTaskException {
        KDConnection conn = ctx.getDbConn();
        PreparedStatement pstInsert = null;
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("insert into t_gl_cashflowinit(FID, FCurrencyID, FCashflowItemID, FCompanyID, FControlUnitID, ");
        sqlInsert.append("FCreatorID, FLastUpdateUserID, FCreateTime, FLastUpdateTime) \r\n ");
        sqlInsert.append("select newbosid('57D74021'), cashflow.fcurrencyid, cashflow.fcashflowitemid,");
        sqlInsert.append("'").append(ctx.getOrgFId()).append("',");
        sqlInsert.append("cashflow.fcontrolunitid,");
        sqlInsert.append("'00000000-0000-0000-0000-00000000000013B7DE7F',").append("'00000000-0000-0000-0000-00000000000013B7DE7F',").append(" now(), now() ");
        sqlInsert.append("from \r\n");
        sqlInsert.append("( \r\n");
        sqlInsert.append(this.getNotExistedSQLCondition("cfr.fprimaryitemid"));
        sqlInsert.append("union \r\n");
        sqlInsert.append(this.getNotExistedSQLCondition("cfr.fsupplementaryitemid"));
        sqlInsert.append("union \r\n");
        sqlInsert.append(this.getNotExistedSQLCondition("cfr.ffullInfoitemid"));
        sqlInsert.append(") cashflow \r\n");
        sqlInsert.append("where not exists");
        sqlInsert.append("( \r\n");
        sqlInsert.append("    select 1 from t_gl_cashflowinit cfinit where fcompanyid ='").append(ctx.getOrgFId()).append("' \r\n");
        sqlInsert.append("    and cfinit.fcashflowitemid = cashflow.fcashflowitemid and cfinit.fcurrencyid = cashflow.fcurrencyid \r\n");
        sqlInsert.append(") \r\n");
        try {
            pstInsert = conn.prepareStatement(sqlInsert.toString());
            int index = 1;
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException("\u63d2\u5165\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff01", 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pstInsert);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pstInsert);
    }

    private void initCashFlow(JZContext ctx) throws JZTaskException {
        PreparedStatement pst = null;
        StringBuffer sqlInit = new StringBuffer();
        sqlInit.append("update t_gl_cashflowinit set(foriginalamount, flocalamount, freportingamount) = \r\n");
        sqlInit.append("(\r\n");
        sqlInit.append("select originalamount, localamount, reportingamount from\r\n");
        sqlInit.append("(\r\n");
        sqlInit.append(this.getSQLCondition("cfr.fprimaryitemid", "cfr.fprimarycoeffient", false));
        sqlInit.append("union all \r\n");
        sqlInit.append(this.getSQLCondition("cfr.fsupplementaryitemid", "cfr.fsupplementarycoeffient", false));
        sqlInit.append("union all \r\n");
        sqlInit.append(this.getSQLCondition("cfr.ffullInfoitemid", "1", false));
        sqlInit.append(") t \r\n");
        sqlInit.append("where cashflowitemid = fcashflowitemid and currencyid = fcurrencyid \r\n");
        sqlInit.append(") where fcompanyid=? ");
        try {
            KDConnection con = ctx.getDbConn();
            int index = 1;
            pst = con.prepareStatement(sqlInit.toString());
            pst.setString(index++, ctx.getOrgFId());
            pst.setInt(index++, ctx.getYear());
            pst.setInt(index++, ctx.getPeriodNumber());
            pst.setString(index++, ctx.getOrgFId());
            pst.setInt(index++, ctx.getYear());
            pst.setInt(index++, ctx.getPeriodNumber());
            pst.setString(index++, ctx.getOrgFId());
            pst.setInt(index++, ctx.getYear());
            pst.setInt(index++, ctx.getPeriodNumber());
            pst.setString(index++, ctx.getOrgFId());
            pst.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u65f6\u53d1\u751f\u9519\u8bef\uff01", 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }

    private void initCashFlowAsst(JZContext ctx) throws JZTaskException {
        PreparedStatement pstInsert = null;
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("insert into t_gl_cashflowgrpasst(fid, fcflowinitid, ftype, fassistgrpid, foriginalamount, flocalamount, freportingamount, ");
        sqlInsert.append(" fcreatorid, flastupdateuserid, fcontrolunitid, fcreatetime, flastupdatetime) \r\n");
        sqlInsert.append("select newbosid('BF43DFE7'),");
        sqlInsert.append(" cinit.fid cflowinitid, ftype, assistgrpid, originalamount, localamount, reportingamount, ");
        sqlInsert.append("'00000000-0000-0000-0000-00000000000013B7DE7F',").append("'00000000-0000-0000-0000-00000000000013B7DE7F','").append(ctx.getOrgFId()).append("', now(), now() from \r\n");
        sqlInsert.append("( \r\n");
        sqlInsert.append(this.getSQLCondition("cfr.fprimaryitemid", "cfr.fprimarycoeffient", true));
        sqlInsert.append("union all \r\n");
        sqlInsert.append(this.getSQLCondition("cfr.fsupplementaryitemid", "cfr.fsupplementarycoeffient", true));
        sqlInsert.append("union all \r\n");
        sqlInsert.append(this.getSQLCondition("cfr.ffullInfoitemid", "1", true));
        sqlInsert.append(") t \r\n");
        sqlInsert.append("inner join t_gl_cashflowinit cinit on cinit.fcashflowitemid = t.cashflowitemid and cinit.fcompanyid = ?");
        try {
            KDConnection con = ctx.getDbConn();
            int index = 1;
            pstInsert = con.prepareStatement(sqlInsert.toString());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.setInt(index++, ctx.getYear());
            pstInsert.setInt(index++, ctx.getPeriodNumber());
            pstInsert.setString(index++, ctx.getOrgFId());
            pstInsert.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException("\u63d2\u5165\u73b0\u91d1\u6d41\u91cf\u8f85\u52a9\u8d26\u521d\u59cb\u5316\u91d1\u989d\u65f6\u53d1\u751f\u9519\u8bef\uff01", 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pstInsert);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pstInsert);
    }

    private String getSQLCondition(String typeField, String coeffientField, boolean isAssist) {
        StringBuffer sql = new StringBuffer();
        sql.append("select cfi.fid cashflowitemid, \r\n");
        if (isAssist) {
            sql.append("cfr.ftype ftype, \r\n");
            sql.append("cfr.fassgrpid assistgrpid, \r\n");
        }
        sql.append("sum (cfr.foriginalamount * ").append(coeffientField).append(") originalamount, \r\n");
        sql.append("sum(cfr.flocalamount * ").append(coeffientField).append(") localamount, \r\n");
        sql.append("sum(cfr.freportingamount * ").append(coeffientField).append(") reportingamount, \r\n");
        sql.append("ve.fcurrencyid currencyid \r\n");
        sql.append("from t_gl_cashflowrecord cfr \r\n");
        sql.append("inner join t_bd_cashflowitem cfi on ").append(typeField).append(" = cfi.fid \r\n");
        sql.append("inner join t_gl_voucher voucher on cfr.fvoucherID = voucher.fid \r\n");
        sql.append("inner join t_bd_Period period on voucher.fperiodID = period.fid \r\n");
        sql.append("inner join t_gl_VoucherEntry ve on cfr.fentryID = ve.FID \r\n");
        sql.append("where voucher.FCompanyID = ? \r\n");
        sql.append("and period.fperiodyear = ? \r\n");
        sql.append("and period.fnumber < ? \r\n");
        sql.append("and voucher.fbizstatus = 5 \r\n");
        if (isAssist) {
            sql.append("and cfr.fassgrpid is not null \r\n");
        }
        sql.append("group by cfi.fid,ve.fcurrencyid \r\n");
        if (isAssist) {
            sql.append(" , cfr.ftype, cfr.fassgrpid \r\n");
        }
        return sql.toString();
    }

    private String getNotExistedSQLCondition(String typeField) {
        StringBuffer sql = new StringBuffer();
        sql.append("select cfi.fid fcashflowitemid,ve.fcurrencyid,com.fcontrolunitid \r\n");
        sql.append("from t_gl_cashflowrecord cfr \r\n");
        sql.append("inner join t_bd_cashflowitem cfi on ").append(typeField).append(" = cfi.fid \r\n");
        sql.append("inner join t_gl_voucher voucher on cfr.fvoucherID = voucher.fid \r\n");
        sql.append("inner join t_bd_Period period on voucher.fperiodID = period.fid \r\n");
        sql.append("inner join t_gl_VoucherEntry ve on cfr.fentryID = ve.FID \r\n");
        sql.append("inner join t_org_company com on com.fid = voucher.fcompanyid \r\n");
        sql.append("where voucher.FCompanyID = ? \r\n");
        sql.append("and period.fperiodyear = ? \r\n");
        sql.append("and period.fnumber < ? \r\n");
        sql.append("and voucher.fbizstatus = 5 \r\n");
        return sql.toString();
    }
}

