/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.eas.basedata.assistant.CommRptRouteConfigFacadeFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.app.AbstractCommRptBaseControllerBean;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.framework.report.util.permission.CommRptPermissionDef;
import com.kingdee.eas.framework.report.util.permission.PermissionDefineErrorException;
import com.kingdee.eas.framework.report.util.permission.PermissionUndefinedException;
import com.kingdee.eas.framework.report.util.permission.RowPermission;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommRptBaseControllerBean
extends AbstractCommRptBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.report.app.CommRptBaseControllerBean");

    @Override
    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected RptParams _getChartDatas(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this._query(ctx, params, 0, -1);
    }

    @Override
    protected Object _invoke(Context ctx, String method, Object[] params, Class[] cls, boolean paramsAppendContext) throws BOSException, EASBizException {
        try {
            int i;
            Object[] pp = params;
            Class[] cc = cls;
            if (paramsAppendContext) {
                pp = new Object[params.length + 1];
                System.arraycopy(params, 0, pp, 0, params.length);
                pp[params.length] = this.changeContext(ctx);
                cc = new Class[cls.length + 1];
                System.arraycopy(cls, 0, cc, 0, cls.length);
                cc[cls.length] = Context.class;
            }
            if ((i = method.indexOf(35)) != -1) {
                return this.doInvoke(Class.forName(method.substring(0, i)), method.substring(i + 1), pp, cc, true);
            }
            i = method.indexOf(36);
            if (i != -1) {
                return this.doInvoke(Class.forName(method.substring(0, i)), method.substring(i + 1), pp, cc, false);
            }
            return this.doInvoke(this.getClass(), method, pp, cc, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(method, (Throwable)e);
        }
    }

    private Object doInvoke(Class cl, String method, Object[] params, Class[] cls, boolean classMethod) throws Exception {
        Method mm = cl.getMethod(method, cls);
        return mm.invoke(classMethod ? null : cl.newInstance(), params);
    }

    @Override
    protected void _dropTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        this.dropTable(tableName, ctx);
    }

    @Override
    protected void _dropPoolTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        this.dropTempTable(tableName, ctx);
    }

    @Override
    protected RptRowSet _executeQuery(Context ctx, String sql, SqlParams sp, int from, int len) throws BOSException, EASBizException {
        try {
            return DBUtilx.executeQuery((String)sql, (SqlParams)sp, (int)from, (int)len, (Context)this.changeContext(ctx));
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
    }

    @Override
    protected int _executeUpdate(Context ctx, String sql, SqlParams sp) throws BOSException, EASBizException {
        try {
            return DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)this.changeContext(ctx));
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        return this.executeQuery(sql, parameters, 0, -1, this.changeContext(ctx));
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtils.executeQuery(sql, parameters, from, length, con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int executeUpdate(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            int n = DBUtils.executeUpdate(sql, parameters, con);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                ps.addBatch(sqls[i]);
            }
            int[] i = ps.executeBatch();
            this.close(con, ps);
            return i;
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute batch update: " + ps));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
    }

    protected String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)this.changeContext(ctx)).getTableName(desc);
    }

    protected CreateTempTableResult executeCreateTableAsSelectInto(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
            ais = this.resetAis(ctx, ais);
            CreateTempTableResult createTempTableResult = DBUtils.executeSelectIntoForTempTable(ctx, sql, parameters, con, ais);
            return createTempTableResult;
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
        finally {
            this.close(con);
        }
    }

    private String resetAis(Context ctx, String ais) {
        Repository repo;
        if (ais.equals(ctx.getAIS()) && (repo = RepositoryFactory.getQueryRepository((Context)ctx)) != null) {
            return repo.getIdentity();
        }
        return ais;
    }

    protected int executeCreateAsSelectInto(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            int n = DBUtils.executeSelectInto(sql, parameters, con);
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
        finally {
            this.close(con);
        }
    }

    protected String createTempTableAs(String selectSql, SqlParams parameters, Context ctx) throws BOSException {
        String tempTableName = this.getTempTableName("CommonRpt.createTempTableAs", ctx);
        Connection con = this.getConnection(ctx);
        String sql = null;
        try {
            sql = "select TEMP.* into " + tempTableName + " from (" + selectSql + ") as TEMP";
            DBUtils.executeSelectInto(sql, parameters, con);
            String string = tempTableName;
            return string;
        }
        catch (Exception e) {
            throw new BOSException("Error sql: " + selectSql, (Throwable)e);
        }
        finally {
            this.close(con);
        }
    }

    protected String createTempTable(String selectSql, SqlParams parameters, Context ctx) throws BOSException {
        String tempTableName = "CommonRpt.createTempTableAs";
        Connection con = this.getConnection(ctx);
        String sql = null;
        try {
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
            ais = this.resetAis(ctx, ais);
            sql = "select TEMP.* into " + tempTableName + " from (" + selectSql + ") as TEMP";
            String string = DBUtils.executeSelectIntoForTempTable(this.changeContext(ctx), sql, parameters, con, ais).getTempTable();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
        finally {
            this.close(con);
        }
    }

    public String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
            ais = this.resetAis(ctx, ais);
            TempTablePool pool = TempTablePool.getInstanceForRead((Context)ctx, (String)ais);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public CreateTempTableResult executeCreateAsSelectInto(Context ctx, String sql, SqlParams parameters) throws BOSException {
        Connection con = null;
        try {
            CreateTempTableResult result;
            con = this.getConnection(ctx);
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
            ais = this.resetAis(ctx, ais);
            CreateTempTableResult createTempTableResult = result = DBUtils.executeSelectIntoForTempTable(ctx, sql, parameters, con, ais);
            return createTempTableResult;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
    }

    protected void dropTable(String tableName, Context ctx) throws BOSException {
        if (tableName == null) {
            return;
        }
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)this.changeContext(ctx));
        manager.releaseTableName(tableName);
    }

    protected void dropTempTable(String tableName, Context ctx) throws BOSException {
        try {
            if (tableName != null && tableName.length() != 0) {
                String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
                ais = this.resetAis(ctx, ais);
                TempTablePool.getInstanceForRead((Context)ctx, (String)ais).releaseTable(tableName);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void close(Connection con) {
        this.close(con, null, null);
    }

    protected void close(Statement statement) {
        this.close(null, statement, null);
    }

    protected void close(ResultSet rs) {
        this.close(null, null, rs);
    }

    protected void close(Connection con, ResultSet rs) {
        this.close(con, null, rs);
    }

    protected void close(Connection con, Statement statement) {
        this.close(con, statement, null);
    }

    protected void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Map _getPeriodRange(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ctx = this.changeContext(ctx);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        Map map = null;
        map = !company.isIsBizUnit() ? this._getPeriodRangeUnion(ctx, company) : this._getPeriodRangeNormal(ctx, 3, this._getStartPeriod(ctx, company), this._getCurrentPeriod(ctx, company), company);
        int maxYear = 0;
        int maxPeriod = 0;
        for (Object key : map.keySet()) {
            if (!(key instanceof Integer)) continue;
            int buf = (Integer)key;
            maxYear = maxYear < buf ? buf : maxYear;
        }
        int[] value = (int[])map.get(new Integer(maxYear));
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            maxPeriod = maxPeriod < value[i] ? value[i] : maxPeriod;
        }
        HashMap<Integer, int[]> map2 = new HashMap<Integer, int[]>();
        map2.putAll(map);
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map2);
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        String periodType = company.getAccountPeriodType().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select A.c, A.FPeriodYear, B.FPeriodNumber from").append("\n (select count(1) c, FPeriodYear from t_bd_period where FTypeID=? and FPeriodYear*100+FPeriodNumber>? group by FPeriodYear) A").append("\n inner join t_bd_period B on B.FPeriodYear=A.FPeriodYear and B.FPeriodYear*100+B.FPeriodNumber>? and B.FTypeID=?").append("\n order by A.FPeriodYear, B.FPeriodNumber");
        RptRowSet rs = this.executeQuery(sb.toString(), new SqlParams().addString(periodType).addInt(maxYear * 100 + maxPeriod).addInt(maxYear * 100 + maxPeriod).addString(periodType), ctx);
        int i = 0;
        while (rs.next()) {
            int n2 = rs.getInt("c");
            if (n2 == 0) continue;
            int year = rs.getInt("FPeriodYear");
            int[] p = new int[n2];
            p[0] = rs.getInt("FPeriodNumber");
            i = 0;
            while (i++ < n2 - 1) {
                rs.next();
                p[i] = rs.getInt("FPeriodNumber");
            }
            Integer kk = new Integer(year);
            if (map2.containsKey(kk)) {
                int[] op = (int[])map2.get(kk);
                int[] np = new int[op.length + p.length];
                System.arraycopy(op, 0, np, 0, op.length);
                System.arraycopy(p, 0, np, op.length, p.length);
                p = np;
            }
            int max = 0;
            int min = Integer.MAX_VALUE;
            for (int m = 0; m < p.length; ++m) {
                max = max < p[m] ? p[m] : max;
                min = min > p[m] ? p[m] : min;
            }
            map2.put(kk, new int[]{min, max});
        }
        return allMap;
    }

    protected Map _getPeriodRangeUnion(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Integer, int[]> hashMap;
        String companyIds = company.getDescription();
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \t\t\t\t\t\t\t\r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \t\t\t\t\t\t\t\r\n");
        sql.append("FROM T_BD_Period TP ,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("(SELECT Min(TPS.FBeginDate) FBeginDate, \t\t\t\t\t\t\r\n");
        sql.append("\t\tMax(TPC.FBeginDate) FEndDate\t\t\t\t\t \t\t\t\r\n");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tinner join t_bd_systemstatus tsst \r\n");
        sql.append(" on TSSC.FSystemStatusID=tsst.fid and TSST.fname=?\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPS\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPC\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_BaseUnit TC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = TC.FID\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SC \t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = SC.FUnitId\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SP\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON CHARINDEX(SP.FLongNumber||'!',SC.FLongNumber) = 1\t\t\r\n");
        sql.append("\tinner join t_org_company cc on cc.fid=sc.funitId and cc.fIsBizUnit=1 and cc.fIsCompanyOrgUnit=1  \r\n");
        sql.append(" WHERE SP.FUnitId = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPS.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPC.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (companyIds != null && companyIds.length() > 0) {
            sql.append("    AND cc.fid in(");
            sql.append(companyIds);
            sql.append(")            \r\n");
        }
        sql.append("\t) TPRange\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("WHERE TP.FBeginDate >= TPRange.FBeginDate\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FBeginDate <= TPRange.FEndDate\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("GROUP BY TP.FPeriodYear\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ORDER BY TP.FPeriodYear \t\t\t\t\t\t\t\t\t\t\r\n");
        SqlParams parameter = new SqlParams();
        parameter.addInt(6);
        parameter.addString(company.getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    protected Map _getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParams parameter = new SqlParams();
        parameter.addString(company.getAccountPeriodType().getId().toString());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            HashMap<Integer, int[]> hashMap = map;
            this.close(con, stmt, rs);
            return hashMap;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, rs);
                throw throwable;
            }
        }
    }

    protected PeriodInfo _getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getStartPeriod((Context)this.changeContext(ctx), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected PeriodInfo _getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.changeContext(ctx), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        Connection con = null;
        try {
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getConnectionKey());
            con = QueryConnectionProvider.getConnection((Context)ctx, (String)ais);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return con;
    }

    protected String getConnectionKey() {
        return this.getBOSType().toString();
    }

    public RptRowSet executeQuery(String sql, SqlParams pp, String permissionDefine, String orgId, Context ctx) throws SQLException, BOSException, EASBizException {
        try {
            return DBUtilx.executeQuery((String)this.appendPermission(sql, permissionDefine, orgId, this.changeContext(ctx)), (SqlParams)pp, (Context)ctx);
        }
        catch (PermissionUndefinedException e) {
            throw new SQLDataException(e.getMessage(), (Throwable)e);
        }
        catch (PermissionDefineErrorException e) {
            throw new SQLDataException(e.getMessage(), (Throwable)e);
        }
    }

    public String appendPermission(String sql, String permissionDefine, String orgId, Context ctx) throws PermissionUndefinedException, PermissionDefineErrorException, BOSException, EASBizException {
        if (permissionDefine != null) {
            int split = (permissionDefine = permissionDefine.trim()).indexOf("->");
            if (split == -1) {
                throw new PermissionDefineErrorException("Can not find \"->\" in \"" + permissionDefine + "\", usage:Field" + "->" + "Config.permissin_name.");
            }
            String field = permissionDefine.substring(0, split);
            RowPermission p = CommRptPermissionDef.getRowPermission(permissionDefine = permissionDefine.substring(split + "->".length()), this.getClass());
            if (p.getPermissionItems().length > 0) {
                sql = "select * from (" + sql + ") where " + p.getWhereFilterSQL(orgId, field, this.changeContext(ctx));
            }
        }
        return sql;
    }

    protected String getRptUIName() {
        return null;
    }

    protected boolean isUseRWSplit() {
        return false;
    }

    protected String getDefRptUIName() {
        return this.getClass().getName();
    }

    protected Context changeContext(Context old) {
        String uiName = this.getRptUIName();
        if (uiName == null) {
            return old;
        }
        Context newCtx = null;
        try {
            newCtx = EASEjbFactory.getCtx((String)uiName, (Context)old);
        }
        catch (Exception e) {
            logger.error((Object)"EASEjbFactory.getCtx fail!", (Throwable)e);
            newCtx = old;
        }
        return newCtx;
    }
}

