/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util.permission;

import com.kingdee.eas.framework.report.util.permission.AbstractPermission;
import com.kingdee.eas.framework.report.util.permission.AbstractPermissionItem;
import com.kingdee.eas.framework.report.util.permission.FieldPermission;
import com.kingdee.eas.framework.report.util.permission.FieldPermissionItem;
import com.kingdee.eas.framework.report.util.permission.PermissionDefineErrorException;
import com.kingdee.eas.framework.report.util.permission.PermissionUndefinedException;
import com.kingdee.eas.framework.report.util.permission.RowPermission;
import com.kingdee.eas.framework.report.util.permission.RowPermissionItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;

public class CommRptPermissionDef {
    public static final String LINK_TAG = "->";
    private static final String TAG_NAME_ROW = "Row";
    private static final String TAG_NAME_FIELD = "Field";
    private static final String TAG_NAME_ITEM = "Item";
    private static final String TAG_ATTR_NAME = "name";
    private static final String TAG_ATTR_COLUMNS = "columns";
    private static final String CONFIG_PATH_NAME = "config";
    private static Map permissionMap = new HashMap();

    private CommRptPermissionDef() {
    }

    public static RowPermission getRowPermission(String permissionDefine, Class cl) throws PermissionUndefinedException, PermissionDefineErrorException {
        AbstractPermission p = CommRptPermissionDef.getPermission(permissionDefine, cl);
        if (p instanceof RowPermission) {
            return (RowPermission)p;
        }
        throw new PermissionUndefinedException("Row permission undefined:" + permissionDefine);
    }

    public static FieldPermission getFieldPermission(String permissionDefine, Class cl) throws PermissionUndefinedException, PermissionDefineErrorException {
        AbstractPermission p = CommRptPermissionDef.getPermission(permissionDefine, cl);
        if (p instanceof FieldPermission) {
            return (FieldPermission)p;
        }
        throw new PermissionUndefinedException("Field permission undefined:" + permissionDefine);
    }

    private static AbstractPermission getPermission(String permissionDefine, Class cl) throws PermissionDefineErrorException {
        int i = permissionDefine.indexOf(".");
        String filename = permissionDefine.substring(0, i);
        String permission = permissionDefine.substring(i + 1);
        String prefix = cl.getPackage().getName();
        PermissionCataLog catalog = (PermissionCataLog)permissionMap.get((prefix = prefix.substring(0, prefix.lastIndexOf(".") + 1) + CONFIG_PATH_NAME + ".") + filename);
        if (catalog == null) {
            catalog = CommRptPermissionDef.loadPermissionFrom(filename, cl);
            permissionMap.put(prefix + filename, catalog);
        }
        if (catalog != null) {
            return catalog.getPermission(permission);
        }
        return null;
    }

    private static PermissionCataLog loadPermissionFrom(String filename, Class cl) throws PermissionDefineErrorException {
        InputStream is = cl.getResourceAsStream("../config/" + filename + ".xml");
        if (is == null) {
            throw new PermissionDefineErrorException(filename + ".xml not exists!");
        }
        try {
            Element e = CommRptPermissionDef.parseXML(is, "UTF-8");
            PermissionCataLog catalog = new PermissionCataLog();
            catalog.file = filename;
            List list = e.getChildren();
            AbstractPermission[] ps = new AbstractPermission[list.size()];
            catalog.ps = ps;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isRow;
                AbstractPermission p;
                Element ee = (Element)list.get(i);
                String tag = ee.getName();
                if (TAG_NAME_ROW.equals(tag)) {
                    p = new RowPermission();
                    isRow = true;
                } else if (TAG_NAME_FIELD.equals(tag)) {
                    p = new FieldPermission();
                    isRow = false;
                } else {
                    throw new PermissionDefineErrorException("Tag \"" + tag + "\" can not reconized!");
                }
                ps[i] = p;
                p.setName(ee.getAttributeValue(TAG_ATTR_NAME));
                List children = ee.getChildren();
                AbstractPermissionItem[] aitems = new AbstractPermissionItem[children.size()];
                p.setPermissionItems(aitems);
                int m = children.size();
                for (int j = 0; j < m; ++j) {
                    AbstractPermissionItem item;
                    Element ii = (Element)children.get(j);
                    if (!TAG_NAME_ITEM.equals(ii.getName())) {
                        throw new PermissionDefineErrorException("Tag \"" + ii.getName() + "\" can not reconized!");
                    }
                    if (isRow) {
                        item = new RowPermissionItem();
                    } else {
                        item = new FieldPermissionItem();
                        ((FieldPermissionItem)item).setColumns(ii.getAttributeValue(TAG_ATTR_COLUMNS));
                    }
                    aitems[j] = item;
                    item.setName(ii.getAttributeValue(TAG_ATTR_NAME));
                }
            }
            PermissionCataLog permissionCataLog = catalog;
            return permissionCataLog;
        }
        catch (Exception e) {
            throw new PermissionDefineErrorException(filename + ".xml define error:" + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element parseXML(InputStream is, String chartset) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            doc = builder.build(is);
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return doc.getRootElement();
    }

    public static void main(String[] args) {
        try {
            AbstractPermission p = CommRptPermissionDef.getPermission("Sample.permission_name", CommRptPermissionDef.class);
            p = CommRptPermissionDef.getPermission("Sample.permission_name", CommRptPermissionDef.class);
            System.out.println(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class PermissionCataLog {
        String file;
        AbstractPermission[] ps;

        PermissionCataLog() {
        }

        public AbstractPermission getPermission(String name) {
            String buf = name.toLowerCase(Locale.ENGLISH);
            int n = this.ps.length;
            for (int i = 0; i < n; ++i) {
                if (!buf.equals(this.ps[i].getName().toLowerCase(Locale.ENGLISH))) continue;
                return this.ps[i];
            }
            return null;
        }

        public String toString() {
            return this.file + Arrays.asList(this.ps);
        }
    }
}

