/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptBiBaseFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptBiBaseFacadeControllerBean
extends AbstractRptBiBaseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptBiBaseFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return super._init(ctx, params);
    }

    protected OrgTreeInfo findTreeByReportID(Context ctx, String rptid) throws BOSException, EASBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT top 1 tr.FID, tr.FNumber, tr.FIsBasic from T_CSL_RptReceived c inner join T_ORG_TREE tr on tr.FID=c.FOrgTreeID left join T_RPT_Report r on c.FReportID = r.FCslReportID WHERE r.FID = ? or c.FReportID = ? order by tr.FIsBasic DESC", (Object[])new Object[]{rptid, rptid});
            if (rs.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setNumber(rs.getString(2));
                return info;
            }
            OrgTreeInfo info = this.getOrgTreeByTemplateDispendse(ctx, rptid);
            if (info != null) {
                return info;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"6_RptBiBaseFacadeControllerBean", (Locale)ctx.getOriginLocale())));
    }

    private OrgTreeInfo getOrgTreeByTemplateDispendse(Context ctx, String rptid) throws BOSException {
        String templateSql = "Select template.FGroup TemplateGroup,template.FVersionNumber versionNumber from T_RPT_Template template inner join T_RPT_Report report on report.FTemplateID = template.FID where report.FID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)templateSql, (Object[])new Object[]{rptid});
        try {
            if (rowSet.next()) {
                String versionNumber = rowSet.getString("versionNumber");
                String group = rowSet.getString("TemplateGroup");
                StringBuffer sql = new StringBuffer();
                sql.append(" select top 1 orgTree.FID TreeID,orgTree.FNumber TreeNumber,orgTree.FIsBasic from T_ORG_Tree orgTree  ");
                sql.append(" inner join T_CSL_TempletDispense td on orgTree.FID = td.FOrgBoundID ");
                sql.append(" inner join T_RPT_Template template on template.FID = td.FDispenseSrcID ");
                sql.append(" where template.FGroup = ? and template.FVersionNumber = ? order by orgTree.FIsBasic DESC");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{group, versionNumber.substring(0, versionNumber.indexOf(".")) + ".0"});
                if (rs.next()) {
                    OrgTreeInfo info = new OrgTreeInfo();
                    info.setId(BOSUuid.read((String)rs.getString("TreeID")));
                    info.setNumber(rs.getString("TreeNumber"));
                    return info;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected List _getOrgTreeListByTemplateDispendse(Context ctx, String reportId) throws BOSException, EASBizException {
        StringBuffer templateKql = new StringBuffer();
        templateKql.append(" SELECT template.FGroup TemplateGroup,template.FVersionNumber versionNumber ");
        templateKql.append(" from T_RPT_Template template inner join T_RPT_Report report on report.FTemplateID = template.FID");
        templateKql.append(" where report.FID = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)templateKql.toString(), (Object[])new Object[]{reportId});
        ArrayList<OrgTreeInfo> orgTreeList = new ArrayList<OrgTreeInfo>();
        try {
            if (rowSet.next()) {
                String versionNumber = rowSet.getString("versionNumber");
                String group = rowSet.getString("TemplateGroup");
                StringBuffer sql = new StringBuffer();
                sql.append(" select orgTree.FID TreeID,orgTree.FNumber TreeNumber,orgTree.FIsBasic");
                sql.append(" from T_ORG_Tree orgTree");
                sql.append(" inner join T_CSL_TempletDispense td on orgTree.FID = td.FOrgBoundID ");
                sql.append(" inner join T_RPT_Template template on template.FID = td.FDispenseSrcID");
                sql.append(" where template.FGroup = ? and template.FVersionNumber = ?");
                sql.append(" order by orgTree.FIsBasic DESC");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{group, versionNumber.substring(0, versionNumber.indexOf(".")) + ".0"});
                if (rs.next()) {
                    OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
                    orgTreeInfo.setId(BOSUuid.read((String)rs.getString("TreeID")));
                    orgTreeInfo.setNumber(rs.getString("TreeNumber"));
                    orgTreeInfo.setBasic(rs.getBoolean("FIsBasic"));
                    orgTreeList.add(orgTreeInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgTreeList;
    }

    protected String buildEnumSQL(List data_type) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data_type.size(); ++i) {
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            IntEnum info = (IntEnum)data_type.get(i);
            sb.append(" SELECT ").append(info.getValue()).append(" AS FValue, '").append(info.getAlias()).append("' AS FName, ").append(i).append(" AS FSEQ ");
        }
        return sb.toString();
    }

    @Override
    protected void _releaseTempTables(Context ctx, RptParams params) throws BOSException {
        String temp_table = params.getString("TEMP_TABLE");
        if (!StringUtils.isEmpty((String)temp_table)) {
            DbUtil.execute((Context)ctx, (String)("Drop table " + temp_table));
        }
        TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
        String itemTable = params.getString("ITEM_TEMP_TABLE");
        if (!StringUtils.isEmpty((String)itemTable)) {
            tempTablePool.releaseTable(itemTable);
        }
    }
}

