/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.BIItemCollection;
import com.kingdee.eas.fi.gr.bi.BIItemEntryCollection;
import com.kingdee.eas.fi.gr.bi.BIItemFactory;
import com.kingdee.eas.fi.gr.bi.BIItemInfo;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptItemAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.app.evaluate.ItemEvaluater;
import com.kingdee.eas.fi.gr.bi.app.evaluate.ItemKey;
import com.kingdee.eas.fi.gr.bi.app.evaluate.ItemValue;
import com.kingdee.eas.fi.gr.bi.util.AnalysisAdjustEnum;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptItemAnalysisFacadeControllerBean
extends AbstractRptItemAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptItemAnalysisFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OlapParams _etlModel(Context ctx, RptParams params, boolean remoteConnection, int caller) throws BOSException, EASBizException {
        String templateTableName;
        OlapParams olapParams;
        try {
            OlapParams olapParams2;
            ctx.put((Object)"useTempTbl", (Object)"true");
            olapParams = olapParams2 = super._etlModel(ctx, params, remoteConnection, caller);
        }
        catch (Throwable throwable) {
            String templateTableName2;
            String string = templateTableName2 = ctx.get((Object)"tempTbl") == null ? null : ctx.get((Object)"tempTbl").toString();
            if (!StringUtils.isEmpty((String)templateTableName2)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(templateTableName2);
            }
            ctx.remove((Object)"useTempTbl");
            ctx.remove((Object)"tempTbl");
            throw throwable;
        }
        String string = templateTableName = ctx.get((Object)"tempTbl") == null ? null : ctx.get((Object)"tempTbl").toString();
        if (!StringUtils.isEmpty((String)templateTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(templateTableName);
        }
        ctx.remove((Object)"useTempTbl");
        ctx.remove((Object)"tempTbl");
        return olapParams;
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        boolean singleOrg;
        StringBuffer sb;
        SchemaSource schema = new SchemaSource();
        schema.setCaller(RptItemAnalysisFacadeControllerBean.class);
        schema.setFilename("RptItemAnalysisSchema_" + ctx.getLocale() + ".xml");
        Integer start_year = (Integer)params.getObject("START_YEAR");
        Integer start_period = (Integer)params.getObject("START_PERIOD");
        Integer end_year = (Integer)params.getObject("END_YEAR");
        Integer end_period = (Integer)params.getObject("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        schema.setMacroValue("PeriodLevel", RptBiUtil.getBIPeriodSegment(period_type));
        List data_type = (List)params.getObject("DATA_TYPE");
        List adjust = (List)params.getObject("ADJUST");
        List currency = (List)params.getObject("CURRENCY");
        if (currency.size() > 1) {
            schema.setMacroValue("CurrencyTable", "<Parameter name=\"Currency\"  type=\"Table\"/>");
            sb = new StringBuffer();
            sb.append("\t<Dimension name=\"Currency\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"781_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"Currency\" primaryKey=\"FID\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FID\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("CurrencyDim", sb.toString());
            schema.setMacroValue("CurrencyDimUsage", "<DimensionUsage name=\"Currency\" foreignKey=\"FCurrencyID\"/>");
            schema.setDataItem("Currency", this.buildCurrencySQL(currency), null);
        } else {
            schema.setMacroValue("CurrencyTable", "");
            schema.setMacroValue("CurrencyDim", "");
            schema.setMacroValue("CurrencyDimUsage", "");
        }
        if (data_type.size() > 1) {
            schema.setMacroValue("DataTypeTable", "<Parameter name=\"DataType\"  type=\"Table\"/>");
            sb = new StringBuffer();
            sb.append("\t<Dimension name=\"DataType\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"780_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"DataType\" primaryKey=\"FValue\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FValue\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("DataTypeDim", sb.toString());
            schema.setMacroValue("DataTypeUsage", "<DimensionUsage name=\"DataType\" foreignKey=\"FDataType\"/>");
            schema.setDataItem("DataType", this.buildEnumSQL(data_type), null);
        } else {
            schema.setMacroValue("DataTypeTable", "");
            schema.setMacroValue("DataTypeDim", "");
            schema.setMacroValue("DataTypeUsage", "");
        }
        if (adjust.size() > 1) {
            schema.setMacroValue("AdjustTable", "<Parameter name=\"Adjust\"  type=\"Table\"/>");
            sb = new StringBuffer();
            sb.append("\t<Dimension name=\"Adjust\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"782_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"Adjust\" primaryKey=\"FValue\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FValue\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("AdjustDim", sb.toString());
            schema.setMacroValue("AdjustUsage", "<DimensionUsage name=\"Adjust\" foreignKey=\"FAdjust\"/>");
            schema.setDataItem("Adjust", this.buildEnumSQL(adjust), null);
        } else {
            schema.setMacroValue("AdjustTable", "");
            schema.setMacroValue("AdjustDim", "");
            schema.setMacroValue("AdjustUsage", "");
        }
        schema.setMacroValue("FetchTypeMeasure", RptBiUtil.buildFetchType(params));
        String tree_id = (String)params.getObject("ORG_TREE_ID");
        List orgs = (List)params.getObject("ORGS");
        schema.setDataItem("Orgs", RptBiUtil.buildOrgs(ctx, orgs, tree_id, this.displayElimData(params)), null);
        String report_id = (String)params.getObject("REPORT_ID");
        if (tree_id == null) {
            OrgTreeInfo treeinfo = this.findTreeByReportID(ctx, report_id);
            params.setObject("ORG_TREE_ID", (Object)treeinfo.getId().toString());
            params.setObject("ORG_TREE_Number", (Object)treeinfo.getNumber());
        }
        String periodSql = null;
        if (period_type == 3 && CslRptUtil.isSupport13Period(ctx)) {
            int sy = start_year;
            int sp = start_period;
            int ey = end_year;
            int ep = end_period;
            periodSql = RptBiUtil.buildPeriodSqlFor13q(period_type, sy, sp, ey, ep, ctx);
        } else {
            PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
            boolean isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
            periodSql = RptBiUtil.buildPeriodSQL(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod);
        }
        schema.setDataItem("Period", periodSql, null);
        List items = (List)params.getObject("ITEMS");
        schema.setDataItem("Item", RptBiUtil.buildItemSQLByTempTable(ctx, schema, items), null);
        boolean show_org_sum = params.getBoolean("SHOW_ORG_SUM");
        boolean show_period_sum = params.getBoolean("SHOW_PERIOD_SUM");
        boolean singlePeriod = start_year.intValue() == end_year.intValue() && start_period.intValue() == end_period.intValue();
        boolean bl = singleOrg = orgs.size() == 1;
        if (singlePeriod) {
            schema.setMacroValue("PeriodUseage", "");
        } else {
            schema.setMacroValue("PeriodUseage", "<DimensionUsage name=\"Period\" foreignKey=\"FYearPeriod\"/>");
        }
        if (singleOrg) {
            schema.setMacroValue("OrgsUseage", "");
        } else {
            schema.setMacroValue("OrgsUseage", "<DimensionUsage name=\"Orgs\" foreignKey=\"FOrgUnitID\"/>");
        }
        schema.setDataItem("Fact", this.buildFact(ctx, schema, params, start_year, end_year, start_period, end_period, items), null);
        schema.setMdx(this.makeMdx(singlePeriod, singleOrg, show_org_sum, show_period_sum, data_type, adjust, currency, ctx));
        return schema;
    }

    private String buildCurrencySQL(List currency) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currency.size(); ++i) {
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            CurrencyInfo info = (CurrencyInfo)currency.get(i);
            sb.append(" SELECT '").append(info.getId().toString()).append("' AS FID, '").append(info.getNumber()).append("' AS FNumber, '").append(info.getName()).append("' AS FName, ").append(i).append(" AS FSEQ ");
        }
        return sb.toString();
    }

    private String makeMdx(boolean singlePeriod, boolean singleOrg, boolean show_org_sum, boolean show_period_sum, List data_type, List adjust, List currency, Context ctx) {
        StringBuffer sb = new StringBuffer();
        if (!singlePeriod && show_period_sum) {
            sb.append(" " + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"783_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\"#,##0.00\" ");
        }
        if (!singleOrg && show_org_sum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            sb.append(" " + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"784_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\"#,##0.00\" ");
        }
        sb.append("SELECT ").append(singleOrg ? "" : "{Orgs.Members" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"9_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*").append(singlePeriod ? "" : "{Period.Members" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"10_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*");
        sb.append("Measures.Members ");
        if (currency.size() > 1) {
            sb.append("* Currency.Members");
        }
        if (data_type.size() > 1) {
            sb.append("* DataType.Members");
        }
        if (adjust.size() > 1) {
            sb.append("* Adjust.Members");
        }
        sb.append(" ON COLUMNS, Item.Members ON ROWS FROM Fact");
        return sb.toString();
    }

    private String buildFact(Context ctx, SchemaSource schema, RptParams params, Integer starty, Integer endy, Integer startp, Integer endp, List items) throws EASBizException, BOSException {
        String strTableName = this.doBuildFact(ctx, params, starty, endy, startp, endp, items);
        schema.setProperty("TEMP_TABLE", (Object)strTableName);
        List fetchType = (List)params.getObject("FETCH_TYPE");
        int iSize = fetchType.size();
        StringBuffer strSql = new StringBuffer("SELECT FOrgUnitID,FItemNumber,FCurrencyID,FYearPeriod,FDataType,FAdjust ");
        for (int i = 0; i < iSize; ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchType.get(i);
            strSql.append(",SUM(F").append(RptBiUtil.reviseColName(dataElementInfo.getNumber())).append(") AS F").append(RptBiUtil.reviseColName(dataElementInfo.getNumber()));
        }
        strSql.append("\n FROM ").append(strTableName).append("\n GROUP BY FOrgUnitID,FItemNumber,FCurrencyID,FYearPeriod,FDataType,FAdjust");
        return strSql.toString();
    }

    public String doBuildFact(Context ctx, RptParams params, Integer starty, Integer endy, Integer startp, Integer endp, List items) throws BOSException, EASBizException {
        List orgs = (List)params.getObject("ORGS");
        ArrayList<String> lstOrgUnitNumbers = new ArrayList<String>(orgs.size());
        for (int i = 0; i < orgs.size(); ++i) {
            lstOrgUnitNumbers.add(((OrgUnitInfo)orgs.get(i)).getNumber());
        }
        HashMap<String, Object> itemNumbers = new HashMap<String, Object>();
        for (int i = 0; i < items.size(); ++i) {
            itemNumbers.put(((RPTItemInfo)items.get(i)).getNumber(), null);
        }
        List curr = (List)params.getObject("CURRENCY");
        List adjusts = (List)params.getObject("ADJUST");
        return this.doBuildFact(ctx, params, starty, endy, startp, endp, adjusts, lstOrgUnitNumbers, curr, itemNumbers);
    }

    public String doBuildFact(Context ctx, RptParams params, Integer starty, Integer endy, Integer startp, Integer endp, List adjusts, List lstOrgUnitNumbers, List curr, Map itemNumbers) throws BOSException, EASBizException {
        ItemDataCondition condition = new ItemDataCondition();
        condition.setForBiReport(true);
        String tree_id = params.getString("ORG_TREE_Number");
        condition.setOrgTreeNumber(tree_id);
        condition.setOrgUnitNumber(lstOrgUnitNumbers);
        int period_type = params.getInt("PERIOD_TYPE");
        condition.setRptPeriodType(period_type);
        int startYear = starty;
        condition.setRptYearStart(startYear);
        int endyear = endy;
        condition.setRptYearEnd(endyear);
        int startperiod = startp;
        condition.setRptPeriodStart(startperiod);
        int endperiod = endp;
        condition.setRptPeriodEnd(endperiod);
        condition.setItemList(itemNumbers);
        boolean isForPortalBI = params.getBoolean("IsForPortalBI");
        List fetchType = (List)params.getObject("FETCH_TYPE");
        ArrayList<String> lstDataElement = new ArrayList<String>(fetchType.size());
        for (int i = 0; i < fetchType.size(); ++i) {
            DataElementInfo info = (DataElementInfo)fetchType.get(i);
            lstDataElement.add("" + info.getInterSeq());
        }
        condition.setDataElement(lstDataElement);
        boolean isRptProcess = params.getBoolean("isRptProcess");
        if (!isRptProcess) {
            condition.setCommitStatus(3);
        }
        if (!params.containsKey("IsUsedByFastMerge")) {
            condition.setDataSource(params.getInt("DATA_SRC_TYPE") == 2 ? 2 : 3);
        } else {
            condition.setDataSource(params.getInt("DATA_SRC_TYPE") == 2 ? 31 : 34);
            condition.setFastMergeSoluId(params.getString("MergeSchemeId"));
            if (params.getBoolean("incluedUnReceivedData")) {
                condition.setCommitStatus(-1);
            }
            condition.setIncludeUnAuditAdjust(params.getBoolean("incluedUnReceivedData"));
        }
        condition.setDataCollectNumber(params.getString("DATACOLLECT"));
        IRPTDataService rptDataService = RPTDataServiceFactory.getLocalInstance(ctx);
        HashMap<String, Object> extConditions = new HashMap<String, Object>(4);
        extConditions.put("DATA_TYPE", params.getObject("DATA_TYPE"));
        extConditions.put("KEY_BI", "bi");
        StringBuffer strSql = new StringBuffer();
        strSql.append("Create Table TEML_KSQL_0").append("(").append(" FOrgUnitID varchar(80),FItemNumber varchar(80),FSrcCurrencyID varchar(44),").append("FCurrencyID varchar(44), FYearPeriod int , FDataType int, FAdjust int ");
        int iSize = fetchType.size();
        ArrayList<DataElementInfo> elements = new ArrayList<DataElementInfo>();
        for (int i = 0; i < iSize; ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchType.get(i);
            strSql.append(",F").append(RptBiUtil.reviseColName(dataElementInfo.getNumber())).append(" Numeric(28,10)");
            while (elements.size() - 1 < dataElementInfo.getInterSeq()) {
                elements.add(null);
            }
            elements.set(dataElementInfo.getInterSeq(), dataElementInfo);
        }
        strSql.append(")");
        String strTableName = null;
        try {
            strTableName = TempTablePool.getInstance((Context)ctx).createTempTable(strSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String currids = new String();
        for (int a = 0; a < curr.size(); ++a) {
            if (a != 0) {
                currids = currids + ",";
            }
            currids = currids + ((CurrencyInfo)curr.get(a)).getId().toString();
        }
        condition.setTargetCurrency(currids);
        for (int b = 0; b < adjusts.size(); ++b) {
            AnalysisAdjustEnum adjust = (AnalysisAdjustEnum)((Object)adjusts.get(b));
            if (adjust == AnalysisAdjustEnum.ADJUSTVALUE) {
                extConditions.put("dataType", new Integer(4));
            } else {
                condition.setIsAdjusted(adjust == AnalysisAdjustEnum.ADJUSTED);
                extConditions.put("dataType", new Integer(2));
            }
            if (this.isSingleOrg(params)) {
                List orgsList = (List)params.getObject("ORGS");
                ArrayList<String> orgNumberList = new ArrayList<String>();
                orgNumberList.add(((OrgUnitInfo)orgsList.get(0)).getNumber());
                condition.setOrgUnitNumber(orgNumberList);
            }
            condition.setRptYearStart(startYear);
            condition.setRptYearEnd(endyear);
            condition.setRptPeriodStart(startperiod);
            condition.setRptPeriodEnd(endperiod);
            ArrayList lstResult = rptDataService.getItemData(condition, extConditions);
            HashMap<String, String> dataElementSqlMap = new HashMap<String, String>();
            HashMap dataElementSqlParams = new HashMap();
            for (int i = 0; lstResult != null && i < lstResult.size(); ++i) {
                Object[] row = (Object[])lstResult.get(i);
                int elementseq = (Integer)row[22];
                DataElementInfo einfo = (DataElementInfo)elements.get(elementseq);
                String dataElementNumber = einfo.getNumber();
                ArrayList<Object[]> parameterList = (ArrayList<Object[]>)dataElementSqlParams.get(dataElementNumber);
                if (parameterList == null) {
                    parameterList = new ArrayList<Object[]>();
                    dataElementSqlParams.put(dataElementNumber, parameterList);
                }
                if (!dataElementSqlMap.containsKey(dataElementNumber)) {
                    strSql.setLength(0);
                    strSql.append("insert into ").append(strTableName).append("(FOrgUnitID,FItemNumber,FSrcCurrencyID,FCurrencyID,FYearPeriod,FDataType,FAdjust,");
                    strSql.append("F").append(RptBiUtil.reviseColName(dataElementNumber)).append(") values(?,?,?,?,?,?,?,?)");
                    dataElementSqlMap.put(dataElementNumber, strSql.toString());
                }
                ArrayList<Object> parameters = new ArrayList<Object>();
                if (!isForPortalBI) {
                    parameters.add(row[0]);
                } else {
                    parameters.add(row[18]);
                }
                parameters.add(row[2]);
                parameters.add(row[20] != null ? row[20] : row[19]);
                parameters.add(row[19]);
                int year = (Integer)row[8];
                int period = (Integer)row[9];
                String periodId = RptBiUtil.generatePeriodID(year, period);
                parameters.add(periodId);
                parameters.add(row[23]);
                parameters.add(new Integer(adjust.getValue()));
                parameters.add(row[12] == null ? row[11] : row[12]);
                parameterList.add(parameters.toArray());
            }
            for (String number : dataElementSqlMap.keySet()) {
                DbUtil.executeBatch((Context)ctx, (String)((String)dataElementSqlMap.get(number)), (List)((List)dataElementSqlParams.get(number)));
            }
        }
        if (this.displayElimData(params)) {
            this.insertElimData2Fact(ctx, condition, strTableName);
        }
        return strTableName;
    }

    private boolean displayElimData(RptParams params) {
        return params.getInt("DATA_SRC_TYPE") == 3 && params.getBoolean("DISPLAY_ELIM_DATA");
    }

    private void insertElimData2Fact(Context ctx, ItemDataCondition condition, String factTbl) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        String elimSql = this.getElimSql(condition, params);
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)elimSql, (Object[])params.toArray());
        try {
            while (rs.next()) {
                parameters.clear();
                strSql.delete(0, strSql.length());
                strSql.append("insert into ").append(factTbl).append("(FOrgUnitID,FItemNumber,FSrcCurrencyID,FCurrencyID,FYearPeriod,FDataType,FAdjust,");
                strSql.append("F").append(RptBiUtil.reviseColName(rs.getString("FDataElement"))).append(") values(").append("?,?,?,?,?,?,?,?)");
                parameters.add(rs.getString("FOrgUnitID"));
                parameters.add(rs.getString("FItemNumber"));
                parameters.add(rs.getString("FCurrencyID"));
                parameters.add(rs.getString("FCurrencyID"));
                parameters.add(RptBiUtil.generatePeriodID(rs.getInt("FYear"), rs.getInt("FPeriod")));
                parameters.add(rs.getInt("FDataType"));
                parameters.add(rs.getInt("FAdjust"));
                parameters.add(rs.getBigDecimal("FValue"));
                DbUtil.execute((Context)ctx, (String)strSql.toString(), (Object[])parameters.toArray());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getElimSql(ItemDataCondition condition, List<Object> params) {
        String items = CSLServerHelper.getOrStringByMap(condition.getItemList(), "Item", "FNumber");
        StringBuffer sbSumElim = new StringBuffer();
        sbSumElim.append(" SELECT ('0000'||unit.FNumber||'Elim') AS FOrgUnitId,Item.Fnumber AS FItemNumber, \n");
        sbSumElim.append(" Elim.FCurrencyID AS FCurrencyId, Element.FNumber AS FDataElement,\n");
        sbSumElim.append(" Elim.FYear , Elim.FPeriod ,1 As FdataType,1 AS FAdjust, \n");
        sbSumElim.append(" CASE WHEN (Sum(FDebit) Is Null and Sum(FCredit) Is Null) THEN 0  ELSE ISNULL(SUM(FDebit),0)-ISNULL(SUM(FCredit),0) END AS FValue ");
        sbSumElim.append(" FROM ");
        sbSumElim.append(" T_CSL_ElIMINATIONENTRY");
        sbSumElim.append(" AS ElimEntry ").append(" INNER JOIN ");
        sbSumElim.append(" T_CSL_ELIMINATION ");
        sbSumElim.append(" AS Elim ON ElimEntry.FEliminationID = Elim.FID ");
        sbSumElim.append(" INNER JOIN T_CSL_RPTITEM AS Item  ");
        sbSumElim.append(" \tON ElimEntry.FItemId = Item.Fid ");
        sbSumElim.append(" INNER JOIN T_ORG_Tree OrgTree ");
        sbSumElim.append(" \tON OrgTree.FID = Elim.FOrgBoundID ");
        sbSumElim.append(" INNER JOIN T_ORG_BaseUnit unit ");
        sbSumElim.append(" \tON unit.FID = Elim.FOrgUnit ");
        sbSumElim.append(" INNER JOIN T_CSL_DataElement Element ");
        sbSumElim.append(" \tON Element.FInterSeq = ElimEntry.FDataElement ");
        sbSumElim.append(" WHERE ");
        sbSumElim.append("  ElimEntry.FDataElement in( ");
        sbSumElim.append(CslRptUtil.arrToString(condition.getLstDataElement().toArray())).append(")");
        sbSumElim.append(" AND unit.FNumber in(").append(CslRptUtil.AryToItemString(condition.getOrgUnitNumber())).append(")");
        sbSumElim.append(" AND OrgTree.FNumber = ? ");
        params.add(condition.getOrgTreeNumber());
        if (condition.getCurrency() != null) {
            sbSumElim.append(" AND Elim.FSourceCurrencyId = ? ");
            params.add(condition.getCurrency());
        }
        sbSumElim.append("  AND Elim.FValueType = ? ");
        sbSumElim.append(" AND Elim.FCurrencyID in(");
        sbSumElim.append(CslRptUtil.AryToItemString(Arrays.asList(condition.getTargetCurrency().split(","))));
        sbSumElim.append(")");
        params.add(new Integer(condition.getValueType()));
        sbSumElim.append(" AND Elim.FPeriodType = ? ");
        params.add(new Integer(condition.getRptPeriodType()));
        sbSumElim.append(" AND Elim.FPeriod >= ").append(condition.getRptPeriodStart());
        sbSumElim.append(" AND Elim.FPeriod <= ").append(condition.getRptPeriodEnd());
        sbSumElim.append(" AND Elim.FYear >= ").append(condition.getRptYearStart());
        sbSumElim.append(" AND Elim.FYear <= ").append(condition.getRptYearStart());
        if (!condition.isIncludeUnAuditElim()) {
            sbSumElim.append(" AND Elim.FCheckedStatus = ? ");
            params.add(new Integer(2));
        }
        sbSumElim.append(" AND ").append(items);
        sbSumElim.append(" GROUP BY unit.FNumber,Item.Fnumber,Elim.FCurrencyID,Elim.FYear,Elim.FPeriod,Element.FNumber");
        return sbSumElim.toString();
    }

    @Override
    public String _getRptItemDataTmpTableName(Context ctx, Map mapFilterParam) throws BOSException, EASBizException {
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"13_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
    }

    @Override
    protected void _extractItemData(Context ctx, int year, int period, RptPeriodTypeEnum type, String orgTreeId, boolean isOverride) throws BOSException, EASBizException {
        Date date;
        if (type == null) {
            type = RptPeriodTypeEnum.MONTHLY;
        }
        if (type == RptPeriodTypeEnum.DAILY || type == RptPeriodTypeEnum.WEEKLY) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, type)) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)orgTreeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        if (year < 1901 || period < 1) {
            date = null;
            if (periods == null) {
                boolean support13Period = CslRptUtil.isSupport13Period(ctx);
                date = RPTDate13Util.getPrePeriodLastDayByDate(cal.getTime(), period, type, support13Period);
            } else {
                date = FiscalPeriodHelper.getPrePeriodLastDayByDate(cal.getTime(), type, periods, isMergeByFiscalPeriod);
            }
            cal.setTime(date);
            year = cal.get(1);
            switch (type.getValue()) {
                case 3: {
                    period = cal.get(2) + 1;
                    break;
                }
                case 6: {
                    period = 1;
                    break;
                }
                case 4: {
                    period = cal.get(2) / 4 + 1;
                    break;
                }
                case 5: {
                    period = cal.get(2) / 6 + 1;
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            date = null;
            date = periods == null ? RPTDate13Util.getPeriodLastDate(year, period, type) : FiscalPeriodHelper.getPeriodLastDate(periods, year, period, type, isMergeByFiscalPeriod);
            cal.setTime(date);
        }
        try {
            HashSet<String> existOrgUnitIDs = new HashSet<String>();
            HashSet<String> existOrgUnitNumbers = new HashSet<String>();
            if (type != RptPeriodTypeEnum.MONTHLY) {
                StringBuffer sql = new StringBuffer();
                sql.append("select unit.fid as id,unit.FNumber as number from t_csl_itemdata d\t\t\t\t\n");
                sql.append("inner join t_csl_itemdataentry de on d.FID = de.FItemDataID\t\t\n");
                sql.append("inner join T_Csl_RptReceived RptReceived on RptReceived.FReportID = d.FReportID \n");
                sql.append("inner join T_ORG_Tree tree on tree.fid= RptReceived.FOrgTreeID \n");
                sql.append("inner join T_ORG_BaseUnit unit on unit.fid= d.FCompanyId \n");
                sql.append("where d.FPeriodType=? and de.FYear = ? and de.fperiod = ?\t\t\n");
                sql.append("and tree.FNumber in (");
                sql.append("select distinct tree2.fnumber from t_org_tree tree2 where tree2.ftype=8 and tree2.fisbasic = 1 and tree2.fisforbudget = 0\t\n");
                sql.append(" and tree2.fstartdate <= " + CslRptUtil.formatDateForSql(cal.getTime()));
                sql.append(" and tree2.Isnull(fenddate, To_date('2099-1-1')) >= " + CslRptUtil.formatDateForSql(cal.getTime()));
                sql.append(")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(type.getValue()), new Integer(year), new Integer(period)});
                while (rs.next()) {
                    existOrgUnitIDs.add(rs.getString("id"));
                    existOrgUnitNumbers.add(rs.getString("number"));
                }
            }
            this.extractPeriod(ctx, year, period, type.getValue(), isMergeByFiscalPeriod, periods);
            String periodid = RptBiUtil.generatePeriodID(year, period) + type.getValue();
            this.extractDataFromCSL(ctx, year, period, type, cal, existOrgUnitNumbers, orgTreeId, isOverride);
            if (!type.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                this.extractDataFromBIData(ctx, year, period, type, periodid, existOrgUnitIDs);
            }
            this.extractCurrencyData(ctx);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private void extractCurrencyData(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select top 1 * from DW_DIM_BD_Currency");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (!rowSet.next()) {
                sb.setLength(0);
                sb.append(" INSERT INTO DW_DIM_BD_Currency (").append("\n\t\tFID,").append("\n\t\tFNumber,").append("\n\t\tFName_L1,").append("\n\t\tFName_L2,").append("\n\t\tFName_L3)").append("\n\tSELECT").append("\n\t\tFID,").append("\n\t\tFNumber,").append("\n\t\tFName_L1,").append("\n\t\tFName_L2,").append("\n\t\tFName_L3").append("\n\tFROM T_BD_Currency");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void extractDataFromBIData(Context ctx, int year, int period, RptPeriodTypeEnum type, String periodid, Set existOrgUnitIDs) throws Exception {
        String monthPeriodIDs = RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, period, type);
        String orgUnitIds = this.getOrgUnitIDs(existOrgUnitIDs);
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT into DW_FACT_CSLRPT_ITEMDATA(FAMOUNT, FYTBEGIN, FENDBALANCE,                            \n");
        sql.append(" FYTDAMOUNT, FOrgUnitID,FItemID,FCurrencyID,FSRCCURRENCYID,FPeriodID)                           \n");
        sql.append(" select sum(FAMOUNT) as FAMOUNT, sum(FYTBEGIN) as FYTBEGIN, sum(FENDBALANCE) as FENDBALANCE,    \n");
        sql.append("  sum(FYTDAMOUNT) as FYTDAMOUNT,                                                                \n");
        sql.append(" FOrgUnitID,FItemID,FCurrencyID,                                                                \n");
        sql.append(" FSRCCURRENCYID, FPeriodID from (                                                               \n");
        sql.append(" select sum(FAMOUNT) as FAMOUNT, 0 as FYTBEGIN, 0 as FENDBALANCE,                               \n");
        sql.append("  0 as FYTDAMOUNT,                                                                              \n");
        sql.append(" FOrgUnitID,FItemID,FCurrencyID,                                                                \n");
        sql.append(" FSRCCURRENCYID," + periodid + " as FPeriodID                                                          \n");
        sql.append(" from DW_FACT_CSLRPT_ITEMDATA                                                                   \n");
        sql.append(" where FPeriodID in (" + monthPeriodIDs + ")                                             \n");
        if (existOrgUnitIDs.size() > 0) {
            sql.append(" and FOrgUnitID not in " + orgUnitIds + "                                            \n");
        }
        sql.append(" group by                                                                                       \n");
        sql.append(" FOrgUnitID,FItemID,FCurrencyID,FSRCCURRENCYID,FPeriodID                                        \n");
        sql.append(" union all                                                                                      \n");
        sql.append(" select 0 as FAMOUNT, FYTBEGIN, FENDBALANCE,                                                    \n");
        sql.append("  FYTDAMOUNT ,FOrgUnitID,FItemID,FCurrencyID,                                                   \n");
        sql.append(" FSRCCURRENCYID," + periodid + " as FPeriodID                                                          \n");
        sql.append(" from DW_FACT_CSLRPT_ITEMDATA                                                                   \n");
        sql.append(" where FPeriodID in (                                                                           \n");
        sql.append(" select top 1 FPeriodID from DW_FACT_CSLRPT_ITEMDATA                                            \n");
        sql.append(" where FPeriodID in (" + monthPeriodIDs + ") order by FPeriodID desc                                \n");
        sql.append(" )                                                                                              \n");
        if (existOrgUnitIDs.size() > 0) {
            sql.append(" and FOrgUnitID not in " + orgUnitIds + "                                            \n");
        }
        sql.append(" ) a                                                                                            \n");
        sql.append(" group by FOrgUnitID,FItemID,FCurrencyID,                                                       \n");
        sql.append(" FSRCCURRENCYID, FPeriodID                                                                      \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getOrgUnitIDs(Set existOrgUnitIDs) throws SQLDataException {
        Iterator iterator = existOrgUnitIDs.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(")\n");
        return sql.toString();
    }

    private static String getMonthPeriodIDs(int year, int period, RptPeriodTypeEnum type) {
        StringBuffer sb = new StringBuffer();
        SimplePeriod sp = new SimplePeriod(year, period, 3, null, false);
        switch (type.getValue()) {
            case 4: {
                switch (period) {
                    case 1: {
                        sp.period = 1;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 2;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 3;
                        sb.append(sp.generateID()).append(3);
                        break;
                    }
                    case 2: {
                        sp.period = 4;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 5;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 6;
                        sb.append(sp.generateID()).append(3);
                        break;
                    }
                    case 3: {
                        sp.period = 7;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 8;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 9;
                        sb.append(sp.generateID()).append(3);
                        break;
                    }
                    case 4: {
                        sp.period = 10;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 11;
                        sb.append(sp.generateID()).append(3).append(',');
                        sp.period = 12;
                        sb.append(sp.generateID()).append(3);
                    }
                }
                break;
            }
            case 5: {
                switch (period) {
                    case 1: {
                        sb.append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 1, RptPeriodTypeEnum.QUARTERLY)).append(',').append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 2, RptPeriodTypeEnum.QUARTERLY));
                        break;
                    }
                    case 2: {
                        sb.append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 3, RptPeriodTypeEnum.QUARTERLY)).append(',').append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 4, RptPeriodTypeEnum.QUARTERLY));
                    }
                }
                break;
            }
            case 6: {
                sb.append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 1, RptPeriodTypeEnum.SEMIYEARLY)).append(',').append(RptItemAnalysisFacadeControllerBean.getMonthPeriodIDs(year, 2, RptPeriodTypeEnum.SEMIYEARLY));
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }

    private void extractDataFromCSL(Context ctx, int year, int period, RptPeriodTypeEnum type, Calendar cal, Set existOrgUnitNumbers, String orgTreeId, boolean isOverride) throws Exception {
        if (!type.equals((Object)RptPeriodTypeEnum.MONTHLY) && existOrgUnitNumbers.size() == 0) {
            return;
        }
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(orgTreeId));
        if (tree == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"14_RptItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())});
        }
        Map itemNumbers = null;
        try {
            itemNumbers = this.getSubjectItemNumber(ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (itemNumbers == null || itemNumbers.size() < 1) {
            return;
        }
        List orgNumbers = null;
        if (type.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            orgNumbers = this.getOrgUnits(ctx, tree.getId().toString());
        } else {
            orgNumbers = new ArrayList();
            orgNumbers.addAll(existOrgUnitNumbers);
        }
        if (orgNumbers == null || orgNumbers.size() < 1) {
            return;
        }
        ArrayList currencyIDs = this.getCurrency(ctx, year, period, type);
        if (currencyIDs.size() < 1) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("entries.*");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("ISStandard", (Object)Boolean.FALSE));
        BIItemCollection biItems = BIItemFactory.getLocalInstance(ctx).getCollection(view);
        ArrayList<AnalysisAdjustEnum> adjusts = new ArrayList<AnalysisAdjustEnum>();
        adjusts.add(AnalysisAdjustEnum.ADJUSTED);
        RptParams params = new RptParams();
        params.setString("ORG_TREE_Number", tree.getNumber());
        DataElementCollection elements = DataElementFactory.getLocalInstance(ctx).getDataElementCollection("where number = 'YTBEGIN' or number = 'ENDBALANCE' or number = 'AMOUNT' or number = 'YTDAMOUNT')");
        ArrayList<DataElementInfo> els = new ArrayList<DataElementInfo>();
        for (int i = 0; i < elements.size(); ++i) {
            els.add(elements.get(i));
        }
        params.setObject("FETCH_TYPE", els);
        params.setInt("DATA_SRC_TYPE", 2);
        ArrayList<ValueTypeEnum> data_type = new ArrayList<ValueTypeEnum>();
        data_type.add(ValueTypeEnum.MONEY);
        params.setObject("DATA_TYPE", data_type);
        params.setBoolean("IsForPortalBI", true);
        params.setInt("PERIOD_TYPE", type.getValue());
        String tempTable = this.doBuildFact(ctx, params, new Integer(year), new Integer(year), new Integer(period), new Integer(period), adjusts, orgNumbers, currencyIDs, itemNumbers);
        for (int i = 0; i < biItems.size(); ++i) {
            Map itemValues;
            BIItemInfo info = biItems.get(i);
            String formula = info.getItemDefine();
            BIItemEntryCollection entries = info.getEntries();
            if (entries == null || entries.size() < 1) continue;
            StringBuffer sql1 = new StringBuffer("select sum(FYTBEGIN) as FYTBEGIN, sum(FENDBALANCE) as FENDBALANCE, sum(FAMOUNT) as FAMOUNT, sum(FYTDAMOUNT) as FYTDAMOUNT ").append("\n , FOrgUnitID, FItemNumber, FSrcCurrencyID,FCurrencyID ,FYearPeriod \n from ");
            sql1.append(tempTable).append(" a").append("\n where ").append("FItemNumber in (");
            for (int j = 0; j < entries.size(); ++j) {
                if (j != 0) {
                    sql1.append(" ,");
                }
                sql1.append("'").append(entries.get(j).getItemNumber()).append("' ");
            }
            sql1.append(")");
            StringBuffer sql2 = new StringBuffer();
            sql2.append(" exists(select * from DW_FACT_CSLRPT_ITEMDATA b");
            sql2.append(" inner join  T_DW_Dim_CSL_BIItem i on b.fitemid = i.fid");
            sql2.append(" inner join T_DW_Dim_CSL_BIItemEntry e on i.fid = e.fbiitemid");
            sql2.append(" where a.FOrgUnitID = b.FOrgUnitID and a.FSrcCurrencyID = b.FSrcCurrencyID");
            sql2.append(" and a.FCurrencyID = b.FCurrencyID and to_char(a.FYearPeriod) || '" + type.getValue() + "' = to_char(b.FPeriodID)");
            sql2.append(" and a.FItemNumber = e.fitemnumber and b.fitemid = '" + info.getId().toString() + "')");
            StringBuffer sql3 = new StringBuffer();
            sql3.append("\n group by FOrgUnitID, FSrcCurrencyID,FCurrencyID,FYearPeriod, FItemNumber").append("\n order by FOrgUnitID, FSrcCurrencyID,FCurrencyID,FYearPeriod, FItemNumber");
            StringBuffer sqlUpdate = new StringBuffer();
            sqlUpdate.append(sql1).append(" and ").append(sql2).append(sql3);
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append(sql1).append(" and not ").append(sql2).append(sql3);
            if (isOverride) {
                itemValues = this.queryToMap(ctx, info, formula, sqlUpdate);
                StringBuffer sqlu = new StringBuffer();
                sqlu.append("update DW_FACT_CSLRPT_ITEMDATA set FYTBEGIN = ?, FENDBALANCE = ?, FAMOUNT = ?, FYTDAMOUNT = ? ");
                sqlu.append(" where FOrgUnitID = ? and FItemID = ? and FCurrencyID = ? and FSrcCurrencyID = ? and FPeriodID = ?");
                this.saveData(ctx, type, itemValues, sqlu);
            }
            itemValues = this.queryToMap(ctx, info, formula, sqlInsert);
            StringBuffer sqli = new StringBuffer();
            sqli.append("INSERT INTO DW_FACT_CSLRPT_ITEMDATA").append("(FYTBEGIN,FENDBALANCE,FAMOUNT,FYTDAMOUNT,FOrgUnitID,FItemID,FCurrencyID,FSrcCurrencyID,FPeriodID)").append("values(?,?,?,?,?,?,?,?,?)");
            this.saveData(ctx, type, itemValues, sqli);
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tempTable);
        }
    }

    private Map queryToMap(Context ctx, BIItemInfo info, String formula, StringBuffer sqlInsert) throws BOSException, SQLException, Exception {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlInsert.toString());
        HashMap<ItemKey, HashMap<String, ItemValue>> itemValues = new HashMap<ItemKey, HashMap<String, ItemValue>>();
        while (rs.next()) {
            BigDecimal ytbegin = (BigDecimal)rs.getObject("FYTBEGIN");
            BigDecimal endbalance = (BigDecimal)rs.getObject("FENDBALANCE");
            BigDecimal amount = (BigDecimal)rs.getObject("FAMOUNT");
            BigDecimal ytamount = (BigDecimal)rs.getObject("FYTDAMOUNT");
            String itemNumber = rs.getString("FItemNumber");
            ItemKey key = new ItemKey(rs.getString("FOrgUnitID"), info.getId().toString(), rs.getString("FCurrencyID"), rs.getString("FSrcCurrencyID"), rs.getString("FYearPeriod"));
            HashMap<String, ItemValue> item_value = (HashMap<String, ItemValue>)itemValues.get(key);
            if (item_value == null) {
                item_value = new HashMap<String, ItemValue>();
                itemValues.put(key, item_value);
            }
            item_value.put(itemNumber, new ItemValue(ytbegin, endbalance, amount, ytamount));
        }
        ItemEvaluater evaluter = new ItemEvaluater(formula, itemValues);
        evaluter.execute(ctx);
        return itemValues;
    }

    private ArrayList getCurrency(Context ctx, int year, int period, RptPeriodTypeEnum type) throws BOSException {
        ArrayList<CurrencyInfo> cus = new ArrayList<CurrencyInfo>();
        String curr_sql = "select distinct FCurrencyID from t_csl_cslreport where fyear = ? and fperiod=? and fperiodtype=?";
        IRowSet rr = DbUtil.executeQuery((Context)ctx, (String)curr_sql, (Object[])new Object[]{new Integer(year), new Integer(period), new Integer(type.getValue())});
        try {
            while (rr.next()) {
                CurrencyInfo inf = new CurrencyInfo();
                String id = rr.getString(1);
                inf.setId(BOSUuid.read((String)id));
                cus.add(inf);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cus;
    }

    private void extractPeriod(Context ctx, int year, int period, int periodType, boolean isMergeByFiscalPeriod, PeriodCollection periods) throws BOSException, SQLException {
        String query = "select top 1 * from DW_DIM_CSL_PERIOD where Fyear=? and Fperiod=? and FperiodType=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)query, (Object[])new Integer[]{new Integer(year), new Integer(period), new Integer(periodType)});
        if (rs.next()) {
            return;
        }
        String insert = "insert into DW_DIM_CSL_PERIOD (FID, FYEAR, FPeriod, FPERIODTYPE,FLastYearID,FLastPeriodID) values (?,?,?,?,?,?)";
        SimplePeriod p = new SimplePeriod(year, period, periodType, periods, isMergeByFiscalPeriod);
        DbUtil.execute((Context)ctx, (String)insert, (Object[])new Object[]{p.generateID() + periodType, new Integer(p.year), new Integer(p.period), new Integer(periodType), p.getLastYear().generateID() + periodType, p.getLastPeriod(ctx).generateID() + periodType});
    }

    private void saveData(Context ctx, RptPeriodTypeEnum en, Map itemValues, StringBuffer sbSql) throws BOSException {
        Iterator valueit = itemValues.entrySet().iterator();
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sbSql.toString());
            while (valueit.hasNext()) {
                Map.Entry entry = valueit.next();
                ItemKey key = (ItemKey)entry.getKey();
                ItemValue value = (ItemValue)entry.getValue();
                statement.setObject(1, value.getYtbegin());
                statement.setObject(2, value.getEndbalance());
                statement.setObject(3, value.getAmount());
                statement.setObject(4, value.getYtamount());
                statement.setObject(5, key.getOrgid());
                statement.setObject(6, key.getItemNumber());
                statement.setObject(7, key.getCurrencyid());
                statement.setObject(8, key.getSrccurrencyid());
                statement.setObject(9, key.getYearperiod() + en.getValue());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql 1 sql is:" + sbSql), (Throwable)exc);
                throw new BOSException("Sql1 execute exception : " + sbSql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private List getOrgUnits(Context ctx, String treeID) throws BOSException, SQLException {
        String sql = "select b.FNumber from T_Org_BaseUnit b inner join T_ORG_STRUCTURE s on b.FID = s.FUnitID where s.FTreeID = ? and s.FISLeaf = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{treeID});
        ArrayList<String> j = new ArrayList<String>();
        while (rs.next()) {
            j.add(rs.getString(1));
        }
        return j;
    }

    private Map getSubjectItemNumber(Context ctx) throws BOSException, SQLException {
        String sql = "select distinct FItemNumber from T_DW_Dim_CSL_BIItemEntry";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Object> j = new HashMap<String, Object>();
        while (rs.next()) {
            j.put(rs.getString(1), null);
        }
        return j;
    }

    public static OrgTreeInfo getBasicTree(Context ctx, Date date) throws EASBizException, BOSException {
        String sql = "select fid,fnumber from t_org_tree where ftype=8 and fisbasic = 1 and fisforbudget = 0  and fstartdate <= " + CslRptUtil.formatDateForSql(date) + " and Isnull(fenddate, To_date('2099-1-1')) >= " + CslRptUtil.formatDateForSql(date);
        IRowSet rs = null;
        String ret = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                ret = rs.getString("fnumber");
                OrgTreeInfo info = new OrgTreeInfo();
                info.setNumber(ret);
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                return info;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (ret == null) {
            // empty if block
        }
        return null;
    }

    private boolean isSingleOrg(RptParams params) {
        return params.getObject("ORGS") != null && ((List)params.getObject("ORGS")).size() == 1;
    }

    @Override
    protected boolean _existsExtractedItemData(Context ctx, String periodId) throws BOSException {
        String sql = "select top 1 * from DW_FACT_CSLRPT_ITEMDATA where FPeriodID = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{periodId});
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }
}

