/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.bi.app.AbstractRptMultiCslAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.app.RptXDynaItemAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.PeriodIterator;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.IMultiDynaItemDataFacade;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaItemDataFacadeFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptMultiCslAnalysisFacadeControllerBean
extends AbstractRptMultiCslAnalysisFacadeControllerBean {
    private static final long serialVersionUID = -3641541456972321514L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.app.RptMultiCslAnalysisFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        boolean singleOrg;
        int i;
        SchemaSource schema = new SchemaSource();
        schema.setCaller(RptXDynaItemAnalysisFacadeControllerBean.class);
        schema.setFilename("RptMultiCslAnalysisSchema_" + ctx.getLocale() + ".xml");
        Integer start_year = (Integer)params.getObject("START_YEAR");
        Integer start_period = (Integer)params.getObject("START_PERIOD");
        Integer end_year = (Integer)params.getObject("END_YEAR");
        Integer end_period = (Integer)params.getObject("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        schema.setMacroValue("PeriodLevel", RptBiUtil.getBIPeriodSegment(period_type));
        schema.setMacroValue("FetchTypeMeasure", RptBiUtil.buildFetchType(params));
        String tree_id = (String)params.getObject("ORG_TREE_ID");
        List orgs = (List)params.getObject("ORGS");
        schema.setDataItem("Orgs", RptBiUtil.buildOrgs(ctx, orgs, tree_id), null);
        String report_id = (String)params.getObject("REPORT_ID");
        if (tree_id == null) {
            OrgTreeInfo treeinfo = this.findTreeByReportID(ctx, report_id);
            if (treeinfo == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"12_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())});
            }
            params.setObject("ORG_TREE_ID", (Object)treeinfo.getId().toString());
            params.setObject("ORG_TREE_Number", (Object)treeinfo.getNumber());
        }
        PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
        boolean isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
        schema.setDataItem("Period", RptBiUtil.buildPeriodSQL(start_year, start_period, end_year, end_period, period_type, periodCollection, isMergeByFiscalPeriod), null);
        List items = (List)params.getObject("ITEMS");
        schema.setDataItem("Item", RptBiUtil.buildItemSQL(items), null);
        Map map = (Map)params.getObject("DITEMS");
        ArrayList ditems = new ArrayList(map.values());
        StringBuffer ditemVar = new StringBuffer();
        for (i = 0; i < ditems.size(); ++i) {
            ditemVar.append("<DimensionUsage name=\"DItem").append(i).append("\" foreignKey=\"FDItem").append(i).append("Number\"/>");
            schema.setDataItem("DItem" + i, this.buildDItemsSQL(ditems.get(i)), null);
        }
        schema.setMacroValue("ditemVar", ditemVar.toString());
        ditemVar = new StringBuffer();
        for (i = 0; i < ditems.size(); ++i) {
            ditemVar.append("<Dimension name=\"DItem" + i + "\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"15_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (i + 1) + "\" table=\"DItem" + i + "\" primaryKey=\"FNumber\"> \n");
            ditemVar.append("<Hierarchy hasAll=\"false\"> \n");
            ditemVar.append("<Level name=\"DItem" + i + "\" column=\"FNumber\" orderBy=\"FID\"> \n");
            ditemVar.append("<Property  name=\"name\" column=\"FNumber\" /> \n");
            ditemVar.append("<Property  name=\"caption\" column=\"FName\" /> \n");
            ditemVar.append("</Level> \n");
            ditemVar.append("</Hierarchy> \n");
            ditemVar.append("</Dimension> \n");
        }
        schema.setMacroValue("DItem0", ditemVar.toString());
        boolean show_org_sum = params.getBoolean("SHOW_ORG_SUM");
        boolean show_period_sum = params.getBoolean("SHOW_PERIOD_SUM");
        List data_type = (List)params.getObject("DATA_TYPE");
        if (data_type.size() > 1) {
            schema.setMacroValue("DataTypeTable", "<Parameter name=\"DataType\"  type=\"Table\"/>");
            StringBuffer sb = new StringBuffer();
            sb.append("\t<Dimension name=\"DataType\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"780_RptDynaItemAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\" table=\"DataType\" primaryKey=\"FValue\"> \n").append("\t\t<Hierarchy>                                                 \n").append("\t\t\t<Level name=\"name\" column=\"FValue\" orderBy=\"FSEQ\">   \n").append("\t\t\t\t<Property name=\"name\" column=\"FName\"/>          \n").append("\t\t\t</Level>                                                \n").append("\t\t</Hierarchy>                                                \n").append("\t</Dimension>                                                    \n");
            schema.setMacroValue("DataTypeDim", sb.toString());
            schema.setMacroValue("DataTypeUsage", "<DimensionUsage name=\"DataType\" foreignKey=\"FDataType\"/>");
            schema.setDataItem("DataType", this.buildEnumSQL(data_type), null);
        } else {
            schema.setMacroValue("DataTypeTable", "");
            schema.setMacroValue("DataTypeDim", "");
            schema.setMacroValue("DataTypeUsage", "");
        }
        boolean singlePeriod = start_year.intValue() == end_year.intValue() && start_period.intValue() == end_period.intValue();
        boolean bl = singleOrg = orgs.size() == 1;
        if (singlePeriod) {
            schema.setMacroValue("PeriodUseage", "");
        } else {
            schema.setMacroValue("PeriodUseage", "<DimensionUsage name=\"Period\" foreignKey=\"FYearPeriod\"/>");
        }
        if (singleOrg) {
            schema.setMacroValue("OrgsUseage", "");
        } else {
            schema.setMacroValue("OrgsUseage", "<DimensionUsage name=\"Orgs\" foreignKey=\"FOrgUnitID\"/>");
        }
        schema.setDataItem("Fact", this.buildFact(ctx, params, schema), null);
        schema.setMdx(this.makeMdx(singlePeriod, singleOrg, show_org_sum, show_period_sum, params, ctx));
        return schema;
    }

    private String buildDItemsSQL(Object o) {
        List list = (List)o;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            DynaItemInfo a = (DynaItemInfo)list.get(i);
            if (i != 0) {
                sb.append("\n UNION ALL ");
            }
            sb.append(" SELECT '").append(a.getDitemName()).append("' AS FName, '").append(a.getDitemNumber()).append("' AS FNumber, ").append(i).append(" AS FID ");
        }
        return sb.toString();
    }

    private String buildFact(Context ctx, RptParams params, SchemaSource schema) throws BOSException, EASBizException {
        int i;
        int i2;
        int j;
        String tableName = RptMultiCslAnalysisFacadeControllerBean.getTempTableName((String)"RptMultiCslAnalysis", (Context)ctx);
        schema.setProperty("TEMP_TABLE", (Object)tableName);
        Map map = (Map)params.getObject("DITEMS");
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tableName).append("( FOrgUnitID varchar(44), FItemNumber varchar(80),");
        for (int i3 = 0; i3 < map.size(); ++i3) {
            sql.append("FDItem");
            sql.append(i3);
            sql.append("Number varchar(400),");
        }
        sql.append(" FYearPeriod int , FDATATYPE int");
        List fetchtype = (List)params.getObject("FETCH_TYPE");
        int iSize = fetchtype.size();
        for (int i4 = 0; i4 < iSize; ++i4) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i4);
            sql.append(",F").append(dataElementInfo.getNumber()).append(" Numeric(28,10)");
            sql.append(",F").append(dataElementInfo.getNumber()).append("Elim Numeric(28,10) DEFAULT 0 ");
        }
        sql.append(",FFCslRptAssistantHGID varchar(44)");
        sql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(sql.toString());
        IMultiDynaItemDataFacade multiDyna = MultiDynaItemDataFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Parameter> dyparams = new ArrayList<Parameter>();
        int startYear = params.getInt("START_YEAR");
        int endyear = params.getInt("END_YEAR");
        int startperiod = params.getInt("START_PERIOD");
        int endperiod = params.getInt("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        PeriodCollection periodCollection = (PeriodCollection)params.getObject("periodCollection");
        boolean isMergeByFiscalPeriod = (Boolean)params.getObject("isMergeByFiscalPeriod");
        PeriodIterator periodit = new PeriodIterator(startYear, endyear, startperiod, endperiod, period_type, periodCollection, isMergeByFiscalPeriod);
        List arrItemList = (List)params.getObject("ITEMS");
        List orgs = (List)params.getObject("ORGS");
        ArrayList ditems = new ArrayList(map.values());
        List ditemsR = RptMultiCslAnalysisFacadeControllerBean.getResult(ditems);
        long b = System.currentTimeMillis();
        while (periodit.hasNext()) {
            SimplePeriod period = periodit.next();
            for (int k = 0; k < orgs.size(); ++k) {
                OrgUnitInfo info = (OrgUnitInfo)orgs.get(k);
                for (j = 0; j < arrItemList.size(); ++j) {
                    for (int m = 0; m < iSize; ++m) {
                        for (i2 = 0; i2 < ditemsR.size(); ++i2) {
                            String a = (String)ditemsR.get(i2);
                            List datatype = (List)params.getObject("DATA_TYPE");
                            for (int l = 0; l < datatype.size(); ++l) {
                                DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(m);
                                Object[] args = new Object[14];
                                args[0] = new Variant((Object)params.getString("ORG_TREE_Number"));
                                args[1] = new Variant((Object)info.getNumber());
                                args[2] = new Variant((Object)"");
                                args[3] = new Variant((Object)params.getString("CURRENCY"));
                                args[4] = new Variant(arrItemList.get(j));
                                args[5] = new Variant((Object)a);
                                args[6] = new Variant((Object)params.getString("PERIOD_TYPE_NAME"));
                                args[7] = new Variant(period.year);
                                args[8] = new Variant(period.period);
                                args[9] = new Variant(period.period);
                                args[10] = new Variant((Object)"MULTIDYNAMICNORMALREPORT");
                                args[11] = new Variant((Object)dataElementInfo.getNumber());
                                ValueTypeEnum valueType = (ValueTypeEnum)((Object)datatype.get(l));
                                args[12] = new Variant((Object)valueType.getName());
                                args[13] = new Variant(params.getBoolean("ADJUST"));
                                Parameter param = new Parameter(new Object[]{args}, "sheetmd");
                                dyparams.add(param);
                            }
                        }
                    }
                }
            }
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"16_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        b = System.currentTimeMillis();
        List result = (List)multiDyna.getMuitlDynaItemData(dyparams);
        logger.info((Object)(dyparams.size() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"17_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        ArrayList ps = new ArrayList();
        b = System.currentTimeMillis();
        HashMap<String, Integer> dataEle = new HashMap<String, Integer>();
        sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName).append(" (FOrgUnitID, FItemNumber,FYearPeriod, FDATATYPE");
        for (j = 0; j < map.size(); ++j) {
            sql.append(",FDItem").append(j).append("Number");
        }
        for (int i5 = 0; i5 < iSize; ++i5) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i5);
            sql.append(",F").append(dataElementInfo.getNumber()).append(" ");
            dataEle.put(dataElementInfo.getNumber(), new Integer(i5));
        }
        sql.append(") values (?,?,?,?");
        for (j = 0; j < map.size() + iSize; ++j) {
            sql.append(",?");
        }
        sql.append(")");
        Connection con = super.getConnection(ctx);
        PreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sql.toString());
            for (i2 = 0; result != null && i2 < result.size(); ++i2) {
                ps.clear();
                Parameter row = (Parameter)result.get(i2);
                if (((BigDecimal)row.getValue()).signum() == 0) continue;
                Object[] obj = (Object[])row.getArgs()[0];
                PeriodIterator it = new PeriodIterator(Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[7].toString()), Integer.valueOf(obj[8].toString()), Integer.valueOf(obj[9].toString()), period_type, periodCollection, isMergeByFiscalPeriod);
                while (it.hasNext()) {
                    SimplePeriod period = it.next();
                    pStmt.setString(1, obj[1].toString());
                    pStmt.setString(2, ((Variant)obj[4]).getValue().toString());
                    pStmt.setString(3, period.generateID());
                    pStmt.setInt(4, 1);
                    String dyItemNumber = (String)((Variant)obj[5]).getValue();
                    String[] dyNumberArr = dyItemNumber.split(";");
                    for (int j2 = 0; j2 < dyNumberArr.length; ++j2) {
                        String dyNumber = dyNumberArr[j2];
                        pStmt.setString(5 + j2, dyNumber);
                    }
                    int init = 5 + dyNumberArr.length;
                    for (int j3 = 0; j3 < dataEle.size(); ++j3) {
                        String temp = obj[11].toString();
                        if (j3 == (Integer)dataEle.get(temp)) {
                            pStmt.setBigDecimal(init + j3, (BigDecimal)row.getValue());
                            continue;
                        }
                        pStmt.setObject(init + j3, null);
                    }
                    pStmt.addBatch();
                }
            }
            pStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)pStmt, (Connection)con);
        }
        List asstList = (List)params.getObject("ASST");
        StringBuffer updateHgSql = new StringBuffer();
        updateHgSql.append(" update ");
        updateHgSql.append(tableName);
        updateHgSql.append(" set ");
        updateHgSql.append(" FFCslRptAssistantHGID = (");
        updateHgSql.append(" select top 1 hg.fid from T_CSL_CslRptAssistantHG hg ");
        for (AsstActTypeInfo asstActTypeInfo : asstList) {
            updateHgSql.append(" inner join ").append(asstActTypeInfo.getRealtionDataObject());
            updateHgSql.append(" AsstActType").append(asstActTypeInfo.getNumber());
            updateHgSql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName());
            updateHgSql.append(" = AsstActType").append(asstActTypeInfo.getNumber()).append(".FID");
        }
        updateHgSql.append(" where 1 = 1");
        int index = 0;
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        String cuID = localInstance.getCurrentCtrlUnit().getId().toString();
        String comID = localInstance.getCurrentCompany().getId().toString();
        for (AsstActTypeInfo asstActTypeInfo : asstList) {
            String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
            String asstActTypeNumber = asstActTypeInfo.getNumber();
            updateHgSql.append(" and ").append(tableName).append(".FDItem").append(index++).append("Number");
            updateHgSql.append(" = ");
            updateHgSql.append(" '").append(asstActTypeNumber).append("' || '|' || ");
            updateHgSql.append(" AsstActType").append(asstActTypeNumber).append(numberOrLongNumber);
            updateHgSql.append(" and AsstActType").append(asstActTypeNumber).append(".FControlUnitID = '");
            updateHgSql.append(cuID).append("' \r\n");
            String asstType = asstActTypeInfo.getAsstHGAttribute();
            if (asstType.equals("companyOrg")) {
                updateHgSql.append(" and AsstActType").append(asstActTypeNumber).append(".FID = '");
                updateHgSql.append(comID).append("' \r\n");
                continue;
            }
            if (asstType.equals("customer")) {
                updateHgSql.append(" and ( AsstActType").append(asstActTypeNumber).append(".FIsInternalCompany = 0 ");
                updateHgSql.append(" or AsstActType").append(asstActTypeNumber).append(".FInternalCompanyID = '");
                updateHgSql.append(comID).append("' )\r\n");
                continue;
            }
            if (!asstType.equals("provider")) continue;
            updateHgSql.append(" and ( AsstActType").append(asstActTypeNumber).append(".FIsInternalCompany = 0 ");
            updateHgSql.append(" or AsstActType").append(asstActTypeNumber).append(".FInternalCompanyID = '");
            updateHgSql.append(comID).append("' )\r\n");
        }
        updateHgSql.append(" and hg.FCount = ").append(index).append(" \r\n");
        updateHgSql.append(" )");
        DbUtil.execute((Context)ctx, (String)updateHgSql.toString());
        if (3 == (Integer)params.getObject("DATA_SRC_TYPE")) {
            this.updateMultiCslElimRptData2Temp(tableName, ctx, params);
        }
        sql = new StringBuffer("SELECT FOrgUnitID, FItemNumber, ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"18_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) + (System.currentTimeMillis() - b)));
        for (i = 0; i < map.size(); ++i) {
            sql.append("FDItem");
            sql.append(i);
            sql.append("Number,");
        }
        sql.append(" FYearPeriod, FDATATYPE ");
        for (i = 0; i < iSize; ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i);
            sql.append(",SUM(F").append(dataElementInfo.getNumber());
            sql.append(" - ISNULL(F").append(dataElementInfo.getNumber()).append("Elim,0)) AS F").append(dataElementInfo.getNumber());
        }
        sql.append(" FROM ").append(tableName).append(" GROUP BY FOrgUnitID, FItemNumber,");
        for (i = 0; i < map.size(); ++i) {
            sql.append("FDItem");
            sql.append(i);
            sql.append("Number,");
        }
        sql.append(" FYearPeriod, FDATATYPE ");
        return sql.toString();
    }

    private void updateMultiCslElimRptData2Temp(String tableName, Context ctx, RptParams params) throws BOSException, EASBizException {
        List<String> unitIDs;
        String treeId = (String)params.getObject("ORG_TREE_ID");
        String unitId = (String)params.getObject("ORG_UNIT_ID");
        int startYear = params.getInt("START_YEAR");
        int endyear = params.getInt("END_YEAR");
        int startperiod = params.getInt("START_PERIOD");
        int endperiod = params.getInt("END_PERIOD");
        int period_type = params.getInt("PERIOD_TYPE");
        if (StringUtils.isEmpty((String)treeId) || StringUtils.isEmpty((String)unitId)) {
            return;
        }
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(ctx, treeId);
        if (MergeModeEnum.DIRECT.equals((Object)mergeMode)) {
            unitIDs = Arrays.asList(unitId);
        } else {
            unitIDs = this.getDirectLevelUnitIDs(ctx, treeId, unitId, true);
            unitIDs.add(unitId);
        }
        SQLBuilder updateSql = new SQLBuilder();
        List fetchtype = (List)params.getObject("FETCH_TYPE");
        List asstList = (List)params.getObject("ASST");
        List datatype = (List)params.getObject("DATA_TYPE");
        for (int i = 0; i < fetchtype.size(); ++i) {
            DataElementInfo dataElementInfo = (DataElementInfo)fetchtype.get(i);
            for (int l = 0; l < datatype.size(); ++l) {
                updateSql.append(" update ");
                updateSql.append(tableName);
                updateSql.append(" set ");
                updateSql.append(" F").append(dataElementInfo.getNumber()).append("Elim");
                updateSql.append(" = (");
                updateSql.append(" select sum(ISNULL(itemDataEntry.fvalue,0)) ");
                updateSql.append(" from T_CSL_MultiDynaItemData ItemData           ");
                updateSql.append(" inner join T_CSL_MultiDynaItemDataEntry ItemDataEntry on ItemData.FID = ItemDataEntry.FItemDataID  ");
                updateSql.append(" inner join T_CSL_RptReceived RptReceived on ItemData.FReportID =  RptReceived.FReportID  ");
                updateSql.append(" inner join T_CSL_CslRptAssistantHG hg on hg.FID = ItemDataEntry.FCslRptAssistantHGId   ");
                updateSql.append(" inner join T_CSL_RptItem rptitem on rptitem.fnumber=ItemDataEntry.FitemId \t");
                updateSql.append(" inner join T_BD_Currency currency on currency.fid = itemData.fcurrencyId ");
                updateSql.append(" inner join T_ORG_BaseUnit unit on unit.fid = ItemData.FOrgUnitId ");
                updateSql.append(" inner join T_ORG_BaseUnit dunit on dunit.fid = ItemDataEntry.FDetailCompanyId ");
                int size = asstList.size();
                for (int j = 0; j < size; ++j) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstList.get(j);
                    updateSql.append(" inner join ").append(asstActTypeInfo.getRealtionDataObject()).append(" AsstActType").append(asstActTypeInfo.getNumber());
                    updateSql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName()).append(" = AsstActType").append(asstActTypeInfo.getNumber()).append(".FID");
                }
                updateSql.append(" where unit.Fid in ", unitIDs);
                updateSql.append(" and ItemData.FDataSource in (45) ");
                int index = 0;
                for (AsstActTypeInfo asstActTypeInfo : asstList) {
                    String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                    String asstActTypeNumber = asstActTypeInfo.getNumber();
                    updateSql.append(" and ").append(tableName).append(".FDItem").append("" + index++).append("Number");
                    updateSql.append(" = ");
                    updateSql.append(" '").append(asstActTypeNumber).append("' || '|' || ");
                    updateSql.append(" AsstActType").append(asstActTypeNumber).append(numberOrLongNumber);
                }
                updateSql.append(" and ItemDataEntry.FDataElement = ? ", (Object)dataElementInfo.getInterSeq());
                updateSql.append(" and itemData.Fyear >= ? ", (Object)startYear);
                updateSql.append(" and itemData.Fyear <= ? ", (Object)endyear);
                updateSql.append(" and itemData.FPeriod >= ? ", (Object)startperiod);
                updateSql.append(" and itemData.FPeriod <= ? ", (Object)endperiod);
                updateSql.append(" and itemData.FPeriodType <= ? ", (Object)period_type);
                updateSql.append(" and currency.Fnumber = ? ", (Object)params.getString("CURRENCY"));
                updateSql.append(" and rptitem.FNumber = ").append(tableName).append(".FItemNumber \r\n");
                updateSql.append(" and ").append(tableName).append(".FOrgUnitID = dunit.Fnumber \n");
                updateSql.append(" and ItemDataEntry.FValueType = ").append(tableName).append(".FDATATYPE");
                updateSql.append(" and itemdataEntry.fvalueType = ? ", (Object)((ValueTypeEnum)((Object)datatype.get(l))));
                updateSql.append(" group by ItemDataEntry.FDetailCompanyId,rptItem.FNumber");
                updateSql.append(" )  ");
                updateSql.append(" where FDATATYPE = ? ", (Object)((ValueTypeEnum)((Object)datatype.get(l))));
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])updateSql.getParams());
                updateSql.reset();
            }
        }
    }

    private List<String> getDirectLevelUnitIDs(Context ctx, String treeId, String parentUnitId, boolean isOnlyUnit) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        SQLBuilder sql = new SQLBuilder(100);
        sql.append(" select sub.funitid OrgID from t_org_Structure sub       \n").append(" join t_org_baseunit unit on sub.funitid = unit.fid \n").append(" join t_org_Structure s on sub.fparentId = s.fid    \n").append(" where s.FtreeId = ? ", (Object)treeId).append(" and s.FUnitId =? ", (Object)parentUnitId).append(" and unit.FIsGrouping = ? ", (Object)(isOnlyUnit ? 1 : 0));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sql.getParams());
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("OrgID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private static List getResult(List list) {
        List result = null;
        List tempResult = null;
        if (list.size() == 1) {
            return RptMultiCslAnalysisFacadeControllerBean.getResult((List)list.get(0), null);
        }
        Iterator it = list.iterator();
        if (it.hasNext()) {
            ArrayList l = (ArrayList)it.next();
            it.remove();
            for (int i = 0; i < l.size(); ++i) {
                if (list.size() == 1) {
                    if (result == null) {
                        result = RptMultiCslAnalysisFacadeControllerBean.getResult((ArrayList)list.get(0), ((DynaItemInfo)l.get(i)).getDitemNumber());
                        continue;
                    }
                    result.addAll(RptMultiCslAnalysisFacadeControllerBean.getResult((ArrayList)list.get(0), ((DynaItemInfo)l.get(i)).getDitemNumber()));
                    continue;
                }
                --i;
                tempResult = RptMultiCslAnalysisFacadeControllerBean.getResult(list);
                list = new ArrayList<List>();
                list.add(tempResult);
            }
        }
        return result;
    }

    private static List getResult(List list, String s) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String dynaNumber;
            Object o = list.get(i);
            if (o instanceof String) {
                dynaNumber = (String)o;
            } else {
                DynaItemInfo temp = (DynaItemInfo)list.get(i);
                dynaNumber = temp.getDitemNumber();
            }
            if (s != null) {
                l.add(s + ";" + dynaNumber);
                continue;
            }
            l.add(dynaNumber);
        }
        return l;
    }

    private String makeMdx(boolean singlePeriod, boolean singleOrg, boolean show_org_sum, boolean show_period_sum, RptParams params, Context ctx) {
        boolean showTypeSum = params.getBoolean("SHOW_TYPE_SUM");
        boolean showSumUp = params.getBoolean("SHOW_SUM_UP");
        Map map = (Map)params.getObject("DITEMS");
        StringBuffer sb = new StringBuffer();
        if (!singlePeriod && show_period_sum) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"7_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (!singleOrg && show_org_sum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"8_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        }
        if (showTypeSum) {
            if (sb.length() < 1) {
                sb.append("With ");
            }
            for (int i = 0; i < map.values().size(); ++i) {
                sb.append("  Member [DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"19_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(i).append("].members)' ");
            }
        }
        List data_type = (List)params.getObject("DATA_TYPE");
        sb.append("SELECT ");
        if (showSumUp) {
            sb.append(singlePeriod ? "" : "{" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"20_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "Period.Members}*");
        } else {
            sb.append(singlePeriod ? "" : "{Period.Members" + (show_period_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"10_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*");
        }
        sb.append("Item.Members*Measures.Members");
        if (data_type.size() > 1) {
            sb.append("* DataType.Members");
        }
        sb.append(" ON COLUMNS, non empty(");
        if (showSumUp) {
            sb.append(singleOrg ? "" : "{" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"21_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "Orgs.Members}*");
        } else {
            sb.append(singleOrg ? "" : "{Orgs.Members" + (show_org_sum ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"9_RptCellAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()) : "") + "}*");
        }
        for (int i = 0; i < map.values().size(); ++i) {
            if (i != 0) {
                sb.append("*");
            }
            sb.append("{");
            if (showTypeSum && showSumUp) {
                sb.append("[DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"22_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            }
            sb.append("DItem").append(i).append(".Members");
            if (showTypeSum && !showSumUp) {
                sb.append(",[DItem").append(i).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"23_RptMultiCslAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            }
            sb.append("}");
        }
        sb.append(") ON ROWS FROM Fact");
        return sb.toString();
    }
}

