/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SimplePeriod {
    public int period;
    public int year;
    public int period_type;
    public PeriodCollection periodCollection;
    public boolean isMergeByFiscalPeriod;

    public SimplePeriod(int year, int period, int period_type, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod) {
        this.year = year;
        this.period = period;
        this.period_type = period_type;
        this.periodCollection = periodCollection;
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
    }

    public Date toSQLDate() {
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)this.period_type))) {
            return FiscalPeriodHelper.getPeriodLastDate(this.periodCollection, this.year, this.period, RptPeriodTypeEnum.getEnum((int)this.period_type), this.isMergeByFiscalPeriod);
        }
        Calendar cc = Calendar.getInstance();
        cc.clear();
        switch (this.period_type) {
            case 6: {
                cc.set(1, this.year + 1);
                cc.set(2, 11);
                cc.set(5, 31);
                cc.add(-1, 6);
                break;
            }
            case 1: {
                cc.set(1, this.year);
                cc.set(6, this.period);
                break;
            }
            case 2: {
                cc.set(1, this.year);
                cc.set(3, this.period);
                break;
            }
            case 3: {
                cc.set(1, this.year);
                int iperiod = this.period;
                if (iperiod > 12) {
                    iperiod = 12;
                }
                cc.set(2, iperiod - 1);
                break;
            }
            case 4: {
                cc.set(1, this.year);
                break;
            }
        }
        return cc.getTime();
    }

    public String generateID() {
        return RptBiUtil.generatePeriodID(this.year, this.period);
    }

    public String toString() {
        String p = null;
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        switch (this.period_type) {
            case 6: {
                p = "";
                break;
            }
            case 1: {
                Calendar cc = Calendar.getInstance();
                cc.set(1, this.year);
                cc.set(6, this.period);
                String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"4_SimplePeriod", (Locale)locale);
                p = MessageFormat.format(msg, cc.get(2) + 1, cc.get(5));
                break;
            }
            case 2: {
                p = this.period + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"789_SimplePeriod", (Locale)locale);
                break;
            }
            case 3: {
                p = this.period + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"786_ExtractItemDataUI", (Locale)locale);
                break;
            }
            case 4: {
                p = this.period + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"89_SimplePeriod", (Locale)locale);
                break;
            }
            case 5: {
                p = this.period == 1 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"90_SimplePeriod", (Locale)locale) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"91_SimplePeriod", (Locale)locale);
            }
        }
        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"5_SimplePeriod", (Locale)locale);
        return MessageFormat.format(msg, this.year + "", p);
    }

    public boolean isMergeByFiscalPeriod() {
        return FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)this.period_type)) && this.periodCollection != null;
    }

    public SimplePeriod getLastYear() {
        int minYear;
        if (this.isMergeByFiscalPeriod() && this.year <= (minYear = this.periodCollection.get(0).getPeriodYear())) {
            return null;
        }
        return new SimplePeriod(this.year - 1, this.period, this.period_type, this.periodCollection, this.isMergeByFiscalPeriod);
    }

    public SimplePeriod getLastPeriod(Context ctx) {
        if (this.isMergeByFiscalPeriod()) {
            int[] perYearAndPeriod = FiscalPeriodHelper.getPerYearAndPeriod(this.year, this.period, RptPeriodTypeEnum.getEnum((int)this.period_type), this.periodCollection, this.isMergeByFiscalPeriod, false);
            if (perYearAndPeriod == null) {
                return null;
            }
            return new SimplePeriod(perYearAndPeriod[0], perYearAndPeriod[1], this.period_type, this.periodCollection, this.isMergeByFiscalPeriod);
        }
        int y = 0;
        int p = 0;
        if (this.period_type == 6) {
            p = this.period;
            --y;
        } else if (this.period_type == 5) {
            if (this.period == 2) {
                p = 1;
                y = this.year;
            } else {
                p = 2;
                y = this.year - 1;
            }
        } else if (this.period_type == 4) {
            if (this.period == 1) {
                p = 4;
                y = this.year - 1;
            } else {
                p = this.period - 1;
                y = this.year;
            }
        } else if (this.period_type == 3) {
            if (this.period == 1) {
                p = CslRptUtil.isSupport13Period(ctx) ? 13 : 12;
                y = this.year - 1;
            } else {
                p = this.period - 1;
                y = this.year;
            }
        }
        return new SimplePeriod(y, p, this.period_type, this.periodCollection, this.isMergeByFiscalPeriod);
    }
}

