/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Point;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataRepairUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil");
    private static final String TEMPLATE_DISPENSE = " Create Table T_CSL_TempletDispense ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FCompanyID VARCHAR(44),FOrgBoundID VARCHAR(44) NOT NULL ,FSourceType INT DEFAULT 1 NOT NULL ,FDispenseSrcID VARCHAR(44) NOT NULL ,FIsAllowChgTemplet INT DEFAULT 0 NOT NULL ,FIsCoverTmpFormula INT DEFAULT 0 NOT NULL ,FIsCoverFormula INT DEFAULT 0,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FIsAllowChgSol INT DEFAULT 0)";

    public static void syncReportAndCslReport(List reportList) throws Exception {
        if (reportList == null) {
            return;
        }
        if (reportList.isEmpty()) {
            return;
        }
        ICslReport icslreport = CslReportFactory.getRemoteInstance();
        IReport ireport = ReportFactory.getRemoteInstance();
        int size = reportList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)reportList.get(i);
            if (StringUtils.isEmpty((String)id)) continue;
            CslReportInfo cslreport = icslreport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            if (!ireport.exists("where company.id='" + cslreport.getCompany().getId().toString() + "' and template.id='" + cslreport.getTemplate().getId().toString() + "' and year=" + cslreport.getYear() + " and period=" + cslreport.getPeriod() + " and periodtype=" + cslreport.getPeriodType().getValue() + " and currency.id='" + cslreport.getCurrency().getId().toString() + "' and sourceCurrency.id='" + cslreport.getSourceCurrency().getId().toString() + "' and dataCollectNumber='" + cslreport.getDataCollectNumber() + "'")) continue;
            ReportInfo temp = ireport.getReportInfo("select id where isSupportGroup=1 and company.id='" + cslreport.getCompany().getId().toString() + "' and template.id='" + cslreport.getTemplate().getId().toString() + "' and year=" + cslreport.getYear() + " and period=" + cslreport.getPeriod() + " and periodtype=" + cslreport.getPeriodType().getValue() + " and currency.id='" + cslreport.getCurrency().getId().toString() + "' and sourceCurrency.id='" + cslreport.getSourceCurrency().getId().toString() + "' and dataCollectNumber='" + cslreport.getDataCollectNumber() + "'");
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("savePoint.*"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)temp.getId().toString()));
            ReportCollection collect = ireport.getReportCollection(view);
            ReportInfo report = collect.get(0);
            if (cslreport.getAuditedStatus().getValue() == report.getAuditedStatus().getValue() && cslreport.getCommittedStatus().getValue() == report.getCommittedStatus().getValue()) continue;
            report.setAuditedStatus(cslreport.getAuditedStatus());
            report.setAuditor(cslreport.getAuditor());
            report.setAuditTime(cslreport.getAuditTime());
            report.setCommittedStatus(cslreport.getCommittedStatus());
            report.setCommitTime(cslreport.getCommitTime());
            ireport.update((IObjectPK)new ObjectUuidPK(report.getId()), (ReportBaseInfo)report, false);
        }
    }

    public static void clearRptReceivedForDuplicateItem(Context ctx) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete t_csl_rptreceived where fid IN ( \r\n");
        sql.append(" select t1.fid \r\n");
        sql.append(" from t_csl_rptreceived t1 \r\n");
        sql.append(" join t_csl_cslreport t2 on t1.freportid=t2.fid \r\n");
        sql.append(" join t_org_tree t3 on t1.forgtreeid=t3.fid \r\n");
        sql.append(" where t2.freportdate<t3.fstartdate or t2.freportdate>isnull(t3.fenddate,TO_Date('2100-01-01'))) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void dealWithCslReportInfo(Context ctx, ReportInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)info.getPeriodType()));
        if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.DAILY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("startDate", (Object)info.getStartDate()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)info.getEndDate()));
        } else if (info.getPeriodType().equals((Object)RptPeriodTypeEnum.YEARLY)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
            view.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Short(info.getPeriod())));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)info.getTemplate().getGroup()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("isCommitReport", (Object)Boolean.TRUE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("committedStatus", (Object)CommittedStatusEnum.GROUPCOMMITTED, CompareType.NOTEQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber(), CompareType.EQUALS));
        SelectorItemCollection sitem = view.getSelector();
        ICslReport icsl = CslReportFactory.getLocalInstance(ctx);
        sitem.add("id");
        ReportBaseCollection c = icsl.getReportBaseCollection(view);
        for (int i = 0; i < c.size(); ++i) {
            String cslid = ((CslReportInfo)c.get(i)).getId().toString();
            if (!icsl.exists((IObjectPK)new ObjectUuidPK(cslid)) || ReportFactory.getLocalInstance((Context)ctx).exists("select id where cslreport.id = '" + cslid + "'")) continue;
            icsl.delete((IObjectPK)new ObjectUuidPK(cslid));
        }
    }

    public static void fixItemDataEntryTable(Context ctx, List tableNames) throws BOSException {
        for (int i = 0; i < tableNames.size(); ++i) {
            Variant variant;
            String tableName = (String)tableNames.get(i);
            if (DataRepairUtil.isTableExist(ctx, tableName)) continue;
            String s = tableName.substring(tableName.length() - 3, tableName.length());
            if (s.startsWith("0")) {
                s = s.substring(1);
            }
            if (s.startsWith("0")) {
                s = s.substring(1);
            }
            if (!(variant = new Variant((Object)Integer.valueOf(s))).isNumber()) continue;
            try {
                int seq = variant.intValue();
                DataRepairUtil.createItemDataEntryTable(ctx, tableName, seq);
                continue;
            }
            catch (SyntaxErrorException e) {
                // empty catch block
            }
        }
    }

    public static boolean isTableExist(Context ctx, String tableName) throws BOSException {
        String sql = "select 1 from KSQL_USERTABLES where KSQL_TABNAME = '" + tableName + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet.size() > 0;
    }

    private static void createItemDataEntryTable(Context ctx, String strTableName, int seq) throws BOSException {
        if (DataRepairUtil.isTableExist(ctx, strTableName)) {
            return;
        }
        String strSeq = seq < 10 ? "00" + seq : (seq < 100 ? "0" + seq : String.valueOf(seq));
        seq = (seq - 1) * 300 + 1;
        StringBuffer strSql = new StringBuffer();
        strSql.append("Create Table " + strTableName + "(FID CHAR(36) NOT NULL");
        for (int i = 0; i < 300; ++i) {
            strSql = strSql.append(",F" + (i + seq) + " NUMERIC(21,6)");
        }
        strSql = strSql.append(",CONSTRAINT PK_CSL_ItmDtEty" + strSeq + " PRIMARY KEY (FID))");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
        strSql.delete(0, strSql.length());
        Uuid uuid = Uuid.create();
        strSql.append("select FTableName from ").append("T_CSL_ItemDataTable");
        strSql.append(" where FTableName = '").append(strTableName).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        if (rowSet.size() == 0) {
            strSql.append("Insert Into T_CSL_ItemDataTable(FID,FTableName) Values('" + uuid.toString() + "','" + strTableName + "')");
            DbUtil.execute((Context)ctx, (String)strSql.toString());
        }
    }

    public static boolean clearExcrescentTemplateDispenseRecord(Context ctx, String srcTemplateID) throws BOSException {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(FID), FCompanyID, FOrgBoundID ");
        sql.append(" from T_CSL_TempletDispense ");
        sql.append(" where FdispenseSrcID = ? ");
        sql.append(" group by FCompanyID, FOrgBoundID ");
        sql.append(" having count(FID) > 1 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{srcTemplateID});
        try {
            if (rowSet.next()) {
                flag = true;
                TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
                String tableName = tempTablePool.createTempTable(TEMPLATE_DISPENSE);
                sql.setLength(0);
                sql.append(" insert into ").append(tableName);
                sql.append(" (FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCOMPANYID,FORGBOUNDID,FSOURCETYPE,FDISPENSESRCID,FISALLOWCHGTEMPLET,FISCOVERTMPFORMULA,FCONTROLUNITID,FISALLOWCHGSOL,FISCOVERFORMULA) ");
                sql.append("  select FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCOMPANYID,FORGBOUNDID,FSOURCETYPE,FDISPENSESRCID,FISALLOWCHGTEMPLET,FISCOVERTMPFORMULA,FCONTROLUNITID,FISALLOWCHGSOL,FISCOVERFORMULA from t_Csl_Templetdispense t where t.fid in ( ");
                sql.append(" \tselect max(t2.fid) from t_Csl_Templetdispense t2 where ");
                sql.append(" \tt2.fdispensesrcid = ? ");
                sql.append(" \tgroup by t2.fcompanyid,t2.forgboundid ) ");
                sql.append(" and t.fdispensesrcid = ? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{srcTemplateID, srcTemplateID});
                sql.setLength(0);
                sql.append(" delete from t_Csl_Templetdispense where fdispensesrcid = ? ");
                TemplateDispenseNewUtil.deleteFromDispense((Context)ctx, (String)sql.toString(), (Object[])new Object[]{srcTemplateID});
                sql.setLength(0);
                sql.append(" insert into t_Csl_Templetdispense ( FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCOMPANYID,FORGBOUNDID,FSOURCETYPE,FDISPENSESRCID,FISALLOWCHGTEMPLET,FISCOVERTMPFORMULA,FCONTROLUNITID,FISALLOWCHGSOL,FISCOVERFORMULA ) ");
                String insertPartSql = sql.toString();
                sql.setLength(0);
                sql.append(" select FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCOMPANYID,FORGBOUNDID,FSOURCETYPE,FDISPENSESRCID,FISALLOWCHGTEMPLET,FISCOVERTMPFORMULA,FCONTROLUNITID,FISALLOWCHGSOL,FISCOVERFORMULA  from ").append(tableName);
                String selectPartSql = sql.toString();
                TemplateDispenseNewUtil.insertIntoDispense((Context)ctx, (String)insertPartSql, (String)selectPartSql, null);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                tempTablePool.releaseTable(tableName);
            }
        }
        catch (Exception e) {
            TemplateDispenseNewUtil.repaireDispense((Context)ctx);
            throw new BOSException((Throwable)e);
        }
        return flag;
    }

    public static Map removeRepeatedHG(Context ctx, Map repeatMap) throws BOSException {
        HashMap result = new HashMap();
        for (Map.Entry entry : repeatMap.entrySet()) {
            List idList = (List)entry.getValue();
            if (idList == null || idList.size() <= 0) continue;
            if (idList.size() == 1) {
                result.put(entry.getKey(), idList.get(0));
                continue;
            }
            StringBuffer sql = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            sql.append(" select FID from  T_CSL_CslRptAssistantHG where FID in ");
            sql.append(RptUtilForServer.createInSql(idList.iterator(), params));
            sql.append(" order by FCreateTime ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            String firstID = null;
            ArrayList<String> deleteList = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    if (firstID == null) {
                        firstID = rowSet.getString("FID");
                        continue;
                    }
                    deleteList.add(rowSet.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            result.put(entry.getKey(), firstID);
            if (deleteList.size() <= 0) continue;
            sql.setLength(0);
            params.clear();
            sql.append(" update T_CSL_MultiDynaItemDataEntry Set FCslRptAssistantHGId = ? where FCslRptAssistantHGId in ");
            params.add(firstID);
            sql.append(RptUtilForServer.createInSql(deleteList.iterator(), params));
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            sql.setLength(0);
            params.clear();
            sql.append(" delete from T_CSL_CslRptAssistantHG where FID in  ");
            sql.append(RptUtilForServer.createInSql(deleteList.iterator(), params));
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
        return result;
    }

    public static void repairDynGradeParamByActualTableData(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        Point basePoint2 = null;
        block0: for (Point basePoint2 : basePointList) {
            int i;
            int index;
            int lastDItemRow;
            int defaultCounter;
            Range range;
            DynaParameters param;
            int y = basePoint2.y;
            int x = basePoint2.x;
            Range basePointRange = sheet.getRange(y, x);
            if (basePointRange == null || (param = DynamicTemplateUtility.getDynaParametersFromCell((Range)basePointRange)) == null) continue;
            int spreadStyle = param.getSpreadStyle();
            int col = 0;
            int start = 0;
            int max = 0;
            if (spreadStyle == 0) {
                col = x + 1;
                start = y + 1;
                max = sheet.getRows().getMaxIntMark() + 1;
                range = null;
                defaultCounter = param.getDefaultCounter();
                lastDItemRow = 0;
                index = 0;
                for (i = start; i < max; ++i) {
                    ItemFormula f;
                    if (DynamicTemplateUtility.isBasePointCell((Sheet)sheet, (int)i, (int)x)) {
                        index = param.getDefaultCounter() + start - 1;
                        int n = index = param.isIncludeSum() ? index + 1 : index;
                        if (index >= i) {
                            int rowCount = lastDItemRow - start + 1;
                            if (param.isIncludeSum() && param.getPosition() == 1) {
                                --rowCount;
                            }
                            if (rowCount == defaultCounter || rowCount < 0) continue block0;
                            param.setDefaultCounter(rowCount);
                            DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)basePointRange), (DynaParameters)param);
                            continue block0;
                        }
                    }
                    if ((f = (ItemFormula)(range = sheet.getRange(i, col)).getUserObject("ITEM")) == null || StringUtils.isEmpty((String)f.getFormula())) continue;
                    lastDItemRow = i;
                }
                continue;
            }
            col = y + 1;
            start = x + 1;
            max = sheet.getCols().getMaxIntMark() + 1;
            range = null;
            defaultCounter = param.getDefaultCounter();
            lastDItemRow = 0;
            index = 0;
            for (i = start; i < max; ++i) {
                ItemFormula f;
                if (DynamicTemplateUtility.isBasePointCell((Sheet)sheet, (int)x, (int)i)) {
                    index = param.getDefaultCounter() + start - 1;
                    int n = index = param.isIncludeSum() ? index + 1 : index;
                    if (index >= i) {
                        int rowCount = lastDItemRow - start + 1;
                        if (param.isIncludeSum() && param.getPosition() == 1) {
                            --rowCount;
                        }
                        if (rowCount == defaultCounter || rowCount < 0) continue block0;
                        param.setDefaultCounter(rowCount);
                        DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)basePointRange), (DynaParameters)param);
                        continue block0;
                    }
                }
                if ((f = (ItemFormula)(range = sheet.getRange(col, i)).getUserObject("ITEM")) == null || StringUtils.isEmpty((String)f.getFormula())) continue;
                lastDItemRow = i;
            }
        }
    }

    public static int repairReport(List cslRptIds, Map repairOptions) throws Exception {
        if (cslRptIds == null || cslRptIds.isEmpty()) {
            return 0;
        }
        boolean isRepairState = false;
        boolean isSynCslRptDatatToRpt = false;
        if (repairOptions.containsKey("repairState")) {
            isRepairState = (Boolean)repairOptions.get("repairState");
        }
        if (repairOptions.containsKey("synCslRptDatatToRpt")) {
            isSynCslRptDatatToRpt = (Boolean)repairOptions.get("synCslRptDatatToRpt");
        }
        IReport ireport = ReportFactory.getRemoteInstance();
        EntityViewInfo rptView = new EntityViewInfo();
        rptView.getSelector().add(new SelectorItemInfo("*"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.AuditedStatus"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.Auditor"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.AuditTime"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.CommittedStatus"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.CommitTime"));
        rptView.getSelector().add(new SelectorItemInfo("cslReport.data"));
        rptView.setFilter(new FilterInfo());
        rptView.getFilter().getFilterItems().add(new FilterItemInfo("CslReport.id", new HashSet(cslRptIds), CompareType.INCLUDE));
        ReportCollection rpts = ireport.getReportCollection(rptView);
        CoreBaseCollection resultRpts = new CoreBaseCollection();
        for (int i = 0; i < rpts.size(); ++i) {
            ReportInfo rptInfo = rpts.get(i);
            CslReportInfo cslRptInfo = rptInfo.getCslReport();
            if (isRepairState) {
                rptInfo.setAuditedStatus(cslRptInfo.getAuditedStatus());
                rptInfo.setAuditor(cslRptInfo.getAuditor());
                rptInfo.setAuditTime(cslRptInfo.getAuditTime());
                rptInfo.setCommittedStatus(cslRptInfo.getCommittedStatus());
                rptInfo.setCommitTime(cslRptInfo.getCommitTime());
            }
            if (isSynCslRptDatatToRpt) {
                rptInfo.setData(cslRptInfo.getData());
            }
            resultRpts.add((CoreBaseInfo)rptInfo);
        }
        ireport.updateBatchData(resultRpts);
        return resultRpts.size();
    }
}

