/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import bsh.ParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.BackedReportFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaKeyAndValue;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptCompanyRela;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptCompanyRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CslReportSave;
import com.kingdee.eas.fi.gr.cslrpt.app.SumRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaRptCalcServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptStyle;
import com.kingdee.eas.fi.gr.cslrpt.util.DyRptSaveHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.ClearUpBook;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviserImpl;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.ExistNoReceRptSelectCalcEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.rpt.CSLCommentsCollection;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.sqlUtil.SqlResultFillter;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SumRptCalcAssist {
    private static Logger logger = Logger.getLogger(SumRptCalcAssist.class);
    private Context ctx;
    private DynaSumMethodEnum sumMethod;
    private Boolean isBySumReport;
    private CslReportInfo curReport;
    private Book curSheets;
    private boolean isShowTotal;
    private int displayNumber;
    private boolean isByTemplate;
    private boolean isOnlyListCompany;
    private boolean isOnlyList;
    private Vector companys;
    private Vector companyNumbers;
    private List companyIdsList;
    private boolean isDynaSum = false;
    private int sumType;
    private Book tmpBook;
    private Map bookStyleMapForGrade = null;
    private Map bookStyleMap = null;
    private static final Color lightblue = new Color(153, 204, 255);
    public static final char DONE = '\u0000';
    private AdjustCollection adjustCol;
    private Map relateParamMap;
    private int createRptStrategy = 1;
    private ICslReport iCslReport = null;

    public SumRptCalcAssist(Context ctx, DynaSumMethodEnum sumMethod, Boolean isBySumReport, CslReportInfo curReport, Book curSheets, boolean isShowTotal, int displayNumber, boolean isByTemplate, boolean isOnlyListCompany, boolean isOnlyList, AdjustCollection adjustCol, int createRptStrategy) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.sumMethod = sumMethod;
        this.isBySumReport = isBySumReport;
        this.curReport = curReport;
        this.curSheets = curSheets;
        this.isShowTotal = isShowTotal;
        this.displayNumber = displayNumber;
        this.isByTemplate = isByTemplate;
        this.isOnlyListCompany = isOnlyListCompany;
        this.isOnlyList = isOnlyList;
        this.adjustCol = adjustCol;
        this.createRptStrategy = createRptStrategy;
        this.initData();
    }

    public SumRptCalcAssist() throws EASBizException, BOSException {
        this.initData();
    }

    public boolean sumAutoCalc(boolean isCalcSingle, Vector selectedCompanys, ExistNoReceRptSelectCalcEnum calcEnum) throws Exception {
        Map ret;
        ICslRptCalculator calculator;
        this.saveSheetStyle(isCalcSingle);
        int sumType = this.getSumType();
        if (selectedCompanys != null && !selectedCompanys.isEmpty()) {
            this.initCompanys(selectedCompanys);
        }
        ICslRptCalculator iCslRptCalculator = calculator = this.ctx == null ? CslRptCalculatorFactory.getRemoteInstance() : CslRptCalculatorFactory.getLocalInstance(this.ctx);
        if (calcEnum == ExistNoReceRptSelectCalcEnum.ABORTCALC && (ret = this.getReSultCheckSumRptRule(calculator)) != null && (Integer)ret.get("noConfirmCount") > 0) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"SUBCOMPANY_RPT_ISNOT_RECEIVE"));
        }
        boolean includeDiffTable = false;
        int precision = CslRptUtil.getPrecisionByCry(this.ctx, this.curReport.getCurrency());
        DynaRptStyle dynaRptStyle = new DynaRptStyle(this.ctx, this.curReport, this.curSheets, this.sumMethod, isCalcSingle);
        dynaRptStyle.getDynaRptStyle();
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            this.dynAMICalc(this.isOnlyListCompany, precision, false);
        } else if (sumType == 2) {
            this.byItemsCalc(precision, this.companyNumbers, includeDiffTable, this.relateParamMap);
        } else if (sumType == 1) {
            ArrayList reportIDs = this.getReportIDs(this.curReport, selectedCompanys);
            if (reportIDs == null || reportIDs.size() == 0) {
                return false;
            }
            this.bySheetsCalc(precision, selectedCompanys, calculator, includeDiffTable, reportIDs, false);
        }
        dynaRptStyle.resetDynaRptStyle();
        this.calcSqlGetData(this.curSheets, this.curReport);
        this.curSheets.calc();
        ClearUpBook clearupbook = new ClearUpBook(this.curSheets, false);
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
            Sheet activeSheet = this.curSheets.getActiveSheet();
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                clearupbook.removeNullLine(sheet);
                clearupbook.removeZeroDynamicRow(sheet, this.curReport.getSourceType(), false);
                clearupbook.sortEveryDynamicItemBySheet(sheet);
                sheet.setSelected(false);
            }
            this.curSheets.setActiveSheet(activeSheet);
        }
        this.curReport.setBook(this.curSheets);
        return true;
    }

    private void calcSqlGetData(Book book, CslReportInfo reportInfo) {
        SqlResultFillter fillter = new SqlResultFillter(this.ctx, book, false, (ReportBaseInfo)reportInfo);
        fillter.fillResult();
    }

    private void removeNullLine(Sheet curSheet) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)curSheet);
        if (null == basePointList || basePointList.size() == 0) {
            return;
        }
        Point basePoint = (Point)basePointList.get(0);
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)curSheet, (Point)basePoint);
        boolean templateisVertical = param.getSpreadStyle() == 0;
        Object[] basePoints = basePointList.toArray();
        if (templateisVertical) {
            Arrays.sort(basePoints, new PointYComparator());
        } else {
            Arrays.sort(basePoints, new PointXComparator());
        }
        Variant cellValue = null;
        Range cell = null;
        boolean bResult = false;
        for (int j = basePoints.length - 1; j >= 0; --j) {
            bResult = false;
            basePoint = (Point)basePoints[j];
            int row = 0;
            int col = 0;
            DynaParameters dynaParameters = DynamicTemplateUtility.getDynaParameters((Sheet)curSheet, (Point)basePoint);
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, curSheet, true, true);
            int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
            for (int i = 0; i < dynaParameters.getDefaultCounter(); ++i) {
                if (templateisVertical) {
                    col = basePoint.x;
                    row = basePoint.y + i + 1 + beforeDynaItemCount;
                } else {
                    row = basePoint.y;
                    col = basePoint.x + i + 1 + beforeDynaItemCount;
                }
                cell = templateisVertical ? UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row, col)) : UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row, col));
                cellValue = cell.getValue();
                if (cellValue != null && !cellValue.toString().trim().equals("")) continue;
                Range range = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(basePoint.y, basePoint.x));
                if (templateisVertical) {
                    int colDel = basePoint.y + i + 1 + beforeDynaItemCount;
                    bResult = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(colDel, colDel)).delete();
                    logger.info((Object)("remove the row" + curSheet.getRowRange(colDel, colDel)));
                } else {
                    int rowDel = basePoint.x + i + 1 + beforeDynaItemCount;
                    bResult = UserObjectHelper.getUnprotectedRange((Range)curSheet.getColRange(rowDel, rowDel)).delete();
                    logger.info((Object)("remove the row" + curSheet.getColRange(rowDel, rowDel)));
                }
                if (!bResult) continue;
                dynaParameters.setDefaultCounter(dynaParameters.getDefaultCounter() - 1);
                DynamicTemplateUtility.saveParametersToCell((Range)range, (DynaParameters)dynaParameters);
                --i;
            }
        }
    }

    public void sumSaveAfterAutoCalc(String rptId) throws Exception {
        try {
            boolean isSaveItemData = true;
            if (this.createRptStrategy == 2) {
                isSaveItemData = false;
            }
            if (this.ctx == null) {
                CslReportFactory.getRemoteInstance().updateCslRpt((IObjectPK)new ObjectUuidPK(this.curReport.getId()), this.curReport, isSaveItemData);
            } else {
                CslReportSave rptSave = new CslReportSave();
                rptSave.update(this.ctx, (IObjectPK)new ObjectUuidPK(this.curReport.getId()), (IObjectValue)this.curReport, isSaveItemData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        CSLCommentsCollection rs = CslRptUtil.getCSLCommentsCollection(this.curReport.getBook());
        if (rs != null) {
            rs.setReportInfo((VirtualSheetParamInfo)this.curReport);
        }
        CslRptUtil.saveCSLItemPostil(this.ctx, rs);
        StringBuffer sb = new StringBuffer("");
        if (this.companys != null) {
            sb = this.copanysVectorToIdStr(this.companys);
        }
        ISumRptRela iSumRptRela = null;
        ISumRptCompanyRela iSumRptCompanyRela = null;
        if (this.ctx == null) {
            iSumRptRela = SumRptRelaFactory.getRemoteInstance();
            iSumRptCompanyRela = SumRptCompanyRelaFactory.getRemoteInstance();
        } else {
            iSumRptRela = SumRptRelaFactory.getLocalInstance(this.ctx);
            iSumRptCompanyRela = SumRptCompanyRelaFactory.getLocalInstance(this.ctx);
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("companyIds", this.companys);
        uiContext.put("DynaSumMethod", (Object)this.sumMethod);
        uiContext.put("isSupportCrossMerger", false);
        uiContext.put("onlyList", this.isOnlyList);
        if (this.curReport.getDynaRptType() == DynaEnumRptTypeEnum.DYNAMIC) {
            SumRptAddedPerportyInfo sumRptAddedPerporty = (this.ctx == null ? SumRptAddedPerportyFactory.getRemoteInstance() : SumRptAddedPerportyFactory.getLocalInstance(this.ctx)).getSumRptAddedPerportyInfo("where report='" + rptId + "'");
            if (sumRptAddedPerporty != null && sumRptAddedPerporty.getIsSupportGroup().equals((Object)IsSupportGroupReportEnum.SUPPORT) && this.curReport.getTemplate().getSumType().getValue() == 2) {
                DyRptSaveHelper.saveDySumRptItemData(this.ctx, this.curReport, this.curSheets != null ? this.curSheets : this.curReport.getBook(), false, false, uiContext);
            }
            if (this.createRptStrategy == 2 && this.curReport.getTemplate().getSumType().getValue() == 2) {
                DyRptSaveHelper.saveDySumRptItemData(this.ctx, this.curReport, this.curReport.getBook(), false, false, uiContext);
            }
        }
        this.allPageCalcDeleteRela(this.companys, iSumRptRela, iSumRptCompanyRela);
        this.deleteNotExistRela();
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.SUM) && this.curReport.getTemplate().getSumType().getValue() == 1) {
            CoreBaseCollection collection = this.getReportRelaColl();
            if (collection.size() != 1) {
                throw new RptWeaveException(CslRptUtil.getString("SumRptProcessSaveNoRelation"));
            }
            CslReportRelaInfo reportRelaInfo = (CslReportRelaInfo)collection.get(0);
            this.sumAllCalcSaveReal(this.curReport, null, iSumRptRela, sb, new HashMap(1), reportRelaInfo);
            if (this.ctx == null) {
                BackedReportFacadeFactory.getRemoteInstance().fixBackReportByCalAllPage(this.curReport.getId().toString());
            } else {
                BackedReportFacadeFactory.getLocalInstance(this.ctx).fixBackReportByCalAllPage(this.curReport.getId().toString());
            }
        } else {
            this.allCalcSaveRela(this.curReport, null, iSumRptRela, sb, new HashMap(1), this.isBySumReport);
        }
    }

    public Map getBookStyleMapForGrade() {
        return this.bookStyleMapForGrade;
    }

    public Map getBookStyleMap() {
        return this.bookStyleMap;
    }

    public Vector getCompanys() {
        return this.companys;
    }

    public Vector getCompanyNumbers() {
        return this.companyNumbers;
    }

    public void initData() throws EASBizException, BOSException {
        this.isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(this.ctx);
        this.iCslReport = this.ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(this.ctx);
    }

    public void initCompanys(Vector vecCompanys) {
        this.companys = new Vector(0);
        this.companyNumbers = new Vector(0);
        this.companyIdsList = new ArrayList(vecCompanys.size());
        for (OrgUnitInfo company : vecCompanys) {
            this.companyNumbers.add(company.getNumber());
            this.companyIdsList.add(company.getId().toString());
            this.companys.add(company);
        }
    }

    public void saveSheetStyle(boolean isCalcSingle) throws Exception {
        this.tmpBook = this.getTemplateBook(this.curReport);
        this.isByTemplate = this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE);
        if (isCalcSingle && this.tmpBook != null) {
            if (!this.isByTemplate) {
                this.bookStyleMapForGrade = DynamicTemplateUtility.getOriginalGradeLineStyle((Sheet)this.tmpBook.getSheet(this.curSheets.getActiveSheetIndex()));
                this.bookStyleMap = DynamicTemplateUtility.getSheetBasePointsFirstLineStyle((Sheet)this.tmpBook.getSheet(this.curSheets.getActiveSheetIndex()));
            }
            DynamicTemplateUtility.clearGradeStyleBySheet((Sheet)this.curSheets.getActiveSheet());
        } else {
            if (!this.isByTemplate) {
                this.bookStyleMapForGrade = DynamicTemplateUtility.getOriginalGradeLineStyle((Book)this.tmpBook);
                this.bookStyleMap = DynamicTemplateUtility.getBookBasePointsFirstLineStyle((Book)this.tmpBook);
            }
            DynamicTemplateUtility.clearGradeStyle((Book)this.curSheets);
        }
    }

    public int getSumType() throws Exception {
        if (this.curReport.getTemplate() == null || this.curReport.getTemplate().getSumType() == null) {
            throw new Exception("SumReport's template information is null!");
        }
        this.sumType = this.curReport.getTemplate().getSumType().getValue();
        return this.sumType;
    }

    public Map getReSultCheckSumRptRule(ICslRptCalculator calculator) throws EASBizException, BOSException {
        HashMap ret = null;
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("report", this.curReport);
        m.put("companys", this.companys);
        if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            m.put("bySumReport", this.isBySumReport);
        } else {
            m.put("bySumReport", Boolean.FALSE);
        }
        ret = calculator.checkSumRptRule(m);
        return ret;
    }

    public void clearSheetData() {
        if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
            if (this.sumType == 1) {
                RptAutoWeaveUtil.clearSheetSumCellData(this.curSheets);
                if (this.isDynaSum) {
                    RptAutoWeaveUtil.clearSheetDynaCellData(this.curSheets);
                }
            } else {
                RptAutoWeaveUtil.clearCellData(this.curSheets, true, false, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dynAMICalc(boolean isOnlyListCompany, int precision, boolean includeDiffTable) throws Exception {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, Object> tableValues = new HashMap<String, Object>();
        DynaSumMethodEnum selectedItem = this.sumMethod;
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            Sheet table = this.curSheets.getSheet(i);
            if (!table.isEnableCalculation()) continue;
            Map tableMap = this.getTableMap(selectedItem, this.isOnlyList, this.isShowTotal, isOnlyListCompany, table);
            DynamicTemplateUtility.setSheetSumMethod((Sheet)table, (DynaSumMethodEnum)selectedItem);
            if (table == null) continue;
            tables.put(table.getID(), table);
            tableValues.put(table.getID(), tableMap);
        }
        ICSLReportCalculator ie = null;
        ie = this.ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(this.ctx);
        Map sumResult = null;
        boolean isSupportRpt = true;
        if (this.createRptStrategy == 2) {
            isSupportRpt = false;
        }
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            sumResult = DynaRptCalcServerHelper._calculateDynaSumRpt(this.ctx, this.curReport.getId().toString(), this.companyIdsList, tableValues, true, false, isSupportRpt);
        } else if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            sumResult = this.calcMultiDynaSumRpt(this.curReport.getId().toString(), this.companyIdsList, tableValues);
        } else if (this.ctx == null) {
            tableValues.put("isSupportRpt", isSupportRpt);
            sumResult = ie.calculateDynaSumRpt(this.curReport.getId().toString(), this.companyIdsList, tableValues, false, includeDiffTable);
        } else {
            sumResult = DynaRptCalcServerHelper._calculateDynaSumRpt(this.ctx, this.curReport.getId().toString(), this.companyIdsList, tableValues, false, includeDiffTable, isSupportRpt);
        }
        if (sumResult != null && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            this.curSheets.setUserObject("sumResult", (Object)sumResult);
        }
        DynaItemListener.setExeFlag((boolean)false);
        if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            DynamicTemplateUtility.clearDynaTableFirst((Book)this.curSheets);
        }
        DynaItemListener.setExeFlag((boolean)false);
        this.curSheets.getUndoManager().startGroup();
        Sheet sheet = null;
        try {
            this.fillDynaData(this.curReport.getSourceType(), tables, tableValues, sumResult, precision);
        }
        finally {
            this.curSheets.getUndoManager().endGroup();
        }
        DynaItemListener.setExeFlag((boolean)true);
        if (this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                sheet = this.curSheets.getSheet(i);
                DataRepairUtil.repairDynGradeParamByActualTableData(sheet);
            }
        }
    }

    public void byItemsCalc(int precision, Vector companyIDs, boolean includeDiffTable) throws BOSException, EASBizException {
        this.byItemsCalc(precision, companyIDs, includeDiffTable, null);
    }

    public void byItemsCalc(int precision, Vector companyIDs, boolean includeDiffTable, Map relateParamMap) throws BOSException, EASBizException {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, Object> tableValues = new HashMap<String, Object>();
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            Sheet table = this.curSheets.getSheet(i);
            if (!table.isEnableCalculation()) continue;
            HashMap tableMap = this.constructTableMap(table);
            if (table == null) continue;
            tables.put(table.getID(), table);
            tableValues.put(table.getID(), tableMap);
        }
        ICSLReportCalculator ie = null;
        ie = this.ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(this.ctx);
        boolean isGroupcommitted = true;
        String fastMergeSoluId = null;
        if (relateParamMap.get("fastMergeSoluId") != null) {
            fastMergeSoluId = (String)relateParamMap.get("fastMergeSoluId");
        }
        if (this.createRptStrategy == 2 && fastMergeSoluId != null && FastMergeUtil.getIsContainUnRecive(this.ctx, fastMergeSoluId)) {
            isGroupcommitted = false;
        }
        Map sumResult = null;
        if (this.ctx == null) {
            tableValues.put("year", this.curReport.getYear());
            tableValues.put("period", Integer.valueOf(this.curReport.getPeriod()));
            tableValues.put("fastMergerParamMap", relateParamMap);
            tableValues.put("adjustColl", (Object)this.adjustCol);
            tableValues.put("isGroupcommitted", isGroupcommitted);
            sumResult = CSLReportCalculatorFactory.getRemoteInstance().calculateSumRptByItem((IObjectPK)new ObjectUuidPK(this.curReport.getId()), companyIDs, tableValues, includeDiffTable, this.isBySumReport, this.curReport.getDataCollectNumber());
        } else {
            sumResult = new SumRptCalculate().calculateByItem(this.ctx, (IObjectPK)new ObjectUuidPK(this.curReport.getId()), companyIDs, tableValues, includeDiffTable, this.isBySumReport, this.curReport.getDataCollectNumber(), isGroupcommitted, this.adjustCol, this.curReport.getYear(), this.curReport.getPeriod(), relateParamMap);
        }
        boolean isRoundingByPrecision = Boolean.valueOf(ParamManager.getParamValue((Context)this.ctx, null, (String)"GR_CSL_RoundingByPrecision"));
        RptAutoWeaveUtil.refreshTableData(tables, sumResult, precision, isRoundingByPrecision);
    }

    public void bySheetsCalc(int precision, Vector vecSelectedCompanys, ICslRptCalculator calculator, boolean includeDiffTable, ArrayList reportIDs, boolean isIncrementCal) throws Exception {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, SumcalcRange> sheetIDs = new HashMap<String, SumcalcRange>();
        HashMap<String, DynaKeyAndValue> dynaSumRange = new HashMap<String, DynaKeyAndValue>();
        if (this.isDynaSum) {
            this.replaceBookByTemplate(this.curReport);
        }
        for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
            Sheet tmpSheet = this.curSheets.getSheet(i);
            if (!tmpSheet.isEnableCalculation()) continue;
            DynaKeyAndValue dynaObj = new DynaKeyAndValue();
            dynaObj.dynaKeyRange = (SumcalcRange)tmpSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            dynaObj.allValueCol = (ArrayList)tmpSheet.getUserObjectValue("allValueCol");
            dynaObj.leftKeyCol = (Integer)tmpSheet.getUserObjectValue("keyLeftCol");
            String sheetName = tmpSheet.getSheetName();
            if (!dynaSumRange.containsKey(sheetName)) {
                dynaSumRange.put(sheetName, dynaObj);
            }
            sheetIDs.put(tmpSheet.getSheetName(), null);
            tables.put(tmpSheet.getSheetName(), tmpSheet);
        }
        String templateId = this.curReport.getTemplate().getId().toString();
        ITemplate itemp = null;
        itemp = this.ctx == null ? TemplateFactory.getRemoteInstance() : TemplateFactory.getLocalInstance((Context)this.ctx);
        TemplateInfo template = itemp.getTemplateInfo("select id, data where id = '" + templateId + "'");
        Book book = template.getBook();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (sheet == null) continue;
            String sheetName = sheet.getSheetName();
            SumcalcRange sumZone = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
            if (!sheetIDs.containsKey(sheetName)) continue;
            sheetIDs.put(sheetName, sumZone);
        }
        book = null;
        String oql = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId <> 'empty_sheet'";
        String oql1 = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId = 'empty_sheet'";
        String oql2 = " where sumReportID = '" + this.curReport.getId().toString() + "'";
        ISumRptRela irela = null;
        irela = this.ctx == null ? SumRptRelaFactory.getRemoteInstance() : SumRptRelaFactory.getLocalInstance(this.ctx);
        if (irela.exists(oql) && isIncrementCal) {
            if (!this.isDynaSum) {
                HashMap result = calculator.incrementCalSumRptBySheets(reportIDs, this.curReport.getId().toString(), sheetIDs);
                this.refreshTableData(tables, result, precision);
            } else {
                int count = 0;
                ArrayList rptList = new ArrayList();
                this.sumDynaData(reportIDs, count, calculator, rptList, sheetIDs, dynaSumRange, tables, precision);
            }
        } else {
            if (irela.exists(oql1)) {
                irela.delete(oql2);
            }
            int count = 0;
            ArrayList rptList = new ArrayList();
            if (!this.isDynaSum) {
                RptAutoWeaveUtil.clearSheetSumCellData(this.curSheets);
                int n = reportIDs.size();
                for (int i = 0; i < n; ++i) {
                    if (count < 2) {
                        rptList.add(reportIDs.get(i));
                        ++count;
                        continue;
                    }
                    HashMap result = calculator.calculateSumRptBySheets(rptList, sheetIDs);
                    this.refreshTableData(tables, result, precision);
                    rptList = new ArrayList();
                    rptList.add(reportIDs.get(i));
                    count = 0;
                }
                if (rptList.size() > 0) {
                    HashMap result = calculator.calculateSumRptBySheets(rptList, sheetIDs);
                    this.refreshTableData(tables, result, precision);
                }
            } else {
                RptAutoWeaveUtil.clearSheetDynaCellData(this.curSheets);
                this.sumDynaData(reportIDs, count, calculator, rptList, sheetIDs, dynaSumRange, tables, precision);
            }
        }
    }

    public void restoreSheetStyle(boolean isCalcSingle) {
        if (isCalcSingle) {
            if (this.isByTemplate) {
                DynamicTemplateUtility.copyTemplateStyleToCurSheet((Sheet)this.tmpBook.getSheet(this.curSheets.getActiveSheetIndex()), (Sheet)this.curSheets.getActiveSheet());
            } else {
                DynamicTemplateUtility.restoreOriginalGradeLineStyle((Sheet)this.curSheets.getActiveSheet(), (Map)this.bookStyleMapForGrade, (boolean)this.isByTemplate);
                DynamicTemplateUtility.setSheetBasePointsFirstLineStyle((Map)this.bookStyleMap, (Sheet)this.curSheets.getActiveSheet());
                DynamicTemplateUtility.reAdjustSheetAlign((Sheet)this.curSheets.getActiveSheet());
            }
        } else if (this.isByTemplate) {
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                DynamicTemplateUtility.copyTemplateStyleToCurSheet((Sheet)this.tmpBook.getSheet(this.curSheets.getSheetName(i)), (Sheet)this.curSheets.getSheet(i));
            }
        } else {
            DynamicTemplateUtility.restoreOriginalGradeLineStyle((Book)this.curSheets, (Map)this.bookStyleMapForGrade, (boolean)this.isByTemplate);
            DynamicTemplateUtility.setBookBasePointsFirstLine((Map)this.bookStyleMap, (Book)this.curSheets);
            DynamicTemplateUtility.reAdjustSheetAlign((Book)this.curSheets);
        }
    }

    protected void fillDynaData(RptSrcTypeEnum rptSrcTypeEnum, Map tables, Map tableItem, Map sumResult, int precision) throws Exception {
        int selectedSize = this.displayNumber;
        ITemplate itemp = null;
        itemp = this.ctx == null ? TemplateFactory.getRemoteInstance() : TemplateFactory.getLocalInstance((Context)this.ctx);
        TemplateInfo templateInfo = itemp.getTemplateInfo((IObjectPK)new ObjectUuidPK(this.curReport.getTemplate().getId()));
        Book book = templateInfo.getBook();
        Sheet templateTable = null;
        for (String sheetID : tables.keySet()) {
            if (!sumResult.containsKey(sheetID)) continue;
            if (book != null) {
                Sheet sheetByID;
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (!sheetID.equals(sheet.getID())) continue;
                    templateTable = sheet;
                    break;
                }
                if (templateTable == null && (sheetByID = this.curSheets.getSheetByID(sheetID)) != null) {
                    templateTable = book.getSheet(sheetByID.getSheetName());
                }
            }
            Sheet table = (Sheet)tables.get(sheetID);
            Map sheetMap = (Map)sumResult.get(sheetID);
            HashMap<Point, String> templateFormulas = new HashMap<Point, String>();
            Object[] basePointArray = this.sortByPosistion(table, sheetMap.keySet());
            ArrayList templateBasePoints = null;
            if (this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                templateBasePoints = DynamicTemplateUtility.getBasePointList((Sheet)templateTable);
            }
            for (int n = basePointArray.length - 1; n >= 0; --n) {
                boolean isSumByName;
                Point basePoint = (Point)basePointArray[n];
                int baseLine = 0;
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)table, (Point)basePoint);
                if (param == null) continue;
                if (rptSrcTypeEnum == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                    this.fillMultiSumData(param, basePoint, table, (Map)sheetMap.get(basePoint), selectedSize);
                    continue;
                }
                Object dItemGradeInfo = table.getRange(basePoint.y, basePoint.x).getUserObject("DItemGradeInfo");
                DItemGradeInfo gradeInfo = null;
                if (param.isGrade() || dItemGradeInfo instanceof DItemGradeInfo) {
                    gradeInfo = (DItemGradeInfo)dItemGradeInfo;
                }
                if (gradeInfo != null) {
                    gradeInfo.reform();
                }
                boolean isShowTotal1 = this.isShowTotal && !param.isGrade() && (param.getOrderBy().equals((Object)OrderByEnum.NONE) || param.getOrderRow() <= 0);
                boolean isTextGrade = param.isGrade() && param.getDynaItemSource() == 0;
                boolean bl = isSumByName = this.sumMethod == DynaSumMethodEnum.SUM_BY_NAME;
                if (isTextGrade && (this.sumMethod == DynaSumMethodEnum.SUM_BY_NAME || this.sumMethod == DynaSumMethodEnum.LIST_NAME_COMPANY)) {
                    DynamicTemplateUtility.copyBasePointRangeForGrade((Sheet)templateTable, (Sheet)table, (Object[])basePointArray, (List)templateBasePoints, (int)n, (boolean)isSumByName);
                    this.fillTextGradeData(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize, false, true, true);
                    continue;
                }
                if (isTextGrade && this.isOnlyList) {
                    DynamicTemplateUtility.copyBasePointRangeForGrade((Sheet)templateTable, (Sheet)table, (Object[])basePointArray, (List)templateBasePoints, (int)n, (boolean)isSumByName);
                    this.fillTextGradeData(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize, false, false, this.isOnlyList);
                    continue;
                }
                if (isTextGrade && (this.sumMethod == DynaSumMethodEnum.LIST_COMPANY_NAME || this.sumMethod == DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && !this.isOnlyList) {
                    this.fillTextCompany_Name(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize);
                    continue;
                }
                boolean isHorizon = param.getSpreadStyle() == 1;
                boolean isLeftUp = param.getPosition() == 1;
                DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, table, true, true);
                int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
                Map nameMap = (Map)sheetMap.get(basePoint);
                Set keySet = nameMap.keySet();
                Iterator<Object> iter3 = null;
                List<Object> resultListBySort = null;
                if (this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    iter3 = keySet.iterator();
                } else {
                    if (param.isGrade() || !param.getOrderBy().equals((Object)OrderByEnum.NONE) && param.getOrderRow() == 0 || param.getOrderBy().equals((Object)OrderByEnum.NONE) && (this.sumMethod.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || this.sumMethod.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY) || this.sumMethod.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME))) {
                        int i;
                        boolean isDesc;
                        Object[] array = keySet.toArray();
                        Collator comparator = null;
                        if (!isTextGrade || !DynaSumMethodEnum.SUM_BY_NAME.equals((Object)this.sumMethod)) {
                            comparator = Collator.getInstance(Locale.CHINA);
                        }
                        ArrayList<Object> arr = new ArrayList<Object>();
                        int size = array.length;
                        for (int i2 = 0; i2 < size; ++i2) {
                            if (array[i2] == null) continue;
                            arr.add(array[i2]);
                        }
                        array = arr.toArray();
                        Arrays.sort(array, comparator);
                        ArrayList<Object> list = new ArrayList<Object>();
                        boolean bl2 = isDesc = comparator != null && param.getOrderBy().equals((Object)OrderByEnum.DESC);
                        if (isDesc) {
                            for (i = array.length - 1; i >= 0; --i) {
                                list.add(array[i]);
                            }
                        } else {
                            for (i = 0; i < array.length; ++i) {
                                list.add(array[i]);
                            }
                        }
                        resultListBySort = param.isGrade() && this.sumMethod.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY) && gradeInfo != null ? SumHelper.getOrderList(gradeInfo, list, nameMap, isDesc) : list;
                    } else if (!param.getOrderBy().equals((Object)OrderByEnum.NONE) && param.getOrderRow() > 0) {
                        ArrayList<Object> list;
                        Point sortedPoint = null;
                        boolean isHead = false;
                        if (param.getOrderRow() > 0) {
                            sortedPoint = isHorizon ? new Point(basePoint.x, basePoint.y + param.getOrderRow()) : new Point(basePoint.x + param.getOrderRow(), basePoint.y);
                        } else {
                            sortedPoint = basePoint;
                            isHead = true;
                        }
                        resultListBySort = list = this.getSortedMap(nameMap, sortedPoint, param.getOrderBy(), isHead);
                    } else {
                        resultListBySort = Arrays.asList(keySet.toArray());
                    }
                    iter3 = resultListBySort.iterator();
                }
                int rowFixed = isHorizon ? basePoint.y : basePoint.y + 1 + beforeDynaItemCount;
                int colFixed = isHorizon ? basePoint.x + 1 + beforeDynaItemCount : basePoint.x;
                Cell cellFixed = table.getCell(rowFixed, colFixed, true);
                boolean existsFixed = false;
                if (cellFixed != null && cellFixed.isLocked()) {
                    existsFixed = true;
                    param.setDefaultCounter(param.getDefaultCounter() + 1);
                    if (isHorizon) {
                        UserObjectHelper.getUnprotectedRange((Range)table.getColRange(colFixed + 1, colFixed + 1)).insert();
                    } else {
                        UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(rowFixed + 1, rowFixed + 1)).insert();
                    }
                    DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                }
                CslReportInfo report = this.curReport;
                int actualSize = this.getActualSize(nameMap, resultListBySort, isShowTotal1);
                if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC) && !this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    if (actualSize > selectedSize && selectedSize > 0) {
                        actualSize = selectedSize;
                    }
                    if (existsFixed) {
                        ++actualSize;
                    }
                    int size = param.getDefaultCounter();
                    if (actualSize == 0) {
                        actualSize = size;
                    }
                    int n2 = baseLine = isHorizon ? basePoint.x + 1 + beforeDynaItemCount : basePoint.y + 1 + beforeDynaItemCount;
                    if (actualSize != size) {
                        int diff = actualSize - size;
                        boolean isInsert = diff > 0;
                        diff = Math.abs(diff);
                        if (existsFixed) {
                            ++baseLine;
                        }
                        int itemFormulaCount = 0;
                        int startIndex = 0;
                        if (isHorizon) {
                            itemFormulaCount = DynamicTemplateUtility.getRowCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                            startIndex = basePoint.y;
                        } else {
                            itemFormulaCount = DynamicTemplateUtility.getColCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                            startIndex = basePoint.x;
                        }
                        if (param.getDynaItemShowType() == 1) {
                            --startIndex;
                        }
                        if (!param.getIsFirst() && !param.isGrade() && size > 0) {
                            this.clearSelfDefineFormula(baseLine, startIndex, itemFormulaCount, table, param.getSpreadStyle());
                        }
                        if (diff > 0) {
                            if (isHorizon) {
                                if (isInsert) {
                                    UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine + 1, baseLine + diff)).insert();
                                } else if (baseLine <= table.getMaxColIndex()) {
                                    UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine + 1, baseLine + diff)).delete();
                                }
                            } else if (isInsert) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine + 1, baseLine + diff)).insert();
                            } else if (baseLine <= table.getMaxRowIndex()) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine + 1, baseLine + diff)).delete();
                            }
                        }
                        param.setDefaultCounter(actualSize);
                        indexHandle.autoAdjustSum(param, !isHorizon, itemFormulaCount);
                        DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                    }
                }
                if (!this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    int i = 0;
                    int childCount = -1;
                    boolean enterNoBranchRange = false;
                    int first = baseLine;
                    ArrayList<Integer> totalLine = new ArrayList<Integer>();
                    String companyName = null;
                    while (iter3.hasNext()) {
                        int StartRowCol;
                        if (!isTextGrade || this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                            if (i > actualSize - 1) {
                                break;
                            }
                        } else {
                            param.setDefaultCounter(nameMap.size());
                            DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                        }
                        String number = (String)iter3.next();
                        Map map = (Map)nameMap.get(number);
                        String name = (String)map.get("KEY_DITEM_NAME");
                        String numberShow = (String)map.get("KEY_DITEM_SHOW_NUMBER");
                        Map pointMap = (Map)map.get("KEY_POINT_VALUE");
                        String grade = (String)map.get("GRADE_NUMBER");
                        String comp = (String)map.get("COMPANY_NAME");
                        if (companyName == null) {
                            companyName = comp;
                        }
                        if (comp != null && !comp.equals(companyName) && isShowTotal1) {
                            int StartRowCol2;
                            int end = baseLine + i - 1;
                            companyName = comp;
                            totalLine.add(new Integer(end + 1));
                            int row = isHorizon ? basePoint.y : baseLine + i;
                            int col = isHorizon ? baseLine + i : basePoint.x;
                            Cell cell = table.getCell(row, col, true);
                            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"317_AfterElimReportUI")));
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                            sa.setBackground(lightblue);
                            cell.setSSA((ShareStyleAttributes)sa);
                            cell.setUserObject("isSum", (Object)"Y");
                            int maxRowCol = isHorizon ? table.getMaxColIndex() : table.getMaxColIndex();
                            for (int j = StartRowCol2 = isHorizon ? basePoint.y + 1 : basePoint.x + 1; j <= maxRowCol; ++j) {
                                Range range = UserObjectHelper.getUnprotectedRange((Range)(isHorizon ? table.getRange(j, basePoint.x) : table.getRange(basePoint.y, j)));
                                ItemFormula itemformula = (ItemFormula)range.getUserObject("ITEM");
                                if (itemformula == null || itemformula.getValueType() == 3) continue;
                                Cell cell2 = cell = isHorizon ? table.getCell(j, baseLine + i, true) : table.getCell(baseLine + i, j, true);
                                if (cell == null) continue;
                                String cellStart = isHorizon ? Location.getCellName(j, first) : Location.getCellName(first, j);
                                String cellEnd = isHorizon ? Location.getCellName(j, end) : Location.getCellName(end, j);
                                String formula = "=sum(" + cellStart + ":" + cellEnd + ")";
                                cell.setFormula(formula);
                                sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                                sa.setBackground(lightblue);
                                cell.setSSA((ShareStyleAttributes)sa);
                                cell.setUserObject("isSum", (Object)"Y");
                            }
                            first = end + 2;
                            ++i;
                        }
                        int row = isHorizon ? basePoint.y : baseLine + i;
                        int col = isHorizon ? baseLine + i : basePoint.x;
                        Cell cell = table.getCell(row, col, true);
                        Cell showNumberCell = table.getCell(isHorizon ? row - 1 : row, isHorizon ? col : col - 1, true);
                        if (cell != null) {
                            String nameShow = name;
                            if (param.isGrade()) {
                                if (param.getDynaItemSource() == 0 && gradeInfo != null) {
                                    DItemGradeEntryInfo info = gradeInfo.findParent(grade);
                                    if (info != null) {
                                        nameShow = info.getIdentBlank() + info.getParentIndentBlank() + nameShow;
                                    }
                                    if ((info = gradeInfo.find(grade)) != null && !info.isLeaf()) {
                                        if (!info.hasBranchChildren()) {
                                            childCount = 0;
                                            enterNoBranchRange = true;
                                        } else {
                                            enterNoBranchRange = false;
                                        }
                                    }
                                    UserObjectHelper.getItemFormula((Cell)cell, (boolean)true).putExt("GRADE_NUMBER", grade);
                                } else {
                                    String[] array = number.split("!");
                                    if (array.length > 1) {
                                        for (int k = 1; k < array.length; ++k) {
                                            nameShow = "  " + nameShow;
                                            numberShow = " " + numberShow;
                                        }
                                    }
                                }
                            }
                            cell.setValue(new Variant((Object)nameShow));
                            if (param.getDynaItemShowType() == 1) {
                                showNumberCell.setValue(new Variant((Object)numberShow));
                            }
                            if (param.getSpreadStyle() == 0) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRange(row, col)).setRowHidden(enterNoBranchRange && childCount > actualSize);
                            } else {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRange(row, col)).setRowHidden(enterNoBranchRange && childCount > actualSize);
                            }
                            ++childCount;
                            if (this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                                if ("GRADESUM_TREE_ROOT".equals(name)) {
                                    cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
                                } else {
                                    DynaItemListener.setExeFlag((boolean)true);
                                    if (isTextGrade) {
                                        DynaItemListener.setAutoFillTextGradeSum((boolean)false);
                                    }
                                    DynaItemListener.autoFillFormula((Sheet)table, (int)row, (int)col, (String)number, null, (int)0, null, (boolean)false);
                                    if (isTextGrade) {
                                        DynaItemListener.setAutoFillTextGradeSum((boolean)true);
                                    }
                                    DynaItemListener.setExeFlag((boolean)false);
                                }
                            }
                        }
                        for (Point point : pointMap.keySet()) {
                            cell = isHorizon ? table.getCell(point.y, baseLine + i, true) : table.getCell(baseLine + i, point.x, true);
                            if (cell == null) continue;
                            Object value = pointMap.get(point);
                            if (value != null && value instanceof BigDecimal) {
                                cell.setValue(new Variant(value));
                                continue;
                            }
                            if (value == null) continue;
                            cell.setValue(new Variant(value));
                        }
                        ++i;
                        if (iter3.hasNext() || !isShowTotal1) continue;
                        int end = baseLine + i - 1;
                        companyName = comp;
                        totalLine.add(new Integer(end + 1));
                        row = isHorizon ? basePoint.y : baseLine + i;
                        col = isHorizon ? baseLine + i : basePoint.x;
                        cell = table.getCell(row, col, true);
                        cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"317_AfterElimReportUI")));
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                        sa.setBackground(lightblue);
                        cell.setSSA((ShareStyleAttributes)sa);
                        cell.setUserObject("isSum", (Object)"Y");
                        int maxRowCol = isHorizon ? table.getMaxColIndex() : table.getMaxColIndex();
                        for (int j = StartRowCol = isHorizon ? basePoint.y + 1 : basePoint.x + 1; j <= maxRowCol; ++j) {
                            Range range = UserObjectHelper.getUnprotectedRange((Range)(isHorizon ? table.getRange(j, basePoint.x) : table.getRange(basePoint.y, j)));
                            ItemFormula itemformula = (ItemFormula)range.getUserObject("ITEM");
                            if (itemformula == null || itemformula.getValueType() == 3) continue;
                            Cell cell3 = cell = isHorizon ? table.getCell(j, baseLine + i, true) : table.getCell(baseLine + i, j, true);
                            if (cell == null) continue;
                            String cellStart = isHorizon ? Location.getCellName(j, first) : Location.getCellName(first, j);
                            String cellEnd = isHorizon ? Location.getCellName(j, end) : Location.getCellName(end, j);
                            String formula = "=sum(" + cellStart + ":" + cellEnd + ")";
                            cell.setFormula(formula);
                            sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                            sa.setBackground(lightblue);
                            cell.setSSA((ShareStyleAttributes)sa);
                            cell.setUserObject("isSum", (Object)"Y");
                        }
                        first = end + 2;
                        ++i;
                    }
                    if (isShowTotal1) {
                        DynamicTemplateUtility.autoAdjustSum((Sheet)table, (Point)basePoint, (int)actualSize, totalLine);
                    }
                    if (!this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) || templateBasePoints == null || templateBasePoints.get(n) == null) continue;
                    DynaRptCalcHelper.insertTemplateStyle(resultListBySort, table, basePoint, param, templateTable, templateBasePoints != null ? (Point)templateBasePoints.get(n) : null);
                    continue;
                }
                if (!this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) continue;
                if (templateTable == null) {
                    if (this.ctx == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"691_SumRptCalculateGuideUI"));
                        return;
                    }
                    throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"691_SumRptCalculateGuideUI"));
                }
                ArrayList originalBasePoints = DynamicTemplateUtility.getBasePointList((Sheet)templateTable);
                Point originalBasePoint = (Point)originalBasePoints.get(n);
                DynaParameters originalParam = DynamicTemplateUtility.getDynaParameters((Sheet)templateTable, (Point)originalBasePoint);
                if (originalParam == null) continue;
                actualSize = originalParam.getDefaultCounter();
                if (actualSize > selectedSize && selectedSize > 0) {
                    actualSize = selectedSize;
                }
                if (existsFixed) {
                    ++actualSize;
                }
                int size = param.getDefaultCounter();
                baseLine = isHorizon ? basePoint.x + 1 + beforeDynaItemCount : basePoint.y + 1 + beforeDynaItemCount;
                int itemFormulaCount = 0;
                int startIndex = 0;
                if (isHorizon) {
                    itemFormulaCount = DynamicTemplateUtility.getRowCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                    startIndex = basePoint.y;
                } else {
                    itemFormulaCount = DynamicTemplateUtility.getColCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                    startIndex = basePoint.x;
                }
                if (param.getDynaItemShowType() == 1) {
                    --startIndex;
                }
                if (!param.getIsFirst() && !param.isGrade() && size > 0) {
                    this.clearSelfDefineFormula(baseLine, startIndex, itemFormulaCount, table, param.getSpreadStyle());
                }
                if (actualSize != size) {
                    int diff = actualSize - size;
                    boolean isInsert = diff > 0;
                    diff = Math.abs(diff);
                    baseLine += beforeDynaItemCount;
                    if (existsFixed) {
                        ++baseLine;
                    }
                    if (diff > 0) {
                        if (isHorizon) {
                            if (isInsert) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine + 1, baseLine + diff)).insert(false, InsertType.NOSTYLE);
                            } else if (baseLine <= table.getMaxColIndex()) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine + 1, baseLine + diff)).delete();
                            }
                        } else if (isInsert) {
                            UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine + 1, baseLine + diff)).insert(true, InsertType.NOSTYLE);
                        } else if (baseLine <= table.getMaxRowIndex()) {
                            UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine + 1, baseLine + diff)).delete();
                        }
                    }
                    DynamicTemplateUtility.autoAdjustSum((Sheet)table, (Point)basePoint, (int)actualSize, (boolean)true);
                    param.setDefaultCounter(actualSize);
                    DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                }
                int headStart = -1;
                int headEnd = -1;
                int bodyStart = -1;
                int bodyEnd = -1;
                if (isHorizon) {
                    headStart = basePoint.y + 1;
                    headEnd = table.getMaxRowIndex();
                    bodyStart = basePoint.x + 1;
                    bodyEnd = basePoint.x + param.getDefaultCounter();
                } else {
                    headStart = basePoint.x + 1;
                    headEnd = table.getMaxColIndex();
                    bodyStart = basePoint.y + 1;
                    bodyEnd = basePoint.y + param.getDefaultCounter();
                }
                bodyStart += beforeDynaItemCount;
                bodyEnd += beforeDynaItemCount;
                int originalbodyStart = -1;
                int originalbodyEnd = -1;
                if (isHorizon) {
                    originalbodyStart = originalBasePoint.x + 1;
                    originalbodyEnd = originalBasePoint.x + param.getDefaultCounter();
                } else {
                    originalbodyStart = originalBasePoint.y + 1;
                    originalbodyEnd = originalBasePoint.y + param.getDefaultCounter();
                }
                originalbodyStart += beforeDynaItemCount;
                originalbodyEnd += beforeDynaItemCount;
                Cell tmpCell = null;
                for (int i = 0; i < param.getDefaultCounter(); ++i) {
                    Point itemheadPoint;
                    if (templateTable == null) continue;
                    Point originalItemheadPoint = isHorizon ? new Point(i + originalbodyStart, originalBasePoint.y) : new Point(originalBasePoint.x, i + originalbodyStart);
                    Point point = itemheadPoint = isHorizon ? new Point(i + bodyStart, basePoint.y) : new Point(basePoint.x, i + bodyStart);
                    if (templateTable.getCell(originalItemheadPoint.y, originalItemheadPoint.x, false) == null) continue;
                    tmpCell = templateTable.getCell(originalItemheadPoint.y, originalItemheadPoint.x, false);
                    String headName = tmpCell.getValue().toString();
                    Cell headcell = table.getCell(itemheadPoint.y, itemheadPoint.x, true);
                    if (headName == null) continue;
                    headcell.setValue(new Variant((Object)headName));
                }
                Cell cell = null;
                Cell curCell = null;
                String templateExpression = null;
                for (int i = headStart; i <= headEnd; ++i) {
                    Point headPoint = null;
                    headPoint = isHorizon ? new Point(basePoint.x, i) : new Point(i, basePoint.y);
                    for (int j = 0; j < param.getDefaultCounter(); ++j) {
                        Object value;
                        Map map;
                        Map pointMap;
                        String number;
                        ItemFormula formula;
                        curCell = isHorizon ? table.getCell(i, j + bodyStart, true) : table.getCell(j + bodyStart, i, true);
                        Cell cell4 = cell = isHorizon ? templateTable.getCell(i, j + originalbodyStart, false) : templateTable.getCell(j + originalbodyStart, i, false);
                        if (cell == null || (formula = CslRptUtil.getFormula(templateTable.getRange(cell))) == null || (number = formula.getDItemNumber()) == null || number.length() == 0) continue;
                        CslRptUtil.setFormula(UserObjectHelper.getUnprotectedRange((Range)table.getRange(curCell)), formula);
                        if (cell.hasFormula()) {
                            templateExpression = cell.getFormula();
                            Point p = new Point(cell.getCol(), cell.getRow());
                            templateFormulas.put(p, templateExpression);
                        }
                        if (!nameMap.containsKey(number) || !(pointMap = (Map)(map = (Map)nameMap.get(number)).get("KEY_POINT_VALUE")).containsKey(headPoint) || (value = pointMap.get(headPoint)) == null) continue;
                        curCell.setValue(new Variant(value));
                    }
                }
            }
            if (!this.sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) continue;
            for (Point p : templateFormulas.keySet()) {
                String formula = (String)templateFormulas.get(p);
                Cell cell = table.getCell(p.y, p.x, true);
                if (cell == null) continue;
                cell.setFormula(formula);
            }
        }
    }

    private Object[] sortByPosistion(Sheet table, Set set) {
        Object[] basePointArray = set.toArray();
        if (basePointArray.length > 0) {
            Point basePoint = (Point)basePointArray[0];
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)table, (int)basePoint.y, (int)basePoint.x);
            if (param != null) {
                if (param.getSpreadStyle() == 1) {
                    Arrays.sort(basePointArray, new PointXComparator());
                } else {
                    Arrays.sort(basePointArray, new PointYComparator());
                }
            }
        }
        return basePointArray;
    }

    protected void fillMultiSumData(DynaParameters param, Point basePoint, Sheet table, Map map, int selectedSize) throws EASBizException, BOSException {
    }

    private void fillTextGradeData(Point basePoint, Sheet sheet, Map nameMap, DItemGradeInfo gradeInfo, int selectedSize, boolean byname, boolean isGenItemFormula, boolean isOnlyList) {
        DItemGradeInfo info = new DItemGradeInfo();
        Iterator it = nameMap.entrySet().iterator();
        String tmpName = null;
        String tmpNumber = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            tmpName = (String)v.get("KEY_DITEM_NAME");
            tmpNumber = (String)entry.getKey();
            en.setName(tmpName);
            en.setNumber(tmpNumber);
            if (tmpName == null && tmpNumber == null) continue;
            info.getEntries().add(en);
            String compName = (String)v.get("COMPANY_NAME");
            en.setCompany(compName);
        }
        info.reform2(true);
        DItemGradeInfo info2 = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basePoint.y, basePoint.x));
        HashMap dupBranchValues = new HashMap();
        BigDecimal preValue = null;
        BigDecimal curValue = null;
        BigDecimal sumValue = null;
        HashMap nameNumberListMap = new HashMap();
        List<String> numberList = null;
        Map aDupMap = null;
        Map dupPointValueMap = null;
        Map aNameMap = null;
        Map namePointValueMap = null;
        Object var24_24 = null;
        Iterator dupIter = null;
        for (DItemGradeEntryInfo i : info.getEntries()) {
            DItemGradeEntryInfo find;
            if (info2 == null || (find = info2.find(i.getGrade())) == null || find.isLeaf()) continue;
            i.setLeaf(false);
            if (!isOnlyList) continue;
            String name = find.getName();
            i.setName(name);
            if (!isOnlyList || find.isIncludeUnknowDetail()) continue;
            BigDecimal zero = new BigDecimal("0");
            if (dupBranchValues.containsKey(name)) {
                aDupMap = (Map)dupBranchValues.get(name);
                aNameMap = (Map)nameMap.get(i.getNumber());
                dupPointValueMap = (Map)aDupMap.get("KEY_POINT_VALUE");
                namePointValueMap = (Map)aNameMap.get("KEY_POINT_VALUE");
                for (Map.Entry entry : dupPointValueMap.entrySet()) {
                    if (!(entry.getValue() instanceof BigDecimal)) continue;
                    preValue = entry.getValue() == null ? zero : (BigDecimal)entry.getValue();
                    curValue = namePointValueMap.get(entry.getKey()) == null ? zero : (BigDecimal)namePointValueMap.get(entry.getKey());
                    sumValue = preValue.add(curValue);
                    entry.setValue(sumValue);
                }
                numberList = (List)nameNumberListMap.get(name);
                numberList.add(i.getNumber());
                continue;
            }
            dupBranchValues.put(name, nameMap.get(i.getNumber()));
            numberList = new ArrayList<String>();
            numberList.add(i.getNumber());
            nameNumberListMap.put(name, numberList);
        }
        if (!byname) {
            info.removeDupBranch(info.getEntries());
        }
        String nameKey = null;
        Map.Entry nameNumberEntry22 = null;
        Map aDupValueMap = null;
        Map aDupPointValueMap = null;
        List aNumberList = null;
        String numberKey22 = null;
        Map aNameValueMap = null;
        Map aNamePonitValueMap = null;
        Map.Entry dupPointValueEntry22 = null;
        Iterator dupPointValueIter = null;
        if (!nameNumberListMap.isEmpty()) {
            for (Map.Entry nameNumberEntry22 : nameNumberListMap.entrySet()) {
                nameKey = (String)nameNumberEntry22.getKey();
                aDupValueMap = (Map)dupBranchValues.get(nameKey);
                aDupPointValueMap = (Map)aDupValueMap.get("KEY_POINT_VALUE");
                aNumberList = (List)nameNumberEntry22.getValue();
                for (String numberKey22 : aNumberList) {
                    aNameValueMap = (Map)nameMap.get(numberKey22);
                    aNamePonitValueMap = (Map)aNameValueMap.get("KEY_POINT_VALUE");
                    for (Map.Entry dupPointValueEntry22 : aDupPointValueMap.entrySet()) {
                        if (!(dupPointValueEntry22.getValue() instanceof BigDecimal)) continue;
                        aNamePonitValueMap.put(dupPointValueEntry22.getKey(), dupPointValueEntry22.getValue());
                    }
                }
            }
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(byname);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(isGenItemFormula);
        ad.setSumMethod(this.sumMethod.getValue());
        if (gradeInfo != null) {
            ad.setTemplateGradeInfo(gradeInfo);
        }
        ad.fill(info);
    }

    private void fillTextCompany_Name(Point basePoint, Sheet sheet, Map nameMap, DItemGradeInfo gradeInfo, int selectedSize) {
        TreeMap<String, DItemGradeInfo> infos = new TreeMap<String, DItemGradeInfo>();
        for (Map.Entry entry : nameMap.entrySet()) {
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            String name2 = (String)v.get("KEY_DITEM_NAME");
            String compName = (String)v.get("COMPANY_NAME");
            DItemGradeInfo info = (DItemGradeInfo)infos.get(compName);
            if (info == null) {
                info = new DItemGradeInfo();
                infos.put(compName, info);
            }
            en.setName(name2);
            en.setNumber((String)entry.getKey());
            en.setCompany(compName);
            info.getEntries().add(en);
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(true);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(false);
        ad.setSumMethod(this.sumMethod.getValue());
        if (gradeInfo != null) {
            ad.setTemplateGradeInfo(gradeInfo);
        }
        ad.fill(infos);
    }

    protected Map calcMultiDynaSumRpt(String reportID, List companyList, Map tableValues) throws EASBizException, BOSException {
        return null;
    }

    protected Map getTableMap(DynaSumMethodEnum selectedItem, boolean onlyList, boolean isShowTotal, boolean isOnlyListCompany, Sheet table) {
        Map tableMap = SumHelper.scanDynaTable(table, selectedItem, onlyList, isShowTotal, isOnlyListCompany);
        return tableMap;
    }

    private Book getTemplateBook(CslReportInfo cslreportInfo) throws Exception {
        Book tempBook = cslreportInfo.getTemplate().getBook();
        if (tempBook == null) {
            String id = cslreportInfo.getTemplate().getId().toString();
            ITemplate itemp = null;
            itemp = this.ctx == null ? TemplateFactory.getRemoteInstance() : TemplateFactory.getLocalInstance((Context)this.ctx);
            TemplateInfo info = itemp.getTemplateInfo("select data where id='" + id + "'");
            tempBook = info.getBook();
        }
        return tempBook;
    }

    private List getSortedMap(final Map nameMap, final Point sortedPoint, OrderByEnum orderBy, final boolean isHead) {
        Set keySet = nameMap.keySet();
        Object[] array = keySet.toArray();
        if (orderBy.equals((Object)OrderByEnum.DESC)) {
            class KeyComparatorDesc
            implements Comparator {
                KeyComparatorDesc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        return o2.toString().compareTo(o1.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return 1;
                    }
                    if (m2 == null) {
                        return -1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return 1;
                    }
                    if (obj2 == null) {
                        return -1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n2.compareTo(n1);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj2).compareTo((String)obj);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorDesc());
        } else {
            class KeyComparatorAsc
            implements Comparator {
                KeyComparatorAsc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.toString().compareTo(o2.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return -1;
                    }
                    if (m2 == null) {
                        return 1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return -1;
                    }
                    if (obj2 == null) {
                        return 1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n1.compareTo(n2);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj).compareTo((String)obj2);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorAsc());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private int getActualSize(Map areaMap, List sortList, boolean isShowTotal) {
        if (!isShowTotal) {
            return areaMap.size();
        }
        int result = areaMap.size();
        int totalSize = 0;
        if (sortList != null) {
            String tmpCompanyName = "";
            for (int i = 0; i < sortList.size(); ++i) {
                String companyName;
                if (!areaMap.containsKey(sortList.get(i)) || tmpCompanyName.equals(companyName = (String)((Map)areaMap.get(sortList.get(i))).get("COMPANY_NAME"))) continue;
                ++totalSize;
                tmpCompanyName = companyName;
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (Map map : areaMap.values()) {
                String companyName = (String)map.get("COMPANY_NAME");
                if (list.contains(companyName)) continue;
                list.add(companyName);
            }
            totalSize = list.size();
        }
        return result += totalSize;
    }

    public HashMap constructTableMap(Sheet table) {
        if (table == null) {
            return null;
        }
        HashMap<Point, ItemFormula> result = new HashMap<Point, ItemFormula>();
        Sheet.ICellsIterator it = table.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            ItemFormula curFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (curFormula == null || !curFormula.isValidity()) continue;
            curFormula.setCell(null);
            Point position = new Point(cell.getCol(), cell.getRow());
            result.put(position, curFormula);
        }
        return result;
    }

    public void replaceBookByTemplate(CslReportInfo curReport) throws Exception {
        Book book = this.getTemplateBook(curReport);
        RptAutoWeaveUtil.getDynaKeyAndValue(book);
        RptAutoWeaveUtil.setFormulaLocation(book);
        this.addSheet(book, this.curSheets);
    }

    public void refreshTableData(Map sheets, Map sheetData, int precision) throws Exception {
        if (sheets == null || sheets.size() == 0 || sheetData == null || sheetData.size() == 0) {
            return;
        }
        HashMap sumBySheet = (HashMap)sheetData.get("sumBySheet");
        if (sumBySheet == null || sumBySheet.size() == 0) {
            return;
        }
        for (String tableID : sumBySheet.keySet()) {
            if (tableID == null || tableID.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(tableID);
            HashMap curSheetData = (HashMap)sumBySheet.get(tableID);
            if (curSheetData == null || curSheetData.size() == 0) continue;
            Iterator iterCell = curSheetData.keySet().iterator();
            Object o = null;
            HashMap v = new HashMap();
            Cell cell = null;
            while (iterCell.hasNext()) {
                BigDecimal cellValue;
                Point position = (Point)iterCell.next();
                cell = curSheet.getCell(position.y, position.x, true);
                Variant oldValue = cell.getValue();
                BigDecimal old = null;
                try {
                    old = oldValue.toBigDecimal();
                }
                catch (Exception e) {
                    old = new BigDecimal("0");
                }
                Variant varValue = null;
                o = curSheetData.get(position);
                if (o != null && o instanceof HashMap) {
                    v = (HashMap)curSheetData.get(position);
                    if (v != null && v.get("value") != null) {
                        cellValue = (BigDecimal)v.get("value");
                        varValue = new Variant((Object)cellValue.add(old));
                    } else {
                        varValue = Variant.nullVariant;
                    }
                } else if (o != null) {
                    cellValue = o;
                    varValue = new Variant((Object)cellValue.add(old));
                } else {
                    varValue = Variant.nullVariant;
                }
                if (varValue == null) {
                    varValue = Variant.nullVariant;
                }
                cell.setValue(varValue);
                if (cell.getFormula() == null || cell.getFormula().equals("")) continue;
                cell.setUserObject("cellValue", cell.getValue().getValue());
            }
        }
    }

    public void sumDynaData(ArrayList reportIDs, int count, ICslRptCalculator calculator, ArrayList rptList, Map sheetIDs, Map dynaSumRange, HashMap tables, int precision) throws Exception {
        HashMap sumdynaSheets = null;
        HashMap dynaOrder = null;
        int n = reportIDs.size();
        for (int i = 0; i < n; ++i) {
            if (count < 2) {
                rptList.add(reportIDs.get(i));
                ++count;
                continue;
            }
            HashMap result = calculator.calculateSumRptByDynaSheets(rptList, sheetIDs, dynaSumRange, sumdynaSheets, dynaOrder);
            if (result == null) {
                sumdynaSheets = null;
                dynaOrder = null;
            } else {
                sumdynaSheets = result.get("dynaSumRange") == null ? null : (HashMap)result.get("dynaSumRange");
                dynaOrder = result.get("order") == null ? null : (HashMap)result.get("order");
            }
            this.refreshTableData(tables, result, precision);
            rptList = new ArrayList();
            rptList.add(reportIDs.get(i));
            count = 0;
        }
        if (rptList.size() > 0) {
            HashMap result = calculator.calculateSumRptByDynaSheets(rptList, sheetIDs, dynaSumRange, sumdynaSheets, dynaOrder);
            this.refreshTableData(tables, result, precision);
            this.refreshDynaTableData(this.curSheets, tables, result, precision, dynaSumRange);
        }
    }

    private void addSheet(Book templateBook, Book book) {
        int actSh = book.getActiveSheetIndex();
        if (templateBook != null && book != null) {
            book.addSheet(new Sheet(book, "&&&"));
            for (int j = 0; j < templateBook.getSheetCount(); ++j) {
                Sheet tmpsheet = templateBook.getSheet(j);
                Sheet sheet = book.getSheet(tmpsheet.getSheetName());
                if (sheet == null || !sheet.isEnableCalculation()) continue;
                int index = sheet.getSheetIndex();
                book.removeSheet(index);
                book.insertSheet(index, tmpsheet);
                tmpsheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
            }
            book.removeSheet("&&&");
            book.activeSheet(actSh);
            book.getSheet(actSh).setSelected(true);
        }
    }

    private void refreshDynaTableData(Book book, Map sheets, Map result, int precision, Map dynaSumRange) throws Exception {
        if (sheets == null || sheets.size() == 0 || result == null || result.size() == 0) {
            return;
        }
        HashMap dynaSumResult = (HashMap)result.get("dynaSumRange");
        HashMap order = (HashMap)result.get("order");
        if (dynaSumResult == null || dynaSumResult.size() == 0) {
            return;
        }
        for (String sheetName : sheets.keySet()) {
            SumcalcRange dynaValueRange;
            if (sheetName == null || sheetName.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(sheetName);
            DynaKeyAndValue dynaValue = (DynaKeyAndValue)dynaSumRange.get(curSheet.getSheetName());
            ArrayList allValueCol = dynaValue.allValueCol;
            Integer leftKeyCol = dynaValue.leftKeyCol;
            SumcalcRange dynaKeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = dynaValueRange = curSheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (dynaKeyRange == null) continue;
            HashMap dynaKeyResult = new HashMap();
            SumcalcRange keyRange = new SumcalcRange();
            SumcalcRange valueRange = new SumcalcRange();
            int temp = -1;
            for (int i = 0; i < dynaKeyRange.size(); ++i) {
                ++temp;
                CellBlock block = dynaKeyRange.getCellBlock(i);
                int beginRow = block.getRow();
                int endRow = block.getRow2();
                int newBeginRow = beginRow;
                ArrayList orderArray = (ArrayList)order.get(sheetName);
                if (orderArray.size() == 0) {
                    --i;
                    dynaKeyRange = (curSheet = CslRptUtil.doDeleteDynaRange(curSheet, dynaKeyRange, beginRow, endRow)).getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow, endRow)).delete();
                    continue;
                }
                if (dynaSumResult.get(sheetName) != null) {
                    HashMap dynaMap = null;
                    HashMap keyMap = new HashMap();
                    dynaMap = (HashMap)dynaSumResult.get(sheetName);
                    dynaKeyRange = this.circleMap(dynaMap, curSheet, sheetName, newBeginRow, leftKeyCol, temp, orderArray, keyMap, dynaKeyResult, keyRange, valueRange, dynaKeyRange, beginRow, endRow);
                    ++newBeginRow;
                    continue;
                }
                curSheet = CslRptUtil.doDeleteDynaRange(curSheet, dynaKeyRange, beginRow, endRow);
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow, endRow)).delete();
            }
            this.setsheetBlock(curSheet, keyRange, valueRange);
            this.clearErrorFormula(curSheet);
            RptAutoWeaveUtil.paintBackColor(curSheet, keyRange);
            RptAutoWeaveUtil.paintBackColor(curSheet, valueRange);
        }
    }

    private SumcalcRange circleMap(HashMap dynaMap, Sheet curSheet, String sheetName, int newBeginRow, Integer leftKeyCol, int blockNumber, ArrayList order, HashMap keyMap, HashMap dynaKeyResult, SumcalcRange keyRange, SumcalcRange valueRange, SumcalcRange oldDynaKeyRange, int beginRow, int endRow) throws Exception {
        Integer maxRow;
        Collator c = Collator.getInstance(Locale.CHINA);
        Object[] orderArray = order.toArray();
        Arrays.sort(orderArray, c);
        HashMap formulaLocMap = curSheet.getUserObjectValue("fomulaLocation") == null ? null : (HashMap)curSheet.getUserObjectValue("fomulaLocation");
        HashMap allHaveFormulaCol = null;
        ArrayList valueFomulaList = null;
        if (!formulaLocMap.isEmpty()) {
            allHaveFormulaCol = formulaLocMap.get("allHaveFormulaCol") == null ? null : (HashMap)formulaLocMap.get("allHaveFormulaCol");
            valueFomulaList = formulaLocMap.get("formulaLocation") == null ? null : (ArrayList)formulaLocMap.get("formulaLocation");
        }
        int diffRow = -10;
        int templateMaxRow = -1;
        boolean isFillFormula = true;
        HashMap mapAll = this.decomposeFormula(valueFomulaList, newBeginRow, blockNumber, diffRow);
        HashMap curRangeFormulaMap = mapAll.get("map") == null ? null : (HashMap)mapAll.get("map");
        Integer n = maxRow = mapAll.get("maxRow") == null ? null : (Integer)mapAll.get("maxRow");
        if (maxRow != null) {
            if (maxRow != -1) {
                templateMaxRow = maxRow;
                isFillFormula = true;
            } else {
                isFillFormula = false;
            }
        }
        int newKeyRangeRow = 0;
        for (int k = 0; k < orderArray.length; ++k) {
            String key = orderArray[k].toString();
            if (key.indexOf("&") == -1) continue;
            DynaKeyValue dynaKeyValue = this.decompose(key);
            int newRange = blockNumber;
            int origRange = dynaKeyValue.range;
            if (newRange != origRange) continue;
            String keyNew = dynaKeyValue.range + "&" + dynaKeyValue.dynaKey;
            if (!dynaKeyResult.containsKey(keyNew)) {
                if (++newKeyRangeRow > endRow - beginRow + 1) {
                    CslRptUtil.doInsertDynaKeyRange(curSheet, oldDynaKeyRange, newBeginRow);
                    if (oldDynaKeyRange != null && !oldDynaKeyRange.isEmpty()) {
                        oldDynaKeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    }
                    UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(newBeginRow - 1, newBeginRow - 1)).insert(true, InsertType.FLLOW_UP_STYLE);
                    this.copyNextDataToPreData(curSheet, newBeginRow);
                }
                dynaKeyResult.put(keyNew, new Integer(newBeginRow));
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(newBeginRow, leftKeyCol.intValue())).setValue(new Variant((Object)dynaKeyValue.dynaKey));
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(newBeginRow, dynaKeyValue.dynaValueCol.intValue())).setValue(new Variant(dynaMap.get(sheetName + "&" + key)));
                keyRange.addRange(curSheet.getRange(newBeginRow, leftKeyCol.intValue()));
                valueRange.addRange(curSheet.getRange(newBeginRow, dynaKeyValue.dynaValueCol.intValue()));
                if (isFillFormula && curRangeFormulaMap != null && curRangeFormulaMap.size() > 0) {
                    this.setCellFormula(curSheet, dynaKeyValue.dynaValueCol, newRange, curRangeFormulaMap, templateMaxRow, newBeginRow, allHaveFormulaCol, valueRange);
                }
                this.setsheetBlock(curSheet, keyRange, valueRange);
                ++newBeginRow;
                continue;
            }
            Integer row = (Integer)dynaKeyResult.get(keyNew);
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row.intValue(), leftKeyCol.intValue())).setValue(new Variant((Object)dynaKeyValue.dynaKey));
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row.intValue(), dynaKeyValue.dynaValueCol.intValue())).setValue(new Variant(dynaMap.get(sheetName + "&" + key)));
            keyRange.addRange(curSheet.getRange(row.intValue(), leftKeyCol.intValue()));
            valueRange.addRange(curSheet.getRange(row.intValue(), dynaKeyValue.dynaValueCol.intValue()));
            if (!isFillFormula || curRangeFormulaMap == null || curRangeFormulaMap.size() <= 0) continue;
            this.setCellFormula(curSheet, dynaKeyValue.dynaValueCol, newRange, curRangeFormulaMap, templateMaxRow, row, allHaveFormulaCol, valueRange);
        }
        int differenceRow = endRow - beginRow + 1;
        if (newKeyRangeRow < differenceRow) {
            oldDynaKeyRange = (curSheet = CslRptUtil.doDeleteDynaRange(curSheet, oldDynaKeyRange, beginRow + newKeyRangeRow, endRow)).getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow + newKeyRangeRow, endRow)).delete();
        }
        return oldDynaKeyRange;
    }

    private void setsheetBlock(Sheet curSheet, SumcalcRange keyRange, SumcalcRange valueRange) {
        ArrayList allValueCol;
        HashMap leftKeyColAndAllRowCount = CslRptUtil.getLeftColAndAllLeftRow(curSheet, keyRange);
        if (leftKeyColAndAllRowCount.get("allRow") != null) {
            ArrayList allKeyRow = (ArrayList)leftKeyColAndAllRowCount.get("allRow");
            if (allKeyRow.size() != 0 && leftKeyColAndAllRowCount.get("leftCol") != null) {
                SumcalcRange newKeyZone = RptAutoWeaveUtil.reSaveKeyZoneByRange(curSheet, allKeyRow, (Integer)leftKeyColAndAllRowCount.get("leftCol"));
                curSheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
            } else {
                curSheet.setUserObject("DYNAMICSUMKEYZONE", (Object)keyRange);
            }
        }
        ArrayList arrayList = allValueCol = curSheet.getUserObjectValue("allValueCol") == null ? null : (ArrayList)curSheet.getUserObjectValue("allValueCol");
        if (allValueCol != null) {
            SumcalcRange newDynaValueZone = new SumcalcRange();
            for (int k = 0; k < allValueCol.size(); ++k) {
                SumcalcRange newValueZone;
                HashMap allValueRowByCol = RptAutoWeaveUtil.getAllValueRow(curSheet, valueRange, (Integer)allValueCol.get(k));
                if (allValueRowByCol.get("allRow") == null || (newValueZone = RptAutoWeaveUtil.reSaveKeyZoneByRange(curSheet, (ArrayList)allValueRowByCol.get("allRow"), (Integer)allValueCol.get(k))) == null) continue;
                newDynaValueZone.addRanges(newValueZone);
            }
            curSheet.setUserObject("DYNAMICSUMVALUEZONE", (Object)newDynaValueZone);
        }
    }

    private void clearErrorFormula(Sheet sheet) {
        String formula = null;
        if (sheet == null) {
            return;
        }
        int rowCount = sheet.getMaxRowIndex() + 1;
        for (int row = 0; row < rowCount; ++row) {
            int colCount = sheet.getMaxColIndex() + 1;
            for (int col = 0; col < colCount; ++col) {
                Cell cell = sheet.getCell(row, col, false);
                if (cell == null) continue;
                CellBlock b = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol());
                formula = cell.getFormula();
                if (formula == null || !formula.equals("=SUM(#REF!)")) continue;
                cell.setFormula(null);
                if (cell.getUserObject("cellValue") == null) continue;
                cell.setValue(new Variant(cell.getUserObjectValue("cellValue")));
            }
        }
    }

    private HashMap decomposeFormula(ArrayList valueFomulaList, int beginRow, int range, int diffRow) throws Exception {
        HashMap<String, Serializable> mapAll = new HashMap<String, Serializable>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (valueFomulaList != null && valueFomulaList.size() == 0) {
            return mapAll;
        }
        int maxRowIndex = -1;
        for (int i = 0; i < valueFomulaList.size(); ++i) {
            String formula = valueFomulaList.get(i).toString();
            String[] f = formula.split("&");
            if (range != new Integer(f[1])) continue;
            if (diffRow == -10) {
                diffRow = beginRow - new Integer(f[2]);
            }
            int curRow = new Integer(f[2]) + diffRow;
            Expression exp = ExcelFormulaPaserHelper.parse((String)f[0]);
            if (!(exp instanceof UnaryOperationExpr) && exp instanceof BinaryOperationExpr) {
                exp = ExcelFormulaPaserHelper.parse((String)f[0]);
                this.walk(exp);
                StringBuffer cellFormula = new StringBuffer();
                this.interpret(exp.toString(), cellFormula, curRow);
                map.put(new Integer(f[1]) + "&" + curRow + "&" + new Integer(f[3]), cellFormula.toString());
            }
            if (maxRowIndex == -1) {
                maxRowIndex = curRow;
                continue;
            }
            if (maxRowIndex >= curRow) continue;
            maxRowIndex = curRow;
        }
        mapAll.put("map", map);
        mapAll.put("maxRow", new Integer(maxRowIndex));
        return mapAll;
    }

    private DynaKeyValue decompose(String key) {
        DynaKeyValue dynaKeyValue = new DynaKeyValue();
        StringBuffer k = new StringBuffer();
        if (key != null && key.length() > 0) {
            int j = 0;
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '&') {
                    if (++j == 1) {
                        dynaKeyValue.range = new Integer(k.toString());
                        k = new StringBuffer();
                    }
                    if (j != 2) continue;
                    dynaKeyValue.dynaKey = k.toString();
                    k = new StringBuffer();
                    continue;
                }
                if (j < 1) {
                    k.append(key.charAt(i));
                }
                if (j != 1) continue;
                k.append(key.charAt(i));
            }
            int last = key.lastIndexOf("&");
            String dynaValueRow = key.substring(last + 1, key.length());
            dynaKeyValue.dynaValueCol = new Integer(dynaValueRow);
        }
        return dynaKeyValue;
    }

    private void copyNextDataToPreData(Sheet curSheet, int currentRow) {
        for (int i = 0; i <= curSheet.getMaxColIndex(); ++i) {
            boolean isEmpty = curSheet.getRange(currentRow, i).getValue().isEmpty();
            if (isEmpty) continue;
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow - 1, i)).setValue(curSheet.getRange(currentRow, i).getValue());
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, i)).setValue(Variant.nullVariant);
        }
    }

    private void setCellFormula(Sheet curSheet, int column, int range, HashMap curRangeFormula, int templateMaxRow, int currentRow, HashMap allHaveFormulaCol, SumcalcRange valueRange) throws Exception {
        String haveFormulaKey;
        String[] allHaveFormula;
        Iterator iter;
        String key = range + "&" + currentRow + "&" + column;
        boolean isFind = false;
        if (curRangeFormula.get(key) != null) {
            isFind = true;
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + curRangeFormula.get(key).toString());
            valueRange.addRange(curSheet.getRange(currentRow, column));
        }
        if (!isFind) {
            iter = curRangeFormula.keySet().iterator();
            while (iter.hasNext()) {
                String k = iter.next().toString();
                String[] dynaMsg = k.split("&");
                if (new Integer(dynaMsg[0]) != range || new Integer(dynaMsg[1]) != currentRow) continue;
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, new Integer(dynaMsg[2]).intValue())).setFormula("=" + curRangeFormula.get(k).toString());
                valueRange.addRange(curSheet.getRange(currentRow, new Integer(dynaMsg[2]).intValue()));
                isFind = true;
            }
        }
        if (!isFind && allHaveFormulaCol != null && allHaveFormulaCol.size() > 0 && (iter = allHaveFormulaCol.keySet().iterator()).hasNext() && new Integer((allHaveFormula = (haveFormulaKey = iter.next().toString()).split("&"))[0]) == range) {
            Iterator iterater = curRangeFormula.keySet().iterator();
            while (iterater.hasNext()) {
                String k = iterater.next().toString();
                String[] dynaMsg = k.split("&");
                if (new Integer(dynaMsg[0]) != range || !dynaMsg[2].equals(allHaveFormula[1])) continue;
                this.parseFormula(curSheet, curRangeFormula.get(k).toString(), currentRow, new Integer(allHaveFormula[1]), valueRange);
                isFind = true;
                break;
            }
        }
    }

    private void walk(Expression exp) {
        if (exp instanceof BinaryOperationExpr) {
            this.walk(((BinaryOperationExpr)exp).left);
            this.walk(((BinaryOperationExpr)exp).right);
        } else if (exp instanceof UnaryOperationExpr) {
            this.walk(((UnaryOperationExpr)exp).operand);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                this.walk((Expression)ps.get(i));
            }
        } else if (exp instanceof Area3DExpr) {
            this.walk((Expression)((Area3DExpr)exp).area);
        } else if (exp instanceof Ref3DExpr) {
            this.walk((Expression)((Ref3DExpr)exp).ref);
        }
    }

    private void parseFormula(Sheet curSheet, String lastFormularowInTemplate, int currentRow, int column, SumcalcRange valueRange) throws Exception {
        Expression exp = ExcelFormulaPaserHelper.parse((String)lastFormularowInTemplate);
        if (!(exp instanceof UnaryOperationExpr) && exp instanceof BinaryOperationExpr) {
            exp = ExcelFormulaPaserHelper.parse((String)lastFormularowInTemplate);
            this.walk(exp);
            StringBuffer cellFormula = new StringBuffer();
            this.interpret(exp.toString(), cellFormula, currentRow);
            if (curSheet.getCell(currentRow, column, false) != null) {
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + cellFormula.toString());
                valueRange.addRange(curSheet.getRange(currentRow, column));
            } else {
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + cellFormula.toString());
                valueRange.addRange(curSheet.getRange(currentRow, column));
            }
        }
    }

    private void interpret(String exp, StringBuffer formula, int currentRow) throws ParseException {
        if (exp == null || exp.length() == 0) {
            return;
        }
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (Character.isLetter(c) && c != '\'') {
                ArrayList list = this.GetName(exp, c, i);
                if (list.size() == 0) continue;
                String cellName = list.get(0).toString();
                i = (Integer)list.get(1);
                int[] rowCol = Location.getCellRowAndColumn(cellName);
                int row = currentRow;
                int col = rowCol[1];
                formula.append(Location.getCellName(row, col));
                continue;
            }
            formula.append(c);
        }
    }

    private ArrayList GetName(String exp, char look, int location) throws ParseException {
        StringBuffer Token2 = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.IsAlNum(look) || this.isSBC_Case_Symbol(look)) {
            Token2.append(Character.toUpperCase(look));
            if (location == exp.length()) {
                look = '\u0000';
                continue;
            }
            if (location + 1 != exp.length()) {
                look = exp.charAt(++location);
                continue;
            }
            ++location;
            break;
        }
        list.add(Token2.toString());
        list.add(new Integer(location - 1));
        return list;
    }

    private boolean IsAlNum(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    private boolean isSBC_Case_Symbol(char c) {
        switch (c) {
            case '\u201c': 
            case '\u3001': 
            case '\uff03': 
            case '\uff04': 
            case '\uff05': 
            case '\uff06': 
            case '\uff07': 
            case '\uff08': 
            case '\uff09': 
            case '\uff0a': 
            case '\uff0b': 
            case '\uff0c': 
            case '\uff0d': 
            case '\uff0e': 
            case '\uff0f': 
            case '\uff1a': 
            case '\uff1b': 
            case '\uff1c': 
            case '\uff1d': 
            case '\uff1e': 
            case '\uff1f': 
            case '\uff20': 
            case '\uff3b': 
            case '\uff3d': 
            case '\uff3f': 
            case '\uff40': 
            case '\uff5b': 
            case '\uff5c': 
            case '\uff5d': 
            case '\uff5e': {
                return true;
            }
        }
        return false;
    }

    public ArrayList getReportIDs(CslReportInfo rpt, Vector vecSelectedCompanys) throws SumRptException {
        HashSet<String> templateGroups = this.getSourceTemplateGroups(rpt.getTemplate().getId().toString());
        if (templateGroups == null) {
            templateGroups = new HashSet<String>();
        }
        templateGroups.add(this.curReport.getTemplate().getGroup());
        CslReportCollection reports = null;
        HashSet<String> companys = new HashSet<String>();
        for (OrgUnitInfo company : vecSelectedCompanys) {
            companys.add(company.getId().toString());
        }
        try {
            if (rpt.getCurrency() == null) {
                throw new BOSException(CslRptUtil.getString("SumRptCaclCurrencyIsNull"));
            }
            reports = this.getCslReports(companys, rpt.getYear(), rpt.getPeriod(), templateGroups, rpt.getCurrency().getId().toString(), rpt.getDataCollectNumber());
        }
        catch (Exception e) {
            logger.error((Object)"getReportIDs", (Throwable)e);
        }
        if (reports == null || reports.size() == 0) {
            return null;
        }
        HashMap<String, Boolean> comAndGroup = new HashMap<String, Boolean>();
        ArrayList<String> reportIDs = new ArrayList<String>();
        Iterator iterReport = reports.iterator();
        while (iterReport.hasNext()) {
            CslReportInfo reportInfo = (CslReportInfo)iterReport.next();
            comAndGroup.put(reportInfo.getOrgUnit().getNumber(), reportInfo.getOrgUnit().isIsGrouping());
            reportIDs.add(reportInfo.getId().toString());
        }
        return reportIDs;
    }

    private CslReportCollection getCslReports(HashSet companyIDs, int year, int period, HashSet templateGroups, String currencyId, String dataCollectNumber) throws Exception {
        CslReportCollection collection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.isGrouping"));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyIDs, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(year)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)templateGroups, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId, CompareType.EQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("committedStatus", (Object)new Integer(3)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        try {
            collection = this.iCslReport.getCslReportCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)"getCslReports", (Throwable)e);
        }
        return collection;
    }

    private HashSet getSourceTemplateGroups(String sumTemplateID) {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityView.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("targetTemplet", (Object)sumTemplateID));
        entityView.getSelector().add(new SelectorItemInfo("sourceTemplet.group"));
        CoreBaseCollection relas = null;
        try {
            ICslReportRela rptRela = this.ctx == null ? CslReportRelaFactory.getRemoteInstance() : CslReportRelaFactory.getLocalInstance(this.ctx);
            relas = rptRela.getCollection(entityView);
        }
        catch (BOSException e) {
            logger.error((Object)"getSourceTemplateGroups", (Throwable)e);
        }
        if (relas == null || relas.size() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (CslReportRelaInfo reportRela : relas) {
            result.add(reportRela.getSourceTemplet().getGroup());
        }
        return result;
    }

    public StringBuffer copanysVectorToIdStr(Vector companys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companys.size(); ++i) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)companys.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + orgUnitInfo.getId().toString() + "'");
        }
        return sb;
    }

    public void allPageCalcDeleteRela(Vector companys, ISumRptRela iSumRptRela, ISumRptCompanyRela iSumRptCompanyRela) throws BOSException, EASBizException {
        if (companys != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumReportID", (Object)this.curReport.getId().toString()));
            iSumRptRela.delete(filter);
            iSumRptCompanyRela.delete(filter);
        }
    }

    public void singlePageCalcDeleteRela(Map singlePageCompanyIds, ISumRptRela iSumRptRela, ISumRptCompanyRela iSumRptCompanyRela, Map sheetCompanyStr) throws BOSException, EASBizException {
        if (singlePageCompanyIds != null && !singlePageCompanyIds.isEmpty()) {
            for (String sheetId : singlePageCompanyIds.keySet()) {
                Vector ids = (Vector)singlePageCompanyIds.get(sheetId);
                StringBuffer buf = new StringBuffer();
                buf = this.copanysVectorToIdStr(ids);
                sheetCompanyStr.put(sheetId, buf.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sumReportID", (Object)this.curReport.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("sheetId", (Object)sheetId));
                iSumRptRela.delete(filter);
                iSumRptCompanyRela.delete(filter);
            }
        }
    }

    public void deleteNotExistRela() throws EASBizException, BOSException {
        Book book = this.curSheets;
        StringBuffer page = new StringBuffer();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            page.append("'").append(book.getSheetName(i).replaceAll("\\'", "''")).append("',");
        }
        if (page.length() > 0) {
            page.deleteCharAt(page.length() - 1);
        }
        String oql = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId not in (" + page.toString() + ")";
        if (this.ctx == null) {
            SumRptRelaFactory.getRemoteInstance().delete(oql);
        } else {
            SumRptRelaFactory.getLocalInstance(this.ctx).delete(oql);
        }
    }

    public CoreBaseCollection getReportRelaColl() throws BOSException {
        StringBuffer strOql = new StringBuffer("");
        strOql.append("SELECT sourceTemplet.id, sourceTemplet.group, targetTemplet.group WHERE targetTemplet.id = '");
        strOql.append(this.curReport.getTemplate().getId().toString()).append("'");
        ICslReportRela iCslReportRela = null;
        iCslReportRela = this.ctx == null ? CslReportRelaFactory.getRemoteInstance() : CslReportRelaFactory.getLocalInstance(this.ctx);
        CoreBaseCollection collection = iCslReportRela.getCollection(strOql.toString());
        return collection;
    }

    public void sumAllCalcSaveReal(CslReportInfo reportInfo, List diffTableIds, ISumRptRela iSumRptRela, StringBuffer sb, Map sheetCompanyStr, CslReportRelaInfo reportRelaInfo) throws BOSException, EASBizException {
        String sql = this.getReportSql(sb.toString(), reportRelaInfo, reportInfo);
        CslReportCollection col = this.iCslReport.getCslReportCollection(sql);
        ArrayList<String> reportIdList = new ArrayList<String>();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                reportIdList.add(col.get(i).getId().toString());
            }
        }
        this.saveRptAndSumRela(reportInfo, iSumRptRela, sheetCompanyStr, reportIdList);
        this.saveDiffAndSumRela(reportInfo, diffTableIds, iSumRptRela, sheetCompanyStr);
    }

    private String getReportSql(String unitId, CslReportRelaInfo reportRelaInfo, CslReportInfo reportInfo) {
        StringBuffer strOql = new StringBuffer();
        strOql.append("SELECT id WHERE orgUnit.id in (");
        strOql.append(unitId);
        strOql.append(") AND template.group in ('");
        strOql.append(reportRelaInfo.getSourceTemplet().getGroup()).append("', '");
        strOql.append(reportRelaInfo.getTargetTemplet().getGroup()).append("'");
        strOql.append(") and year = ").append(reportInfo.getYear());
        strOql.append(" and period = ").append(reportInfo.getPeriod());
        strOql.append(" and currency.id = '").append(reportInfo.getCurrency().getId().toString());
        strOql.append("' and adjustStatus = ").append(0);
        strOql.append(" and committedStatus = ").append(3);
        strOql.append(" and dataCollect.number = '").append(reportInfo.getDataCollectNumber()).append("'");
        return strOql.toString();
    }

    private void saveRptAndSumRela(CslReportInfo reportInfo, ISumRptRela iSumRptRela, Map sheetCompanyStr, List reportIdList) throws BOSException, EASBizException {
        SumRptRelaInfo info = null;
        if (reportIdList != null && reportIdList.size() > 0) {
            for (int i = 0; i < reportIdList.size(); ++i) {
                String id = reportIdList.get(i).toString();
                for (int j = 0; j < this.curSheets.getSheetCount(); ++j) {
                    String sheetName = this.curSheets.getSheetName(j);
                    if (sheetCompanyStr.containsKey(sheetName)) continue;
                    info = new SumRptRelaInfo();
                    info.setReportID(id);
                    info.setSumReportID(reportInfo.getId().toString());
                    info.setSheetId(sheetName);
                    iSumRptRela.save((CoreBaseInfo)info);
                }
            }
        }
    }

    public void singlecalcSaveRela(CslReportInfo reportInfo, List diffTableIds, ISumRptRela iSumRptRela, Map sheetCompanyStr, boolean bySumReport) throws BOSException, EASBizException {
        for (String sheetName : sheetCompanyStr.keySet()) {
            SumRptRelaInfo info;
            String companyIds = (String)sheetCompanyStr.get(sheetName);
            List col = this.iCslReport.getLinkReports(reportInfo.getId().toString(), companyIds, bySumReport, true);
            if (col != null && col.size() > 0 || diffTableIds != null) {
                int i;
                if (col != null && col.size() > 0) {
                    for (i = 0; i < col.size(); ++i) {
                        String id = col.get(i).toString();
                        info = new SumRptRelaInfo();
                        info.setReportID(id);
                        info.setSumReportID(reportInfo.getId().toString());
                        info.setSheetId(sheetName);
                        iSumRptRela.save((CoreBaseInfo)info);
                    }
                }
                if (diffTableIds == null) continue;
                for (i = 0; i < diffTableIds.size(); ++i) {
                    info = new SumRptRelaInfo();
                    info.setReportID((String)diffTableIds.get(i));
                    info.setSumReportID(reportInfo.getId().toString());
                    info.setSheetId(sheetName);
                    iSumRptRela.save((CoreBaseInfo)info);
                }
                continue;
            }
            info = new SumRptRelaInfo();
            info.setReportID("empty_company");
            info.setSumReportID(reportInfo.getId().toString());
            info.setSheetId(sheetName);
            iSumRptRela.save((CoreBaseInfo)info);
        }
    }

    public Map sumSinglecalcSaveRela(CslReportInfo reportInfo, List diffTableIds, ISumRptRela iSumRptRela, Map sheetCompanyStr, CslReportRelaInfo reportRelaInfo) throws BOSException, EASBizException {
        HashMap sheetReportIds = new HashMap();
        for (String sheetName : sheetCompanyStr.keySet()) {
            SumRptRelaInfo info;
            String companyIds = (String)sheetCompanyStr.get(sheetName);
            CslReportCollection col = this.iCslReport.getCslReportCollection(this.getReportSql(companyIds, reportRelaInfo, reportInfo));
            ArrayList<String> rptIds = new ArrayList<String>();
            if (col != null && col.size() > 0 || diffTableIds != null) {
                int i;
                if (col != null && col.size() > 0) {
                    for (i = 0; i < col.size(); ++i) {
                        String id = col.get(i).getId().toString();
                        rptIds.add(id);
                        info = new SumRptRelaInfo();
                        info.setReportID(id);
                        info.setSumReportID(reportInfo.getId().toString());
                        info.setSheetId(sheetName);
                        iSumRptRela.save((CoreBaseInfo)info);
                    }
                }
                if (diffTableIds != null) {
                    for (i = 0; i < diffTableIds.size(); ++i) {
                        String diffTableId = (String)diffTableIds.get(i);
                        info = new SumRptRelaInfo();
                        rptIds.add(diffTableId);
                        info.setReportID(diffTableId);
                        info.setSumReportID(reportInfo.getId().toString());
                        info.setSheetId(sheetName);
                        iSumRptRela.save((CoreBaseInfo)info);
                    }
                }
            } else {
                info = new SumRptRelaInfo();
                info.setReportID("empty_company");
                info.setSumReportID(reportInfo.getId().toString());
                info.setSheetId(sheetName);
                iSumRptRela.save((CoreBaseInfo)info);
            }
            sheetReportIds.put(sheetName, rptIds);
        }
        return sheetReportIds;
    }

    private void saveDiffAndSumRela(CslReportInfo reportInfo, List diffTableIds, ISumRptRela iSumRptRela, Map sheetCompanyStr) throws BOSException, EASBizException {
        if (diffTableIds != null) {
            for (int j = 0; j < this.curSheets.getSheetCount(); ++j) {
                String sheetName = this.curSheets.getSheetName(j);
                if (sheetCompanyStr.containsKey(sheetName)) continue;
                for (int i = 0; i < diffTableIds.size(); ++i) {
                    SumRptRelaInfo info = new SumRptRelaInfo();
                    info.setReportID((String)diffTableIds.get(i));
                    info.setSumReportID(reportInfo.getId().toString());
                    info.setSheetId(sheetName);
                    iSumRptRela.save((CoreBaseInfo)info);
                }
            }
        }
    }

    public void allCalcSaveRela(CslReportInfo reportInfo, List diffTableIds, ISumRptRela iSumRptRela, StringBuffer sb, Map sheetCompanyStr, boolean bySumReport) throws BOSException, EASBizException {
        List col = this.iCslReport.getLinkReports(reportInfo.getId().toString(), sb.toString(), bySumReport, true);
        this.saveRptAndSumRela(reportInfo, iSumRptRela, sheetCompanyStr, col);
        this.saveDiffAndSumRela(reportInfo, diffTableIds, iSumRptRela, sheetCompanyStr);
    }

    public CslReportInfo getCurReport() {
        return this.curReport;
    }

    public void setCurReport(CslReportInfo curReport) {
        this.curReport = curReport;
    }

    public Book getCurSheets() {
        return this.curSheets;
    }

    public void setCurSheets(Book curSheets) {
        this.curSheets = curSheets;
    }

    public Map getRelateParamMap() {
        return this.relateParamMap;
    }

    public void setRelateParamMap(Map relateParamMap) {
        this.relateParamMap = relateParamMap;
    }

    private void clearSelfDefineFormula(int startRow, int left, int colCount, Sheet curSheet, int spreadStyle) {
        Cell cellTemp = null;
        for (int j = left; j < left + colCount; ++j) {
            if (spreadStyle == 0) {
                cellTemp = curSheet.getCell(startRow, j, true);
            } else if (spreadStyle == 1) {
                cellTemp = curSheet.getCell(j, startRow, true);
            }
            Range rangeTemp = null;
            String formula = "";
            if (cellTemp != null) {
                rangeTemp = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(cellTemp));
                formula = cellTemp.getFormula();
            }
            if (!DynamicTemplateUtility.isExcelFormula((String)formula) && rangeTemp != null) {
                rangeTemp.setFormula(null);
                rangeTemp.setValue(Variant.nullVariant);
                rangeTemp.setUserObject("ITEM", null);
                rangeTemp.setUserObject("0", null);
                rangeTemp.setUserObject("1", null);
                continue;
            }
            if (rangeTemp == null) continue;
            rangeTemp.setValue(Variant.nullVariant);
            rangeTemp.setUserObject("ITEM", null);
            rangeTemp.setUserObject("0", null);
            rangeTemp.setUserObject("1", null);
        }
    }

    class DynaKeyValue {
        public Integer range;
        public String dynaKey;
        public Integer dynaValueCol;

        DynaKeyValue() {
        }
    }
}

