/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.HandleModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractAdjElimDataControlFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjElimDataControlFacadeControllerBean
extends AbstractAdjElimDataControlFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.AdjElimDataControlFacadeControllerBean");

    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        HashMap initMap = new HashMap();
        return initMap;
    }

    @Override
    protected RptRowSet _getAdjustData(Context ctx, RptProperties param) throws BOSException, EASBizException {
        int year = Integer.parseInt(param.getString("year"));
        int period = Integer.parseInt(param.getString("period"));
        int curyear = Integer.parseInt(param.getString("curYear"));
        int curperiod = Integer.parseInt(param.getString("curPeriod"));
        int periodType = Integer.parseInt(param.getString("periodType"));
        int mergeType = Integer.parseInt(param.getString("mergeType"));
        String treeId = param.getString("treeID");
        String orgUnitId = param.getString("orgUnitID");
        String treeNumber = this.getTreeNumber(ctx, treeId);
        String unitLNumber = this.getUnitLongNumber(ctx, treeId, orgUnitId);
        String preDataTable = this.createPreTempTable(ctx, param, year, period, periodType, treeNumber, unitLNumber, mergeType, "ADJUST");
        String curDataTable = this.createCurTempTable(ctx, param, curyear, curperiod, periodType, treeNumber, unitLNumber, mergeType, "ADJUST");
        param.setString("ELIMINATIONORADJUSTTYPE", "ADJUST");
        return this.getData(ctx, preDataTable, curDataTable, param);
    }

    @Override
    protected RptRowSet _getElimData(Context ctx, RptProperties param) throws BOSException, EASBizException {
        int curperiod;
        int year = Integer.parseInt(param.getString("year"));
        int period = Integer.parseInt(param.getString("period"));
        int curyear = Integer.parseInt(param.getString("curYear"));
        if (curyear == 0) {
            curyear = Integer.parseInt(param.getString("defaultYear"));
        }
        if ((curperiod = Integer.parseInt(param.getString("curPeriod"))) == 0) {
            curperiod = Integer.parseInt(param.getString("defaultPeriod"));
        }
        int periodType = Integer.parseInt(param.getString("periodType"));
        int mergeType = Integer.parseInt(param.getString("mergeType"));
        String treeId = param.getString("treeID");
        String orgUnitId = param.getString("orgUnitID");
        String treeNumber = this.getTreeNumber(ctx, treeId);
        String unitLNumber = this.getUnitLongNumber(ctx, treeId, orgUnitId);
        String preDataTable = this.createPreTempTable(ctx, param, year, period, periodType, treeNumber, unitLNumber, mergeType, "ELIMINATION");
        String curDataTable = this.createCurTempTable(ctx, param, curyear, curperiod, periodType, treeNumber, unitLNumber, mergeType, "ELIMINATION");
        param.setString("ELIMINATIONORADJUSTTYPE", "ELIMINATION");
        return this.getData(ctx, preDataTable, curDataTable, param);
    }

    private RptRowSet getData(Context ctx, String preDataTable, String curDataTable, RptProperties param) throws BOSException, EASBizException {
        RptRowSet rst;
        StringBuffer sql = new StringBuffer();
        String selectPreSql = " fpreid, FpreNumber, fpreMode,FpreEnSeq,Fprecompany,  FpreSummary,FpreItemNum,FpreItemName,FpreDataelement,Fpredebit,FpreCredit,";
        String selectSql = "FSrcCopyID,FEnSeq,FNumber,FMode,Fcompany,FSummary,FItemNum,FItemName,FDataelement,Fdebit,FCredit,  Fcreator,FLastUpdateTime,FAuditStatus,Fauditor,FAuditDate, fhandlemode,fremark";
        sql.append("SELECT 0 isselect,  \n");
        sql.append("       isnull(t.FSrcCopyID, t.FpreID) FpreID,t.FpreEnSeq,t.FpreNumber,t.FpreMode,t.Fprecompany, \n");
        sql.append("       t.FpreSummary,t.FpreItemNum,t.FpreItemName,t.FpreDataelement,t.Fpredebit,t.FpreCredit, \n");
        sql.append("       t.FID,t.FEnSeq,t.FNumber,t.FMode,t.Fcompany,t.FSummary,t.FItemNum,t.FItemName,t.FDataelement,t.Fdebit,t.FCredit, \n");
        sql.append("      t.Fcreator,t.FLastUpdateTime,t.FAuditStatus,t.Fauditor,t.FAuditDate, \n");
        sql.append("       CASE t.fhandlemode WHEN '0' THEN '" + HandleModeEnum.REPRODUCE.getAlias() + "' WHEN '" + 1 + "' THEN '" + HandleModeEnum.MODIFY.getAlias() + "' ELSE '" + HandleModeEnum.NONE.getAlias() + "' END fhandlemode,t.fremark \n");
        sql.append("  FROM (");
        sql.append("\t SELECT " + selectPreSql + " (SELECT TOP 1 fid FROM " + curDataTable + "  WHERE pre.fpreId=FSrcCopyID) AS fid," + selectSql + "\n");
        sql.append("\t   FROM " + curDataTable + " cur \n");
        sql.append("      RIGHT JOIN (SELECT * FROM " + preDataTable + " pre WHERE NOT EXISTS \n");
        sql.append("            (SELECT 1 FROM " + curDataTable + " cur  WHERE cur.FSrcCopyID = pre.fpreID AND pre.FPreEnNum = cur.FEnNum AND pre.fpreDataelement = cur.fDataelement)) pre \n");
        sql.append("         ON cur.FSrcCopyID = pre.fpreID AND pre.FPreEnNum = cur.FEnNum AND pre.fpreDataelement = cur.fDataelement AND pre.FCurrencyId=cur.FCurrencyId \n ");
        sql.append("      UNION ALL \n");
        sql.append("     SELECT " + selectPreSql + " FId," + selectSql + " \n");
        sql.append(" \t   FROM " + preDataTable + " pre \n");
        sql.append("      INNER JOIN " + curDataTable + " cur ON cur.FSrcCopyID = pre.FPreID AND pre.FPreEnNum = cur.FEnNum AND pre.FPreDataelement=cur.FDataElement AND pre.FCurrencyId=cur.FCurrencyId \n");
        sql.append("      UNION ALL \n");
        sql.append(" \t SELECT fpreid, (SELECT TOP 1 FpreNumber FROM " + preDataTable + "  WHERE fpreId=cur.FSrcCopyID) as FpreNumber, fpreMode, \n");
        sql.append("            FpreEnSeq,Fprecompany, FpreSummary, FpreItemNum, FpreItemName, FpreDataelement,Fpredebit,FpreCredit, \n");
        sql.append("\t        FId," + selectSql + " \n");
        sql.append("       FROM " + preDataTable + " pre \n");
        sql.append("      RIGHT JOIN  (SELECT * FROM " + curDataTable + " cur \n");
        sql.append("      WHERE NOT EXISTS (SELECT 1 FROM  " + preDataTable + "   pre WHERE cur.FSrcCopyID = pre.fpreID AND cur.FEnNum=pre.FPreEnNum AND pre.fpreDataelement=cur.fDataelement AND pre.FCurrencyId=cur.FCurrencyId)) cur \n ");
        sql.append("         ON cur.FSrcCopyID = pre.fpreID  AND  pre.FPreEnNum = cur.FEnNum AND  pre.fpreDataelement=cur.fDataelement AND pre.FCurrencyId=cur.FCurrencyId \n");
        sql.append("  ) t \n");
        if (param.containsKey("handleType") && -1 != param.getInt("handleType")) {
            if (2 == param.getInt("handleType")) {
                sql.append(" WHERE (t.FHandleMode=").append(param.getInt("handleType")).append(" or ").append(" t.FHandleMode is null) ");
            } else {
                sql.append(" WHERE t.FHandleMode=").append(param.getInt("handleType"));
            }
        }
        sql.append(" ORDER BY t.FpreNumber, t.fnumber, t.FpreEnSeq , t.FEnSeq, t.fpreitemnum, t.fitemnum\n");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sql.toString(), (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
            this._releaseTempTable(ctx, curDataTable);
            this._releaseTempTable(ctx, preDataTable);
        }
        return rst;
    }

    private String createCurTempTable(Context ctx, RptProperties param, int year, int period, int periodType, String treeNumber, String unitLNumber, int mergeType, String AdjOrElim) throws EASBizException, BOSException {
        String tableName = "Tmp_Cur_" + System.currentTimeMillis();
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName + "  \n");
        create.append("(FID          \t varchar(44),  \n");
        create.append(" FSrcCopyID       varchar(44),  \n");
        create.append(" FCurrencyId      varchar(44),  \n");
        create.append(" FNumber      \t varchar(44),  \n");
        create.append(" FEnNum           varchar(44),  \n");
        create.append(" FMode            varchar(500), \n");
        create.append(" FCompany         nvarchar(500),\n");
        create.append(" FEnSeq           int,          \n");
        create.append(" FSummary         nvarchar(500),\n");
        create.append(" FItemNum         varchar(44),  \n");
        create.append(" FItemName        varchar(500),  \n");
        create.append(" FDebit           NUMERIC(21,6),\n");
        create.append(" FCredit          NUMERIC(21,6),\n");
        create.append(" FDataelement     varchar(44),  \n");
        create.append(" FCreator         varchar(44),  \n");
        create.append(" FLastUpdateTime  DATETIME,     \n");
        create.append(" FAuditstatus     varchar(44),  \n");
        create.append(" FAuditor         varchar(44),  \n");
        create.append(" FAuditDate       DATETIME,     \n");
        create.append(" FHandleMode      varchar(44),  \n");
        create.append(" FRemark          nvarchar(500))\n");
        tableName = this._createTable(ctx, create.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tableName + " \n");
        if (AdjOrElim.equals("ADJUST")) {
            sql.append("select Adj.fid FAdjID,adj.FSrcCopyAdjustID FSrcCopyAdjustID, Adj.fcurrencyid, Adj.fnumber FAdjNumber, to_char(item.FNumber)||'_0' FEnNum,Adjmode.fName_l2 FAdjMode, \n");
            sql.append("       unit.fname_l2 Fcompany,AdjEn.fseq FEnSeq,AdjEn.FSummary FSummary,Item.fnumber FItemNum, \n");
            sql.append("       Item.fname_l2 FItemName,AdjEn.fdebit Fdebit,AdjEn.fcredit FCredit,Ele.fname_l2 FDataelement, \n");
            sql.append("      creator.fname_l2 Fcreator,Adj.FLastUpdateTime FLastUpdateTime,\n");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"911_AdjElimDataControlFacadeControllerBean", (Locale)ctx.getLocale()));
            sql.append(" from t_csl_adjust Adj \n");
            sql.append(" inner join T_CSL_AdjustMode Adjmode on Adjmode.fid = Adj.fadjustMode \n");
            sql.append(" inner join t_csl_adjustentry AdjEn on AdjEn.fadjustID = Adj.Fid \n");
            sql.append(" left join t_pm_user creator on creator.fid = adj.fcreatorid \n");
            sql.append(" left join t_pm_user auditor on auditor.fid = adj.FAuditorID \n");
            sql.append(" inner join T_ORG_Tree tree on tree.fid = Adj.FOrgBoundID \n");
            sql.append(" inner JOIN T_ORG_BaseUnit unit on unit.fid = Adj.forgunit \n");
            sql.append(" inner join T_ORG_Structure str on tree.fid = str.FTreeId AND unit.fid = str.FUnitId  \n");
            sql.append(" inner join t_csl_rptitem item on Item.fid = AdjEn.fitemid \n");
            sql.append(" inner join t_csl_dataelement Ele on Ele.fInterSeq = AdjEn.FDataElement \n");
            sql.append(" where Adj.FSrcCopyAdjustID is not null  and AdjEn.fisvisible = 1 \n");
            sql.append("   and Adj.fyear = " + year + "\n");
            sql.append("   and Adj.fperiod = " + period + "\n");
            sql.append("   and Adj.fperiodType = " + periodType + "\n");
            sql.append("   and tree.fnumber = '" + treeNumber + "' \n");
            sql.append("   and (str.FLongNumber LIKE '" + unitLNumber + "!%' OR str.FLongNumber = '" + unitLNumber + "') \n");
            if (mergeType == 1) {
                sql.append("       AND str.FLongNumber NOT LIKE '" + unitLNumber + "!%!%' \n");
            }
            String unitFilter = null;
            unitFilter = param.getString("unitEqualsFilter").length() > 0 ? param.getString("unitEqualsFilter") : param.getString("unitInFilter");
            if (unitFilter != null) {
                sql.append("   and " + unitFilter.replaceAll("orgUnit.id", "unit.fid") + " \n");
            }
        } else {
            sql.append("select Elim.fid FElimID,Elim.FSrcCopyElimID FSrcCopyElimID,Elim.fcurrencyid, Elim.fnumber FElimNumber, to_char(item.FNumber)||'_0' FEnNum, \n");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"912_AdjElimDataControlFacadeControllerBean", (Locale)ctx.getLocale()));
            sql.append("       com.fname_l2 Fcompany,ElimEn.fseq FEnSeq,ElimEn.FSummary FSummary,Item.fnumber FItemNum,  \n");
            sql.append("       Item.fname_l2 FItemName,ElimEn.fdebit Fdebit,ElimEn.fcredit FCredit,Ele.fname_l2 FDataelement,  \n");
            sql.append("      creator.fname_l2 Fcreator,Elim.FLastUpdateTime FLastUpdateTime, \n");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"913_AdjElimDataControlFacadeControllerBean", (Locale)ctx.getLocale()));
            sql.append("       Elim.FHandleMode FHandleMode,Elim.FRemark FRemark \n");
            sql.append(" from t_csl_elimination Elim  \n");
            sql.append(" inner join t_csl_eliminationentry ElimEn on ElimEn.feliminationID = Elim.Fid  \n");
            sql.append(" left join t_org_baseunit com on com.fid = ElimEn.FCompanyid \n");
            sql.append(" left join t_pm_user creator on creator.fid = Elim.fcreatorid  \n");
            sql.append(" left join t_pm_user auditor on auditor.fid = Elim.FAuditorID  \n");
            sql.append(" inner join T_ORG_Tree tree on tree.fid = Elim.FOrgBoundID  \n");
            sql.append(" inner JOIN T_ORG_BaseUnit unit on unit.fid = Elim.forgunit  \n");
            sql.append(" inner join T_ORG_Structure str on tree.fid = str.FTreeId AND unit.fid = str.FUnitId  \n");
            sql.append(" inner join t_csl_rptitem item on Item.fid = ElimEn.fitemid  \n");
            sql.append(" inner join t_csl_dataelement Ele on Ele.fInterSeq = ElimEn.FDataElement  \n");
            sql.append(" where Elim.FSrcCopyElimID is not null  and ElimEn.fisvisible = 1 \n");
            sql.append("   and Elim.fyear = " + year + "\n");
            sql.append("   and Elim.fperiod = " + period + "\n");
            String typeFilter = param.getString("typeFilter");
            if (!StringUtils.isEmpty((String)typeFilter)) {
                sql.append(" and ").append(typeFilter.replaceAll("displayTemplateType.id", "Elim.fdisplaytemplatetypeid")).append(" \n");
            }
            sql.append("   and tree.fnumber = '" + treeNumber + "' \n");
            sql.append("   and str.FLongNumber = '" + unitLNumber + "' \n");
            if (param.containsKey("type")) {
                sql.append(" and Elim.felimtype=").append(param.getInt("type"));
            }
        }
        this._executeUpdate(ctx, sql.toString());
        this.handDumpEntryNumber(ctx, tableName, false);
        return tableName;
    }

    private String createPreTempTable(Context ctx, RptProperties param, int year, int period, int periodType, String treeNumber, String unitLNumber, int mergeType, String AdjOrElim) throws EASBizException, BOSException {
        String tableName = "Tmp_Pre_" + System.currentTimeMillis();
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName + " \n");
        create.append("(FpreID          varchar(44),  \n");
        create.append(" FCurrencyId     varchar(44),  \n");
        create.append(" FpreNumber      varchar(44),  \n");
        create.append(" FPreEnNum       varchar(44),  \n");
        create.append(" FpreMode        varchar(44), \n");
        create.append(" FpreCompany        nvarchar(500),\n");
        create.append(" FpreEnSeq          int,          \n");
        create.append(" FpreSummary        nvarchar(500),\n");
        create.append(" FpreItemNum        varchar(44),  \n");
        create.append(" FpreItemName       nvarchar(500), \n");
        create.append(" FpreDebit          NUMERIC(21,6),\n");
        create.append(" FpreCredit         NUMERIC(21,6),\n");
        create.append(" FpreDataelement    varchar(44))  \n");
        tableName = this._createTable(ctx, create.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tableName + " \n");
        if (AdjOrElim.equals("ADJUST")) {
            sql.append("select preAdj.fid FpreAdjID, preAdj.fcurrencyid, preAdj.fnumber FpreAdjNumber,to_char(preItem.FNumber)||'_0' FPreEnNum,premode.fName_l2 FpreAdjMode,unit.fname_l2 Fprecompany,  \n");
            sql.append("       preEntry.fseq FpreEnSeq,preEntry.FSummary FpreSummary,preItem.fnumber FpreItemNum,preItem.fname_l2 FpreItemName, \n");
            sql.append("       preentry.fdebit Fpredebit,preentry.fcredit FpreCredit,preEle.fname_l2 FpreElement \n");
            sql.append("  from t_csl_adjust preAdj \n");
            sql.append(" inner join t_csl_adjustentry preEntry on preEntry.fadjustID = preAdj.Fid \n");
            sql.append(" inner join T_ORG_Tree tree on tree.fid = preAdj.FOrgBoundID \n");
            sql.append(" INNER JOIN T_ORG_BaseUnit unit on unit.fid = preAdj.forgunit \n");
            sql.append(" inner join T_ORG_Structure str on tree.fid = str.FTreeId AND unit.fid = str.FUnitId  \n");
            sql.append(" INNER JOIN T_CSL_AdjustMode preMode on preMode.fid = preAdj.fadjustMode \n");
            sql.append(" inner join t_csl_rptitem preitem on preItem.fid = preEntry.fitemid \n");
            sql.append(" inner join t_csl_dataelement preEle on preEle.fInterSeq = preentry.FDataElement \n");
            sql.append(" where preAdj.FIsCitedByLater = 1 and preAdj.FcheckedStatus =2  and preEntry.fisvisible = 1 \n");
            sql.append("   and preAdj.fyear = " + year + "\n");
            sql.append("   and preAdj.fperiod = " + period + "\n");
            sql.append("   and preAdj.fperiodType = " + periodType + "\n");
            sql.append("   and tree.fnumber = '" + treeNumber + "' \n");
            sql.append("   and (str.FLongNumber LIKE '" + unitLNumber + "!%' OR str.FLongNumber = '" + unitLNumber + "') \n");
            if (mergeType == 1) {
                sql.append("       AND str.FLongNumber NOT LIKE '" + unitLNumber + "!%!%' \n");
            }
            String unitFilter = null;
            if (param.getString("unitEqualsFilter").length() > 0) {
                unitFilter = param.getString("unitEqualsFilter");
                if (unitFilter != null) {
                    sql.append("   and unit.fnumber in( select fnumber from t_org_baseunit where " + unitFilter.replaceAll("orgUnit.id", "fid") + ") \n");
                }
            } else {
                boolean isDisplayAdjustRPTMByOrg = CslRptUtil.isDisplayAdjustRPTMByOrg(ctx);
                if (isDisplayAdjustRPTMByOrg) {
                    String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
                    sql.append("   and unit.fid in (select distinct forgid from t_pm_orgrange where fuserid='" + userId + "' and ftype=" + 10 + ") \n");
                }
            }
        } else {
            sql.append("select preElim.fid FpreElimID, preElim.fcurrencyid,preElim.fnumber FpreElimNumber, to_char(preitem.FNumber)||'_0' FPreEnNum, \n");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"914_AdjElimDataControlFacadeControllerBean", (Locale)ctx.getLocale()));
            sql.append("       com.fname_l2 Fprecompany,preEntry.fseq FpreEnSeq,preEntry.FSummary FpreSummary,preItem.fnumber FpreItemNum,preItem.fname_l2 FpreItemName,  \n");
            sql.append("       preentry.fdebit Fpredebit,preentry.fcredit FpreCredit,preEle.fname_l2 FpreElement \n");
            sql.append("  from t_csl_elimination preElim \n");
            sql.append(" inner join t_csl_eliminationentry preEntry on preEntry.feliminationid = preElim.fid \n");
            sql.append(" left join t_org_baseunit com on com.fid = preEntry.FCompanyid \n");
            sql.append(" inner join T_ORG_Tree tree on tree.fid = preElim.FOrgBoundID \n");
            sql.append(" inner join T_ORG_BaseUnit unit on unit.fid = preElim.forgunit \n");
            sql.append(" inner join T_ORG_Structure str on tree.fid = str.FTreeId AND unit.fid = str.FUnitId  \n");
            sql.append(" inner join t_csl_rptitem preitem on preItem.fid = preEntry.fitemid \n");
            sql.append(" inner join t_csl_dataelement preEle on preEle.fInterSeq = preEntry.FDataElement \n");
            sql.append(" where preElim.FIsCitedByLater = 1  and preElim.FcheckedStatus = 2 and preEntry.fisvisible = 1 \n");
            sql.append("   and preElim.fyear = " + year + "\n");
            sql.append("   and preElim.fperiod = " + period + "\n");
            String typeFilter = param.getString("typeFilter");
            if (!StringUtils.isEmpty((String)typeFilter)) {
                sql.append(" and ").append(typeFilter.replaceAll("displayTemplateType.id", "preElim.fdisplaytemplatetypeid")).append(" \n");
            }
            sql.append("   and tree.fnumber ='" + treeNumber + "' \n");
            sql.append("   and str.FLongNumber = '" + unitLNumber + "' \n");
            if (param.containsKey("type")) {
                sql.append(" and preElim.felimtype=").append(param.getInt("type"));
            }
            if (param.containsKey("elimMode")) {
                sql.append(" and preElim.FEliminationModeId='").append(param.getString("elimMode")).append("'");
            }
        }
        this._executeUpdate(ctx, sql.toString());
        this.handDumpEntryNumber(ctx, tableName, true);
        return tableName;
    }

    private void handDumpEntryNumber(Context ctx, String tableName, boolean isPre) throws BOSException {
        String fenseq;
        String fennumber;
        String fdataelement;
        String fitemnumber;
        String fnumber;
        String fid;
        if (isPre) {
            fid = "FPreId";
            fnumber = "FPreNumber";
            fitemnumber = "FPreItemNum";
            fdataelement = "FPreDataElement";
            fennumber = "FPreEnNum";
            fenseq = "FPreEnSeq";
        } else {
            fid = "FId";
            fnumber = "FNumber";
            fitemnumber = "FItemNum";
            fdataelement = "FDataElement";
            fennumber = "FEnNum";
            fenseq = "FEnSeq";
        }
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT t." + fid + " FId, t." + fnumber + " FNumber, t." + fitemnumber + " FItemNumber, t." + fdataelement + " FDataElement, t." + fennumber + " FEnNumber, t." + fenseq + " FEnSeq ");
        builder.append("  FROM " + tableName + " t ");
        builder.append(" INNER JOIN (SELECT COUNT(1) cnt, " + fid + ", " + fitemnumber + ", " + fdataelement + " FROM " + tableName + " t1 GROUP BY " + fid + ", " + fitemnumber + ", " + fdataelement + " HAVING COUNT(1) >= 2) t2 ON t." + fid + "=t2." + fid + " AND t." + fitemnumber + "=t2." + fitemnumber + " AND t." + fdataelement + "=t2." + fdataelement + " \n");
        builder.append(" ORDER BY FNumber, FItemnumber, FDataElement");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        Connection cn = null;
        Statement st = null;
        try {
            cn = this.getConnection(ctx);
            st = cn.createStatement();
            String preId = "";
            String preNumber = "";
            String preItemNum = "";
            String preDataElement = "";
            String preEnNum = "";
            String preEnSeq = "";
            int index = 0;
            while (rs.next()) {
                String id = rs.getString("FId");
                String number = rs.getString("FNumber");
                String itemNum = rs.getString("FItemNumber");
                String dataElement = rs.getString("FDataElement");
                String enNum = rs.getString("FEnNumber");
                String enSeq = rs.getString("FEnSeq");
                index = id.equals(preId) && number.equals(preNumber) && itemNum.equals(preItemNum) && dataElement.equals(preDataElement) ? ++index : 0;
                builder.reset();
                builder.append("UPDATE " + tableName + " SET " + fennumber + "='" + itemNum + "_" + index + "'");
                builder.append(" where " + fid + "='" + id + "'");
                builder.append("   and " + fnumber + "='" + number + "'");
                builder.append("   and " + fitemnumber + "='" + itemNum + "'");
                builder.append("   and " + fdataelement + "='" + dataElement + "'");
                builder.append("   and " + fennumber + "='" + enNum + "'");
                builder.append("   and " + fenseq + "='" + enSeq + "'");
                st.addBatch(builder.getSQL());
                preId = id;
                preNumber = number;
                preItemNum = itemNum;
                preDataElement = dataElement;
                preEnNum = enNum;
                preEnSeq = enSeq;
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    private String getTreeNumber(Context ctx, String treeId) throws BOSException, EASBizException {
        String treeNumber = "";
        IRowSet rsTree = DbUtil.executeQuery((Context)ctx, (String)" select FNumber From t_org_tree where fid = ?", (Object[])new Object[]{treeId});
        try {
            while (rsTree.next()) {
                treeNumber = rsTree.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return treeNumber;
    }

    private String getUnitLongNumber(Context ctx, String treeId, String orgUnitId) throws BOSException, EASBizException {
        String longNumber = "";
        IRowSet rsOrgUnit = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsOrgUnit.next()) {
                longNumber = rsOrgUnit.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return longNumber;
    }

    private String[] getTreeAndUnitID(Context ctx, String treeId, String orgUnitId, int year, int period, int periodType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  str.ftreeid,str.funitid from t_org_structure str \n");
        sql.append("  inner join t_org_tree tree on tree.fid = str.ftreeid \n");
        sql.append("  where tree.fnumber = (select fnumber from t_org_tree where fid = ?) \n");
        sql.append("  and str.flongnumber = (select flongnumber from t_org_structure where funitid = ? and ftreeid = ? ) \n");
        sql.append("  and  tree.fstartdate <=? and( tree.fenddate is null or tree.fenddate >=?) \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(treeId);
        params.add(orgUnitId);
        params.add(treeId);
        params.add(new Timestamp(RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()));
        params.add(new Timestamp(RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()));
        String[] treeAndUnit = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                treeAndUnit = new String[]{rs.getString("FTreeId"), rs.getString("FUnitId")};
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return treeAndUnit;
    }

    private Set getUnits(Context ctx, String treeId, String orgUnitId, int mergeType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct str.funitid  from t_org_structure str \n");
        sql.append("  inner join t_org_structure str2 on str2.flongnumber =  str.flongnumber \n");
        sql.append("    where str2.ftreeid = ? and (str2.flongnumber like ? or str2.flongnumber = ? )\n");
        ArrayList<String> params = new ArrayList<String>();
        params.add(treeId);
        String unitNumber = this.getUnitLongNumber(ctx, treeId, orgUnitId);
        params.add(unitNumber + "!%");
        params.add(unitNumber);
        if (mergeType == 1) {
            // empty if block
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        HashSet<String> companyIds = new HashSet<String>();
        try {
            while (rs.next()) {
                companyIds.add(rs.getString("funitid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return companyIds;
    }

    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        this._dropTable(ctx, tableName);
    }

    @Override
    protected List _copyHisAdjustData(Context ctx, RptProperties param) throws BOSException, EASBizException {
        int year = Integer.parseInt(param.getString("defaultYear"));
        int period = Integer.parseInt(param.getString("defaultPeriod"));
        int periodType = Integer.parseInt(param.getString("periodType"));
        int mergeType = Integer.parseInt(param.getString("mergeType"));
        DataCollectInfo dataCollect = null;
        if (param.getObject("dataCollect") instanceof DataCollectInfo) {
            dataCollect = (DataCollectInfo)param.getObject("dataCollect");
        } else {
            dataCollect = new DataCollectInfo();
            dataCollect.setNumber("ACTUALDATA");
        }
        String treeId = param.getString("treeID");
        String unitId = param.getString("orgUnitID");
        String[] tu = this.getTreeAndUnitID(ctx, treeId, unitId, year, period, periodType);
        OrgTreeInfo orgTreeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tu[0])));
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tu[1])));
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new AdjustInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
        RPTItemInfo unAllotRptItemInfo = this.getUnAllotRptItemId(ctx);
        UserInfo nowUser = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Date date = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        String autoSummary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"97_AdjustControllerBean", (Locale)ctx.getLocale());
        Set companyIds = this.getUnits(ctx, orgTreeInfo.getId().toString(), orgUnitInfo.getId().toString(), mergeType);
        ArrayList<String> removeDataList = new ArrayList<String>();
        ArrayList list = (ArrayList)param.getObject("list");
        ArrayList<AdjustEntryInfo> removeList = new ArrayList<AdjustEntryInfo>();
        AdjustInfo newInfo = null;
        AdjustInfo oldInfo = null;
        AdjustEntryInfo lineInfo = null;
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        BOSObjectType bosType = new AdjustDynamicItemInfo().getBOSType();
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        int size = list.size();
        for (int j = 0; j < size; ++j) {
            String id = (String)list.get(j);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            try {
                oldInfo = iAdjust.getAdjustInfo((IObjectPK)pk, this.getAdjustSelector());
            }
            catch (Exception e) {
                removeDataList.add("notExitPreElim");
                return removeDataList;
            }
            if (!companyIds.contains(oldInfo.getOrgUnit().getId().toString())) {
                removeDataList.add(oldInfo.getNumber());
                continue;
            }
            newInfo = new AdjustInfo();
            newInfo = (AdjustInfo)oldInfo.clone();
            newInfo.setOrgUnit(oldInfo.getOrgUnit());
            if (oldInfo.getDataSource().getValue() == 2 || oldInfo.getDataSource().getValue() == 3) {
                newInfo.setOrgUnit(orgUnitInfo);
            }
            newInfo.setOrgBound(orgTreeInfo);
            newInfo.setSrcCopyAdjust(oldInfo);
            newInfo.setHandleMode(HandleModeEnum.REPRODUCE);
            newInfo.setDate(date);
            newInfo.setYear(year);
            newInfo.setPeriod(period);
            newInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            newInfo.setId(null);
            newInfo.setNumber(null);
            newInfo.setAuditDate(null);
            newInfo.setAuditor(null);
            newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            newInfo.setCreator(nowUser);
            newInfo.setCreateTime(time);
            newInfo.setDataCollect(dataCollect);
            newInfo.setDataCollectNumber(dataCollect.getNumber());
            if (!hasCodeRule) {
                String number = this.getCurrentMaxNumber(ctx, orgTreeInfo.getId().toString(), periodType, year, period, "t_csl_adjust");
                newInfo.setNumber(number);
            }
            BigDecimal debit = new BigDecimal("0");
            BigDecimal credit = new BigDecimal("0");
            BigDecimal zero = new BigDecimal("0");
            int oldYear = oldInfo.getYear();
            AdjustEntryCollection col = newInfo.getEntries();
            this.queryAdjustDetails(ctx, col);
            Object adjustDynamicItems = null;
            for (int i = 0; i < col.size(); ++i) {
                col.get(i).getAdjustDynamicItem().clear();
                if (oldYear < year && col.get(i).getItem().isIsProfitAndLosses() && col.get(i).getDataElement() == 3) {
                    lineInfo = col.get(i);
                    if (col.get(i).getDebit() != null) {
                        debit = debit.add(col.get(i).getDebit());
                    } else if (col.get(i).getCredit() != null) {
                        credit = credit.add(col.get(i).getCredit());
                    }
                    removeList.add(col.get(i));
                    continue;
                }
                if (col.get(i).getSummary() != null && (col.get(i).getSummary().equals("AdjustEntry_Auto_Summary") || col.get(i).getSummary().equals(autoSummary))) {
                    removeList.add(col.get(i));
                    continue;
                }
                bosUuid = BOSUuid.create((BOSObjectType)bosType);
                entryIds.put(col.get(i).getId().toString(), bosUuid.toString());
                col.get(i).setId(bosUuid);
                col.get(i).getAdjust().setId(null);
            }
            if (!removeList.isEmpty()) {
                int n = removeList.size();
                for (int k = 0; k < n; ++k) {
                    newInfo.getEntries().remove((AdjustEntryInfo)removeList.get(k));
                }
                removeList.clear();
                if (lineInfo != null) {
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(lineInfo.getId().toString(), bosUuid.toString());
                    lineInfo.setDataElement(3);
                    lineInfo.setItem(unAllotRptItemInfo);
                    lineInfo.setId(null);
                    lineInfo.getAdjust().setId(null);
                    if (debit.subtract(credit).compareTo(zero) == 1) {
                        lineInfo.setDebit(debit.subtract(credit));
                        lineInfo.setCredit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == -1) {
                        lineInfo.setCredit(credit.subtract(debit));
                        lineInfo.setDebit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == 0 || debit.subtract(credit).compareTo(zero) == 0) {
                        lineInfo.setDebit(null);
                        lineInfo.setCredit(null);
                    }
                    col.add(lineInfo);
                    newInfo.setHandleMode(HandleModeEnum.MODIFY);
                }
            }
            if (newInfo.getEntries().size() == 0) continue;
            newInfo.remove("id");
            iAdjust.submit((CoreBaseInfo)newInfo);
        }
        list.clear();
        CslRptUtil.copyDynamicItem(ctx, entryIds, true);
        return removeDataList;
    }

    private void queryAdjustDetails(Context ctx, AdjustEntryCollection collection) throws BOSException, EASBizException {
        for (int m = 0; m < collection.size(); ++m) {
            if (collection.get(m).getHasAdjustDetails().getValue() != 1 || collection.get(m).getId() == null) continue;
            collection.get(m).put("entryDetails", (Object)RelatingAdjustElimHelper.queryAdjustDetails(ctx, collection.get(m).getId().toString()));
        }
    }

    private SelectorItemCollection getAdjustSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("adjustMode.name"));
        sic.add(new SelectorItemInfo("templet.id"));
        sic.add(new SelectorItemInfo("templet.name"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("handleMode"));
        sic.add(new SelectorItemInfo("customNumber"));
        sic.add(new SelectorItemInfo("srcCopyAdjust.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.item.effectItem"));
        sic.add(new SelectorItemInfo("entries.item.id"));
        sic.add(new SelectorItemInfo("entries.item.number"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
        sic.add(new SelectorItemInfo("entries.hasAdjustDetails"));
        sic.add(new SelectorItemInfo("entries.debit"));
        sic.add(new SelectorItemInfo("entries.credit"));
        sic.add(new SelectorItemInfo("entries.isVisible"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("orgBound.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.adjust.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("isCitedByLater"));
        sic.add(new SelectorItemInfo("isFixed"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        sic.add(new SelectorItemInfo("dataCollect.number"));
        sic.add(new SelectorItemInfo("entries.adjustDynamicItem.*"));
        return sic;
    }

    private Object getParamValue(Context ctx, String key) {
        Object value = null;
        try {
            value = CslRptUtil.getParamValue(ctx, null, key);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    private boolean multiEliminationEntryInfo(EliminationEntryInfo entryInfo, EliminationInfo info, BigDecimal bDebit, BigDecimal bCredit, List lstRemove, int iHiddleCount, boolean bResult) {
        EliminationEntryCollection col = info.getEntries();
        if (null != entryInfo) {
            RPTItemInfo item = entryInfo.getItem();
            BigDecimal sub = bDebit.subtract(bCredit);
            if (sub.compareTo(BigDecimal.valueOf(0L)) >= 0) {
                entryInfo.setDebit(bDebit.subtract(bCredit));
                entryInfo.setCredit(null);
            } else {
                entryInfo.setCredit(bCredit.subtract(bDebit));
                entryInfo.setDebit(null);
            }
            col.add(entryInfo);
            this.removeCreditAndDebitIsZero(lstRemove, info);
            this.removeEntry(lstRemove, col);
        }
        if (null == col || col.size() == 0 || col.size() == iHiddleCount) {
            bResult = false;
        }
        return bResult;
    }

    private void removeCreditAndDebitIsZero(List lstDeleteEntry, EliminationInfo info) {
        EliminationEntryCollection entriesCollection = info.getEntries();
        EliminationEntryInfo entryInfo = null;
        int iSize = entriesCollection.size();
        for (int i = 0; i < iSize; ++i) {
            entryInfo = entriesCollection.get(i);
            this.convertZeroToNull(entryInfo);
            if (null != entryInfo.getCredit() || null != entryInfo.getDebit()) continue;
            lstDeleteEntry.add(entriesCollection.get(i));
        }
    }

    private void convertZeroToNull(EliminationEntryInfo entryInfo) {
        int iResult = 0;
        if (null != entryInfo.getCredit() && iResult == BigDecimal.valueOf(0L).compareTo(entryInfo.getCredit())) {
            entryInfo.setCredit(null);
        }
        if (null != entryInfo.getDebit() && iResult == BigDecimal.valueOf(0L).compareTo(entryInfo.getDebit())) {
            entryInfo.setDebit(null);
        }
    }

    private void removeEntry(List lstDeleteEntry, EliminationEntryCollection entry) {
        if (null != lstDeleteEntry && lstDeleteEntry.size() != 0) {
            int iSize = lstDeleteEntry.size();
            for (int i = 0; i < iSize; ++i) {
                entry.remove((EliminationEntryInfo)lstDeleteEntry.get(i));
            }
        }
    }

    @Override
    protected List _copyHisElimData(Context ctx, RptProperties param) throws BOSException, EASBizException {
        int year = Integer.parseInt(param.getString("defaultYear"));
        int period = Integer.parseInt(param.getString("defaultPeriod"));
        int periodType = Integer.parseInt(param.getString("periodType"));
        int mergeType = Integer.parseInt(param.getString("mergeType"));
        int oldYear = 0;
        String orgTreeId = param.getString("treeID");
        DataCollectInfo dataCollect = null;
        if (param.getObject("dataCollect") instanceof DataCollectInfo) {
            dataCollect = (DataCollectInfo)param.getObject("dataCollect");
        } else {
            dataCollect = new DataCollectInfo();
            dataCollect.setNumber("ACTUALDATA");
        }
        String treeId = param.getString("treeID");
        String unitId = param.getString("orgUnitID");
        String[] tu = this.getTreeAndUnitID(ctx, treeId, unitId, year, period, periodType);
        OrgTreeInfo orgTreeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tu[0])));
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tu[1])));
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new EliminationInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
        RPTItemInfo unAllotRptItemInfo = this.getUnAllotRptItemId(ctx);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Date date = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        Set companyIds = this.getUnits(ctx, orgTreeInfo.getId().toString(), orgUnitInfo.getId().toString(), mergeType);
        ArrayList<String> removeDataList = new ArrayList<String>();
        ArrayList<EliminationInfo> oldInfoList = new ArrayList<EliminationInfo>();
        ArrayList<String> currencyList = new ArrayList<String>();
        ArrayList list = (ArrayList)param.getObject("list");
        IElimination iElim = EliminationFactory.getLocalInstance(ctx);
        Object oParamValue = this.getParamValue(ctx, "GR_CSL_AllowElimRRTM");
        for (int j = 0; j < list.size(); ++j) {
            String id = (String)list.get(j);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            EliminationInfo info = null;
            try {
                info = iElim.getEliminationInfo((IObjectPK)pk, this.getElimSelectors());
            }
            catch (Exception e) {
                removeDataList.add("notExitPreElim");
                return removeDataList;
            }
            info.setHandleMode(HandleModeEnum.REPRODUCE);
            if (!currencyList.contains(info.getCurrency().getId().toString() + "@@@" + info.getSourceCurrency().getId().toString() + "@@@" + info.getValueType().getValue())) {
                currencyList.add(info.getCurrency().getId().toString() + "@@@" + info.getSourceCurrency().getId().toString() + "@@@" + info.getValueType().getValue());
            }
            String company = "";
            BigDecimal bCredit = BigDecimal.valueOf(0L);
            BigDecimal bDebit = BigDecimal.valueOf(0L);
            HashMap unAllotCom = new HashMap();
            ArrayList<Serializable> unAllotData = new ArrayList<Serializable>(3);
            EliminationEntryCollection col = info.getEntries();
            oldYear = info.getYear();
            boolean isallin = true;
            EliminationEntryInfo entryInfo = null;
            int iHiddleCount = 0;
            ArrayList<EliminationEntryInfo> lstRemove = new ArrayList<EliminationEntryInfo>();
            for (int i = col.size() - 1; i >= 0; --i) {
                EliminationEntryInfo lineInfo = col.get(i);
                if (lineInfo.getCompany() == null) continue;
                isallin = lineInfo.getCompany() == null || companyIds.contains(lineInfo.getCompany().getId().toString());
                entryInfo = null;
                company = lineInfo.getCompany().getName();
                if (oldYear < year && lineInfo.getItem().isIsProfitAndLosses() && lineInfo.getDataElement() == 3 && lineInfo.isIsVisible()) {
                    info.setHandleMode(HandleModeEnum.MODIFY);
                    if (!"false".equals(oParamValue)) continue;
                    if (unAllotCom.containsKey(company)) {
                        unAllotData = (ArrayList<Serializable>)unAllotCom.get(company);
                        bDebit = (BigDecimal)unAllotData.get(0);
                        bCredit = (BigDecimal)unAllotData.get(1);
                        if (lineInfo.getDebit() != null) {
                            bDebit = bDebit.add(lineInfo.getDebit());
                            unAllotData.set(0, bDebit);
                        }
                        if (lineInfo.getCredit() != null) {
                            bCredit = bCredit.add(lineInfo.getCredit());
                            unAllotData.set(1, bCredit);
                        }
                    } else {
                        unAllotData = new ArrayList<Serializable>(3);
                        bCredit = BigDecimal.valueOf(0L);
                        bDebit = BigDecimal.valueOf(0L);
                        if (lineInfo.getDebit() != null) {
                            bDebit = bDebit.add(lineInfo.getDebit());
                        }
                        if (lineInfo.getCredit() != null) {
                            bCredit = bCredit.add(lineInfo.getCredit());
                        }
                        unAllotData.add(bDebit);
                        unAllotData.add(bCredit);
                        entryInfo = (EliminationEntryInfo)lineInfo.clone();
                        entryInfo.setItem(unAllotRptItemInfo);
                        entryInfo.setDataElement(3);
                        unAllotData.add(entryInfo);
                        unAllotCom.put(company, unAllotData);
                    }
                    lstRemove.add(lineInfo);
                    continue;
                }
                if (lineInfo.isIsVisible()) continue;
                ++iHiddleCount;
            }
            if (oldYear < year && "false".equals(oParamValue)) {
                if (unAllotCom.size() > 0) {
                    Set keySet = unAllotCom.keySet();
                    for (String key : keySet) {
                        ArrayList bList = (ArrayList)unAllotCom.get(key);
                        bDebit = (BigDecimal)bList.get(0);
                        bCredit = (BigDecimal)bList.get(1);
                        entryInfo = (EliminationEntryInfo)bList.get(2);
                        isallin = this.multiEliminationEntryInfo(entryInfo, info, bDebit, bCredit, lstRemove, iHiddleCount, true);
                    }
                } else {
                    isallin = this.multiEliminationEntryInfo(entryInfo, info, bDebit, bCredit, lstRemove, iHiddleCount, true);
                }
            }
            if (isallin) {
                oldInfoList.add(info);
                continue;
            }
            removeDataList.add(info.getNumber());
        }
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        BOSObjectType bosType = new ElimDynaItemEntryInfo().getBOSType();
        ArrayList<EliminationInfo> newInfoList = null;
        newInfoList = new ArrayList<EliminationInfo>(oldInfoList.size());
        for (int i = 0; i < oldInfoList.size(); ++i) {
            EliminationInfo newData = new EliminationInfo();
            newInfoList.add(newData);
            EliminationInfo oldData = (EliminationInfo)oldInfoList.get(i);
            newData.setId(oldData.getId());
            newData.setSrcCopyElim(oldData);
            newData.setHandleMode(oldData.getHandleMode());
            if (oldData.getDisplayTemplateType() != null) {
                newData.setDisplayTemplateType(oldData.getDisplayTemplateType());
            }
            newData.setCurrency(oldData.getCurrency());
            newData.setSourceCurrency(oldData.getSourceCurrency());
            newData.setValueType(oldData.getValueType());
            newData.setDataCollect(oldData.getDataCollect());
            newData.setDataCollectNumber(oldData.getDataCollectNumber());
            newData.setIsFixed(oldData.getIsFixed());
            newData.setRemark(oldData.getRemark());
            newData.setEliminationMode(oldData.getEliminationMode());
            newData.setCustomNumber(oldData.getCustomNumber());
            newData.setSourceElimination(oldData);
            newData.setInvestNewType(oldData.getInvestNewType());
            newData.setHasEffected(oldData.isHasEffected());
            newData.setElimType(oldData.getElimType());
            for (int j = 0; j < oldData.getEntries().size(); ++j) {
                EliminationEntryInfo entryInfo = oldData.getEntries().get(j);
                bosUuid = BOSUuid.create((BOSObjectType)bosType);
                entryIds.put(entryInfo.getId().toString(), bosUuid.toString());
                entryInfo.setId(bosUuid);
                newData.getEntries().add(entryInfo);
            }
        }
        IElimination ielimination = EliminationFactory.getLocalInstance(ctx);
        for (int i = 0; i < newInfoList.size(); ++i) {
            EliminationInfo newInfo = (EliminationInfo)newInfoList.get(i);
            newInfo.setYear(year);
            newInfo.setPeriod(period);
            newInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            newInfo.setOrgBound(orgTreeInfo);
            newInfo.setOrgUnit(orgUnitInfo);
            newInfo.setCreator(user);
            newInfo.setCreateTime(time);
            newInfo.setDate(date);
            newInfo.setAuditDate(null);
            newInfo.setAuditor(null);
            newInfo.setNumber(null);
            newInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            newInfo.setIsCitedByLater(IsCitedByLaterEnum.ISTRUE);
            newInfo.setDataCollect(dataCollect);
            newInfo.setDataCollectNumber(dataCollect.getNumber());
            String currentNumber = null;
            if (hasCodeRule) {
                currentNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)newInfo, CSLServerHelper.getRootOrgIDForRootCU(ctx));
                newInfo.setNumber(currentNumber);
            } else {
                currentNumber = this.getCurrentMaxNumber(ctx, orgTreeId, periodType, year, period, "t_csl_elimination");
                newInfo.setNumber(currentNumber);
            }
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            String oldId = newInfo.getId().toString();
            newInfo.setId(null);
            IObjectPK pk = oldYear < year ? ielimination.addnewHand((CoreBaseInfo)newInfo) : ielimination.addnew((CoreBaseInfo)newInfo);
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            String[] attachIDs = asm.getAttachmentIDsByBoID(oldId);
            asm.addAssociations(pk.toString(), attachIDs);
        }
        CslRptUtil.copyDynamicItem(ctx, entryIds, false);
        return removeDataList;
    }

    private SelectorItemCollection getElimSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.effectItem"));
        sic.add(new SelectorItemInfo("entries.item.id"));
        sic.add(new SelectorItemInfo("entries.item.number"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("entries.company.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("displayTemplateType.id"));
        sic.add(new SelectorItemInfo("displayTemplateType.name"));
        sic.add(new SelectorItemInfo("displayTemplateType.number"));
        return sic;
    }

    private String getCurrentMaxNumber(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("0");
        StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("  WHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like 'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            String tempNumber = "";
            BigDecimal curNumber = new BigDecimal("1");
            while (rs.next()) {
                tempNumber = rs.getString("Fnumber");
                if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                number = curNumber;
            }
            if (number != null) {
                number = number.add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private RPTItemInfo getUnAllotRptItemId(Context ctx) throws BOSException, EASBizException {
        String oql = "select id,number,name, effectItem, isProfitAndLosses WHERE isFreezed = 0 and control = 10";
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{RPTItemControlEnum.UNALLOTGAIN_SYEAR.getAlias()});
    }

    @Override
    protected List _getPrePeriod(Context ctx, RptProperties param, boolean isAdjust) throws BOSException, EASBizException {
        ArrayList<String> yp = null;
        int year = Integer.parseInt(param.getString("defaultYear"));
        int period = Integer.parseInt(param.getString("defaultPeriod"));
        int periodType = Integer.parseInt(param.getString("periodType"));
        int mergeType = Integer.parseInt(param.getString("mergeType"));
        String treeId = param.getString("treeID");
        String orgUnitId = param.getString("orgUnitID");
        String unitLNumber = this.getUnitLongNumber(ctx, treeId, orgUnitId);
        StringBuffer sql = new StringBuffer();
        if (isAdjust) {
            sql.append(" select top 1 pre.fyear,pre.fperiod from t_csl_adjust adj  \n");
            sql.append("  inner join t_csl_adjust pre on pre.fid = adj.fsrccopyadjustid \n");
            sql.append("  inner join t_org_baseunit unit on unit.fid = adj.forgunit \n");
            sql.append("   where adj.forgboundId = '").append(treeId).append("' \n");
            sql.append("   and adj.fyear = ").append(year).append(" \n");
            sql.append("   and adj.fperiod = ").append(period).append(" \n");
            sql.append("   and adj.fperiodType = ").append(periodType).append(" \n");
            sql.append("   and exists(select 1 from T_ORG_Structure str where adj.forgboundId = str.FTreeId AND unit.fid = str.FUnitId \n");
            sql.append("           and (str.FLongNumber LIKE '" + unitLNumber + "!%' OR str.FLongNumber = '" + unitLNumber + "')");
            if (mergeType == 1) {
                sql.append(" AND str.FLongNumber NOT LIKE '" + unitLNumber + "!%!%' ");
            }
            sql.append(") \n");
        } else {
            sql.append(" select top 1 preElim.fyear,preElim.fperiod,elim.fid from t_csl_elimination elim \n");
            sql.append("  inner join t_csl_elimination preElim on preElim.fid = elim.fsrccopyelimid \n");
            sql.append("  inner join t_org_structure str on str.funitid = elim.forgunit \n");
            sql.append("   where elim.forgboundid = '").append(treeId).append("' \n");
            sql.append("    and elim.fyear =").append(year).append(" \n");
            sql.append("\tand elim.fperiod = ").append(period).append(" \n");
            sql.append("\tand elim.fperiodtype = ").append(periodType).append(" \n");
            sql.append("    and str.FLongNumber ='" + unitLNumber + "'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                yp = new ArrayList<String>();
                yp.add(rs.getString("FYear"));
                yp.add(rs.getString("FPeriod"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return yp;
    }

    @Override
    protected Set _findSrcDatas(Context ctx, String Id, int year, int period, int periodType, boolean isAdjust) throws BOSException, EASBizException {
        HashSet<String> IDs = new HashSet<String>();
        IDs.add(Id);
        StringBuffer sql = new StringBuffer();
        if (isAdjust) {
            sql.append(" select preAdj.fid,preAdj.fyear,preAdj.fperiod from t_csl_adjust preAdj \n");
            sql.append("  inner join t_csl_adjust adj on adj.fsrccopyadjustid = preAdj.fid \n");
            sql.append("   where adj.fid = ? and adj.fyear = ? and adj.fperiod = ? ");
        } else {
            sql.append(" select preElim.fid,preElim.fyear,preElim.fperiod from t_csl_elimination preElim \n");
            sql.append("  inner join t_csl_elimination elim on elim.fsrccopyelimid = preElim.fid \n");
            sql.append("   where elim.fid = ? and elim.fyear = ? and elim.fperiod = ? ");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Id);
        params.add(new Integer(year));
        params.add(new Integer(period));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                Id = rs.getString("fid");
                IDs.add(Id);
                int[] yp = RPTDateUtil.getRptYearAndPeriod(year, period, periodType, 0, -3);
                params = new ArrayList();
                params.add(Id);
                params.add(new Integer(yp[0]));
                params.add(new Integer(yp[1]));
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                while (rs.next()) {
                    Id = rs.getString("fid");
                    IDs.add(Id);
                    yp = RPTDateUtil.getRptYearAndPeriod(year, period, periodType, 0, -6);
                    params = new ArrayList();
                    params.add(Id);
                    params.add(new Integer(yp[0]));
                    params.add(new Integer(yp[1]));
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                    while (rs.next()) {
                        Id = rs.getString("fid");
                        IDs.add(Id);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return IDs;
    }

    @Override
    protected List _checkAllowCopy(Context ctx, List preIds, RptProperties params, boolean isAdjust) throws BOSException, EASBizException {
        int year = Integer.parseInt(params.getString("defaultYear"));
        int period = Integer.parseInt(params.getString("defaultPeriod"));
        int periodType = Integer.parseInt(params.getString("periodType"));
        int mergeType = Integer.parseInt(params.getString("mergeType"));
        String treeId = params.getString("treeID");
        String orgUnitId = params.getString("orgUnitID");
        String treeNumber = this.getTreeNumber(ctx, treeId);
        String unitLNumber = this.getUnitLongNumber(ctx, treeId, orgUnitId);
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < preIds.size(); ++i) {
            if (i != 0) {
                ids.append(", ");
            }
            ids.append("'" + preIds.get(i) + "'");
        }
        ArrayList curDataList = new ArrayList();
        ArrayList<String> auditedDataList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        if (isAdjust) {
            sql.append(" select preAdj.FId preId, preAdj.fnumber,adj.fid,adj.fcheckedstatus from t_csl_Adjust PreAdj \n");
            sql.append("  inner join t_csl_adjust adj on adj.fsrccopyadjustid = preAdj.fid \n");
            sql.append("  inner join t_org_structure str on adj.forgboundId = str.FTreeId AND adj.forgunit = str.FUnitId \n");
            sql.append("  inner join t_org_tree tree  on tree.fid = str.ftreeId \n");
            sql.append("   where preAdj.fid in (" + ids.toString() + ") \n");
            sql.append("    and tree.fnumber = '").append(treeNumber).append("' \n");
            sql.append("    and adj.fyear =").append(year).append(" \n");
            sql.append("\tand adj.fperiod = ").append(period).append(" \n");
            sql.append("\tand adj.fperiodtype = ").append(periodType).append(" \n");
            sql.append("    and (str.FLongNumber LIKE '" + unitLNumber + "!%' OR str.FLongNumber = '" + unitLNumber + "')");
            if (mergeType == 1) {
                sql.append(" AND str.FLongNumber NOT LIKE '" + unitLNumber + "!%!%' ");
            }
        } else {
            sql.append(" select preElim.FId preId, preElim.fnumber,Elim.fid,Elim.fcheckedstatus from t_csl_elimination preElim \n");
            sql.append("  inner join t_csl_elimination elim on elim.fsrccopyelimid = preElim.fid \n");
            sql.append("  inner join t_org_structure str on elim.forgboundId = str.FTreeId AND elim.forgunit = str.FUnitId \n");
            sql.append("  inner join t_org_tree tree  on tree.fid = str.ftreeId \n");
            sql.append("   where preelim.fid in (" + ids.toString() + ") \n");
            sql.append("    and tree.fnumber = '").append(treeNumber).append("' \n");
            sql.append("    and str.FLongNumber = '").append(unitLNumber).append("' \n");
            sql.append("    and elim.fyear =").append(year).append(" \n");
            sql.append("\tand elim.fperiod = ").append(period).append(" \n");
            sql.append("\tand elim.fperiodtype = ").append(periodType).append(" \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> unAuditedDataList = new ArrayList<String>();
        ArrayList<String> auditedNumber = new ArrayList<String>();
        try {
            while (rs.next()) {
                if (rs.getString("FCheckedStatus").equals("2")) {
                    auditedDataList.add(rs.getString("preId"));
                    auditedNumber.add(rs.getString("FNumber"));
                    continue;
                }
                unAuditedDataList.add(rs.getString("FID"));
            }
            curDataList.add(auditedDataList);
            curDataList.add(unAuditedDataList);
            curDataList.add(auditedNumber);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return curDataList;
    }
}

