/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AbstractAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AdjustEntryCopy {
    private boolean hasCodeRule = false;

    public List<IObjectPK> copyFixedAdjustData(Context ctx, String orgTreeId, int periodType, int year, int period, IObjectValue dataCollect, String orgUnitId) throws BOSException, EASBizException {
        Map map = this.getNumber(ctx, orgUnitId, orgTreeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        int[] pre = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)orgTreeId));
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        pre = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx));
        ArrayList<String> list = new ArrayList<String>();
        DataCollectInfo dataColInfo = (DataCollectInfo)dataCollect;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct TPreAdjust.fid from t_csl_adjust TPreAdjust ");
        sql.append(" inner join T_ORG_Structure tstru on tstru.FUnitId=TPreAdjust.FOrgUnit");
        sql.append(" inner join T_Org_Tree tree2 on tree2.fid = tstru.ftreeid and tree2.fnumber = ?");
        sql.append(" left join T_ORG_Structure tParentStru on tParentStru.FId=tstru.FParentID");
        sql.append(" left join T_Org_Tree tree3 on tree3.fid = tParentStru.ftreeid and tree3.fnumber = ?");
        sql.append(" inner join T_Org_Tree tree on tree.fid = TPreAdjust.FOrgBoundID");
        sql.append(" where TPreAdjust.FisFixed = 1");
        sql.append(" and tree.fnumber = ?");
        sql.append(" and ((tParentStru.flongnumber like ? or tParentStru.flongnumber = ?) or ");
        sql.append(" (tstru.FIsLeaf=0 and tstru.flongnumber= ?) )");
        sql.append(" and TPreAdjust.Fyear = ? and TPreAdjust.Fperiod=?");
        sql.append(" and TPreAdjust.FperiodType = ?");
        sql.append(" and TPreAdjust.FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        Object[] param = new Object[]{treeNumber, treeNumber, treeNumber, unitNumber + "!%", unitNumber, unitNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (list.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        String tableName = "t_csl_adjust";
        List<IObjectPK> pks = this.copyHisData(ctx, orgTreeId, orgUnitId, periodType, year, period, tableName, list, false, (IObjectValue)dataColInfo);
        return pks;
    }

    private Map getNumber(Context ctx, String orgUnitId, String orgTreeId) throws BOSException {
        HashMap<String, String> numbers = new HashMap<String, String>();
        String sql = "select fnumber from t_org_tree where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            while (rs.next()) {
                String treeNumber = rs.getString("fnumber");
                numbers.put("treeNumber", treeNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String newSql = "select flongnumber from T_ORG_Structure where funitid = ?";
        IRowSet newrs = DbUtil.executeQuery((Context)ctx, (String)newSql, (Object[])new Object[]{orgUnitId});
        try {
            while (newrs.next()) {
                String unitNumber = newrs.getString("flongnumber");
                numbers.put("unitNumber", unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return numbers;
    }

    public List<IObjectPK> copyHisData(Context ctx, String orgTreeId, String orgUnitId, int periodType, int year, int period, String tableName, List list, boolean select, IObjectValue dataCollect) throws BOSException, EASBizException {
        this.reSetCopyList(ctx, orgTreeId, orgUnitId, periodType, year, period, list);
        BOSObjectType bosType = new AdjustDynamicItemInfo().getBOSType();
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId));
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)periodType))) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        Iterator iter = null;
        ArrayList<AdjustEntryInfo> array = new ArrayList<AdjustEntryInfo>();
        AbstractAdjustEntryInfo lineInfo = null;
        RPTItemInfo itemInfo1 = null;
        String oql = "select id,number,name where isFreezed=0 and control=10";
        RPTItemCollection itemCol = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (itemCol.size() > 0) {
            itemInfo1 = itemCol.get(0);
        }
        this.initCodeRule(ctx);
        iter = list.iterator();
        AdjustInfo info = null;
        UserInfo nowUser = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        ArrayList<IObjectPK> copyCreatePK = new ArrayList<IObjectPK>();
        while (iter.hasNext()) {
            BigDecimal debit = new BigDecimal("0");
            BigDecimal credit = new BigDecimal("0");
            BigDecimal zero = new BigDecimal("0");
            String id = iter.next().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("date"));
            sic.add(new SelectorItemInfo("adjustMode.name"));
            sic.add(new SelectorItemInfo("templet.id"));
            sic.add(new SelectorItemInfo("templet.name"));
            sic.add(new SelectorItemInfo("dataSource"));
            sic.add(new SelectorItemInfo("valueType"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("sourceCurrency.name"));
            sic.add(new SelectorItemInfo("entries.summary"));
            sic.add(new SelectorItemInfo("entries.item.effectItem"));
            sic.add(new SelectorItemInfo("entries.item.id"));
            sic.add(new SelectorItemInfo("entries.item.number"));
            sic.add(new SelectorItemInfo("entries.item.name"));
            sic.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
            sic.add(new SelectorItemInfo("entries.debit"));
            sic.add(new SelectorItemInfo("entries.credit"));
            sic.add(new SelectorItemInfo("entries.isVisible"));
            sic.add(new SelectorItemInfo("entries.hasAdjustDetails"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("CheckedStatus"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.dataElement"));
            sic.add(new SelectorItemInfo("orgBound.id"));
            sic.add(new SelectorItemInfo("entries.adjust.id"));
            sic.add(new SelectorItemInfo("entries.seq"));
            sic.add(new SelectorItemInfo("isCitedByLater"));
            sic.add(new SelectorItemInfo("isFixed"));
            sic.add(new SelectorItemInfo("remark"));
            sic.add(new SelectorItemInfo("dataCollect.name"));
            sic.add(new SelectorItemInfo("dataCollectNumber"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("year"));
            sic.add(new SelectorItemInfo("period"));
            info = AdjustFactory.getLocalInstance(ctx).getAdjustInfo((IObjectPK)pk, sic);
            AdjustInfo sourceAjustInfo = new AdjustInfo();
            sourceAjustInfo.setId(info.getId());
            info.setSourceAdjust(sourceAjustInfo);
            OrgTreeInfo treeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgTreeId)));
            if ((info.getDataSource().getValue() == 2 || info.getDataSource().getValue() == 3) && (new Timestamp(info.getDate().getTime()).compareTo(treeInfo.getStartDate()) < 0 || treeInfo.getEndDate() != null && new Timestamp(info.getDate().getTime()).compareTo(treeInfo.getEndDate()) > 0)) {
                String oldUnitId = info.getOrgUnit().getId().toString();
                String newTreeId = orgTreeId;
                String oldTreeId = info.getOrgBound().getId().toString();
                String newUnitId = null;
                StringBuffer sql = new StringBuffer();
                ArrayList<String> arr = new ArrayList<String>();
                sql.append(" select funitid \n");
                sql.append(" from t_org_structure \n");
                sql.append(" where ftreeid = ? \n");
                arr.add(newTreeId);
                sql.append(" and flongnumber in ( \n");
                sql.append(" select flongnumber from t_org_structure where ftreeid=? and funitid =? \n");
                arr.add(oldTreeId);
                arr.add(oldUnitId);
                sql.append(" ) \n");
                IRowSet rstemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])arr.toArray());
                try {
                    if (rstemp.next()) {
                        newUnitId = rstemp.getString("funitid");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                FullOrgUnitInfo newUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newUnitId)));
                info.setOrgUnit(newUnitInfo);
            }
            info.setOrgBound(treeInfo);
            try {
                info.setDate(FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod));
            }
            catch (Exception e) {
                info.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
            }
            int oldYear = info.getYear();
            int oldPeriod = info.getPeriod();
            info.setYear(year);
            info.setPeriod(period);
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            info.setId(null);
            info.setNumber(null);
            info.setAuditDate(null);
            info.setAuditor(null);
            info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            info.setCreator(nowUser);
            info.setCreateTime(time);
            AdjustEntryCollection col = info.getEntries();
            AdjustEntryCopy.queryAdjustDetails(ctx, col);
            boolean isGeneratePeriod = FiscalPeriodHelper.isGeneratePeriod(periods, oldYear, oldPeriod, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod);
            for (int i = 0; i < col.size(); ++i) {
                if (isGeneratePeriod && col.get(i).getItem().isIsProfitAndLosses() && col.get(i).getDataElement() == 3 && select) {
                    lineInfo = info.getEntries().get(i);
                    if (col.get(i).getDebit() != null) {
                        debit = debit.add(col.get(i).getDebit());
                    } else if (col.get(i).getCredit() != null) {
                        credit = credit.add(col.get(i).getCredit());
                    }
                    array.add(col.get(i));
                } else if (col.get(i).getSummary() != null && (col.get(i).getSummary().equals("AdjustEntry_Auto_Summary") || col.get(i).getSummary().equals(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"97_AdjustControllerBean", (Locale)ctx.getLocale())))) {
                    array.add(col.get(i));
                } else {
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(col.get(i).getId().toString(), bosUuid.toString());
                    col.get(i).setId(bosUuid);
                    col.get(i).getAdjust().setId(null);
                }
                info.getEntries();
            }
            if (!array.isEmpty()) {
                int n = array.size();
                for (int j = 0; j < n; ++j) {
                    info.getEntries().remove((AdjustEntryInfo)array.get(j));
                }
                array.clear();
                if (lineInfo != null) {
                    lineInfo.setDataElement(5);
                    lineInfo.setItem(itemInfo1);
                    bosUuid = BOSUuid.create((BOSObjectType)bosType);
                    entryIds.put(lineInfo.getId().toString(), bosUuid.toString());
                    lineInfo.setId(bosUuid);
                    lineInfo.getAdjust().setId(null);
                    if (debit.subtract(credit).compareTo(zero) == 1) {
                        lineInfo.setDebit(debit.subtract(credit));
                        lineInfo.setCredit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == -1) {
                        lineInfo.setCredit(credit.subtract(debit));
                        lineInfo.setDebit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == 0 || debit.subtract(credit).compareTo(zero) == 0) {
                        lineInfo.setDebit(null);
                        lineInfo.setCredit(null);
                    }
                    col.add((AdjustEntryInfo)lineInfo);
                }
            }
            info.getEntries().size();
            info.getEntries().get(0).getItem().getName();
            if (info.getEntries().size() == 0) {
                throw new AdjustException(AdjustException.LINE_NOT_EXIST);
            }
            if (!this.hasCodeRule) {
                BigDecimal number = new BigDecimal("1");
                StringBuffer ret = new StringBuffer("AUTO_");
                StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
                sbSQL.append(tableName).append(" a  \r\n");
                sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
                sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                sbSQL.append("  and a.fNumber like 'AUTO\\_%' ESCAPE '\\' \r\n");
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                    String tempNumber = "";
                    BigDecimal curNumber = new BigDecimal("1");
                    while (rowSet.next()) {
                        tempNumber = rowSet.getString("Fnumber");
                        if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                        number = curNumber;
                    }
                    if (number != null) {
                        number = number.add(new BigDecimal("1"));
                    }
                }
                catch (SQLException exc) {
                    throw new SQLDataException(exc);
                }
                int n = 8 - number.toString().length();
                for (int i = 0; i < n; ++i) {
                    ret.append("0");
                }
                ret.append(number);
                info.setNumber(ret.toString());
            }
            info.getEntries().get(0).getItem().getName();
            info.getEntries().get(0).getItem().getNumber();
            info.setDataCollect((DataCollectInfo)dataCollect);
            info.setDataCollectNumber(((DataCollectInfo)dataCollect).getNumber());
            info.remove("id");
            copyCreatePK.add(AdjustFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info));
        }
        CslRptUtil.copyDynamicItem(ctx, entryIds, true);
        list.clear();
        list.size();
        return copyCreatePK;
    }

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new AdjustInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    public static void queryAdjustDetails(Context ctx, AdjustEntryCollection collection) throws BOSException, EASBizException {
        for (int m = 0; m < collection.size(); ++m) {
            if (collection.get(m).getHasAdjustDetails().getValue() != 1 || collection.get(m).getId() == null) continue;
            collection.get(m).put("entryDetails", (Object)RelatingAdjustElimHelper.queryAdjustDetails(ctx, collection.get(m).getId().toString()));
        }
    }

    public List<IObjectPK> doImportAdjustRecords(Context ctx, List listId, String orgTreeID, IObjectValue dataCollect) throws BOSException, EASBizException {
        ArrayList<IObjectPK> copyCreatePK = new ArrayList<IObjectPK>();
        boolean isbasicimport = false;
        if (listId.size() > 0 && listId.get(listId.size() - 1) != null && ((String)listId.get(listId.size() - 1)).equals("yes")) {
            isbasicimport = true;
            listId.remove(listId.size() - 1);
        }
        BOSObjectType bosType = new AdjustDynamicItemInfo().getBOSType();
        HashMap<String, String> entryIds = new HashMap<String, String>();
        BOSUuid bosUuid = null;
        String orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        AdjustInfo info = null;
        String adjustId = null;
        AdjustEntryCollection collection = null;
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeID));
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        String[] numbers = null;
        if (listId != null && listId.size() > 0) {
            IObjectPK obPk = null;
            String BoId = null;
            int size = listId.size();
            for (int i = 0; i < size; ++i) {
                adjustId = (String)listId.get(i);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("entries.*"));
                selector.add(new SelectorItemInfo("entries.item.id"));
                selector.add(new SelectorItemInfo("entries.item.number"));
                selector.add(new SelectorItemInfo("entries.hasAdjustDetails"));
                selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
                selector.add(new SelectorItemInfo("entries.company.number"));
                info = iAdjust.getAdjustInfo((IObjectPK)new ObjectUuidPK(adjustId), selector);
                AdjustInfo sourceAdjustInfo = new AdjustInfo();
                sourceAdjustInfo.setId(info.getId());
                info.setSourceAdjust(sourceAdjustInfo);
                BoId = info.getId().toString();
                if (periods == null && FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, info.getPeriodType())) {
                    periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTreeInfo);
                }
                try {
                    info.setDate(FiscalPeriodHelper.getPeriodLastDate(periods, info.getYear(), info.getPeriod(), info.getPeriodType(), isMergeByFiscalPeriod));
                }
                catch (Exception e) {
                    info.setDate(RPTDate13Util.getPeriodLastDate(info.getYear(), info.getPeriod(), info.getPeriodType()));
                }
                info.setId(null);
                info.setAuditDate(null);
                info.setAuditor(null);
                info.setOrgBound(orgTreeInfo);
                info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                String resPath = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
                info.setRemark(info.getRemark());
                if (dataCollect != null) {
                    info.setDataCollect((DataCollectInfo)dataCollect);
                    if (!StringUtils.isEmpty((String)((DataCollectInfo)dataCollect).getNumber())) {
                        info.setDataCollectNumber(((DataCollectInfo)dataCollect).getNumber());
                    }
                }
                if (numbers == null) {
                    numbers = CslElimUtil.getBatchBizNumber(ctx, (IObjectValue)info, size);
                }
                info.setNumber((String)numbers[i]);
                collection = info.getEntries();
                AdjustEntryCopy.queryAdjustDetails(ctx, collection);
                if (collection != null && collection.size() > 0) {
                    for (int j = 0; j < collection.size(); ++j) {
                        bosUuid = BOSUuid.create((BOSObjectType)bosType);
                        entryIds.put(collection.get(j).getId().toString(), bosUuid.toString());
                        collection.get(j).setId(bosUuid);
                        collection.get(j).setAdjust(null);
                    }
                }
                ServiceManagerFactory.getServiceManager().disableService("PERMISSION_SERVICE");
                obPk = iAdjust.submit((CoreBaseInfo)info);
                copyCreatePK.add(obPk);
                String[] attachIDs = asm.getAttachmentIDsByBoID(BoId);
                asm.addAssociations(obPk.toString(), attachIDs);
            }
            CslRptUtil.copyDynamicItem(ctx, entryIds, true);
        }
        return copyCreatePK;
    }

    public void reSetCopyList(Context ctx, String orgTreeId, String orgUnitId, int periodType, int year, int period, List list) throws BOSException, EASBizException {
        Map map = this.getNumber(ctx, orgUnitId, orgTreeId);
        String unitNumber = (String)map.get("unitNumber");
        StringBuffer sql = new StringBuffer();
        sql.append("select unit.Fid fid from t_org_baseunit unit ");
        sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
        sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
        IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, unitNumber + "!%"});
        boolean isDisplayAdjustRPTMByOrg = CslRptUtil.isDisplayAdjustRPTMByOrg(ctx);
        ArrayList<String> companyIds = new ArrayList<String>();
        try {
            Set orgIDSet = null;
            if (isDisplayAdjustRPTMByOrg) {
                orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForServer(ctx, orgTreeId, null, ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
            }
            while (ids.next()) {
                if (isDisplayAdjustRPTMByOrg && orgIDSet != null) {
                    if (!orgIDSet.contains(ids.getString("fid"))) continue;
                    companyIds.add(ids.getString("fid"));
                    continue;
                }
                companyIds.add(ids.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        AdjustInfo info = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean hadCopyBySourceAdjustId;
            String id = (String)list.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = AdjustFactory.getLocalInstance(ctx).getAdjustInfo((IObjectPK)pk);
            String preCompanyId = null;
            if (info != null && !companyIds.contains(preCompanyId = info.getOrgUnit().getId().toString())) {
                list.remove(i);
            }
            if (hadCopyBySourceAdjustId = AdjustFactory.getLocalInstance(ctx).exists("select 1 where sourceAdjust.id ='" + id + "' and checkedStatus=2 and orgBound.id = '" + orgTreeId + "' and periodType = " + periodType + " and year = " + year + " and period = " + period + " and orgUnit.id = '" + preCompanyId + "'")) {
                list.remove(i);
                continue;
            }
            StringBuffer strSQL = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            strSQL.append(" delete from t_csl_adjust where ");
            strSQL.append(" fSourceAdjustid = ? ");
            params.add(id);
            strSQL.append(" and fCheckedStatus = 1 ");
            strSQL.append(" and fOrgBoundId = ? ");
            params.add(orgTreeId);
            strSQL.append(" and fPeriodType = ? ");
            params.add(periodType);
            strSQL.append(" and fYear = ? ");
            params.add(year);
            strSQL.append(" and fPeriod = ? ");
            params.add(period);
            strSQL.append(" and fOrgUnit = ? ");
            params.add(preCompanyId);
            DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
        }
    }
}

