/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractBackedReportFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BackedReportFacadeControllerBean
extends AbstractBackedReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.BackedReportFacadeControllerBean");

    @Override
    protected void _fixBackReportByCalAllPage(Context ctx, String sumRptID) throws BOSException, EASBizException {
        String sql = "delete t_csl_backedSheet where FSumReportId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sumRptID});
        this.deleteBackedReport(ctx);
    }

    private void deleteBackedReport(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete t_csl_backedReport where FId not in (");
        sql.append("select FReportId from t_csl_backedSheet)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _fixBackReportByCalSinglePage(Context ctx, String sumRptId, Map sheetNames) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete t_csl_backedSheet where FSumReportId = ? ");
        sql.append(" and FReportId = ? and FSheetName = ?");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            boolean isEmpty = true;
            for (String sheetName : sheetNames.keySet()) {
                List rptIds = (List)sheetNames.get(sheetName);
                for (int i = 0; i < rptIds.size(); ++i) {
                    String rptId = (String)rptIds.get(i);
                    if ((rptId = this.getBackedReportId(ctx, sumRptId, rptId)) == null) continue;
                    isEmpty = false;
                    ps.setObject(1, sumRptId);
                    ps.setObject(2, rptId);
                    ps.setObject(3, sheetName);
                    ps.addBatch();
                }
            }
            if (!isEmpty) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        this.deleteBackedReport(ctx);
    }

    private String getBackedReportId(Context ctx, String sumRptId, String rptId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select br.FId from t_csl_backedReport br, t_rpt_template t, \n");
        sql.append("(select c.FId, t.FGroup, c.FYear, c.FPeriod, c.FOrgUnitId, ");
        sql.append("c.FCurrencyId, c.FSourceCurrencyId from t_csl_cslReport c ");
        sql.append(" join t_rpt_template t on c.FTemplateId = t.FId");
        sql.append(" where c.FId = ?) as r \n");
        sql.append(" where br.FTemplateId = t.FId and t.FGroup = r.FGroup");
        sql.append(" and br.FYear = r.FYear and br.FPeriod = r.FPeriod");
        sql.append(" and br.FOrgUnitId = r.FOrgUnitId and br.FCurrencyId = r.FCurrencyId");
        sql.append(" and br.FSourceCurrencyId = r.FSourceCurrencyId");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rptId});
        try {
            if (rowSet.next()) {
                return rowSet.getString("FId");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected void _fixBackRptWhenDelSumRpt(Context ctx, String sumRptId) throws BOSException, EASBizException {
        String sql = "delete t_csl_backedSheet where FSumReportId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sumRptId});
        this.deleteBackedReport(ctx);
    }

    @Override
    protected void _saveSendBackedReport(Context ctx, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select br.FId from t_csl_backedReport br, t_rpt_template t, \n");
        sql.append("(select c.FId, t.FGroup, c.FYear, c.FPeriod, c.FOrgUnitId, ");
        sql.append("c.FCurrencyId, c.FSourceCurrencyId, c.FSourceType from t_csl_cslReport c ");
        sql.append(" join t_rpt_template t on c.FTemplateId = t.FId");
        sql.append(" where c.FId = ?) as r \n");
        sql.append(" where br.FTemplateId = t.FId and t.FGroup = r.FGroup");
        sql.append(" and br.FYear = r.FYear and br.FPeriod = r.FPeriod");
        sql.append(" and br.FOrgUnitId = r.FOrgUnitId and br.FCurrencyId = r.FCurrencyId");
        sql.append(" and br.FSourceCurrencyId = r.FSourceCurrencyId");
        sql.append(" and br.FSourceType = r.FSourceType");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (rowSet.size() > 0) {
            return;
        }
        try {
            this._fixBackRptWhenDelSumRpt(ctx, id);
        }
        catch (EASBizException e) {
            logger.debug((Object)"something wrong in BackedReportFacadeControllerBean._saveSendBackedReport(),\n can't execute _fixBackRptWhenDelSumRpt");
        }
        sql = new StringBuffer();
        sql.append("insert into t_csl_backedReport ");
        sql.append("(FId, FNumber, FName, FOrgTreeID, FOrgUnitId, FYear, FPeriod, ");
        sql.append("FTemplateId, FCompanyId, FPeriodType, FSourceType, FCurrencyId, ");
        sql.append("FData, FSourceCurrencyId, FReportDate, FConvertStatus, ");
        sql.append("FIsCommitReport, FDynaRptType) ");
        sql.append("select FId, FNumber, FName, FOrgTreeID, FOrgUnitId, FYear, FPeriod, ");
        sql.append("FTemplateId, FCompanyId, FPeriodType, FSourceType, FCurrencyId, ");
        sql.append("FData, FSourceCurrencyId, FReportDate, FConvertStatus, ");
        sql.append("FIsCommitReport, FDynaRptType from t_csl_cslReport ");
        sql.append(" where FId = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        sql = new StringBuffer();
        sql.append("insert into t_csl_backedSheet (FId, FSumReportId, FReportId, FSheetName)");
        sql.append(" select FId, FSumReportId, FReportId, FSheetId from t_csl_sumRptRela");
        sql.append(" where FReportId = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
    }
}

