/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMemAttachment;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLK3TemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCSLK3TemplateControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLExportUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CSLK3TemplateControllerBean
extends AbstractCSLK3TemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CSLK3TemplateControllerBean");

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            super.delete(ctx, arrayPK[i]);
        }
    }

    @Override
    protected List _converToK3(Context ctx, List arrayPK) throws BOSException, EASBizException {
        ArrayList<IObjectPK> result = new ArrayList<IObjectPK>();
        ITemplate it = TemplateFactory.getLocalInstance((Context)ctx);
        TemplateInfo info = null;
        AccountTableInfo accounttable = CSLK3TemplateControllerBean.getDefaultAccountTableByCU(ctx, ContextUtil.getCurrentFIUnit((Context)ctx));
        for (int i = 0; i < arrayPK.size(); ++i) {
            String objectPK = (String)arrayPK.get(i);
            CSLK3TemplateInfo curInfo = new CSLK3TemplateInfo();
            try {
                super.delete(ctx, "where sourceTemplate.id = '" + objectPK + "' ");
                info = it.getTemplateInfo((IObjectPK)new ObjectUuidPK(objectPK));
                curInfo.setBook(this.convertKDF(info.getBook(), accounttable));
            }
            catch (ReportException e) {
                logger.error((Object)"converToK3_ReportException", (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)"converToK3_EASBizException", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"converToK3_IOException", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"converToK3_Exception", (Throwable)e);
            }
            if (null == curInfo || curInfo.getData() == null) continue;
            curInfo.setSourceTemplate(info);
            IObjectPK pk = super.addnew(ctx, (CoreBaseInfo)curInfo);
            result.add(pk);
        }
        return result;
    }

    private static AccountTableInfo getDefaultAccountTableByCU(Context ctx, CompanyOrgUnitInfo currentFIUnit) throws BOSException {
        AccountTableInfo tableInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentFIUnit.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(false)));
        evi.getSelector().add("accountTableID.*");
        evi.getSelector().add("accountTableID.userLevel.*");
        SorterItemCollection sorters = evi.getSorter();
        SorterItemInfo sort = new SorterItemInfo("accountTableID.userLevel.level");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance((Context)ctx);
        Account_ControlCollection acctCtrlsCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlsCols != null && acctCtrlsCols.size() > 0) {
            tableInfo = acctCtrlsCols.get(0).getAccountTableID();
        }
        try {
            if (tableInfo != null && (tableInfo.getUserLevel() == null || tableInfo.getUserLevel().size() < 1)) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select flevel, flength from t_bd_accountLev where faccounttableid= ? order by flevel", (Object[])new String[]{tableInfo.getId().toString()});
                while (rs.next()) {
                    AccountUserLevelInfo ul = new AccountUserLevelInfo();
                    ul.setLevel(rs.getInt(1));
                    ul.setLength(rs.getInt(2));
                    tableInfo.getUserLevel().add(ul);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableInfo;
    }

    private Book convertKDF(Book book, AccountTableInfo accounttable) throws ReportException {
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        int sheetCount = book.getSheetCount();
        if (sheetCount > 0) {
            Sheet sheet = null;
            for (int i = 0; i < sheetCount; ++i) {
                sheet = book.getSheet(i);
                Protection pro = sheet.getSheetOption().getProtection(false);
                boolean willProtect = false;
                String proPass = null;
                if (pro != null && pro.isProtected()) {
                    proPass = pro.getEncryptedPassword();
                    pro.setPassword(proPass);
                    pro.stop(proPass);
                    willProtect = true;
                }
                CSLExportUtility.convertTable(sheet, accounttable);
                if (willProtect) {
                    pro.startWithEncryptedPassword(proPass);
                }
                if (variables == null) continue;
                variables.remove("IncludeLeaf", sheet.getSheetName());
                variables.remove("IncludeSub", sheet.getSheetName());
            }
        }
        properties.restoreToBook(book);
        RptOperationSchemaComp comp = (RptOperationSchemaComp)book.getUserObjectValue("operationSchemas");
        if (comp != null) {
            RptCheckExpTank expTank = comp.getExpTank();
            this.convertCheckExpression(expTank, accounttable);
        }
        return book;
    }

    private void convertCheckExpression(RptCheckExpTank expTank, AccountTableInfo accounttable) {
        if (expTank != null && expTank.getExpressions() != null) {
            Collection expressions = expTank.getExpressions();
            for (RptCheckExpression exp : expressions) {
                exp.setEditable(false);
                exp.setDeleteable(false);
                String line = exp.getContent();
                exp.setContent(CSLExportUtility.convertFormula(line, accounttable));
            }
        }
    }

    @Override
    protected String _deliverTemplate(Context ctx, HashMap templateMap, HashMap recevierMap) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"130_CSLK3TemplateControllerBean", (Locale)ctx.getOriginLocale());
        String content = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"131_CSLK3TemplateControllerBean", (Locale)ctx.getOriginLocale());
        Set companyKey = templateMap.keySet();
        for (String element : companyKey) {
            if (!recevierMap.containsKey(element)) continue;
            String receivers = StringUtils.arrayToString((Object[])((ArrayList)recevierMap.get(element)).toArray(), (String)",");
            KDMemAttachment attach = new KDMemAttachment();
            attach.setName(element);
            attach.setData((byte[])templateMap.get(element));
            MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)content, (String)receivers, null, null, (KDMessageAttachment[])new KDMemAttachment[]{attach});
            result.add(element);
        }
        return result.size() == 0 ? null : StringUtils.arrayToString((Object[])result.toArray(), (String)",");
    }

    @Override
    protected Book _createK3Book(Context ctx, String easTplId) throws BOSException, EASBizException {
        ITemplate it = TemplateFactory.getLocalInstance((Context)ctx);
        TemplateInfo info = null;
        AccountTableInfo accounttable = CSLK3TemplateControllerBean.getDefaultAccountTableByCU(ctx, ContextUtil.getCurrentFIUnit((Context)ctx));
        try {
            info = it.getTemplateInfo((IObjectPK)new ObjectUuidPK(easTplId));
            return this.convertKDF(info.getBook(), accounttable);
        }
        catch (ReportException e) {
            throw e;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

