/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslParamBox;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCSLReportCalculatorControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.SumRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.app.multicalculate.CompanysExpander;
import com.kingdee.eas.fi.gr.cslrpt.app.multicalculate.MultiCalculateContext;
import com.kingdee.eas.fi.gr.cslrpt.app.multicalculate.MultiCalculateProcess;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaRptCalcServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DynaNumberTransition4ListAll;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.DynamicEnumException;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CSLReportCalculatorControllerBean
extends AbstractCSLReportCalculatorControllerBean {
    private static final long serialVersionUID = 8672928195833437830L;
    private static final Logger logger = CoreUIObject.getLogger(CSLReportCalculatorControllerBean.class);
    private static final int MAX_ITEM_SIZE = 200;

    @Override
    public Map _calculateSumRptBySheet(Context ctx, List reports, List sheets) throws BOSException, SumRptException {
        return null;
    }

    @Override
    public Map _calculateCSLReport(Context ctx, IObjectPK reportID, Map sheets) throws BOSException, EASBizException {
        return this.CslRptCalculate(ctx, reportID, sheets);
    }

    private Map SumRptCalculateByItem(Context ctx, IObjectPK reportID, Vector companys, Map sheets, boolean includeDiffTable, boolean bySumReport, String dataCollectNumber) throws EASBizException, BOSException {
        int year = 0;
        int period = 0;
        Map fastMergerParamMap = null;
        AdjustCollection adjustColl = null;
        boolean isGroupcommitted = true;
        if (sheets.containsKey("year") && sheets.containsKey("period") && sheets.containsKey("fastMergerParamMap") && sheets.containsKey("adjustColl") && sheets.containsKey("isGroupcommitted")) {
            year = (Integer)sheets.get("year");
            period = (Integer)sheets.get("period");
            fastMergerParamMap = (Map)sheets.get("fastMergerParamMap");
            isGroupcommitted = (Boolean)sheets.get("isGroupcommitted");
            adjustColl = (AdjustCollection)((Object)sheets.get("adjustColl"));
            sheets.remove("year");
            sheets.remove("period");
            sheets.remove("fastMergerParamMap");
            sheets.remove("isGroupcommitted");
            sheets.remove("adjustColl");
        }
        return new SumRptCalculate().calculateByItem(ctx, reportID, companys, sheets, includeDiffTable, bySumReport, dataCollectNumber, isGroupcommitted, adjustColl, year, period, fastMergerParamMap);
    }

    @Override
    protected Map _calculateMnsReport(Context ctx, MnsRptParamInfo mnsRptParamInfo) throws BOSException, EASBizException {
        return MnsRptCalcHelper._calculateMnsReport(ctx, mnsRptParamInfo);
    }

    @Override
    protected Map _calculateMnsReport(Context ctx, IObjectPK reportID, Map sheets, boolean includeSendback, boolean isBeforeAdjust, int dataElementRelating) throws BOSException, EASBizException {
        return null;
    }

    private Map CslRptCalculate(Context ctx, IObjectPK reportID, Map sheets) throws EASBizException, BOSException {
        if (reportID == null || reportID.toString().trim().length() == 0) {
            return null;
        }
        ICslReport cslRpt = CslReportFactory.getLocalInstance(ctx);
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        CslReportInfo report = null;
        boolean isCalcCslBeginByCurPeriod = false;
        if (sheets.containsKey("isCalcCslBeginByCurPeriod")) {
            isCalcCslBeginByCurPeriod = (Boolean)sheets.remove("isCalcCslBeginByCurPeriod");
        }
        if ((report = cslRpt.getCslReportInfo(reportID, this.getSelectors())) == null) {
            return null;
        }
        ItemDataCondition condition = new ItemDataCondition();
        condition = CSLParamUtil.getSysParams(ctx, condition);
        PeriodCollection periods = null;
        boolean isMergeByFiscalPeriod = condition.isMergeByFiscalPeriod();
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        }
        boolean isSupport13Period = condition.isSupport13Period();
        boolean isSupportCrossMerger = CSLParamUtil.isSupportCrossMerger(ctx, report.getOrgTree().getId().toString());
        int sourceType = report.getSourceType().getValue();
        String fastMergeSoluId = report.getFastMergeSoluId();
        boolean isSupportGroupReport = true;
        if (34 == sourceType) {
            isSupportGroupReport = false;
        }
        if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
            isSupportCrossMerger = false;
        }
        condition.setSupportGroupReport(isSupportGroupReport);
        condition.setFastMergeSoluId(fastMergeSoluId);
        condition.setRptSrcType(3);
        condition.setOrgTreeNumber(report.getOrgTree().getNumber());
        ArrayList<String> companys = new ArrayList<String>();
        companys.add(report.getOrgUnit().getId().toString());
        condition.setOrgUnit(companys);
        ArrayList<String> orgUnitNumberList = new ArrayList<String>();
        orgUnitNumberList.add(report.getOrgUnit().getNumber());
        condition.setOrgUnitNumber(orgUnitNumberList);
        condition.setCurrency(report.getSourceCurrency().getId().toString());
        condition.setTargetCurrency(report.getCurrency().getId().toString());
        RptPeriodTypeEnum rptPeriodType = report.getPeriodType();
        int periodType = rptPeriodType.getValue();
        condition.setRptPeriodType(periodType);
        condition.setIsAdjusted(true);
        condition.setCommitStatus(3);
        condition.setDataSource(4);
        String dataCollectNumber = report.getDataCollectNumber();
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            condition.setDataCollectNumber(dataCollectNumber);
        }
        int reportYear = report.getYear();
        short reportPeriod = report.getPeriod();
        ItemFormula itemFormula = null;
        IItemDataProvider ie = ItemDataProviderFactory.getLocalInstance(ctx);
        HashMap<String, List<String>> mapItems = new HashMap<String, List<String>>();
        HashMap<String, Object> mapConditions = new HashMap<String, Object>();
        HashMap<String, List<String>> mapYearInitItem = new HashMap<String, List<String>>();
        HashMap<String, Map> mapYearInitParams = new HashMap<String, Map>();
        Iterator iterTable = sheets.keySet().iterator();
        String dataElementNumber = null;
        while (iterTable.hasNext()) {
            HashMap curSheet;
            String tableID = (String)iterTable.next();
            if (tableID == null || tableID.trim().length() == 0 || (curSheet = (HashMap)sheets.get(tableID)) == null || curSheet.size() == 0) continue;
            for (Point position : curSheet.keySet()) {
                itemFormula = (ItemFormula)curSheet.get(position);
                try {
                    condition = (ItemDataCondition)condition.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                if (itemFormula.isValidity()) {
                    List<String> items;
                    String key;
                    dataElementNumber = itemFormula.getDataElementNumber();
                    this.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
                    if (!isSupportCrossMerger && dataElementNumber.equals("YTBEGIN")) {
                        List<String> items2;
                        Integer year = new Integer(itemFormula.getYear());
                        String year_valueType = String.valueOf(itemFormula.getYear()) + ":" + String.valueOf(itemFormula.getValueType());
                        if (!mapYearInitParams.containsKey(year_valueType)) {
                            HashMap<String, Object> mapParams = new HashMap<String, Object>();
                            mapParams.put("OrgTreeID", report.getOrgTree().getId().toString());
                            mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
                            mapParams.put("KEY_CURRENCY_ID", report.getCurrency().getId().toString());
                            mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
                            mapParams.put("DataElement", new Integer(5));
                            mapParams.put("ValueType", itemFormula.getValueType() == 0 ? new Integer(1) : new Integer(itemFormula.getValueType()));
                            mapParams.put("KEY_CONVERTSTATUS", new Integer(0));
                            mapParams.put("Year", year);
                            mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
                            mapParams.put("MERGETYPE", report.getSourceType().getValue() == 34 ? 1 : 0);
                            mapYearInitParams.put(year_valueType, mapParams);
                        }
                        if (!mapYearInitItem.containsKey(year_valueType)) {
                            items2 = new ArrayList();
                            mapYearInitItem.put(year_valueType, items2);
                        } else {
                            items2 = (List)mapYearInitItem.get(year_valueType);
                        }
                        if (items2.contains(itemFormula.getItemNumber())) continue;
                        items2.add(itemFormula.getItemNumber());
                        continue;
                    }
                    if (!isSupportCrossMerger && !isCalcCslBeginByCurPeriod && dataElementNumber.equals("BEGINBALANCE")) {
                        int offSetYear = itemFormula.getYearOffSet();
                        int offSetPeriod = itemFormula.getPeriodOffSet();
                        int[] arrYearAndPeriod = isSupport13Period ? RPTDate13Util.getRptYearAndPeriod(reportYear, (int)reportPeriod, periodType, offSetYear, --offSetPeriod, isSupport13Period) : FiscalPeriodHelper.getRptYearAndPeriod(periods, reportYear, reportPeriod, periodType, offSetYear, --offSetPeriod, isMergeByFiscalPeriod);
                        key = "ENDBALANCE-" + itemFormula.getValueType() + "-" + arrYearAndPeriod[0] + "-" + arrYearAndPeriod[1] + "-" + 3;
                        if (!mapConditions.containsKey(key)) {
                            condition.setDataElement(4);
                            condition.setValueType(itemFormula.getValueType());
                            condition.setRptYearStart(arrYearAndPeriod[0]);
                            condition.setRptPeriodStart(arrYearAndPeriod[1]);
                            condition.setRptYearEnd(arrYearAndPeriod[0]);
                            condition.setRptPeriodEnd(arrYearAndPeriod[1]);
                            if (isSupportGroupReport) {
                                condition.setDataSource(3);
                            } else {
                                condition.setDataSource(-1);
                                int[] dataSources = new int[]{34};
                                condition.setDataSourceString(dataSources);
                            }
                            mapConditions.put(key, condition);
                        }
                    } else {
                        key = dataElementNumber + "-" + itemFormula.getValueType() + "-" + itemFormula.getYear() + "-" + itemFormula.getPeriod() + "-" + 4;
                        if (!mapConditions.containsKey(key)) {
                            condition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, dataElementNumber));
                            condition.setValueType(itemFormula.getValueType());
                            condition.setRptYearStart(itemFormula.getYear());
                            condition.setRptPeriodStart(itemFormula.getPeriod());
                            condition.setRptYearEnd(itemFormula.getYear());
                            condition.setRptPeriodEnd(itemFormula.getPeriod());
                            if (isSupportGroupReport) {
                                condition.setDataSource(4);
                            } else {
                                condition.setDataSource(-1);
                                int[] dataSources = new int[]{33};
                                condition.setDataSourceString(dataSources);
                            }
                            mapConditions.put(key, condition);
                        }
                    }
                    if (!mapItems.containsKey(key)) {
                        items = new ArrayList();
                        mapItems.put(key, items);
                    } else {
                        items = (List)mapItems.get(key);
                    }
                    if (items.contains(itemFormula.getItemNumber())) continue;
                    items.add(itemFormula.getItemNumber());
                    continue;
                }
                curSheet.put(position, null);
            }
        }
        IItemDataYearInit iYearInit = ItemDataYearInitFactory.getLocalInstance(ctx);
        for (String year_valueType : mapYearInitParams.keySet()) {
            Map params = (Map)mapYearInitParams.get(year_valueType);
            List items = (List)mapYearInitItem.get(year_valueType);
            Map mapValue = iYearInit.batchGetYearInitValue(items, params);
            mapYearInitParams.put(year_valueType, mapValue);
        }
        for (String key : mapConditions.keySet()) {
            condition = (ItemDataCondition)mapConditions.get(key);
            List items = (List)mapItems.get(key);
            condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(items));
            Map mapValue = ie.getAcctItems(condition);
            mapConditions.put(key, mapValue);
        }
        for (String tableID : sheets.keySet()) {
            HashMap curSheet;
            if (tableID == null || tableID.trim().length() == 0 || (curSheet = (HashMap)sheets.get(tableID)) == null || curSheet.size() == 0) continue;
            for (Point position : curSheet.keySet()) {
                itemFormula = (ItemFormula)curSheet.get(position);
                if (itemFormula != null && itemFormula.isValidity()) {
                    dataElementNumber = itemFormula.getDataElementNumber();
                    BigDecimal result = null;
                    this.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
                    if (!isSupportCrossMerger && dataElementNumber.equals("YTBEGIN")) {
                        String year_valueType = String.valueOf(itemFormula.getYear()) + ":" + String.valueOf(itemFormula.getValueType());
                        Map mapValue = (Map)mapYearInitParams.get(year_valueType);
                        if (mapValue != null) {
                            result = (BigDecimal)mapValue.get(itemFormula.getItemNumber());
                        }
                    } else if (!isSupportCrossMerger && dataElementNumber.equals("YTDAMOUNT") && report.getConvertStatus().getValue() == 0 && itemFormula.getYearOffSet() == -1 && itemFormula.getPeriodOffSet() == -1 && itemFormula.getValueType() == 1) {
                        boolean isExist = this.getLastYearreport(ctx, report, itemFormula, 0, fastMergeSoluId, isSupportGroupReport);
                        if (isExist) {
                            condition.setItemNumberStart(itemFormula.getItemNumber());
                            condition.setItemNumberEnd(itemFormula.getItemNumber());
                            condition.setDataElement(3);
                            condition.setValueType(itemFormula.getValueType());
                            condition.setRptYearStart(itemFormula.getYear());
                            condition.setRptPeriodStart(itemFormula.getPeriod());
                            condition.setRptYearEnd(itemFormula.getYear());
                            condition.setRptPeriodEnd(itemFormula.getPeriod());
                            if (isSupportGroupReport) {
                                condition.setDataSource(3);
                            } else {
                                condition.setDataSource(-1);
                                int[] dataSources = new int[]{34};
                                condition.setDataSourceString(dataSources);
                            }
                            result = ie.getAcctItem(condition, false);
                        } else {
                            HashMap<String, Object> mapParams = new HashMap<String, Object>();
                            mapParams.put("OrgTreeID", report.getOrgTree().getId().toString());
                            mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
                            mapParams.put("KEY_CURRENCY_ID", report.getCurrency().getId().toString());
                            mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
                            mapParams.put("Year", new Integer(itemFormula.getYear()));
                            mapParams.put("DataElement", new Integer(3));
                            mapParams.put("ValueType", new Integer(1));
                            mapParams.put("KEY_ITEM_NUMBER", itemFormula.getItemNumber());
                            mapParams.put("Period", new Integer(report.getPeriod()));
                            result = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
                        }
                    } else if (!isSupportCrossMerger && !isCalcCslBeginByCurPeriod && dataElementNumber.equals("BEGINBALANCE")) {
                        int offSetYear = itemFormula.getPeriodOffSet();
                        int offSetPeriod = itemFormula.getPeriodOffSet();
                        int[] arrYearAndPeriod = isSupport13Period ? RPTDate13Util.getRptYearAndPeriod(reportYear, (int)reportPeriod, periodType, offSetYear, --offSetPeriod, isSupport13Period) : FiscalPeriodHelper.getRptYearAndPeriod(periods, reportYear, reportPeriod, periodType, offSetYear, --offSetPeriod, isMergeByFiscalPeriod);
                        String key = "ENDBALANCE-" + itemFormula.getValueType() + "-" + arrYearAndPeriod[0] + "-" + arrYearAndPeriod[1] + "-" + 3;
                        Map mapValue = (Map)mapConditions.get(key);
                        if (mapValue != null) {
                            result = (BigDecimal)mapValue.get(itemFormula.getItemNumber());
                        }
                    } else {
                        String key = dataElementNumber + "-" + itemFormula.getValueType() + "-" + itemFormula.getYear() + "-" + itemFormula.getPeriod() + "-" + 4;
                        Map mapValue = (Map)mapConditions.get(key);
                        if (mapValue != null) {
                            result = (BigDecimal)mapValue.get(itemFormula.getItemNumber());
                        }
                    }
                    if (result == null) {
                        result = CslConstant.BGZERO;
                    }
                    curSheet.put(position, result);
                    continue;
                }
                curSheet.put(position, null);
            }
        }
        return sheets;
    }

    private void offsetYearAndPeriod(boolean isMergeByFiscalPeriod, boolean isSupport13Period, RptPeriodTypeEnum rptPeriodType, int reportYear, int reportPeriod, ItemFormula itemFormula, PeriodCollection periods) throws EASBizException, BOSException {
        RptCalcHelper.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, rptPeriodType, reportYear, reportPeriod, itemFormula, periods);
    }

    private boolean getLastYearreport(Context ctx, CslReportInfo report, ItemFormula itemFormula, int convertStatus, String fastMergeSoluId, boolean isSupportGroupReport) throws BOSException, EASBizException {
        String strOrgTreeID = report.getOrgTree().getId().toString();
        StringBuffer sql = new StringBuffer();
        Object[] param = new Object[11];
        sql.append(" select top 1 c.fid \r\n");
        sql.append(" from t_csl_templetItemList list \r\n");
        sql.append(" inner join t_csl_cslreport c on list.FTemplateID = c.ftemplateid \r\n");
        sql.append(" inner join t_csl_rptreceived r on c.fid=r.freportid");
        sql.append(" where c.fperiod = ?");
        sql.append(" and c.FSourceCurrencyID= ?");
        sql.append(" and c.fcurrencyid= ?");
        sql.append(" and list.FDataElement= ?");
        sql.append(" and list.FValueType= ?");
        sql.append(" and r.forgtreeId= ?");
        sql.append(" and c.FOrgUnitID= ?");
        sql.append(" and c.FConvertStatus = ?");
        sql.append(" and list.fitemNumber= ?");
        sql.append(" and c.fcommittedStatus = ?");
        sql.append(" and c.fsourceType= ?");
        if (!isSupportGroupReport) {
            sql.append(" and c.ffastmergesoluid= ?");
        }
        param[0] = new Integer(report.getPeriod());
        param[1] = report.getSourceCurrency().getId().toString();
        param[2] = report.getCurrency().getId().toString();
        param[3] = new Integer(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
        param[4] = new Integer(itemFormula.getValueType());
        param[5] = strOrgTreeID;
        param[6] = report.getOrgUnit().getId().toString();
        param[7] = new Integer(convertStatus);
        param[8] = itemFormula.getItemNumber();
        if (isSupportGroupReport) {
            param[9] = new Integer(3);
            param[10] = new Integer(3);
        } else {
            param[9] = new Integer(1);
            param[10] = new Integer(34);
            param[11] = fastMergeSoluId;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private SelectorItemCollection getSelectors() {
        return new SumRptCalculate().getSelectors(true);
    }

    private SelectorItemCollection getSelectors(boolean WidthData) {
        return new SumRptCalculate().getSelectors(WidthData);
    }

    @Override
    protected Map _calculateDynaSumRpt(Context ctx, String reportID, List companys, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        return DynaRptCalcServerHelper._calculateDynaSumRpt(ctx, reportID, companys, positions, doOffset, includeDiffTable);
    }

    private CslReportInfo getCslReportInfo(Context ctx, String reportID) throws BOSException {
        if (reportID == null) {
            return null;
        }
        String oql = new StringBuffer("select id, year, period, periodType, SourceType, ").append("currency.id, currency.precision, OrgTree.id,OrgTree.number, OrgUnit.id,orgUnit.number, ").append("dataCollectNumber, company.id,company.number where id = '").append(reportID).append("'").toString();
        CslReportCollection reportCol = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oql);
        if (reportCol == null || reportCol.size() != 1) {
            return null;
        }
        return reportCol.get(0);
    }

    private CslParamBox getCslParamBox(Context ctx) {
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        CslParamBox paramBox = new CslParamBox();
        paramBox.setMergeByFiscalPeriod(values[0]);
        paramBox.setSupport13Period(values[1]);
        return paramBox;
    }

    protected Map performDynaRptSUM(Context ctx, CslReportInfo report, List companys, Map positions, boolean doOffset, boolean includeDiffTable, boolean keepItemFormula, boolean isForSave, CslParamBox paramBox, PeriodCollection periods, String orgTreeid) throws BOSException, EASBizException {
        if (report == null || companys == null || companys.size() == 0 || positions == null || positions.size() == 0) {
            return null;
        }
        boolean isMergeByFiscalPeriod = paramBox.isMergeByFiscalPeriod();
        boolean isSupport13Period = paramBox.isSupport13Period();
        HashMap result = new HashMap();
        Iterator iter = positions.keySet().iterator();
        while (iter.hasNext()) {
            long time1 = System.currentTimeMillis();
            String sheetID = (String)iter.next();
            Map sheetMap = (Map)positions.get(sheetID);
            HashMap resultSheet = new HashMap();
            result.put(sheetID, resultSheet);
            if (sheetMap == null) continue;
            for (Point basePoint : sheetMap.keySet()) {
                Map areaMap = (Map)sheetMap.get(basePoint);
                DynaParameters param = DynaParameters.getInstanceFromString((String)((String)areaMap.get("param")));
                Map formulasMap = (Map)areaMap.get("formulas");
                if (!resultSheet.containsKey(basePoint)) {
                    resultSheet.put(basePoint, new HashMap());
                }
                Map resultBase = (Map)resultSheet.get(basePoint);
                Map gradeMapping = null;
                if (param.isGrade() && param.getDynaItemSource() == 0) {
                    DynaSumMethodEnum method = param.getSumMethod();
                    gradeMapping = this.getTextGrade(ctx, report, companys, formulasMap, method);
                } else {
                    gradeMapping = new HashMap();
                }
                TableInfo table = new TableInfo("Company_param_temp");
                table.addColumn("id");
                ParamTempTblService cmpParamSrv = new ParamTempTblService(ctx, table, companys, null);
                for (Point point : formulasMap.keySet()) {
                    ItemFormula formula = (ItemFormula)formulasMap.get(point);
                    this.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, report.getPeriodType(), report.getYear(), report.getPeriod(), formula, periods);
                    List dataList = null;
                    dataList = this.getDynaItemData(ctx, report, cmpParamSrv, formula, param, gradeMapping, doOffset, includeDiffTable, isForSave, orgTreeid);
                    int n = dataList.size();
                    for (int i = 0; i < n; ++i) {
                        Map row = (Map)dataList.get(i);
                        String name = (String)row.get("KEY_DITEM_NAME");
                        String key = (String)row.get("KEY_DITEM_NUMBER");
                        Object value = row.get("KEY_DITEM_VALUE");
                        if (!resultBase.containsKey(key)) {
                            HashMap<String, Object> pointMap = new HashMap<String, Object>(8);
                            pointMap.put("KEY_DITEM_NAME", name);
                            pointMap.put("KEY_POINT_VALUE", new HashMap());
                            pointMap.put("GRADE_NUMBER", row.get("GRADE_NUMBER"));
                            Object o = row.get("COMPANY_NAME");
                            if (o != null) {
                                pointMap.put("COMPANY_NAME", o);
                            }
                            resultBase.put(key, pointMap);
                        } else {
                            Map tmpResultName = (Map)((Map)resultBase.get(key)).get("KEY_POINT_VALUE");
                            Object tmpValue = tmpResultName.get(point);
                            if (tmpValue instanceof BigDecimal && value instanceof BigDecimal) {
                                value = ((BigDecimal)tmpValue).add((BigDecimal)value);
                            }
                        }
                        Map resultName = (Map)((Map)resultBase.get(key)).get("KEY_POINT_VALUE");
                        if (keepItemFormula) {
                            resultName.put("ItemFormula" + point.toString(), formula);
                            resultName.put("DynaParam" + point.toString(), (String)areaMap.get("param"));
                        }
                        resultName.put(point, value);
                    }
                }
            }
            logger.info((Object)("sheet" + sheetID + ":" + (System.currentTimeMillis() - time1) + "ms"));
        }
        return result;
    }

    private Map getTextGrade(Context ctx, CslReportInfo report, List companys, Map formulas, DynaSumMethodEnum method) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (formulas == null || formulas.isEmpty()) {
            return result;
        }
        String companyIDs = CslRptUtil.changeIdList2String(companys);
        StringBuffer items = new StringBuffer();
        Iterator iter3 = formulas.keySet().iterator();
        boolean bfirst = true;
        ItemFormula formula = null;
        while (iter3.hasNext()) {
            if (!bfirst) {
                items.append(',');
            }
            bfirst = false;
            Point point = (Point)iter3.next();
            formula = (ItemFormula)formulas.get(point);
            items.append('\'').append(formula.getItemNumber()).append('\'');
        }
        StringBuffer sql = new StringBuffer();
        if (!method.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY)) {
            sql.append(" SELECT DISTINCT de.FGradeNumber || '**' || de.FKeyNumber , de.FGradeNumber \n");
        } else {
            sql.append(" SELECT DISTINCT de.FKeyNumber , de.FGradeNumber \n");
        }
        sql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
        sql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
        sql.append("    ON de.FItemDataID = d.FID                           \n");
        sql.append(" inner join t_csl_rptreceived r on d.FReportId = r.FReportId \n");
        sql.append(" WHERE d.FOrgUnitID IN (" + companyIDs.toString() + ")  \n");
        sql.append("    and r.FOrgTreeID = ?                                \n");
        sql.append("    AND d.FCurrencyID = ?                               \n");
        sql.append(" \tAnd d.FPeriodType = ? \t\t\t\t\t\t\t\t\n");
        sql.append(" \tAnd de.FYear = ? \t\t\t\t\t\t\t\t\t\n");
        sql.append(" \tAnd de.FPeriod = ? \t\t\t\t\t\t\t\t\t\n");
        sql.append("    AND de.FItemID in (" + items.toString() + ")            \n");
        sql.append("    AND de.FGradeNumber IS NOT NULL                    \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(report.getOrgTree().getId().toString());
        params.add(report.getCurrency().getId().toString());
        params.add(new Integer(report.getPeriodType().getValue()));
        params.add(new Integer(report.getYear()));
        params.add(new Integer(report.getPeriod()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            String number = null;
            while (rs.next()) {
                number = rs.getString(1);
                if (!StringUtils.isEmpty((String)number)) {
                    number = number.trim();
                }
                result.put(number, rs.getString(2));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getDynaItemLongNumberSql(String tableAlias) {
        StringBuffer sql = new StringBuffer();
        sql.append(" substring((case charindex('_'," + tableAlias + ".FKeyLongNumber) \n");
        sql.append(" when 0 then " + tableAlias + ".FKeyLongNumber \n");
        sql.append(" else left(" + tableAlias + ".FKeyLongNumber, charindex('_'," + tableAlias + ".FKeyLongNumber)-1) || '**'|| " + tableAlias + ".FKeyLongNumber  \n");
        sql.append(" end),1,255) as FSingleNumber \n");
        return sql.toString();
    }

    private List getDynaItemData(Context ctx, CslReportInfo report, ParamTempTblService cmpParamSrv, ItemFormula formula, DynaParameters param, Map gradeMapping, boolean doOffset, boolean includeDiffTable, boolean isForSave, String orgTreeid) throws BOSException, EASBizException {
        boolean isSumByTextNotGrade;
        String companyIDs = cmpParamSrv.getParamsSql();
        boolean isTextGrade = param.isGrade() && param.getDynaItemSource() == 0;
        DynaSumMethodEnum method = param.getSumMethod();
        boolean bl = isSumByTextNotGrade = !isTextGrade && !isForSave && formula.getValueType() == 3;
        if (method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) || isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || isForSave && formula.getValueType() == 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
            return this.getDynaItemDataByName(ctx, report, companyIDs, formula, isTextGrade, doOffset, includeDiffTable, isForSave, isSumByTextNotGrade, param, orgTreeid, gradeMapping);
        }
        if (formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
            return this.getDynaItemDataByCompany(ctx, report, companyIDs, formula, doOffset, includeDiffTable, param, orgTreeid);
        }
        if (method.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY) || method.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
            return this.getDynaItemDataListAll(ctx, report, companyIDs, formula, doOffset, includeDiffTable, isForSave, param, orgTreeid, gradeMapping);
        }
        return new ArrayList();
    }

    private List getDynaItemDataByName(Context ctx, CslReportInfo report, String companyIDs, ItemFormula formula, boolean isTextGrade, boolean doOffset, boolean includeDiffTable, boolean isForSave, boolean isSumByTextNotGrade, DynaParameters param, String orgTreeid, Map gradeMapping) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        DynaSumMethodEnum method = param.getSumMethod();
        Map number_nameMapping = this.getDItemNumberNameMapping(ctx, report, companyIDs, formula, param, doOffset, includeDiffTable);
        String ext = "_" + ctx.getLocale().getLanguage();
        ArrayList result = new ArrayList();
        if (number_nameMapping == null || number_nameMapping.isEmpty()) {
            return result;
        }
        ArrayList<Object> params = new ArrayList<Object>(42);
        StringBuffer selectSql1 = new StringBuffer();
        boolean isOnlyDisplayFullName = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_PERFORMANCE_ISONLYDISPLAYFULLNAME");
        if (isForSave && formula.getValueType() == 3) {
            sql.append("select DNumber,Fnumber as CompanyNumber,(GNumber || '**' || DNumber) as FSingleNumber, Expr1 as Value  from (\n");
            selectSql1.append(" SELECT de.FKeyNumber AS DNumber,bu.Fnumber as fnumber,de.FGradeNumber AS GNumber, case when d.fdatatype=2 then de.FTextValue else de.FTextValue end AS Expr1 \n");
        } else if (isSumByTextNotGrade) {
            sql.append("select  DNumber, Value from (");
            selectSql1.append("select de.FKeyNumber AS DNumber, (case when d.fdatatype = 2 ");
            selectSql1.append("then de.FTextValue else de.FTextValue end) AS Value, o.fnumber as fnumber");
        } else {
            sql.append("select GroupedTable.*, (GNumber || '**' || DNumber) as FSingleNumber from (\n");
            sql.append("select DNumber, max(GNumber) as GNumber, SUM(Expr1) as Value \n");
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                sql.append(", ONumber, OName");
            }
            sql.append(" from(\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            selectSql1.append(" SELECT de.FKeyNumber AS DNumber, de.FGradeNumber AS GNumber, (case when d.fdatatype=2 then de.FValue else de.FValue end) AS Expr1 \n");
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                String compName = this.getCompanyName(isOnlyDisplayFullName, "o", ext);
                selectSql1.append(", o.FNumber AS ONumber, " + compName.substring(0, compName.lastIndexOf(44)));
            }
        }
        selectSql1.append("\r\n");
        sql.append(selectSql1);
        StringBuffer fromSql = new StringBuffer();
        fromSql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
        fromSql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
        fromSql.append("    ON de.FItemDataID = d.FID                           \n");
        if (isForSave && formula.getValueType() == 3) {
            fromSql.append(" INNER JOIN T_ORG_BaseUnit bu on d.FOrgUnitID=bu.fid  \n");
        }
        fromSql.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
        fromSql.append(" inner join t_csl_cslreport r on d.FReportID = r.FId").append("\r\n");
        if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || isSumByTextNotGrade) {
            fromSql.append(" LEFT JOIN T_ORG_BaseUnit o ON d.FOrgUnitID = o.FID  \n");
        }
        sql.append(fromSql);
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" where  (receive.FOrgTreeID = ?                          \n");
        whereSql.append("    AND d.FCurrencyID = ?                               \n");
        whereSql.append("    AND de.FItemID = ?                                  \n");
        whereSql.append("    AND de.FDataElement = ?                             \n");
        whereSql.append("    AND de.FValueType = ?                               \n");
        whereSql.append("    AND de.FYear = ?                                    \n");
        whereSql.append("    AND de.FPeriod = ?                                  \n");
        whereSql.append("    AND d.fperiodtype = ?                                                   \n");
        whereSql.append("    AND ((d.FCommitStatus = ?                           \n");
        whereSql.append("    and d.FOrgUnitID IN (" + companyIDs.toString() + ")  \n");
        whereSql.append("    and r.FSourceType in( ").append(10).append(',').append(doOffset ? 12 : 11).append("))\n");
        whereSql.append("    AND r.FIsSaveAs\t = ?                               \n");
        whereSql.append("    AND r.FCurrencyid\t = ?                               \n");
        whereSql.append("    AND d.FDataCollectNumber = ?                        \n");
        if (includeDiffTable) {
            whereSql.append(" or (d.FOrgUnitId = '").append(report.getOrgUnit().getId().toString());
            whereSql.append("' and r.FSourceType = ").append(8).append(")\n");
        }
        whereSql.append(")                     \n");
        String sql_methodsql = "";
        sql_methodsql = method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) ? " and (d.fdynatype=6 or d.fdataSource=" + RptSrcTypeEnum.DYNAMICNORMALREPORT.getValue() + ")\r\n" : " and d.fdynatype=1\r\n";
        whereSql.append(sql_methodsql);
        whereSql.append("\tAND\tD.FDATATYPE <> ").append(2).append(" \n");
        sql.append(whereSql).append(")");
        params.add(report.getOrgTree().getId().toString());
        params.add(report.getCurrency().getId().toString());
        params.add(formula.getItemNumber());
        Integer dataElement = DataElementProvider.getDataElementInnerValue(ctx, formula.getDataElementNumber());
        params.add(dataElement);
        params.add(formula.getValueType());
        params.add(formula.getYear());
        params.add(formula.getPeriod());
        params.add(report.getPeriodType().getValue());
        params.add(3);
        params.add(0);
        params.add(report.getCurrency().getId().toString());
        params.add(report.getDataCollectNumber());
        if (doOffset) {
            StringBuffer elimWhereSql = new StringBuffer(50);
            elimWhereSql.append(" OR (receive.FOrgTreeID = ?                              \n");
            elimWhereSql.append("    AND d.FCurrencyID = ?                               \n");
            elimWhereSql.append("    AND de.FItemID = ?                                  \n");
            elimWhereSql.append("    AND de.FDataElement = ?                             \n");
            elimWhereSql.append("    AND de.FValueType = ?                               \n");
            elimWhereSql.append("    AND de.FYear = ?                                    \n");
            elimWhereSql.append("    AND de.FPeriod = ?                                  \n");
            elimWhereSql.append("    AND d.fperiodtype = ?                               \n");
            elimWhereSql.append("    and d.FOrgUnitID = ?                                \n");
            elimWhereSql.append("    and r.FSourceType = ").append(42).append(" \n");
            elimWhereSql.append("    AND r.FCurrencyid\t = ?                               \n");
            elimWhereSql.append("   and d.fdynatype=1 )\r\n");
            sql.append(elimWhereSql.toString());
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getPeriodType().getValue());
            params.add(report.getOrgUnit().getId().toString());
            params.add(report.getCurrency().getId().toString());
        }
        if (!(formula.getValueType() == 3 || isForSave && formula.getValueType() == 3)) {
            String compName;
            sql.append(" UNION ALL \n");
            sql.append(" select t3.FKeyLongNumber as DNumber, to_char(null) as GNumber\t\t\t\t\n");
            sql.append(" , t3.fvalue as Expr1\t\t\n");
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                compName = this.getCompanyName(isOnlyDisplayFullName, "o", ext);
                sql.append(", o.FNumber AS ONumber, " + compName.substring(0, compName.lastIndexOf(44)));
            }
            sql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
            sql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                sql.append(" inner JOIN T_ORG_BaseUnit o ON t1.FOrgUnit = o.FID  \n");
            }
            sql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
            sql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
            sql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
            sql.append(" WHERE t1.FOrgUnit IN (" + companyIDs.toString() + ")\t\n");
            sql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t2.FDataElement = ?                             \n");
            sql.append("    and t1.FValueType = ?                               \n");
            sql.append("    and t1.FYear = ?                                    \n");
            sql.append("    and t1.FPeriod = ?                                  \n");
            sql.append("    and t1.FCheckedStatus = ?                           \n");
            sql.append("    and t1.FDataCollectNumber = ?                       \n");
            sql.append("\tAND t1.fdatasource in (1, " + (report.getReportSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? 2 : 3) + ")");
            if (orgTreeid != null) {
                params.add(orgTreeid);
            } else {
                params.add(report.getOrgTree().getId().toString());
            }
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(2);
            params.add(report.getDataCollectNumber());
            if (doOffset) {
                sql.append(" UNION ALL \n");
                sql.append(" SELECT de.FKeyLongNumber AS DNumber, to_char(null) as GNumber, de.FValue AS Expr1 \n");
                if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                    compName = this.getCompanyName(isOnlyDisplayFullName, "o", ext);
                    sql.append(", o.FNumber AS ONumber, " + compName.substring(0, compName.lastIndexOf(44)));
                }
                sql.append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n");
                if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                    sql.append(" left JOIN T_ORG_BaseUnit o ON ee.FCompanyID = o.FID  \n");
                }
                sql.append(" WHERE e.FOrgUnit =? \t\t\t\t     \n").append(" AND e.FCurrencyID = ?                                                  \n").append(" AND ri.fNumber = ?                                                     \n").append(" AND ee.FDataElement = ?                                                \n").append(" AND e.FValueType = ?                                                   \n").append(" AND e.FYear = ?                                                      \n").append(" AND e.FPeriod= ?                                                       \n").append(" AND e.FCheckedStatus = 2   \n").append(" AND e.FOrgBoundID = ?                                                  \n").append(" AND e.FDataCollectNumber = ?                                           \n");
                params.add(report.getOrgUnit().getId().toString());
                params.add(report.getCurrency().getId().toString());
                params.add(formula.getItemNumber());
                params.add(dataElement);
                params.add(formula.getValueType());
                params.add(formula.getYear());
                params.add(formula.getPeriod());
                params.add(report.getOrgTree().getId().toString());
                params.add(report.getDataCollectNumber());
            }
        }
        if (isForSave && formula.getValueType() == 3) {
            sql.append(") t order by t.fnumber\t\t\t\t\t\t\t \n");
        } else if (isSumByTextNotGrade) {
            sql.append(") as t order by t.fnumber asc\t\t\t\t     \n");
        } else {
            sql.append(") as t group by DNumber\t\t\t\t\t\t\t\n");
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                sql.append(", ONumber, OName ");
            }
            sql.append(") as GroupedTable");
            sql.append(" order by GNumber, DNumber\t\t\t\t\t\t\t\t\t\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (isTextGrade && formula.getValueType() != 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                return this.sumCompany(rs, gradeMapping);
            }
            if (isTextGrade && isForSave && formula.getValueType() == 3 && method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                HashMap<String, String> tmpValue = new HashMap<String, String>();
                HashMap<String, String> gradNumberValue = new HashMap<String, String>();
                String number = null;
                String value = null;
                String tmpTextValue = null;
                String name = null;
                while (rs.next()) {
                    number = rs.getString("DNumber");
                    value = rs.getString("Value");
                    if (StringUtils.isEmpty((String)value) || value.toUpperCase(Locale.ENGLISH).equals("NULL")) continue;
                    if (tmpValue.containsKey(number)) {
                        tmpTextValue = tmpValue.get(number) + ";" + value;
                        tmpValue.remove(number);
                        tmpValue.put(number, tmpTextValue);
                    } else {
                        tmpValue.put(number, value);
                    }
                    if (!isTextGrade || gradeMapping == null) continue;
                    String singleNumber = rs.getString("FSINGLENUMBER");
                    String grade = (String)gradeMapping.get(singleNumber);
                    if (gradNumberValue.containsKey(number)) continue;
                    gradNumberValue.put(number, grade);
                }
                Iterator iter = tmpValue.keySet().iterator();
                while (iter.hasNext()) {
                    HashMap<String, String> row = new HashMap<String, String>(8);
                    number = (String)iter.next();
                    name = (String)number_nameMapping.get(number);
                    tmpTextValue = (String)tmpValue.get(number);
                    row.put("KEY_DITEM_NUMBER", number);
                    row.put("KEY_DITEM_NAME", name);
                    row.put("KEY_DITEM_VALUE", tmpTextValue);
                    if (isTextGrade) {
                        row.put("GRADE_NUMBER", (String)gradNumberValue.get(number));
                    }
                    result.add(row);
                }
                return result;
            }
            if (!isTextGrade && formula.getValueType() == 3 && (method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME))) {
                HashMap<String, String> tmpValue = new HashMap<String, String>();
                String number = null;
                String value = null;
                String tmpTextValue = null;
                String name = null;
                while (rs.next()) {
                    number = rs.getString("DNumber");
                    value = rs.getString("Value");
                    if (StringUtils.isEmpty((String)value) || value.toUpperCase(Locale.ENGLISH).equals("NULL")) continue;
                    if (tmpValue.containsKey(number)) {
                        tmpTextValue = tmpValue.get(number) + ";" + value;
                        tmpValue.remove(number);
                        tmpValue.put(number, tmpTextValue);
                        continue;
                    }
                    tmpValue.put(number, value);
                }
                Iterator iter = tmpValue.keySet().iterator();
                while (iter.hasNext()) {
                    HashMap<String, String> row = new HashMap<String, String>(4);
                    number = (String)iter.next();
                    name = (String)number_nameMapping.get(number);
                    tmpTextValue = (String)tmpValue.get(number);
                    row.put("KEY_DITEM_NUMBER", number);
                    row.put("KEY_DITEM_NAME", name);
                    row.put("KEY_DITEM_VALUE", tmpTextValue);
                    result.add(row);
                }
                return result;
            }
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>(4);
                String number = null;
                String name = null;
                if (formula.getValueType() != 3 && (method.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || method.equals((Object)DynaSumMethodEnum.SUM_BY_NAME))) {
                    number = rs.getString("DNumber");
                    name = (String)number_nameMapping.get(number);
                    if (gradeMapping != null) {
                        String singleNumber = rs.getString("FSingleNumber");
                        if (!StringUtils.isEmpty((String)singleNumber)) {
                            singleNumber = singleNumber.trim();
                        }
                        String grade = (String)gradeMapping.get(singleNumber);
                        row.put("GRADE_NUMBER", grade);
                    }
                }
                row.put("KEY_DITEM_NUMBER", number);
                row.put("KEY_DITEM_NAME", name);
                row.put("KEY_DITEM_VALUE", rs.getObject("Value"));
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private List getDynaItemDataByCompany(Context ctx, CslReportInfo report, String companyIDs, ItemFormula formula, boolean doOffset, boolean includeDiffTable, DynaParameters param, String orgTreeid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        DynaSumMethodEnum method = param.getSumMethod();
        String ext = "_" + ctx.getLocale().getLanguage();
        ArrayList<HashMap<Object, Object>> result = new ArrayList<HashMap<Object, Object>>();
        ArrayList<Object> params = new ArrayList<Object>(50);
        sql.append("select ONumber,OName, SUM(Expr1) as Value from(\n");
        StringBuffer selectSqlForNoConvert = new StringBuffer();
        boolean isOnlyDisplayFullName = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_PERFORMANCE_ISONLYDISPLAYFULLNAME");
        selectSqlForNoConvert.append(" SELECT o.FNumber AS ONumber, \n");
        selectSqlForNoConvert.append(this.getCompanyName(isOnlyDisplayFullName, "o", ext));
        selectSqlForNoConvert.append(" SUM(de.FValue) AS Expr1");
        sql.append(selectSqlForNoConvert);
        StringBuffer fromSql = new StringBuffer();
        fromSql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
        fromSql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
        fromSql.append("    ON de.FItemDataID = d.FID                           \n");
        fromSql.append(" INNER JOIN T_ORG_BaseUnit o                            \n");
        fromSql.append("    ON d.FOrgUnitID = o.FID                             \n");
        fromSql.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
        fromSql.append(" inner join t_csl_cslreport r on d.FReportID = r.FId    \n");
        sql.append(fromSql);
        StringBuffer whereSql = new StringBuffer();
        whereSql.append("WHERE (d.FOrgUnitID IN (" + companyIDs.toString() + ")").append("\r\n");
        whereSql.append("and d.FDataType = ").append(0).append("\r\n");
        whereSql.append("    and receive.FOrgTreeID = ?                                \n");
        whereSql.append("        AND d.FCurrencyID = ?                           \n");
        whereSql.append("        AND de.FItemID = ?                              \n");
        whereSql.append("        AND de.FDataElement = ?                         \n");
        whereSql.append("        AND de.FValueType = ?                           \n");
        whereSql.append("        AND de.FYear = ?                                \n");
        whereSql.append("        AND de.FPeriod = ?                              \n");
        whereSql.append("    AND d.fperiodtype = ?                                                   \n");
        whereSql.append("    AND d.FCommitStatus = ?                             \n");
        whereSql.append("    and r.FSourceType in( ").append(10).append(',').append(doOffset ? 12 : 11).append(")\n");
        whereSql.append("    AND r.FIsSaveAs\t = ?                               \n");
        whereSql.append("    AND r.FCurrencyid\t = ?                               \n");
        whereSql.append("    AND d.FDataCollectNumber = ?                               \n");
        if (param.isGrade()) {
            whereSql.append(" and not exists").append("\r\n");
            whereSql.append(" (").append("\r\n");
            whereSql.append("   select 1 from T_CSL_DynaItemDataEntry sde").append("\r\n");
            whereSql.append("   where sde.FItemDataID=d.FID").append("\r\n");
            whereSql.append("   and CHARINDEX(sde.FKeyNumber||'!',de.FKeyNumber) = 1").append("\r\n");
            whereSql.append(" )").append("\r\n");
        }
        String sql_methodsql = "";
        sql_methodsql = method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) ? " and (d.fdynatype=6 or d.fdataSource=" + RptSrcTypeEnum.DYNAMICNORMALREPORT.getValue() + ")\r\n" : " and d.fdynatype=1\r\n";
        whereSql.append(sql_methodsql);
        whereSql.append("\tAND d.fdatatype<>").append(2).append(") \r\n");
        sql.append(whereSql);
        sql.append(" GROUP BY o.FNumber,o.FSimpleName, o.FName" + ext + ",r.fid              \n");
        params.add(report.getOrgTree().getId().toString());
        params.add(report.getCurrency().getId().toString());
        params.add(formula.getItemNumber());
        Integer dataElement = DataElementProvider.getDataElementInnerValue(ctx, formula.getDataElementNumber());
        params.add(dataElement);
        params.add(formula.getValueType());
        params.add(formula.getYear());
        params.add(formula.getPeriod());
        params.add(report.getPeriodType().getValue());
        params.add(3);
        params.add(0);
        params.add(report.getCurrency().getId().toString());
        params.add(report.getDataCollectNumber());
        if (doOffset) {
            sql.append(" UNION ALL \n");
            sql.append(" SELECT de.FKeyNumber AS ONumber, \n");
            sql.append(" de.FKeyName as OName, \n");
            sql.append(" SUM(de.FValue) AS Expr1");
            fromSql = new StringBuffer();
            fromSql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
            fromSql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
            fromSql.append("    ON de.FItemDataID = d.FID                           \n");
            fromSql.append(" INNER JOIN T_ORG_BaseUnit o                            \n");
            fromSql.append("    ON d.FOrgUnitID = o.FID                             \n");
            fromSql.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
            fromSql.append(" inner join t_csl_cslreport r on d.FReportID = r.FId    \n");
            sql.append(fromSql);
            StringBuffer elimWhereSql = new StringBuffer(50);
            elimWhereSql.append(" Where (receive.FOrgTreeID = ?                              \n");
            elimWhereSql.append("    AND d.FCurrencyID = ?                               \n");
            elimWhereSql.append("    AND de.FItemID = ?                                  \n");
            elimWhereSql.append("    AND de.FDataElement = ?                             \n");
            elimWhereSql.append("    AND de.FValueType = ?                               \n");
            elimWhereSql.append("    AND de.FYear = ?                                    \n");
            elimWhereSql.append("    AND de.FPeriod = ?                                  \n");
            elimWhereSql.append("    AND d.fperiodtype = ?                               \n");
            elimWhereSql.append("    and d.FOrgUnitID = ?                                \n");
            elimWhereSql.append("    and r.FSourceType = ").append(42).append(" \n");
            elimWhereSql.append("    AND r.FCurrencyid\t = ?                               \n");
            elimWhereSql.append("   and d.fdynatype=6 )\r\n");
            sql.append(elimWhereSql.toString());
            sql.append(" GROUP BY de.FKeyNumber, de.FKeyName \n");
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getPeriodType().getValue());
            params.add(report.getOrgUnit().getId().toString());
            params.add(report.getCurrency().getId().toString());
        }
        sql.append(" UNION ALL \n");
        sql.append(" select orgUnit.Fnumber as ONumber,\n");
        sql.append(this.getCompanyName(isOnlyDisplayFullName, "orgUnit", ext));
        sql.append(" sum(t3.fvalue) as Expr1\t\t\t\t\t\n");
        sql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
        sql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
        sql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
        sql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
        sql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
        sql.append(" inner join T_Org_BaseUnit orgUnit\t\t\t\t\t\t\n");
        sql.append(" on t1.FOrgUnit=orgUnit.FID\t\t\t\t\t\t\t\t\n");
        sql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
        sql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
        sql.append(" WHERE t1.FOrgUnit IN (" + companyIDs.toString() + ")\t\n");
        sql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\t\n");
        sql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
        sql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
        sql.append("    and t2.FDataElement = ?                             \n");
        sql.append("    and t1.FValueType = ?                               \n");
        sql.append("    and t1.FYear = ?                                    \n");
        sql.append("    and t1.FPeriod = ?                                  \n");
        sql.append("    and t1.FCheckedStatus = ?                           \n");
        sql.append("    and t1.FDataCollectNumber = ?                           \n");
        sql.append("\tAND t1.fdatasource in (1, " + (report.getReportSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? 2 : 3) + ")");
        sql.append(" group by orgUnit.Fnumber,orgUnit.FSimpleName,orgUnit.FName" + ext + " \n");
        if (orgTreeid != null) {
            params.add(orgTreeid);
        } else {
            params.add(report.getOrgTree().getId().toString());
        }
        params.add(report.getCurrency().getId().toString());
        params.add(formula.getItemNumber());
        params.add(dataElement);
        params.add(formula.getValueType());
        params.add(formula.getYear());
        params.add(formula.getPeriod());
        params.add(2);
        params.add(report.getDataCollectNumber());
        if (doOffset) {
            sql.append(" UNION ALL \n");
            sql.append(" SELECT u.FNumber AS ONumber, " + this.getCompanyName(isOnlyDisplayFullName, "u", ext) + " SUM(de.FValue) AS Expr1 \n").append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n").append(" LEFT  JOIN T_ORG_BaseUnit u ON u.FID = ee.FCompanyID                  \n").append(" WHERE e.FOrgUnit =? \t\t\t\t     \n").append(" AND e.FCurrencyID = ?                                                  \n").append(" AND ri.fNumber = ?                                                     \n").append(" AND ee.FDataElement = ?                                                \n").append(" AND e.FValueType = ?                                                   \n").append(" AND e.FYear = ?                                                      \n").append(" AND e.FPeriod= ?                                                       \n").append(" AND e.FOrgBoundID = ?                                                  \n").append(" AND e.FCheckedStatus = 2   \n").append(" AND e.FDataCollectNumber = ?  \n").append(" GROUP BY u.FNumber, u.FSimpleName,u.FName" + ext + "                  \n");
            params.add(report.getOrgUnit().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getDataCollectNumber());
        }
        if (includeDiffTable) {
            sql.append(" UNION ALL \n");
            sql.append(" SELECT o.FNumber AS ONumber,to_char('");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"137_CslReportControllerBean", (Locale)ctx.getLocale())).append("') AS OName,");
            sql.append(" SUM(de.FValue) AS Expr1\t\t\t\t\t\n");
            sql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
            sql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
            sql.append("    ON de.FItemDataID = d.FID                           \n");
            sql.append(" INNER JOIN T_ORG_BaseUnit o                            \n");
            sql.append("    ON d.FOrgUnitID = o.FID                             \n");
            sql.append(" inner join t_csl_cslreport r on d.FReportID = r.FId    \n");
            sql.append(" WHERE d.FOrgUnitID = '" + report.getOrgUnit().getId().toString() + "'  \n");
            sql.append("        AND d.FCurrencyID = ?                           \n");
            sql.append("        AND de.FItemID = ?                              \n");
            sql.append("        AND de.FDataElement = ?                         \n");
            sql.append("        AND de.FValueType = ?                           \n");
            sql.append("        AND de.FYear = ?                                \n");
            sql.append("        AND de.FPeriod = ?                              \n");
            sql.append("        AND d.FDataCollectNumber = ?                           \n");
            sql.append("    and r.FSourceType = ").append(8);
            sql.append(" GROUP BY o.FNumber,o.FName" + ext + "                \n");
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getDataCollectNumber());
        }
        sql.append(") as t group by ONumber,OName\t\t\t\t\t\t\t\n");
        sql.append(" order by ONumber\t\t\t\t\t\t\t\t\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        DynaParamInfo paramInfo = new DynaParamInfo();
        paramInfo.isSupportCrossMerger = false;
        paramInfo.report = report;
        DynaNumberTransition4ListAll transition = new DynaNumberTransition4ListAll(paramInfo, ctx, param, new HashMap<Object, Object>(), new HashMap<Object, Object>());
        try {
            HashMap<Object, Object> row = null;
            String number = null;
            String name = null;
            while (rs.next()) {
                row = new HashMap<Object, Object>(4);
                number = rs.getString("ONumber");
                name = rs.getString("OName");
                if (name.equals(number)) {
                    String[] numberAndName = transition.transition("", number, name, row);
                    number = numberAndName[0];
                    name = numberAndName[1];
                }
                row.put("KEY_DITEM_NUMBER", number);
                row.put("KEY_DITEM_NAME", name);
                row.put("KEY_DITEM_VALUE", rs.getObject("Value"));
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private String getCompanyName(boolean isOnlyDisplayFullName, String alias, String ext) {
        return isOnlyDisplayFullName ? alias + ".FName" + ext + " AS OName," : " case when " + alias + ".FSimpleName is null then " + alias + ".FName" + ext + " else " + alias + ".FSimpleName end AS OName, \n";
    }

    private List getDynaItemDataListAll(Context ctx, CslReportInfo report, String companyIDs, ItemFormula formula, boolean doOffset, boolean includeDiffTable, boolean isForSave, DynaParameters param, String orgTreeid, Map gradeMapping) throws BOSException, EASBizException {
        Map number_nameMapping;
        StringBuffer sql = new StringBuffer();
        DynaSumMethodEnum method = param.getSumMethod();
        String ext = "_" + ctx.getLocale().getLanguage();
        ArrayList<HashMap<Object, Object>> result = new ArrayList<HashMap<Object, Object>>();
        ArrayList<Object> params = new ArrayList<Object>(50);
        boolean isOnlyListCompany = param.isOnlyListCompany();
        if (method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && isOnlyListCompany) {
            companyIDs = CslRptUtil.expandCompanys(ctx, report.getOrgTree().getId().toString(), companyIDs, true);
        }
        if ((number_nameMapping = this.getDItemNumberNameMapping(ctx, report, companyIDs.toString(), formula, param, doOffset, includeDiffTable)) == null || number_nameMapping.isEmpty()) {
            return result;
        }
        if (formula.getValueType() == 3) {
            sql.append("select DNumber, ONumber, OName, to_char(Expr1) as Value,FSingleNumber from(\t\n");
        } else {
            sql.append("select DNumber, ONumber, OName, sum(Expr1) as Value,FSingleNumber from( \n");
            sql.append("select DNumber, ONumber, OName, sum(Expr1) as Expr1,FSingleNumber from ( \n");
        }
        StringBuffer selectSqlForNoConvert = new StringBuffer();
        boolean isOnlyDisplayFullName = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_PERFORMANCE_ISONLYDISPLAYFULLNAME");
        selectSqlForNoConvert.append(" SELECT de.FKeyNumber as DNumber, o.FNumber AS ONumber,");
        selectSqlForNoConvert.append(this.getCompanyName(isOnlyDisplayFullName, "o", ext));
        if (formula.getValueType() == 3) {
            selectSqlForNoConvert.append("to_char(de.FTextValue)  AS Expr1, \n");
        } else {
            selectSqlForNoConvert.append("de.FValue  AS Expr1,   \n");
        }
        selectSqlForNoConvert.append("substring(de.FGradeNumber || '**' || de.FKeyNumber,1,255) as FSingleNumber \n");
        sql.append(selectSqlForNoConvert);
        StringBuffer fromSqlForNoConvert = new StringBuffer();
        fromSqlForNoConvert.append(" FROM T_CSL_DynaItemDataEntry de                                            \n");
        fromSqlForNoConvert.append(" INNER JOIN T_CSL_DynaItemData d                                            \n");
        fromSqlForNoConvert.append("    ON de.FItemDataID = d.FID                                               \n");
        fromSqlForNoConvert.append(" INNER JOIN T_ORG_BaseUnit o                                                \n");
        fromSqlForNoConvert.append("    ON d.FOrgUnitID = o.FID                                                 \n");
        fromSqlForNoConvert.append(" inner join t_csl_rptreceived receive on d.FReportId = receive.FReportId \n");
        fromSqlForNoConvert.append(" inner join t_csl_cslReport r on d.FReportId = r.FID                        \n");
        sql.append(fromSqlForNoConvert);
        StringBuffer whereSqlForNoConvert = new StringBuffer();
        whereSqlForNoConvert.append(" WHERE ( d.FOrgUnitID IN (" + companyIDs.toString() + ")                      \n");
        whereSqlForNoConvert.append("    and receive.FOrgTreeID = ?                                \n");
        whereSqlForNoConvert.append("    AND d.FCurrencyID = ?                                                   \n");
        whereSqlForNoConvert.append("    AND de.FItemID = ?                                                      \n");
        whereSqlForNoConvert.append("    AND de.FDataElement = ?                                                 \n");
        whereSqlForNoConvert.append("    AND de.FValueType = ?                                                   \n");
        whereSqlForNoConvert.append("    AND de.FYear = ?                                                        \n");
        whereSqlForNoConvert.append("    AND de.FPeriod = ?                                                      \n");
        whereSqlForNoConvert.append("    AND d.fperiodtype = ?                                                   \n");
        whereSqlForNoConvert.append("    AND d.FCommitStatus = ?                                                 \n");
        whereSqlForNoConvert.append("    and r.FSourceType in( ").append(10).append(',').append(doOffset ? 12 : 11).append(") \n");
        whereSqlForNoConvert.append("    AND r.FIsSaveAs\t = ?                               \n");
        whereSqlForNoConvert.append("    AND r.FCurrencyid\t = ?                               \n");
        whereSqlForNoConvert.append("    AND r.FAdjustStatus\t != 1                              \n");
        whereSqlForNoConvert.append("    AND d.FDataCollectNumber = ?                                                   \n");
        String sql_methodsql = "";
        sql_methodsql = method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) ? " and (d.fdynatype=6 or d.fdataSource=" + RptSrcTypeEnum.DYNAMICNORMALREPORT.getValue() + ")\r\n" : " and d.fdynatype=1\r\n";
        whereSqlForNoConvert.append(sql_methodsql);
        whereSqlForNoConvert.append("\tAND d.fdatatype<>").append(2).append(") \r\n");
        sql.append(whereSqlForNoConvert);
        params.add(report.getOrgTree().getId().toString());
        params.add(report.getCurrency().getId().toString());
        params.add(formula.getItemNumber());
        Integer dataElement = DataElementProvider.getDataElementInnerValue(ctx, formula.getDataElementNumber());
        params.add(dataElement);
        params.add(formula.getValueType());
        params.add(formula.getYear());
        params.add(formula.getPeriod());
        params.add(report.getPeriodType().getValue());
        params.add(3);
        params.add(0);
        params.add(report.getCurrency().getId().toString());
        params.add(report.getDataCollectNumber());
        if (doOffset) {
            StringBuffer elimWhereSql = new StringBuffer(50);
            elimWhereSql.append(" OR (receive.FOrgTreeID = ?                              \n");
            elimWhereSql.append("    AND d.FCurrencyID = ?                               \n");
            elimWhereSql.append("    AND de.FItemID = ?                                  \n");
            elimWhereSql.append("    AND de.FDataElement = ?                             \n");
            elimWhereSql.append("    AND de.FValueType = ?                               \n");
            elimWhereSql.append("    AND de.FYear = ?                                    \n");
            elimWhereSql.append("    AND de.FPeriod = ?                                  \n");
            elimWhereSql.append("    AND d.fperiodtype = ?                               \n");
            elimWhereSql.append("    and d.FOrgUnitID = ?                                \n");
            elimWhereSql.append("    and r.FSourceType = ").append(42).append(" \n");
            elimWhereSql.append("    AND r.FCurrencyid\t = ?                               \n");
            elimWhereSql.append("   and d.fdynatype=6 )\r\n");
            sql.append(elimWhereSql.toString());
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getPeriodType().getValue());
            params.add(report.getOrgUnit().getId().toString());
            params.add(report.getCurrency().getId().toString());
        }
        if (formula.getValueType() != 3) {
            sql.append(" ) as t3 group by DNumber,ONumber,OName,FSingleNumber \n");
        }
        if (formula.getValueType() != 3) {
            sql.append(" UNION ALL \n");
            sql.append("SELECT t3.FKeyLongNumber AS DNumber , orgUnit.Fnumber AS ONumber, \n");
            sql.append(this.getCompanyName(isOnlyDisplayFullName, "orgUnit", ext));
            sql.append(" t3.FValue AS Expr1,\n");
            sql.append(this.getDynaItemLongNumberSql("t3"));
            sql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
            sql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
            sql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_Org_BaseUnit orgUnit\t\t\t\t\t\t\n");
            sql.append(" on t1.FOrgUnit=orgUnit.FID\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
            sql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
            sql.append(" WHERE t1.FOrgUnit IN (" + companyIDs.toString() + ")\t\n");
            sql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t2.FDataElement = ?                             \n");
            sql.append("    and t1.FValueType = ?                               \n");
            sql.append("    and t1.FYear = ?                                    \n");
            sql.append("    and t1.FPeriod = ?                                  \n");
            sql.append("    and t1.FCheckedStatus = ?                           \n");
            sql.append("    and t1.FDataCollectNumber = ?                           \n");
            sql.append("\tAND t1.fdatasource in (1, " + (report.getReportSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? 2 : 3) + ")");
            if (orgTreeid != null) {
                params.add(orgTreeid);
            } else {
                params.add(report.getOrgTree().getId().toString());
            }
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(2);
            params.add(report.getDataCollectNumber());
        }
        if (doOffset && formula.getValueType() != 3) {
            sql.append(" UNION ALL \n");
            sql.append("SELECT de.FKeyLongNumber AS DNumber, u.FNumber AS ONumber, ");
            sql.append(this.getCompanyName(isOnlyDisplayFullName, "u", ext));
            sql.append(" de.FValue  AS Expr1, \n");
            sql.append(this.getDynaItemLongNumberSql("de"));
            sql.append(" FROM t_csl_elimDynaItemEntry de                                     \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n").append(" LEFT JOIN T_ORG_BaseUnit u ON u.FID = ee.FCompanyID                  \n").append(" WHERE e.FOrgUnit =? \t\t\t\t     \n").append(" AND e.FCurrencyID = ?                                                  \n").append(" AND ri.fNumber = ?                                                     \n").append(" AND ee.FDataElement = ?                                                \n").append(" AND e.FValueType = ?                                                   \n").append(" AND e.FYear = ?                                                      \n").append(" AND e.FPeriod= ?                                                       \n").append(" AND e.FCheckedStatus = 2   \n").append(" AND e.FOrgBoundID = ?                                                  \n").append(" AND e.FDataCollectNumber = ?                                                  \n");
            params.add(report.getOrgUnit().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getDataCollectNumber());
        }
        if (includeDiffTable) {
            sql.append(" UNION ALL \n");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"135_CSLReportCalculatorControllerBean", (Locale)ctx.getLocale()));
            if (formula.getValueType() == 3) {
                sql.append(" de.FTextValue  AS Expr1 \n");
            } else {
                sql.append(" de.FValue  AS Expr1     \n");
            }
            sql.append(",substring(de.FGradeNumber||'**'||de.FKeyNumber,1,255) as FSingleNumber     \n");
            sql.append(" FROM T_CSL_DynaItemDataEntry de                                            \n");
            sql.append(" INNER JOIN T_CSL_DynaItemData d                                            \n");
            sql.append("    ON de.FItemDataID = d.FID                                               \n");
            sql.append(" INNER JOIN T_ORG_BaseUnit o                                                \n");
            sql.append("    ON d.FOrgUnitID = o.FID                                                 \n");
            sql.append(" inner join t_csl_cslReport r on d.FReportId = r.FID                        \n");
            sql.append(" WHERE d.FOrgUnitID = '" + report.getOrgUnit().getId().toString() + "'      \n");
            sql.append("    AND d.FCurrencyID = ?                                                   \n");
            sql.append("    AND de.FItemID = ?                                                      \n");
            sql.append("    AND de.FDataElement = ?                                                 \n");
            sql.append("    AND de.FValueType = ?                                                   \n");
            sql.append("    AND de.FYear = ?                                                        \n");
            sql.append("    AND de.FPeriod = ?                                                      \n");
            sql.append("    AND d.FDataCollectNumber = ?                                            \n");
            sql.append("    and r.FSourceType = ").append(8);
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(report.getDataCollectNumber());
        }
        sql.append(") as t ");
        if (formula.getValueType() != 3) {
            sql.append(" group by DNumber,ONumber, OName,FSingleNumber\t\n");
        }
        sql.append(" order by DNumber ASC\t\t\t\t\t\t\t\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        DynaParamInfo paramInfo = new DynaParamInfo();
        paramInfo.isSupportCrossMerger = false;
        paramInfo.report = report;
        DynaNumberTransition4ListAll transition = new DynaNumberTransition4ListAll(paramInfo, ctx, param, number_nameMapping, gradeMapping);
        try {
            boolean isOnlyList = param.isOnlyList();
            HashMap<Object, Object> row = null;
            String number = null;
            String name = null;
            while (rs.next()) {
                String grade;
                String[] numberAndName;
                String singleNumber;
                row = new HashMap<Object, Object>(4);
                String dnumber = rs.getString("DNumber");
                String onumber = rs.getString("ONumber");
                String oname = rs.getString("OName");
                if (method.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY)) {
                    if (number_nameMapping.get(dnumber) != null) {
                        if (!StringUtils.isEmpty((String)dnumber)) {
                            dnumber = dnumber.trim();
                        }
                        String grade2 = (String)gradeMapping.get(dnumber);
                        row.put("GRADE_NUMBER", grade2);
                        number = dnumber + '[' + onumber + ']';
                        row.put("COMPANY_NAME", oname);
                        name = (String)number_nameMapping.get(dnumber) + '[' + oname + ']';
                    } else {
                        singleNumber = rs.getString("FSingleNumber");
                        numberAndName = transition.transition(singleNumber, dnumber, oname, row);
                        number = numberAndName[0];
                        name = numberAndName[1];
                    }
                } else if (method.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME)) {
                    if (number_nameMapping.get(dnumber) != null) {
                        number = onumber + '[' + dnumber + ']';
                        singleNumber = rs.getString("FSingleNumber");
                        if (!StringUtils.isEmpty((String)singleNumber)) {
                            singleNumber = singleNumber.trim();
                        }
                        grade = (String)gradeMapping.get(singleNumber);
                        row.put("GRADE_NUMBER", grade);
                        row.put("COMPANY_NAME", oname);
                        name = '[' + oname + ']' + (String)number_nameMapping.get(dnumber);
                    } else {
                        singleNumber = rs.getString("FSingleNumber");
                        numberAndName = transition.transition(singleNumber, dnumber, oname, row);
                        number = numberAndName[0];
                        name = numberAndName[1];
                    }
                } else if (method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
                    if (number_nameMapping.get(dnumber) != null) {
                        String rptUnitNumber;
                        singleNumber = rs.getString("FSingleNumber");
                        if (!StringUtils.isEmpty((String)singleNumber)) {
                            singleNumber = singleNumber.trim();
                        }
                        number = onumber + '[' + dnumber + ']';
                        grade = (String)gradeMapping.get(singleNumber);
                        row.put("GRADE_NUMBER", grade);
                        name = (String)number_nameMapping.get(dnumber);
                        if (!isOnlyListCompany) {
                            name = '[' + oname + ']' + name;
                        } else {
                            int site = name.lastIndexOf("[");
                            if (site < 0) {
                                name = '[' + oname + ']' + name;
                            } else if (site > 0) {
                                name = name.substring(site);
                            }
                        }
                        String str = (String)number_nameMapping.get(dnumber);
                        int site = str.lastIndexOf("]");
                        if (site > 0) {
                            oname = oname + str.substring(0, site + 1);
                        }
                        String string = rptUnitNumber = report.getOrgUnit() == null ? "NULL" : report.getOrgUnit().getNumber();
                        if (onumber.equals(rptUnitNumber)) {
                            number = dnumber;
                            name = (String)number_nameMapping.get(dnumber);
                        }
                        row.put("COMPANY_NAME", oname);
                    } else {
                        singleNumber = rs.getString("FSingleNumber");
                        numberAndName = transition.transition(singleNumber, dnumber, oname, row);
                        number = numberAndName[0];
                        name = numberAndName[1];
                    }
                }
                row.put("KEY_DITEM_NUMBER", number);
                row.put("KEY_DITEM_NAME", name);
                if (formula.getValueType() == 3 && method.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && isOnlyList && !isForSave && param.isGrade()) {
                    row.put("KEY_DITEM_VALUE", null);
                } else {
                    row.put("KEY_DITEM_VALUE", rs.getObject("Value"));
                }
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private List sumCompany(IRowSet rs, Map gradeMapping) throws SQLDataException {
        HashMap<String, DItemGradeInfo> infos = new HashMap<String, DItemGradeInfo>();
        try {
            while (rs.next()) {
                String dnumber = rs.getString("ONumber");
                DItemGradeInfo o = (DItemGradeInfo)infos.get(dnumber);
                if (o == null) {
                    o = new DItemGradeInfo();
                    infos.put(dnumber, o);
                }
                String ditemKeyNumber = rs.getString("DNumber");
                String grade = (String)gradeMapping.get(ditemKeyNumber);
                MyDItemGradeEntryInfo en = new MyDItemGradeEntryInfo(grade);
                en.value = rs.getObject("Value");
                en.D_Name = rs.getString("OName");
                en.D_number = dnumber;
                o.getEntries().add(en);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Iterator it = infos.values().iterator();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            MyDItemGradeEntryInfo en;
            int i;
            DItemGradeInfo info = (DItemGradeInfo)it.next();
            info.reform2(true);
            MyDItemGradeEntryInfo root = new MyDItemGradeEntryInfo();
            root.setLevel(0);
            root.setLeaf(false);
            int top_level = Integer.MAX_VALUE;
            for (i = 0; i < info.getEntries().size(); ++i) {
                en = (MyDItemGradeEntryInfo)((Object)info.getEntries().get(i));
                if (top_level <= en.getLevel()) continue;
                top_level = en.getLevel();
            }
            for (i = 0; i < info.getEntries().size(); ++i) {
                en = (MyDItemGradeEntryInfo)((Object)info.getEntries().get(i));
                if (en.getChildren().size() > 0) {
                    en.value = CslConstant.BGZERO;
                }
                if (root.D_Name == null) {
                    root.D_Name = en.D_Name;
                    root.D_number = en.D_number;
                }
                if (en.getLevel() != top_level) continue;
                root.getChildren().add(en);
            }
            CSLReportCalculatorControllerBean.sumTextGradeChildren(root);
            HashMap<String, Object> row = new HashMap<String, Object>(4);
            row.put("KEY_DITEM_NUMBER", root.D_Name);
            row.put("KEY_DITEM_VALUE", root.value);
            row.put("KEY_DITEM_NAME", root.D_Name);
            result.add(row);
        }
        return result;
    }

    private static void sumTextGradeChildren(MyDItemGradeEntryInfo en) {
        if (en.getChildren().size() < 1) {
            return;
        }
        for (MyDItemGradeEntryInfo child : en.getChildren()) {
            CSLReportCalculatorControllerBean.sumTextGradeChildren(child);
            if (!(child.value instanceof BigDecimal) || !(en.value instanceof BigDecimal)) continue;
            en.value = ((BigDecimal)en.value).add((BigDecimal)child.value);
        }
    }

    @Override
    protected Map _calculateDynaSumRpt(Context ctx, String reportID, List companys, Map positions) throws BOSException, EASBizException {
        return this._calculateDynaSumRpt(ctx, reportID, companys, positions, false, false);
    }

    private Map getDItemNumberNameMapping(Context ctx, CslReportInfo report, String companyIDs, ItemFormula formula, DynaParameters param, boolean doOffset, boolean includeDiffTable) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT de.FKeyNumber AS FKeyNumber, de.FKeyName as FKeyName \n");
            sql.append(" FROM T_CSL_DynaItemDataEntry de                        \n");
            sql.append(" INNER JOIN T_CSL_DynaItemData d                        \n");
            sql.append("    ON de.FItemDataID = d.FID                           \n");
            sql.append(" inner join t_csl_rptreceived r on d.FReportId = r.FReportId \n");
            sql.append(" inner join t_csl_cslreport report on d.FReportID = report.FId").append("\r\n");
            sql.append("  where (r.FOrgTreeID = ?                                \n");
            sql.append("    AND d.FDataCollectNumber = ?                        \n");
            sql.append("    AND d.FCurrencyID = ?                               \n");
            sql.append("    AND de.FItemID = ?                                  \n");
            sql.append("    AND de.FDataElement = ?                             \n");
            sql.append("    AND de.FValueType = ?                               \n");
            sql.append("    AND de.FYear = ?                                    \n");
            sql.append("    AND de.FPeriod = ?                                  \n");
            sql.append("    and ((d.FOrgUnitID IN (" + companyIDs.toString() + ")  \n");
            sql.append("    AND d.FCommitStatus = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and report.FSourceType <> ").append(8).append(")\n");
            if (includeDiffTable) {
                sql.append(" or (d.FOrgUnitId = '").append(report.getOrgUnit().getId().toString());
                sql.append("' and report.FSourceType = ").append(8).append(")\n");
            }
            sql.append("))\n");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getDataCollectNumber());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            Integer dataElement = DataElementProvider.getDataElementInnerValue(ctx, formula.getDataElementNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(3);
            if (doOffset) {
                sql.append("    OR (r.FOrgTreeID = ?                                \n");
                sql.append("    AND d.FDataCollectNumber = ?                        \n");
                sql.append("    AND d.FCurrencyID = ?                               \n");
                sql.append("    AND de.FItemID = ?                                  \n");
                sql.append("    AND de.FDataElement = ?                             \n");
                sql.append("    AND de.FValueType = ?                               \n");
                sql.append("    AND de.FYear = ?                                    \n");
                sql.append("    AND de.FPeriod = ?                                  \n");
                sql.append("    AND d.FDataSource = 12                              \n");
                sql.append("    and d.FOrgUnitID =? )                               \n");
                params.add(report.getOrgTree().getId().toString());
                params.add(report.getDataCollectNumber());
                params.add(report.getCurrency().getId().toString());
                params.add(formula.getItemNumber());
                dataElement = DataElementProvider.getDataElementInnerValue(ctx, formula.getDataElementNumber());
                params.add(dataElement);
                params.add(formula.getValueType());
                params.add(formula.getYear());
                params.add(formula.getPeriod());
                params.add(report.getOrgUnit().getId().toString());
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            HashMap<String, String> result = new HashMap<String, String>();
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("FKeyName"))) continue;
                result.put(rs.getString("FKeyNumber"), rs.getString("FKeyName"));
            }
            sql.delete(0, sql.length() - 1);
            sql.append(" select t3.FKeyLongNumber as FKeyNumber\t\t\t\t\t\n");
            sql.append(" ,t3.FKeyName\tas \tFKeyName\n");
            sql.append(" From T_CSL_Adjust t1\t\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_AdjustEntry t2\t\t\t\t\t\t\n");
            sql.append(" on t1.FID=t2.fadjustid\t\t\t\t\t\t\t\t\t\n");
            sql.append(" inner join t_Csl_Adjustdynamicitem t3\t\t\t\t\t\n");
            sql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\n");
            sql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
            sql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
            sql.append(" WHERE t1.FOrgUnit IN (" + companyIDs.toString() + ")\t\n");
            sql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
            sql.append("    and t2.FDataElement = ?                             \n");
            sql.append("    and t1.FValueType = ?                               \n");
            sql.append("    and t1.FYear = ?                                    \n");
            sql.append("    and t1.FPeriod = ?                                  \n");
            sql.append("    and t1.FCheckedStatus = ?                           \n");
            sql.append("    and t1.FDataCollectNumber = ?\t\t\t\t\t\t\t\t\n");
            if (doOffset && formula.getValueType() != 3) {
                sql.append(" UNION ALL \n");
                sql.append(" SELECT de.FKeyLongNumber AS FKeyNumber, de.FKeyName as FKeyName    \n").append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n").append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n").append(" WHERE e.FOrgUnit =? \t\t\t\t     \n").append(" AND e.FCurrencyID = ?    \n").append(" AND ri.fNumber = ?       \n").append(" AND ee.FDataElement = ?       \n").append(" AND e.FValueType = ?         \n").append(" AND e.FYear = ?         \n").append(" AND e.FPeriod= ?                 \n").append(" AND e.FCheckedStatus = 2   \n").append(" AND e.FOrgBoundID = ?  \n").append(" AND e.FdataCollectNumber = ?  \n");
            }
            params.clear();
            params.add(report.getOrgTree().getId().toString());
            params.add(report.getCurrency().getId().toString());
            params.add(formula.getItemNumber());
            params.add(dataElement);
            params.add(formula.getValueType());
            params.add(formula.getYear());
            params.add(formula.getPeriod());
            params.add(2);
            params.add(report.getDataCollectNumber());
            if (doOffset && formula.getValueType() != 3) {
                params.add(report.getOrgUnit().getId().toString());
                params.add(report.getCurrency().getId().toString());
                params.add(formula.getItemNumber());
                params.add(dataElement);
                params.add(formula.getValueType());
                params.add(formula.getYear());
                params.add(formula.getPeriod());
                params.add(report.getOrgTree().getId().toString());
                params.add(report.getDataCollectNumber());
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            while (rs.next()) {
                String key = rs.getString("FKeyNumber");
                if (result.containsKey(key)) continue;
                result.put(key, rs.getString("FKeyName"));
            }
            return result;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _calculateDynaSumRptAndSave(Context ctx, String reportID, Map companys, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        DynaRptCalcServerHelper._calculateDynaSumRptAndSave(ctx, reportID, companys, positions, doOffset, includeDiffTable);
    }

    private DynaItemTypeEnum getDynaItemType(Context ctx, String param, Map dynaItemTypes) throws BOSException, EASBizException {
        if (param == null) {
            return DynaItemTypeEnum.Other;
        }
        DynaItemTypeEnum type = null;
        if (dynaItemTypes.containsKey(param)) {
            type = (DynaItemTypeEnum)dynaItemTypes.get(param);
        } else {
            block8: {
                DynaParameters params = DynaParameters.getInstanceFromString((String)param);
                if (params.getDynaItemSource() == 0) {
                    type = DynaItemTypeEnum.ManualImport;
                } else {
                    String itemname = params.getAssistantType().properityName;
                    String sql = "select FAsstHGAttribute from t_bd_asstActType where FNumber = ?";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{itemname});
                    try {
                        if (rowSet.next()) {
                            String asstType = rowSet.getString("FAsstHGAttribute");
                            type = asstType.equals("companyOrg") ? DynaItemTypeEnum.Company : (asstType.equals("customer") ? DynaItemTypeEnum.Custom : (asstType.equals("provider") ? DynaItemTypeEnum.Provider : DynaItemTypeEnum.Other));
                            break block8;
                        }
                        throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"136_CSLReportCalculatorControllerBean", (Locale)ctx.getLocale()) + "\r\n" + params.getAssistantType().properityAlias + "    " + itemname));
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                }
            }
            dynaItemTypes.put(param, type);
        }
        return type;
    }

    @Override
    protected List _getDiffTableIDs(Context ctx, CslReportInfo sumReport) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct r.FId from t_csl_cslReport r ");
        sql.append(" join t_csl_diffTableSumRela re on r.FTemplateId = re.FDiffTableTemplate");
        sql.append(" join t_csl_templetDispense d on r.FTemplateId = d.FDispenseSrcID");
        sql.append(" where re.FSumTmpGroup = ? and r.FYear = ? and r.FPeriod = ?");
        sql.append(" and r.FPeriodType = ? and r.FOrgTreeId = ? and r.FOrgUnitId = ?");
        sql.append(" and r.FCurrencyId = ? and r.FSourceType = 8");
        sql.append(" and r.FAuditedStatus = 2");
        Object[] params = new Object[]{sumReport.getTemplate().getGroup(), new Integer(sumReport.getYear()), new Integer(sumReport.getPeriod()), new Integer(sumReport.getPeriodType().getValue()), sumReport.getOrgTree().getId().toString(), sumReport.getOrgUnit().getId().toString(), sumReport.getCurrency().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected List _sendBackedCompany(Context ctx, IObjectPK reportid, Map itemFormulas) throws BOSException, EASBizException {
        return MnsRptCalcHelper._sendBackedCompany(ctx, reportid, itemFormulas);
    }

    @Override
    protected Map _calculateSumRptByItem(Context ctx, IObjectPK reportID, Vector companys, Map sheets, boolean includeDiffTable, boolean bySumReport, String dataCollectNumber) throws BOSException, EASBizException {
        return this.SumRptCalculateByItem(ctx, reportID, companys, sheets, includeDiffTable, bySumReport, dataCollectNumber);
    }

    @Override
    protected Map _calculateMultiDynaSumRpt(Context ctx, String reportID, List companys, Map assstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany) throws BOSException, EASBizException {
        return this.calculateMutiSumAndCslRptNew(ctx, reportID, companys, assstActTypeMap, positions, sumType, isOnlyCompany, false);
    }

    private Map calculateMutiSumAndCslRpt(Context ctx, String reportID, List companys, Map assstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany, boolean isElim) throws BOSException, EASBizException, DynamicEnumException {
        String oql;
        if (reportID == null || companys == null || companys.size() == 0 || positions == null || positions.size() == 0) {
            return null;
        }
        ICslReport icr = CslReportFactory.getLocalInstance(ctx);
        CslReportCollection reportCol = icr.getCslReportCollection(oql = "select id, year, period, periodType, SourceType, currency.id, currency.precision, OrgTree.id, OrgUnit.id,company.id where id = '" + reportID + "'");
        if (reportCol.size() != 1) {
            return null;
        }
        CslReportInfo report = reportCol.get(0);
        String orgTreeid = report.getOrgTree().getId().toString();
        if (isOnlyCompany) {
            companys = this.expandCompanys(ctx, orgTreeid, companys);
        }
        HashMap result = new HashMap();
        Iterator iter = positions.keySet().iterator();
        while (iter.hasNext()) {
            long time1 = System.currentTimeMillis();
            String sheetID = (String)iter.next();
            Map sheetMap = (Map)positions.get(sheetID);
            HashMap<Point, Map> resultSheet = new HashMap<Point, Map>();
            result.put(sheetID, resultSheet);
            for (Point basePoint : sheetMap.keySet()) {
                Map areaMap = (Map)sheetMap.get(basePoint);
                Map formulasMap = (Map)areaMap.get("formulas");
                AsstActTypeCollection asstActTypeCollection = (AsstActTypeCollection)assstActTypeMap.get(sheetID + "|" + basePoint.x + "|" + basePoint.y);
                if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
                    throw new DynamicEnumException(DynamicEnumException.AT_LEAST_ONE_ASST);
                }
                asstActTypeCollection = this.sortAsstActTypeCollection(asstActTypeCollection);
                Map valueMap = this.getMultiDynaValue(ctx, formulasMap, asstActTypeCollection, companys, report, orgTreeid, sumType, isElim);
                resultSheet.put(basePoint, valueMap);
            }
            logger.info((Object)("sheet" + sheetID + ":" + (System.currentTimeMillis() - time1) + "ms"));
        }
        return result;
    }

    protected Map calculateMutiSumAndCslRptNew(Context ctx, String reportID, List companys, Map assstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany, boolean isElimRpt) throws BOSException, EASBizException, DynamicEnumException {
        String oql;
        if (reportID == null || companys == null || companys.size() == 0 || positions == null || positions.size() == 0) {
            return null;
        }
        ICslReport icr = CslReportFactory.getLocalInstance(ctx);
        CslReportCollection reportCol = icr.getCslReportCollection(oql = "select id, year, period, periodType, SourceType, currency.id, currency.precision, OrgTree.id, OrgUnit.id,company.id where id = '" + reportID + "'");
        if (reportCol.size() != 1) {
            return null;
        }
        CslReportInfo report = reportCol.get(0);
        String orgTreeid = report.getOrgTree().getId().toString();
        List<CompanysExpander.ExcecuteTask> companyTask = new CompanysExpander(ctx, isOnlyCompany, companys, report, isElimRpt).expandCompanys();
        HashMap result = new HashMap();
        Iterator iter = positions.keySet().iterator();
        while (iter.hasNext()) {
            long time1 = System.currentTimeMillis();
            String sheetID = (String)iter.next();
            Map sheetMap = (Map)positions.get(sheetID);
            HashMap<Point, Map> resultSheet = new HashMap<Point, Map>();
            result.put(sheetID, resultSheet);
            for (Point basePoint : sheetMap.keySet()) {
                Map areaMap = (Map)sheetMap.get(basePoint);
                Map formulasMap = (Map)areaMap.get("formulas");
                AsstActTypeCollection asstActTypeCollection = (AsstActTypeCollection)assstActTypeMap.get(sheetID + "|" + basePoint.x + "|" + basePoint.y);
                if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
                    throw new DynamicEnumException(DynamicEnumException.AT_LEAST_ONE_ASST);
                }
                asstActTypeCollection = this.sortAsstActTypeCollection(asstActTypeCollection);
                Map valueMap = null;
                HashSet multiDynaKeySet = new HashSet();
                int size = companyTask.size();
                for (int i = 0; i < size; ++i) {
                    MultiCalculateContext calCtx = new MultiCalculateContext();
                    calCtx.setAsstActTypeCollection(asstActTypeCollection);
                    calCtx.setItemFormulaMap(formulasMap);
                    calCtx.setCtx(ctx);
                    calCtx.setIsOnlyCompany(isOnlyCompany);
                    calCtx.setTask(companyTask.get(i));
                    calCtx.setReportInfo(report);
                    calCtx.setSumType(sumType);
                    calCtx.setElimRpt(isElimRpt);
                    valueMap = this.getMultiDynaValueNew(calCtx);
                    if (valueMap != null && valueMap.containsKey("KEY_ALL_MULTIDYNAKEY")) {
                        multiDynaKeySet.addAll((Set)valueMap.get("KEY_ALL_MULTIDYNAKEY"));
                    }
                    if (resultSheet.containsKey(basePoint)) {
                        if (resultSheet.get(basePoint) == null) continue;
                        ((Map)resultSheet.get(basePoint)).putAll(valueMap);
                        continue;
                    }
                    resultSheet.put(basePoint, valueMap);
                }
                if (resultSheet.get(basePoint) == null || multiDynaKeySet.size() <= 0) continue;
                ((Map)resultSheet.get(basePoint)).put("KEY_ALL_MULTIDYNAKEY", multiDynaKeySet);
            }
            logger.info((Object)("sheet" + sheetID + ":" + (System.currentTimeMillis() - time1) + "ms"));
        }
        return result;
    }

    private Map getMultiDynaValueNew(MultiCalculateContext calCtx) throws EASBizException, BOSException {
        HashMap<Object, Object> moneyFormulaMap = new HashMap<Object, Object>();
        HashMap<Object, Object> textFormulaMap = new HashMap<Object, Object>();
        HashMap<Object, Object> quantityFormulaMap = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : calCtx.getItemFormulaMap().entrySet()) {
            ItemFormula itemFormula = (ItemFormula)entry.getValue();
            if (itemFormula.getValueType() == 3) {
                textFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() == 1) {
                moneyFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() != 2) continue;
            quantityFormulaMap.put(entry.getKey(), itemFormula);
        }
        calCtx.setItemFormulaMap(moneyFormulaMap);
        Map<Object, Object> amountMap = new MultiCalculateProcess(calCtx).calculate();
        calCtx.setItemFormulaMap(textFormulaMap);
        Map<Object, Object> textMap = new MultiCalculateProcess(calCtx).calculate();
        calCtx.setItemFormulaMap(quantityFormulaMap);
        Map<Object, Object> quantityMap = new MultiCalculateProcess(calCtx).calculate();
        Map numerMap = this.mergeMultiDynaResultMap(calCtx.getSumType(), amountMap, textMap);
        Map result = this.mergeMultiDynaResultMap(calCtx.getSumType(), numerMap, quantityMap);
        return result;
    }

    private List expandCompanys(Context ctx, String orgTreeID, List companys) throws BOSException {
        if (companys == null || companys.size() == 0) {
            return companys;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" select subOrg.FUnitID OrgID  from T_ORG_Structure subOrg ");
        sql.append(" inner join T_ORG_Structure superOrg on subOrg.FLongNumber = superOrg.FLongNumber ");
        sql.append(" or charindex(concat(superOrg.flongnumber,'!'),subOrg.flongnumber) = 1 ");
        sql.append(" inner join T_ORG_BaseUnit unit on subOrg.FUnitID = unit.FID ");
        sql.append(" where unit.FIsGrouping = 0 ");
        sql.append(" and subOrg.FTreeID = ? ");
        sql.append(" and superOrg.FTreeID = ? ");
        sql.append(" and superOrg.FUnitID in ");
        params.add(orgTreeID);
        params.add(orgTreeID);
        sql.append(RptUtilForServer.createInEnumSql(companys.iterator(), params, (Context)ctx));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("OrgID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private AsstActTypeCollection sortAsstActTypeCollection(AsstActTypeCollection asstActTypeCollection) {
        if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
            return new AsstActTypeCollection();
        }
        ArrayList<AsstActTypeInfo> asstActTypeList = new ArrayList<AsstActTypeInfo>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            asstActTypeList.add(asstActTypeCollection.get(i));
        }
        ObjectValueComparator comparator = new ObjectValueComparator();
        comparator.setFieldName("number");
        Collections.sort(asstActTypeList, comparator);
        asstActTypeCollection.clear();
        for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
            asstActTypeCollection.add(asstActTypeInfo);
        }
        return asstActTypeCollection;
    }

    private Map getMultiDynaValue(Context ctx, Map itemFormulaMap, AsstActTypeCollection asstActTypeCollection, List companyIDs, CslReportInfo reportInfo, String orgTreeID, MultiDynaSumTypeEnum sumType, boolean isCslOrSum) throws EASBizException, BOSException {
        HashMap numberFormulaMap = new HashMap();
        HashMap textFormulaMap = new HashMap();
        HashMap quantityFormulaMap = new HashMap();
        for (Map.Entry entry : itemFormulaMap.entrySet()) {
            ItemFormula itemFormula = (ItemFormula)entry.getValue();
            if (itemFormula.getValueType() == 3) {
                textFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() == 1) {
                numberFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() != 2) continue;
            quantityFormulaMap.put(entry.getKey(), itemFormula);
        }
        Map amountMap = this.getSortedMultiDynaValue(ctx, numberFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, isCslOrSum);
        Map textMap = this.getSortedMultiDynaValue(ctx, textFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, isCslOrSum);
        Map quantityMap = this.getSortedMultiDynaValue(ctx, quantityFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, isCslOrSum);
        Map numerMap = this.mergeMultiDynaResultMap(sumType, amountMap, textMap);
        Map result = this.mergeMultiDynaResultMap(sumType, numerMap, quantityMap);
        return result;
    }

    private Map mergeMultiDynaResultMap(MultiDynaSumTypeEnum sumType, Map numberMap, Map textMap) {
        if (textMap == null || textMap.size() == 0) {
            return numberMap;
        }
        if (numberMap == null || numberMap.size() == 0) {
            return textMap;
        }
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            Set numberDynaKey = (Set)numberMap.get("KEY_ALL_MULTIDYNAKEY");
            Set textDynaKey = (Set)textMap.get("KEY_ALL_MULTIDYNAKEY");
            numberDynaKey.addAll(textDynaKey);
            numberMap.remove("KEY_ALL_MULTIDYNAKEY");
            textMap.remove("KEY_ALL_MULTIDYNAKEY");
            for (Map.Entry entry : textMap.entrySet()) {
                String orgUnitID = (String)entry.getKey();
                Map orgValueMap = (Map)numberMap.get(orgUnitID);
                if (orgValueMap == null) {
                    numberMap.put(orgUnitID, entry.getValue());
                    continue;
                }
                Map textOrgValueMap = (Map)entry.getValue();
                this.mergeMultiDynaValue(orgValueMap, textOrgValueMap);
            }
            numberMap.put("KEY_ALL_MULTIDYNAKEY", numberDynaKey);
            return numberMap;
        }
        return this.mergeMultiDynaValue(numberMap, textMap);
    }

    private Map mergeMultiDynaValue(Map numberValueMap, Map textValueMap) {
        for (Map.Entry entry2 : textValueMap.entrySet()) {
            String dynaKey = (String)entry2.getKey();
            Map dynaValueMap = (Map)numberValueMap.get(dynaKey);
            if (dynaValueMap == null) {
                numberValueMap.put(dynaKey, entry2.getValue());
                continue;
            }
            Map textDynaValueMap = (Map)entry2.getValue();
            for (Map.Entry entry3 : textDynaValueMap.entrySet()) {
                dynaValueMap.put(entry3.getKey(), entry3.getValue());
            }
        }
        return numberValueMap;
    }

    private Map getSortedMultiDynaValue(Context ctx, Map itemFormulaMap, AsstActTypeCollection asstActTypeCollection, List companyIDs, CslReportInfo reportInfo, String orgTreeID, MultiDynaSumTypeEnum sumType, boolean isCslOrSum) throws EASBizException, BOSException {
        if (itemFormulaMap == null || itemFormulaMap.size() == 0) {
            return null;
        }
        if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
            return null;
        }
        if (companyIDs == null || companyIDs.size() == 0) {
            return null;
        }
        if (orgTreeID == null) {
            return null;
        }
        ArrayList itemFormulaList = new ArrayList(itemFormulaMap.values());
        HashSet dynaKeySet = null;
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            dynaKeySet = new HashSet();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean isFirtstSQL = true;
        ItemFormula lastItemFormula = (ItemFormula)itemFormulaList.get(itemFormulaList.size() - 1);
        int valueType = lastItemFormula.getValueType();
        Map<String, HashSet<Object>> result = new HashMap();
        MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
        int index = 0;
        while (index < itemFormulaList.size()) {
            AsstActTypeInfo asstActTypeInfo;
            int i;
            if (valueType == 3) {
                sql.append(" select ItemDataEntry.FTextValue Value  ");
            } else {
                sql.append(" select rptitem.fdc dc,sum(ItemDataEntry.FValue) Value  ");
            }
            sql.append(" ,ItemDataEntry.FItemID ItemNumber ");
            sql.append(" ,ItemDataEntry.FDataElement DataElement ");
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                sql.append(" ,ItemData.FOrgUnitID OrgUnitID ");
            }
            for (i = 0; i < asstActTypeCollection.size(); ++i) {
                asstActTypeInfo = asstActTypeCollection.get(i);
                String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                String name = ".FName_" + ctx.getLocale().getLanguage();
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                sql.append(",AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" Number").append(asstActTypeNumber);
                sql.append(",AsstActType").append(asstActTypeNumber).append(name).append(" Name").append(asstActTypeNumber);
            }
            sql.append(" from T_CSL_MultiDynaItemData ItemData           ");
            sql.append(" inner join T_CSL_MultiDynaItemDataEntry ItemDataEntry on ItemData.FID = ItemDataEntry.FItemDataID  ");
            sql.append(" inner join T_CSL_RptReceived RptReceived on ItemData.FReportID =  RptReceived.FReportID  ");
            sql.append(" inner join T_CSL_CslRptAssistantHG hg on hg.FID = ItemDataEntry.FCslRptAssistantHGId   ");
            sql.append(" inner join T_CSL_RptItem rptitem on rptitem.fnumber=ItemDataEntry.FitemId \t");
            for (i = 0; i < asstActTypeCollection.size(); ++i) {
                asstActTypeInfo = asstActTypeCollection.get(i);
                sql.append(" inner join ").append(asstActTypeInfo.getRealtionDataObject()).append(" AsstActType").append(asstActTypeInfo.getNumber());
                sql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName()).append(" = AsstActType").append(asstActTypeInfo.getNumber()).append(".FID");
            }
            sql.append(" where RptReceived.FOrgTreeId = ?     ");
            params.add(orgTreeID);
            sql.append(" and ItemData.FCurrencyID = ?    ");
            params.add(reportInfo.getCurrency().getId().toString());
            sql.append(" and ItemDataEntry.FValueType = ? ");
            params.add(new Integer(valueType));
            sql.append(" and ItemData.FOrgUnitID in ");
            sql.append(RptUtilForServer.createInSql(companyIDs.iterator(), params));
            sql.append(" and ItemData.FPeriodType = ? ");
            params.add(new Integer(reportInfo.getPeriodType().getValue()));
            sql.append(" and ItemData.FYear = ? ");
            params.add(new Integer(reportInfo.getYear()));
            sql.append(" and ItemData.FPeriod = ? ");
            params.add(new Integer(reportInfo.getPeriod()));
            sql.append(" and ItemData.FCommitStatus = 3\t\t\t");
            if (reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
                sql.append(" and ItemData.FDataSource in (13,15)    ");
            } else {
                sql.append(" and ItemData.FDataSource in (13,14)    ");
            }
            sql.append(" and ( ");
            boolean addOr = false;
            ArrayList<Map> dynaMapList = new ArrayList<Map>();
            ArrayList<ItemFormula> itemList = new ArrayList<ItemFormula>();
            int variablesSize = 0;
            while (variablesSize < 200) {
                ItemFormula itemFormula = null;
                if (index < itemFormulaList.size()) {
                    itemFormula = (ItemFormula)itemFormulaList.get(index);
                } else {
                    if (isFirtstSQL) break;
                    itemFormula = lastItemFormula;
                }
                if (addOr) {
                    sql.append("OR   ");
                } else {
                    addOr = true;
                }
                sql.append(" (  ItemDataEntry.FItemID = ?                            ");
                params.add(itemFormula.getItemNumber());
                if (sumType == MultiDynaSumTypeEnum.BYASSTACCOUNT) {
                    Map ditemMap = multiDynaItem.parseDItemNumber(itemFormula.getDItemNumber());
                    dynaMapList.add(ditemMap);
                    itemList.add(itemFormula);
                    for (int i2 = 0; i2 < asstActTypeCollection.size(); ++i2) {
                        AsstActTypeInfo asstActTypeInfo2 = asstActTypeCollection.get(i2);
                        String asstActTypeNumber = asstActTypeInfo2.getNumber();
                        String itemNumber = (String)ditemMap.get(asstActTypeNumber);
                        if (itemNumber == null) continue;
                        String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo2) ? ".FLongNumber" : ".FNumber";
                        sql.append(" and AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" = ? ");
                        params.add(itemNumber);
                    }
                }
                sql.append("    AND ItemDataEntry.FDataElement = ?        )          ");
                params.add(new Integer(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber())));
                ++index;
            }
            sql.append(")");
            if (valueType != 3) {
                sql.append("Group by rptitem.fdc,ItemDataEntry.FItemID , ItemDataEntry.FDataElement ");
                if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                    sql.append(" ,ItemData.FOrgUnitID");
                }
                for (int i3 = 0; i3 < asstActTypeCollection.size(); ++i3) {
                    AsstActTypeInfo asstActTypeInfo3 = asstActTypeCollection.get(i3);
                    String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo3) ? ".FLongNumber" : ".FNumber";
                    String name = ".FName_" + ctx.getLocale().getLanguage();
                    String asstActTypeNumber = asstActTypeInfo3.getNumber();
                    sql.append(",AsstActType").append(asstActTypeNumber).append(numberOrLongNumber);
                    sql.append(",AsstActType").append(asstActTypeNumber).append(name);
                }
            }
            if (addOr) {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                try {
                    if (!isCslOrSum) {
                        result = rowSet.size() == 0 && sumType == MultiDynaSumTypeEnum.BYASSTACCOUNT ? this.getNullMultiDynaResult(ctx, asstActTypeCollection, dynaMapList, itemList, valueType, result) : this.exportMultiDynaResult(asstActTypeCollection, sumType, dynaKeySet, valueType, result, rowSet);
                    } else {
                        Map debitMap = this.getDebitAndCredit(ctx, itemFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, "1", true);
                        Map creditMap = this.getDebitAndCredit(ctx, itemFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, "0", true);
                        result = this.exportMultiCslResult(asstActTypeCollection, sumType, dynaKeySet, valueType, result, rowSet, debitMap, creditMap);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            params.clear();
            sql.setLength(0);
            if (!isFirtstSQL) continue;
            isFirtstSQL = false;
        }
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            result.put("KEY_ALL_MULTIDYNAKEY", dynaKeySet);
        }
        return result;
    }

    private Map getNullMultiDynaResult(Context ctx, AsstActTypeCollection asstActTypeCollection, List dynaMapList, List itemList, int valueType, Map result) throws BOSException, EASBizException {
        HashMap asstMap = new HashMap();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            HashSet keySet = new HashSet();
            for (Map dyItemMap : dynaMapList) {
                keySet.add(dyItemMap.get(asstActTypeInfo.getNumber()));
            }
            asstMap.put(asstActTypeInfo.getNumber(), keySet);
        }
        HashMap asstNameMap = new HashMap();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            HashMap<String, String> nameMap = new HashMap<String, String>();
            asstNameMap.put(asstActTypeInfo.getNumber(), nameMap);
            Set keySet = (Set)asstMap.get(asstActTypeInfo.getNumber());
            StringBuffer sql = new StringBuffer();
            ArrayList params = new ArrayList();
            String numberField = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? "FLongNumber" : "FNumber";
            sql.append(" select FName_").append(ctx.getLocale().getLanguage()).append(" AsstName , ");
            sql.append(numberField).append(" AsstNumber from ");
            sql.append(asstActTypeInfo.getRealtionDataObject());
            sql.append(" where  ").append(numberField).append(" in ");
            sql.append(RptUtilForServer.createInSql(keySet.iterator(), params));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            try {
                while (rowSet.next()) {
                    nameMap.put(rowSet.getString("AsstNumber"), rowSet.getString("AsstName"));
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        for (Map dyItemMap : dynaMapList) {
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                if (i != 0) {
                    key.append(";");
                }
                AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
                String typeNumber = asstActTypeInfo.getNumber();
                Map nameMap = (Map)asstNameMap.get(typeNumber);
                String number = (String)dyItemMap.get(typeNumber);
                String name = (String)nameMap.get(number);
                key.append(typeNumber).append("|").append(number).append("@!@").append(name);
            }
            HashMap<String, Object> multiValueMap = (HashMap<String, Object>)result.get(key.toString());
            if (multiValueMap == null) {
                multiValueMap = new HashMap<String, Object>();
                result.put(key.toString(), multiValueMap);
            }
            for (ItemFormula itemFormula : itemList) {
                String itemNumber = itemFormula.getItemNumber() + "@!@" + DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()) + "@!@" + valueType;
                if (valueType == 3) {
                    multiValueMap.put(itemNumber, "");
                    continue;
                }
                multiValueMap.put(itemNumber, CslConstant.BGZERO);
            }
        }
        return result;
    }

    private Map exportMultiDynaResult(AsstActTypeCollection asstActTypeCollection, MultiDynaSumTypeEnum sumType, Set dynaKeySet, int valueType, Map result, IRowSet rowSet) throws SQLException {
        while (rowSet.next()) {
            HashMap<String, Object> multiValueMap;
            HashMap valueMap = null;
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                String orgUnitID = rowSet.getString("OrgUnitID");
                HashMap companyValueMap = (HashMap)result.get(orgUnitID);
                if (companyValueMap == null) {
                    companyValueMap = new HashMap();
                }
                result.put(orgUnitID, companyValueMap);
                valueMap = companyValueMap;
            } else {
                valueMap = result;
            }
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                if (i != 0) {
                    key.append(";");
                }
                AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
                String typeNumber = asstActTypeInfo.getNumber();
                String number = rowSet.getString("Number" + typeNumber);
                String name = rowSet.getString("Name" + typeNumber);
                key.append(typeNumber).append("|").append(number).append("@!@").append(name);
            }
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                dynaKeySet.add(key.toString());
            }
            if ((multiValueMap = (HashMap<String, Object>)valueMap.get(key.toString())) == null) {
                multiValueMap = new HashMap<String, Object>();
                valueMap.put(key.toString(), multiValueMap);
            }
            String itemNumber = rowSet.getString("ItemNumber") + "@!@" + rowSet.getInt("DataElement") + "@!@" + valueType;
            Object itemValue = multiValueMap.get(itemNumber);
            if (valueType == 3) {
                String textValue = rowSet.getString("Value");
                if (itemValue == null) {
                    multiValueMap.put(itemNumber, textValue);
                    continue;
                }
                multiValueMap.put(itemNumber, itemValue.toString() + textValue);
                continue;
            }
            BigDecimal numberValue = rowSet.getBigDecimal("Value");
            if (itemValue == null) {
                multiValueMap.put(itemNumber, numberValue);
                multiValueMap.put("dc" + itemNumber, rowSet.getString("dc"));
                continue;
            }
            multiValueMap.put(itemNumber, numberValue.add((BigDecimal)itemValue));
        }
        return result;
    }

    @Override
    protected Map _calculateMnsMultiRpt(Context ctx, String reportID, List companys, Map asstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany) throws BOSException, EASBizException {
        HashMap<String, Map> sumMap = new HashMap<String, Map>(4);
        Map msnMap = this.calculateMultiDynaSumRpt(ctx, reportID, companys, asstActTypeMap, positions, sumType, true);
        sumMap.put("individMap", msnMap);
        try {
            Map debitMap = this.getMultiDynaSumRpt(ctx, reportID, companys, asstActTypeMap, positions, sumType, isOnlyCompany, "1");
            sumMap.put("debitMap", debitMap);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        try {
            Map creditMap = this.getMultiDynaSumRpt(ctx, reportID, companys, asstActTypeMap, positions, sumType, isOnlyCompany, "0");
            sumMap.put("creditMap", creditMap);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sumMap;
    }

    private Map getDebitAndCredit(Context ctx, Map itemFormulaMap, AsstActTypeCollection asstActTypeCollection, List companyIDs, CslReportInfo reportInfo, String orgTreeID, MultiDynaSumTypeEnum sumType, String dc, boolean isMnsorCsl) throws BOSException, EASBizException {
        if (itemFormulaMap == null || itemFormulaMap.size() == 0) {
            return null;
        }
        if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
            return null;
        }
        if (companyIDs == null || companyIDs.size() == 0) {
            return null;
        }
        if (orgTreeID == null) {
            return null;
        }
        ArrayList itemFormulaList = new ArrayList(itemFormulaMap.values());
        HashSet dynaKeySet = null;
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            dynaKeySet = new HashSet();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean isFirtstSQL = true;
        ItemFormula lastItemFormula = (ItemFormula)itemFormulaList.get(itemFormulaList.size() - 1);
        int valueType = lastItemFormula.getValueType();
        Map<String, HashSet<Object>> result = new HashMap();
        MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
        int index = 0;
        while (index < itemFormulaList.size()) {
            AsstActTypeInfo asstActTypeInfo;
            int i;
            if (valueType == 3) {
                return null;
            }
            if (dc.equals("1")) {
                sql.append(" select dc='5',sum(ItemDataEntry.FValiDebit) Value  ");
            }
            if (dc.equals("0")) {
                sql.append(" select dc='5', sum(ItemDataEntry.FValiCredit) Value  ");
            }
            sql.append(" ,rptitem.fnumber  ItemNumber ");
            sql.append(" ,ItemDataEntry.FDataElement DataElement ");
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                if (isMnsorCsl) {
                    sql.append(" ,case when ItemDataEntry.fdebit = 0 and ItemDataEntry.fcredit = 0 and ItemDataEntry.fdirection=1 then ItemDataEntry.FtargetCompanyID else ItemDataEntry.FCompanyID end as OrgUnitID ");
                } else {
                    sql.append(" ,ItemDataEntry.FCompanyID OrgUnitID ");
                }
            }
            for (i = 0; i < asstActTypeCollection.size(); ++i) {
                asstActTypeInfo = asstActTypeCollection.get(i);
                String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                String name = ".FName_" + ctx.getLocale().getLanguage();
                String asstActTypeNumber = asstActTypeInfo.getNumber();
                sql.append(",AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" Number").append(asstActTypeNumber);
                sql.append(",AsstActType").append(asstActTypeNumber).append(name).append(" Name").append(asstActTypeNumber);
            }
            sql.append(" from T_CSL_MultiInterCheckage ItemData           ");
            sql.append(" inner join T_CSL_MultiInterCheckageEntry ItemDataEntry on ItemData.FID = ItemDataEntry.FCheckageID  ");
            sql.append(" inner join T_CSL_CslRptAssistantHG hg on hg.FID = ItemDataEntry.FCslAsstHGID   ");
            for (i = 0; i < asstActTypeCollection.size(); ++i) {
                asstActTypeInfo = asstActTypeCollection.get(i);
                sql.append(" left outer join ").append(asstActTypeInfo.getRealtionDataObject()).append(" AsstActType").append(asstActTypeInfo.getNumber());
                sql.append(" on hg.").append(asstActTypeInfo.getMappingFieldName()).append(" = AsstActType").append(asstActTypeInfo.getNumber()).append(".FID");
            }
            sql.append(" inner join t_csl_rptitem rptitem  on ItemDataEntry.FitemID=rptitem.fid ");
            sql.append(" where ");
            sql.append(" ItemData.FCurrencyID = ?    ");
            params.add(reportInfo.getCurrency().getId().toString());
            sql.append(" and ItemDataEntry.FCompanyID in ");
            sql.append(RptUtilForServer.createInSql(companyIDs.iterator(), params));
            sql.append(" and ItemDataEntry.FTargetCompanyID in ");
            sql.append(RptUtilForServer.createInSql(companyIDs.iterator(), params));
            sql.append(" and ItemData.FPeriodType = ? ");
            params.add(new Integer(reportInfo.getPeriodType().getValue()));
            sql.append(" and ItemData.FYear = ? ");
            params.add(new Integer(reportInfo.getYear()));
            sql.append(" and ItemData.FPeriod = ? ");
            params.add(new Integer(reportInfo.getPeriod()));
            sql.append(" and ItemData.FCheckedStatus = 2\t\t\t");
            sql.append(" and ( ");
            boolean addOr = false;
            ArrayList<Map> dynaMapList = new ArrayList<Map>();
            ArrayList<ItemFormula> itemList = new ArrayList<ItemFormula>();
            int variablesSize = 0;
            while (variablesSize < 200) {
                ItemFormula itemFormula = null;
                if (index < itemFormulaList.size()) {
                    itemFormula = (ItemFormula)itemFormulaList.get(index);
                } else {
                    if (isFirtstSQL) break;
                    itemFormula = lastItemFormula;
                }
                if (addOr) {
                    sql.append("OR   ");
                } else {
                    addOr = true;
                }
                sql.append(" (  ItemDataEntry.FItemID = (select fid from T_CSL_RptItem where fnumber= ? )                            ");
                params.add(itemFormula.getItemNumber());
                if (sumType == MultiDynaSumTypeEnum.BYASSTACCOUNT) {
                    Map ditemMap = multiDynaItem.parseDItemNumber(itemFormula.getDItemNumber());
                    dynaMapList.add(ditemMap);
                    itemList.add(itemFormula);
                    for (AsstActTypeInfo asstActTypeInfo2 : asstActTypeCollection) {
                        String asstActTypeNumber = asstActTypeInfo2.getNumber();
                        String itemNumber = (String)ditemMap.get(asstActTypeNumber);
                        if (itemNumber == null) continue;
                        String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo2) ? ".FLongNumber" : ".FNumber";
                        sql.append(" and AsstActType").append(asstActTypeNumber).append(numberOrLongNumber).append(" = ? ");
                        params.add(itemNumber);
                    }
                }
                sql.append("    AND ItemDataEntry.FDataElement = ?        )          ");
                params.add(new Integer(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber())));
                ++index;
            }
            sql.append(")");
            if (valueType != 3) {
                sql.append("Group by ItemDataEntry.FItemID , rptitem.fnumber , ItemDataEntry.FDataElement ");
                if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                    sql.append(" ,ItemDataEntry.FCompanyID");
                }
                for (int i2 = 0; i2 < asstActTypeCollection.size(); ++i2) {
                    AsstActTypeInfo asstActTypeInfo3 = asstActTypeCollection.get(i2);
                    String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo3) ? ".FLongNumber" : ".FNumber";
                    String name = ".FName_" + ctx.getLocale().getLanguage();
                    String asstActTypeNumber = asstActTypeInfo3.getNumber();
                    sql.append(",AsstActType").append(asstActTypeNumber).append(numberOrLongNumber);
                    sql.append(",AsstActType").append(asstActTypeNumber).append(name);
                }
            }
            sql.append(",ItemDataEntry.fdirection,ItemDataEntry.FtargetCompanyID ");
            sql.append("  ,ItemDataEntry.fdebit , ItemDataEntry.fcredit ");
            if (addOr) {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                try {
                    result = rowSet.size() == 0 && sumType == MultiDynaSumTypeEnum.BYASSTACCOUNT ? (isMnsorCsl ? this.getNullMultiDynaResult(ctx, asstActTypeCollection, dynaMapList, itemList, valueType, result) : null) : this.exportMultiDynaResult(asstActTypeCollection, sumType, dynaKeySet, valueType, result, rowSet);
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            params.clear();
            sql.setLength(0);
            if (!isFirtstSQL) continue;
            isFirtstSQL = false;
        }
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            result.put("KEY_ALL_MULTIDYNAKEY", dynaKeySet);
        }
        return result;
    }

    protected Map getMultiDynaSumRpt(Context ctx, String reportID, List companys, Map assstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany, String dc) throws BOSException, EASBizException, SQLException {
        String orgTreeid;
        String oql;
        if (reportID == null || companys == null || companys.size() == 0 || positions == null || positions.size() == 0) {
            return null;
        }
        ICslReport icr = CslReportFactory.getLocalInstance(ctx);
        CslReportCollection reportCol = icr.getCslReportCollection(oql = "select id, year, period, periodType, SourceType, currency.id, currency.precision, OrgTree.id, OrgUnit.id,company.id where id = '" + reportID + "'");
        if (reportCol.size() != 1) {
            return null;
        }
        CslReportInfo report = reportCol.get(0);
        PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(ctx, report);
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        int year = report.getYear();
        short period = report.getPeriod();
        int periodType = report.getPeriodType().getValue();
        String string = orgTreeid = report.getOrgTree() != null ? report.getOrgTree().getId().toString() : null;
        if (orgTreeid == null) {
            Date date = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)periodType), isMergeByFiscalPeriod);
            orgTreeid = CslRptUtil.getBasicTree(ctx, date);
        }
        if (isOnlyCompany) {
            companys = this.expandCompanys(ctx, orgTreeid, companys);
        }
        HashMap result = new HashMap();
        Iterator iter = positions.keySet().iterator();
        while (iter.hasNext()) {
            long time1 = System.currentTimeMillis();
            String sheetID = (String)iter.next();
            Map sheetMap = (Map)positions.get(sheetID);
            HashMap resultSheet = new HashMap();
            result.put(sheetID, resultSheet);
            for (Point basePoint : sheetMap.keySet()) {
                Map areaMap = (Map)sheetMap.get(basePoint);
                Map formulasMap = (Map)areaMap.get("formulas");
                AsstActTypeCollection asstActTypeCollection = (AsstActTypeCollection)assstActTypeMap.get(sheetID + "|" + basePoint.x + "|" + basePoint.y);
                if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
                    throw new DynamicEnumException(DynamicEnumException.AT_LEAST_ONE_ASST);
                }
                asstActTypeCollection = this.sortAsstActTypeCollection(asstActTypeCollection);
                Map valueMap = this.getMnsMultiValue(ctx, formulasMap, asstActTypeCollection, companys, report, orgTreeid, sumType, dc);
                resultSheet.put(basePoint, valueMap);
                resultSheet.put("asstActTypeCollection", asstActTypeCollection);
            }
            logger.info((Object)("sheet" + sheetID + ":" + (System.currentTimeMillis() - time1) + "ms"));
        }
        return result;
    }

    private Map getMnsMultiValue(Context ctx, Map itemFormulaMap, AsstActTypeCollection asstActTypeCollection, List companyIDs, CslReportInfo reportInfo, String orgTreeID, MultiDynaSumTypeEnum sumType, String dc) throws EASBizException, BOSException {
        HashMap numberFormulaMap = new HashMap();
        HashMap textFormulaMap = new HashMap();
        HashMap quantityFormulaMap = new HashMap();
        for (Map.Entry entry : itemFormulaMap.entrySet()) {
            ItemFormula itemFormula = (ItemFormula)entry.getValue();
            if (itemFormula.getValueType() == 3) {
                textFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() == 1) {
                numberFormulaMap.put(entry.getKey(), itemFormula);
                continue;
            }
            if (itemFormula.getValueType() != 2) continue;
            quantityFormulaMap.put(entry.getKey(), itemFormula);
        }
        Map amountMap = this.getDebitAndCredit(ctx, numberFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, dc, true);
        Map textMap = this.getDebitAndCredit(ctx, numberFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, dc, true);
        Map quantityMap = this.getDebitAndCredit(ctx, numberFormulaMap, asstActTypeCollection, companyIDs, reportInfo, orgTreeID, sumType, dc, true);
        Map numerMap = this.mergeMultiDynaResultMap(sumType, amountMap, textMap);
        Map result = this.mergeMultiDynaResultMap(sumType, numerMap, quantityMap);
        return result;
    }

    @Override
    protected Map _calculateDynaCslRpt(Context ctx, String reportID, List companys, Map asstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany) throws BOSException {
        try {
            return this.calculateMutiSumAndCslRptNew(ctx, reportID, companys, asstActTypeMap, positions, sumType, isOnlyCompany, false);
        }
        catch (DynamicEnumException e) {
            logger.error((Object)"_calculateDynaCslRpt error", (Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            logger.error((Object)"_calculateDynaCslRpt error", (Throwable)e);
            return null;
        }
    }

    private Map exportMultiCslResult(AsstActTypeCollection asstActTypeCollection, MultiDynaSumTypeEnum sumType, Set dynaKeySet, int valueType, Map result, IRowSet rowSet, Map debitMap, Map creditMap) throws SQLException {
        while (rowSet.next()) {
            HashMap<String, Object> multiValueMap;
            HashMap valueMap = null;
            Map debitMap1 = null;
            Map debitMap2 = null;
            Map creditMap1 = null;
            Map creditMap2 = null;
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                String orgUnitID = rowSet.getString("OrgUnitID");
                HashMap companyValueMap = (HashMap)result.get(orgUnitID);
                if (debitMap != null) {
                    debitMap1 = (Map)debitMap.get(orgUnitID);
                }
                if (creditMap != null) {
                    creditMap1 = (Map)creditMap.get(orgUnitID);
                }
                if (companyValueMap == null) {
                    companyValueMap = new HashMap();
                }
                result.put(orgUnitID, companyValueMap);
                valueMap = companyValueMap;
            } else {
                valueMap = result;
            }
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                if (i != 0) {
                    key.append(";");
                }
                AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
                String typeNumber = asstActTypeInfo.getNumber();
                String number = rowSet.getString("Number" + typeNumber);
                String name = rowSet.getString("Name" + typeNumber);
                key.append(typeNumber).append("|").append(number).append("@!@").append(name);
            }
            if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT && dynaKeySet != null) {
                dynaKeySet.add(key.toString());
            }
            if (debitMap1 != null) {
                debitMap2 = (Map)debitMap1.get(key.toString());
            }
            if (creditMap1 != null) {
                creditMap2 = (Map)creditMap1.get(key.toString());
            }
            if ((multiValueMap = (HashMap<String, Object>)valueMap.get(key.toString())) == null) {
                multiValueMap = new HashMap<String, Object>();
                valueMap.put(key.toString(), multiValueMap);
            }
            String itemNumber = rowSet.getString("ItemNumber") + "@!@" + rowSet.getInt("DataElement") + "@!@" + valueType;
            Object itemValue = multiValueMap.get(itemNumber);
            if (valueType == 3) {
                String textValue = rowSet.getString("Value");
                if (itemValue == null) {
                    multiValueMap.put(itemNumber, textValue);
                    continue;
                }
                multiValueMap.put(itemNumber, itemValue.toString() + textValue);
                continue;
            }
            BigDecimal numberValue = rowSet.getBigDecimal("Value");
            BigDecimal endValue = new BigDecimal(0);
            BigDecimal debitValue = new BigDecimal(0);
            BigDecimal creditValue = new BigDecimal(0);
            if (debitMap2 != null && debitMap2.get(itemNumber) != null) {
                debitValue = (BigDecimal)debitMap2.get(itemNumber);
            }
            if (creditMap2 != null && creditMap2.get(itemNumber) != null) {
                creditValue = (BigDecimal)creditMap2.get(itemNumber);
            }
            if (itemValue == null) {
                if (rowSet.getString("dc").equals("1")) {
                    endValue = numberValue.add(debitValue).subtract(creditValue);
                } else if (rowSet.getString("dc").equals("0")) {
                    endValue = numberValue.subtract(debitValue).add(creditValue);
                }
                multiValueMap.put(itemNumber, endValue);
                multiValueMap.put("dc" + itemNumber, rowSet.getString("dc"));
                continue;
            }
            multiValueMap.put(itemNumber, numberValue.add((BigDecimal)itemValue));
        }
        this.addAjustDatas(sumType, result, debitMap, creditMap);
        return result;
    }

    private void addAjustDatas(MultiDynaSumTypeEnum sumType, Map result, Map debitMap, Map creditMap) {
        if (sumType == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            Map valMap;
            if (debitMap != null) {
                for (String orgUnitID : debitMap.keySet()) {
                    if ("KEY_ALL_MULTIDYNAKEY".equals(orgUnitID)) continue;
                    Map debMap = (Map)debitMap.get(orgUnitID);
                    valMap = (HashMap)result.get(orgUnitID);
                    if (valMap == null) {
                        valMap = new HashMap();
                        result.put(orgUnitID, valMap);
                    }
                    this.addAjustData(debMap, valMap, true);
                }
            }
            if (creditMap != null) {
                for (String orgUnitID : creditMap.keySet()) {
                    if ("KEY_ALL_MULTIDYNAKEY".equals(orgUnitID)) continue;
                    Map creMap = (Map)creditMap.get(orgUnitID);
                    valMap = (Map)result.get(orgUnitID);
                    if (valMap == null) {
                        valMap = new HashMap();
                        result.put(orgUnitID, valMap);
                    }
                    this.addAjustData(creMap, valMap, false);
                }
            }
        } else {
            this.addAjustData(debitMap, result, true);
            this.addAjustData(creditMap, result, false);
        }
    }

    private void addAjustData(Map adjustMap, Map valMap, boolean dc) {
        if (adjustMap == null || valMap == null) {
            return;
        }
        for (String asstKey : adjustMap.keySet()) {
            Map ajust1Map = (Map)adjustMap.get(asstKey);
            HashMap<String, BigDecimal> val1Map = (HashMap<String, BigDecimal>)valMap.get(asstKey);
            if (val1Map == null) {
                val1Map = new HashMap<String, BigDecimal>();
                valMap.put(asstKey, val1Map);
            }
            for (String itemKey : ajust1Map.keySet()) {
                if (val1Map.containsKey(itemKey)) continue;
                Object v = ajust1Map.get(itemKey);
                if (v instanceof BigDecimal) {
                    BigDecimal val = (BigDecimal)ajust1Map.get(itemKey);
                    if (CslConstant.BGZERO.compareTo(val) == 0) continue;
                    if (dc) {
                        val1Map.put(itemKey, val);
                        continue;
                    }
                    val1Map.put(itemKey, val);
                    continue;
                }
                if (v instanceof String) {
                    String str = ajust1Map.get(itemKey).toString();
                    if (str.equals("")) continue;
                    BigDecimal val = new BigDecimal(str);
                    if (dc) {
                        val1Map.put(itemKey, val);
                        continue;
                    }
                    val1Map.put(itemKey, val);
                    continue;
                }
                logger.info((Object)"error type! need to fix!");
            }
        }
    }

    @Override
    protected Map _calculateDynaCslRpt(Context ctx, DynaCslRptParamInfo dynaCslRptParamInfo, Map positions, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        return DynaRptCalcServerHelper._calculateDynaCslRpt(ctx, dynaCslRptParamInfo, positions, doOffset, includeDiffTable);
    }

    @Override
    protected Map _calculateMultiDynaElimCslRpt(Context ctx, String reportID, List companys, Map asstActTypeMap, Map positions, MultiDynaSumTypeEnum sumType, boolean isOnlyCompany) throws BOSException, EASBizException {
        try {
            return this.calculateMutiSumAndCslRptNew(ctx, reportID, companys, asstActTypeMap, positions, sumType, isOnlyCompany, true);
        }
        catch (DynamicEnumException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    class MyDItemGradeEntryInfo
    extends DItemGradeEntryInfo {
        Object value;
        String D_number;
        String D_Name;

        public MyDItemGradeEntryInfo() {
            this.value = CslConstant.BGZERO;
        }

        public MyDItemGradeEntryInfo(String g) {
            super(g);
            this.value = CslConstant.BGZERO;
        }
    }
}

