/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AbstractCaliAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CaliAdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.CaliAdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.CaliAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.CaliAdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.CaliAdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICaliAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCaliAdjustControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CaliAdjustControllerBean
extends AbstractCaliAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CaliAdjustControllerBean");
    private boolean hasCodeRule = false;

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new CaliAdjustInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BOSObjectType bosType = new RptReceivedInfo().getBOSType();
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_RptReceived                      \n");
        sql.append(" (FID, FReportID, FOrgTreeID, FCreatorID, FCreateTime)");
        sql.append(" VALUES                                             \n");
        sql.append(" ( ");
        sql.append("'" + BOSUuid.create((BOSObjectType)bosType).toString() + "'").append(",");
        sql.append("'" + pk.toString()).append("',");
        sql.append("'" + ((CaliAdjustInfo)model).getOrgBound().getId().toString() + "'").append(",");
        sql.append("'" + userID + "'").append(", getdate());");
        StringBuffer querySql = new StringBuffer();
        querySql.append("select t1.Fyear,t1.fperiod,t1.fvaluetype,t1.fdate").append("\r\n");
        querySql.append(",t2.fdataelement,t3.FNumber as FItemNumber").append("\r\n");
        querySql.append(",(isnull(sum(t2.fdebit),0)-isnull(sum(t2.fcredit),0))*(2*t3.FDC-1) as FValue").append("\r\n");
        querySql.append("from T_CSL_CaliAdjust t1").append("\r\n");
        querySql.append("inner join T_CSL_CaliAdjustEntry t2").append("\r\n");
        querySql.append("on t1.fid = t2.fAdjustId").append("\r\n");
        querySql.append("inner join T_CSL_RptItem t3").append("\r\n");
        querySql.append("on t3.fid = t2.fitemid").append("\r\n");
        querySql.append("where t1.FID='").append(pk.toString()).append("'").append("\r\n");
        querySql.append("group by t1.fid,t1.Fyear,t1.fperiod,t1.fvaluetype").append("\r\n");
        querySql.append(",t1.fdate,t1.FDataCollectNumber,t2.fdataelement,t3.fdc,t3.FNumber").append("\r\n");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            IItemDataProvider itemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
            HashMap views = new HashMap();
            BigDecimal adjustValue = null;
            while (rs.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rs.getInt("FDataElement") + ",").append(rs.getInt("FValueType") + ",").append(rs.getInt("FYear") + ",").append(rs.getInt("FPeriod") + ",").append(rs.getDate("FDate") + ",");
                adjustValue = rs.getBigDecimal("FValue");
                Object value = views.get(key.toString());
                if (value != null && value instanceof HashMap) {
                    ((HashMap)value).put(rs.getString("FItemNumber"), adjustValue);
                    continue;
                }
                value = new HashMap();
                ((HashMap)value).put(rs.getString("FItemNumber"), adjustValue);
                views.put(key.toString(), value);
            }
            itemDataProvider.saveItemData(pk.toString(), views, null, null, null, 11);
            itemDataProvider.updateAuditedItemData(pk.toString(), true);
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        super._passAudit(ctx, pk, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_CSL_RptReceived WHERE FReportID = '").append(pk.toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        IItemDataProvider itemDataProvider = ItemDataProviderFactory.getLocalInstance(ctx);
        if (itemDataProvider != null) {
            itemDataProvider.clearItemData(pk.toString());
            itemDataProvider.updateAuditedItemData(pk.toString(), true);
        }
        super._unpassAudit(ctx, pk, model);
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.CORPORATIONMANAGEMENT;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (CaliAdjustInfo)model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    private void addnewCheck(Context ctx, CaliAdjustInfo model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)model.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(model);
            }
        }
        this._checkNumberDup(ctx, null, (IObjectValue)model);
        this.checkRptItemBlankAndDup(ctx, (IObjectValue)model);
        this.checkDebitAndCredit((IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.initCodeRule(ctx);
            if (!this.hasCodeRule) {
                this.checkNumberBlank(info);
            }
        }
        this._checkNumberDup(ctx, null, model);
        this.checkRptItemBlankAndDup(ctx, model);
        this.checkDebitAndCredit(model);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CaliAdjustInfo info = this.getCaliAdjustInfo(ctx, pk);
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy();
        AssignmentInfo[] assignments = iEnactmentService.checkAssignmentInfos(info.getId().toString(), ctx.getCaller().toString());
        boolean isInWorkflow = false;
        isInWorkflow = assignments != null && assignments.length != 0;
        if (isInWorkflow) {
            throw new AdjustException(AdjustException.NOT_DELETE_INWF);
        }
    }

    private void checkRptItemBlankAndDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        CaliAdjustEntryCollection adjustEntries = info.getEntries();
        if (adjustEntries == null) {
            return;
        }
        this.fixRptItemNumber(ctx, info);
        ArrayList<String> list = new ArrayList<String>(adjustEntries.size());
        RPTItemInfo rptItem = null;
        CaliAdjustEntryInfo adjustEntryInfo = null;
        String keyAdjust = "GR_CSL_AllowAdjustRRTM";
        Object value = CslRptUtil.getParamValue(ctx, null, keyAdjust);
        for (int i = 0; i < adjustEntries.size(); ++i) {
            adjustEntryInfo = adjustEntries.get(i);
            rptItem = adjustEntryInfo.getItem();
            if (rptItem.getId() == null || StringUtils.isEmpty((String)rptItem.getId().toString())) {
                throw new AdjustException(AdjustException.RPTITEM_BLANK);
            }
            if (!"false".equals(value) || !adjustEntryInfo.isIsVisible()) continue;
            String key = adjustEntryInfo.getItem().getNumber();
            if (list.contains(key = key + "," + adjustEntryInfo.getDataElement())) {
                ArrayList<Object> exParam = new ArrayList<Object>(3);
                exParam.add(new Integer(i + 1));
                exParam.add(rptItem.getNumber());
                exParam.add(DataElementProvider.getDataElementName(ctx, adjustEntryInfo.getDataElement()));
                throw new AdjustException(AdjustException.RPTITEMDATAELEMENT_DUP, exParam.toArray());
            }
            list.add(key);
        }
    }

    private void checkDebitAndCredit(IObjectValue model) throws EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            CaliAdjustEntryCollection entry = info.getEntries();
            for (int i = 0; i < entry.size(); ++i) {
                CaliAdjustEntryInfo lineInfo = entry.get(i);
                BigDecimal bgDebit = lineInfo.getDebit();
                BigDecimal bgCredit = lineInfo.getCredit();
                if (bgDebit != null && bgCredit != null) {
                    throw new AdjustException(AdjustException.DC_ALL_HAVE);
                }
                if (bgDebit == null && bgCredit == null) {
                    throw new AdjustException(AdjustException.DC_ALL_HAVE);
                }
                if (bgDebit != null && bgDebit.compareTo(CslConstant.BGZERO) == 0) {
                    throw new AdjustException(AdjustException.NOT_INPUT_ZERO);
                }
                if (bgCredit == null || bgCredit.compareTo(CslConstant.BGZERO) != 0) continue;
                throw new AdjustException(AdjustException.NOT_INPUT_ZERO);
            }
        }
    }

    @Override
    protected void _audit(Context ctx, List list) throws BOSException, EASBizException {
        for (IObjectPK pk : list) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("entries.*"));
            sc.add(new SelectorItemInfo("entries.item.*"));
            CaliAdjustInfo info = this.getCaliAdjustInfo(ctx, pk, sc);
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) continue;
            info.setAuditor(user);
            info.setAuditDate(new Timestamp(System.currentTimeMillis()));
            this._passAudit(ctx, pk, (IObjectValue)info);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue adjustInfo, IObjectPK userPK) throws EASBizException, BOSException {
        CaliAdjustInfo info = (CaliAdjustInfo)adjustInfo;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("entries.*"));
        sc.add(new SelectorItemInfo("entries.item.*"));
        info = (CaliAdjustInfo)CaliAdjustFactory.getLocalInstance(ctx).getBillBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), sc);
        IUser ie = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ie.getValue(userPK);
        if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new AdjustException(AdjustException.ALL_HAVE_AUDITED);
        }
        info.setAuditor(user);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        this._passAudit(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unAudit(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        while (iter.hasNext()) {
            IObjectPK pk = (IObjectPK)iter.next();
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("entries.*"));
            sc.add(new SelectorItemInfo("entries.item.*"));
            CaliAdjustInfo info = (CaliAdjustInfo)CaliAdjustFactory.getLocalInstance(ctx).getBillBaseInfo(pk, sc);
            if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) continue;
            if (info.getArchivedStatus() == ArchivedStatusEnum.ARCHIVED) {
                throw new AdjustException(AdjustException.HAVE_ARCHIVED);
            }
            if (!info.getAuditor().getId().equals((Object)user.getId()) && CslRptUtil.canUnAuditCheck(ctx)) {
                throw new AdjustException(AdjustException.SAME_AUDITOR);
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            this._unpassAudit(ctx, pk, (IObjectValue)info);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue adjustInfo, IObjectPK userPK) throws BOSException, EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)adjustInfo;
        IUser ie = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ie.getValue(userPK);
        if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new AdjustException(AdjustException.ALL_HAVE_NOT_AUDIT);
        }
        if (info.getArchivedStatus() == ArchivedStatusEnum.ARCHIVED) {
            throw new AdjustException(AdjustException.HAVE_ARCHIVED);
        }
        if (!info.getAuditor().getId().equals((Object)user.getId())) {
            throw new AdjustException(AdjustException.SAME_AUDITOR);
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        this._unpassAudit(ctx, pk, (IObjectValue)info);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)info.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        FilterItemInfo filterItem1 = new FilterItemInfo("orgBound.id", (Object)info.getOrgBound().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("periodType", (Object)new Integer(info.getPeriodType().getValue()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = new FilterItemInfo("year", (Object)new Integer(info.getYear()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        FilterItemInfo filterItem4 = new FilterItemInfo("period", (Object)new Integer(info.getPeriod()), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem4);
        FilterItemInfo filterItem5 = new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem5);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6");
        } else {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
        }
        boolean exist = this.exists(ctx, filter);
        if (exist) {
            throw new AdjustException(AdjustException.ADJUSTNUMBER_DUP, new Object[]{info.getNumber()});
        }
        return true;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
            boolean isHasCodingRuleByOrg = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID);
            if (strOrgID != null && isHasCodingRuleByOrg) {
                String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, strOrgID);
                info.setNumber(number);
            }
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        boolean isHasCodingRuleByOrg = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)info, strOrgID);
        ICodingRuleManager codingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strOrgID != null && isHasCodingRuleByOrg) {
            IFullOrgUnit IFullOrgUnit2 = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            String fullOrgUnitID = info.getOrgUnit().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = IFullOrgUnit2.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitID));
            String fullOrgUnitCuID = fullOrgUnitInfo.getCU().getId().toString();
            CtrlUnitInfo cuInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitCuID));
            fullOrgUnitInfo.setCU(cuInfo);
            info.setOrgUnit(fullOrgUnitInfo);
            if (StringUtils.isEmpty((String)info.getNumber())) {
                String number = codingRule.getNumber((IObjectValue)info, strOrgID);
                info.setNumber(number);
            } else if (codingRule.isModifiable((IObjectValue)info, strOrgID) && !codingRule.checkModifiedNumber((IObjectValue)info, strOrgID, info.getNumber())) {
                throw new AdjustException(AdjustException.CODERULECONFLICTION, new Object[]{info.getNumber()});
            }
        }
        this.removeHideEntries((CaliAdjustInfo)model);
        this.autoAdjustParentItems(ctx, (CaliAdjustInfo)model);
        this.doSpecialRptItem(ctx, model);
        return super._submit(ctx, (IObjectValue)info);
    }

    private void removeHideEntries(CaliAdjustInfo model) {
        CaliAdjustEntryCollection entries = model.getEntries();
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (int i = entries.size() - 1; i >= 0; --i) {
            if (entries.get(i).isIsVisible()) continue;
            entries.removeObject(i);
        }
    }

    private Map getParentRptItems(Context ctx, CaliAdjustInfo adjust) throws BOSException {
        HashMap<String, RPTItemInfo> parentItems = new HashMap<String, RPTItemInfo>();
        ArrayList<String> numbers = new ArrayList<String>();
        CaliAdjustEntryCollection entries = adjust.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            CaliAdjustEntryInfo adjustEntry = (CaliAdjustEntryInfo)iter.next();
            String number = adjustEntry.getItem().getNumber();
            int end = number.length();
            while ((end = number.lastIndexOf(46, end)) > 0) {
                String num = number.substring(0, end);
                if (!numbers.contains(num)) {
                    numbers.add(num);
                }
                --end;
            }
        }
        if (!numbers.isEmpty()) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FisFreezed=0").append("\r\n");
            querySql.append("and FNumber in('").append(numbers.get(0)).append("'");
            for (int i = 1; i < numbers.size(); ++i) {
                querySql.append(",'").append(numbers.get(i)).append("'");
            }
            querySql.append(")\r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    RPTItemInfo rptItemInfo = new RPTItemInfo();
                    rptItemInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                    rptItemInfo.setNumber(rowSet.getString(2));
                    parentItems.put(rptItemInfo.getNumber(), rptItemInfo);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return parentItems;
    }

    private Map fixRptItemNumber(Context ctx, CaliAdjustInfo adjustInfo) throws BOSException {
        RPTItemInfo item;
        CaliAdjustEntryCollection entries = adjustInfo.getEntries();
        HashMap<String, String> idAndNumber = new HashMap<String, String>(entries.size());
        StringBuffer ids = new StringBuffer();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            item = ((CaliAdjustEntryInfo)iter.next()).getItem();
            if (!StringUtils.isEmpty((String)item.getNumber())) continue;
            String id = item.getId().toString();
            if (ids.length() == 0) {
                ids.append("'").append(id).append("'");
                continue;
            }
            ids.append(",'").append(id).append("'");
        }
        if (ids.length() > 0) {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select FID,FNumber from t_csl_RptItem").append("\r\n");
            querySql.append("where FID in(").append(ids.toString()).append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                while (rowSet.next()) {
                    idAndNumber.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!idAndNumber.isEmpty()) {
            iter = entries.iterator();
            while (iter.hasNext()) {
                item = ((CaliAdjustEntryInfo)iter.next()).getItem();
                if (!StringUtils.isEmpty((String)item.getNumber())) continue;
                item.setNumber((String)idAndNumber.get(item.getId().toString()));
            }
        }
        return idAndNumber;
    }

    private void autoAdjustParentItems(Context ctx, CaliAdjustInfo model) throws BOSException {
        CaliAdjustEntryCollection entries = model.getEntries();
        this.fixRptItemNumber(ctx, model);
        Map parentItems = this.getParentRptItems(ctx, model);
        HashMap<String, CaliAdjustEntryInfo> autoAdjustData = new HashMap<String, CaliAdjustEntryInfo>();
        int maxSeq = entries.size() + 1;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            CaliAdjustEntryInfo entryInfo = (CaliAdjustEntryInfo)iter.next();
            if (maxSeq < entryInfo.getSeq()) {
                ++maxSeq;
            }
            String number = entryInfo.getItem().getNumber();
            List parentNumbers = this.getParentNumbers(number);
            for (int index = 0; parentNumbers != null && index < parentNumbers.size(); ++index) {
                String pnumber = (String)parentNumbers.get(index);
                String key = pnumber + ", " + entryInfo.getDataElement();
                CaliAdjustEntryInfo entry = (CaliAdjustEntryInfo)autoAdjustData.get(key);
                if (entry == null) {
                    entry = new CaliAdjustEntryInfo();
                    entry.setAdjust(entryInfo.getAdjust());
                    entry.setItem((RPTItemInfo)parentItems.get(pnumber));
                    entry.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"94_AdjustControllerBean", (Locale)ctx.getOriginLocale()));
                    entry.setDataElement(entryInfo.getDataElement());
                    entry.setIsVisible(false);
                    autoAdjustData.put(key, entry);
                } else if (entry.getSummary().lastIndexOf(42) == -1) {
                    entry.setSummary(entry.getSummary() + " *");
                }
                if (entryInfo.getDebit() != null) {
                    if (entry.getDebit() == null) {
                        entry.setDebit(entryInfo.getDebit());
                        continue;
                    }
                    entry.setDebit(entry.getDebit().add(entryInfo.getDebit()));
                    continue;
                }
                if (entry.getCredit() == null) {
                    entry.setCredit(entryInfo.getCredit());
                    continue;
                }
                entry.setCredit(entry.getCredit().add(entryInfo.getCredit()));
            }
        }
        for (Map.Entry entry : autoAdjustData.entrySet()) {
            CaliAdjustEntryInfo adjustEntry = (CaliAdjustEntryInfo)entry.getValue();
            adjustEntry.setSeq(maxSeq++);
            if (adjustEntry.getDebit() != null && adjustEntry.getCredit() != null) {
                if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) > 0) {
                    adjustEntry.setDebit(adjustEntry.getDebit().subtract(adjustEntry.getCredit()));
                    adjustEntry.setCredit(null);
                } else {
                    if (adjustEntry.getDebit().compareTo(adjustEntry.getCredit()) >= 0) continue;
                    adjustEntry.setCredit(adjustEntry.getCredit().subtract(adjustEntry.getDebit()));
                    adjustEntry.setDebit(null);
                }
            }
            entries.add((CaliAdjustEntryInfo)entry.getValue());
        }
        parentItems.clear();
        parentItems = null;
        autoAdjustData.clear();
        autoAdjustData = null;
    }

    private List getParentNumbers(String number) {
        if (number.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            numbers.add(number.substring(0, end));
            --end;
        }
        return numbers;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CaliAdjustInfo info = this.getCaliAdjustInfo(ctx, pk, this.getSelectors());
        this.deleteCheck(ctx, pk);
        this.initCodeRule(ctx);
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isUseIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, strOrgID);
        if (this.hasCodeRule && strOrgID != null && isUseIntermitNumber) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, strOrgID, info.getNumber());
        }
        ArrayList<String> delIds = new ArrayList<String>();
        Iterator iter = info.getEntries().iterator();
        while (iter.hasNext()) {
            CaliAdjustEntryInfo element = (CaliAdjustEntryInfo)iter.next();
            if (element.getId() == null) continue;
            delIds.add(element.getId().toString());
        }
        if (!delIds.isEmpty()) {
            AdjustDynamicItemFactory.getLocalInstance(ctx).deleteDynamicAdjustItems(delIds);
        }
        super._delete(ctx, pk);
        this.deleteElimRelaOrgTree(ctx, info);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.debit"));
        sic.add(new SelectorItemInfo("entries.credit"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.item.name"));
        sic.add(new SelectorItemInfo("adjustMode"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entries.item.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("archivedStatus"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgBound.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        return sic;
    }

    private void checkNumberBlank(CaliAdjustInfo info) throws EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new AdjustException(AdjustException.NUMBER_CANNOT_BLANK);
        }
    }

    @Override
    protected void _submitWF(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected IObjectCollection _getAdjustRecord(Context ctx, int period, int year, int periodType, String treeId, String orgUnitId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + treeId + "' and s1.funitid = '" + orgUnitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer bf = new StringBuffer("");
        try {
            while (rs.next()) {
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        sql = new StringBuffer();
        String numberStr = "";
        if (CSLPermissionUtil.hasDataCollectPermissionAndParam(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), DataCollectConstant.getActualDC())) {
            numberStr = numberStr + "'" + "ACTUALDATA" + "'";
        }
        if (CSLPermissionUtil.hasDataCollectPermissionAndParam(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), DataCollectConstant.getBudgetDC())) {
            if (numberStr != null && numberStr.length() != 0) {
                numberStr = numberStr + ",";
            }
            numberStr = "'BUDGETDATA'";
        }
        numberStr = "(" + numberStr.trim() + ")";
        sql.append(" select fid from t_org_tree where fisbasic = 1 and ftype= 8 and fstartdate < Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "' and (fenddate is null or fenddate > Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "')");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgTreeId = null;
        try {
            if (rs.next()) {
                orgTreeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (orgTreeId == null) {
            return null;
        }
        CaliAdjustCollection list = null;
        ICaliAdjust iAdjust = CaliAdjustFactory.getLocalInstance(ctx);
        String oql = "SELECT id,number,adjustMode.name,year,period,orgUnit.name,sourceCurrency.name,currency.name,orgBound.id, dataCollectNumber, dataCollect.name,isFixed   WHERE year = " + year + " AND period = " + period + "  AND periodType = " + periodType + " and dataCollectNumber in " + numberStr + "  AND orgBound.id  = '" + orgTreeId + "' AND orgUnit.id in (" + bf.toString() + ") ORDER BY orgUnit.id ";
        list = iAdjust.getCaliAdjustCollection(oql);
        return list;
    }

    @Override
    protected IObjectCollection _getAdjustRecord(Context ctx, int period, int year, int periodType, String treeId, String orgUnitId, String dataCollectNumber) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + treeId + "' and s1.funitid = '" + orgUnitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer bf = new StringBuffer("");
        try {
            while (rs.next()) {
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        sql = new StringBuffer();
        sql.append(" select fid from t_org_tree where fisbasic = 1 and ftype= 8 and fstartdate < Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "' and (fenddate is null or fenddate > Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "')");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgTreeId = null;
        try {
            if (rs.next()) {
                orgTreeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (orgTreeId == null) {
            return null;
        }
        CaliAdjustCollection list = null;
        ICaliAdjust iAdjust = CaliAdjustFactory.getLocalInstance(ctx);
        String oql = "SELECT id,number,adjustMode.name,year,period,orgUnit.name,sourceCurrency.name,currency.name,orgBound.id WHERE year = " + year + " AND period = " + period;
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            oql = oql + "  and dataCollectNumber = '" + dataCollectNumber + "' ";
        }
        oql = oql + " AND periodType = " + periodType + "  AND orgBound.id  = '" + orgTreeId + "' AND orgUnit.id in (" + bf.toString() + ") ORDER BY orgUnit.id ";
        list = iAdjust.getCaliAdjustCollection(oql);
        return list;
    }

    @Override
    protected void _doImportAdjustRecords(Context ctx, List listId) throws BOSException, EASBizException {
        ICaliAdjust iAdjust = CaliAdjustFactory.getLocalInstance(ctx);
        CaliAdjustInfo info = null;
        String adjustId = null;
        if (listId != null && listId.size() > 0) {
            for (int i = 0; i < listId.size(); ++i) {
                adjustId = (String)listId.get(i);
                info = iAdjust.getCaliAdjustInfo((IObjectPK)new ObjectUuidPK(adjustId));
            }
        }
    }

    private void doSpecialRptItem(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CaliAdjustInfo info = (CaliAdjustInfo)model;
        CaliAdjustEntryCollection entry = info.getEntries();
        int entrySize = 0;
        if (entry != null) {
            entrySize = entry.size();
        }
        CaliAdjustEntryInfo lineInfo = null;
        ArrayList<CaliAdjustEntryInfo> list = new ArrayList<CaliAdjustEntryInfo>();
        if (entry != null && entrySize > 0) {
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                if (lineInfo.getItem() == null || lineInfo.getItem().getControl() != RPTItemControlEnum.UNSHARED_PROFIT || lineInfo.isIsVisible()) continue;
                list.add(lineInfo);
            }
        }
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            info.getEntries().removeObject((IObjectValue)((CaliAdjustEntryInfo)list.get(j)));
        }
        if (info.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        entry = info.getEntries();
        if (entry != null) {
            entrySize = entry.size();
        }
        if (entry != null && entrySize > 0) {
            BigDecimal debitTotal = new BigDecimal("0");
            BigDecimal creditTotal = new BigDecimal("0");
            BigDecimal resultTotal = null;
            BigDecimal zeroValue = new BigDecimal("0");
            for (int i = 0; i < entrySize; ++i) {
                lineInfo = entry.get(i);
                if (lineInfo.getItem() == null || !lineInfo.getItem().isIsProfitAndLosses() || lineInfo.getDataElement() != 3) continue;
                if (lineInfo.getDebit() != null) {
                    debitTotal = debitTotal.add(lineInfo.getDebit());
                }
                if (lineInfo.getCredit() == null) continue;
                creditTotal = creditTotal.add(lineInfo.getCredit());
            }
            lineInfo = entry.get(entrySize - 1);
            if (debitTotal.compareTo(creditTotal) != 0) {
                CaliAdjustEntryInfo anotherLineInfo = new CaliAdjustEntryInfo();
                anotherLineInfo.setSeq(lineInfo.getSeq() + 1);
                anotherLineInfo.setIsVisible(false);
                anotherLineInfo.setDataElement(4);
                anotherLineInfo.setItem(this.getUnAssignRptItemId(ctx));
                anotherLineInfo.setAdjust(info);
                anotherLineInfo.setSummary(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustBAutoCreate", (Locale)ctx.getOriginLocale()));
                resultTotal = debitTotal.subtract(creditTotal);
                if (resultTotal.compareTo(zeroValue) > 0) {
                    anotherLineInfo.setDebit(resultTotal);
                    anotherLineInfo.setCredit(null);
                }
                if (resultTotal.compareTo(zeroValue) < 0) {
                    anotherLineInfo.setCredit(resultTotal.abs());
                    anotherLineInfo.setDebit(null);
                }
                info.getEntries().add(anotherLineInfo);
            }
        }
    }

    private RPTItemInfo getUnAssignRptItemId(Context ctx) throws BOSException, EASBizException {
        String oql = "SELECT id WHERE isFreezed = 0 and Control = 27";
        RPTItemCollection items = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        throw new AdjustException(AdjustException.UN_EXIST_UNSHARED_RPTITEM, new Object[]{RPTItemControlEnum.UNSHARED_PROFIT.getAlias()});
    }

    @Override
    protected void _copyHisData(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName, List list, boolean select, IObjectValue dataCollect) throws BOSException, EASBizException {
        Iterator iter = null;
        ArrayList<CaliAdjustEntryInfo> array = new ArrayList<CaliAdjustEntryInfo>();
        AbstractCaliAdjustEntryInfo lineInfo = null;
        RPTItemInfo itemInfo1 = null;
        String oql = "select id,number,name where isFreezed=0 and control=10";
        RPTItemCollection itemCol = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(oql);
        if (itemCol.size() > 0) {
            itemInfo1 = itemCol.get(0);
        }
        this.initCodeRule(ctx);
        iter = list.iterator();
        CaliAdjustInfo info = null;
        UserInfo nowUser = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        GregorianCalendar date = new GregorianCalendar();
        int nowYear = date.get(1);
        while (iter.hasNext()) {
            BigDecimal debit = new BigDecimal("0");
            BigDecimal credit = new BigDecimal("0");
            BigDecimal zero = new BigDecimal("0");
            String id = iter.next().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("date"));
            sic.add(new SelectorItemInfo("adjustMode.name"));
            sic.add(new SelectorItemInfo("templet.id"));
            sic.add(new SelectorItemInfo("templet.name"));
            sic.add(new SelectorItemInfo("dataSource"));
            sic.add(new SelectorItemInfo("valueType"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("sourceCurrency.name"));
            sic.add(new SelectorItemInfo("entries.summary"));
            sic.add(new SelectorItemInfo("entries.item.id"));
            sic.add(new SelectorItemInfo("entries.item.number"));
            sic.add(new SelectorItemInfo("entries.item.name"));
            sic.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
            sic.add(new SelectorItemInfo("entries.debit"));
            sic.add(new SelectorItemInfo("entries.credit"));
            sic.add(new SelectorItemInfo("entries.isVisible"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("CheckedStatus"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.dataElement"));
            sic.add(new SelectorItemInfo("orgBound.id"));
            sic.add(new SelectorItemInfo("entries.adjust.id"));
            sic.add(new SelectorItemInfo("entries.seq"));
            sic.add(new SelectorItemInfo("isCitedByLater"));
            sic.add(new SelectorItemInfo("dataCollect.name"));
            sic.add(new SelectorItemInfo("dataCollectNumber"));
            sic.add(new SelectorItemInfo("isFixed"));
            info = this.getCaliAdjustInfo(ctx, (IObjectPK)pk, sic);
            info.setDate(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
            info.setYear(year);
            info.setPeriod(period);
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
            info.setId(null);
            info.setNumber(null);
            info.setAuditDate(null);
            info.setAuditor(null);
            info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            info.setCreator(nowUser);
            info.setCreateTime(time);
            CaliAdjustEntryCollection col = info.getEntries();
            for (int i = 0; i < col.size(); ++i) {
                if (info.getYear() != nowYear && col.get(i).getItem().isIsProfitAndLosses() && col.get(i).getDataElement() == 3 && select) {
                    lineInfo = info.getEntries().get(i);
                    if (col.get(i).getDebit() != null) {
                        debit = debit.add(col.get(i).getDebit());
                    } else if (col.get(i).getCredit() != null) {
                        credit = credit.add(col.get(i).getCredit());
                    }
                    array.add(col.get(i));
                } else if (col.get(i).getSummary() != null && (col.get(i).getSummary().equals("AdjustEntry_Auto_Summary") || col.get(i).getSummary().equals(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"97_AdjustControllerBean", (Locale)ctx.getOriginLocale())))) {
                    array.add(col.get(i));
                } else {
                    col.get(i).setId(null);
                    col.get(i).getAdjust().setId(null);
                }
                info.getEntries();
            }
            if (!array.isEmpty()) {
                int n = array.size();
                for (int j = 0; j < n; ++j) {
                    info.getEntries().remove((CaliAdjustEntryInfo)array.get(j));
                }
                array.clear();
                if (lineInfo != null) {
                    lineInfo.setDataElement(5);
                    lineInfo.setItem(itemInfo1);
                    lineInfo.setId(null);
                    lineInfo.getAdjust().setId(null);
                    if (debit.subtract(credit).compareTo(zero) == 1) {
                        lineInfo.setDebit(debit.subtract(credit));
                        lineInfo.setCredit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == -1) {
                        lineInfo.setCredit(credit.subtract(debit));
                        lineInfo.setDebit(null);
                    } else if (debit.subtract(credit).compareTo(zero) == 0 || debit.subtract(credit).compareTo(zero) == 0) {
                        lineInfo.setDebit(null);
                        lineInfo.setCredit(null);
                    }
                    col.add((CaliAdjustEntryInfo)lineInfo);
                }
            }
            info.getEntries().size();
            info.getEntries().get(0).getItem().getName();
            if (info.getEntries().size() == 0) {
                throw new AdjustException(AdjustException.LINE_NOT_EXIST);
            }
            if (!this.hasCodeRule) {
                BigDecimal number = new BigDecimal("1");
                StringBuffer ret = new StringBuffer("AUTO_");
                StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
                sbSQL.append(tableName).append(" a  \r\n");
                sbSQL.append("\tWHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
                sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
                sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
                sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
                sbSQL.append("  and a.fNumber like 'AUTO\\_%' ESCAPE '\\' \r\n");
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                    String tempNumber = "";
                    BigDecimal curNumber = null;
                    while (rowSet.next()) {
                        tempNumber = rowSet.getString("Fnumber");
                        if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                        number = curNumber;
                    }
                    if (number != null) {
                        number = number.add(new BigDecimal("1"));
                    }
                }
                catch (SQLException exc) {
                    throw new SQLDataException(exc);
                }
                int n = 8 - number.toString().length();
                for (int i = 0; i < n; ++i) {
                    ret.append("0");
                }
                ret.append(number);
                info.setNumber(ret.toString());
            }
            info.getEntries().get(0).getItem().getName();
            info.getEntries().get(0).getItem().getNumber();
            info.setDataCollect((DataCollectInfo)dataCollect);
            info.setDataCollectNumber(((DataCollectInfo)dataCollect).getNumber());
            info.remove("id");
            this.submit(ctx, (CoreBaseInfo)info);
        }
        list.clear();
        list.size();
    }

    @Override
    protected void _forbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        CaliAdjustInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getCaliAdjustInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISFALSE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    @Override
    protected void _unForbidCitedByLater(Context ctx, List list) throws BOSException, EASBizException {
        Iterator iter = list.iterator();
        CaliAdjustInfo info = null;
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next().toString()));
            info = this.getCaliAdjustInfo(ctx, (IObjectPK)pk);
            IsCitedByLaterEnum isCited = IsCitedByLaterEnum.ISTRUE;
            info.setIsCitedByLater(isCited);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
        }
        list.clear();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CaliAdjustInfo info = this.getCaliAdjustInfo(ctx, pk);
        String s = info.getNumber() + "   " + info.getDataSource().getAlias();
        return s;
    }

    @Override
    protected boolean _removeBatch(Context ctx, List idList) throws BOSException, EASBizException {
        for (int i = 0; i < idList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idList.get(i).toString()));
            CaliAdjustInfo info = CaliAdjustFactory.getLocalInstance(ctx).getCaliAdjustInfo("select id,orgBound.id where id='" + pk.toString() + "'");
            super.delete(ctx, (IObjectPK)pk);
            this.deleteElimRelaOrgTree(ctx, info);
        }
        return true;
    }

    @Override
    protected CaliAdjustCollection _getAdjustForRemove(Context ctx, List idList) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            idSet.add(idList.get(i).toString());
        }
        if (idSet.size() == 0) {
            return new CaliAdjustCollection();
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().add(new String("id"));
        v.getSelector().add(new String("number"));
        v.getSelector().add(new String("checkedStatus"));
        v.getSelector().add(new String("convertBefore"));
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("convertBefore", idSet, CompareType.INCLUDE));
        f.setMaskString("#0 or #1");
        CaliAdjustCollection infos = this.getCaliAdjustCollection(ctx, v);
        idSet.clear();
        for (int i = 0; i < infos.size(); ++i) {
            CaliAdjustInfo info = infos.get(i);
            if (info.getConvertBefore() == null || info.getConvertBefore().length() <= 0) continue;
            idSet.add(info.getConvertBefore());
        }
        if (idSet.size() > 0) {
            f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            v.setFilter(f);
            infos.addCollection(this.getCaliAdjustCollection(ctx, v));
        }
        return infos;
    }

    @Override
    protected Map _isAdjhasImportBefore(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(8);
        StringBuffer msg = new StringBuffer();
        List idList = (List)param.get("idList");
        String basicTreeId = (String)param.get("basicOrgBoundId");
        String curOrgTreeId = (String)param.get("curOrgTreeId");
        StringBuffer sql = new StringBuffer();
        StringBuffer sql1 = null;
        Connection con = super.getConnection(ctx);
        PreparedStatement ps1 = null;
        ResultSet rs = null;
        String adjHeadId = null;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<Object[]> notImport = new ArrayList<Object[]>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<String, Integer> mapOther = new HashMap<String, Integer>();
        ArrayList<String> cach = new ArrayList<String>();
        HashMap<Object, Boolean> mapAll = new HashMap<Object, Boolean>();
        String key = null;
        sql.append(" select a.fid as adjFid,a.fnumber as fnumber,a.FOrgUnit as FOrgUnit,e.FItemID as FItemID,e.FDataElement as FDataElement,e.FDebit as FDebit,e.FCredit as FCredit \r\n");
        sql.append("  from t_csl_Caliadjust a inner join t_csl_Caliadjustentry e on a.fid=e.fadjustid where a.fid = ?  order by a.fid asc");
        try {
            ps1 = con.prepareStatement(sql.toString());
            if (idList != null && idList.size() > 0) {
                for (int i = 0; i < idList.size(); ++i) {
                    ps1.setString(1, idList.get(i).toString());
                    ps1.addBatch();
                    rs = ps1.executeQuery();
                    while (rs.next()) {
                        Object[] obj = new Object[]{rs.getString("adjFid"), rs.getString("FOrgUnit"), rs.getString("FItemID"), rs.getString("FDataElement"), rs.getBigDecimal("FDebit"), rs.getBigDecimal("FCredit"), rs.getString("fnumber")};
                        adjHeadId = obj[0].toString();
                        boolean isContain = this.isContains(dataList, obj[0].toString());
                        if (!isContain) {
                            dataList.add(obj);
                        }
                        mapAll.put(obj[0], new Boolean(false));
                        key = obj[4] == null ? obj[1].toString() + "-" + obj[2].toString() + "-" + obj[3].toString() + "-@-" + obj[5].toString() : obj[1].toString() + "-" + obj[2].toString() + "-" + obj[3].toString() + "-" + obj[4].toString() + "-@";
                        if (map.containsKey(key)) {
                            Integer adjBodyCount = (Integer)map.get(key);
                            Integer newCount = new Integer(adjBodyCount + 1);
                            map.put(key, newCount);
                            continue;
                        }
                        map.put(key, new Integer(1));
                    }
                    if (dataList == null || dataList.size() <= 0 || notImport == null) continue;
                    sql1 = new StringBuffer();
                    sql1.append(" select a2.fid as fid from t_csl_Caliadjust a1 inner join t_csl_Caliadjustentry e1 ");
                    sql1.append(" on a1.fid=e1.fadjustid inner join t_csl_Caliadjust a2 on a1.FOrgUnit=a2.FOrgUnit\u3000");
                    sql1.append(" inner join t_csl_Caliadjustentry e2 on a2.fid=e2.fadjustid");
                    sql1.append(" where a1.FOrgUnit=a2.FOrgUnit");
                    sql1.append(" and e1.FItemID=e2.FItemID");
                    sql1.append(" and e1.FDataElement=e2.FDataElement");
                    sql1.append(" and a1.FOrgBoundID='").append(basicTreeId).append("'");
                    sql1.append(" and a2.FOrgBoundID='").append(curOrgTreeId).append("'");
                    sql1.append(" and a1.fid='").append(adjHeadId).append("'");
                    IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        String adjustId = rs1.getString("fid");
                        if (cach.contains(adjustId)) continue;
                        cach.add(adjustId);
                        sql1 = new StringBuffer();
                        sql1.append(" select a.fid as adjFid,a.fnumber as fnumber,a.FOrgUnit as FOrgUnit,e.FItemID as FItemID,\r\n");
                        sql1.append(" e.FDataElement as FDataElement,e.FDebit as FDebit,e.FCredit as FCredit ");
                        sql1.append(" from t_csl_Caliadjust a inner join t_csl_Caliadjustentry e on a.fid=e.fadjustid where a.fid='").append(adjustId).append("'");
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                        while (rs2.next()) {
                            Object[] obj = new Object[]{rs2.getString("adjFid"), rs2.getString("FOrgUnit"), rs2.getString("FItemID"), rs2.getString("FDataElement"), rs2.getBigDecimal("FDebit"), rs2.getBigDecimal("FCredit"), rs2.getString("fnumber")};
                            boolean isContain = this.isContains(notImport, obj[0].toString());
                            if (!isContain) {
                                notImport.add(obj);
                            }
                            if (mapOther.containsKey(key = obj[4] == null ? obj[1].toString() + "-" + obj[2].toString() + "-" + obj[3].toString() + "-@-" + obj[5].toString() : obj[1].toString() + "-" + obj[2].toString() + "-" + obj[3].toString() + "-" + obj[4].toString() + "-@")) {
                                Integer adjBodyCount = (Integer)mapOther.get(key);
                                Integer newCount = new Integer(adjBodyCount + 1);
                                mapOther.put(key, newCount);
                                continue;
                            }
                            mapOther.put(key, new Integer(1));
                        }
                        if (!mapOther.isEmpty() && !map.isEmpty() && map.size() == mapOther.size()) {
                            Object[] o;
                            Object number;
                            int size1 = 0;
                            for (Object key1 : mapOther.keySet()) {
                                if (!map.containsKey(key1.toString())) break;
                                number = (Integer)map.get(key1.toString());
                                Integer numberOther = (Integer)mapOther.get(key1.toString());
                                if (((Integer)number).intValue() != numberOther.intValue()) break;
                                ++size1;
                            }
                            if (size1 == map.size()) {
                                if (dataList.size() > 0 && notImport.size() > 0) {
                                    o = (Object[])dataList.get(dataList.size() - 1);
                                    number = o[6].toString();
                                    Object[] o1 = (Object[])notImport.get(notImport.size() - 1);
                                    String number1 = o1[6].toString();
                                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"203_ElimRelaOrgTreeControllerBean", (Locale)ctx.getOriginLocale())).append((String)number).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"204_ElimRelaOrgTreeControllerBean", (Locale)ctx.getOriginLocale())).append(number1).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"205_ElimRelaOrgTreeControllerBean", (Locale)ctx.getOriginLocale()));
                                    msg.append("\n");
                                    if (mapAll.containsKey(o[0])) {
                                        Object value = mapAll.get(o[0]);
                                        value = new Boolean(true);
                                        mapAll.put(o[0], (Boolean)value);
                                    }
                                    dataList.remove(dataList.size() - 1);
                                }
                            } else {
                                o = (Object[])dataList.get(dataList.size() - 1);
                                if (mapAll.containsKey(o[0])) {
                                    Object value = mapAll.get(o[0]);
                                    value = new Boolean(false);
                                    mapAll.put(o[0], (Boolean)value);
                                }
                                if (notImport.size() > 0) {
                                    notImport.remove(notImport.size() - 1);
                                }
                            }
                            mapOther.clear();
                            continue;
                        }
                        mapOther.clear();
                        if (mapOther.isEmpty()) continue;
                        notImport.remove(notImport.size() - 1);
                    }
                    map.clear();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps1, (Connection)con);
        }
        resultMap.put("canImport", dataList);
        resultMap.put("notImport", notImport);
        resultMap.put("msg", msg);
        resultMap.put("mapAll", mapAll);
        return resultMap;
    }

    private boolean isContains(ArrayList list, String id) {
        boolean isEqual = false;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] obj = (Object[])list.get(i);
                if (obj[0].toString().equals(id)) {
                    isEqual = true;
                    break;
                }
                isEqual = false;
            }
        }
        return isEqual;
    }

    @Override
    protected String _getBasicOrgTree(Context ctx, Map param) throws BOSException, EASBizException {
        int year = (Integer)param.get("year");
        int period = (Integer)param.get("period");
        int periodType = (Integer)param.get("periodType");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_org_tree where fisbasic = 1 and ftype= 8 and fstartdate < Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "' and (fenddate is null or fenddate > Timestamp'" + new Timestamp(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)).getTime()) + "')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgTreeId = null;
        try {
            if (rs.next()) {
                orgTreeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgTreeId;
    }

    private void deleteElimRelaOrgTree(Context ctx, CaliAdjustInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_CSL_ElimRelaOrgTree where FCurrentElimId ='").append(info.getId().toString()).append("'");
        sql.append(" and FOrgTreeId ='").append(info.getOrgBound().getId().toString()).append("'");
        sql.append(" and (FRecordType=").append(0);
        sql.append(" or FRecordType = ").append(2);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected CaliAdjustCollection _getAdjustInOtherTree(Context ctx, String sourceTreeId, String importedTreeId, String unitId, int startYear, int startPeriod, int endYear, int endPeriod, int periodType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s2.funitid as FCompanyId from t_org_structure s1 ");
        sql.append(" inner join t_org_structure s2 on s1.ftreeid = s2.ftreeid ");
        sql.append(" and charindex(s1.flongnumber||'!', s2.flongnumber)=1 ");
        sql.append(" where s1.ftreeid = '" + importedTreeId + "' and s1.funitid = '" + unitId + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer bf = new StringBuffer("");
        try {
            while (rs.next()) {
                bf.append("'" + rs.getString("FCompanyId") + "',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (0 < rs.size()) {
            bf.deleteCharAt(bf.lastIndexOf(","));
        }
        OrgTreeInfo sourceTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(sourceTreeId));
        CaliAdjustCollection list = null;
        ICaliAdjust iAdjust = CaliAdjustFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT id,number,adjustMode.name,year,period,orgUnit.name,sourceCurrency.name,currency.name,orgBound.id,isFixed ");
        oql.append("WHERE (year > ").append(startYear);
        oql.append(" or (year = ").append(startYear).append(" and period >= ").append(startPeriod);
        oql.append(")) and (year < ").append(endYear);
        oql.append(" or (year = ").append(endYear).append(" and period <= ").append(endPeriod);
        oql.append("))  AND periodType = ").append(periodType);
        oql.append("  AND orgBound.number  = '").append(sourceTree.getNumber());
        oql.append("' AND orgUnit.id in (").append(bf.toString()).append(")");
        oql.append(" and isCitedByLater = 1 ORDER BY orgUnit.id");
        list = iAdjust.getCaliAdjustCollection(oql.toString());
        return list;
    }

    @Override
    protected void _copyFixedAdjustData(Context ctx, String orgTreeId, int periodType, int year, int period, IObjectValue dataCollect, String orgUnitId) throws BOSException, EASBizException {
        Map map = this.getNumber(ctx, orgUnitId, orgTreeId);
        String treeNumber = (String)map.get("treeNumber");
        String unitNumber = (String)map.get("unitNumber");
        boolean isSupport13Period = CslRptUtil.isSupport13Period(ctx);
        int[] pre = RPTDate13Util.getPreYearAndPeriod(year, period, RptPeriodTypeEnum.getEnum((int)periodType), isSupport13Period);
        ArrayList<String> list = new ArrayList<String>();
        DataCollectInfo dataColInfo = (DataCollectInfo)dataCollect;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct TPreAdjust.fid,TPreAdjust.FOrgUnitID from t_csl_Caliadjust TPreAdjust ");
        sql.append(" inner join T_ORG_Structure tstru on tstru.FUnitId=TPreAdjust.FOrgUnitID");
        sql.append(" inner join T_Org_Tree tree2 on tree2.fid = tstru.ftreeid and tree2.fnumber = ?");
        sql.append(" left join T_ORG_Structure tParentStru on tParentStru.FId=tstru.FParentID");
        sql.append(" left join T_Org_Tree tree3 on tree3.fid = tParentStru.ftreeid and tree3.fnumber = ?");
        sql.append(" inner join T_Org_Tree tree on tree.fid = TPreAdjust.FOrgBoundID");
        sql.append(" where TPreAdjust.FisFixed = 1");
        sql.append(" and tree.fnumber = ?");
        sql.append(" and ((tParentStru.flongnumber like ? or tParentStru.flongnumber = ?) or ");
        sql.append(" (tstru.FIsLeaf=0 and tstru.flongnumber= ?) )");
        sql.append(" and TPreAdjust.Fyear = ? and TPreAdjust.Fperiod=?");
        sql.append(" and TPreAdjust.FperiodType = ?");
        sql.append(" and TPreAdjust.FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        Object[] param = new Object[]{treeNumber, treeNumber, treeNumber, unitNumber + "!%", unitNumber, unitNumber, new Integer(pre[0]), new Integer(pre[1]), new Integer(periodType)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        ArrayList<String> orgUnitIDList = new ArrayList<String>();
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
                orgUnitIDList.add(rs.getString("FOrgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sql = new StringBuffer();
        sql.append("select unit.Fid fid from t_org_baseunit unit ");
        sql.append(" inner join t_org_structure str on str.funitid = unit.fid");
        sql.append(" where str.ftreeid = ? and str.flongNumber like ?");
        IRowSet ids = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, unitNumber + "!%"});
        HashSet<String> companyIds = new HashSet<String>();
        try {
            while (ids.next()) {
                companyIds.add(ids.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String orgUnitID = (String)orgUnitIDList.get(i);
            if (companyIds.contains(orgUnitID)) continue;
            list.remove(i);
        }
        if (list.size() == 0) {
            throw new AdjustException(AdjustException.FIXLINE_NOT_EXIST);
        }
        String tableName = "t_csl_Caliadjust";
        this.copyHisData(ctx, orgTreeId, periodType, year, period, tableName, list, false, dataColInfo);
    }

    @Override
    protected boolean _isHaveFixedAdjustData(Context ctx, String orgTreeId, int periodType, int year, int period, IObjectValue dataCollect, String orgUnitId) throws BOSException, EASBizException {
        DataCollectInfo dataColInfo = (DataCollectInfo)dataCollect;
        StringBuffer sql = new StringBuffer();
        sql.append(" select TAdj.fid from t_csl_Caliadjust tadj");
        sql.append(" inner join T_ORG_Structure tstru on tstru.FUnitId=tadj.FOrgUnitID and tstru.FTreeId='" + orgTreeId + "'");
        sql.append(" left join T_ORG_Structure tParentStru on tParentStru.FId=tstru.FParentID and tParentStru.FTreeId='" + orgTreeId + "'");
        sql.append(" where TAdj.FisFixed = 1");
        sql.append(" and ((tParentStru.FUnitID='" + orgUnitId + "') or ");
        sql.append(" (tstru.FIsLeaf=0 and tadj.FOrgUnitID='" + orgUnitId + "') )");
        sql.append(" and TAdj.FOrgBoundID = '" + orgTreeId + "'");
        sql.append(" and TAdj.Fyear = " + year + " and TAdj.Fperiod=" + period);
        sql.append(" and TAdj.FperiodType = " + periodType);
        sql.append(" and TAdj.FDataCollectID = '" + dataColInfo.getId().toString() + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs.size() > 0;
    }

    private Map getNumber(Context ctx, String orgUnitId, String orgTreeId) throws BOSException {
        HashMap<String, String> numbers = new HashMap<String, String>();
        String sql = "select fnumber from t_org_tree where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
        try {
            while (rs.next()) {
                String treeNumber = rs.getString("fnumber");
                numbers.put("treeNumber", treeNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String newSql = "select flongnumber from T_ORG_Structure where funitid = ?";
        IRowSet newrs = DbUtil.executeQuery((Context)ctx, (String)newSql, (Object[])new Object[]{orgUnitId});
        try {
            while (newrs.next()) {
                String unitNumber = newrs.getString("flongnumber");
                numbers.put("unitNumber", unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return numbers;
    }
}

