/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.DItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.EItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.NItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.OffYearPeriod;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CollectItemDefine {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CollectItemDefine.class);
    private DBHandler dao;
    private ItemContext baseContext;
    private Collection<IItemQueryUnit> queryUnits;
    private OrgType rptOrgType;

    public CollectItemDefine(DBHandler dao) {
        this.dao = dao;
        this.queryUnits = new HashSet<IItemQueryUnit>(10);
    }

    public boolean init(String reportId) {
        CslReportInfo report;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("orgUnit.id");
        selector.add("orgUnit.number");
        selector.add("sourceCurrency");
        selector.add("periodType");
        selector.add("year");
        selector.add("period");
        selector.add("sourceType");
        selector.add("orgType");
        selector.add("template.id");
        selector.add("template.hasExtrItem");
        try {
            report = this.dao.get(ICslReport.class).getCslReportInfo((IObjectPK)new ObjectUuidPK(reportId), selector);
            if (!IItemSourceType.SOURCE_TYPE_REPORT.contains(report.getSourceType().getValue())) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("", e);
            return false;
        }
        if (!report.getTemplate().isHasExtrItem()) {
            return false;
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(report.getOrgUnit().getId());
        company.setNumber(report.getOrgUnit().getNumber());
        this.baseContext = new ItemContext((OrgUnitInfo)company, report.getSourceCurrency(), report.getPeriodType(), report.getYear(), report.getPeriod(), 0, null);
        this.rptOrgType = report.getOrgType();
        return true;
    }

    public void addItem(Map<String, Map<String, Object>> data, String itemType) {
        if (data == null || data.isEmpty() || !BizFormulaDefine.belongType(itemType, new String[]{"ITEM"})) {
            return;
        }
        OffYearPeriod offYearPeriod = new OffYearPeriod();
        for (Map.Entry<String, Map<String, Object>> entry : data.entrySet()) {
            String contextKey = entry.getKey();
            Map<String, Object> itemValues = entry.getValue();
            HashMap keyMap = CslRptUtil.getKeyMap(contextKey);
            ItemContext context = new ItemContext(this.baseContext.getCompany(), this.baseContext.getCurrency(), this.baseContext.getPeriodType(), offYearPeriod.year(this.baseContext.getYear(), new Integer(keyMap.get("Year").toString())), offYearPeriod.period(this.baseContext.getPeriod(), new Integer(keyMap.get("Period").toString())), new Integer(keyMap.get("DataElement").toString()), ValueTypeEnum.getEnum(new Integer(keyMap.get("ValueType").toString())));
            if (!BizFormulaDefine.belongType(itemType, new String[]{"ITEM"})) continue;
            for (String itemNum : itemValues.keySet()) {
                ItemInfo item = new ItemInfo(itemType, itemNum, null);
                this.queryUnits.add(new NItemQueryUnit(item, context));
            }
        }
    }

    public void addDItem(Map<String, Map<String, Map<String, List<Object>>>> data, String itemType) {
        if (data == null || data.isEmpty() || !BizFormulaDefine.belongType(itemType, new String[]{"DITEM"})) {
            return;
        }
        OffYearPeriod offYearPeriod = new OffYearPeriod();
        for (Map.Entry<String, Map<String, Map<String, List<Object>>>> entry : data.entrySet()) {
            String contextKey = entry.getKey();
            Map<String, Map<String, List<Object>>> itemValues = entry.getValue();
            HashMap keyMap = CslRptUtil.getKeyMap(contextKey);
            for (String itemNum : itemValues.keySet()) {
                Map<String, List<Object>> ditems = itemValues.get(itemNum);
                for (String ditemNum : ditems.keySet()) {
                    this.queryUnits.add(new DItemQueryUnit(this.baseContext.getCompany(), itemType, itemNum, offYearPeriod.year(this.baseContext.getYear(), new Integer(keyMap.get("Year").toString())), offYearPeriod.period(this.baseContext.getPeriod(), new Integer(keyMap.get("Period").toString())), this.baseContext.getPeriodType(), new Integer(keyMap.get("DataElement").toString()), ValueTypeEnum.getEnum(new Integer(keyMap.get("ValueType").toString())), this.baseContext.getCurrency(), ditemNum));
                }
            }
        }
    }

    public void addEItem(Map<String, StringBuffer> data, String itemType) throws BOSException {
        if (data == null || data.isEmpty()) {
            return;
        }
        OffYearPeriod offYearPeriod = new OffYearPeriod();
        QueryDataElement queryDataElement = new QueryDataElement(this.dao);
        Map<String, Integer> allDataElements = queryDataElement.exec();
        for (Map.Entry<String, StringBuffer> entry : data.entrySet()) {
            String itemInfoKey = entry.getKey();
            String[] itemInfos = itemInfoKey.split(",");
            String itemNum = itemInfos[0];
            String targetCompany = itemInfos[2];
            int year = Integer.parseInt(itemInfos[6]);
            int period = Integer.parseInt(itemInfos[7]);
            String dataElement = itemInfos[10];
            this.queryUnits.add(new EItemQueryUnit(this.baseContext.getCompany(), itemType, itemNum, offYearPeriod.year(this.baseContext.getYear(), year), offYearPeriod.period(this.baseContext.getPeriod(), period), this.baseContext.getPeriodType(), allDataElements.get(dataElement), this.baseContext.getCurrency(), targetCompany));
        }
    }

    public Collection<IItemQueryUnit> getQueryUnits() {
        return this.queryUnits;
    }

    public void clear() {
        this.queryUnits.clear();
    }

    public OrgType getOrgType() {
        if (this.rptOrgType == null) {
            return OrgType.Company;
        }
        return this.rptOrgType;
    }
}

