/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ArchiveFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslParam;
import com.kingdee.eas.fi.gr.cslrpt.ITempletItemList;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCslParamControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListNewUtil;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.jdbc.statement.CslPreparedStatement;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Point;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslParamControllerBean
extends AbstractCslParamControllerBean {
    private static final Logger logger = CoreUIObject.getLogger(CslParamControllerBean.class);

    @Override
    protected boolean _isUpdatedTemplate(Context ctx) throws BOSException, EASBizException {
        String value = this.getParam(ctx, "KEY_CSLPARAM_UPDATEDYNATMP");
        Boolean b = new Boolean(value);
        return b;
    }

    @Override
    protected boolean _setUpdatedTemplate(Context ctx) throws BOSException, EASBizException {
        this.setParam(ctx, "KEY_CSLPARAM_UPDATEDYNATMP", "TRUE");
        return true;
    }

    @Override
    protected String _getFtpPath(Context ctx) throws BOSException, EASBizException {
        return this.getParam(ctx, "KEY_CSLPARAM_FTPPATH");
    }

    @Override
    protected void _setFtpPath(Context ctx, String ftpPath) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ftpPath)) {
            ftpPath = "";
        }
        this.setParam(ctx, "KEY_CSLPARAM_FTPPATH", ftpPath);
    }

    @Override
    protected void _setParam(Context ctx, String key, String value) throws BOSException, EASBizException {
        this.setParam(ctx, key, value, null);
    }

    private void setParam(Context ctx, String key, String value, String desc) throws BOSException, EASBizException {
        String sql = "select Fid from t_csl_cslparam where FKey = '" + key + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            sql = "update t_csl_cslparam set FValue = '" + value + "' where FKey = '" + key + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            sql = StringUtils.isEmpty((String)desc) ? "insert into t_csl_cslparam (FID, FKey, FValue) values ('" + BOSUuid.create((BOSObjectType)new CslParamInfo().getBOSType()) + "', '" + key + "', '" + value + "')" : "insert into t_csl_cslparam (FID, FKey, FValue, FDESCRIPTION) values ('" + BOSUuid.create((BOSObjectType)new CslParamInfo().getBOSType()) + "', '" + key + "', '" + value + "', '" + desc + "')";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected String _getParam(Context ctx, String key) throws BOSException, EASBizException {
        String sql = "Select FValue From T_Csl_CslParam where FKey='" + key + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                return rowSet.getString("FValue");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected void _updateDynaTemplate(Context ctx) throws BOSException, EASBizException {
        String oql = " where templateType in (10, 11)";
        TemplateCollection temps = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(oql);
        for (TemplateInfo info : temps) {
            Book book = null;
            try {
                book = info.getBook();
            }
            catch (Exception e) {
                continue;
            }
            if (book == null) continue;
            this.updateAsstActTypeByTemplate(ctx, info, book);
            book = null;
        }
    }

    private void updateAsstActTypeByTemplate(Context ctx, TemplateInfo info, Book book) throws BOSException {
        book.setCalculate(false);
        Connection conn = null;
        PreparedStatement ps = null;
        String templateId = info.getId().toString();
        String templetItemListTable = TemplateItemListNewUtil.getTemplateItemListTableNameById((Context)ctx, (String)templateId, (String)TemplateItemListNewUtil.templateItemList_his);
        String sql = "update " + templetItemListTable + " set FAsstActTypeNumber = ? where FTemplateId = ? and FSheetId = ? and FPosX = ? and FPosY = ?";
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            boolean isEmpty = true;
            for (int iIndex = 0; iIndex < book.getSheetCount(); ++iIndex) {
                Sheet sheet = book.getSheet(iIndex);
                String tableId = sheet.getID();
                ArrayList basePoints = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                HashMap asstActTypeNumber = new HashMap();
                int ct = sheet.getMaxRowIndex() + 1;
                for (int i = 0; i < ct; ++i) {
                    int jt = sheet.getMaxColIndex() + 1;
                    for (int j = 0; j < jt; ++j) {
                        String number;
                        ItemFormula formula = (ItemFormula)sheet.getRange(i, j).getUserObject("ITEM");
                        if (formula == null || formula.getFormula() == null || !formula.isValidity()) continue;
                        Point point = new Point(j, i);
                        if ((point = DynamicTemplateUtility.getBasePoint((Sheet)sheet, (Point)point, (ArrayList)basePoints)) == null) continue;
                        if (asstActTypeNumber.containsKey(point)) {
                            number = (String)asstActTypeNumber.get(point);
                        } else {
                            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)sheet, (int)point.y, (int)point.x);
                            number = param.getAssistantType().getProperityName();
                        }
                        if (StringUtils.isEmpty((String)number)) continue;
                        isEmpty = false;
                        ps.setObject(1, number);
                        ps.setObject(2, templateId);
                        ps.setObject(3, tableId);
                        ps.setObject(4, new Integer(j));
                        ps.setObject(5, new Integer(i));
                        ps.addBatch();
                    }
                }
            }
            if (!isEmpty) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _updateOffsetSheet(Context ctx) throws BOSException, EASBizException {
        ITempletItemList iItemList = TempletItemListFactory.getLocalInstance(ctx);
        String flag = this.getParam(ctx, "KEY_CSLPARAM_ISUPDATEDXTMPT");
        if ("TRUE".equalsIgnoreCase(flag)) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        StringBuffer querySql = new StringBuffer();
        querySql.append("select fid from t_rpt_template t1");
        querySql.append(" where t1.ftemplatetype = ").append(6);
        querySql.append(" and exists(select 1 from t_rpt_rptsheetpara t2");
        querySql.append(" where t2.freportid = t1.fid");
        querySql.append(" and t2.FReportClass!=").append(1).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rowSet.next()) {
                ids.append(rowSet.getString(1)).append(",");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add("data");
            ITemplate iTemplate = TemplateFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("data"));
            selector.add(new SelectorItemInfo("sheetParam.id"));
            selector.add(new SelectorItemInfo("sheetParam.sheetID"));
            selector.add(new SelectorItemInfo("sheetParam.reportClass"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection collection = iTemplate.getCollection(view);
            for (TemplateInfo template : collection) {
                String id = template.getId().toString();
                Map sheetTypes = this.getSheetTypes(template);
                try {
                    Map updateGradeData;
                    Book book = template.getBook();
                    if (book == null || (updateGradeData = this.createUpdateGradeData(ctx, book, sheetTypes)).isEmpty()) continue;
                    iItemList.importItemList(id, updateGradeData);
                    template.setBook(book);
                    iTemplate.updatePartial((CoreBaseInfo)template, sc);
                }
                catch (Exception e) {
                    logger.error((Object)"template.getBook()_Exception", (Throwable)e);
                }
            }
        }
        String desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"132_CslParamControllerBean", (Locale)ctx.getOriginLocale());
        this.setParam(ctx, "KEY_CSLPARAM_ISUPDATEDXTMPT", "TRUE", desc);
    }

    private Map createUpdateGradeData(Context ctx, Book book, Map sheetTypes) {
        HashMap<String, ItemFormula> itemData = new HashMap<String, ItemFormula>();
        int count = book.getSheetCount();
        StringBuffer formulaString = new StringBuffer();
        DataElementInfo element = DataElementProvider.getDataElementInfo(ctx, 4);
        for (int i = 0; i < count; ++i) {
            String cellName;
            ItemFormula newFormula;
            ItemFormula formula;
            Range range;
            int index;
            Sheet sheet = book.getSheet(i);
            int sheetType = Integer.parseInt((String)sheetTypes.get(sheet.getID()));
            if (sheetType == 1) continue;
            int x = CslRptUtil.getBasePosition_Left(sheet);
            int y = CslRptUtil.getBasePosition_Top(sheet);
            if (x < 0 && y < 0) continue;
            int x2 = sheet.getMaxColIndex();
            if (sheetType == 10) {
                for (index = x + 1; index <= x2; ++index) {
                    range = sheet.getRange(y, index);
                    formula = (ItemFormula)range.getUserObject("ITEM");
                    if (formula == null || formula.isValidity()) continue;
                    formulaString.setLength(0);
                    formulaString.append("=Item(\"").append(formula.getItemNumber());
                    formulaString.append("\",0,0,\"").append(element.getNumber());
                    formulaString.append("\",\"MONEY\")");
                    newFormula = new ItemFormula(formulaString.toString());
                    newFormula.putExt("5", sheet.getID());
                    newFormula.putExt("6", sheet.getSheetName());
                    newFormula.putExt("SHEETTYPE", (String)sheetTypes.get(sheet.getID()));
                    newFormula.putExt("8", Integer.toString(index));
                    newFormula.putExt("9", Integer.toString(y));
                    cellName = TableToolkit.xy2range((int)index, (int)y);
                    newFormula.putExt("7", cellName);
                    itemData.put(newFormula.getFormula(), newFormula);
                    range.setUserObject("ITEM", (Object)newFormula);
                    range.setValue(new Variant((Object)(range.getValue().getValue() + "(" + element.getName() + ")")));
                }
                continue;
            }
            if (sheetType == 20) {
                for (index = x + 1; index <= x2; ++index) {
                    range = sheet.getRange(y, index);
                    formula = (ItemFormula)range.getUserObject("ITEM");
                    if (formula == null || formula.isValidity()) continue;
                    element = StringUtils.isEmpty((String)formula.getDataElementNumber()) ? DataElementProvider.getDataElementInfo(ctx, "AMOUNT") : DataElementProvider.getDataElementInfo(ctx, formula.getDataElementNumber());
                    formulaString.setLength(0);
                    formulaString.append("=Item(\"").append(formula.getItemNumber());
                    formulaString.append("\",0,0,\"").append(element.getNumber());
                    formulaString.append("\",\"MONEY\")");
                    newFormula = new ItemFormula(formulaString.toString());
                    newFormula.putExt("5", sheet.getID());
                    newFormula.putExt("6", sheet.getSheetName());
                    newFormula.putExt("SHEETTYPE", (String)sheetTypes.get(sheet.getID()));
                    newFormula.putExt("8", Integer.toString(index));
                    newFormula.putExt("9", Integer.toString(y));
                    cellName = TableToolkit.xy2range((int)index, (int)y);
                    newFormula.putExt("7", cellName);
                    itemData.put(newFormula.getFormula(), newFormula);
                    range.setUserObject("ITEM", (Object)newFormula);
                    range.setValue(new Variant((Object)(range.getValue().getValue() + "(" + element.getName() + ")")));
                }
                continue;
            }
            if (sheetType == 30) {
                for (index = x + 1; index <= x2; ++index) {
                    range = sheet.getRange(y, index);
                    formula = (ItemFormula)range.getUserObject("ITEM");
                    if (formula == null || formula.isValidity() || (element = DataElementProvider.getDataElementInfo(ctx, formula.getDataElementNumber())) == null) continue;
                    formulaString.setLength(0);
                    formulaString.append("=Item(\"").append(formula.getItemNumber());
                    formulaString.append("\",0,0,\"").append(element.getNumber());
                    formulaString.append("\",\"MONEY\")");
                    newFormula = new ItemFormula(formulaString.toString());
                    newFormula.putExt("5", sheet.getID());
                    newFormula.putExt("6", sheet.getSheetName());
                    newFormula.putExt("SHEETTYPE", (String)sheetTypes.get(sheet.getID()));
                    newFormula.putExt("8", Integer.toString(index));
                    newFormula.putExt("9", Integer.toString(y));
                    cellName = TableToolkit.xy2range((int)index, (int)y);
                    newFormula.putExt("7", cellName);
                    itemData.put(newFormula.getFormula(), newFormula);
                    range.setUserObject("ITEM", (Object)newFormula);
                    range.setValue(new Variant((Object)(range.getValue().getValue() + "(" + element.getName() + ")")));
                }
                continue;
            }
            if (sheetType != 40) continue;
            for (index = x + 1; index <= x2; ++index) {
                range = sheet.getRange(y, index);
                formula = (ItemFormula)range.getUserObject("ITEM");
                if (formula == null || formula.isValidity() || (element = DataElementProvider.getDataElementInfo(ctx, formula.getDataElementNumber())) == null) continue;
                formulaString.setLength(0);
                formulaString.append("=Item(\"").append(formula.getItemNumber());
                formulaString.append("\",0,0,\"").append(element.getNumber());
                formulaString.append("\",\"MONEY\")");
                newFormula = new ItemFormula(formulaString.toString());
                newFormula.putExt("5", sheet.getID());
                newFormula.putExt("6", sheet.getSheetName());
                newFormula.putExt("SHEETTYPE", (String)sheetTypes.get(sheet.getID()));
                newFormula.putExt("8", Integer.toString(index));
                newFormula.putExt("9", Integer.toString(y));
                cellName = TableToolkit.xy2range((int)index, (int)y);
                newFormula.putExt("7", cellName);
                itemData.put(newFormula.getFormula(), newFormula);
                range.setUserObject("ITEM", (Object)newFormula);
                range.setValue(new Variant((Object)(range.getValue().getValue() + "(" + element.getName() + ")")));
            }
        }
        return itemData;
    }

    private Map getSheetTypes(TemplateInfo template) {
        HashMap<String, String> sheetTypes = new HashMap<String, String>();
        RptSheetParamCollection sheetParamCollection = template.getSheetParam();
        for (RptSheetParamInfo sheetParam : sheetParamCollection) {
            sheetTypes.put(sheetParam.getSheetID(), String.valueOf(sheetParam.getReportClass().getValue()));
        }
        return sheetTypes;
    }

    @Override
    protected Map _getZipDataForRPC(Context ctx, List params) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(4);
        Object[] param0 = (Object[])params.get(0);
        String orgBoundId = (String)param0[0];
        String orgGroupId = (String)param0[1];
        int rptYear = (Integer)param0[2];
        int rptPeriod = (Integer)param0[3];
        int rptPeriodType = (Integer)param0[4];
        boolean isPublish = ArchiveFactory.getLocalInstance(ctx).isPublised(orgBoundId, orgGroupId, rptYear, rptPeriod, rptPeriodType);
        result.put("isPublish", isPublish);
        boolean isUpdateTemplate = CslParamFactory.getLocalInstance(ctx).isUpdatedTemplate();
        result.put("isUpdateTemplate", isUpdateTemplate);
        return result;
    }

    @Override
    protected Map _getInitCSLContextData(Context ctx, Map params) throws BOSException, EASBizException {
        String treeid = (String)params.get("OrgTreeID");
        String orgGroupid = (String)params.get("OrgGroupID");
        Integer curRptYear = (Integer)params.get("CurRptYear");
        Integer curRptPeriod = (Integer)params.get("CurRptPeriod");
        Integer rptPeriodType = (Integer)params.get("PeriodType");
        boolean published = ArchiveFactory.getLocalInstance(ctx).isPublised(treeid, orgGroupid, curRptYear, curRptPeriod, rptPeriodType);
        ICslParam icp = CslParamFactory.getLocalInstance(ctx);
        boolean updatedTemplate = icp.isUpdatedTemplate();
        if (!updatedTemplate) {
            try {
                icp.updateDynaTemplate();
                updatedTemplate = icp.setUpdatedTemplate();
            }
            catch (EASBizException e) {
                updatedTemplate = false;
            }
            catch (BOSException e) {
                updatedTemplate = false;
            }
        }
        icp.updateOffsetSheet();
        HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>(2);
        returnMap.put("Published", published);
        returnMap.put("UpdatedTemplate", updatedTemplate);
        return returnMap;
    }

    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        Statement statement;
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_CSL_CSLPARAM");
        Connection cn = null;
        CslPreparedStatement ps = null;
        try {
            cn = super.getConnection(ctx);
            String insert = "INSERT INTO T_CSL_CSLPARAM (FID,FKEY,FVALUE,FDESCRIPTION) VALUES(?,?,?,?)";
            int count = colls.size();
            CslParamInfo paramInfo = (CslParamInfo)colls.get(0);
            BOSObjectType type = paramInfo.getBOSType();
            ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)insert);
            for (int i = 0; i < count; ++i) {
                paramInfo = (CslParamInfo)colls.get(i);
                ps.setString(1, paramInfo.getId() == null ? BOSUuid.create((BOSObjectType)type).toString() : paramInfo.getId().toString());
                ps.setString(2, paramInfo.getKey());
                ps.setString(3, paramInfo.getValue());
                ps.setString(4, paramInfo.getDescription());
                ps.addBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
            statement = ps != null ? ps.getStatement() : null;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)(ps != null ? ps.getStatement() : null), (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)cn);
        return null;
    }
}

