/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCslPostilControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.CSLComment;
import com.kingdee.eas.fi.rpt.CSLCommentsCollection;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class CslPostilControllerBean
extends AbstractCslPostilControllerBean {
    private static final String BOSTYPESTRING = "FCAF2794";

    @Override
    protected boolean _saveCSLItemPostil(Context ctx, CSLCommentsCollection cslComments) throws BOSException, EASBizException {
        if (cslComments == null) {
            return true;
        }
        boolean isTrue = true;
        String strSQL = null;
        boolean isSupport13Period = CslRptUtil.isSupport13Period(ctx);
        strSQL = "Delete From T_CSL_CSLPOSTIL Where FReportId = ?";
        DbUtil.execute((Context)ctx, (String)strSQL, (Object[])new String[]{cslComments.getRptID().toString()});
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_CSL_CslPostil").append("\r\n");
        insertSql.append("(FID, FDescription, FReportID, FItemNumber").append("\r\n");
        insertSql.append(", FDataElement, FValueType, FYear, FPeriod, FPostilType)").append("\r\n");
        insertSql.append("values(?,?,?,?,?,?,?,?,?)").append("\r\n");
        PreparedStatement pStmt = null;
        Connection cn = super.getConnection(ctx);
        try {
            pStmt = cn.prepareStatement(insertSql.toString());
            Iterator itor = cslComments.getComments().iterator();
            Object postil = null;
            while (itor.hasNext()) {
                postil = itor.next();
                if (postil == null || !(postil instanceof CSLComment)) continue;
                CSLComment cslComment = postil;
                pStmt.setString(1, BOSUuid.create((String)BOSTYPESTRING).toString());
                pStmt.setString(2, cslComment.getContent());
                pStmt.setString(3, cslComments.getRptID().toString());
                pStmt.setString(4, cslComment.getItemNumber());
                pStmt.setInt(5, DataElementProvider.getDataElementInnerValue(ctx, cslComment.getDataElement()));
                pStmt.setInt(6, cslComment.getValueType());
                if (cslComments.getRptYear() > 0 && cslComments.getRptPeriod() > 0) {
                    int[] yp = RPTDateUtil.getRptYearAndPeriod(cslComments.getRptYear(), cslComments.getRptPeriod(), cslComments.getRptPeriodType(), cslComment.getYear(), cslComment.getPeriod());
                    pStmt.setInt(7, yp[0]);
                    pStmt.setInt(8, yp[1]);
                } else {
                    pStmt.setInt(7, cslComment.getYear());
                    pStmt.setInt(8, cslComment.getPeriod());
                }
                pStmt.setInt(9, 3);
                pStmt.addBatch();
            }
            pStmt.executeBatch();
        }
        catch (SQLException e) {
            isTrue = false;
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        }
        return isTrue;
    }

    private String _getSQLStringForInsert(Context ctx, CSLComment postil, int year, int period, int periodType, String rptID) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        String id = BOSUuid.create((String)BOSTYPESTRING).toString();
        boolean isSupport13Period = CslRptUtil.isSupport13Period(ctx);
        int[] yp = RPTDate13Util.getRptYearAndPeriod(year, period, periodType, postil.getYear(), postil.getPeriod(), isSupport13Period);
        strSQL.append("INSERT INTO T_CSL_CslPostil \r\n");
        strSQL.append("(FID, FDescription, FReportID, FItemNumber, FDataElement, \r\n");
        strSQL.append("  FValueType, FYear, FPeriod, FPostilType) \r\n");
        strSQL.append("VALUES ('");
        strSQL.append(id);
        strSQL.append("','");
        strSQL.append(postil.getContent());
        strSQL.append("','");
        strSQL.append(rptID);
        strSQL.append("','");
        strSQL.append(postil.getItemNumber());
        strSQL.append("',");
        strSQL.append(DataElementProvider.getDataElementInnerValue(ctx, postil.getDataElement()));
        strSQL.append(",");
        strSQL.append(postil.getValueType());
        strSQL.append(",");
        strSQL.append(yp[0]);
        strSQL.append(",");
        strSQL.append(yp[1]);
        strSQL.append(",");
        strSQL.append(3);
        strSQL.append(")");
        return strSQL.toString();
    }
}

