/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CyconvtDataElementMappingInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractCyconvtDataElementMappingControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CyconvtDataElementMappingControllerBean
extends AbstractCyconvtDataElementMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.CyconvtDataElementMappingControllerBean");

    @Override
    protected void _saveAll(Context ctx, List dataElmentMappings) throws BOSException, EASBizException {
        this.deleteAllRecords(ctx);
        if (dataElmentMappings != null && dataElmentMappings.size() > 0) {
            Map dataElementIDMap = this.getDataElementIDByNumber(ctx, dataElmentMappings);
            Connection connection = this.getConnection(ctx);
            PreparedStatement prepareStatement = null;
            try {
                String insertSQL = " insert into T_CSL_DataElementMapping (FID,FCustomDataElementID,FSysDataElement) values (?,?,?) ";
                prepareStatement = connection.prepareStatement(insertSQL);
                for (CyconvtDataElementMappingInfo info : dataElmentMappings) {
                    prepareStatement.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                    prepareStatement.setString(2, (String)dataElementIDMap.get(info.get("mappingRela.number")));
                    prepareStatement.setInt(3, info.getSysDataElement().getValue());
                    prepareStatement.addBatch();
                }
                prepareStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(prepareStatement, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)prepareStatement, (Connection)connection);
        }
    }

    private Map getDataElementIDByNumber(Context ctx, List dataElmentMappings) throws BOSException {
        HashSet<Object> numberSet = new HashSet<Object>();
        for (CyconvtDataElementMappingInfo info : dataElmentMappings) {
            numberSet.add(info.get("mappingRela.number"));
        }
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append(" Select FID,FNumber from T_CSL_DataElement where FNumber in ");
        sql.append(RptUtilForServer.createInSql(numberSet.iterator(), params));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                result.put(rowSet.getString("FNumber"), rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void deleteAllRecords(Context ctx) throws BOSException, EASBizException {
        String deleteSQL = "delete from T_CSL_DataElementMapping ";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
    }

    @Override
    protected boolean _isReportHasUnMappedDataElement(Context ctx, List reportIDs) throws BOSException, EASBizException {
        HashSet ids = new HashSet(reportIDs);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        CslReportCollection cslReportCollection = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(view);
        ArrayList<Book> books = new ArrayList<Book>();
        for (int i = 0; i < cslReportCollection.size(); ++i) {
            CslReportInfo cslReportInfo = cslReportCollection.get(i);
            try {
                books.add(cslReportInfo.getBook());
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return CslRptUtil.isReportHasUnMappedDataElement(ctx, books);
    }
}

