/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractDataElementControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.jfree.util.Log;

public class DataElementControllerBean
extends AbstractDataElementControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.submitCheck(ctx, model);
        this.setInterSeq(ctx, model);
        super._addnew(ctx, pk, model);
        DataElementProvider.refresh(ctx);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.submitCheck(ctx, model);
        this.setInterSeq(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        DataElementProvider.refresh(ctx);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataElementInfo model = this.getDataElementInfo(ctx, pk);
        if (!this.checkRemove(ctx, model)) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement_IsUsed", (Locale)ctx.getOriginLocale())));
        }
        super._delete(ctx, pk);
        DataElementProvider.refresh(ctx);
    }

    private boolean checkRemove(Context ctx, DataElementInfo model) throws BOSException {
        int interSeq = model.getInterSeq();
        String[] tableNames = new String[]{"T_CSL_AdjustEntry", "T_CSL_ElimTempletEntry", "T_CSL_TempletItemList", "T_CSL_InvestItemData", "T_CSL_AdjustTempletEntry", "T_CSL_EliminationEntry", "T_CSL_InvestCheckage", "T_CSL_ItemDataEntry", "T_CSL_InvestTempletEntry", "T_CSL_InterestCheckage", "T_CSL_CslPostil", "T_CSL_IIAssistantItemData"};
        for (int i = 0; i < tableNames.length; ++i) {
            String sql = "select FID from " + tableNames[i] + " where FDataElement = " + interSeq;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() <= 0) continue;
            return false;
        }
        return true;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.submitCheck(ctx, model);
        super._update(ctx, pk, model);
        DataElementProvider.refresh(ctx);
    }

    private void submitCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IRowSet rowSet;
        DataElementInfo info = (DataElementInfo)model;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> arr = new ArrayList<String>();
        sql.append("select data.FNumber,data.FName_" + ctx.getLocale() + ",org.FName_" + ctx.getLocale() + " from T_Csl_DataElement data ");
        sql.append("inner join T_ORG_Company org ");
        sql.append("on data.FTrackRecordCreatorID=org.fid ");
        sql.append("and (Upper(data.FNumber) = ? ");
        arr.add(info.getNumber().toUpperCase());
        sql.append(" or Upper(data.FName_" + ctx.getLocale() + ") = ? ) ");
        arr.add(info.getName().toUpperCase());
        if (info.getId() != null) {
            sql.append(" and data.FId <> ?");
            arr.add(info.getId().toString());
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])arr.toArray())).size() > 0) {
            try {
                while (rowSet.next()) {
                    if (rowSet.getString(1).toUpperCase().equals(info.getNumber().toUpperCase())) {
                        throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{rowSet.getString(1), rowSet.getString(3)});
                    }
                    if (!rowSet.getString(2).toUpperCase().equals(info.getName().toUpperCase())) continue;
                    throw new SundryException(SundryException.NAMEEXISTINORG, new Object[]{rowSet.getString(2), rowSet.getString(3)});
                }
            }
            catch (SQLException e) {
                Log.error((Object)"get result error", (Exception)e);
            }
        }
    }

    private void setInterSeq(Context ctx, IObjectValue model) throws BOSException {
        DataElementInfo info = (DataElementInfo)model;
        if (info.containsKey("interSeq") && info.isIsSys()) {
            return;
        }
        BigDecimal number = new BigDecimal("101");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Max(to_int(finterseq)) As Fmaxnumber From ");
        sql.append("T_CSL_DataElement");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber");
                number = number.compareTo(new BigDecimal(100.0)) > 0 ? number.add(new BigDecimal(1.0)) : new BigDecimal(101.0);
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        info.setInterSeq(number.intValue());
    }

    @Override
    protected DataElementInfo _getDataElementByInterSeq(Context ctx, int interSeq) throws EASBizException, BOSException {
        String sql = " where interSeq = " + interSeq;
        DataElementInfo info = (DataElementInfo)this.getValue(ctx, sql);
        return info;
    }

    @Override
    public DataElementCollection getDataElementCollection(Context ctx) throws BOSException {
        return this.sort(super.getDataElementCollection(ctx));
    }

    @Override
    public DataElementCollection getDataElementCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return this.sort(super.getDataElementCollection(ctx, view));
    }

    @Override
    public DataElementCollection getDataElementCollection(Context ctx, String oql) throws BOSException {
        return this.sort(super.getDataElementCollection(ctx, oql));
    }

    private DataElementCollection sort(DataElementCollection collection) {
        Object[] objs = collection.toArray();
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean isSys1 = ((DataElementInfo)o1).isIsSys();
                boolean isSys2 = ((DataElementInfo)o2).isIsSys();
                if (isSys1 && isSys2 || !isSys1 && !isSys2) {
                    String s1 = ((DataElementInfo)o1).getNumber();
                    String s2 = ((DataElementInfo)o2).getNumber();
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 != null && s2 != null) {
                        return s1.compareTo(s2);
                    }
                    return -1;
                }
                if (isSys1 && !isSys2) {
                    return -1;
                }
                return 1;
            }
        });
        collection.clear();
        for (int i = 0; i < objs.length; ++i) {
            collection.add((DataElementInfo)objs[i]);
        }
        return collection;
    }
}

