/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.DynItemFillSqlParse;
import com.kingdee.eas.fi.gr.cslrpt.app.DynaItemDataInterface;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynaItemFillDataByAcctCash
implements DynaItemDataInterface {
    private static Logger logger = Logger.getLogger(DynaItemFillDataByAcctCash.class);
    private Context ctx;
    private String dynItemSql;
    private String fieldHg;
    private List<FormulaFilterInfo> fourmulaFilterList;
    private CompanyOrgUnitInfo currentUnit;
    private boolean isIncludingUnposted = false;
    private String sameYear = null;
    private String sameStartPeriod = null;
    private String sameEndPeriod = null;
    private String sameCompanyId = null;
    private String sameCompanyNumber = null;
    private String sameCurrent = null;
    private boolean isHasCurrency = true;
    private boolean isSameYearPeriod = true;
    private boolean isSameUnit = true;
    private boolean isSameCurrency = true;
    private boolean isIncludeInit = false;
    private String tmpTable_name = null;
    private boolean isSameStartEndPeriod = true;
    private boolean isExecuteError = false;
    private Set<String> fillDataSet = new HashSet<String>();
    private Map<String, Set<String>> fillItemMap = null;
    private Exception exception = null;
    private boolean isGroupByFormulaId = false;
    private String filterSqls = null;
    private boolean isQueryOwnerComapany = false;
    private String attribute = null;

    public DynaItemFillDataByAcctCash(Context ctx, List<FormulaFilterInfo> fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, boolean isHasCurrency, boolean isIncludingUnposted) {
        this.ctx = ctx;
        this.fourmulaFilterList = fourmulaFilterList;
        this.dynItemSql = dynItemSql;
        this.fieldHg = fieldHg;
        this.currentUnit = currentUnit;
        this.isHasCurrency = isHasCurrency;
        this.isIncludingUnposted = isIncludingUnposted;
    }

    public DynaItemFillDataByAcctCash(Context ctx, List<FormulaFilterInfo> fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, boolean isHasCurrency, boolean isIncludingUnposted, String filterSqls, boolean isGroupByFormulaId) {
        this(ctx, fourmulaFilterList, dynItemSql, fieldHg, currentUnit, isHasCurrency, isIncludingUnposted);
        this.isGroupByFormulaId = isGroupByFormulaId;
        this.filterSqls = filterSqls;
    }

    public DynaItemFillDataByAcctCash(Context ctx, List<FormulaFilterInfo> fourmulaFilterList, String dynItemSql, String fieldHg, CompanyOrgUnitInfo currentUnit, boolean isHasCurrency, boolean isIncludingUnposted, String filterSqls, boolean isQueryOwnerCompany, String attribute) {
        this.isQueryOwnerComapany = isQueryOwnerCompany;
        this.attribute = attribute;
    }

    public void initProcess() throws EASBizException, BOSException {
        this.removeDup();
        this.createTmpTable();
    }

    @Override
    public void createFillDate() throws EASBizException, BOSException {
        try {
            if (this.isGroupByFormulaId || this.isQueryOwnerComapany) {
                this.getFillDataByFormulaGroup();
            } else {
                this.initProcess();
                this.getFillDate();
            }
        }
        catch (Exception e) {
            this.isExecuteError = true;
            this.exception = e;
            logger.error((Object)"createFillDate", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTable_name) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTable_name);
                this.tmpTable_name = null;
            }
        }
    }

    private SQLBuilder getSql() throws Exception {
        boolean isSqlNull = true;
        String bodySql = null;
        if (!StringUtils.isEmpty((String)this.dynItemSql)) {
            DynItemFillSqlParse sqlParse = new DynItemFillSqlParse(this.dynItemSql);
            sqlParse.parseSql();
            bodySql = sqlParse.getOtherExcludeorder();
            isSqlNull = StringUtils.isEmpty((String)bodySql);
        }
        SQLBuilder sql = new SQLBuilder();
        if (!isSqlNull) {
            sql.append("select distinct fillItemTbl.Id as ID from ( ");
            sql.append(bodySql);
            sql.append(") fillItemTbl ");
            sql.append("inner join ( \n");
        }
        if (this.isQueryOwnerComapany) {
            sql.append(" select distinct voucher.FCompanyID ").append(!isSqlNull ? " fid " : " ID ");
        } else {
            sql.append(" select distinct A_Hg.").append(this.fieldHg).append(!isSqlNull ? " fid " : " ID ");
        }
        if (this.isGroupByFormulaId || this.isQueryOwnerComapany) {
            sql.append(", filter.formulaId ");
        }
        sql.append(" from T_BD_AssistantHG A_Hg  \n");
        sql.append(" inner join T_GL_CashflowRecord Cash on Cash.fassgrpid = A_Hg.fid \n");
        sql.append(" inner join T_GL_Voucher voucher on Cash.FVoucherID = voucher.FID \n");
        if (this.isHasCurrency) {
            sql.append(" inner join T_GL_VoucherEntry ve on Cash.FEntryId = ve.FID and ve.FBillID = voucher.FID  \n");
            sql.append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID  \n");
        }
        sql.append(" inner join T_BD_Period period on period.FID = voucher.FPeriodID \n");
        sql.append(" inner join T_BD_CashFlowItem CashItem on (CashItem.ftype=0 and CashItem.FID = Cash.FPrimaryItemID ");
        sql.append(" or CashItem.ftype=1 and CashItem.FID = Cash.FSupplementaryItemID or CashItem.ftype=2 and CashItem.FID = Cash.FFullInfoItemID) \n");
        if (this.sameCompanyId == null) {
            sql.append(" inner join T_ORG_Company company on company.FID = voucher.FCompanyID \n");
        }
        sql.append(" inner join ").append(this.tmpTable_name).append(" filter on (CashItem.FIsleaf = 1 and CashItem.flongnumber like concat(filter.cashFlowNumber,'%')  ");
        if (!this.isSameYearPeriod) {
            if (this.isSameStartEndPeriod) {
                sql.append(" and period.FPeriodYear=filter.year and period.FPeriodNumber=filter.period ");
            } else {
                sql.append(" and period.FPeriodYear=filter.year and period.FPeriodNumber>=filter.startPeriod and period.FPeriodNumber<=filter.endPeriod ");
            }
        }
        if (this.isHasCurrency && !this.isSameCurrency) {
            sql.append(" and filter.currency=Currency.fnumber ");
        }
        if (!this.isSameUnit) {
            sql.append(" and filter.companyNumber=company.fnumber ");
        }
        sql.append(") Where voucher.FBizStatus <> 0 and voucher.FBizStatus <> 2 \n");
        if (!StringUtils.isEmpty((String)this.filterSqls)) {
            sql.append(" and A_Hg.").append(this.fieldHg).append(" in(").append(this.filterSqls).append(") ");
        }
        if (!this.isIncludingUnposted) {
            sql.append(" and voucher.FBizStatus = 5 \n");
        }
        if (this.isQueryOwnerComapany) {
            if (this.sameCompanyId != null) {
                if (this.attribute.equals("customer")) {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Customer Where FInternalCompanyID = '").append(this.sameCompanyId).append("') \n");
                } else if (this.attribute.equals("provider")) {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Supplier Where FInternalCompanyID = '").append(this.sameCompanyId).append("') \n");
                } else {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = '").append(this.sameCompanyId).append("' \n");
                }
            } else if (this.isSameUnit) {
                if (this.attribute.equals("customer")) {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                    sql.append(" = (Select cust.fid from T_BD_Customer cust ");
                    sql.append(" Inner Join T_ORG_Company com On cust.FInternalCompanyID = com.Fid ");
                    sql.append(" Where com.FNumber = '").append(this.sameCompanyNumber).append("') \n");
                } else if (this.attribute.equals("provider")) {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                    sql.append(" = (Select cust.fid from T_BD_Supplier supp ");
                    sql.append(" Inner Join T_ORG_Company com On supp.FInternalCompanyID = com.Fid ");
                    sql.append(" Where com.FNumber = '").append(this.sameCompanyNumber).append("') \n");
                } else {
                    sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                    sql.append(" = (").append("Select Fid From T_ORG_Company Where FNumber = '").append(this.sameCompanyNumber).append("') \n");
                }
            }
        } else if (this.sameCompanyId != null) {
            sql.append(" and voucher.FCompanyID=? ", (Object)this.sameCompanyId);
        } else if (this.isSameUnit) {
            sql.append(" and company.fnumber=? ", (Object)this.sameCompanyNumber);
        }
        if (this.isSameYearPeriod) {
            if (this.isSameStartEndPeriod) {
                sql.append(" and period.FPeriodYear=? ", (Object)Integer.valueOf(this.sameYear)).append(" and period.FPeriodNumber=? ", (Object)Integer.valueOf(this.sameStartPeriod));
            } else {
                sql.append(" and period.FPeriodYear=? ", (Object)Integer.valueOf(this.sameYear)).append(" and period.FPeriodNumber>=? ", (Object)Integer.valueOf(this.sameStartPeriod));
                sql.append(" and period.FPeriodNumber<=? ", (Object)Integer.valueOf(this.sameEndPeriod));
            }
        }
        if (this.isHasCurrency && this.isSameCurrency) {
            sql.append(" and Currency.fnumber=? ", (Object)this.sameCurrent);
        }
        if (this.isIncludeInit) {
            sql.append(" union ");
            if (this.isQueryOwnerComapany) {
                sql.append(" select distinct Init.FCompanyID ").append(!isSqlNull ? " fid " : " ID ");
            } else {
                sql.append(" select distinct A_Hg.").append(this.fieldHg).append(!isSqlNull ? " fid " : " ID ");
            }
            if (this.isGroupByFormulaId || this.isQueryOwnerComapany) {
                sql.append(", filter.formulaId ");
            }
            sql.append(" from T_BD_AssistantHG A_Hg  \n");
            sql.append(" inner join T_GL_CashflowGrpAsst CashAsst on CashAsst.FAssistGrpID = A_Hg.fid  \n");
            sql.append(" inner join T_GL_CashFlowInit Init on CashAsst.FCflowInitID = Init.FID  \n");
            sql.append(" inner join T_BD_CashFlowItem CashItem on Init.FCashflowItemID = CashItem.FID  \n");
            if (this.isHasCurrency) {
                sql.append(" inner join T_BD_Currency Currency on Init.FCurrencyID = Currency.FID  \n");
            }
            if (this.sameCompanyId == null) {
                sql.append(" inner join T_ORG_Company company on company.FID = Init.FCompanyID  \n");
            }
            sql.append(" inner join ").append(this.tmpTable_name).append(" filter on (CashItem.FIsleaf = 1 and CashItem.flongnumber like concat(filter.cashFlowNumber,'%')  ");
            if (this.isHasCurrency && !this.isSameCurrency) {
                sql.append(" and filter.currency=Currency.fnumber ");
            }
            if (!this.isSameUnit) {
                sql.append(" and filter.companyNumber=company.fnumber ");
            }
            sql.append(") Where 1=1 \n");
            if (!StringUtils.isEmpty((String)this.filterSqls)) {
                sql.append(" and A_Hg.").append(this.fieldHg).append(" in(").append(this.filterSqls).append(") ");
            }
            if (this.isQueryOwnerComapany) {
                if (this.sameCompanyId != null) {
                    if (this.attribute.equals("customer")) {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Customer Where FInternalCompanyID = '").append(this.sameCompanyId).append("') \n");
                    } else if (this.attribute.equals("provider")) {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = (Select fid from T_BD_Supplier Where FInternalCompanyID = '").append(this.sameCompanyId).append("') \n");
                    } else {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg).append(" = '").append(this.sameCompanyId).append("' \n");
                    }
                } else if (this.isSameUnit) {
                    if (this.attribute.equals("customer")) {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                        sql.append(" = (Select cust.fid from T_BD_Customer cust ");
                        sql.append(" Inner Join T_ORG_Company com On cust.FInternalCompanyID = com.Fid ");
                        sql.append(" Where com.FNumber = '").append(this.sameCompanyNumber).append("') \n");
                    } else if (this.attribute.equals("provider")) {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                        sql.append(" = (Select cust.fid from T_BD_Supplier supp ");
                        sql.append(" Inner Join T_ORG_Company com On supp.FInternalCompanyID = com.Fid ");
                        sql.append(" Where com.FNumber = '").append(this.sameCompanyNumber).append("') \n");
                    } else {
                        sql.append(" and ").append(" A_Hg.").append(this.fieldHg);
                        sql.append(" = (").append("Select Fid From T_ORG_Company Where FNumber = '").append(this.sameCompanyNumber).append("') \n");
                    }
                }
            } else if (this.sameCompanyId != null) {
                sql.append(" and Init.FCompanyID=? ", (Object)this.sameCompanyId);
            } else if (this.isSameUnit) {
                sql.append(" and company.fnumber=? ", (Object)this.sameCompanyNumber);
            }
            if (this.isHasCurrency && this.isSameCurrency) {
                sql.append(" and Currency.fnumber=? ", (Object)this.sameCurrent);
            }
        }
        if (!isSqlNull) {
            sql.append(") fillDateId on fillDateId.fid=fillItemTbl.id ");
        }
        return sql;
    }

    private void getFillDate() throws Exception {
        SQLBuilder sql = this.getSql();
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        if (rowSet != null) {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("ID"))) continue;
                this.fillDataSet.add(rowSet.getString("ID"));
            }
        }
    }

    public Map<String, Set<String>> getFillDataByFormulaGroup() throws Exception {
        try {
            this.initProcess();
            SQLBuilder sql = this.getSql();
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            if (rowSet != null) {
                this.fillItemMap = new HashMap<String, Set<String>>();
                while (rowSet.next()) {
                    String id = rowSet.getString("ID");
                    String formulaId = rowSet.getString("formulaId");
                    if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)formulaId)) continue;
                    Set<String> ids = this.fillItemMap.get(formulaId);
                    if (ids == null) {
                        ids = new HashSet<String>();
                        this.fillItemMap.put(formulaId, ids);
                    }
                    ids.add(id);
                }
                Map<String, Set<String>> map = this.fillItemMap;
                return map;
            }
        }
        catch (Exception e) {
            this.isExecuteError = true;
            this.exception = e;
            logger.error((Object)"createFillDate", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTable_name) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTable_name);
                this.tmpTable_name = null;
            }
        }
        return null;
    }

    private void createTmpTable() throws EASBizException, BOSException {
        if (this.fourmulaFilterList != null && !this.fourmulaFilterList.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            StringBuffer fields = new StringBuffer();
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            sql.append("create table t_csl_FormulFilter(cashFlowNumber NVARCHAR(200)");
            fields.append("cashFlowNumber");
            if (!this.isSameUnit) {
                sql.append(",companyNumber VARCHAR(44)");
                fields.append(",companyNumber");
            }
            if (this.isHasCurrency && !this.isSameCurrency) {
                sql.append(",currency VARCHAR(44)");
                fields.append(",currency");
            }
            if (!this.isSameYearPeriod) {
                if (this.isSameStartEndPeriod) {
                    sql.append(",year int,period int");
                    fields.append(",year,period");
                } else {
                    sql.append(",year int,startPeriod int,endPeriod int");
                    fields.append(",year,startPeriod,endPeriod");
                }
            }
            if (this.isGroupByFormulaId || this.isQueryOwnerComapany) {
                sql.append(",formulaId VARCHAR(100)");
                fields.append(",formulaId");
            }
            sql.append(")");
            try {
                this.tmpTable_name = pool.createTempTable(sql.toString());
                sql.setLength(0);
                sql.append("insert into ").append(this.tmpTable_name).append("(").append(fields).append(")");
                sql.append(" values(");
                int fieldLength = fields.toString().split(",").length;
                for (int i = 0; i < fieldLength; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                }
                sql.append(")");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                Object[] param = null;
                int index = 0;
                HashSet<String> numberSet = new HashSet<String>();
                HashMap<String, String> longNumberMap = new HashMap<String, String>();
                for (FormulaFilterInfo filterInfo : this.fourmulaFilterList) {
                    numberSet.add(filterInfo.getCashFlowNumber());
                }
                String searchLongNumberSql = "select flongNumber,fnumber from T_BD_CashFLowItem where fnumber in (" + CslRptUtil.collection2String(numberSet, ",", true) + ")";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)searchLongNumberSql.toString());
                if (rowSet != null) {
                    while (rowSet.next()) {
                        String longNumber = rowSet.getString("flongNumber");
                        String number = rowSet.getString("fnumber");
                        if (StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)number)) continue;
                        longNumberMap.put(number, longNumber);
                    }
                }
                for (FormulaFilterInfo filterInfo : this.fourmulaFilterList) {
                    index = 0;
                    param = new Object[fieldLength];
                    param[index++] = longNumberMap.get(filterInfo.getCashFlowNumber());
                    if (!this.isSameUnit) {
                        param[index++] = filterInfo.getCompanyNumber();
                    }
                    if (this.isHasCurrency && !this.isSameCurrency) {
                        param[index++] = filterInfo.getCurrency();
                    }
                    if (!this.isSameYearPeriod) {
                        param[index++] = filterInfo.getStartYear();
                        param[index++] = filterInfo.getStartPeriod();
                        if (!this.isSameStartEndPeriod) {
                            param[index++] = filterInfo.getEndPeriod();
                        }
                    }
                    if (this.isGroupByFormulaId || this.isQueryOwnerComapany) {
                        param[index++] = filterInfo.getFormulaId();
                    }
                    params.add(param);
                }
                if (!params.isEmpty()) {
                    DbUtil.executeBatch((Context)this.ctx, (String)sql.toString(), params);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void removeDup() {
        if (this.fourmulaFilterList != null) {
            HashSet<FormulaFilterInfo> tmpFilterSet = new HashSet<FormulaFilterInfo>();
            for (FormulaFilterInfo filterInfo : this.fourmulaFilterList) {
                if (this.sameCurrent == null) {
                    this.sameCurrent = filterInfo.getCurrency();
                } else if (!this.sameCurrent.equals(filterInfo.getCurrency())) {
                    this.isSameCurrency = false;
                }
                if (this.sameYear == null) {
                    this.sameYear = filterInfo.getStartYear();
                } else if (!this.sameYear.equals(filterInfo.getStartYear())) {
                    this.isSameYearPeriod = false;
                }
                if (this.sameStartPeriod == null) {
                    this.sameStartPeriod = filterInfo.getStartPeriod();
                } else if (!this.sameStartPeriod.equals(filterInfo.getStartPeriod())) {
                    this.isSameYearPeriod = false;
                }
                if (this.sameEndPeriod == null) {
                    this.sameEndPeriod = filterInfo.getEndPeriod();
                } else if (!this.sameEndPeriod.equals(filterInfo.getEndPeriod())) {
                    this.isSameYearPeriod = false;
                }
                if (!filterInfo.getStartPeriod().equals(filterInfo.getEndPeriod())) {
                    this.isSameStartEndPeriod = false;
                }
                if (this.sameCompanyNumber == null) {
                    this.sameCompanyNumber = filterInfo.getCompanyNumber();
                } else if (!this.sameCompanyNumber.equals(filterInfo.getCompanyNumber())) {
                    this.isSameUnit = false;
                }
                if (filterInfo.getStartPeriod().trim().equals("1")) {
                    this.isIncludeInit = true;
                }
                if (this.isGroupByFormulaId && this.isQueryOwnerComapany) continue;
                tmpFilterSet.add(filterInfo);
            }
            if (this.isSameUnit && this.sameCompanyNumber.equals(this.currentUnit.getNumber())) {
                this.sameCompanyId = this.currentUnit.getId().toString();
            }
            if (this.isSameYearPeriod && !this.sameStartPeriod.equals(this.sameEndPeriod)) {
                this.isSameStartEndPeriod = false;
            }
            if (!this.isGroupByFormulaId || !this.isQueryOwnerComapany) {
                this.fourmulaFilterList.clear();
                this.fourmulaFilterList.addAll(tmpFilterSet);
                tmpFilterSet.clear();
            }
        }
    }

    @Override
    public Set<String> getFillItemSet() {
        return this.fillDataSet;
    }

    @Override
    public Map<String, Set<String>> getFillItemMap() {
        return this.fillItemMap;
    }

    @Override
    public boolean isExecuteError() {
        return this.isExecuteError;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public boolean isQueryOwnerComapany() {
        return this.isQueryOwnerComapany;
    }

    public void setQueryOwnerComapany(boolean isQueryOwnerComapany) {
        this.isQueryOwnerComapany = isQueryOwnerComapany;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }
}

