/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRateEntry;
import com.kingdee.eas.fi.gr.cslrpt.IInvestTemplet;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractElimInvestRateControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CalculateEquivShareRateHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.ElimInvestRateGenerateHandle;
import com.kingdee.eas.fi.gr.cslrpt.app.GenerateElimInvestRateInDirectHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ElimInvestRateControllerBean
extends AbstractElimInvestRateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ElimInvestRateControllerBean");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private List getOriginalTemplateNumListById(Context ctx, String id) throws BOSException, EASBizException {
        IElimInvestRate IElimInvestRate2 = ElimInvestRateFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ElimInvestRateInfo elimInvestRateInfo = IElimInvestRate2.getElimInvestRateInfo((IObjectPK)pk);
        List originalList = this.split(elimInvestRateInfo.getTemplate());
        return originalList;
    }

    private Set getOriginalIdSet(Context ctx, Date reportDate, String orgBoundId, String targetCompanyId, int rptPeriod, RptPeriodTypeEnum rptPeriodType, String orgUnitId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgBoundId));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("targetCompany", (Object)targetCompanyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)reportDate));
        if (rptPeriodType != null && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(rptPeriod)));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("islatest", (Object)new Integer(1)));
        IObjectPK[] list = this.getPKList(ctx, filterInfo, new SorterItemCollection());
        HashSet<String> originalIdSet = new HashSet<String>();
        for (int i = 0; i < list.length; ++i) {
            originalIdSet.add(list[i].toString());
        }
        return originalIdSet;
    }

    private void saveTemplate(Context ctx, ElimInvestRateInfo elimInvestRate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)elimInvestRate.getTemplate())) {
            return;
        }
        List tmp = this.split(elimInvestRate.getTemplate());
        IElimInvestRateEntry iElimInvestRateEntry = ElimInvestRateEntryFactory.getLocalInstance(ctx);
        for (String tempNum : tmp) {
            InvestTempletInfo tmpInfo = this.getTemplateByNumber(ctx, tempNum);
            ElimInvestRateEntryInfo entry = new ElimInvestRateEntryInfo();
            entry.setInvestTemplate(tmpInfo);
            entry.setElimInvestRate(elimInvestRate);
            iElimInvestRateEntry.addnew(entry);
        }
    }

    private void updateTemplate(Context ctx, ElimInvestRateInfo elimInvestRate) throws BOSException, EASBizException {
        IElimInvestRateEntry iElimInvestRateEntry = ElimInvestRateEntryFactory.getLocalInstance(ctx);
        String elimInvestRateId = elimInvestRate.getId().toString();
        List originalList = this.getOriginalTemplateNumListById(ctx, elimInvestRateId);
        List list = this.split(elimInvestRate.getTemplate());
        if (list != null) {
            for (String templateNum : list) {
                if (originalList == null || !originalList.contains(templateNum)) {
                    InvestTempletInfo tmpInfo = this.getTemplateByNumber(ctx, templateNum);
                    ElimInvestRateEntryInfo entry = new ElimInvestRateEntryInfo();
                    entry.setInvestTemplate(tmpInfo);
                    entry.setElimInvestRate(elimInvestRate);
                    iElimInvestRateEntry.addnew(entry);
                    continue;
                }
                originalList.remove(templateNum);
            }
        }
        if (originalList != null && originalList.size() > 0) {
            for (String num : originalList) {
                InvestTempletInfo investTempletInfo = this.getTemplateByNumber(ctx, num);
                if (investTempletInfo == null) continue;
                String investTempletId = investTempletInfo.getId().toString();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("investTemplate", (Object)investTempletId));
                filterInfo.getFilterItems().add(new FilterItemInfo("elimInvestRate", (Object)elimInvestRateId));
                iElimInvestRateEntry.delete(filterInfo);
            }
        }
    }

    private void deleteTemplateByElimInvestRateId(Context ctx, Set elimInvestRateIdSet) throws BOSException, EASBizException {
        IElimInvestRateEntry iElimInvestRateEntry = ElimInvestRateEntryFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("elimInvestRate", (Object)elimInvestRateIdSet, CompareType.INCLUDE));
        iElimInvestRateEntry.delete(filterInfo);
    }

    private List split(String template) {
        ArrayList<String> tempList = new ArrayList<String>();
        if (null == template) {
            return null;
        }
        String[] templateIds = template.split(",");
        for (int i = 0; i < templateIds.length; ++i) {
            if (templateIds[i] == null || tempList.contains(templateIds[i])) continue;
            tempList.add(templateIds[i]);
        }
        return tempList;
    }

    private InvestTempletInfo getTemplateByNumber(Context ctx, String number) throws BOSException, EASBizException {
        IInvestTemplet iInvestTemplet = InvestTempletFactory.getLocalInstance(ctx);
        InvestTempletCollection tmpIColl = iInvestTemplet.getInvestTempletCollection("where number = '" + number + "'");
        if (tmpIColl != null && tmpIColl.size() > 0) {
            return tmpIColl.get(0);
        }
        return null;
    }

    private FullOrgUnitInfo getTopUnit(Context ctx, OrgTreeInfo orgBound) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection col = iStruct.getOrgStructureCollection("select id, unit.*,unit.partUnionGroup.* where parent = null and tree.id = '" + orgBound.getId().toString() + "'");
        if (null == col || 0 == col.size()) {
            return null;
        }
        OrgStructureInfo structureInfo = col.get(0);
        FullOrgUnitInfo unit = structureInfo.getUnit();
        return unit;
    }

    private String getOrgUnitLongNumber(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit) throws BOSException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgBound.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnit.getId().toString()));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(view);
        if (null != structCol && structCol.size() > 0) {
            return structCol.get(0).getLongNumber();
        }
        return orgUnit.getLongNumber();
    }

    private void generateRelationByOrdinal(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, Date reportDate, Map investRelation) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" SELECT DISTINCT RELA.FSHAREHOLDERID,       \n").append(" RELA.FINVESTEECOMPANYID,                            \n").append(" RELA.FSHARESCALE,                                   \n").append(" RELA.FCHANGEDATE,                                   \n").append(" RELA.FISLATEST,                                     \n").append(" STRUCT.FLONGNUMBER AS SHAREHOLDERNUM,               \n").append(" (SELECT STRUCT1.FLONGNUMBER                         \n").append(" FROM T_ORG_TREE TREE1                               \n").append(" JOIN T_ORG_STRUCTURE STRUCT1 ON                     \n").append(" TREE1.FID = STRUCT1.FTREEID JOIN                    \n").append(" T_ORG_BASEUNIT BASEUNIT1 ON                         \n").append(" BASEUNIT1.FID = STRUCT1.FUNITID                     \n").append(" WHERE TREE1.FTYPE = 8                               \n").append(" AND TREE1.FID = TREE.FID AND                        \n").append(" BASEUNIT1.FID = RELA.FINVESTEECOMPANYID)            \n").append(" AS INVESTEECOMPANYNUM                               \n").append(" FROM T_ORG_TREE TREE                                \n").append(" JOIN T_ORG_STRUCTURE STRUCT ON                      \n").append(" TREE.FID = STRUCT.FTREEID JOIN                      \n").append(" T_ORG_BASEUNIT BASEUNIT ON                          \n").append(" BASEUNIT.FID = STRUCT.FUNITID JOIN                  \n").append(" T_CSL_SHARERELA RELA                                \n").append(" ON RELA.FSHAREHOLDERID = BASEUNIT.FID               \n").append(" WHERE TREE.FTYPE = 8                                \n").append(" AND TREE.FID = ?                                    \n").append(" AND STRUCT.FLONGNUMBER LIKE ?                       \n").append(" AND RELA.FCHANGEDATE <= ?                           \n").append(" ORDER BY INVESTEECOMPANYNUM,SHAREHOLDERNUM,         \n").append(" RELA.FCHANGEDATE DESC                               \n");
        String orgUnitLongNumber = this.getOrgUnitLongNumber(ctx, orgBound, orgUnit);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{orgBound.getId().toString(), orgUnitLongNumber + "!%", new Timestamp(reportDate.getTime())});
        HashMap<String, ElimInvestRateInfo> monthLatestMap = new HashMap<String, ElimInvestRateInfo>();
        HashMap<String, ElimInvestRateInfo> latestMap = new HashMap<String, ElimInvestRateInfo>();
        Calendar calendar = Calendar.getInstance();
        try {
            while (rowSet.next()) {
                String investeeCompanyNum = rowSet.getString("INVESTEECOMPANYNUM");
                if (null == investeeCompanyNum) continue;
                String shareHolder = rowSet.getString("FSHAREHOLDERID");
                String investeeCompany = rowSet.getString("FINVESTEECOMPANYID");
                BigDecimal shareScale = rowSet.getBigDecimal("FSHARESCALE");
                java.sql.Date changeDate = rowSet.getDate("FCHANGEDATE");
                String shareHolderlongNum = rowSet.getString("SHAREHOLDERNUM");
                String investRelationOrgUnitLongNumber = this.getInvestRelationOrgUnitLongNumber(shareHolderlongNum, investeeCompanyNum);
                if (!investRelationOrgUnitLongNumber.equals(orgUnitLongNumber)) continue;
                ElimInvestRateInfo elimInvestRate = new ElimInvestRateInfo();
                FullOrgUnitInfo targetCompany = new FullOrgUnitInfo();
                targetCompany.setId(BOSUuid.read((String)investeeCompany));
                elimInvestRate.setTargetCompany(targetCompany);
                FullOrgUnitInfo company = new FullOrgUnitInfo();
                company.setId(BOSUuid.read((String)shareHolder));
                elimInvestRate.setCompany(company);
                elimInvestRate.setRate(shareScale);
                elimInvestRate.setDate(changeDate);
                if (latestMap.get(shareHolder + "@" + investeeCompany) == null) {
                    elimInvestRate.setIsLatest(true);
                    latestMap.put(shareHolder + "@" + investeeCompany, elimInvestRate);
                } else {
                    elimInvestRate.setIsLatest(false);
                }
                calendar.setTime(changeDate);
                int year = calendar.get(1);
                int month = calendar.get(2);
                if (monthLatestMap.get(shareHolder + "@" + investeeCompany + year + month) == null) {
                    elimInvestRate.setIsMonthLatest(true);
                    monthLatestMap.put(shareHolder + "@" + investeeCompany + year + month, elimInvestRate);
                } else {
                    elimInvestRate.setIsMonthLatest(false);
                }
                investRelation.put(shareHolder + "@" + investeeCompany + ((Date)changeDate).toString(), elimInvestRate);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getInvestRelationOrgUnitLongNumber(String shareHolderlongNum, String investeeCompanyNum) {
        String[] investeeCompanyNums;
        String[] shareHolderlongNums = shareHolderlongNum.split("!");
        int length = shareHolderlongNums.length > (investeeCompanyNums = investeeCompanyNum.split("!")).length ? investeeCompanyNums.length : shareHolderlongNums.length;
        StringBuffer longNumber = new StringBuffer();
        for (int i = 0; i < length && shareHolderlongNums[i].equals(investeeCompanyNums[i]); ++i) {
            longNumber.append(shareHolderlongNums[i]);
            longNumber.append("!");
        }
        if (longNumber.length() > 0) {
            return longNumber.substring(0, longNumber.length() - 1);
        }
        return longNumber.toString();
    }

    private List getDateOfId(Context ctx, Map param) throws BOSException {
        Boolean isFirst = (Boolean)param.get("isFirst");
        Integer length = (Integer)param.get("length");
        OrgTreeInfo orgBound = (OrgTreeInfo)param.get("orgBound");
        Date reportDate = (Date)param.get("reportDate");
        OrgUnitInfo orgUnit = (OrgUnitInfo)param.get("orgUnit");
        Boolean isLatest = (Boolean)param.get("islatest");
        int top = length != null ? length : 100;
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" SELECT     \n");
        if (isFirst != null) {
            kqlBuffer.append(" TOP " + top);
        }
        kqlBuffer.append(" ElimInvestRate.FID     \n").append(" FROM T_CSL_ELIMINVESTRATE  ELIMINVESTRATE JOIN  \n").append(" (SELECT MAX(ELIMINVESTRATE.FRPTDATE) RPTDATE,   \n").append(" ELIMINVESTRATE.FTARGETCOMPANY TARGETCOMPANY,    \n").append(" ELIMINVESTRATE.FCOMPANY COMPANY                 \n").append(" FROM T_CSL_ELIMINVESTRATE  ELIMINVESTRATE       \n").append(" WHERE ELIMINVESTRATE.FRPTDATE <= ?              \n").append(" AND ELIMINVESTRATE.FORGBOUNDID = ?              \n").append(" AND ELIMINVESTRATE.FORGUNIT = ?                 \n").append(" GROUP BY ELIMINVESTRATE.FTARGETCOMPANY,         \n").append(" ELIMINVESTRATE.FCOMPANY) ELIMINVESTRATE1        \n").append(" ON ELIMINVESTRATE.FTARGETCOMPANY =              \n").append(" ELIMINVESTRATE1.TARGETCOMPANY                   \n").append(" AND ELIMINVESTRATE.FCOMPANY =                   \n").append(" ELIMINVESTRATE1.COMPANY                         \n").append(" AND ELIMINVESTRATE.FRPTDATE =                   \n").append(" ELIMINVESTRATE1.RPTDATE                         \n").append(" WHERE ELIMINVESTRATE.FORGBOUNDID = ?            \n").append(" AND ELIMINVESTRATE.FORGUNIT = ?                 \n");
        if (isLatest != null) {
            kqlBuffer.append(" AND ELIMINVESTRATE.FISLATEST = 1            \n");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{new Timestamp(reportDate.getTime()), orgBound.getId().toString(), orgUnit.getId().toString(), orgBound.getId().toString(), orgUnit.getId().toString()});
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                idList.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return idList;
    }

    private void saveInvestRelation(Context ctx, Map param, Map investRelation, Map tmpRelation, Set directRelation) throws EASBizException, BOSException {
        OrgUnitInfo orgUnit = (OrgUnitInfo)param.get("orgUnit");
        if (null == tmpRelation && investRelation.size() == 0 || 0 == investRelation.size() && 0 == directRelation.size() && 0 == tmpRelation.size()) {
            throw new ReportException(ReportException.INVEST_RELATION_NULL, new Object[]{orgUnit.getName()});
        }
        MergeModeEnum mergeMode = (MergeModeEnum)((Object)param.get("MergeMode"));
        ElimInvestRateGenerateHandle handle = new ElimInvestRateGenerateHandle(ctx, param, investRelation, mergeMode);
        handle.sortElimInvestRateOprt();
        handle.generateElimRateRecords();
        handle.clear();
    }

    private void checkExistSameInvestOnOrgBound(Context ctx, ElimInvestRateInfo ElimInvestRate2) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)ElimInvestRate2.getOrgBound().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(ElimInvestRate2.getRptDate().getTime())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(ElimInvestRate2.getPeriod())));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)new Timestamp(ElimInvestRate2.getDate().getTime())));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ElimInvestRate2.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("targetCompany.id", (Object)ElimInvestRate2.getTargetCompany().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add("company.id");
        selectorItemCollection.add("company.name");
        selectorItemCollection.add("targetCompany.id");
        selectorItemCollection.add("targetCompany.name");
        selectorItemCollection.add("orgBound.id");
        selectorItemCollection.add("orgBound.name");
        selectorItemCollection.add("orgUnit.id");
        selectorItemCollection.add("orgUnit.name");
        view.setFilter(filter);
        view.setSelector(selectorItemCollection);
        ElimInvestRateCollection elimInvestRateCollection = this.getElimInvestRateCollection(ctx, view);
        if (elimInvestRateCollection.size() > 0) {
            ElimInvestRateInfo elimInvestRate = elimInvestRateCollection.get(0);
            throw new InvestCheckException(InvestCheckException.EXISTS_SAME_INVEST, new Object[]{elimInvestRate.getOrgBound(), elimInvestRate.getOrgUnit(), elimInvestRate.getCompany(), elimInvestRate.getTargetCompany()});
        }
    }

    private List getUpdateTargetCompayList(Context ctx, List selectIdList) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        ArrayList<String> targetCompanyList = new ArrayList<String>();
        kqlBuffer.append(" SELECT DISTINCT FTARGETCOMPANY            \n");
        kqlBuffer.append(" FROM T_CSL_ELIMINVESTRATE WHERE FID IN (  \n");
        kqlBuffer.append(this.buildInQueryString(selectIdList));
        kqlBuffer.append(" )");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString());
            while (rowSet.next()) {
                String targetCompany = rowSet.getString("FTARGETCOMPANY");
                if (null == targetCompany || 0 == targetCompany.length()) continue;
                targetCompanyList.add(targetCompany);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return targetCompanyList;
    }

    private void updateElimInvestRateLatest(Context ctx, String orgBoundId, String orgUnit_targcompanyTable, Date reportDate, int rptPeriod, RptPeriodTypeEnum rptPeriodType) throws BOSException {
        Timestamp rptDate = new Timestamp(reportDate.getTime());
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" UPDATE T_CSL_ELIMINVESTRATE            \n").append(" SET FISLATEST = 1,FIsMonthLatest = 1            \n").append(" WHERE FID IN                                    \n").append(" (SELECT ELIMINVESTRATE.FID                      \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATE JOIN   \n").append(" (SELECT MAX(FDATE) FDATE,FCOMPANY COMPANY,FTARGETCOMPANY TARGETCOMPANY  \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATE2,       \n").append(orgUnit_targcompanyTable).append(" company \n").append(" WHERE ELIMINVESTRATE2.FORGBOUNDID = ?            \n").append(" AND ELIMINVESTRATE2.FORGUNIT =company.forgunitid \n").append(" AND ELIMINVESTRATE2.FTARGETCOMPANY=company.fcompanyid  \n").append(" AND ELIMINVESTRATE2.FRPTDATE = ?               \n");
        if (rptPeriodType != null && rptPeriod != 0 && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            kqlBuffer.append("  AND ELIMINVESTRATE2.FPeriod =").append(new Integer(rptPeriod));
        }
        kqlBuffer.append(" GROUP BY ELIMINVESTRATE2.FCOMPANY,ELIMINVESTRATE2.FtargetCOMPANY)         \n").append(" ELIMINVESTRATE1 ON ELIMINVESTRATE.FDATE =       \n").append(" ELIMINVESTRATE1.FDATE                           \n").append(" AND ELIMINVESTRATE.FCOMPANY =                   \n").append(" ELIMINVESTRATE1.COMPANY                         \n").append(" AND ELIMINVESTRATE.FTARGETCOMPANY =             \n").append(" ELIMINVESTRATE1.TARGETCOMPANY                   \n").append(" join ").append(orgUnit_targcompanyTable).append(" \n").append(" company2 ON ELIMINVESTRATE.FORGUNIT = company2.forgunitid \n").append(" and ELIMINVESTRATE.FTARGETCOMPANY = company2.fcompanyid \n").append(" WHERE ELIMINVESTRATE.FORGBOUNDID = ?            \n").append(" AND ELIMINVESTRATE.FRPTDATE = ? \t\t\t\t  \n");
        if (rptPeriodType != null && rptPeriod != 0 && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            kqlBuffer.append("  AND ELIMINVESTRATE.FPeriod =").append(new Integer(rptPeriod));
        }
        kqlBuffer.append(" )");
        DbUtil.execute((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{orgBoundId, rptDate, orgBoundId, rptDate});
    }

    private void deleteElimInvestRateByRptDate(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, Date rptDate, RptPeriodTypeEnum rptPeriodType, int rptPeriod) throws EASBizException, BOSException {
        this.deleteElimInvestRateEntryByDate(ctx, orgBound, orgUnit, rptDate, rptPeriodType, rptPeriod);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(rptDate.getTime())));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgBound.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString()));
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(rptPeriod)));
        }
        this.delete(ctx, filterInfo);
    }

    private void deleteElimInvestRateEntryByDate(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, Date rptDate, RptPeriodTypeEnum rptPeriodType, int rptPeriod) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" DELETE FROM T_CSL_ELIMINVESTRATEENTRY     \n").append(" WHERE FELIMINVESTRATE IN (                         \n").append(" SELECT FID FROM T_CSL_ELIMINVESTRATE               \n").append(" WHERE FORGBOUNDID = ?                              \n").append(" AND FORGUNIT = ?                                   \n").append(" AND FRPTDATE = ?                                   \n");
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            kqlBuffer.append(" AND FPERIOD =").append(rptPeriod).append(" \n");
        }
        kqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{orgBound.getId().toString(), orgUnit.getId().toString(), new Timestamp(rptDate.getTime())});
    }

    private String buildInQueryString(List list) {
        StringBuffer inString = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                inString.append(",");
            }
            inString.append("'");
            inString.append(list.get(i));
            inString.append("'");
        }
        return inString.toString();
    }

    private Date getCopyElimInvestRateMaxMonth(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, Date reportDate, int rptYear, int period, RptPeriodTypeEnum rptPeriodType) throws BOSException {
        SQLBuilder builder = new SQLBuilder();
        builder.append(" SELECT MAX(FRPTDATE) FRPTDATE                        \n");
        builder.append("   FROM T_CSL_ELIMINVESTRATE RATE                       \n");
        builder.append("   JOIN T_ORG_TREE TREE ON RATE.FORGBOUNDID = TREE.FID  \n");
        builder.append("   JOIN T_ORG_BASEUNIT UNIT ON RATE.fORGUNIT = UNIT.FID \n");
        builder.append("  WHERE TREE.FNUMBER = ?\n", (Object)orgBound.getNumber());
        builder.append("    AND UNIT.FNUMBER = ?\n", (Object)orgUnit.getNumber());
        builder.append("    AND RATE.FRPTDATE <= ?\n", (Object)new Timestamp(reportDate.getTime()));
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
            builder.append(" AND ((RATE.FYear = ?", (Object)rptYear).append(" And RATE.Fperiod <=?", (Object)period).append(")");
            builder.append("  OR (RATE.Fyear <?", (Object)rptYear).append("))");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        java.sql.Date date = null;
        try {
            while (rowSet.next()) {
                date = rowSet.getDate("FRPTDATE");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return date;
    }

    private Object[] getCopyElimInvestRateInfo(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, Date prePeriodLastDay, int preYear, int prePeriod, RptPeriodTypeEnum rptPeriodType) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" SELECT RATE.FRPTDATE FRPTDATE, RATE.Fyear Fyear,RATE.Fperiod Fperiod,     \n").append(" RATE.FORGBOUNDID FORGBOUNDID FROM T_CSL_ELIMINVESTRATE RATE                        \n").append(" JOIN T_ORG_TREE TREE ON RATE.FORGBOUNDID = TREE.FID       \n").append(" JOIN T_ORG_BASEUNIT UNIT ON RATE.fORGUNIT = UNIT.FID      \n").append(" WHERE TREE.FNUMBER = ?           \n").append(" AND UNIT.FNUMBER = ?    AND RATE.FRPTDATE <= ?            \n").append(" AND RATE.FperiodType = ? AND (                            \n").append(" (RATE.Fyear = ? And RATE.Fperiod <=?) or (RATE.Fyear <?)  \n").append(" ) order by FRPTDATE desc,fperiod desc ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{orgBound.getNumber(), orgUnit.getNumber(), new Timestamp(prePeriodLastDay.getTime()), new Integer(rptPeriodType.getValue()), new Integer(preYear), new Integer(prePeriod), new Integer(preYear)});
        try {
            if (rowSet.next()) {
                return new Object[]{rowSet.getDate("FRPTDATE"), new Integer(rowSet.getInt("Fyear")), new Integer(rowSet.getInt("Fperiod")), rowSet.getString("FORGBOUNDID")};
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private int getCopyElimInvestRateMaxPeriod(Context ctx, String treeId, OrgUnitInfo orgUnit, Date maxReportDate) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" SELECT MAX(FPeriod) FPeriod   \n");
        kqlBuffer.append(" FROM T_CSL_ELIMINVESTRATE   RATE           \n");
        kqlBuffer.append(" JOIN T_ORG_BASEUNIT UNIT ON RATE.fORGUNIT = UNIT.FID      \n");
        kqlBuffer.append(" WHERE RATE.FORGBOUNDID = ?                    \n");
        kqlBuffer.append(" AND UNIT.FNUMBER  =  ? \n");
        kqlBuffer.append(" AND FRPTDATE = ?                        \n");
        kqlBuffer.append(" AND FPeriodType = ?                       \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])new Object[]{treeId, orgUnit.getNumber(), new Timestamp(maxReportDate.getTime()), new Integer(3)});
        int maxPeriod = 0;
        try {
            while (rowSet.next()) {
                maxPeriod = rowSet.getInt("FPeriod");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return maxPeriod;
    }

    private List getOrgUnitCompanyIdList(Context ctx, OrgTreeInfo orgBound, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        ArrayList<String> CompanyIdList = new ArrayList<String>();
        INewOrgViewFacade iOrgViewFacade = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
        IRowSet rowSet = iOrgViewFacade.buildUnionRows(orgUnit.getId().toString(), orgBound.getId().toString());
        try {
            while (rowSet.next()) {
                CompanyIdList.add(rowSet.getString("UNIT.ID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return CompanyIdList;
    }

    @Override
    protected List _addNewElimInvestRate(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        ElimInvestRateInfo elimInvestRate = (ElimInvestRateInfo)objectValue;
        Date date = elimInvestRate.getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        Iterator upit = elimInvestRate.getEntries().iterator();
        while (upit.hasNext()) {
            ElimInvestRateInfo elimInvestRateInfo = (ElimInvestRateInfo)upit.next();
            if (null == elimInvestRateInfo || null == elimInvestRateInfo.getId()) continue;
            ObjectUuidPK pk = new ObjectUuidPK(elimInvestRateInfo.getId());
            ElimInvestRateInfo original = this.getElimInvestRateInfo(ctx, (IObjectPK)pk);
            Date originalDate = original.getDate();
            calendar.setTime(originalDate);
            int originalYear = calendar.get(1);
            int originalMonth = calendar.get(2);
            if (year == originalYear && month == originalMonth) {
                original.setIsMonthLatest(false);
            }
            original.setIsLatest(false);
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)original);
        }
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        Iterator it = elimInvestRate.getEntries().iterator();
        while (it.hasNext()) {
            ElimInvestRateInfo elimInvestRateInfo = (ElimInvestRateInfo)it.next();
            if (null == elimInvestRateInfo) continue;
            elimInvestRateInfo.setId(null);
            if (elimInvestRateInfo.getTargetCompany() == null) {
                elimInvestRateInfo.setTargetCompany(elimInvestRate.getTargetCompany());
            }
            String formatDate = dateFormat.format(elimInvestRate.getDate());
            try {
                elimInvestRateInfo.setDate(dateFormat.parse(formatDate));
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            elimInvestRateInfo.setIsLatest(true);
            elimInvestRateInfo.setIsMonthLatest(true);
            this.checkExistSameInvestOnOrgBound(ctx, elimInvestRateInfo);
            IObjectPK pk = this.addnew(ctx, (CoreBaseInfo)elimInvestRateInfo);
            idList.add(pk);
            this.saveTemplate(ctx, elimInvestRateInfo);
        }
        return idList;
    }

    @Override
    protected List _updateElimInvestRate(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        ElimInvestRateInfo elimInvestRateInfo = (ElimInvestRateInfo)objectValue;
        ElimInvestRateCollection elimInvestRateCollection = elimInvestRateInfo.getEntries();
        if (null == elimInvestRateCollection || 0 == elimInvestRateCollection.size()) {
            return null;
        }
        int rptYear = -1;
        int rptPeriod = -1;
        FullOrgUnitInfo targetCompany = null;
        OrgTreeInfo orgBound = null;
        FullOrgUnitInfo orgUnit = null;
        Date reportDate = null;
        Date effectDate = null;
        RptPeriodTypeEnum periodType = null;
        Iterator it = elimInvestRateCollection.iterator();
        while (it.hasNext()) {
            ElimInvestRateInfo elimInvestRate = (ElimInvestRateInfo)it.next();
            if (null == elimInvestRate) continue;
            targetCompany = elimInvestRateInfo.getTargetCompany();
            effectDate = elimInvestRateInfo.getDate();
            orgBound = elimInvestRate.getOrgBound();
            reportDate = elimInvestRate.getRptDate();
            rptYear = elimInvestRate.getYear();
            rptPeriod = elimInvestRate.getPeriod();
            periodType = elimInvestRate.getPeriodType();
            orgUnit = elimInvestRate.getOrgUnit();
            break;
        }
        if (targetCompany == null || orgUnit == null) {
            return null;
        }
        Set originalIdSet = this.getOriginalIdSet(ctx, reportDate, orgBound.getId().toString(), targetCompany.getId().toString(), rptPeriod, periodType, orgUnit.getId().toString());
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        Iterator it2 = elimInvestRateCollection.iterator();
        while (it2.hasNext()) {
            ElimInvestRateInfo elimInvestRate = (ElimInvestRateInfo)it2.next();
            if (null == elimInvestRate) continue;
            elimInvestRate.setTargetCompany(targetCompany);
            elimInvestRate.setDate(effectDate);
            if (null == elimInvestRate.getId()) {
                elimInvestRate.setYear(rptYear);
                elimInvestRate.setPeriod(rptPeriod);
                elimInvestRate.setRptDate(reportDate);
                elimInvestRate.setPeriodType(periodType);
                this.checkExistSameInvestOnOrgBound(ctx, elimInvestRate);
                IObjectPK pk = this.addnew(ctx, (CoreBaseInfo)elimInvestRate);
                idList.add(pk);
                this.saveTemplate(ctx, elimInvestRate);
                continue;
            }
            String elimInvestRateId = elimInvestRate.getId().toString();
            if (!originalIdSet.contains(elimInvestRateId)) continue;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)elimInvestRateId));
            this.updateTemplate(ctx, elimInvestRate);
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)elimInvestRate);
            originalIdSet.remove(elimInvestRateId);
        }
        if (originalIdSet.size() > 0) {
            this.deleteElimInvestRate(ctx, Arrays.asList((Object[])originalIdSet.toArray()), orgBound.getId().toString(), reportDate, rptPeriod, periodType);
        }
        return idList;
    }

    private void deleteElimInvestRate(Context ctx, List<String> selectIds, String orgBoundId, Date reportDate, int rptPeriod, RptPeriodTypeEnum rptPeriodType) throws BOSException, EASBizException {
        if (selectIds != null && !selectIds.isEmpty()) {
            TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
            String tempateTable = null;
            try {
                tempateTable = iPool.createTempTable("create table t_csl_orgUnit_company(forgUnitid VARCHAR(44), fcompanyid VARCHAR(44))");
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append("insert into ").append(tempateTable).append("(forgUnitid,fcompanyid) ");
                kqlBuffer.append("select distinct forgUnit,ftargetcompany from T_CSL_ELIMINVESTRATE where fid in(");
                kqlBuffer.append(this.buildInQueryString(selectIds)).append(")");
                DbUtil.execute((Context)ctx, (String)kqlBuffer.toString());
                kqlBuffer.setLength(0);
                kqlBuffer.append(" DELETE FROM T_CSL_ELIMINVESTRATEENTRY ");
                kqlBuffer.append(" WHERE FELIMINVESTRATE IN (");
                kqlBuffer.append(this.buildInQueryString(selectIds));
                kqlBuffer.append(")");
                DbUtil.execute((Context)ctx, (String)kqlBuffer.toString());
                kqlBuffer.setLength(0);
                kqlBuffer.append(" DELETE FROM T_CSL_ELIMINVESTRATE WHERE FID IN (");
                kqlBuffer.append(this.buildInQueryString(selectIds));
                kqlBuffer.append(")");
                DbUtil.execute((Context)ctx, (String)kqlBuffer.toString());
                this.updateElimInvestRateLatest(ctx, orgBoundId, tempateTable, reportDate, rptPeriod, rptPeriodType);
            }
            catch (Exception e) {
                logger.error((Object)"deleteElimInvestRate error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty((String)tempateTable)) {
                    iPool.releaseTable(tempateTable);
                }
            }
        }
    }

    @Override
    protected IRowSet _getElimInvestRateList(Context ctx, Map param) throws BOSException, EASBizException {
        List idList = (List)param.get("idList");
        if (null == idList) {
            param.put("isFirst", Boolean.TRUE);
            idList = this.getDateOfId(ctx, param);
        }
        if (null == idList || 0 == idList.size()) {
            return null;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "ElimInvestRateQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowset = queryExecutor.executeQuery();
        return rowset;
    }

    @Override
    protected void _deleteElimInvestRate(Context ctx, Map param) throws BOSException, EASBizException {
        Object obj;
        String orgBoundId = (String)param.get("orgBoundId");
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)param.get("orgUnit");
        List selectIdList = (List)param.get("selectIdList");
        int rptPeriod = 0;
        RptPeriodTypeEnum rptPeriodType = null;
        if (param.containsKey("rptPeriod")) {
            int n = rptPeriod = param.get("rptPeriod") != null ? (Integer)param.get("rptPeriod") : 0;
        }
        if (param.containsKey("rptPeriodType") && (obj = param.get("rptPeriodType")) != null && obj instanceof RptPeriodTypeEnum) {
            rptPeriodType = (RptPeriodTypeEnum)obj;
        }
        Timestamp rptDate = new Timestamp(((Date)param.get("reportDate")).getTime());
        if (null == selectIdList || 0 == selectIdList.size()) {
            return;
        }
        this.deleteElimInvestRate(ctx, selectIdList, orgBoundId, rptDate, rptPeriod, rptPeriodType);
    }

    @Override
    protected void _distributeTemplate(Context ctx, Object object, List elimInvestRateIdList) throws BOSException, EASBizException {
        String template = (String)object;
        HashSet elimInvestRateIdSet = new HashSet();
        elimInvestRateIdSet.addAll(elimInvestRateIdList);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", elimInvestRateIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        IElimInvestRate IElimInvestRate2 = ElimInvestRateFactory.getLocalInstance(ctx);
        ElimInvestRateCollection collection = IElimInvestRate2.getElimInvestRateCollection(entityViewInfo);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            ElimInvestRateInfo eliminvestRateInfo = (ElimInvestRateInfo)it.next();
            eliminvestRateInfo.setTemplate(template);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)eliminvestRateInfo.getId().toString()));
            this.updateTemplate(ctx, eliminvestRateInfo);
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)eliminvestRateInfo);
        }
    }

    @Override
    protected IRowSet _getInvestCompanyList(Context ctx, Map param) throws BOSException, EASBizException {
        String orgBoundId = (String)param.get("orgBoundId");
        String orgUnitId = (String)param.get("orgUnitId");
        String companyId = (String)param.get("companyId");
        Date effectDate = DateTimeUtils.truncateDate((Date)((Date)param.get("effectDate")));
        Timestamp tsEffectDate = new Timestamp(effectDate.getTime());
        Integer year = (Integer)param.get("rptYear");
        Integer period = (Integer)param.get("rptPeriod");
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)param.get("rptPeriodType");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT TARGETCOMPANY.FID ID,          \n").append(" TARGETCOMPANY.FNAME_" + ctx.getLocale() + " \"COMPANY.NAME\",       \n").append(" FRATE RATE,                                    \n").append(" FDESCRIPTION DESCRIPTION                       \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATE       \n").append(" JOIN T_ORG_BASEUNIT COMPANY                    \n").append(" ON ELIMINVESTRATE.FCOMPANY = COMPANY.FID       \n").append(" JOIN T_ORG_BASEUNIT TARGETCOMPANY              \n").append(" ON ELIMINVESTRATE.FTARGETCOMPANY =             \n").append(" TARGETCOMPANY.FID                              \n").append(" WHERE ELIMINVESTRATE.FORGBOUNDID = ?           \n").append(" AND ELIMINVESTRATE.FORGUNIT = ?                \n").append(" AND ELIMINVESTRATE.FCOMPANY = ?                \n").append(" AND ELIMINVESTRATE.FYEAR = ?  \t              \n").append(" AND ELIMINVESTRATE.FPERIOD = ?                 \n").append(" AND ELIMINVESTRATE.FPERIODTYPE = ?             \n").append(" AND ELIMINVESTRATE.FDATE =                     \n").append(" (SELECT MAX(FDATE)                             \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATESUB    \n").append(" WHERE ELIMINVESTRATESUB.FORGBOUNDID =          \n").append(" ELIMINVESTRATE.FORGBOUNDID                     \n").append(" AND ELIMINVESTRATESUB.FORGUNIT =               \n").append(" ELIMINVESTRATE.FORGUNIT                        \n").append(" AND ELIMINVESTRATESUB.FCOMPANY =               \n").append(" ELIMINVESTRATE.FCOMPANY                        \n").append(" AND ELIMINVESTRATESUB.FTARGETCOMPANY =         \n").append(" ELIMINVESTRATE.FTARGETCOMPANY                  \n").append(" AND ELIMINVESTRATESUB.FYEAR =         \n").append(" ELIMINVESTRATE.FYEAR                  \n").append(" AND ELIMINVESTRATESUB.FPERIOD =         \n").append(" ELIMINVESTRATE.FPERIOD                  \n").append(" AND ELIMINVESTRATESUB.FPERIODTYPE =         \n").append(" ELIMINVESTRATE.FPERIODTYPE                  \n").append(" AND ELIMINVESTRATESUB.FDATE <= ?)              \n");
        Object[] params = new Object[]{orgBoundId, orgUnitId, companyId, year, period, new Integer(periodType.getValue()), tsEffectDate};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
        return rs;
    }

    @Override
    protected IRowSet _getShareholderList(Context ctx, Map param) throws BOSException, EASBizException {
        String orgBoundId = (String)param.get("orgBoundId");
        String orgUnitId = (String)param.get("orgUnitId");
        String companyId = (String)param.get("companyId");
        Date effectDate = DateTimeUtils.truncateDate((Date)((Date)param.get("effectDate")));
        Timestamp tsEffectDate = new Timestamp(effectDate.getTime());
        Integer year = (Integer)param.get("rptYear");
        Integer period = (Integer)param.get("rptPeriod");
        boolean isIncludeChild = false;
        if (param.containsKey("isIncludeChild")) {
            isIncludeChild = (Boolean)param.get("isIncludeChild");
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)param.get("rptPeriodType");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT COMPANY.FID AS ID,             \n").append(" COMPANY.FNAME_" + ctx.getLocale() + " \"TARGETCOMPANY.NAME\",       \n").append(" FRATE RATE,                                    \n").append(" FDESCRIPTION DESCRIPTION                       \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATE       \n").append(" JOIN T_ORG_BASEUNIT COMPANY                    \n").append(" ON ELIMINVESTRATE.FCOMPANY = COMPANY.FID       \n").append(" JOIN T_ORG_BASEUNIT TARGETCOMPANY              \n").append(" ON ELIMINVESTRATE.FTARGETCOMPANY =             \n").append(" TARGETCOMPANY.FID                              \n").append(" WHERE ELIMINVESTRATE.FORGBOUNDID = ?           \n");
        if (isIncludeChild) {
            sqlBuffer.append(" AND ELIMINVESTRATE.FORGUNIT in ( \n").append(" select b.funitid from t_org_structure b,t_org_structure c  \n").append(" where c.funitid=? and b.flongnumber like concat(c.flongnumber,'%')  \n").append(" and  c.ftreeid= ? and b.ftreeid = ? ) \n");
        } else {
            sqlBuffer.append(" AND ELIMINVESTRATE.FORGUNIT = ?                \n");
        }
        sqlBuffer.append(" AND ELIMINVESTRATE.FTARGETCOMPANY = ?          \n").append(" AND ELIMINVESTRATE.FYEAR = ?  \t              \n").append(" AND ELIMINVESTRATE.FPERIOD = ?                 \n").append(" AND ELIMINVESTRATE.FPERIODTYPE = ?             \n").append(" AND ELIMINVESTRATE.FDATE =                     \n").append(" (SELECT MAX(FDATE)                             \n").append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATESUB    \n").append(" WHERE ELIMINVESTRATESUB.FORGBOUNDID =          \n").append(" ELIMINVESTRATE.FORGBOUNDID                     \n").append(" AND ELIMINVESTRATESUB.FORGUNIT =               \n").append(" ELIMINVESTRATE.FORGUNIT                        \n").append(" AND ELIMINVESTRATESUB.FCOMPANY =               \n").append(" ELIMINVESTRATE.FCOMPANY                        \n").append(" AND ELIMINVESTRATESUB.FTARGETCOMPANY =         \n").append(" ELIMINVESTRATE.FTARGETCOMPANY                  \n").append(" AND ELIMINVESTRATESUB.FRPTDATE =               \n").append(" ELIMINVESTRATE.FRPTDATE                        \n").append(" AND ELIMINVESTRATESUB.FDATE <= ?)              \n");
        Object[] params = null;
        params = isIncludeChild ? new Object[]{orgBoundId, orgUnitId, orgBoundId, orgBoundId, companyId, year, period, new Integer(periodType.getValue()), tsEffectDate} : new Object[]{orgBoundId, orgUnitId, companyId, year, period, new Integer(periodType.getValue()), tsEffectDate};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
        return rs;
    }

    @Override
    protected void _generateElimInvestRate(Context ctx, Map param) throws BOSException, EASBizException {
        OrgTreeInfo orgBound = (OrgTreeInfo)param.get("orgBound");
        Date reportDate = (Date)param.get("reportDate");
        OrgUnitInfo orgUnit = (OrgUnitInfo)param.get("orgUnit");
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(ctx, orgBound.getId().toString());
        HashMap investRelation = new HashMap();
        if (mergeMode.getValue() == 0) {
            GenerateElimInvestRateInDirectHelper helper = new GenerateElimInvestRateInDirectHelper(ctx, param, mergeMode);
            helper.generateElimInvestRate();
        } else if (mergeMode.getValue() == 1) {
            this.generateRelationByOrdinal(ctx, orgBound, orgUnit, reportDate, investRelation);
            param.put("MergeMode", mergeMode);
            this.saveInvestRelation(ctx, param, investRelation, null, null);
        }
    }

    @Override
    protected List _getAllDataOfId(Context ctx, Map param) throws BOSException, EASBizException {
        return this.getDateOfId(ctx, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _copyElimInvestRatePrePeriod(Context ctx, Map param) throws BOSException, EASBizException {
        boolean auto;
        Uuid requestId;
        block16: {
            String treeId;
            Date copyElimInvestRateMaxMonth;
            boolean isSupport13Period;
            OrgUnitInfo orgUnit;
            OrgTreeInfo orgBound;
            RptPeriodTypeEnum rptPeriodType;
            int rptPeriod;
            int rptYear;
            Date reportDate;
            block19: {
                block20: {
                    block17: {
                        block18: {
                            reportDate = (Date)param.get("reportDate");
                            rptYear = (Integer)param.get("rptYear");
                            rptPeriod = (Integer)param.get("rptPeriod");
                            rptPeriodType = (RptPeriodTypeEnum)param.get("rptPeriodType");
                            orgBound = (OrgTreeInfo)param.get("orgBound");
                            orgUnit = (OrgUnitInfo)param.get("orgUnit");
                            requestId = null;
                            auto = true;
                            auto = param.get("auto_copy") == null ? false : Boolean.parseBoolean(param.get("auto_copy").toString());
                            String ACTION_NAME = "autoCopyElim";
                            StringBuffer mutexName = new StringBuffer();
                            mutexName.append(rptYear);
                            if (rptPeriodType != null && RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType)) {
                                mutexName.append(rptPeriod);
                            }
                            mutexName.append(reportDate.toString().trim());
                            mutexName.append(orgBound.getId().toString());
                            mutexName.append(orgUnit.getId().toString());
                            requestId = Uuid.create();
                            String tips = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.900_Msg_ElimInvestRateLocked", (Locale)ctx.getOriginLocale());
                            if (!auto && !CslRptUtil.requestCheckControlLock(ctx, requestId, ACTION_NAME, mutexName.toString())) {
                                throw new EASBizException(new NumericExceptionSubItem("autoCopy", tips));
                            }
                            boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx);
                            PeriodCollection periodCollection = null;
                            if (isMergeByFiscalPeriod) {
                                periodCollection = FiscalPeriodHelper.getPeriodCollection(ctx, orgBound);
                            }
                            if (isMergeByFiscalPeriod && periodCollection != null) {
                                this.copyElimInvestRatePrePeriodForFiscalPeriod(ctx, param, isMergeByFiscalPeriod, periodCollection, reportDate, rptYear, rptPeriod, rptPeriodType, orgBound, orgUnit);
                                break block16;
                            }
                            isSupport13Period = CslRptUtil.isSupport13Period(ctx);
                            Date prePeriodLastDay = RPTDate13Util.getPrePeriodLastDayByDate(reportDate, rptPeriod, RptPeriodTypeEnum.MONTHLY, isSupport13Period);
                            int prePeriod = RPTDate13Util.getPreYearAndPeriod(rptYear, rptPeriod, rptPeriodType, isSupport13Period)[1];
                            param.put("reportDate", prePeriodLastDay);
                            boolean isAutoCopy = param.get("auto_copy") == null ? false : (Boolean)param.get("auto_copy");
                            copyElimInvestRateMaxMonth = this.getCopyElimInvestRateMaxMonth(ctx, orgBound, orgUnit, prePeriodLastDay, rptYear, prePeriod, rptPeriodType);
                            if (null == copyElimInvestRateMaxMonth && !isAutoCopy) {
                                throw new InvestCheckException(InvestCheckException.ELIMINVESTRATE_NOT_EXIS);
                            }
                            if (null != copyElimInvestRateMaxMonth || !isAutoCopy) break block17;
                            if (auto || requestId == null) break block18;
                            CslRptUtil.releaseCheckControlLock(ctx, requestId);
                        }
                        return;
                    }
                    this.deleteElimInvestRateByRptDate(ctx, orgBound, orgUnit, reportDate, rptPeriodType, rptPeriod);
                    int[] period = RPTDateUtil.getPeriod(copyElimInvestRateMaxMonth, RptPeriodTypeEnum.MONTHLY);
                    Map tree = UnionVersionUtil.getOrgTreeByPeriods(ctx, orgBound.getNumber(), period[0], period[0], period[1], period[1], RptPeriodTypeEnum.MONTHLY.getValue());
                    Iterator iter = tree.keySet().iterator();
                    treeId = null;
                    if (iter.hasNext()) {
                        treeId = (String)iter.next();
                    }
                    if (!StringUtils.isEmpty(treeId)) break block19;
                    if (auto || requestId == null) break block20;
                    CslRptUtil.releaseCheckControlLock(ctx, requestId);
                }
                return;
            }
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                viewInfo.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)treeId));
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnit.getNumber()));
                filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(copyElimInvestRateMaxMonth.getTime())));
                if (RptPeriodTypeEnum.MONTHLY.equals((Object)rptPeriodType) && copyElimInvestRateMaxMonth.getMonth() + 1 == 12) {
                    int maxPeriod = 12;
                    if (isSupport13Period) {
                        maxPeriod = this.getCopyElimInvestRateMaxPeriod(ctx, treeId, orgUnit, copyElimInvestRateMaxMonth);
                    }
                    if (maxPeriod != 0) {
                        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(maxPeriod)));
                    }
                }
                List orgUnitCompanyIdList = this.getOrgUnitCompanyIdList(ctx, orgBound, orgUnit);
                CoreBaseCollection elimInvestRateCollection = this.getCollection(ctx, viewInfo);
                for (ElimInvestRateInfo elimInvestRateInfo : elimInvestRateCollection) {
                    String companyId = elimInvestRateInfo.getCompany().getId().toString();
                    String targetCompanyId = elimInvestRateInfo.getTargetCompany().getId().toString();
                    if (!(orgUnitCompanyIdList.contains(companyId) && orgUnitCompanyIdList.contains(targetCompanyId) || elimInvestRateInfo.isIsClearCompany() && elimInvestRateInfo.getYear() == rptYear)) continue;
                    elimInvestRateInfo.setId(null);
                    elimInvestRateInfo.setRptDate(reportDate);
                    elimInvestRateInfo.setOrgBound(orgBound);
                    elimInvestRateInfo.setOrgUnit((FullOrgUnitInfo)orgUnit);
                    elimInvestRateInfo.setYear(rptYear);
                    elimInvestRateInfo.setPeriod(rptPeriod);
                    this.addnew(ctx, (CoreBaseInfo)elimInvestRateInfo);
                    this.saveTemplate(ctx, elimInvestRateInfo);
                }
            }
            catch (Throwable throwable) {
                if (!auto && requestId != null) {
                    CslRptUtil.releaseCheckControlLock(ctx, requestId);
                }
                throw throwable;
            }
        }
        if (!auto && requestId != null) {
            CslRptUtil.releaseCheckControlLock(ctx, requestId);
        }
    }

    private void copyElimInvestRatePrePeriodForFiscalPeriod(Context ctx, Map param, boolean isMergeByFiscalPeriod, PeriodCollection periodCollection, Date reportDate, int rptYear, int rptPeriod, RptPeriodTypeEnum rptPeriodType, OrgTreeInfo orgBound, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        boolean isAutoCopy;
        if (!isMergeByFiscalPeriod || periodCollection == null) {
            return;
        }
        CoreBaseCollection elimInvestRateCollection = this.getElimInvestRateCollection(ctx, param, reportDate, rptYear, rptPeriod, orgBound, orgUnit, rptPeriodType, periodCollection);
        boolean bl = isAutoCopy = param.get("auto_copy") == null ? false : (Boolean)param.get("auto_copy");
        if (null == elimInvestRateCollection && !isAutoCopy) {
            throw new InvestCheckException(InvestCheckException.ELIMINVESTRATE_NOT_EXIS);
        }
        if (null == elimInvestRateCollection && isAutoCopy) {
            return;
        }
        List orgUnitCompanyIdList = this.getOrgUnitCompanyIdList(ctx, orgBound, orgUnit);
        for (ElimInvestRateInfo elimInvestRateInfo : elimInvestRateCollection) {
            String companyId = elimInvestRateInfo.getCompany().getId().toString();
            String targetCompanyId = elimInvestRateInfo.getTargetCompany().getId().toString();
            if (!orgUnitCompanyIdList.contains(companyId) || !orgUnitCompanyIdList.contains(targetCompanyId)) continue;
            elimInvestRateInfo.setId(null);
            elimInvestRateInfo.setRptDate(reportDate);
            elimInvestRateInfo.setOrgBound(orgBound);
            elimInvestRateInfo.setOrgUnit((FullOrgUnitInfo)orgUnit);
            elimInvestRateInfo.setYear(rptYear);
            elimInvestRateInfo.setPeriod(rptPeriod);
            this.addnew(ctx, (CoreBaseInfo)elimInvestRateInfo);
            this.saveTemplate(ctx, elimInvestRateInfo);
        }
    }

    private CoreBaseCollection getElimInvestRateCollection(Context ctx, Map param, Date reportDate, int rptYear, int rptPeriod, OrgTreeInfo orgBound, OrgUnitInfo orgUnit, RptPeriodTypeEnum rptPeriodType, PeriodCollection periodCollection) throws BOSException, EASBizException {
        int[] perYearAndPeriod = FiscalPeriodHelper.getPerYearAndPeriod(rptYear, rptPeriod, rptPeriodType, periodCollection, true, false);
        if (perYearAndPeriod == null) {
            return null;
        }
        Date prePeriodLastDay = null;
        try {
            prePeriodLastDay = FiscalPeriodHelper.getPeriodLastDate(periodCollection, perYearAndPeriod[0], perYearAndPeriod[1], rptPeriodType, true);
            param.put("reportDate", prePeriodLastDay);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isAutoCopy = param.get("auto_copy") == null ? false : (Boolean)param.get("auto_copy");
        Object[] info = this.getCopyElimInvestRateInfo(ctx, orgBound, orgUnit, prePeriodLastDay, perYearAndPeriod[0], perYearAndPeriod[1], rptPeriodType);
        if (null == info && !isAutoCopy) {
            throw new InvestCheckException(InvestCheckException.ELIMINVESTRATE_NOT_EXIS);
        }
        if (null == info && isAutoCopy) {
            return null;
        }
        this.deleteElimInvestRateByRptDate(ctx, orgBound, orgUnit, reportDate, rptPeriodType, rptPeriod);
        Date copyElimInvestRateMaxMonth = (Date)info[0];
        Integer year = (Integer)info[1];
        Integer period = (Integer)info[2];
        String treeId = (String)info[3];
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)treeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnit.getNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(copyElimInvestRateMaxMonth.getTime())));
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period));
        filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)year));
        return this.getCollection(ctx, viewInfo);
    }

    @Override
    protected boolean _IsTopUnit(Context ctx, IObjectValue orgUnit, IObjectValue orgBound) throws BOSException, EASBizException {
        FullOrgUnitInfo topUnit = this.getTopUnit(ctx, (OrgTreeInfo)orgBound);
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)orgUnit;
        if (null == topUnit) {
            return false;
        }
        return orgUnitInfo.getId().toString().equals(topUnit.getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _autoCopyElimInvestRatePrePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgBound = (OrgTreeInfo)params.get("orgBound");
        OrgUnitInfo curOrgGroup = (OrgUnitInfo)params.get("orgUnit");
        Date reportDate = (Date)params.get("reportDate");
        boolean isCovered = params.get("isCovered") != null && (Boolean)params.get("isCovered") != false;
        Integer period = (Integer)params.get("rptPeriod");
        RptPeriodTypeEnum rptType = null;
        if (params.get("rptPeriodType") instanceof RptPeriodTypeEnum) {
            rptType = (RptPeriodTypeEnum)params.get("rptPeriodType");
        }
        if (params.get("rptPeriodType") instanceof Integer) {
            rptType = RptPeriodTypeEnum.getEnum((int)((Integer)params.get("rptPeriodType")));
            params.put("rptPeriodType", rptType);
        }
        HashSet<String> IDs = new HashSet<String>();
        IDs.add(curOrgGroup.getId().toString());
        this.findNextGradeOrgUnit(ctx, IDs, params);
        if (IDs != null && IDs.size() > 0) {
            ArrayList<Uuid> requestIds = new ArrayList<Uuid>();
            try {
                for (String curOrgGroupID : IDs) {
                    OrgUnitInfo unitinfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(curOrgGroupID));
                    params.put("orgUnit", unitinfo);
                    params.put("reportDate", reportDate);
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(reportDate.getTime())));
                    filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgBound.getId().toString()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)curOrgGroupID));
                    StringBuffer mutexName = new StringBuffer();
                    mutexName.append((Integer)params.get("rptYear"));
                    if (rptType != null && RptPeriodTypeEnum.MONTHLY.equals((Object)rptType)) {
                        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period));
                        mutexName.append(period);
                    }
                    Uuid requestId = Uuid.create();
                    requestIds.add(requestId);
                    String ACTION_NAME = "autoCopyElim";
                    mutexName.append(reportDate.toString().trim());
                    mutexName.append(orgBound.getId().toString());
                    mutexName.append(curOrgGroupID);
                    String tips = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.900_Msg_ElimInvestRateLocked", (Locale)ctx.getOriginLocale());
                    if (!CslRptUtil.requestCheckControlLock(ctx, requestId, ACTION_NAME, mutexName.toString())) {
                        throw new EASBizException(new NumericExceptionSubItem("autoCopy", tips));
                    }
                    if (this.exists(ctx, filterInfo) && !isCovered) continue;
                    params.put("auto_copy", new Boolean(true));
                    this.copyElimInvestRatePrePeriod(ctx, params);
                }
            }
            finally {
                for (Uuid requestId : requestIds) {
                    if (requestId == null) continue;
                    CslRptUtil.releaseCheckControlLock(ctx, requestId);
                }
            }
        }
        return true;
    }

    private void findNextGradeOrgUnit(Context ctx, Set IDs, Map param) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)param.get("orgUnit");
        OrgTreeInfo treeInfo = (OrgTreeInfo)param.get("orgBound");
        String treeId = treeInfo.getId().toString();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select flongnumber from t_org_structure where ftreeid=? and funitid=? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, unitInfo.getId().toString()});
            String longNumber = null;
            if (rs.next()) {
                longNumber = rs.getString("flongnumber");
            }
            if (!StringUtils.isEmpty(longNumber)) {
                sql.setLength(0);
                sql.append("select unit.fid id from t_org_baseunit unit join t_org_structure struct \n").append(" on unit.fid = struct.funitid \n").append(" where struct.flongnumber like '" + longNumber + "!%' \n").append(" and unit.fisCompanyOrgUnit = 0 and struct.ftreeid = ? ");
                ArrayList<String> params = new ArrayList<String>(2);
                params.add(treeId);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                while (rs.next()) {
                    IDs.add(rs.getString("id"));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected Map _calEquivShareRate(Context ctx, List idList, Map params) throws BOSException, EASBizException {
        CalculateEquivShareRateHelper helper = new CalculateEquivShareRateHelper(idList, params, ctx);
        return helper.calculate();
    }

    @Override
    protected Map _getClearingCompanyInfors(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)params.get("orgTreeInfo");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)params.get("orgUnitInfo");
        int year = (Integer)params.get("year");
        int period = (Integer)params.get("period");
        int periodType = (Integer)params.get("periodType");
        if (treeInfo == null || orgUnitInfo == null || year == -1 || period == -1 || periodType != 3) {
            return null;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select ftargetCompany,min(fdate) fdate from T_CSL_ElimInvestRate \n").append(" where FOrgBoundId = ? ", (Object)treeInfo.getId().toString()).append(" and FOrgUnit = ? ", (Object)orgUnitInfo.getId().toString()).append(" and frate = 0 and fyear = ?", (Object)year).append(" and fperiod =   ? ", (Object)period).append(" and fRptdate >= ? ", (Object)new java.sql.Date(RPTDateUtil.getBeginOfYear(year).getTime())).append(" and fRptdate <= ? ", (Object)new java.sql.Date(RPTDate13Util.getPeriodLastDate(year, period, RptPeriodTypeEnum.MONTHLY).getTime())).append(" and ftargetCompany not in(select s.funitid from t_org_Structure s \n").append(" where FtreeId = ? ", (Object)treeInfo.getId().toString()).append(" ) \n").append(" group by ftargetCompany");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        ArrayList<ClearCompanyItemInfo> clearCompList = new ArrayList<ClearCompanyItemInfo>();
        HashMap<String, List<Object>> clearCompMap = new HashMap<String, List<Object>>();
        if (rs != null && rs.size() > 0) {
            treeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo("select number where id ='" + treeInfo.getId().toString() + "'");
            String orgTreeNum = treeInfo.getNumber();
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            try {
                while (rs.next()) {
                    java.sql.Date date = rs.getDate("fdate");
                    String targCompanyId = rs.getString("ftargetCompany");
                    String orgTreeId = CslRptUtil.getOrgTreeIdByDateAndNum(ctx, RPTDateUtil.getPrevMonthLastDayByDate(date), orgTreeNum);
                    if (StringUtils.isEmpty((String)orgTreeId)) continue;
                    orgUnitInfo = this.getPreGradeOrgBoundUnitInfo(ctx, orgTreeNum, targCompanyId);
                    int[] yearAndPeriod = RPTDateUtil.getPeriod(RPTDateUtil.getPrevMonthLastDayByDate(date), RptPeriodTypeEnum.MONTHLY);
                    FullOrgUnitInfo clearCompanyInfo = iFullOrgUnit.getFullOrgUnitInfo("select number,id,name,simpleName where id='" + targCompanyId + "'");
                    ClearCompanyItemInfo itemInfo = new ClearCompanyItemInfo();
                    treeInfo = new OrgTreeInfo();
                    treeInfo.setId(BOSUuid.read((String)orgTreeId));
                    treeInfo.setNumber(orgTreeNum);
                    itemInfo.setTreeInfo(treeInfo);
                    itemInfo.setOrgUnitInfo(orgUnitInfo);
                    itemInfo.setPeriodType(periodType);
                    itemInfo.setYear(yearAndPeriod[0]);
                    itemInfo.setPeriod(yearAndPeriod[1]);
                    itemInfo.setClearCompany(clearCompanyInfo);
                    clearCompList.add(itemInfo);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        Object[] sortItems = clearCompList.toArray(new ClearCompanyItemInfo[0]);
        java.util.Arrays.sort(sortItems);
        clearCompMap.put("clearCompList", java.util.Arrays.asList(sortItems));
        return clearCompMap;
    }

    private OrgUnitInfo getPreGradeOrgBoundUnitInfo(Context ctx, String treeId, String companyId) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        String lan = ctx.getLocale().toString();
        sql.append(" select fid,fnumber,fSimpleName,fname_").append(lan).append(" from t_org_BaseUnit where FID in(").append(" select funitId from t_org_Structure where fid in(").append(" select fparentId from t_org_Structure where funitId = ? ", (Object)companyId).append(" and fTreeId = ?", (Object)treeId).append("))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        try {
            if (rs.next()) {
                FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                unitInfo.setNumber(rs.getString("fnumber"));
                unitInfo.setName(rs.getString("fname"), ctx.getLocale());
                unitInfo.setSimpleName(rs.getString("fSimpleName"));
                return unitInfo;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected void _setClearingCompanyFlag(Context ctx, List idList) throws BOSException, EASBizException {
        SQLBuilder builder = new SQLBuilder(300);
        builder.append(" update t_csl_ElimInvestRate set FIsClearCompany = (  \n").append(" case when FIsClearCompany = 1 then 0 else 1 end )").append(" where FId in", (Collection)idList);
        DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
    }

    @Override
    protected void _createAndCalculateElimInvestRate(Context ctx, Map param) throws BOSException, EASBizException {
        ElimInvestRateGenerateHandle handle = new ElimInvestRateGenerateHandle(ctx, param, null, MergeModeEnum.ORDINAL);
        handle.createAndCalculateElimInvestRate();
    }
}

