/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInvestRateParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRateEntry;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ElimInvestRateGenerateHandle {
    private List insertList;
    private List insertEntryList;
    private List updateList;
    private Map investRelation;
    private Map params;
    private Context ctx;
    private OrgTreeInfo orgBound;
    private OrgUnitInfo orgUnit;
    private java.util.Date reportDate;
    private int rptYear;
    private RptPeriodTypeEnum rptPeriodType;
    private int rptPeriod;
    private IElimInvestRate iElimInvest;
    private IElimInvestRateEntry iElimInvestEntry;
    private MergeModeEnum mergeMode;
    private String groupOrgLongNumber = null;
    private Map<String, EliminationInvestRateParamInfo> elimInvestRateParamMap = new HashMap<String, EliminationInvestRateParamInfo>();
    private Map<String, Set<EliminationInvestRateParamInfo>> tarCompanyMap = new HashMap<String, Set<EliminationInvestRateParamInfo>>();
    private Map<String, Set<String>> companyMap = new HashMap<String, Set<String>>();
    private BigDecimal indirectHoldingRates = null;
    private StringBuffer indirectHoldingRatesCalcLog = null;
    private StringBuffer indirectHoldingRatesCalcLogForName = null;
    private Set<String> oneTarCompanyAllCompanyIdSet = null;
    private Map<String, String> orgLongNumbers = new HashMap<String, String>();
    private List<String> selectCalcTarCompanyId = new ArrayList<String>();
    private List<String> selectCalcCompanyId = new ArrayList<String>();
    private int lineCount = 0;
    private boolean isPrintLog = false;
    static DateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ElimInvestRateGenerateHandle");

    public ElimInvestRateGenerateHandle(Context ctx, Map params, Map investRelation, MergeModeEnum mode) throws BOSException {
        this.ctx = ctx;
        this.investRelation = investRelation;
        this.params = params;
        this.mergeMode = mode;
        try {
            this.isPrintLog = CslRptUtil.getCslParam(ctx, "genElimRatePrintLog");
        }
        catch (EASBizException e) {
            logger.error((Object)"getparamError", (Throwable)e);
        }
        this.initEnv();
    }

    private void initEnv() throws BOSException {
        this.orgBound = (OrgTreeInfo)this.params.get("orgBound");
        this.orgUnit = (OrgUnitInfo)this.params.get("orgUnit");
        this.reportDate = (java.util.Date)this.params.get("reportDate");
        this.rptYear = (Integer)this.params.get("rptYear");
        this.rptPeriodType = (RptPeriodTypeEnum)this.params.get("rptPeriodType");
        this.rptPeriod = (Integer)this.params.get("rptPeriod");
        this.groupOrgLongNumber = (String)this.params.get("groupOrgLongNumber");
        this.insertList = new ArrayList();
        this.insertEntryList = new ArrayList();
        this.updateList = new ArrayList();
        this.iElimInvest = ElimInvestRateFactory.getLocalInstance(this.ctx);
        this.iElimInvestEntry = ElimInvestRateEntryFactory.getLocalInstance(this.ctx);
    }

    public void sortElimInvestRateOprt() throws EASBizException, BOSException {
        ElimInvestRateCollection ratecol = this.getCurElimInvestRates();
        HashMap curRateMap = new HashMap(ratecol.size());
        HashMap latestRateMap = new HashMap();
        this.keyMappingCurRate(ratecol, curRateMap, latestRateMap);
        String key = "";
        Timestamp curTime = new Timestamp(new java.util.Date().getTime());
        UserInfo curUser = (UserInfo)this.ctx.get((Object)"UserInfo");
        for (ElimInvestRateInfo rateInfo : this.investRelation.values()) {
            ElimInvestRateInfo tempInfo;
            if (null == rateInfo) continue;
            key = this.mergeMode.getValue() == 0 ? rateInfo.getCompany().getId().toString() + rateInfo.getTargetCompany().getId().toString() + rateInfo.isIsLatest() + this.orgUnit.getId().toString() : this.combineKey(rateInfo.getCompany().getId().toString(), rateInfo.getTargetCompany().getId().toString(), rateInfo.getDate(), this.orgUnit.getId().toString());
            if (curRateMap.containsKey(key)) {
                tempInfo = (ElimInvestRateInfo)curRateMap.get(key);
                tempInfo.setIsLatest(rateInfo.isIsLatest());
                tempInfo.setIsMonthLatest(rateInfo.isIsMonthLatest());
                tempInfo.setRate(rateInfo.getRate());
                tempInfo.setLastUpdateUser(curUser);
                tempInfo.setLastUpdateTime(curTime);
                tempInfo.getEntries();
                this.updateList.add(tempInfo);
                continue;
            }
            rateInfo.setOrgBound(this.orgBound);
            rateInfo.setYear(this.rptYear);
            rateInfo.setPeriodType(this.rptPeriodType);
            rateInfo.setPeriod(this.rptPeriod);
            rateInfo.setRptDate(this.reportDate);
            rateInfo.setOrgUnit((FullOrgUnitInfo)this.orgUnit);
            rateInfo.setId(BOSUuid.create((BOSObjectType)new ElimInvestRateInfo().getBOSType()));
            this.insertList.add(rateInfo);
            key = rateInfo.getCompany().getId().toString() + rateInfo.getTargetCompany().getId().toString();
            if (!latestRateMap.containsKey(key)) continue;
            tempInfo = (ElimInvestRateInfo)latestRateMap.get(key);
            rateInfo.setTemplate(tempInfo.getTemplate());
            rateInfo.setDescription(tempInfo.getDescription());
            this.getDispenseTemplates(tempInfo.getId().toString(), rateInfo.getId().toString());
        }
    }

    private void getDispenseTemplates(String oldRateId, String newRateId) throws BOSException {
        ElimInvestRateEntryCollection rateEntry = this.iElimInvestEntry.getElimInvestRateEntryCollection("where elimInvestRate='" + oldRateId + "'");
        Iterator it = rateEntry.iterator();
        while (it.hasNext()) {
            ElimInvestRateEntryInfo entryInfo = (ElimInvestRateEntryInfo)it.next();
            entryInfo.setId(null);
            ElimInvestRateInfo rateInfo = new ElimInvestRateInfo();
            rateInfo.setId(BOSUuid.read((String)newRateId));
            entryInfo.setElimInvestRate(rateInfo);
            this.insertEntryList.add(entryInfo);
        }
    }

    public void generateElimRateRecords() throws EASBizException, BOSException {
        this.deleteElimRateRecords();
        this.updateElimInvestRateRecords();
        this.insertElimInvestRateRecords();
    }

    private void deleteElimRateRecords() throws EASBizException, BOSException {
        String excludeDeleteIDs = this.getSpecialElimInvestRatesIDs();
        if (this.updateList.isEmpty()) {
            if (excludeDeleteIDs.length() > 0) {
                this.deleteElimInvestRateEntryByDate(excludeDeleteIDs);
                this.deleteElimInvestRateMast(excludeDeleteIDs);
            } else {
                this.deleteElimInvestRateEntryByDate(null);
                this.deleteElimInvestRateMast(null);
            }
        } else {
            String ids = this.packSql(this.updateList);
            if (excludeDeleteIDs.length() > 0) {
                ids = ids + "," + excludeDeleteIDs;
            }
            this.deleteElimInvestRateEntryByDate(ids);
            this.deleteElimInvestRateMast(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertElimInvestRateRecords() {
        if (this.insertList.isEmpty()) {
            return;
        }
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            IORMappingDAO iOrMapping = ORMappingDAO.getInstance((BOSObjectType)new ElimInvestRateInfo().getBOSType(), (Context)this.ctx, (Connection)cn);
            Iterator it = this.insertList.iterator();
            ElimInvestRateInfo info = null;
            while (it.hasNext()) {
                info = (ElimInvestRateInfo)it.next();
                iOrMapping.addNewBatch((IObjectValue)info);
            }
            iOrMapping.executeBatch();
            iOrMapping = ORMappingDAO.getInstance((BOSObjectType)new ElimInvestRateEntryInfo().getBOSType(), (Context)this.ctx, (Connection)cn);
            for (ElimInvestRateEntryInfo entryInfo : this.insertList) {
                entryInfo.setId(BOSUuid.create((BOSObjectType)new ElimInvestRateEntryInfo().getBOSType()));
                iOrMapping.addNewBatch((IObjectValue)entryInfo);
            }
            iOrMapping.executeBatch();
        }
        catch (Exception e) {
            new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Connection)cn);
        }
    }

    private void updateElimInvestRateRecords() throws EASBizException, BOSException {
        for (ElimInvestRateInfo rateInfo : this.updateList) {
            ObjectUuidPK pk = new ObjectUuidPK(rateInfo.getId());
            this.iElimInvest.update((IObjectPK)pk, (CoreBaseInfo)rateInfo);
        }
    }

    private void deleteElimInvestRateEntryByDate(String ids) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        kqlBuffer.append(" DELETE FROM T_CSL_ELIMINVESTRATEENTRY     \n");
        kqlBuffer.append(" WHERE FELIMINVESTRATE IN (                \n");
        kqlBuffer.append(" SELECT FID FROM T_CSL_ELIMINVESTRATE      \n");
        kqlBuffer.append(" WHERE FORGBOUNDID = ?                     \n");
        if (ids != null) {
            kqlBuffer.append(" AND FID NOT IN( \t\t\t\t\t\t \n");
            kqlBuffer.append(ids).append(")\t\t\t\t\t\t\t \n");
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            kqlBuffer.append(" AND FPERIOD =").append(this.rptPeriod).append(" \n");
        }
        kqlBuffer.append(" AND FORGUNIT = ?                          \n");
        kqlBuffer.append(" AND FRPTDATE = ? )                        \n");
        params.add(this.orgBound.getId().toString());
        params.add(this.orgUnit.getId().toString());
        params.add(new Timestamp(this.reportDate.getTime()));
        DbUtil.execute((Context)this.ctx, (String)kqlBuffer.toString(), (Object[])params.toArray());
    }

    private void deleteElimInvestRateMast(String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" delete from t_csl_ElimInvestRate         \n").append(" where ForgBoundId = ?\t\t\t\t\t  \n").append(" and ForgUnit = ?   \t\t\t\t\t  \n").append(" and FrptDate = ?  \t\t\t\t\t\t  \n");
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            sql.append(" AND FPERIOD =").append(this.rptPeriod).append(" \n");
        }
        if (ids != null) {
            sql.append(" and Fid not in(\t\t\t\t\t  \n").append(ids).append(")\t\t\t\t\t\t\t\t\t  \n");
        }
        params.add(this.orgBound.getId().toString());
        params.add(this.orgUnit.getId().toString());
        params.add(new Timestamp(this.reportDate.getTime()));
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private String packSql(List list) {
        StringBuffer sql = new StringBuffer();
        boolean moreOne = false;
        for (ElimInvestRateInfo rateInfo : list) {
            if (moreOne) {
                sql.append(",");
            }
            sql.append("'").append(rateInfo.getId().toString()).append("'");
            moreOne = true;
        }
        return sql.toString();
    }

    private void keyMappingCurRate(ElimInvestRateCollection ratecol, Map curRateMap, Map latestRateMap) {
        String key = "";
        Iterator it = ratecol.iterator();
        while (it.hasNext()) {
            ElimInvestRateInfo rateInfo = (ElimInvestRateInfo)it.next();
            String comId = rateInfo.getCompany().getId().toString();
            String targComId = rateInfo.getTargetCompany().getId().toString();
            key = this.mergeMode.getValue() == 0 ? comId + targComId + rateInfo.isIsLatest() + rateInfo.getOrgUnit().getId().toString() : this.combineKey(comId, targComId, rateInfo.getDate(), rateInfo.getOrgUnit().getId().toString());
            if (curRateMap != null) {
                curRateMap.put(key, rateInfo);
            }
            if (!rateInfo.isIsLatest()) continue;
            key = comId + targComId + rateInfo.getOrgUnit().getId().toString();
            latestRateMap.put(key, rateInfo);
        }
    }

    private ElimInvestRateCollection getCurElimInvestRates() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBound.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLatest", (Object)new Integer(1)));
        if (this.mergeMode.getValue() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isLatest", (Object)new Integer(1)));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(this.rptYear)));
        if (this.rptPeriodType != null && RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
        }
        view.setFilter(filterInfo);
        return this.iElimInvest.getElimInvestRateCollection(view);
    }

    private String getSpecialElimInvestRatesIDs() throws EASBizException, BOSException {
        if (this.mergeMode.equals((Object)MergeModeEnum.DIRECT)) {
            return this.getHisElimInvetsRatesRecordIds();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select elim.FId from t_csl_ElimInvestRate elim                \n").append(" join t_org_baseUnit unit on elim.FOrgUnit = unit.Fid     \n").append(" join t_org_Tree tree on elim.FOrgBoundId = tree.fid      \n").append(" where tree.Fid = ? and unit.Fid = ?  \n").append(" and elim.FRptDate = ?                                    \n");
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            sql.append(" AND elim.FPERIOD =").append(this.rptPeriod).append(" \n");
        }
        sql.append(" and elim.FRate is null and elim.FequivRate is not null   \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.orgBound.getId().toString(), this.orgUnit.getId().toString(), new Timestamp(this.reportDate.getTime())});
        StringBuffer IDs = new StringBuffer();
        boolean isMulti = false;
        try {
            while (rs.next()) {
                if (isMulti) {
                    IDs.append(",");
                }
                IDs.append("'").append(rs.getString("FId")).append("'");
                isMulti = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return IDs.toString();
    }

    private String combineKey(String companyId, String targComapnyId, java.util.Date date, String groupOrgUnitId) {
        String strDate = date == null ? "" : formate.format(date);
        return companyId + targComapnyId + strDate + groupOrgUnitId;
    }

    public void clear() {
        this.insertList.clear();
        this.insertEntryList.clear();
        this.updateList.clear();
        this.params = null;
        this.investRelation = null;
        this.orgBound = null;
        this.orgUnit = null;
        this.rptPeriodType = null;
        this.groupOrgLongNumber = null;
        this.elimInvestRateParamMap = new HashMap<String, EliminationInvestRateParamInfo>();
        this.tarCompanyMap = new HashMap<String, Set<EliminationInvestRateParamInfo>>();
        this.companyMap = new HashMap<String, Set<String>>();
    }

    private String getHisElimInvetsRatesRecordIds() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(this.reportDate.getTime()), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBound.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLatest", (Object)new Integer(0)));
        view.setFilter(filterInfo);
        ArrayList<String> hisRateRecordIds = new ArrayList<String>();
        StringBuffer ids = new StringBuffer();
        ElimInvestRateCollection investRate = this.iElimInvest.getElimInvestRateCollection(view);
        Iterator it = investRate.iterator();
        while (it.hasNext()) {
            ElimInvestRateInfo rateInfo = (ElimInvestRateInfo)it.next();
            hisRateRecordIds.add(rateInfo.getId().toString());
        }
        if (hisRateRecordIds != null && hisRateRecordIds.size() > 0) {
            boolean isMulti = false;
            for (int i = 0; i < hisRateRecordIds.size(); ++i) {
                if (isMulti) {
                    ids.append(",");
                }
                ids.append("'").append(hisRateRecordIds.get(i).toString()).append("'");
                isMulti = true;
            }
        }
        return ids.toString();
    }

    public void createAndCalculateElimInvestRate() throws BOSException, EASBizException {
        Date date = new Date(this.reportDate.getTime());
        Object[] sqlParam = new Object[]{this.orgBound.getId().toString(), date};
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT RELA.FINVESTEECOMPANYID tarCompanyId,               \n");
        sql.append("BASEUNIT2.fnumber tarCompanyNumber,                                 \n");
        sql.append("BASEUNIT2.fname_" + this.ctx.getLocale() + " tarCompanyName,                 \n");
        sql.append("STRUCT2.FLONGNUMBER tarCompanyLongNumber,                           \n");
        sql.append("RELA.FSHARESCALE shareScale,                                        \n");
        sql.append("RELA.FCHANGEDATE changeDate,                                        \n");
        sql.append("STRUCT.FLONGNUMBER companyLongNumber,                               \n");
        sql.append("BASEUNIT.FID companyId,\t                                            \n");
        sql.append("BASEUNIT.Fnumber companyNumber,                                     \n");
        sql.append("BASEUNIT.fname_" + this.ctx.getLocale() + " companyName                      \n");
        sql.append("from  T_ORG_TREE tree\t                                            \n");
        sql.append("join T_ORG_structure  STRUCT on tree.FID =  STRUCT.FTREEID\t\t    \n");
        sql.append("join T_ORG_BASEUNIT BASEUNIT on BASEUNIT.FID = STRUCT.FUNITID\t\t\n");
        sql.append("join T_ORG_structure  STRUCT2 on tree.FID =  STRUCT2.FTREEID\t\t\n");
        sql.append("join T_ORG_BASEUNIT BASEUNIT2 on BASEUNIT2.FID = STRUCT2.FUNITID    \n");
        sql.append("join T_CSL_SHARERELA RELA on RELA.FInvesteeCompanyID = BASEUNIT2.FID\t\t\n");
        sql.append("and RELA.FSHAREHOLDERID = BASEUNIT.FID \t\t\t\t\t\t\t\t\t\t\n");
        sql.append("where TREE.FTYPE = 8                                                \n");
        sql.append("AND TREE.FID = ? \t                                                \n");
        sql.append("AND RELA.FCHANGEDATE <= ?                                           \n");
        sql.append("AND RELA.FisLatest = 1                                              \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sqlParam);
        String companyId = null;
        String companyNumber = null;
        String companyName = null;
        String companyLongNumber = null;
        String tarCompanyId = null;
        String tarCompanyNumber = null;
        String tarCompanyName = null;
        String tarCompanyLongNumber = null;
        BigDecimal rate = null;
        Date changeDate = null;
        EliminationInvestRateParamInfo eliminationInvestRateParamInfo = null;
        try {
            while (rs.next()) {
                eliminationInvestRateParamInfo = new EliminationInvestRateParamInfo();
                tarCompanyId = rs.getString("tarCompanyId");
                eliminationInvestRateParamInfo.setTarCompanyId(tarCompanyId);
                tarCompanyNumber = rs.getString("tarCompanyNumber");
                eliminationInvestRateParamInfo.setTarCompanyNumber(tarCompanyNumber);
                tarCompanyName = rs.getString("tarCompanyName");
                eliminationInvestRateParamInfo.setTarCompanyName(tarCompanyName);
                tarCompanyLongNumber = rs.getString("tarCompanyLongNumber");
                eliminationInvestRateParamInfo.setTarCompanyLongNumber(tarCompanyLongNumber);
                this.orgLongNumbers.put(tarCompanyId, tarCompanyLongNumber);
                companyId = rs.getString("companyId");
                eliminationInvestRateParamInfo.setCompanyId(companyId);
                companyNumber = rs.getString("companyNumber");
                eliminationInvestRateParamInfo.setCompanyNumber(companyNumber);
                companyName = rs.getString("companyName");
                eliminationInvestRateParamInfo.setCompanyName(companyName);
                companyLongNumber = rs.getString("companyLongNumber");
                eliminationInvestRateParamInfo.setCompanyLongNumber(companyLongNumber);
                this.orgLongNumbers.put(companyId, companyLongNumber);
                rate = rs.getBigDecimal("shareScale");
                eliminationInvestRateParamInfo.setRate(rate);
                changeDate = rs.getDate("changeDate");
                eliminationInvestRateParamInfo.setChangeDate(changeDate);
                Set<EliminationInvestRateParamInfo> companySet = this.tarCompanyMap.get(tarCompanyId);
                if (companySet == null) {
                    companySet = new HashSet<EliminationInvestRateParamInfo>();
                    this.tarCompanyMap.put(tarCompanyId, companySet);
                }
                companySet.add(eliminationInvestRateParamInfo);
                Set<String> tarCompanySet = this.companyMap.get(companyId);
                if (tarCompanySet == null) {
                    tarCompanySet = new HashSet<String>();
                    this.companyMap.put(companyId, tarCompanySet);
                }
                tarCompanySet.add(tarCompanyId);
                this.elimInvestRateParamMap.put(tarCompanyId + companyId, eliminationInvestRateParamInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Map<String, Set<String>> needCalcEilmRateTarCompanySet = this.getNeedCalcEilmRateTarCompany();
        if (this.isPrintLog) {
            String json = JSONUtils.convertObjectToJson(needCalcEilmRateTarCompanySet);
            logger.error((Object)("needCalcEilmRateTarCompanySet:" + json));
        }
        this.calculateEilmRate(needCalcEilmRateTarCompanySet);
    }

    private Map<String, Set<String>> getNeedCalcEilmRateTarCompany() {
        HashMap<String, Set<String>> needCalcEilmRateTarCompanys = new HashMap<String, Set<String>>();
        if (this.isPrintLog) {
            logger.error((Object)("groupOrgLongNumber:" + this.groupOrgLongNumber));
            String json = JSONUtils.convertObjectToJson(this.tarCompanyMap);
            logger.error((Object)("tarCompanyMap:" + json));
            json = JSONUtils.convertObjectToJson(this.orgLongNumbers);
            logger.error((Object)("orgLongNumbers:" + json));
            json = JSONUtils.convertObjectToJson(this.elimInvestRateParamMap);
            logger.error((Object)("elimInvestRateParamMap:" + json));
        }
        Set<String> tarCompanySet = this.tarCompanyMap.keySet();
        for (String tarCompanyId : tarCompanySet) {
            if (!this.orgLongNumbers.get(tarCompanyId).startsWith(this.groupOrgLongNumber + "!")) {
                if (!this.isPrintLog) continue;
                logger.error((Object)("longNumberNoStartsWith:" + tarCompanyId + " " + this.orgLongNumbers.get(tarCompanyId) + " " + this.groupOrgLongNumber));
                continue;
            }
            this.oneTarCompanyAllCompanyIdSet = new HashSet<String>();
            Set<EliminationInvestRateParamInfo> companyIdSet = this.tarCompanyMap.get(tarCompanyId);
            for (EliminationInvestRateParamInfo paramInfo : companyIdSet) {
                String companyId = paramInfo.getCompanyId();
                EliminationInvestRateParamInfo eliminationInvestRateParamInfo = this.elimInvestRateParamMap.get(tarCompanyId + companyId);
                if (this.isPrintLog) {
                    logger.error((Object)("invlongNumberNoStartsWith:" + companyId + " " + tarCompanyId + companyId + " " + eliminationInvestRateParamInfo.getCompanyLongNumber()));
                }
                if (this.orgLongNumbers.get(companyId).startsWith(this.groupOrgLongNumber + "!")) {
                    this.oneTarCompanyAllCompanyIdSet.add(companyId);
                }
                this.setCompanysByTarCompany(companyId, tarCompanyId);
            }
            if (this.oneTarCompanyAllCompanyIdSet.size() <= 0) continue;
            needCalcEilmRateTarCompanys.put(tarCompanyId, this.oneTarCompanyAllCompanyIdSet);
        }
        return needCalcEilmRateTarCompanys;
    }

    private void setCompanysByTarCompany(String tarCompanyId, String checkTarCompanyId) {
        Set<EliminationInvestRateParamInfo> companySet = this.tarCompanyMap.get(tarCompanyId);
        if (companySet != null) {
            for (EliminationInvestRateParamInfo paramInfo : companySet) {
                String companyId = paramInfo.getCompanyId();
                if (checkTarCompanyId.equals(tarCompanyId) || this.oneTarCompanyAllCompanyIdSet.contains(companyId)) continue;
                EliminationInvestRateParamInfo eliminationInvestRateParamInfo = this.elimInvestRateParamMap.get(tarCompanyId + companyId);
                if (eliminationInvestRateParamInfo.getCompanyLongNumber().startsWith(this.groupOrgLongNumber + "!")) {
                    this.oneTarCompanyAllCompanyIdSet.add(companyId);
                }
                this.setCompanysByTarCompany(companyId, checkTarCompanyId);
            }
        }
    }

    private String getGroupOrgUnitId(String tarCompanyLongNumber, String invCompanyLongNumber, Map<String, String> groupOrgUnitLongNumIds) {
        String[] tarCompanyNumbers = tarCompanyLongNumber.split("!");
        String[] invCompanyNumbers = invCompanyLongNumber.split("!");
        StringBuffer longNumber = new StringBuffer();
        String invNumber = null;
        String tarNumber = null;
        for (int i = 0; i < invCompanyNumbers.length; ++i) {
            invNumber = invCompanyNumbers[i];
            tarNumber = null;
            if (tarCompanyNumbers.length > i) {
                tarNumber = tarCompanyNumbers[i];
            }
            if (!invNumber.equals(tarNumber)) break;
            if (longNumber.length() > 0) {
                longNumber.append("!");
            }
            longNumber.append(invNumber);
        }
        return groupOrgUnitLongNumIds.get(longNumber.toString());
    }

    private Map<String, String> getGroupOrgUnitLongNumIds() throws BOSException {
        HashMap<String, String> groupOrgUnitLongNumIds = new HashMap<String, String>();
        String sql = "select str.flongnumber orgLongNumber,str.fUnitID orgUnitId from t_org_structure str \njoin t_org_baseunit org on org.fid=str.fUnitID \n where str.ftreeId='" + this.orgBound.getId() + "' and org.fisUnion=1 \n and (str.flongnumber ='" + this.groupOrgLongNumber + "' or str.flongnumber like '" + this.groupOrgLongNumber + "!%')";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rs.next()) {
                groupOrgUnitLongNumIds.put(rs.getString("orgLongNumber"), rs.getString("orgUnitId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return groupOrgUnitLongNumIds;
    }

    private void calculateEilmRate(Map<String, Set<String>> tarCompanySet) throws EASBizException, BOSException {
        Object json;
        if (tarCompanySet == null || tarCompanySet.size() == 0) {
            throw new ReportException(ReportException.INVEST_RELATION_NULL, new Object[]{this.orgUnit.getName()});
        }
        Set<String> tarCompanyKeySet = tarCompanySet.keySet();
        HashMap existRateMap = new HashMap();
        ElimInvestRateCollection ratecol = null;
        if (tarCompanyKeySet.size() > 0) {
            ratecol = this.getCurElimInvestRates();
            this.keyMappingCurRate(ratecol, null, existRateMap);
        }
        Set<String> companySet = null;
        UserInfo curUser = (UserInfo)this.ctx.get((Object)"UserInfo");
        FullOrgUnitInfo groupOrgUnit = null;
        Map<String, String> groupOrgUnitLongNumIds = this.getGroupOrgUnitLongNumIds();
        if (this.isPrintLog) {
            json = JSONUtils.convertObjectToJson(groupOrgUnitLongNumIds);
            logger.error((Object)("groupOrgUnitLongNumIds:" + (String)json));
            json = JSONUtils.convertObjectToJson(tarCompanyKeySet);
            logger.error((Object)("tarCompanyKeySet:" + (String)json));
            json = JSONUtils.convertObjectToJson(this.selectCalcTarCompanyId);
            logger.error((Object)("selectCalcTarCompanyId:" + (String)json));
            json = JSONUtils.convertObjectToJson(this.companyMap);
            logger.error((Object)("companyMap:" + (String)json));
        }
        for (String tarCompanyId : tarCompanyKeySet) {
            if (this.selectCalcTarCompanyId.size() > 0 && !this.selectCalcTarCompanyId.contains(tarCompanyId)) continue;
            companySet = tarCompanySet.get(tarCompanyId);
            if (this.isPrintLog) {
                String json2 = JSONUtils.convertObjectToJson(companySet);
                logger.error((Object)("tarCompanyIdCompanySet:" + this.orgLongNumbers.get(tarCompanyId) + " " + json2));
            }
            for (String companyId : companySet) {
                ElimInvestRateInfo elimInvestRate;
                if (tarCompanyId.equals(companyId) || this.selectCalcCompanyId.size() > 0 && !this.selectCalcCompanyId.contains(companyId)) continue;
                groupOrgUnit = new FullOrgUnitInfo();
                String groupOrgUnitId = this.getGroupOrgUnitId(this.orgLongNumbers.get(tarCompanyId), this.orgLongNumbers.get(companyId), groupOrgUnitLongNumIds);
                groupOrgUnit.setId(BOSUuid.read((String)groupOrgUnitId));
                if (this.isPrintLog) {
                    logger.error((Object)(this.orgLongNumbers.get(tarCompanyId) + " " + this.orgLongNumbers.get(companyId) + ":" + groupOrgUnitId));
                }
                EliminationInvestRateParamInfo eliminationInvestRateParamInfo = this.elimInvestRateParamMap.get(tarCompanyId + companyId);
                this.indirectHoldingRates = BigDecimal.ZERO;
                this.indirectHoldingRatesCalcLog = new StringBuffer();
                this.indirectHoldingRatesCalcLogForName = new StringBuffer();
                BigDecimal indirectHoldingRate = BigDecimal.ONE;
                StringBuffer log = new StringBuffer();
                StringBuffer logForName = new StringBuffer();
                HashSet<String> hasTarCompanyIdSet = new HashSet<String>();
                hasTarCompanyIdSet.add(companyId);
                this.lineCount = 0;
                this.calculateOneTarCompanyEilmRate(tarCompanyId, companyId, indirectHoldingRate, hasTarCompanyIdSet, log, logForName);
                this.indirectHoldingRates = this.indirectHoldingRates.multiply(new BigDecimal("100"));
                String rateLog = this.indirectHoldingRates.stripTrailingZeros().toPlainString() + "%= " + this.indirectHoldingRatesCalcLog;
                String rateLogForName = this.indirectHoldingRates.stripTrailingZeros().toPlainString() + "%= " + this.indirectHoldingRatesCalcLogForName;
                String updateKey = this.combineKey(companyId, tarCompanyId, null, groupOrgUnitId);
                Timestamp time = new Timestamp(new java.util.Date().getTime());
                if (existRateMap.containsKey(updateKey)) {
                    if (this.isPrintLog) {
                        logger.error((Object)(this.orgLongNumbers.get(tarCompanyId) + " " + this.orgLongNumbers.get(companyId) + " " + groupOrgUnitId + " isUpdate"));
                    }
                    elimInvestRate = (ElimInvestRateInfo)existRateMap.get(updateKey);
                    if (this.indirectHoldingRates != null && BigDecimal.ZERO.compareTo(this.indirectHoldingRates) < 0) {
                        elimInvestRate.setEquivRate(this.indirectHoldingRates);
                    }
                    if (eliminationInvestRateParamInfo != null) {
                        elimInvestRate.setRate(eliminationInvestRateParamInfo.getRate());
                    }
                    if (eliminationInvestRateParamInfo != null && eliminationInvestRateParamInfo.getChangeDate() != null) {
                        elimInvestRate.setDate(eliminationInvestRateParamInfo.getChangeDate());
                    } else {
                        elimInvestRate.setDate(this.reportDate);
                    }
                    elimInvestRate.setIsLatest(true);
                    elimInvestRate.setIsMonthLatest(true);
                    elimInvestRate.setLastUpdateUser(curUser);
                    elimInvestRate.setLastUpdateTime(new Timestamp(new java.util.Date().getTime()));
                    elimInvestRate.setCalcLog(rateLog.getBytes());
                    elimInvestRate.setCalcLogForName(rateLogForName.getBytes());
                    elimInvestRate.setCalcTime(new Timestamp(new java.util.Date().getTime()));
                    elimInvestRate.setCalcUser(curUser);
                    elimInvestRate.setLastUpdateTime(time);
                    elimInvestRate.setLastUpdateUser(curUser);
                    elimInvestRate.setCalcUser(curUser);
                    elimInvestRate.setLineCount(this.lineCount);
                    this.updateList.add(elimInvestRate);
                    continue;
                }
                if (this.isPrintLog) {
                    logger.error((Object)(this.orgLongNumbers.get(tarCompanyId) + " " + this.orgLongNumbers.get(companyId) + " " + groupOrgUnitId + " isInsert"));
                }
                elimInvestRate = new ElimInvestRateInfo();
                FullOrgUnitInfo targetCompany = new FullOrgUnitInfo();
                targetCompany.setId(BOSUuid.read((String)tarCompanyId));
                elimInvestRate.setTargetCompany(targetCompany);
                FullOrgUnitInfo company = new FullOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                elimInvestRate.setCompany(company);
                if (eliminationInvestRateParamInfo != null) {
                    elimInvestRate.setRate(eliminationInvestRateParamInfo.getRate());
                }
                if (this.indirectHoldingRates != null && BigDecimal.ZERO.compareTo(this.indirectHoldingRates) < 0) {
                    elimInvestRate.setEquivRate(this.indirectHoldingRates);
                }
                if (eliminationInvestRateParamInfo != null && eliminationInvestRateParamInfo.getChangeDate() != null) {
                    elimInvestRate.setDate(eliminationInvestRateParamInfo.getChangeDate());
                } else {
                    elimInvestRate.setDate(this.reportDate);
                }
                elimInvestRate.setIsLatest(true);
                elimInvestRate.setIsMonthLatest(true);
                elimInvestRate.setOrgBound(this.orgBound);
                elimInvestRate.setYear(this.rptYear);
                elimInvestRate.setPeriodType(this.rptPeriodType);
                elimInvestRate.setPeriod(this.rptPeriod);
                elimInvestRate.setRptDate(this.reportDate);
                elimInvestRate.setOrgUnit(groupOrgUnit);
                elimInvestRate.setCalcLog(rateLog.getBytes());
                elimInvestRate.setCalcLogForName(rateLogForName.getBytes());
                elimInvestRate.setCalcTime(time);
                elimInvestRate.setLastUpdateTime(time);
                elimInvestRate.setCreateTime(time);
                elimInvestRate.setCreator(curUser);
                elimInvestRate.setLastUpdateUser(curUser);
                elimInvestRate.setCalcUser(curUser);
                elimInvestRate.setLineCount(this.lineCount);
                this.insertList.add(elimInvestRate);
            }
        }
        if (this.isPrintLog) {
            json = JSONUtils.convertObjectToJson(this.updateList);
            logger.error((Object)("updateList:" + (String)json));
            json = JSONUtils.convertObjectToJson(this.insertList);
            logger.error((Object)("updateList:" + (String)json));
        }
        this.generateElimRateRecords();
        this.clear();
    }

    private void calculateOneTarCompanyEilmRate(String checkTarCompanyId, String companyId, BigDecimal indirectHoldingRate, Set<String> hasTarCompanyIdSet, StringBuffer log, StringBuffer logForName) {
        BigDecimal indirectHoldingRateTemp = BigDecimal.ONE.multiply(indirectHoldingRate);
        HashSet<String> hasTarCompanyIdSetTemp = new HashSet<String>();
        hasTarCompanyIdSetTemp.addAll(hasTarCompanyIdSet);
        StringBuffer logTemp = new StringBuffer(log);
        StringBuffer logForNameTemp = new StringBuffer(logForName);
        Set<String> tarCompanyKeySet = this.companyMap.get(companyId);
        if (tarCompanyKeySet == null || tarCompanyKeySet.size() == 0) {
            return;
        }
        BigDecimal directHoldingRate = null;
        EliminationInvestRateParamInfo eliminationInvestRateParamInfo = null;
        String logStr = null;
        String logForNameStr = null;
        String preTarCompanyId = "";
        for (String tarCompanyId : tarCompanyKeySet) {
            indirectHoldingRate = BigDecimal.ONE.multiply(indirectHoldingRateTemp);
            log = new StringBuffer(logTemp);
            logForName = new StringBuffer(logForNameTemp);
            if (!StringUtils.isEmpty((String)preTarCompanyId)) {
                hasTarCompanyIdSet.remove(preTarCompanyId);
            }
            if (hasTarCompanyIdSet.contains(tarCompanyId)) continue;
            preTarCompanyId = tarCompanyId;
            hasTarCompanyIdSet.add(tarCompanyId);
            eliminationInvestRateParamInfo = this.elimInvestRateParamMap.get(tarCompanyId + companyId);
            directHoldingRate = eliminationInvestRateParamInfo.getRate();
            if (directHoldingRate == null) continue;
            logStr = eliminationInvestRateParamInfo.getCompanyNumber() + "_" + eliminationInvestRateParamInfo.getTarCompanyNumber() + "(" + directHoldingRate + "%)";
            logForNameStr = eliminationInvestRateParamInfo.getCompanyName() + "_" + eliminationInvestRateParamInfo.getTarCompanyName() + "(" + directHoldingRate + "%)";
            log.append("\n              *  " + logStr);
            logForName.append("\n              *  " + logForNameStr);
            directHoldingRate = directHoldingRate.divide(new BigDecimal("100"));
            indirectHoldingRate = indirectHoldingRate.multiply(directHoldingRate);
            if (checkTarCompanyId.equals(tarCompanyId)) {
                this.indirectHoldingRates = this.indirectHoldingRates.add(indirectHoldingRate);
                ++this.lineCount;
                hasTarCompanyIdSet.clear();
                hasTarCompanyIdSet.addAll(hasTarCompanyIdSetTemp);
                if (this.indirectHoldingRatesCalcLog.length() > 0) {
                    this.indirectHoldingRatesCalcLog.append("\n      +");
                    this.indirectHoldingRatesCalcLogForName.append("\n      +");
                }
                int index = log.indexOf("*");
                int indexForNameStr = logForName.indexOf("*");
                this.indirectHoldingRatesCalcLog.append(log.replace(index, index + 1, "  "));
                this.indirectHoldingRatesCalcLogForName.append(logForName.replace(indexForNameStr, indexForNameStr + 1, "  "));
                continue;
            }
            this.calculateOneTarCompanyEilmRate(checkTarCompanyId, tarCompanyId, indirectHoldingRate, hasTarCompanyIdSet, log, logForName);
        }
        hasTarCompanyIdSet.clear();
        hasTarCompanyIdSet.addAll(hasTarCompanyIdSetTemp);
    }
}

