/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRateEntry;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElimInvestRateImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ElimInvestRateImport");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Map<String, BigDecimal> investeeCompanyMap = new HashMap<String, BigDecimal>();
    private Map<String, Date> investeeCompanyChangeDateMap = new HashMap<String, Date>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ElimInvestRateFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ElimInvestRateInfo info = (ElimInvestRateInfo)coreBaseInfo;
            ElimInvestRateCollection existsColl = this.getExistsColl(ctx, info);
            ElimInvestRateInfo sameInfo = this.getSameInfo(existsColl, info);
            if (sameInfo != null && sameInfo.getId() != null && this.isSltImportUpdate()) {
                info.setId(sameInfo.getId());
                ElimInvestRateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sameInfo.getId()), (CoreBaseInfo)info);
                this.updateTemplate(ctx, sameInfo.getId().toString(), info, true);
            } else {
                String key;
                BigDecimal sumRate;
                if (sameInfo != null && sameInfo.getId() != null) {
                    throw new InvestCheckException(InvestCheckException.EXISTS_SAME_INVEST, new Object[]{info.getOrgBound(), info.getOrgUnit(), info.getCompany(), info.getTargetCompany()});
                }
                if (existsColl != null) {
                    ElimInvestRateInfo tmpInfo = null;
                    for (int i = 0; i < existsColl.size(); ++i) {
                        tmpInfo = existsColl.get(i);
                        if (tmpInfo.isIsLatest()) {
                            if (info.getDate().after(tmpInfo.getDate())) {
                                tmpInfo.setIsLatest(false);
                                ElimInvestRateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmpInfo.getId()), (CoreBaseInfo)tmpInfo);
                                continue;
                            }
                            info.setIsLatest(false);
                            continue;
                        }
                        if (!tmpInfo.getDate().after(info.getDate())) continue;
                        info.setIsLatest(false);
                    }
                }
                sumRate = (sumRate = this.investeeCompanyMap.get(key = info.getOrgBound().getId().toString() + info.getTargetCompany().getId().toString())) == null ? info.getRate() : sumRate.add(info.getRate());
                this.investeeCompanyMap.put(key, sumRate);
                if (sumRate.doubleValue() > 100.0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"457_ElimInvestRateEditUI"));
                }
                Date date = info.getDate();
                if (this.investeeCompanyChangeDateMap.containsKey(key) && !this.investeeCompanyChangeDateMap.get(key).equals(date)) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Invest_Repeat")));
                }
                IObjectPK curId = ElimInvestRateFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
                this.updateTemplate(ctx, curId.toString(), info, false);
                this.investeeCompanyChangeDateMap.put(key, date);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private ElimInvestRateInfo getSameInfo(ElimInvestRateCollection existsColl, ElimInvestRateInfo curInfo) {
        if (existsColl != null) {
            for (int i = 0; i < existsColl.size(); ++i) {
                if (!existsColl.get(i).getDate().equals(curInfo.getDate())) continue;
                return existsColl.get(i);
            }
        }
        return null;
    }

    private void updateTemplate(Context ctx, String id, ElimInvestRateInfo info, boolean isCove) throws Exception {
        if (org.apache.axis.utils.StringUtils.isEmpty((String)info.getTemplate())) {
            return;
        }
        String[] tmpNumberArr = info.getTemplate().split(",");
        IElimInvestRateEntry iElimInvestRateEntry = ElimInvestRateEntryFactory.getLocalInstance(ctx);
        StringBuffer inStr = new StringBuffer();
        for (String number : tmpNumberArr) {
            inStr.append("'").append(number).append("',");
        }
        inStr.deleteCharAt(inStr.lastIndexOf(","));
        InvestTempletCollection tmpIColl = InvestTempletFactory.getLocalInstance(ctx).getInvestTempletCollection("where number in(" + inStr + ")");
        if (isCove) {
            iElimInvestRateEntry.delete("where elimInvestRate.id='" + id + "'");
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < tmpIColl.size(); ++i) {
            ElimInvestRateEntryInfo curInfo = new ElimInvestRateEntryInfo();
            curInfo.setInvestTemplate(tmpIColl.get(i));
            curInfo.setElimInvestRate(info);
            coll.add((CoreBaseInfo)curInfo);
        }
        iElimInvestRateEntry.addnew(coll);
    }

    private String getMsg(Context ctx, String key, Object[] values) throws TaskExternalException {
        String msgs = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource", (String)key, (Locale)ctx.getLocale());
        if (values != null && values.length > 0) {
            msgs = MessageFormat.format(msgs, values);
        }
        return msgs;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            Integer year = (Integer)this.getContextParameter("rptYear");
            Integer period = (Integer)this.getContextParameter("rptPeriod");
            RptPeriodTypeEnum rptPeriodType = (RptPeriodTypeEnum)this.getContextParameter("rptPeriodType");
            OrgTreeInfo orgTree = (OrgTreeInfo)this.getContextParameter("orgBound");
            OrgUnitInfo orgUnit = (OrgUnitInfo)this.getContextParameter("orgUnit");
            Date rptDate = (Date)this.getContextParameter("reportDate");
            String companyNumber = ((DataToken)hsData.get("FCompany_number")).toString();
            String targetCompayNumber = ((DataToken)hsData.get("FTargetCompany_number")).toString();
            String effDate = ((DataToken)hsData.get("FDate")).toString();
            String rate = ((DataToken)hsData.get("FRate")).toString();
            String template = ((DataToken)hsData.get("FTemplate")).toString();
            String orgUnitNumber = ((DataToken)hsData.get("FOrgUnit_number")).toString();
            String description = ((DataToken)hsData.get("FDescription")).toString();
            StringBuffer inStr = new StringBuffer();
            inStr.append("'").append(companyNumber).append("','").append(targetCompayNumber).append("'");
            FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id,name,number where number in(" + inStr.toString() + ")");
            HashMap<String, FullOrgUnitInfo> number_info = new HashMap<String, FullOrgUnitInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                number_info.put(coll.get(i).getNumber(), coll.get(i));
            }
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)orgUnitNumber)) {
                try {
                    OrgStructureInfo orgInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select unit.id,unit.number,unit.name where unit.number='" + orgUnitNumber + "' and tree.id='" + orgTree.getId().toString() + "'");
                    if (orgInfo != null) {
                        number_info.put(orgUnitNumber, orgInfo.getUnit());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"orgUnitNumber is not exists", (Throwable)e);
                    throw new TaskExternalException(this.getMsg(ctx, "orgUnitNotExist", new Object[]{orgUnitNumber}), (Throwable)e);
                }
            }
            ElimInvestRateInfo info = new ElimInvestRateInfo();
            info.setId(null);
            info.setDate(dateFormat.parse(effDate));
            info.setRate(StringUtils.isEmpty((String)rate) ? null : new BigDecimal(rate));
            if (info.getRate() != null && (info.getRate().doubleValue() < 0.0 || info.getRate().doubleValue() > 100.0)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"457_ElimInvestRateEditUI"));
            }
            info.setOrgBound(orgTree);
            info.setTargetCompany((FullOrgUnitInfo)number_info.get(targetCompayNumber));
            info.setCompany((FullOrgUnitInfo)number_info.get(companyNumber));
            if (info.getCompany() == null) {
                throw new TaskExternalException(this.getMsg(ctx, "companyNotExist", new Object[]{companyNumber}));
            }
            if (info.getTargetCompany() == null) {
                throw new TaskExternalException(this.getMsg(ctx, "targetCompanyNotExist", new Object[]{targetCompayNumber}));
            }
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)orgUnitNumber)) {
                info.setOrgUnit((FullOrgUnitInfo)number_info.get(orgUnitNumber));
            } else {
                info.setOrgUnit((FullOrgUnitInfo)orgUnit);
            }
            info.setYear(year);
            info.setPeriod(period);
            info.setPeriodType(rptPeriodType);
            info.setRptDate(rptDate);
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)template)) {
                info.setTemplate(template);
            }
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)description)) {
                if (description.startsWith("=")) {
                    throw new TaskExternalException(this.getMsg(ctx, "remarkUnallowStartWithEqual-sign", null));
                }
                info.setDescription(description);
            }
            info.setIsLatest(true);
            info.setIsMonthLatest(true);
            info.setEquivRate(null);
            return info;
        }
        catch (Exception e) {
            logger.error((Object)"ElimInvestRateImport transmit error.", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            if (rs != null) {
                ht.put("FCompany_number", rs.getObject("company.number") == null ? "" : rs.getObject("company.number"));
                ht.put("FCompany_name_l1", rs.getObject("company.name") == null ? "" : rs.getObject("company.name"));
                ht.put("FTargetCompany_number", rs.getObject("targetCompany.number") == null ? "" : rs.getObject("targetCompany.number"));
                ht.put("FTargetCompany_name_l1", rs.getObject("targetCompany.name") == null ? "" : rs.getObject("targetCompany.name"));
                ht.put("FRate", rs.getObject("rate") == null ? "" : rs.getObject("rate"));
                ht.put("FDate", rs.getObject("date") == null ? "" : rs.getObject("date"));
                ht.put("FTemplate", rs.getObject("template") == null ? "" : rs.getObject("template"));
                ht.put("FOrgBound_number", rs.getObject("orgBound.number") == null ? "" : rs.getObject("orgBound.number"));
                ht.put("FOrgBound_name_l1", rs.getObject("orgBound.name") == null ? "" : rs.getObject("orgBound.name"));
                ht.put("FOrgUnit_number", rs.getObject("orgUnit.number") == null ? "" : rs.getObject("orgUnit.number"));
                ht.put("FOrgUnit_name_l1", rs.getObject("orgUnit.name") == null ? "" : rs.getObject("orgUnit.name"));
                ht.put("FDescription", rs.getObject("description") == null ? "" : rs.getObject("description"));
            }
            return ht;
        }
        catch (Exception ex) {
            logger.error((Object)"ElimInvestRateImport exportTransmit error.", (Throwable)ex);
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private ElimInvestRateCollection getExistsColl(Context ctx, ElimInvestRateInfo ElimInvestRate2) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)ElimInvestRate2.getOrgBound().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(ElimInvestRate2.getRptDate().getTime())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(ElimInvestRate2.getPeriod())));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(ElimInvestRate2.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ElimInvestRate2.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("targetCompany.id", (Object)ElimInvestRate2.getTargetCompany().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ElimInvestRateCollection elimInvestRateCollection = ElimInvestRateFactory.getLocalInstance(ctx).getElimInvestRateCollection(view);
        if (elimInvestRateCollection.size() > 0) {
            return elimInvestRateCollection;
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateQueryNew";
    }
}

