/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractElimReportFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DataSourceItemData;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DynaCslElimReportSaveImp;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.GenerateDynaCslElimReport4Server;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.GenerateMultiCslElimReport4Server;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IElimReportGenerate;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.MultiElimReportSaveImp;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.SheetToItemDataMap;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Point;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ElimReportFacadeControllerBean
extends AbstractElimReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ElimReportFacadeControllerBean");

    @Override
    protected Map _getElimReportByReportIds(Context ctx, List reportIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getCslReportSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(reportIds), CompareType.INCLUDE));
        view.setFilter(filter);
        HashMap<String, CslReportInfo> result = new HashMap<String, CslReportInfo>();
        CslReportCollection cslrptCol = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(view);
        if (cslrptCol == null || cslrptCol.size() == 0) {
            return result;
        }
        int size = cslrptCol.size();
        for (int i = 0; i < size; ++i) {
            CslReportInfo cslRptInfo = cslrptCol.get(i);
            CslReportInfo cslElimRptInfo = (CslReportInfo)this.getElimReportByCslReportInfo(ctx, cslRptInfo);
            if (cslElimRptInfo == null) continue;
            result.put(cslRptInfo.getId().toString(), cslElimRptInfo);
        }
        return result;
    }

    private SelectorItemCollection getCslReportSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("id");
        selectors.add("year");
        selectors.add("period");
        selectors.add("periodType");
        selectors.add("sourceType");
        selectors.add("template.id");
        selectors.add("template.group");
        selectors.add("currency.id");
        selectors.add("orgTree.id");
        selectors.add("orgTree.number");
        selectors.add("orgUnit.id");
        selectors.add("orgUnit.number");
        selectors.add("orgUnit.name");
        selectors.add("company.id");
        selectors.add("company.number");
        return selectors;
    }

    @Override
    protected IObjectValue _getElimReportByCslReportInfo(Context ctx, IObjectValue cslReportInfo) throws BOSException, EASBizException {
        CslReportInfo reportInfo = (CslReportInfo)cslReportInfo;
        int year = reportInfo.getYear();
        short period = reportInfo.getPeriod();
        int periodType = reportInfo.getPeriodType().getValue();
        String currencyId = reportInfo.getCurrency().getId().toString();
        String group = reportInfo.getTemplate().getGroup();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getCslReportSelector());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.appendFilterItem("year", (Object)year);
        filter.appendFilterItem("period", (Object)period);
        filter.appendFilterItem("periodType", (Object)periodType);
        filter.appendFilterItem("currency.id", (Object)currencyId);
        filter.appendFilterItem("template.group", (Object)group);
        if (ElimReportUtils.isCslReport(reportInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", ElimReportUtils.getRptSrcTypeSetOfElimRptInStatMerger(), CompareType.INCLUDE));
        }
        if (ElimReportUtils.isFastMergeReport(reportInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", ElimReportUtils.getRptSrcTypeSetOfElimRptInFastMerger(), CompareType.INCLUDE));
            filter.appendFilterItem("fastMergeSoluId", (Object)reportInfo.getFastMergeSoluId());
        }
        if (ElimReportUtils.isCslReport(reportInfo) || ElimReportUtils.isFastMergeReport(reportInfo)) {
            filter.appendFilterItem("orgUnit.id", (Object)reportInfo.getOrgUnit().getId().toString());
            filter.appendFilterItem("orgTree.id", (Object)reportInfo.getOrgTree().getId().toString());
        } else if (ElimReportUtils.isSingleReport(reportInfo)) {
            filter.appendFilterItem("company.id", (Object)reportInfo.getCompany().getId().toString());
        }
        CslReportCollection col = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(view);
        if (col != null & col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    @Override
    protected Map _getReportItemData(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        String pk = condition.getString("pk");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("sourceType");
        CslReportInfo cslreportInfo = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(pk), selectors);
        if (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)cslreportInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)cslreportInfo.getSourceType())) {
            return this.getDynaCslReportItemData(ctx, condition);
        }
        throw new RuntimeException(" report source type'" + cslreportInfo.getSourceType().getAlias() + " is not support");
    }

    private Map getDynaCslReportItemData(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        String pk = condition.getString("pk");
        Map sheetSumMthRela = (Map)condition.getObject("sheetSumMthRela");
        Map calcSumMthRela = (Map)condition.getObject("calcSumMthRela");
        StringBuilder sql = new StringBuilder(200);
        sql.append(" select entry.FSheetId,entry.FRow ,entry.FCol ,\n").append(" entry.FKeyNumber, entry.FItemId itemNumber, entry.FKeyName,\n").append(" entry.Fyear,entry.Fperiod, \n").append(" entry.FvalueType valueType,dataElement.Fnumber deNum, \n").append(" entry.FValue, entry.FTextValue \n").append(" from T_CSL_DynaItemData main \n").append(" join T_CSL_CslReport rpt on main.freportid = rpt.fid \n").append(" join T_CSL_DynaItemDataEntry entry on main.FId = entry.FItemDataId \n").append(" join T_CSL_DataElement dataElement on entry.FdataElement = dataElement.FInterSeq \n").append(" where rpt.FId = ? \n").append("");
        SheetToItemDataMap rstMap = new SheetToItemDataMap();
        if (sheetSumMthRela != null && sheetSumMthRela.size() != 0) {
            sql.append(" and (");
            boolean isMoreOne = false;
            for (Map.Entry entry : sheetSumMthRela.entrySet()) {
                if (isMoreOne) {
                    sql.append(" or ");
                }
                sql.append(" (main.fdynaType = " + entry.getValue() + " and entry.FSheetId = '" + (String)entry.getKey() + "' )");
                isMoreOne = true;
            }
            sql.append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk});
            int sumMethod = -1;
            StringBuffer key = new StringBuffer();
            boolean isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(ctx);
            if (rs != null) {
                try {
                    while (rs.next()) {
                        key.setLength(0);
                        String keyNumber = rs.getString("FKeyNumber");
                        String keyName = rs.getString("FKeyName");
                        String sheetId = rs.getString("FSheetId");
                        if (isDyRptSaveUpdateItem4CM) {
                            sumMethod = (Integer)calcSumMthRela.get(sheetId);
                            keyName = this.handleKeyName(keyName, sumMethod);
                            keyNumber = this.handleKeyNumber(keyNumber, sumMethod);
                        }
                        ElimReportUtils.combineKey(key, rs.getString("itemNumber"));
                        ElimReportUtils.combineKey(key, keyNumber);
                        ElimReportUtils.combineKey(key, rs.getString("Fyear"));
                        ElimReportUtils.combineKey(key, rs.getString("Fperiod"));
                        ElimReportUtils.combineKey(key, rs.getString("deNum"));
                        ElimReportUtils.combineKey(key, rs.getString("valueType"));
                        DataSourceItemData item = new DataSourceItemData(new Point(rs.getInt("FRow"), rs.getInt("FCol")), rs.getInt("valueType") != 3 ? rs.getObject("FValue") : rs.getObject("FTextValue"), key.toString(), rs.getInt("valueType"));
                        item.setExtObj(keyName);
                        rstMap.put(sheetId, item);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getCause());
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return rstMap;
    }

    private String handleKeyName(String keyName, int sumMethod) {
        String[] splitNames = this.decodeDNumber(keyName);
        if (5 == sumMethod) {
            if (splitNames.length > 1) {
                keyName = "[" + splitNames[0] + "]" + splitNames[splitNames.length - 1];
            }
        } else if (4 == sumMethod) {
            if (splitNames.length > 1) {
                keyName = splitNames[splitNames.length - 1] + "[" + splitNames[0] + "]";
            }
        } else if (2 == sumMethod && splitNames.length > 1) {
            keyName = splitNames[0];
        }
        return keyName;
    }

    private String handleKeyNumber(String keyName, int sumMethod) {
        String[] splitNames = this.decodeDNumber(keyName);
        if (5 == sumMethod) {
            if (splitNames.length > 1) {
                keyName = "[" + splitNames[0] + "]" + splitNames[splitNames.length - 1];
            }
        } else if (4 == sumMethod) {
            if (splitNames.length > 1) {
                keyName = splitNames[splitNames.length - 1] + "[" + splitNames[0] + "]";
            }
        } else if (2 == sumMethod && splitNames.length > 1) {
            keyName = splitNames[0];
        }
        return keyName;
    }

    private String[] decodeDNumber(String dname) {
        char[] chars = dname.toCharArray();
        ArrayList<String> arrs = new ArrayList<String>();
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if ((chars[i] == ']' || chars[i] == '[') && name.length() > 0) {
                arrs.add(name.toString());
                name.setLength(0);
                continue;
            }
            if (chars[i] == '[' || chars[i] == ']') continue;
            name.append(chars[i]);
        }
        if (name.length() > 0) {
            arrs.add(name.toString());
        }
        String[] names = new String[arrs.size()];
        return arrs.toArray(names);
    }

    @Override
    protected void _clearDynaItemData(Context ctx, String reportId) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        Statement st = null;
        Connection cn = null;
        try {
            cn = super.getConnection(ctx);
            st = cn.createStatement();
            strSql = strSql.append(" DELETE FROM T_CSL_DynaItemDataEntry ").append(" WHERE FItemDataID IN (").append("SELECT FID FROM T_CSL_DynaItemData WHERE FreportID = '" + reportId + "') ");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append(" DELETE FROM T_CSL_DynaItemData ");
            strSql = strSql.append(" WHERE FreportID = '" + reportId + "' ");
            st.addBatch(strSql.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    @Override
    protected void _generateDynaCslElimReport(Context ctx, List idLst, Map extMap) throws BOSException, EASBizException {
        if (idLst == null || idLst.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getCslReportSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idLst), CompareType.INCLUDE));
        view.setFilter(filter);
        CslReportCollection cslColl = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(view);
        if (cslColl == null || cslColl.size() == 0) {
            return;
        }
        try {
            int size = cslColl.size();
            for (int i = 0; i < size; ++i) {
                this.deleteDynaCslElimReport(ctx, cslColl.get(i));
                IElimReportGenerate server = RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)cslColl.get(i).getSourceType()) ? new GenerateMultiCslElimReport4Server(ctx, cslColl.get(i)) : new GenerateDynaCslElimReport4Server(ctx, cslColl.get(i));
                server.build();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteDynaCslElimReport(Context ctx, CslReportInfo cslReportInfo) throws BOSException, EASBizException {
        CslReportInfo elimRptInfo = (CslReportInfo)this._getElimReportByCslReportInfo(ctx, (IObjectValue)cslReportInfo);
        if (elimRptInfo != null) {
            CslReportFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(elimRptInfo.getId().toString()), true);
        }
    }

    @Override
    protected Map _copyElimReportByRptIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        Set<String> grpIds = this.collectTemplateGroupId(ctx, ids);
        CslReportCollection cslColl = this.getCslReportCollection(ctx, new HashSet(ids));
        String rptSrcTypeFilter = ElimReportUtils.isCslReport(cslColl.get(0)) ? "    and rpt.fsourceType in(42,45) \n" : "and rpt.fsourceType in(43,46) and rpt.FfastMergeSoluId ='" + cslColl.get(0).getFastMergeSoluId() + "' \n";
        int year = cslColl.get(0).getYear();
        short period = cslColl.get(0).getPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct rpt.fid from T_CSL_CslReport rpt \n").append(" join t_rpt_template tmpl on rpt.ftemplateid = tmpl.fid \n").append(" join t_org_tree tree on rpt.forgtreeid = tree.fid \n").append(" join t_org_baseunit unit on unit.fid = rpt.forgUnitid \n").append(" join ( \n").append("        select max(rpt.fyear) fyear,max(rpt.fperiod) fperiod,tmpl2.fgroup from t_csl_cslreport rpt \n").append("        join t_rpt_template tmpl2 on rpt.ftemplateid = tmpl2.fid \n").append("        join t_org_tree tree on rpt.forgtreeid = tree.fid \n").append("        join t_org_baseunit unit on unit.fid = rpt.forgUnitid \n").append("        join (select distinct tree.fnumber treeNum,unit.fnumber unitNum,FCurrencyId   \n").append(" \t\t     from t_csl_cslreport r                              \n").append("             join t_org_tree tree on r.forgtreeid = tree.fid     \n").append("             join t_org_baseunit unit on unit.fid = r.forgUnitid \n").append(" \t\t     where r.fid in(").append(CslRptUtil.AryToItemString(ids)).append(")\n").append(" \t\t) as flt \n").append(" on flt.treeNum = tree.fnumber          \n").append(" and flt.unitNum = unit.fnumber         \n").append(" and flt.fCurrencyId = rpt.fCurrencyId \n").append(" where tmpl2.fgroup in(").append(CslRptUtil.AryToItemString(grpIds)).append(")\n").append(rptSrcTypeFilter).append(" and (rpt.fyear=").append(year).append(" and rpt.fperiod<").append(period).append(" or rpt.fyear<").append(year).append(")").append("    group by tmpl2.fgroup ) as m \n").append(" on m.fyear = rpt.fyear and m.fperiod = rpt.fperiod and m.fgroup = tmpl.fgroup\n").append("        join (select distinct tree.fnumber treeNum,unit.fnumber unitNum,FCurrencyId   \n").append(" \t\t     from t_csl_cslreport r                              \n").append("             join t_org_tree tree on r.forgtreeid = tree.fid     \n").append("             join t_org_baseunit unit on unit.fid = r.forgUnitid \n").append(" \t\t     where r.fid in(").append(CslRptUtil.AryToItemString(ids)).append(")\n").append(" \t\t) as flt2 \n").append(" on flt2.treeNum = tree.fnumber \t     \n").append(" and flt2.unitNum = unit.fnumber         \n").append(" and flt2.fCurrencyId = rpt.fCurrencyId  \n").append(rptSrcTypeFilter);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> elimRptIds = new HashSet<String>(rs.size());
        try {
            while (rs.next()) {
                elimRptIds.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (elimRptIds.isEmpty()) {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            result.put(1, ElimReportUtils.getResource4Server("notExistElimRpt", ctx));
            return result;
        }
        this._deleteElimReportByRptIds(ctx, ids);
        CslReportCollection elimColl = this.getCslReportCollection(ctx, elimRptIds);
        try {
            int size = cslColl.size();
            for (int k = 0; k < size; ++k) {
                CslReportInfo copyInfo = cslColl.get(k);
                int size2 = elimColl.size();
                for (int i = 0; i < size2; ++i) {
                    if (!copyInfo.getTemplate().getGroup().equals(elimColl.get(i).getTemplate().getGroup())) continue;
                    copyInfo.setId(BOSUuid.create((BOSObjectType)copyInfo.getBOSType()));
                    copyInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                    copyInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
                    copyInfo.setAuditor(null);
                    copyInfo.setCommitor(null);
                    copyInfo.setAuditTime(null);
                    copyInfo.setSourceType(ElimReportUtils.getElimRptSrcTypeBySrcReportInfo(copyInfo));
                    copyInfo.setBook(elimColl.get(i).getBook());
                    if (ElimReportUtils.isMultiCslElimReport(copyInfo.getSourceType())) {
                        new MultiElimReportSaveImp().saveElimReport(ctx, copyInfo, new HashMap<Object, Object>(0));
                        continue;
                    }
                    new DynaCslElimReportSaveImp().saveElimReport(ctx, copyInfo, new HashMap<Object, Object>(0));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private CslReportCollection getCslReportCollection(Context ctx, Set ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("template.group");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        return CslReportFactory.getLocalInstance(ctx).getCslReportCollection(view);
    }

    private Set<String> collectTemplateGroupId(Context ctx, List rptIds) throws BOSException, EASBizException {
        HashSet<String> grpIds = new HashSet<String>();
        StringBuffer oql = new StringBuffer();
        oql.append(" select template.group ").append(" where id in(").append(CslRptUtil.AryToItemString(rptIds)).append(" )");
        CslReportCollection col = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oql.toString());
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            grpIds.add(col.get(i).getTemplate().getGroup());
        }
        return grpIds;
    }

    @Override
    protected Map _deleteElimReportByRptIds(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer oql = new StringBuffer();
        oql.append(" select id,auditedStatus,name,sourceType,orgunit.name").append(" where id in (").append(CslRptUtil.AryToItemString(ids)).append(")");
        StringBuffer unDeletedMsg = new StringBuffer();
        CslReportCollection col = CslReportFactory.getLocalInstance(ctx).getCslReportCollection(oql.toString());
        String tmpMsg = null;
        int sucessCount = 0;
        HashSet<String> unDeleteIds = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (!AuditedStatusEnum.AUDITED.equals((Object)col.get(i).getAuditedStatus())) continue;
            ids.remove(col.get(i).getId().toString());
            if (unDeleteIds.contains(col.get(i).getId().toString())) continue;
            if (tmpMsg == null) {
                tmpMsg = ElimReportUtils.getResource4Server("isAuditedCannotDelete", ctx);
            }
            unDeletedMsg.append(col.get(i).getSourceType().getAlias()).append(":[").append(col.get(i).getName()).append("(").append(col.get(i).getOrgUnit().getName()).append(")]").append(tmpMsg).append(" \n");
            unDeleteIds.add(col.get(i).getId().toString());
        }
        if (ids.size() == 0) {
            result.put("msg", unDeletedMsg.toString());
            result.put("sucessCount", sucessCount);
            return result;
        }
        Map map = this.getElimReportByReportIds(ctx, ids);
        if (map == null || map.size() == 0) {
            result.put("msg", unDeletedMsg.toString());
            result.put("sucessCount", sucessCount);
            return result;
        }
        HashSet<String> deleteIds = new HashSet<String>();
        StringBuffer deletedMsg = new StringBuffer();
        for (CslReportInfo elimRptInfo : map.values()) {
            String elimId = elimRptInfo.getId().toString();
            if (deleteIds.contains(elimId)) continue;
            if (!AuditedStatusEnum.AUDITED.equals((Object)elimRptInfo.getAuditedStatus())) {
                CslReportFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(elimId), true);
                ++sucessCount;
                deletedMsg.append(elimRptInfo.getSourceType().getAlias()).append(":[").append(elimRptInfo.getName()).append("(").append(elimRptInfo.getOrgUnit().getName()).append(")]\n");
            } else if (!unDeleteIds.contains(elimId)) {
                if (tmpMsg == null) {
                    tmpMsg = ElimReportUtils.getResource4Server("isAuditedCannotDelete", ctx);
                }
                unDeletedMsg.append(elimRptInfo.getSourceType().getAlias()).append(":[").append(elimRptInfo.getName()).append("(").append(elimRptInfo.getOrgUnit().getName()).append(")]").append(tmpMsg).append(" \n");
                unDeleteIds.add(elimId);
            }
            deleteIds.add(elimId);
        }
        unDeleteIds.clear();
        deleteIds.clear();
        if (deletedMsg.length() > 0) {
            deletedMsg.insert(0, ElimReportUtils.getResource4Server("DeleteSuccessList", ctx) + "\n");
            deletedMsg.append("\n").append(unDeletedMsg);
        }
        result.put("msg", deletedMsg.length() > 0 ? deletedMsg.toString() : unDeletedMsg.toString());
        result.put("sucessCount", sucessCount);
        return result;
    }

    @Override
    protected boolean _isExistElimReport(Context ctx, List ids) throws BOSException, EASBizException {
        Map map = this.getElimReportByReportIds(ctx, ids);
        return map != null && map.size() != 0;
    }
}

