/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DispenseSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletGroupCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletGroupInfo;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseException;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractElimTempletGroupControllerBean;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class ElimTempletGroupControllerBean
extends AbstractElimTempletGroupControllerBean {
    @Override
    protected boolean _checkItemExists(Context ctx, RPTItemInfo item, ElimTempletGroupInfo group) throws BOSException {
        return false;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ElimTempletGroupInfo info = this.getElimTempletGroupInfo(ctx, pk);
        return info.getNumber() + "  " + info.getName();
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, (ElimTempletGroupInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    private void addNewCheck(Context ctx, ElimTempletGroupInfo model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletGroupInfo dataBaseInfo = (ElimTempletGroupInfo)model;
        String name = dataBaseInfo.getName();
        if (name == null || name.equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletGroupInfo dataBaseInfo = (ElimTempletGroupInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ObjectBaseCollection results = this.getObjectBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{dataBaseInfo.getName()});
        }
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletGroupInfo dataBaseInfo = (ElimTempletGroupInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ElimTempletGroupInfo dataBaseInfo = (ElimTempletGroupInfo)model;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        ElimTempletGroupCollection elimTempletGroupCollection = this.getElimTempletGroupCollection(ctx, view);
        if (elimTempletGroupCollection.size() > 0) {
            ElimTempletGroupInfo infoInDB = elimTempletGroupCollection.get(0);
            if (infoInDB.getNumber().equals(dataBaseInfo.getNumber())) {
                throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
            }
            if (infoInDB.getName().equals(dataBaseInfo.getName())) {
                throw new SundryException(SundryException.NAMEEXISTINORG, new Object[]{infoInDB.getName(), infoInDB.getTrackRecordCreator().getName()});
            }
        }
    }

    private EntityViewInfo buildIsNumExistView(ElimTempletGroupInfo billBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItemName = new FilterItemInfo("name", (Object)billBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemName);
        if (billBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("(#0 or #1) and #2");
        } else {
            filter.setMaskString("#0 or #1");
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("name"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        this._isReferenced(ctx, pk);
        this.checkTemplateDispense(ctx, pk);
        this.deleteFromDispense(ctx);
    }

    private void deleteFromDispense(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select distinct t.fdispensesrcid,t.ftype  from t_csl_templetdispense t where fsourcetype = 2 and not exists (");
        oql.append("select fid from T_CSL_ElimTempletGroup e where e.fid = t.fdispensesrcid )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            while (rs.next()) {
                oql = new StringBuffer();
                oql.append("delete from ").append(TemplateDispenseNewUtil.getDispTableByType((int)rs.getInt("ftype"))).append(" where fdispensesrcid = ? ");
                DbUtil.execute((Context)ctx, (String)oql.toString(), (Object[])new Object[]{rs.getString("fdispensesrcid")});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkTemplateDispense(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("dispenseSrcID", (Object)pk.toString());
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("sourceType", (Object)new Integer(DispenseSrcTypeEnum.ELIMTEMPLETGROUP.getValue()));
        filter.getFilterItems().add(filterItem2);
        ITempletDispense iDis = TempletDispenseFactory.getLocalInstance(ctx);
        boolean isExist = iDis.exists(filter);
        if (isExist) {
            throw new TempletDispenseException(TempletDispenseException.ALREADYDISPENSED);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCheck(ctx, pk);
        super._delete(ctx, pk);
    }
}

