/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CompanyTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IInvestTempletEntry;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDCRuleEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminateByHkCostMethodControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.InvestDayUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EliminateByHkCostMethodControllerBean
extends AbstractEliminateByHkCostMethodControllerBean {
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal ONE = new BigDecimal("1");
    private static final String KEY_CURRENCY = "KeyCurrency";
    private static final String KEY_COMPANY = "KeyCompany";
    private static final String KEY_ITEM = "KeyItem";
    private IInvestTempletEntry iinvestTempletEntry = null;

    @Override
    protected boolean _checkExists(Context ctx, Map mapParams) throws BOSException, EASBizException {
        List lstTemplateID;
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        int iElimType = 5;
        List lstTemplate = null;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        int iPeriod = (Integer)mapParams.get("Period");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        iElimType = (Integer)mapParams.get("ElimType");
        if (mapParams.containsKey("KEY_TEMPLATE")) {
            lstTemplate = (List)mapParams.get("KEY_TEMPLATE");
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where orgBound.id = '").append(orgTreeId).append("'");
        oql.append(" and orgUnit.id = '").append(orgUnitId).append("'");
        oql.append(" and year = ").append(iYear);
        oql.append(" and period = ").append(iPeriod);
        oql.append(" and periodType = ").append(iPeriodType);
        oql.append(" and elimType = ").append(iElimType);
        if (lstTemplate == null || lstTemplate.size() == 0) {
            throw new BOSException("Data Error:Not found selected template!");
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR)) {
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISYEAR_FIRSTDAY);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISYEAR_OTHERINVEST);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISDAY);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_FEWSHARESHOLDER);
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR) || lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_THISYEAR_PROFITDIST)) {
            lstTemplate.add(InvestTempletEnum.HK_INVEST_ELIM_INVESTDAY);
        }
        if ((lstTemplateID = this.getTemplateID(ctx, lstTemplate)) != null && lstTemplateID.size() > 0) {
            oql.append(" and templetID in (");
            for (int i = 0; i < lstTemplateID.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                oql.append("'" + lstTemplateID.get(i) + "'");
            }
            oql.append(")");
            if (elimination.exists(oql.toString() + " and checkedStatus = 2")) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Exists_Audited_EliminationDatas", (Locale)ctx.getOriginLocale())));
            }
            return elimination.exists(oql.toString());
        }
        return false;
    }

    private List getTemplateID(Context ctx, List lstParams) throws BOSException {
        if (lstParams != null && lstParams.size() > 0) {
            StringBuffer oql = new StringBuffer();
            oql.append("select fid from T_CSL_InvestTemplet where felimType = ");
            oql.append(5);
            oql.append(" and ftempletType in (");
            for (int i = 0; i < lstParams.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                int templateType = ((InvestTempletEnum)((Object)lstParams.get(i))).getValue();
                oql.append(templateType);
            }
            oql.append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            ArrayList<String> result = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    result.add(rowSet.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return result;
        }
        return null;
    }

    @Override
    protected void _delete(Context ctx, Map mapParams) throws BOSException, EASBizException {
        List lstTemplateID;
        IElimination elimination = EliminationFactory.getLocalInstance(ctx);
        int iElimType = 5;
        List lstTemplate = null;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        int iPeriod = (Integer)mapParams.get("Period");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        iElimType = (Integer)mapParams.get("ElimType");
        if (mapParams.containsKey("KEY_TEMPLATE")) {
            lstTemplate = (List)mapParams.get("KEY_TEMPLATE");
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where orgBound.id = '").append(orgTreeId).append("'");
        oql.append(" and orgUnit.id = '").append(orgUnitId).append("'");
        oql.append(" and year = ").append(iYear);
        oql.append(" and period = ").append(iPeriod);
        oql.append(" and periodType = ").append(iPeriodType);
        oql.append(" and elimType = ").append(iElimType);
        if (lstTemplate == null || lstTemplate.size() == 0) {
            throw new BOSException("Data Error:Not found selected template!");
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR)) {
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISYEAR_FIRSTDAY);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISYEAR_OTHERINVEST);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_THISDAY);
            lstTemplate.add(InvestTempletEnum.HK_INVEST_FEWSHARESHOLDER);
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR) || lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_THISYEAR_PROFITDIST)) {
            lstTemplate.add(InvestTempletEnum.HK_INVEST_ELIM_INVESTDAY);
        }
        if ((lstTemplateID = this.getTemplateID(ctx, lstTemplate)) != null && lstTemplateID.size() > 0) {
            oql.append(" and templetID in (");
            for (int i = 0; i < lstTemplateID.size(); ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                oql.append("'" + lstTemplateID.get(i) + "'");
            }
            oql.append(")");
            elimination.delete(oql.toString());
        }
    }

    private String getTemplateIdByType(Context ctx, int templetType) throws EASBizException, BOSException {
        String oql = "select fid from t_csl_investTemplet where ftempletType = ?";
        Object[] param = new Object[]{new Integer(templetType)};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql, (Object[])param);
        try {
            if (rowSet.next()) {
                return rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        throw new ServerException(ServerException.NOT_FOUND_SYS_INVESTTEMPLATE, new Object[]{InvestTempletEnum.getEnum(templetType).getAlias()});
    }

    private InvestTempletEntryInfo getTempletEntryBySeq(Context ctx, String templetId, int seq, Map entries) throws EASBizException, BOSException {
        InvestTempletEntryInfo info = (InvestTempletEntryInfo)entries.get(templetId + seq);
        if (info != null) {
            return info;
        }
        String oql = " where templet.id = '" + templetId + "' and seq = " + seq;
        info = this.iinvestTempletEntry.getInvestTempletEntryInfo(oql);
        if (info == null) {
            throw new ServerException(ServerException.NOT_FOUND_SYS_INVESTTEMPLATE);
        }
        entries.put(templetId + seq, info);
        return info;
    }

    @Override
    protected void _createElimRecords(Context ctx, Map mapParams) throws BOSException, EASBizException {
        this.iinvestTempletEntry = InvestTempletEntryFactory.getLocalInstance(ctx);
        List lstTemplate = (List)mapParams.get("KEY_TEMPLATE");
        ArrayList eliminations = new ArrayList(0);
        HashMap eliminationNew = new HashMap();
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR)) {
            this.createElimRecordForBeforeYear(ctx, eliminations, mapParams);
            eliminations.addAll(eliminationNew.values());
            eliminationNew.clear();
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_THISYEAR_PROFITDIST)) {
            this.createElimRecordForThisYearProfitDist(ctx, eliminationNew, mapParams);
            eliminations.addAll(eliminationNew.values());
            eliminationNew.clear();
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_BEFOREYEAR) || lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_THISYEAR_PROFITDIST)) {
            this.createElimRecordForInvestDayInvest(ctx, eliminationNew, mapParams);
            eliminations.addAll(eliminationNew.values());
            eliminationNew.clear();
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_ELIMOTHERASSET)) {
            this.createElimRecordForOtherOwnerSum(ctx, eliminationNew, mapParams);
            eliminations.addAll(eliminationNew.values());
            eliminationNew.clear();
        }
        if (lstTemplate.contains((Object)InvestTempletEnum.HK_INVEST_POOL)) {
            this.createElimRecordForPool(ctx, eliminationNew, mapParams);
            eliminations.addAll(eliminationNew.values());
            eliminationNew.clear();
        }
        if (!eliminations.isEmpty()) {
            IElimination elimination = EliminationFactory.getLocalInstance(ctx);
            ICodingRuleManager icodeManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            EliminationInfo elimInfo = new EliminationInfo();
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)mapParams.get("KEY_ORGTREE_INFO");
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mapParams.get("KEY_ORGUNIT_INFO");
            elimInfo.setOrgBound(orgTreeInfo);
            elimInfo.setOrgUnit(orgUnitInfo);
            elimInfo.setYear((Integer)mapParams.get("Year"));
            elimInfo.setPeriod((Integer)mapParams.get("Period"));
            String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(ctx);
            boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)elimInfo, strOrgID);
            for (EliminationInfo newInfo : eliminations) {
                String number = strOrgID != null && hasCodeRule ? icodeManager.getNumber((IObjectValue)elimInfo, strOrgID) : this.getMaxNumber(ctx, mapParams, "T_CSL_Elimination");
                newInfo.setNumber(number);
                if (mapParams.get("displayTypeId") != null) {
                    String typeid = (String)mapParams.get("displayTypeId");
                    BOSUuid id = BOSUuid.read((String)typeid);
                    TemplateTypeInfo type = new TemplateTypeInfo();
                    type.setId(id);
                    newInfo.setDisplayTemplateType(type);
                }
                elimination.submit((CoreBaseInfo)newInfo);
            }
        }
        this.iinvestTempletEntry = null;
    }

    private void createElimRecordForBeforeYear(Context ctx, Collection eliminations, Map mapParams) throws BOSException, EASBizException {
        String orgUnitId;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        Map mapAttachCompany = InvestDayUtil.getTwoTypeCompanyForInvest(ctx, orgTreeId, orgUnitId = (String)mapParams.get("OrgUnitID"), 1, 3);
        if (mapAttachCompany == null || mapAttachCompany.size() <= 0) {
            return;
        }
        HashMap mapElimination = new HashMap();
        this.createElimRecordForBeforeYearLongInvest(ctx, mapElimination, mapAttachCompany, mapParams);
        eliminations.addAll(mapElimination.values());
        mapElimination.clear();
        this.createElimRecordForCurYearLongInvest(ctx, mapElimination, mapAttachCompany, mapParams);
        eliminations.addAll(mapElimination.values());
        mapElimination.clear();
        this.createElimRecordForThisDayInvestProfitLoss(ctx, mapElimination, mapAttachCompany, mapParams);
        eliminations.addAll(mapElimination.values());
        mapElimination.clear();
        this.createElimRecordForFewHolderInterests(ctx, mapElimination, mapAttachCompany, mapParams);
        eliminations.addAll(mapElimination.values());
        mapElimination.clear();
    }

    private void createElimRecordForBeforeYearLongInvest(Context ctx, Map mapElimination, Map mapAttachCompany, Map mapParams) throws BOSException, EASBizException {
        int iYear = (Integer)mapParams.get("Year");
        String templetId = this.getTemplateIdByType(ctx, 6);
        String summary = InvestTempletEnum.HK_INVEST_BEFOREYEAR.getAlias();
        HashMap entries = new HashMap();
        Set set = mapAttachCompany.keySet();
        for (String sourceCompanyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(sourceCompanyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                List investDayValues = this.getEndOfLastYearOwnerSum(ctx, targetCompanyId, mapParams, templetEntry.isIsSumItemExtend());
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                investDayValues = InvestDayUtil.getEndOfLastYearHonorSum(ctx, sourceCompanyId, targetCompanyId, iYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                investDayValues = InvestDayUtil.getEndOfLastYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, iYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
                investDayValues = this.getBeforeYearFewHolderInterest(ctx, sourceCompanyId, targetCompanyId, mapParams);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                investDayValues = this.caclEntryDist(mapElimination, false);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private List getEndOfLastYearOwnerSum(Context ctx, String targetCompanyId, Map mapParams, boolean expanded) throws EASBizException, BOSException {
        int iYear = (Integer)mapParams.get("Year");
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        java.util.Date endOfLastYear = RPTDateUtil.getEndOfYear(iYear - 1);
        int[] arrPeriodType = RPTDateUtil.getPeriod(endOfLastYear, RptPeriodTypeEnum.getEnum((int)iPeriodType));
        RPTItemInfo item = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.OWNER_EQUITY_SUM, mapParams);
        int sourceType = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select FUnitId, FStockControlCompanyID from T_ORG_OUPartUnionGroup");
        sql.append(" where FUnitId in (");
        sql.append("select a.FUnitId from t_org_structure a join t_org_structure b");
        sql.append(" on a.FId = b.FParentId");
        sql.append(" where b.FTreeId = ? and b.FUnitId = ?)");
        sql.append(" and FStockControlCompanyID is not null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, targetCompanyId});
        try {
            String controlCompanyId;
            if (rowSet.next() && (controlCompanyId = rowSet.getString("FStockControlCompanyID")).equals(targetCompanyId)) {
                targetCompanyId = rowSet.getString("FUnitId");
                sourceType = 3;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ArrayList result = new ArrayList();
        if (expanded) {
            StringBuffer buf = new StringBuffer();
            buf.append("select i.FId, i.FNumber");
            buf.append(" from T_CSL_RptItem i join T_CSL_RptItemMapping m");
            buf.append(" on i.fid = m.FSourceItem");
            buf.append(" where m.FTargetItem = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (Object[])new Object[]{item.getId().toString()});
            List currencyIds = this.getCurrencyIds(ctx);
            int size = currencyIds.size();
            try {
                while (rowSet.next()) {
                    String itemId = rowSet.getString("FId");
                    String itemNumber = rowSet.getString("FNumber");
                    for (int i = 0; i < size; ++i) {
                        String currencyId = (String)currencyIds.get(i);
                        BigDecimal dbValue = this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeId, arrPeriodType[0], arrPeriodType[1], sourceType, 4);
                        if (dbValue == null) continue;
                        HashMap<String, Object> data = new HashMap<String, Object>(4);
                        data.put("RPTITEM_ID", itemId);
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", dbValue);
                        result.add(data);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            List currencyIds = this.getCurrencyIds(ctx);
            int size = currencyIds.size();
            for (int i = 0; i < size; ++i) {
                String currencyId = (String)currencyIds.get(i);
                BigDecimal dbValue = this.getAcctItem(ctx, targetCompanyId, currencyId, item.getNumber(), orgTreeId, arrPeriodType[0], arrPeriodType[1], sourceType, 4);
                if (dbValue == null) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", dbValue);
                result.add(data);
            }
        }
        return result;
    }

    private List getBeforeYearFewHolderInterest(Context ctx, String companyId, String targetCompanyId, Map mapParams) throws BOSException, EASBizException {
        int iYear = (Integer)mapParams.get("Year");
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        java.util.Date endOfLastYear = RPTDateUtil.getEndOfYear(iYear - 1);
        int[] arrPeriodType = RPTDateUtil.getPeriod(endOfLastYear, RptPeriodTypeEnum.getEnum((int)iPeriodType));
        String itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.OWNER_EQUITY_SUM, mapParams).getNumber();
        List sumInvestRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, iYear - 1);
        int sourceType = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select FUnitId, FStockControlCompanyID from T_ORG_OUPartUnionGroup");
        sql.append(" where FUnitId in (");
        sql.append("select a.FUnitId from t_org_structure a join t_org_structure b");
        sql.append(" on a.FId = b.FParentId");
        sql.append(" where b.FTreeId = ? and b.FUnitId = ?)");
        sql.append(" and FStockControlCompanyID is not null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, targetCompanyId});
        try {
            String controlCompanyId;
            if (rowSet.next() && (controlCompanyId = rowSet.getString("FStockControlCompanyID")).equals(targetCompanyId)) {
                targetCompanyId = rowSet.getString("FUnitId");
                sourceType = 3;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ArrayList result = new ArrayList();
        for (Map mapSumInvestRate : sumInvestRate) {
            String currencyId = (String)mapSumInvestRate.get("KEY_CURRENCY_ID");
            HashMap<String, Object> mapInvestDay = new HashMap<String, Object>(4);
            mapInvestDay.put("KEY_CURRENCY_ID", currencyId);
            BigDecimal dbValue = this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeId, arrPeriodType[0], arrPeriodType[1], sourceType, 4);
            if (dbValue == null) continue;
            BigDecimal dbRate = (BigDecimal)mapSumInvestRate.get("Value");
            dbValue = dbValue.multiply(ONE.subtract(dbRate));
            mapInvestDay.put("Value", dbValue);
            result.add(mapInvestDay);
        }
        return result;
    }

    private void createElimRecordForCurYearLongInvest(Context ctx, Map mapElimination, Map mapAttachCompany, Map mapParams) throws BOSException, EASBizException {
        int iYear = (Integer)mapParams.get("Year");
        Set set = mapAttachCompany.keySet();
        String firstTempletId = this.getTemplateIdByType(ctx, 7);
        String summary = InvestTempletEnum.HK_INVEST_THISYEAR_INVEST.getAlias();
        String otherTempletId = this.getTemplateIdByType(ctx, 19);
        HashMap entries = new HashMap();
        for (String sourceCompanyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(sourceCompanyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                List investDayCl;
                InvestTempletEntryInfo templetEntry;
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                boolean isThisYearByFirstInvest = InvestDayUtil.isThisYearByFirstInvest(ctx, sourceCompanyId, targetCompanyId, null, iYear);
                if (isThisYearByFirstInvest) {
                    templetEntry = this.getTempletEntryBySeq(ctx, firstTempletId, 1, entries);
                    investDayCl = InvestDayUtil.getFirstOwnerSum(ctx, sourceCompanyId, targetCompanyId, templetEntry.isIsSumItemExtend(), true);
                    this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                    templetEntry = this.getTempletEntryBySeq(ctx, firstTempletId, 2, entries);
                    investDayCl = InvestDayUtil.getFirstHonor(ctx, sourceCompanyId, targetCompanyId);
                    this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                    templetEntry = this.getTempletEntryBySeq(ctx, firstTempletId, 3, entries);
                    investDayCl = InvestDayUtil.getFirstSumInvestAmount(ctx, sourceCompanyId, targetCompanyId);
                    this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                    templetEntry = this.getTempletEntryBySeq(ctx, firstTempletId, 4, entries);
                    investDayCl = InvestDayUtil.getFirstMinority(ctx, sourceCompanyId, targetCompanyId);
                    this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                }
                templetEntry = this.getTempletEntryBySeq(ctx, otherTempletId, 1, entries);
                investDayCl = InvestDayUtil.getThisYearMinoritySum(ctx, sourceCompanyId, targetCompanyId, iYear, false);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, otherTempletId, 2, entries);
                investDayCl = InvestDayUtil.getThisYearHonorSum(ctx, sourceCompanyId, targetCompanyId, iYear, false);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, otherTempletId, 3, entries);
                investDayCl = InvestDayUtil.getThisYearOwnerSum(ctx, sourceCompanyId, targetCompanyId, iYear, templetEntry.isIsSumItemExtend(), false);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, otherTempletId, 4, entries);
                investDayCl = InvestDayUtil.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, iYear, false);
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private void createElimRecordForThisDayInvestProfitLoss(Context ctx, Map mapElimination, Map mapAttachCompany, Map mapParams) throws BOSException, EASBizException {
        int iYear = (Integer)mapParams.get("Year");
        String templetId = this.getTemplateIdByType(ctx, 8);
        String summary = InvestTempletEnum.HK_INVEST_THISDAY.getAlias();
        Set set = mapAttachCompany.keySet();
        HashMap entries = new HashMap();
        for (String sourceCompanyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(sourceCompanyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                List investDayCl = InvestDayUtil.getThisYearProfit(ctx, sourceCompanyId, targetCompanyId, iYear, templetEntry.isIsSumItemExtend());
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                investDayCl = InvestDayUtil.getThisYearProfit(ctx, sourceCompanyId, targetCompanyId, iYear, templetEntry.isIsSumItemExtend());
                this.mergeElimination(ctx, mapElimination, investDayCl, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private void createElimRecordForFewHolderInterests(Context ctx, Map mapElimination, Map mapAttachCompany, Map mapParams) throws BOSException, EASBizException {
        String templetId = this.getTemplateIdByType(ctx, 9);
        String summary = InvestTempletEnum.HK_INVEST_FEWSHARESHOLDER.getAlias();
        Set set = mapAttachCompany.keySet();
        HashMap entries = new HashMap();
        for (String companyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(companyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                List fewHolderInterest = this.getFewHolderInterestForThisYear(ctx, companyId, targetCompanyId, mapParams);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                this.mergeElimination(ctx, mapElimination, fewHolderInterest, companyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                this.mergeElimination(ctx, mapElimination, fewHolderInterest, companyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private List getFewHolderInterestForThisYear(Context ctx, String sourceCompanyId, String targetCompanyId, Map mapParams) throws EASBizException, BOSException {
        ArrayList result;
        block11: {
            int iYear;
            block10: {
                result = new ArrayList();
                iYear = (Integer)mapParams.get("Year");
                java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
                if (InvestDayUtil.existsInvest(ctx, sourceCompanyId, targetCompanyId, iYear)) break block10;
                List lstRate = InvestDayUtil.getThisDaySumInvestRate(ctx, sourceCompanyId, targetCompanyId, rptDate);
                if (lstRate == null || lstRate.size() <= 0) break block11;
                int n = lstRate.size();
                for (int j = 0; j < n; ++j) {
                    Map mapRate = (Map)lstRate.get(j);
                    String currencyID = (String)mapRate.get("KEY_CURRENCY_ID");
                    BigDecimal bdRateValue = (BigDecimal)mapRate.get("Value");
                    BigDecimal bdProfitValue = this.getPeriodEndProfit(ctx, targetCompanyId, currencyID, mapParams);
                    if (bdProfitValue == null) continue;
                    BigDecimal bdResultValue = bdProfitValue.multiply(ONE.subtract(bdRateValue));
                    HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                    mapTemp.put("KEY_CURRENCY_ID", currencyID);
                    mapTemp.put("Value", bdResultValue);
                    result.add(mapTemp);
                }
                break block11;
            }
            Map mapProfit = InvestDayUtil.getThisYearAllProfit(ctx, sourceCompanyId, targetCompanyId, iYear);
            for (String currencyId : mapProfit.keySet()) {
                BigDecimal resultValue;
                List allProfits = (List)mapProfit.get(currencyId);
                int size = allProfits.size();
                if (size == 0) continue;
                BigDecimal beginOfYearSumInvestRate = InvestDayUtil.getBeginOfThisYearSumInvestRate(ctx, sourceCompanyId, targetCompanyId, currencyId, iYear);
                if (beginOfYearSumInvestRate != null && beginOfYearSumInvestRate.compareTo(ZERO) != 0) {
                    resultValue = ZERO;
                    BigDecimal bdPrevProfit = ZERO;
                    BigDecimal bdPrevSumInvestRate = ZERO;
                    for (int iRow = 0; iRow < size; ++iRow) {
                        Map mapProfitDetail = (Map)allProfits.get(iRow);
                        BigDecimal bdCurProfit = (BigDecimal)mapProfitDetail.get("Value");
                        BigDecimal bdCurSumInvestRate = (BigDecimal)mapProfitDetail.get("SumInvestRate");
                        resultValue = iRow == 0 ? bdCurProfit.multiply(ONE.subtract(beginOfYearSumInvestRate)) : resultValue.add(bdCurProfit.subtract(bdPrevProfit).multiply(ONE.subtract(bdPrevSumInvestRate)));
                        if (iRow == size - 1) {
                            BigDecimal bdEndProfit = this.getPeriodEndProfit(ctx, targetCompanyId, currencyId, mapParams);
                            if (bdEndProfit == null) {
                                bdEndProfit = ZERO;
                            }
                            resultValue = resultValue.add(bdEndProfit.subtract(bdCurProfit).multiply(ONE.subtract(bdCurSumInvestRate)));
                            continue;
                        }
                        bdPrevProfit = bdCurProfit;
                        bdPrevSumInvestRate = bdCurSumInvestRate;
                    }
                    HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                    mapTemp.put("KEY_CURRENCY_ID", currencyId);
                    mapTemp.put("Value", resultValue);
                    result.add(mapTemp);
                    continue;
                }
                resultValue = ZERO;
                BigDecimal lastProfit = ZERO;
                for (int iRow = size - 1; iRow >= 0; --iRow) {
                    Map mapProfitDetail = (Map)allProfits.get(iRow);
                    BigDecimal curProfit = (BigDecimal)mapProfitDetail.get("Value");
                    BigDecimal curSumInvestRate = (BigDecimal)mapProfitDetail.get("SumInvestRate");
                    if (iRow == size - 1) {
                        BigDecimal endProfit = this.getPeriodEndProfit(ctx, targetCompanyId, currencyId, mapParams);
                        if (endProfit == null) {
                            endProfit = ZERO;
                        }
                        BigDecimal endSumInvestRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, sourceCompanyId, targetCompanyId, iYear, currencyId);
                        resultValue = endProfit.subtract(curProfit).multiply(ONE.subtract(endSumInvestRate));
                    } else {
                        resultValue = resultValue.add(lastProfit.subtract(curProfit).multiply(ONE.subtract(curSumInvestRate)));
                    }
                    lastProfit = curProfit;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", resultValue);
                result.add(data);
            }
        }
        return result;
    }

    private BigDecimal getPeriodEndProfit(Context ctx, String targetCompanyId, String currencyId, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        StringBuffer sql = new StringBuffer();
        sql.append("select FUnitId, FStockControlCompanyID from T_ORG_OUPartUnionGroup");
        sql.append(" where FUnitId in (");
        sql.append("select a.FUnitId from t_org_structure a join t_org_structure b");
        sql.append(" on a.FId = b.FParentId");
        sql.append(" where b.FTreeId = ? and b.FUnitId = ?)");
        sql.append(" and FStockControlCompanyID is not null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, targetCompanyId});
        try {
            String controlCompanyId;
            if (rowSet.next() && (controlCompanyId = rowSet.getString("FStockControlCompanyID")).equals(targetCompanyId)) {
                String unitId = rowSet.getString("FUnitId");
                return this.getPeriodEndNetProfit(ctx, unitId, currencyId, 3, mapParams);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return this.getPeriodEndNetProfit(ctx, targetCompanyId, currencyId, 1, mapParams);
    }

    private BigDecimal getPeriodEndNetProfit(Context ctx, String targetCompanyId, String currencyId, int sourceType, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
        int[] arrPeriodType = RPTDateUtil.getPeriod(rptDate, RptPeriodTypeEnum.getEnum((int)iPeriodType));
        String itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.NET_PROFIT, mapParams).getNumber();
        return this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeId, arrPeriodType[0], arrPeriodType[1], sourceType, 3);
    }

    private void mergeElimination(Context ctx, Map mapElimination, List investDayCl, String companyId, String targetCompanyId, InvestTempletEntryInfo templetEntry, String summary, Map mapParams) throws BOSException, EASBizException {
        if (investDayCl == null || investDayCl.isEmpty()) {
            return;
        }
        int dataElement = templetEntry.getDataElement();
        InvestItemDCRuleEnum dcRule = templetEntry.getDcType();
        String strCompanyID = templetEntry.getCompanyType().equals((Object)CompanyTypeEnum.FROM_INVEST) ? companyId : targetCompanyId;
        RPTItemInfo item = this.getRptItemByCtrlAttr(ctx, templetEntry.getControlAttr(), mapParams);
        int size = investDayCl.size();
        for (int i = 0; i < size; ++i) {
            String strItemID;
            Map mapInvestDay = (Map)investDayCl.get(i);
            dataElement = templetEntry.getDataElement();
            BigDecimal bdValue = (BigDecimal)mapInvestDay.get("Value");
            if (bdValue == null || bdValue.compareTo(ZERO) == 0) continue;
            String currencyId = (String)mapInvestDay.get("KEY_CURRENCY_ID");
            RPTItemInfo tmpItem = item;
            if (mapInvestDay.containsKey("RPTITEM_ID") && (tmpItem = this.getItemByID(ctx, strItemID = (String)mapInvestDay.get("RPTITEM_ID"), mapParams)).getControl().equals((Object)RPTItemControlEnum.UNSHARED_PROFIT)) {
                tmpItem = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.UNALLOTGAIN_SYEAR, mapParams);
                dataElement = 3;
            }
            String templetId = templetEntry.getTemplet().getId().toString();
            this.mergeElimEntry(ctx, mapElimination, strCompanyID, currencyId, templetId, tmpItem, dataElement, dcRule, bdValue, summary, mapParams);
        }
    }

    private void mergeElimEntry(Context ctx, Map mapElimination, String companyId, String currencyId, String templetId, RPTItemInfo item, int dataElement, InvestItemDCRuleEnum dcRule, BigDecimal value, String summary, Map mapParams) throws EASBizException, BOSException {
        EliminationInfo elimination = null;
        FullOrgUnitInfo company = this.getCompanyByID(ctx, companyId, mapParams);
        if (!mapElimination.containsKey(currencyId)) {
            elimination = new EliminationInfo();
            elimination.setSourceCurrency(this.getCurrencyByID(ctx, currencyId, mapParams));
            elimination.setCurrency(this.getCurrencyByID(ctx, currencyId, mapParams));
            elimination.setOrgBound((OrgTreeInfo)mapParams.get("KeyOrgTree"));
            elimination.setOrgUnit((OrgUnitInfo)mapParams.get("KeyOrgUnit"));
            int iPeriodType = (Integer)mapParams.get("PeriodType");
            elimination.setPeriodType(RptPeriodTypeEnum.getEnum((int)iPeriodType));
            int iYear = (Integer)mapParams.get("Year");
            elimination.setYear(iYear);
            int iPeriod = (Integer)mapParams.get("Period");
            elimination.setPeriod(iPeriod);
            elimination.setElimType(ElimTypeEnum.HK_COST);
            java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
            elimination.setDate(rptDate);
            elimination.setTempletID(templetId);
            elimination.getEntries().add(this.getElimEntryInfo(ctx, item, dataElement, company, value, dcRule, summary));
            mapElimination.put(currencyId, elimination);
        } else {
            boolean isFind = false;
            elimination = (EliminationInfo)mapElimination.get(currencyId);
            int n = elimination.getEntries().size();
            for (int j = 0; j < n; ++j) {
                EliminationEntryInfo elimEntryInfo = elimination.getEntries().get(j);
                if (!elimEntryInfo.getCompany().getId().toString().equals(companyId) || !elimEntryInfo.getItem().getId().equals((Object)item.getId()) || elimEntryInfo.getDataElement() != dataElement || !elimEntryInfo.isIsVisible()) continue;
                this.setDCValue(dcRule, value, elimEntryInfo.getItem(), elimEntryInfo);
                isFind = true;
                break;
            }
            if (!isFind) {
                elimination.getEntries().add(this.getElimEntryInfo(ctx, item, dataElement, company, value, dcRule, summary));
            }
        }
    }

    private EliminationEntryInfo getElimEntryInfo(Context ctx, RPTItemInfo item, int dataElement, FullOrgUnitInfo company, BigDecimal bdValue, InvestItemDCRuleEnum dcRule, String summary) throws BOSException, EASBizException {
        EliminationEntryInfo elimEntryInfo = new EliminationEntryInfo();
        elimEntryInfo.setCompany(company);
        this.setDCValue(dcRule, bdValue, item, elimEntryInfo);
        elimEntryInfo.setItem(item);
        elimEntryInfo.setDataElement(dataElement);
        elimEntryInfo.setSummary(summary);
        elimEntryInfo.setIsVisible(true);
        return elimEntryInfo;
    }

    private void setDCValue(InvestItemDCRuleEnum dcRule, BigDecimal value, RPTItemInfo item, EliminationEntryInfo elimEntryInfo) {
        switch (dcRule.getValue()) {
            case 1: {
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 2: {
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 5: {
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 6: {
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 3: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
            case 4: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 7: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(ZERO) > 0) {
                        this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                        break;
                    }
                    value = value.negate();
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                break;
            }
            case 8: {
                if (item.getDc().equals((Object)DebitOrCreditEnum.CREDIT)) {
                    if (value.compareTo(ZERO) > 0) {
                        this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                        break;
                    }
                    value = value.negate();
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                if (value.compareTo(ZERO) > 0) {
                    this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.CREDIT);
                    break;
                }
                value = value.negate();
                this.addDCValue(elimEntryInfo, value, DebitOrCreditEnum.DEBIT);
                break;
            }
        }
    }

    private void addDCValue(EliminationEntryInfo elimEntryInfo, BigDecimal bdValue, DebitOrCreditEnum dc) {
        BigDecimal credit;
        BigDecimal debit = elimEntryInfo.getDebit() != null ? elimEntryInfo.getDebit() : ZERO;
        BigDecimal bigDecimal = credit = elimEntryInfo.getCredit() != null ? elimEntryInfo.getCredit() : ZERO;
        if (dc.equals((Object)DebitOrCreditEnum.DEBIT)) {
            debit = debit.add(bdValue);
        } else {
            credit = credit.add(bdValue);
        }
        BigDecimal diff = debit.subtract(credit);
        if (diff.compareTo(ZERO) > 0) {
            debit = diff;
            credit = null;
        } else {
            debit = null;
            credit = diff.negate();
        }
        elimEntryInfo.setDebit(debit);
        elimEntryInfo.setCredit(credit);
    }

    private List caclEntryDist(Map mapElimination, boolean isDebitToCredit) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        for (String currencyId : mapElimination.keySet()) {
            EliminationInfo elim = (EliminationInfo)mapElimination.get(currencyId);
            BigDecimal diff = ZERO;
            Iterator iterEntry = elim.getEntries().iterator();
            while (iterEntry.hasNext()) {
                EliminationEntryInfo entry = (EliminationEntryInfo)iterEntry.next();
                if (!entry.isIsVisible()) continue;
                if (entry.getDebit() != null) {
                    diff = diff.subtract(entry.getDebit());
                }
                if (entry.getCredit() == null) continue;
                diff = diff.add(entry.getCredit());
            }
            if (diff.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            if (isDebitToCredit) {
                data.put("Value", diff.negate());
            } else {
                data.put("Value", diff);
            }
            result.add(data);
        }
        return result;
    }

    private void createElimRecordForThisYearProfitDist(Context ctx, Map mapElimination, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = RPTDateUtil.getBeginOfYear(iYear + 1);
        String templetId = this.getTemplateIdByType(ctx, 10);
        String summary = InvestTempletEnum.HK_INVEST_THISYEAR_PROFITDIST.getAlias();
        Map mapAttachCompany = InvestDayUtil.getTwoTypeCompanyForInvest(ctx, orgTreeId, orgUnitId, 1, 3);
        if (mapAttachCompany == null || mapAttachCompany.size() <= 0) {
            return;
        }
        ArrayList lstProfitDist = new ArrayList();
        ArrayList profitDisForThePeriod = new ArrayList();
        ArrayList lstFewHolder = new ArrayList();
        ArrayList lstInvestProfit = new ArrayList();
        ArrayList invProfitForThePeriod = new ArrayList();
        Set set = mapAttachCompany.keySet();
        HashMap entries = new HashMap();
        for (String companyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(companyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                Map mapProfitDist = this.getProfitDistSum(ctx, targetCompanyId, beginOfYear, endOfYear);
                if (mapProfitDist.isEmpty()) continue;
                lstProfitDist.clear();
                profitDisForThePeriod.clear();
                lstFewHolder.clear();
                lstInvestProfit.clear();
                invProfitForThePeriod.clear();
                for (String currencyId : mapProfitDist.keySet()) {
                    BigDecimal bdValue = (BigDecimal)mapProfitDist.get(currencyId);
                    HashMap<String, Object> mapPt = new HashMap<String, Object>(4);
                    mapPt.put("KEY_CURRENCY_ID", currencyId);
                    mapPt.put("Value", bdValue);
                    lstProfitDist.add(mapPt);
                    BigDecimal[] bdValues = this.getProfitDistAndFewHolder(ctx, companyId, targetCompanyId, currencyId, beginOfYear, endOfYear);
                    if (bdValues[0].compareTo(ZERO) != 0) {
                        HashMap<String, Object> mapIp = new HashMap<String, Object>(4);
                        mapIp.put("KEY_CURRENCY_ID", currencyId);
                        mapIp.put("Value", bdValues[0]);
                        lstInvestProfit.add(mapIp);
                    }
                    if (bdValues[1].compareTo(ZERO) == 0) continue;
                    HashMap<String, Object> mapFh = new HashMap<String, Object>(4);
                    mapFh.put("KEY_CURRENCY_ID", currencyId);
                    mapFh.put("Value", bdValues[1]);
                    lstFewHolder.add(mapFh);
                }
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                this.mergeElimination(ctx, mapElimination, lstInvestProfit, companyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                this.mergeElimination(ctx, mapElimination, lstFewHolder, companyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                this.mergeElimination(ctx, mapElimination, lstProfitDist, companyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private BigDecimal[] getProfitDistAndFewHolder(Context ctx, String sourceCompanyId, String targetCompanyId, String currencyId, java.util.Date begin, java.util.Date end) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
        sql.append(" where FCompanyID = '");
        sql.append(targetCompanyId);
        sql.append("' and FDistDate >= ");
        sql.append(CslRptUtil.formatDateForSql(begin));
        sql.append(" and FDistDate <= ");
        sql.append(CslRptUtil.formatDateForSql(end));
        sql.append(" and FCurrencyID = '");
        sql.append(currencyId);
        sql.append("' order by FDistDate");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal[] result = new BigDecimal[]{ZERO, ZERO};
        try {
            while (rowSet.next()) {
                BigDecimal value = rowSet.getBigDecimal("FAmount");
                Date distDate = rowSet.getDate("FDistDate");
                BigDecimal rate = InvestDayUtil.getThisDaySumInvestRate(ctx, sourceCompanyId, targetCompanyId, currencyId, distDate);
                if (rate == null) continue;
                result[0] = result[0].add(value.multiply(rate));
                result[1] = result[1].add(value.multiply(ONE.subtract(rate)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private Map getProfitDistSum(Context ctx, String targetCompanyId, java.util.Date begin, java.util.Date end) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select FCurrencyID,sum(FAmount) as FValue");
        sql.append(" From T_CSL_ProfitDistributeList");
        sql.append(" where FCompanyID = '");
        sql.append(targetCompanyId);
        sql.append("' and FDistDate >= ");
        sql.append(CslRptUtil.formatDateForSql(begin));
        sql.append(" and FDistDate < ");
        sql.append(CslRptUtil.formatDateForSql(end));
        sql.append(" Group by FCurrencyID");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<Object, BigDecimal> mapResult = new HashMap<Object, BigDecimal>();
        try {
            while (rowSet.next()) {
                BigDecimal value = rowSet.getBigDecimal("FValue");
                if (value.compareTo(ZERO) == 0) continue;
                mapResult.put(rowSet.getObject("FCurrencyID"), value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return mapResult;
    }

    private void createElimRecordForInvestDayInvest(Context ctx, Map mapElimination, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = RPTDateUtil.getBeginOfYear(iYear + 1);
        Map mapAttachCompany = InvestDayUtil.getTwoTypeCompanyForInvest(ctx, orgTreeId, orgUnitId, 1, 4);
        String templetId = this.getTemplateIdByType(ctx, 20);
        String summary = InvestTempletEnum.HK_INVEST_ELIM_INVESTDAY.getAlias();
        Set set = mapAttachCompany.keySet();
        HashMap entries = new HashMap();
        for (String sourceCompanyId : set) {
            List lstTargetCompanyID = (List)mapAttachCompany.get(sourceCompanyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                List investDayValues = this.getThisYearFewHolderInterest(ctx, sourceCompanyId, targetCompanyId, mapParams);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                investDayValues = InvestDayUtil.getThisYearHonorSum(ctx, sourceCompanyId, targetCompanyId, iYear, true);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                investDayValues = InvestDayUtil.getThisYearSumInvestAmount(ctx, sourceCompanyId, targetCompanyId, iYear, true);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                investDayValues = this.getFewHolderProfit(ctx, sourceCompanyId, targetCompanyId, mapParams);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 6, entries);
                investDayValues = this.getProfitDist(ctx, sourceCompanyId, targetCompanyId, beginOfYear, endOfYear);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
                investDayValues = this.caclEntryDist(mapElimination, true);
                this.mergeElimination(ctx, mapElimination, investDayValues, sourceCompanyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private List getThisYearFewHolderInterest(Context ctx, String sourceCompanyId, String targetCompanyId, Map mapParams) throws BOSException, EASBizException {
        int iYear = (Integer)mapParams.get("Year");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.OWNER_EQUITY_SUM, mapParams).getNumber();
        java.util.Date endOfLastYear = RPTDateUtil.getEndOfYear(iYear);
        int[] arrPeriodType = RPTDateUtil.getPeriod(endOfLastYear, RptPeriodTypeEnum.getEnum((int)iPeriodType));
        int sourceType = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select FUnitId, FStockControlCompanyID from T_ORG_OUPartUnionGroup");
        sql.append(" where FUnitId in (");
        sql.append("select a.FUnitId from t_org_structure a join t_org_structure b");
        sql.append(" on a.FId = b.FParentId");
        sql.append(" where b.FTreeId = ? and b.FUnitId = ?)");
        sql.append(" and FStockControlCompanyID is not null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, targetCompanyId});
        try {
            String controlCompanyId;
            if (rowSet.next() && (controlCompanyId = rowSet.getString("FStockControlCompanyID")).equals(targetCompanyId)) {
                targetCompanyId = rowSet.getString("FUnitId");
                sourceType = 3;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        List sumInvestRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, sourceCompanyId, targetCompanyId, iYear);
        ArrayList result = new ArrayList();
        for (Map mapSumInvestRate : sumInvestRate) {
            String currencyId = (String)mapSumInvestRate.get("KEY_CURRENCY_ID");
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            BigDecimal dbValue = this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeId, arrPeriodType[0], arrPeriodType[1], sourceType, 4);
            if (dbValue == null) continue;
            BigDecimal dbRate = (BigDecimal)mapSumInvestRate.get("Value");
            dbValue = dbValue.multiply(dbRate);
            data.put("Value", dbValue);
            result.add(data);
        }
        return result;
    }

    private List getFewHolderProfit(Context ctx, String sourceCompanyId, String targetCompanyId, Map mapParams) throws EASBizException, BOSException {
        ArrayList result;
        block11: {
            int iYear;
            block10: {
                result = new ArrayList();
                iYear = (Integer)mapParams.get("Year");
                java.util.Date rptDate = (java.util.Date)mapParams.get("Day");
                if (InvestDayUtil.existsInvest(ctx, sourceCompanyId, targetCompanyId, iYear)) break block10;
                List lstRate = InvestDayUtil.getThisDaySumInvestRate(ctx, sourceCompanyId, targetCompanyId, rptDate);
                if (lstRate == null || lstRate.size() <= 0) break block11;
                int n = lstRate.size();
                for (int j = 0; j < n; ++j) {
                    Map mapRate = (Map)lstRate.get(j);
                    String currencyID = (String)mapRate.get("KEY_CURRENCY_ID");
                    BigDecimal bdRateValue = (BigDecimal)mapRate.get("Value");
                    BigDecimal bdProfitValue = this.getPeriodEndNetProfit(ctx, targetCompanyId, currencyID, 1, mapParams);
                    if (bdProfitValue == null) continue;
                    BigDecimal bdResultValue = bdProfitValue.multiply(bdRateValue);
                    HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                    mapTemp.put("KEY_CURRENCY_ID", currencyID);
                    mapTemp.put("Value", bdResultValue);
                    result.add(mapTemp);
                }
                break block11;
            }
            Map mapProfit = InvestDayUtil.getThisYearAllProfit(ctx, sourceCompanyId, targetCompanyId, iYear);
            for (String currencyId : mapProfit.keySet()) {
                BigDecimal resultValue;
                List allProfits = (List)mapProfit.get(currencyId);
                int size = allProfits.size();
                if (size == 0) continue;
                BigDecimal beginOfYearSumInvestRate = InvestDayUtil.getBeginOfThisYearSumInvestRate(ctx, sourceCompanyId, targetCompanyId, currencyId, iYear);
                if (beginOfYearSumInvestRate != null && beginOfYearSumInvestRate.compareTo(ZERO) != 0) {
                    resultValue = ZERO;
                    BigDecimal bdPrevProfit = ZERO;
                    BigDecimal bdPrevSumInvestRate = ZERO;
                    for (int iRow = 0; iRow < size; ++iRow) {
                        Map mapProfitDetail = (Map)allProfits.get(iRow);
                        BigDecimal bdCurProfit = (BigDecimal)mapProfitDetail.get("Value");
                        BigDecimal bdCurSumInvestRate = (BigDecimal)mapProfitDetail.get("SumInvestRate");
                        resultValue = iRow == 0 ? bdCurProfit.multiply(beginOfYearSumInvestRate) : resultValue.add(bdCurProfit.subtract(bdPrevProfit).multiply(bdPrevSumInvestRate));
                        if (iRow == size - 1) {
                            BigDecimal bdEndProfit = this.getPeriodEndNetProfit(ctx, targetCompanyId, currencyId, 1, mapParams);
                            if (bdEndProfit == null) {
                                bdEndProfit = ZERO;
                            }
                            resultValue = resultValue.add(bdEndProfit.subtract(bdCurProfit).multiply(bdCurSumInvestRate));
                            continue;
                        }
                        bdPrevProfit = bdCurProfit;
                        bdPrevSumInvestRate = bdCurSumInvestRate;
                    }
                    HashMap<String, Object> mapTemp = new HashMap<String, Object>(4);
                    mapTemp.put("KEY_CURRENCY_ID", currencyId);
                    mapTemp.put("Value", resultValue);
                    result.add(mapTemp);
                    continue;
                }
                resultValue = ZERO;
                BigDecimal lastProfit = ZERO;
                for (int iRow = size - 1; iRow >= 0; --iRow) {
                    Map mapProfitDetail = (Map)allProfits.get(iRow);
                    BigDecimal curProfit = (BigDecimal)mapProfitDetail.get("Value");
                    BigDecimal curSumInvestRate = (BigDecimal)mapProfitDetail.get("SumInvestRate");
                    if (iRow == size - 1) {
                        BigDecimal endProfit = this.getPeriodEndNetProfit(ctx, targetCompanyId, currencyId, 1, mapParams);
                        if (endProfit == null) {
                            endProfit = ZERO;
                        }
                        BigDecimal endSumInvestRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, sourceCompanyId, targetCompanyId, iYear, currencyId);
                        resultValue = endProfit.subtract(curProfit).multiply(endSumInvestRate);
                    } else {
                        resultValue = resultValue.add(lastProfit.subtract(curProfit).multiply(curSumInvestRate));
                    }
                    lastProfit = curProfit;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", resultValue);
                result.add(data);
            }
        }
        return result;
    }

    private List getTotalOtherOnwerSum(List investDayCl) {
        BigDecimal value;
        String currencyId;
        ArrayList result = new ArrayList();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (HashMap<String, Object> data : investDayCl) {
            currencyId = (String)data.get("KEY_CURRENCY_ID");
            value = (BigDecimal)data.get("Value");
            if (map.containsKey(currencyId)) {
                BigDecimal tmpValue = (BigDecimal)map.get(currencyId);
                value = value.add(tmpValue);
            }
            map.put(currencyId, value);
        }
        Iterator<Object> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            HashMap<String, Object> data;
            data = new HashMap<String, Object>(4);
            currencyId = (String)iter.next();
            value = (BigDecimal)map.get(currencyId);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", value);
            result.add(data);
        }
        return result;
    }

    private void createElimRecordForOtherOwnerSum(Context ctx, Map mapElimination, Map mapParams) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = RPTDateUtil.getBeginOfYear(iYear + 1);
        String templetId = this.getTemplateIdByType(ctx, 11);
        String summary = InvestTempletEnum.HK_INVEST_ELIMOTHERASSET.getAlias();
        Map unionCompany = InvestDayUtil.getTwoTypeCompanyForInvest(ctx, orgTreeId, orgUnitId, 1, 3);
        if (unionCompany == null || unionCompany.size() <= 0) {
            return;
        }
        Set set = unionCompany.keySet();
        HashMap entries = new HashMap();
        for (String companyId : set) {
            List lstTargetCompanyID = (List)unionCompany.get(companyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                List investDayCl = this.getOtherOwnerSum(ctx, companyId, targetCompanyId, beginOfYear, endOfYear, false);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.getTotalOtherOnwerSum(investDayCl);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private void createElimRecordForPool(Context ctx, Map mapElimination, Map mapParams) throws EASBizException, BOSException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String orgUnitId = (String)mapParams.get("OrgUnitID");
        int iYear = (Integer)mapParams.get("Year");
        int iPeriod = (Integer)mapParams.get("Period");
        java.util.Date beginOfYear = RPTDateUtil.getBeginOfYear(iYear);
        java.util.Date endOfYear = RPTDateUtil.getBeginOfYear(iYear + 1);
        String templetId = this.getTemplateIdByType(ctx, 12);
        String summary = InvestTempletEnum.HK_INVEST_POOL.getAlias();
        Map unionCompany = InvestDayUtil.getTwoTypeCompanyForInvest(ctx, orgTreeId, orgUnitId, 2, -1);
        if (unionCompany == null || unionCompany.size() <= 0) {
            return;
        }
        Set set = unionCompany.keySet();
        HashMap entries = new HashMap();
        for (String companyId : set) {
            List lstTargetCompanyID = (List)unionCompany.get(companyId);
            for (int i = 0; i < lstTargetCompanyID.size(); ++i) {
                String targetCompanyId = (String)lstTargetCompanyID.get(i);
                List investDayCl = InvestDayUtil.getEndOfThisYearHonorSum(ctx, companyId, targetCompanyId, iYear);
                InvestTempletEntryInfo templetEntry = this.getTempletEntryBySeq(ctx, templetId, 1, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.getPoolInvest(ctx, companyId, targetCompanyId, iYear, iPeriod, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 2, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.getProfitDist(ctx, companyId, targetCompanyId, beginOfYear, endOfYear);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 3, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.getThisYearPool(ctx, companyId, targetCompanyId, iYear, iPeriod, mapParams);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 5, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.getOtherOwnerSum(ctx, companyId, targetCompanyId, null, null, true);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 6, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
                investDayCl = this.caclEntryDist(mapElimination, true);
                templetEntry = this.getTempletEntryBySeq(ctx, templetId, 4, entries);
                this.mergeElimination(ctx, mapElimination, investDayCl, companyId, targetCompanyId, templetEntry, summary, mapParams);
            }
        }
    }

    private List getPoolInvest(Context ctx, String companyId, String targetCompanyId, int year, int period, Map mapParams) throws BOSException, EASBizException {
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        String itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.OWNER_EQUITY_SUM, mapParams).getNumber();
        ArrayList result = new ArrayList();
        List rates = InvestDayUtil.getEndOfThisYearSumInvestRateAndAmount(ctx, companyId, targetCompanyId, year);
        int size = rates.size();
        for (int i = 0; i < size; ++i) {
            Map tmpMap = (Map)rates.get(i);
            String currencyId = (String)tmpMap.get("KEY_CURRENCY_ID");
            BigDecimal dbValue = this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber, orgTreeId, year, period, 1, 4);
            if (dbValue == null) {
                dbValue = ZERO;
            }
            BigDecimal rate = (BigDecimal)tmpMap.get("SumInvestRate");
            dbValue = dbValue.multiply(rate);
            BigDecimal amount = (BigDecimal)tmpMap.get("SumInvestAmount");
            if ((dbValue = dbValue.subtract(amount)).compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", dbValue);
            result.add(data);
        }
        return result;
    }

    private List getThisYearPool(Context ctx, String companyId, String targetCompanyId, int year, int period, Map mapParams) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = this.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            BigDecimal pool = this.getCurYearSumPool(ctx, companyId, targetCompanyId, currencyId, year, period, mapParams);
            if (pool.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", pool);
            result.add(data);
        }
        return result;
    }

    private List getProfitDist(Context ctx, String companyId, String targetCompanyId, java.util.Date begin, java.util.Date end) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        CurrencyCollection currencies = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
        for (CurrencyInfo currency : currencies) {
            String currencyId = currency.getId().toString();
            StringBuffer oql = new StringBuffer();
            oql.append("Select FAmount, FDistDate From T_CSL_ProfitDistributeList");
            oql.append(" where fcurrencyid = '");
            oql.append(currencyId);
            oql.append("' and fcompanyid = '");
            oql.append(targetCompanyId);
            oql.append("'");
            if (begin != null) {
                oql.append(" and fdistDate >= ");
                oql.append(CslRptUtil.formatDateForSql(begin));
            }
            if (end != null) {
                oql.append(" and fdistDate < ");
                oql.append(CslRptUtil.formatDateForSql(end));
            }
            oql.append(" order by fdistDate");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            BigDecimal total = ZERO;
            try {
                while (rowSet.next()) {
                    BigDecimal amount = rowSet.getBigDecimal("FAmount");
                    Date distDate = rowSet.getDate("FDistDate");
                    BigDecimal sumInvestRate = InvestDayUtil.getThisDaySumInvestRate(ctx, companyId, targetCompanyId, currencyId, distDate);
                    if (sumInvestRate == null || amount == null) continue;
                    total = total.add(amount.multiply(sumInvestRate));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (total.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", total);
            result.add(data);
        }
        return result;
    }

    private List getOtherOwnerSum(Context ctx, String companyId, String targetCompanyId, java.util.Date begin, java.util.Date end, boolean isForFewHolder) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        StringBuffer oql = new StringBuffer();
        oql.append("Select o.FCurrencyID, o.FChangeDate, e.FChangeMoney, e.FItemID ");
        oql.append(" From T_CSL_OtherOwnerRight o join T_CSL_OtherOwnerRightEntry e");
        oql.append(" on o.FId = e.FHeadID");
        oql.append(" where o.fcompanyid = '");
        oql.append(targetCompanyId);
        oql.append("'");
        if (begin != null) {
            oql.append(" and o.FChangeDate >= ");
            oql.append(CslRptUtil.formatDateForSql(begin));
        }
        if (end != null) {
            oql.append(" and o.FChangeDate < ");
            oql.append(CslRptUtil.formatDateForSql(end));
        }
        oql.append(" order by o.FCurrencyID, o.FChangeDate");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        HashMap<String, Map<String, BigDecimal>> tmpResult = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<Date, BigDecimal> rateByDate = new HashMap<Date, BigDecimal>();
        try {
            while (rowSet.next()) {
                Map<String, BigDecimal> tmpItem;
                BigDecimal changeMoney;
                Date date = rowSet.getDate("FChangeDate");
                BigDecimal rate = null;
                String currencyId = rowSet.getString("FCurrencyId");
                if (rateByDate.containsKey(date)) {
                    rate = (BigDecimal)rateByDate.get(date);
                } else {
                    rate = InvestDayUtil.getThisDaySumInvestRate(ctx, companyId, targetCompanyId, currencyId, date);
                    if (rate == null) {
                        rate = ZERO;
                    }
                    rateByDate.put(date, rate);
                }
                if (!isForFewHolder) {
                    rate = ONE.subtract(rate);
                }
                if ((changeMoney = rowSet.getBigDecimal("FChangeMoney")) == null) {
                    changeMoney = ZERO;
                }
                String itemid = rowSet.getString("FItemId");
                BigDecimal total = ZERO;
                if (tmpResult.containsKey(currencyId)) {
                    tmpItem = (Map)tmpResult.get(currencyId);
                    if (tmpItem.containsKey(itemid)) {
                        total = (BigDecimal)tmpItem.get(itemid);
                    }
                    total = total.add(changeMoney.multiply(rate));
                    tmpItem.put(itemid, total);
                    continue;
                }
                tmpItem = new HashMap();
                tmpItem.put(itemid, changeMoney.multiply(rate));
                tmpResult.put(currencyId, tmpItem);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (String currencyId : tmpResult.keySet()) {
            Map tmpItem = (Map)tmpResult.get(currencyId);
            for (String itemid : tmpItem.keySet()) {
                BigDecimal value = (BigDecimal)tmpItem.get(itemid);
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("RPTITEM_ID", itemid);
                data.put("Value", value);
                result.add(data);
            }
        }
        return result;
    }

    private BigDecimal getCurYearSumPool(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, int period, Map mapParams) throws EASBizException, BOSException {
        String itemNumber;
        BigDecimal profit;
        String orgTreeId = (String)mapParams.get("OrgTreeID");
        int iPeriodType = (Integer)mapParams.get("PeriodType");
        List curYearAllRate = InvestDayUtil.getThisYearAllSumInvestRate(ctx, companyId, targetCompanyId, currencyId, year);
        BigDecimal beginRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, year - 1, currencyId);
        if (beginRate == null) {
            beginRate = ZERO;
        }
        BigDecimal endRate = ZERO;
        if (curYearAllRate.isEmpty()) {
            endRate = InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, year, currencyId);
        }
        BigDecimal sum = ZERO;
        for (int i = 0; i < curYearAllRate.size(); ++i) {
            Map data = (Map)curYearAllRate.get(i);
            BigDecimal profit2 = (BigDecimal)data.get("Profit");
            endRate = (BigDecimal)data.get("SumInvestRate");
            if (profit2 == null || endRate == null) continue;
            sum = sum.add(profit2.multiply(beginRate.subtract(endRate)));
            beginRate = endRate;
        }
        if (period < 0) {
            int[] arrPeriodType = RPTDateUtil.getPeriod(RPTDateUtil.getEndOfYear(year), RptPeriodTypeEnum.getEnum((int)iPeriodType));
            year = arrPeriodType[0];
            period = arrPeriodType[1];
        }
        if ((profit = this.getAcctItem(ctx, targetCompanyId, currencyId, itemNumber = this.getRptItemByCtrlAttr(ctx, RPTItemControlEnum.NET_PROFIT, mapParams).getNumber(), orgTreeId, year, period, 1, 3)) != null) {
            sum = sum.add(profit.multiply(endRate));
        }
        return sum;
    }

    private RPTItemInfo getRptItemByCtrlAttr(Context ctx, RPTItemControlEnum ctrlAttr, Map mapParams) throws BOSException, EASBizException {
        RPTItemInfo item;
        HashMap items = (HashMap)mapParams.get(KEY_ITEM);
        if (items == null) {
            items = new HashMap(16);
            mapParams.put(KEY_ITEM, items);
        }
        if ((item = (RPTItemInfo)items.get((Object)ctrlAttr)) == null) {
            String strOql;
            IRPTItem iitem = RPTItemFactory.getLocalInstance(ctx);
            if (iitem.exists(strOql = "select *, sumItems.number where control = " + ctrlAttr.getValue())) {
                try {
                    item = iitem.getRPTItemInfo(strOql);
                }
                catch (BOSException e) {
                    throw new ServerException(ServerException.MANY_RECORD_RPTITEM, new Object[]{ctrlAttr.getAlias()});
                }
            } else {
                throw new ServerException(ServerException.NOT_FOUND_RPTITEM, new Object[]{ctrlAttr.getAlias()});
            }
        }
        return item;
    }

    private RPTItemInfo getItemByID(Context ctx, String itemId, Map mapParams) throws BOSException, EASBizException {
        RPTItemInfo item;
        HashMap<String, RPTItemInfo> items = (HashMap<String, RPTItemInfo>)mapParams.get(KEY_ITEM);
        if (items == null) {
            items = new HashMap<String, RPTItemInfo>(16);
            mapParams.put(KEY_ITEM, items);
        }
        if ((item = (RPTItemInfo)items.get(itemId)) == null) {
            IRPTItem iitem = RPTItemFactory.getLocalInstance(ctx);
            item = iitem.getRPTItemInfo(" where id = '" + itemId + "'");
            items.put(itemId, item);
        }
        return item;
    }

    private FullOrgUnitInfo getCompanyByID(Context ctx, String companyId, Map mapParams) throws BOSException, EASBizException {
        FullOrgUnitInfo company;
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        HashMap<String, FullOrgUnitInfo> companys = (HashMap<String, FullOrgUnitInfo>)mapParams.get(KEY_COMPANY);
        if (companys == null) {
            companys = new HashMap<String, FullOrgUnitInfo>(16);
            mapParams.put(KEY_COMPANY, companys);
        }
        if ((company = (FullOrgUnitInfo)companys.get(companyId)) == null) {
            IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            company = fullOrgUnit.getFullOrgUnitInfo("select id where id = '" + companyId + "'");
            companys.put(companyId, company);
        }
        return company;
    }

    private CurrencyInfo getCurrencyByID(Context ctx, String currencyId, Map mapParams) throws BOSException, EASBizException {
        CurrencyInfo currency;
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        HashMap<String, CurrencyInfo> currencies = (HashMap<String, CurrencyInfo>)mapParams.get(KEY_CURRENCY);
        if (currencies == null) {
            currencies = new HashMap<String, CurrencyInfo>(16);
            mapParams.put(KEY_CURRENCY, currencies);
        }
        if ((currency = (CurrencyInfo)currencies.get(currencyId)) == null) {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            currency = (CurrencyInfo)icurrency.getValue("select id where id = '" + currencyId + "'");
            currencies.put(currencyId, currency);
        }
        return currency;
    }

    private BigDecimal getAcctItem(Context ctx, String targetCompanyId, String currencyId, String itemNumber, String orgTreeId, int year, int period, int dataSource, int dataElement) throws BOSException, EASBizException {
        ItemDataCondition condition = new ItemDataCondition();
        ArrayList<String> lstOrgUnit = new ArrayList<String>();
        lstOrgUnit.add(targetCompanyId);
        condition.setOrgUnit(lstOrgUnit);
        condition.setOrgTreeId(orgTreeId);
        condition.setCurrency(currencyId);
        condition.setTargetCurrency(currencyId);
        condition.setRptYearStart(year);
        condition.setRptYearEnd(year);
        condition.setRptPeriodStart(period);
        condition.setRptPeriodEnd(period);
        condition.setDataSource(dataSource);
        condition.setDataElement(dataElement);
        condition.setCommitStatus(3);
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        ArrayList<String> lstItem = new ArrayList<String>();
        lstItem.add(itemNumber);
        condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
        Map mapValue = ItemDataProviderFactory.getLocalInstance(ctx).getAcctItems(condition);
        if (mapValue != null && mapValue.containsKey(itemNumber)) {
            return (BigDecimal)mapValue.get(itemNumber);
        }
        return null;
    }

    private String getMaxNumber(Context ctx, Map mapParams, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Round(Max(to_int(Replace(fnumber,'AUTO_',''))),0) As Fmaxnumber From ");
        sql.append(tableName).append(" a  \r\n");
        sql.append("  WHERE a.fOrgBoundId = ? \r\n");
        sql.append("  and a.fyear = ? \r\n");
        sql.append("  and a.fperiod = ? \r\n");
        sql.append("  and a.fperiodType = ? \r\n");
        sql.append("  and a.fNumber like N'AUTO\\_%' escape '\\' \r\n");
        Object[] param = new Object[]{mapParams.get("OrgTreeID"), mapParams.get("Year"), mapParams.get("Period"), mapParams.get("PeriodType")};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer result = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            result.append("0");
        }
        result.append(number);
        return result.toString();
    }

    private List getCurrencyIds(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select distinct fcurrencyId from t_csl_investDay";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("fcurrencyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }
}

