/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckCondition;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckException;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInvestCheckControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class InvestCheckControllerBean
extends AbstractInvestCheckControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.InvestCheckControllerBean");
    private static final int RATE_NULL = 0;
    private static final int RATE_MINUSPLUS = 2;
    private static final String FORMULA_KEY = "FORMULA_";
    private static final String ITEMS_KEY = "ITEMS_";
    private static final int ONE_ONE = 1;
    private static final int ONE_SUM = 3;
    private static final String IIASSISTANT_BOSTYPE = "FCB7329A";
    private static final String IIASSISTANTITEMDATA_BOSTYPE = "2E927A17";

    @Override
    protected void _buildCheckage(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        this.initCheckParam(ctx, param);
        ItemControlHelper ic = new ItemControlHelper(new ControlAttrHelper(ctx, 0, param.getMergeMode()), false);
        this.checkBusinessRule(ctx, param);
        this.clearOldData(ctx, param);
        this.insertCompanyAndRate(ctx, param, ic);
        IRowSet rs = this.GetIIAssistantDataCompany(ctx, param);
        Map group = this.getIIAssistantRateInGroup(ctx, param, false);
        Map unit = this.getIIAssistantRateInUnit(ctx, param, false);
        this.updateOwnerRightAssistant(ctx, param, ic, rs);
        this.updateProfitAssistant(ctx, param, ic, rs);
        this.updateShareHolderIsChecked(ctx, param);
        this.updateInvestIIAssistant(ctx, param, ic, param.getMergeMode() ? unit : group);
        this.updateInterestIIAssistant(ctx, param, ic, param.getMergeMode() ? unit : group);
        this.updateMoreInvestIIAssistant(ctx, param, ic);
        this.updateInvestMergeDiff(ctx, param, ic);
        this.insertInvestCheckage(ctx, param);
        this.insertInterestCheckage(ctx, param);
    }

    private boolean isExistsItemData(Context ctx, InvestCheckCondition param, int elimType) throws BOSException {
        StringBuffer sbSQL = new StringBuffer(" Select Top 1 FId From t_csl_IIAssistantItemData \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        sbSQL.append(" And FControlAttr = ");
        switch (elimType) {
            case 1: {
                sbSQL.append(1);
                break;
            }
            case 2: {
                sbSQL.append(9);
                break;
            }
            case 5: {
                sbSQL.append(29);
            }
        }
        boolean isExists = false;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                isExists = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isExists;
    }

    private void initStockControlCompany(Context ctx, InvestCheckCondition param) throws BOSException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer("Select fStockControlCompanyId ");
        sbSQL.append(" from t_org_OUPartUnionGroup ");
        sbSQL.append(" Where FUnitId = '").append(param.getOrgBoundId()).append("'");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                param.setStockControlCompanyId(rs.getString("fStockControlCompanyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void fillMoreItemData(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)this.getClearDataSQL(4, param));
    }

    private void fillInterestItemData(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException, EASBizException {
        AssInsert[] asses1;
        int i;
        if (this.isExistsItemData(ctx, param, 2)) {
            return;
        }
        this.initCheckParam(ctx, param);
        Map group = this.getIIAssistantRateInGroup(ctx, param, true);
        int templetType = param.getMergeMode() ? 3 : 5;
        String tempTableName = this.createCalculateRateTempTable(ctx);
        AssInsert ass = ic.getHelper().getControlTempletInfo(templetType, 13, 2, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 13, 3, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 9, 2, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 9, 3, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 8, 2, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 8, 3, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        AssInsert[] asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(templetType, 10, 2, true)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, false, tempTableName);
        asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(templetType, 10, 3, true)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, false, tempTableName);
        asses = ic.getHelper().getControlTempletInfos(templetType, 4, 2, true, param.getMergeMode() ? 3 : 5);
        int n = asses.length;
        for (i = 0; i < n; ++i) {
            asses1 = new AssInsert[]{asses[i]};
            this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses1, false, tempTableName);
        }
        asses = ic.getHelper().getControlTempletInfos(templetType, 4, 3, true, param.getMergeMode() ? 3 : 5);
        n = asses.length;
        for (i = 0; i < n; ++i) {
            asses1 = new AssInsert[]{asses[i]};
            this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses1, false, tempTableName);
        }
        asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(templetType, 27, 4, true)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, false, tempTableName);
        if (!param.getMergeMode()) {
            return;
        }
        ass = ic.getHelper().getControlTempletInfo(4, 13, 2, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(4, 13, 3, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(4, 9, 2, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(4, 9, 3, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        this.dropTempTable(ctx, tempTableName);
    }

    private void fillInvestItemData(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException, EASBizException {
        if (this.isExistsItemData(ctx, param, 1)) {
            return;
        }
        this.initCheckParam(ctx, param);
        this.initStockControlCompany(ctx, param);
        Map group = this.getIIAssistantRateInGroup(ctx, param, true);
        int templetType = param.getMergeMode() ? 1 : 5;
        String tempTableName = this.createCalculateRateTempTable(ctx);
        this.clearAssistantItemData(ctx, param);
        AssInsert[] asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(31, 29, 2, true, 31), ic.getHelper().getControlTempletInfo(31, 30, 2, true, 31), ic.getHelper().getControlTempletInfo(31, 31, 2, true, 31)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, true, tempTableName);
        asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(31, 29, 3, true, 31), ic.getHelper().getControlTempletInfo(31, 30, 3, true, 31), ic.getHelper().getControlTempletInfo(31, 31, 3, true, 31)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, true, tempTableName);
        asses = new AssInsert[]{ic.getHelper().getControlTempletInfo(templetType, 20, 4, true)};
        this.insertControlItemIntoIIAssistantItemData(ctx, param, ic, group, asses, false, tempTableName);
        AssInsert ass = ic.getHelper().getControlTempletInfo(templetType, 3, 4, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 1, 4, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 2, 4, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(templetType, 7, 4, true);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        if (!param.getMergeMode()) {
            return;
        }
        ass = ic.getHelper().getControlTempletInfo(2, 3, 4, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(2, 1, 4, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        ass = ic.getHelper().getControlTempletInfo(2, 2, 4, false);
        this.insertAssistantIntoAssistantItemData(ctx, param, ic, ass);
        this.dropTempTable(ctx, tempTableName);
    }

    private void insertInvestCheckage(Context ctx, InvestCheckCondition param) throws BOSException {
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" insert into t_csl_investCheckage(FID,FOrgBoundId,FOrgUnitID,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FInvestLong,FInvestDiff,FNetAsset,FCsDiff,FMinorityRight,FCheckerId,FCheckDate, \r\n");
        sbSQL.append(" FDataElement,FMergeMode,FCreatorId,FCreateTime) \r\n");
        sbSQL.append(" select newBosId('").append(IIASSISTANT_BOSTYPE).append("') AS FID,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FInvestLong,FInvestDiff,FNetAsset,FInvestMergeDiff As FCsDiff,FInvestMinorityRight as FMinorityRight, \r\n");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCheckId, \r\n");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCheckDate, \r\n");
        sbSQL.append(4).append(" As FDataElement, \r\n");
        sbSQL.append(param.getMergeMode() ? 1 : 0).append(" As FMergeMode,");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCreatorId,");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId='").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType=").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        }
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void insertInterestCheckage(Context ctx, InvestCheckCondition param) throws BOSException {
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" insert into t_csl_interestCheckage(FID,FOrgBoundId,FOrgUnitID,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FYieldDirect,FNetProfit,FMinorityRight,FCheckerId,FCheckDate, \r\n");
        sbSQL.append(" FDataElement,FMergeMode,FCreatorId,FCreateTime) \r\n");
        sbSQL.append(" select newbosId('").append(IIASSISTANT_BOSTYPE).append("') as FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FInterest,FNetProfit,FInterestMinorityRight, \r\n");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCheckId, \r\n");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCheckDate, \r\n");
        sbSQL.append(2).append(" As FDataElement, \r\n");
        sbSQL.append(param.getMergeMode() ? 1 : 0).append(" As FMergeMode,");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCreatorId,");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId='").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType=").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        }
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        d = new Date();
        time = new Timestamp(d.getTime());
        sbSQL = new StringBuffer();
        sbSQL.append(" insert into t_csl_interestCheckage(FID,FOrgBoundId,FOrgUnitID,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FYieldDirect,FNetProfit,FMinorityRight,FCheckerId,FCheckDate, \r\n");
        sbSQL.append(" FDataElement,FMergeMode,FCreatorId,FCreateTime) \r\n");
        sbSQL.append(" select newbosId('").append(IIASSISTANT_BOSTYPE).append("') as FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay,FRate,FInterestYear,FNetProfitYear,FInterestMinorityRightYear, \r\n");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCheckId, \r\n");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCheckDate, \r\n");
        sbSQL.append(3).append(" As FDataElement, \r\n");
        sbSQL.append(param.getMergeMode() ? 1 : 0).append(" As FMergeMode,");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCreatorId,");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId='").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType=").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        }
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void updateShareHolderIsChecked(Context ctx, InvestCheckCondition param) throws BOSException {
        if (param.getMergeMode()) {
            StringBuffer sbSQL = null;
            sbSQL = new StringBuffer();
            sbSQL.append(" Update t_csl_IIAssistant \r\n");
            sbSQL.append(" Set FIsChecked = 1 \r\n");
            sbSQL.append(" Where FTargetCompanyId in \r\n");
            sbSQL.append(" (Select distinct FTargetCompanyId   \r\n");
            sbSQL.append(" From t_csl_IIAssistant t1 \r\n");
            sbSQL.append(" join t_org_structure t2 on t1.Forgboundid=t2.ftreeid and t1.forgunitid=t2.funitid \r\n ");
            sbSQL.append(" Where t1.FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
            sbSQL.append(" And t1.FOrgUnitId<>'").append(param.getOrgBoundId()).append("' \r\n");
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And t1.FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            sbSQL.append(" And t1.FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
            sbSQL.append(" And t1.FYear = ").append(param.getYear()).append(" \r\n");
            sbSQL.append(" And t1.FPeriod = ").append(param.getPeriod()).append(" \r\n");
            sbSQL.append(" ANd t2.FTreeId = '").append(param.getOrgTreeId()).append("' \r\n");
            sbSQL.append(" And t2.FLongNumber like '").append(param.getLongNumber()).append("%') \r\n");
            sbSQL.append(" And FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
            sbSQL.append(" And FOrgUnitId='").append(param.getOrgBoundId()).append("' \r\n");
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
            sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
            sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        }
    }

    private void updateInvestMergeDiff(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException {
        StringBuffer sbSQL = null;
        ArrayList<Object> arr = new ArrayList<Object>();
        sbSQL = new StringBuffer();
        sbSQL.append(" Update t_csl_IIAssistant \r\n");
        sbSQL.append(" Set FInvestMergeDiff = TO_DECIMAL((FInvestLong - FInvestDiff - TO_DECIMAL(FNetAsset*FRate/100, 21, 6)), 21, 6) \r\n");
        sbSQL.append(" Where FOrgBoundId = ? \r\n");
        arr.add(param.getOrgTreeId());
        sbSQL.append(" And FOrgUnitId = ? \r\n");
        arr.add(param.getOrgBoundId());
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = ? \r\n");
            arr.add(param.getCurrencyId());
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = ? \r\n");
            arr.add(param.getCompanyId());
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = ? \r\n");
            arr.add(param.getTargetCompanyId());
        }
        sbSQL.append(" And FPeriodType = ? \r\n");
        arr.add(new Integer(param.getPeriodType()));
        sbSQL.append(" And FYear = ? \r\n");
        arr.add(new Integer(param.getYear()));
        sbSQL.append(" And FPeriod = ? \r\n");
        arr.add(new Integer(param.getPeriod()));
        sbSQL.append(" And FIsChecked = 0 ");
        sbSQL.append(" And FNetAsset >= 0 ");
        sbSQL.append(" And FInvestMergeDiff = 0 ");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString(), (Object[])arr.toArray());
    }

    private void updateInvestIIAssistant(Context ctx, InvestCheckCondition param, ItemControlHelper ic, Map group) throws BOSException {
        StringBuffer sbSQL = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" Update t_csl_IIAssistant \r\n");
        sbSQL.append(" Set FInvestMergeDiff = FInvestDiff \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        sbSQL.append(" And FIsChecked = 0 ");
        sbSQL.append(" And FNetAsset >= 0 ");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        if (group == null) {
            return;
        }
        Connection conn = null;
        Statement st = null;
        IRowSet rsCheck = null;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            Set s = group.keySet();
            for (String companyId : s) {
                if (group.get(companyId) == null) continue;
                BigDecimal rate = (BigDecimal)group.get(companyId);
                sbSQL = new StringBuffer();
                sbSQL.append(" select FIsChecked from t_csl_IIAssistant \r\n");
                sbSQL.append(" where forgboundid = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" and forgunitid = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" and ftargetcompanyid = '").append(companyId).append("'");
                rsCheck = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                if (!rsCheck.next()) continue;
                sbSQL = new StringBuffer();
                sbSQL.append(" Update t_csl_IIAssistant \r\n");
                if (rsCheck.getInt("FIsChecked") == 0) {
                    sbSQL.append(" set FInvestMinorityRight = TO_DECIMAL(FNetAsset * (1-TO_DECIMAL(").append(Util.bigDecimalToPlainString((BigDecimal)rate)).append("/100,21,6)),21,6) \r\n");
                } else {
                    sbSQL.append(" set FInvestMinorityRight = TO_DECIMAL(FNetAsset * TO_DECIMAL(").append(Util.bigDecimalToPlainString((BigDecimal)rate)).append("/100,21,6),21,6) \r\n");
                }
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" and FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" And FTargetCompanyId = '").append(companyId).append("' \r\n");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
                sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
                sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                }
                if (param.getCompanyId() != null) {
                    sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
                }
                if (param.getTargetCompanyId() != null) {
                    sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                }
                st.addBatch(sbSQL.toString());
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(rsCheck);
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private void updateInterestIIAssistant(Context ctx, InvestCheckCondition param, ItemControlHelper ic, Map group) throws BOSException {
        if (group == null) {
            return;
        }
        StringBuffer sbSQL = null;
        Connection conn = null;
        Statement st = null;
        IRowSet rsCheck = null;
        IRowSet rsTemp = null;
        int count = 0;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            Set s = group.keySet();
            Iterator it = s.iterator();
            String companyId = null;
            BigDecimal rate = null;
            while (it.hasNext()) {
                companyId = (String)it.next();
                if (group.get(companyId) == null) continue;
                rate = (BigDecimal)group.get(companyId);
                sbSQL = new StringBuffer();
                sbSQL.append(" select FIsChecked from t_csl_IIAssistant \r\n");
                sbSQL.append(" where forgboundid = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" and forgunitid = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" and ftargetcompanyid = '").append(companyId).append("'");
                rsCheck = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                if (!rsCheck.next()) continue;
                sbSQL = new StringBuffer();
                sbSQL.append(" select count(*) As FCount from t_csl_IIAssistant \r\n");
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" And FTargetCompanyId = '").append(companyId).append("' \r\n");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
                sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
                sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                }
                if (param.getCompanyId() != null) {
                    sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
                }
                if (param.getTargetCompanyId() != null) {
                    sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                }
                if ((rsTemp = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString())).next()) {
                    count = rsTemp.getInt("fcount");
                }
                if (count <= 0) continue;
                sbSQL = new StringBuffer();
                sbSQL.append(" Update t_csl_IIAssistant \r\n");
                if (rsCheck.getInt("FIsChecked") == 0) {
                    sbSQL.append(" set FInterestMinorityRight = TO_DECIMAL(FNetProfit * (1-TO_DECIMAL(").append(Util.bigDecimalToPlainString((BigDecimal)rate)).append("/100,21,6)),21,6) \r\n");
                } else {
                    sbSQL.append(" set FInterestMinorityRight = TO_DECIMAL(FNetProfit * TO_DECIMAL(").append(Util.bigDecimalToPlainString((BigDecimal)rate)).append("/100,21,6),21,6) \r\n");
                }
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" And FTargetCompanyId = '").append(companyId).append("' \r\n");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
                sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
                sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                }
                if (param.getCompanyId() != null) {
                    sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
                }
                if (param.getTargetCompanyId() != null) {
                    sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                }
                st.addBatch(sbSQL.toString());
                sbSQL = new StringBuffer();
                sbSQL.append(" Update t_csl_IIAssistant \r\n");
                if (rsCheck.getInt("FIsChecked") == 0) {
                    sbSQL.append(" set FInterestMinorityRightYear = TO_DECIMAL(FNetProfitYear * (1-TO_DECIMAL(").append(rate).append("/100,21,6)),21,6) \r\n");
                } else {
                    sbSQL.append(" set FInterestMinorityRightYear = TO_DECIMAL(FNetProfitYear * TO_DECIMAL(").append(rate).append("/100,21,6),21,6) \r\n");
                }
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
                sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                sbSQL.append(" And FTargetCompanyId = '").append(companyId).append("' \r\n");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
                sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
                sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                }
                if (param.getCompanyId() != null) {
                    sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
                }
                if (param.getTargetCompanyId() != null) {
                    sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                }
                st.addBatch(sbSQL.toString());
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateMoreInvestIIAssistant(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException {
        if (!param.getMergeMode()) {
            return;
        }
        StringBuffer sbSQL = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" Update t_csl_IIAssistant \r\n");
        sbSQL.append(" Set FInvestMergeDiff = FInvestDiff \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        sbSQL.append(" And FIsChecked = 1 ");
        sbSQL.append(" And FNetAsset >= 0 ");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertAssistantIntoAssistantItemData(Context ctx, InvestCheckCondition param, ItemControlHelper ic, AssInsert ass) throws BOSException {
        block22: {
            block21: {
                block20: {
                    if (ic.getControlItemSQL(ass.getControl()).trim().equals("")) {
                        return;
                    }
                    d = new Date();
                    time = new Timestamp(d.getTime());
                    sbSQL = null;
                    fieldName = ass.getFieldName();
                    if (ass.getControl() != 8 && ass.getControl() != 7 && ass.getNetAsset() != 2) break block22;
                    sbSQL = new StringBuffer();
                    sbSQL.append(" select FTargetCompanyId From t_csl_IIAssistant ");
                    sbSQL.append(" Where FOrgBoundId = ? \r\n");
                    sbSQL.append(" And FOrgUnitId = ? \r\n");
                    sbSQL.append(" And FPeriodType = ? \r\n");
                    sbSQL.append(" And FYear = ? \r\n");
                    sbSQL.append(" And FPeriod = ? \r\n");
                    sbSQL.append(" And FNetAsset < 0");
                    rs = null;
                    rs2 = null;
                    ps = null;
                    ps2 = null;
                    conn = null;
                    try {
                        conn = super.getConnection(ctx);
                        ps = conn.prepareStatement(sbSQL.toString());
                        ps.setString(1, param.getOrgTreeId());
                        ps.setString(2, param.getOrgBoundId());
                        ps.setInt(3, param.getPeriodType());
                        ps.setInt(4, param.getYear());
                        ps.setInt(5, param.getPeriod());
                        rs = ps.executeQuery();
                        selecttime = new Timestamp(param.getDay().getTime());
                        tmp = new StringBuffer();
                        tmp.append(" from t_csl_sharerela sr1 inner join  (select FShareHolderId, ");
                        tmp.append(" max(FChangeDate) as maxdate from t_csl_sharerela where ");
                        tmp.append(" finvesteecompanyid = ? and FChangeDate <= ? ");
                        tmp.append(" group by FShareHolderId) sr2 on  ");
                        tmp.append(" sr1.FShareHolderId = sr2.FShareHolderId and sr1.FChangeDate = sr2.maxdate)");
                        sbSQL = new StringBuffer();
                        sbSQL.append(" select fshareHolderId from ");
                        sbSQL.append(" (select sr1.fshareHolderId as fshareHolderId,  ");
                        sbSQL.append(" sr1.fsharescale as fsharescale ");
                        sbSQL.append(tmp.toString());
                        sbSQL.append(" where fsharescale in (select max(sr1.fsharescale) as fsharescale ");
                        sbSQL.append(tmp.toString());
lbl62:
                        // 2 sources

                        while (rs.next()) {
                            ps2 = conn.prepareStatement(sbSQL.toString());
                            ps2.setString(1, rs.getString("FTargetCompanyId"));
                            ps2.setTimestamp(2, selecttime);
                            ps2.setString(3, rs.getString("FTargetCompanyId"));
                            ps2.setTimestamp(4, selecttime);
                            rs2 = ps2.executeQuery();
                            list = new ArrayList<String>();
                            if (rs2.next()) {
                                list.add(rs2.getString("fshareHolderId"));
                            }
                            isCompanyNull = false;
                            maxCompanyId = null;
                            if (list.size() == 0) {
                                break block20;
                            }
                            ** GOTO lbl-1000
                        }
                        break block21;
                    }
                    catch (SQLException e) {
                        try {
                            throw new SQLDataException(e);
                        }
                        catch (Throwable var21_24) {
                            SQLUtils.cleanup(rs, ps);
                            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                            throw var21_24;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return;
lbl-1000:
                // 1 sources

                {
                    block23: {
                        if (list.size() != 1) break block23;
                        maxCompanyId = (String)list.get(0);
                        ** GOTO lbl126
                    }
                    sbSQL = new StringBuffer();
                    sbSQL.append(" select fid from t_org_structure ");
                    sbSQL.append(" where fTreeId = ? And FLevel > ? ");
                    sbSQL.append(" And FUnitId IN (");
                    first = true;
                    for (i = 0; i < list.size(); ++i) {
                        if (!first) {
                            sbSQL.append(",");
                        } else {
                            first = false;
                        }
                        sbSQL.append("?");
                    }
                    sbSQL.append(") ");
                    SQLUtils.cleanup((ResultSet)rs2, (Statement)ps2);
                    ps2 = conn.prepareStatement(sbSQL.toString());
                    ps2.setString(1, param.getOrgTreeId());
                    ps2.setInt(2, param.getLevel());
                    for (i = 0; i < list.size(); ++i) {
                        ps2.setString(3 + i, list.get(i).toString());
                    }
                    rs2 = ps2.executeQuery();
                    if (!rs2.next()) ** GOTO lbl-1000
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return;
lbl-1000:
                // 1 sources

                {
                    isCompanyNull = true;
lbl126:
                    // 2 sources

                    SQLUtils.cleanup((ResultSet)rs2, (Statement)ps2);
                    itemNumber = ic.getControlItemSQL(ass.getControl());
                    sbSQL = new StringBuffer();
                    sbSQL.append(" Insert into t_CSL_IIAssistantItemData(FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId, \r\n");
                    sbSQL.append(" FCurrencyId,FTargetCurrencyId,FPeriodType,FYear,FPeriod,FDay,FItemNumber,Fdc,FMoney,FDataElement, \r\n");
                    sbSQL.append(" FControlAttr,FMergeMode,FCreatorId,FCreateTime) \r\n");
                    sbSQL.append(" Select newbosId('").append("2E927A17").append("'),a.* From ");
                    sbSQL.append(" (Select ");
                    if (isCompanyNull) {
                        sbSQL.append(" top 1");
                    }
                    sbSQL.append(" FOrgBoundId,FOrgUnitId,");
                    sbSQL.append(isCompanyNull != false ? "''" : "'" + maxCompanyId + "'");
                    sbSQL.append(" as FCompanyId,FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
                    sbSQL.append(" FPeriodType,FYear,FPeriod,FDay, \r\n");
                    sbSQL.append(itemNumber).append(" As FItemNumber, \r\n");
                    sbSQL.append(ass.getDC()).append(" As Fdc, \r\n");
                    sbSQL.append(ass.getIsGroup() != false ? "SUM(" + fieldName + ")" : fieldName).append(" As FMoney, \r\n");
                    sbSQL.append(ass.getDataElement()).append(" As FDataElement, \r\n");
                    sbSQL.append(ass.getControl()).append(" As FControlAttr, \r\n");
                    sbSQL.append(param.getMergeMode() != false ? 1 : 0).append(" As FMergeMode, \r\n");
                    sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCreatorId, \r\n");
                    sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
                    sbSQL.append(" From t_csl_IIAssistant t1 \r\n");
                    sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
                    sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("'");
                    if (!isCompanyNull) {
                        sbSQL.append(" And FCompanyId = '").append(maxCompanyId).append("'");
                    }
                    sbSQL.append(" And FTargetCompanyId = '").append(rs.getString("FTargetCompanyId")).append("'");
                    sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
                    sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
                    sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
                    sbSQL.append(" And FNetAsset < 0").append(" \r\n");
                    sbSQL.append(" ) a");
                    DbUtil.execute((Context)ctx, (String)sbSQL.toString());
                    ** GOTO lbl62
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return;
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" Insert into t_CSL_IIAssistantItemData(FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId, \r\n");
        sbSQL.append(" FCurrencyId,FTargetCurrencyId,FPeriodType,FYear,FPeriod,FDay,FItemNumber,Fdc,FMoney,FDataElement, \r\n");
        sbSQL.append(" FControlAttr,FMergeMode,FCreatorId,FCreateTime) \r\n");
        sbSQL.append(" Select newbosId('").append("2E927A17").append("'),a.* From ");
        sbSQL.append(" (Select ");
        if (!ass.getIsShareHolder()) {
            sbSQL.append(" distinct ");
        }
        sbSQL.append(" FOrgBoundId,FOrgUnitId,").append(ass.getIsShareHolder() != false ? "FCompanyId," : "FTargetCompanyId As FCompanyId,");
        sbSQL.append(" FTargetCompanyId,FCurrencyId,FTargetCurrencyId, \r\n");
        sbSQL.append(" FPeriodType,FYear,FPeriod,FDay, \r\n");
        sbSQL.append(ic.getControlItemSQL(ass.getControl())).append(" As FItemNumber, \r\n");
        sbSQL.append(ass.getDC()).append(" As Fdc, \r\n");
        sbSQL.append(ass.getIsGroup() != false ? "SUM(" + fieldName + ")" : fieldName).append(" As FMoney, \r\n");
        sbSQL.append(ass.getDataElement()).append(" As FDataElement, \r\n");
        sbSQL.append(ass.getControl()).append(" As FControlAttr, \r\n");
        sbSQL.append(param.getMergeMode() != false ? 1 : 0).append(" As FMergeMode, \r\n");
        sbSQL.append(" '").append(ctx.getCaller().toString()).append("' As FCreatorId, \r\n");
        sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
        sbSQL.append(" From t_csl_IIAssistant t1 \r\n");
        if (ass.getIsByRate()) {
            selecttime = new Timestamp(param.getDay().getTime());
            sbSQL.append(" Join (select sr1.FInvesteeCompanyId As FCompany ,Sum(sr1.FShareScale) As FRateTotal \r\n");
            sbSQL.append(" from t_csl_sharerela sr1 inner join \r\n");
            sbSQL.append(" (select FInvesteeCompanyId As FCompany ,FShareHolderId, max(FChangeDate) as maxdate \r\n");
            sbSQL.append(" from t_csl_sharerela \r\n");
            sbSQL.append(" Where FIsOut = 0 \r\n");
            sbSQL.append(" And FInvesteeCompanyId IN \r\n");
            sbSQL.append(" (Select distinct FTargetCompanyId From t_csl_IIAssistant \r\n");
            sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
            sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
            sbSQL.append(" And FYear = ").append(param.getYear());
            sbSQL.append(" And FPeriod = ").append(param.getPeriod());
            sbSQL.append(" And FNetAsset >= 0) \r\n");
            sbSQL.append(" and FChangeDate <= TimeStamp'").append(selecttime.toString()).append("'");
            sbSQL.append(" Group by FInvesteeCompanyId, FShareHolderId) sr2 \r\n");
            sbSQL.append(" on sr1.FInvesteeCompanyId = sr2.FCompany \r\n");
            sbSQL.append(" and sr1.FShareHolderId = sr2.FShareHolderId \r\n");
            sbSQL.append(" and sr1.FChangeDate = sr2.maxdate Group by sr1.FInvesteeCompanyId \r\n");
            sbSQL.append(" ) t2 on t1.FTargetCompanyId = t2.FCompany \r\n");
        }
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("'");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        sbSQL.append(" And FIsChecked =").append(ass.getIsCurrentLevel() != false ? 0 : 1).append(" \r\n");
        if (ass.getNetAsset() != 0) {
            sbSQL.append(" And FNetAsset ").append(ass.getNetAsset() == 1 ? ">= 0" : "< 0").append(" \r\n");
        }
        if (ass.getIsGroup()) {
            sbSQL.append(" Group by ").append(ass.getStrGroupSQL());
        }
        sbSQL.append(" ) a");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void clearAssistantItemData(Context ctx, InvestCheckCondition param) throws BOSException {
        StringBuffer delSQL = new StringBuffer();
        ArrayList<Object> delParams = new ArrayList<Object>();
        delSQL.append(" delete from t_CSL_IIAssistantItemData where FOrgBoundId = ? and FOrgUnitId = ? ");
        delSQL.append(" and FPeriodType = ? and FYear = ? and FPeriod = ?  ");
        delParams.add(param.getOrgTreeId());
        delParams.add(param.getOrgBoundId());
        delParams.add(new Integer(param.getPeriodType()));
        delParams.add(new Integer(param.getYear()));
        delParams.add(new Integer(param.getPeriod()));
        DbUtil.execute((Context)ctx, (String)delSQL.toString(), (Object[])delParams.toArray());
    }

    private BigDecimal calculateEquivalentRate(Context ctx, String fromCompanyId, String toCompanyId, String tempTableName, Date time) throws BOSException {
        StringBuffer sbSQL = null;
        DbUtil.execute((Context)ctx, (String)("delete From " + tempTableName));
        sbSQL = new StringBuffer();
        int level = 1;
        BigDecimal result = new BigDecimal("0");
        sbSQL.append(" insert into ").append(tempTableName);
        sbSQL.append(" values(1,'").append(toCompanyId).append("', 1.0)");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        Connection conn = null;
        Statement ps = null;
        IRowSet rs = null;
        String levelSql = "select flevel, fcompanyID, fstockRight From " + tempTableName + " where flevel = ?";
        String topLevelSql = "select top 1 flevel, fcompanyID, fstockRight From " + tempTableName + " where flevel = ?";
        String delSql = "Delete From " + tempTableName + " where fcompanyId = ? and flevel = ?";
        String topSql = "select top 1 fid From t_csl_ShareRela Where FIsLatest = 1 And FIsOut = 0 And FInvesteeCompanyId = ?";
        try {
            conn = super.getConnection(ctx);
            String companyto = new String();
            BigDecimal currentStockRight = new BigDecimal("0");
            while (level > 0) {
                rs = DbUtil.executeQuery((Context)ctx, (String)levelSql, (Object[])new Object[]{level});
                if (rs.next()) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)topLevelSql, (Object[])new Object[]{level});
                    if (rs.next()) {
                        companyto = rs.getString("fcompanyId");
                        currentStockRight = rs.getBigDecimal("fstockRight");
                    }
                    DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{companyto, level});
                    if (companyto.equals(fromCompanyId)) {
                        result = result.add(currentStockRight);
                    }
                    if (!(rs = DbUtil.executeQuery((Context)ctx, (String)"select top 1 fid From t_csl_ShareRela Where FIsLatest = 1 And FIsOut = 0 And FInvesteeCompanyId = ?", (Object[])new Object[]{companyto})).next()) continue;
                    sbSQL = new StringBuffer();
                    Timestamp selecttime = new Timestamp(time.getTime());
                    sbSQL.append(" insert into ").append(tempTableName).append("(flevel, fcompanyId, fstockRight) \r\n");
                    sbSQL.append(" select ").append(++level).append(", \r\n");
                    sbSQL.append(" sr1.FShareHolderId, \r\n");
                    sbSQL.append(" TO_DECIMAL(TO_DECIMAL(sr1.FShareScale,21,6) * TO_DECIMAL(").append(currentStockRight).append("/100,21,6),21,6) \r\n");
                    sbSQL.append(" From t_csl_ShareRela sr1 inner join \r\n");
                    sbSQL.append(" (select FShareHolderId, max(FChangeDate) as maxdate \r\n");
                    sbSQL.append(" from t_csl_ShareRela where FIsOut = 0 \r\n");
                    sbSQL.append(" And FInvesteeCompanyId = ? \r\n");
                    sbSQL.append(" and FChangeDate <= TimeStamp'").append(selecttime.toString()).append("' \r\n");
                    sbSQL.append(" group by FShareHolderId) sr2  \r\n");
                    sbSQL.append(" on sr1.FShareHolderId = sr2.FShareHolderId \r\n");
                    sbSQL.append(" and sr1.FChangeDate = sr2.maxdate \r\n");
                    DbUtil.execute((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{companyto});
                    continue;
                }
                --level;
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
        }
        return result;
    }

    private void dropTempTable(Context ctx, String tempTableName) throws BOSException {
    }

    private boolean isDistillControl(int control) {
        return control == 29 || control == 30 || control == 31;
    }

    private String getStockCompanyUnitId(Context ctx, String stockCompanyId) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String unitId = null;
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement("select fUnitId From t_org_OUPartUnionGroup where fStockControlCompanyId = ?");
            ps.setString(1, stockCompanyId);
            rs = ps.executeQuery();
            if (rs.next()) {
                unitId = rs.getString("fUnitId");
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return unitId;
    }

    private String getStockCompanyUnitId(Context ctx, String stockCompanyId, String treeId) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String unitId = null;
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement("select t1.funitid From t_org_OUPartUnionGroup t1 join t_org_structure t2 on t1.funitid=t2.funitid where fStockControlCompanyId = ? and t2.ftreeid= ? ");
            ps.setString(1, stockCompanyId);
            ps.setString(2, treeId);
            rs = ps.executeQuery();
            if (rs.next()) {
                unitId = rs.getString("fUnitId");
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return unitId;
    }

    private boolean insertControlItemIntoIIAssistantItemData(Context ctx, InvestCheckCondition param, ItemControlHelper ic, Map rate, AssInsert[] ass, boolean isDistill, String tempTableName) throws BOSException, EASBizException {
        if (ass.length == 0) {
            return true;
        }
        StringBuffer sbSQL = null;
        Connection conn = null;
        Statement st = null;
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        IRowSet rs = null;
        rs = !isDistill ? (ass[0].getIsShareHolder() ? this.GetIIAssistantDataByCompany(ctx, param, true, ass[0].getNetAsset()) : this.GetIIAssistantDataByTargetCompany(ctx, param, true, ass[0].getNetAsset())) : this.GetDistillCompany(ctx, param);
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            Map itemValues = null;
            Set key = null;
            IItemDataProvider idp = ItemDataProviderFactory.getLocalInstance(ctx);
            ItemDataCondition condition = new ItemDataCondition();
            condition.setOrgTreeId(param.getOrgTreeId());
            condition.setValueType(1);
            condition.setRptPeriodType(param.getPeriodType());
            condition.setRptYearStart(param.getYear());
            condition.setRptPeriodStart(param.getPeriod());
            condition.setRptYearEnd(param.getYear());
            condition.setRptPeriodEnd(param.getPeriod());
            Map m = ic.getUnionControlItemMap(ass);
            if (m != null) {
                rs.beforeFirst();
                while (rs.next()) {
                    if (ass[0].getControl() == 20 && rs.getInt("FIsChecked") == 1) continue;
                    condition.setDataElement(ass[0].getDataElement());
                    condition.setOrgUnit(CslRptUtil.arrOrgUnit(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? this.getStockCompanyUnitId(ctx, rs.getString("FTargetCompanyId"), param.getOrgTreeId()) : rs.getString("FTargetCompanyId")));
                    condition.setCurrency(rs.getString("FCurrencyId"));
                    condition.setTargetCurrency(rs.getString("FCurrencyId"));
                    condition.setDataSource(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? 3 : 1);
                    condition.setItemList(m);
                    condition.setCommitStatus(3);
                    itemValues = idp.getAcctItems(condition);
                    if (ass[0].getControl() == 10 && ass[0].getDataElement() == 3 && itemValues.get(ic.getControlItem(ass[0].getControl())) == null) {
                        condition.setDataElement(5);
                        itemValues = idp.getAcctItems(condition);
                    }
                    int n = ass.length;
                    for (int i = 0; i < n; ++i) {
                        if (ass[i].getIsSpread()) {
                            key = itemValues.keySet();
                            for (Object objKey : key) {
                                sbSQL = new StringBuffer();
                                sbSQL.append(" Insert into t_Csl_IIAssistantItemData(FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId, \r\n");
                                sbSQL.append(" FCurrencyId,FTargetCurrencyId,FPeriodType,FYear,FPeriod,FDay,FItemNumber,Fdc,FMoney,FFlag,FDataElement, \r\n");
                                sbSQL.append(" FControlAttr,FMergeMode,FCreatorId,FCreateTime) \r\n");
                                sbSQL.append(" values(newbosId('").append(IIASSISTANTITEMDATA_BOSTYPE).append("'),'").append(param.getOrgTreeId()).append("', \r\n");
                                sbSQL.append("'").append(param.getOrgBoundId()).append("', \r\n");
                                sbSQL.append("'").append(ass[0].getIsShareHolder() ? rs.getString("FCompanyId") : rs.getString("FTargetCompanyId")).append("', \r\n");
                                sbSQL.append("'").append(rs.getString("FTargetCompanyId")).append("', \r\n");
                                sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                                sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                                sbSQL.append(param.getPeriodType()).append(", \r\n");
                                sbSQL.append(param.getYear()).append(", \r\n");
                                sbSQL.append(param.getPeriod()).append(", \r\n");
                                sbSQL.append("TimeStamp'").append(new Timestamp(param.getDay().getTime()).toString()).append("', \r\n");
                                sbSQL.append("'").append(objKey).append("', \r\n");
                                sbSQL.append(ass[i].getDC()).append(", \r\n");
                                sbSQL.append(itemValues.get(objKey) == null ? "0" : CslRptUtil.getCastDecimalString((BigDecimal)itemValues.get(objKey))).append(", \r\n");
                                sbSQL.append(ass[i].getFlag()).append(", \r\n");
                                sbSQL.append(ass[i].getDataElement()).append(", \r\n");
                                sbSQL.append(ass[i].getControl()).append(", \r\n");
                                sbSQL.append(param.getMergeMode() ? 1 : 0).append(", \r\n");
                                sbSQL.append("'").append(ctx.getCaller()).append("', \r\n");
                                sbSQL.append("TimeStamp'").append(time.toString()).append("') \r\n");
                                st.addBatch(sbSQL.toString());
                            }
                            continue;
                        }
                        if (ic.getControlItemSQL(ass[i].getControl()) == null || ic.getControlItemSQL(ass[i].getControl()).trim().length() <= 0) continue;
                        Object obj = ic.getControlItem(ass[i].getControl());
                        if (obj instanceof String) {
                            sbSQL = new StringBuffer();
                            sbSQL.append(" Insert into t_CSL_IIAssistantItemData(FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId, \r\n");
                            sbSQL.append(" FCurrencyId,FTargetCurrencyId,FPeriodType,FYear,FPeriod,FDay,FItemNumber,Fdc,FMoney,FFlag,FDataElement, \r\n");
                            sbSQL.append(" FControlAttr,FMergeMode,FCreatorId,FCreateTime) \r\n");
                            sbSQL.append(" values(newbosId('").append(IIASSISTANTITEMDATA_BOSTYPE).append("'),'").append(param.getOrgTreeId()).append("', \r\n");
                            sbSQL.append("'").append(param.getOrgBoundId()).append("', \r\n");
                            sbSQL.append("'").append(ass[0].getIsShareHolder() ? rs.getString("FCompanyId") : rs.getString("FTargetCompanyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FTargetCompanyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                            sbSQL.append(param.getPeriodType()).append(", \r\n");
                            sbSQL.append(param.getYear()).append(", \r\n");
                            sbSQL.append(param.getPeriod()).append(", \r\n");
                            sbSQL.append("TimeStamp'").append(new Timestamp(param.getDay().getTime()).toString()).append("', \r\n");
                            sbSQL.append(ic.getControlItemSQL(ass[i].getControl())).append(", \r\n");
                            sbSQL.append(ass[i].getDC()).append(", \r\n");
                            sbSQL.append(itemValues.get(ic.getControlItem(ass[i].getControl())) == null ? "0" : (this.isDistillControl(ass[i].getControl()) && ass[i].getFlag() == 31 ? CslRptUtil.getCastDecimalString(((BigDecimal)itemValues.get(ic.getControlItem(ass[i].getControl()))).multiply(this.calculateEquivalentRate(ctx, param.getStockControlCompanyId(), rs.getString("FTargetCompanyId"), tempTableName, param.getDay()))) : CslRptUtil.getCastDecimalString((BigDecimal)itemValues.get(ic.getControlItem(ass[i].getControl()))))).append(", \r\n");
                            sbSQL.append(ass[i].getFlag()).append(", \r\n");
                            sbSQL.append(ass[i].getDataElement()).append(", \r\n");
                            sbSQL.append(ass[i].getControl()).append(", \r\n");
                            sbSQL.append(param.getMergeMode() ? 1 : 0).append(", \r\n");
                            sbSQL.append("'").append(ctx.getCaller()).append("', \r\n");
                            sbSQL.append("TimeStamp'").append(time.toString()).append("') \r\n");
                            st.addBatch(sbSQL.toString());
                            continue;
                        }
                        if (!(obj instanceof List)) continue;
                        List l = (List)obj;
                        for (Object o : l) {
                            sbSQL = new StringBuffer();
                            sbSQL.append(" Insert into t_CSL_IIAssistantItemData(FId,FOrgBoundId,FOrgUnitId,FCompanyId,FTargetCompanyId, \r\n");
                            sbSQL.append(" FCurrencyId,FTargetCurrencyId,FPeriodType,FYear,FPeriod,FDay,FItemNumber,Fdc,FMoney,FFlag,FDataElement, \r\n");
                            sbSQL.append(" FControlAttr,FMergeMode,FCreatorId,FCreateTime) \r\n");
                            sbSQL.append(" values(newbosId('").append(IIASSISTANTITEMDATA_BOSTYPE).append("'),'").append(param.getOrgTreeId()).append("', \r\n");
                            sbSQL.append("'").append(param.getOrgBoundId()).append("', \r\n");
                            sbSQL.append("'").append(ass[0].getIsShareHolder() ? rs.getString("FCompanyId") : rs.getString("FTargetCompanyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FTargetCompanyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                            sbSQL.append("'").append(rs.getString("FCurrencyId")).append("', \r\n");
                            sbSQL.append(param.getPeriodType()).append(", \r\n");
                            sbSQL.append(param.getYear()).append(", \r\n");
                            sbSQL.append(param.getPeriod()).append(", \r\n");
                            sbSQL.append("TimeStamp'").append(new Timestamp(param.getDay().getTime()).toString()).append("', \r\n");
                            sbSQL.append("'" + (String)o + "'").append(", \r\n");
                            sbSQL.append(ass[i].getDC()).append(", \r\n");
                            sbSQL.append(itemValues.get(o) == null ? "0" : CslRptUtil.getCastDecimalString((BigDecimal)itemValues.get(o))).append(", \r\n");
                            sbSQL.append(ass[i].getFlag()).append(", \r\n");
                            sbSQL.append(ass[i].getDataElement()).append(", \r\n");
                            sbSQL.append(ass[i].getControl()).append(", \r\n");
                            sbSQL.append(param.getMergeMode() ? 1 : 0).append(", \r\n");
                            sbSQL.append("'").append(ctx.getCaller()).append("', \r\n");
                            sbSQL.append("TimeStamp'").append(time.toString()).append("') \r\n");
                            st.addBatch(sbSQL.toString());
                        }
                    }
                }
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return true;
    }

    private void updateProfitAssistant(Context ctx, InvestCheckCondition param, ItemControlHelper ic, IRowSet rs) throws BOSException, EASBizException {
        Map m2;
        String formula;
        String number;
        boolean isSum;
        BigDecimal value;
        Map m;
        ItemDataCondition condition;
        IItemDataProvider idp;
        Map itemValues;
        AssInsert[] ass = new AssInsert[]{new AssInsert(true, 21, true, 2, false)};
        StringBuffer sbSQL = null;
        Connection conn = null;
        Statement st = null;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            itemValues = null;
            idp = ItemDataProviderFactory.getLocalInstance(ctx);
            condition = new ItemDataCondition();
            condition.setOrgTreeId(param.getOrgTreeId());
            condition.setValueType(1);
            condition.setRptPeriodType(param.getPeriodType());
            condition.setRptYearStart(param.getYear());
            condition.setRptPeriodStart(param.getPeriod());
            condition.setRptYearEnd(param.getYear());
            condition.setRptPeriodEnd(param.getPeriod());
            m = ic.getUnionControlItemMap(ass);
            if (m != null) {
                rs.beforeFirst();
                value = new BigDecimal("0");
                while (rs.next()) {
                    condition.setDataElement(ass[0].getDataElement());
                    condition.setOrgUnit(CslRptUtil.arrOrgUnit(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? this.getStockCompanyUnitId(ctx, rs.getString("FTargetCompanyId"), param.getOrgTreeId()) : rs.getString("FTargetCompanyId")));
                    condition.setCurrency(rs.getString("FCurrencyId"));
                    condition.setTargetCurrency(rs.getString("FCurrencyId"));
                    condition.setDataSource(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? 3 : 1);
                    condition.setItemList(m);
                    condition.setCommitStatus(3);
                    itemValues = idp.getAcctItems(condition);
                    isSum = false;
                    number = ic.getControlItemNumber(ass[0].getControl());
                    if (ic.getControlItem(ass[0].getControl()) instanceof Map && ((Map)ic.getControlItem(ass[0].getControl())).get(number) != null) {
                        isSum = true;
                    }
                    if (isSum) {
                        formula = null;
                        m2 = (Map)ic.getControlItem(ass[0].getControl());
                        formula = (String)((Map)m2.get(number)).get(FORMULA_KEY + number);
                        value = this.calculateSumItemFormula(formula, (Map)m2.get(number), itemValues);
                    } else {
                        BigDecimal bigDecimal = value = itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic)) == null ? new BigDecimal("0") : (BigDecimal)itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic));
                    }
                    if (value == null) continue;
                    sbSQL = new StringBuffer();
                    sbSQL.append(" Update t_csl_IIAssistant Set FNetProfit = ").append(CslRptUtil.getCastDecimalString(value));
                    sbSQL.append(" Where FOrgBoundId ='").append(param.getOrgTreeId()).append("' \r\n");
                    sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                    sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
                    sbSQL.append(" And FYear = ").append(param.getYear());
                    sbSQL.append(" And FPeriod = ").append(param.getPeriod());
                    sbSQL.append(" And FTargetCompanyId ='").append(rs.getString("FTargetCompanyId")).append("'");
                    st.addBatch(sbSQL.toString());
                }
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        ass = new AssInsert[]{new AssInsert(true, 21, true, 3, false)};
        sbSQL = null;
        conn = null;
        st = null;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            itemValues = null;
            idp = ItemDataProviderFactory.getLocalInstance(ctx);
            condition = new ItemDataCondition();
            condition.setOrgTreeId(param.getOrgTreeId());
            condition.setValueType(1);
            condition.setRptPeriodType(param.getPeriodType());
            condition.setRptYearStart(param.getYear());
            condition.setRptPeriodStart(param.getPeriod());
            condition.setRptYearEnd(param.getYear());
            condition.setRptPeriodEnd(param.getPeriod());
            m = ic.getUnionControlItemMap(ass);
            if (m != null) {
                rs.beforeFirst();
                value = new BigDecimal("0");
                while (rs.next()) {
                    condition.setDataElement(ass[0].getDataElement());
                    condition.setOrgUnit(CslRptUtil.arrOrgUnit(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? this.getStockCompanyUnitId(ctx, rs.getString("FTargetCompanyId"), param.getOrgTreeId()) : rs.getString("FTargetCompanyId")));
                    condition.setCurrency(rs.getString("FCurrencyId"));
                    condition.setTargetCurrency(rs.getString("FCurrencyId"));
                    condition.setDataSource(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? 3 : 1);
                    condition.setItemList(m);
                    condition.setCommitStatus(3);
                    itemValues = idp.getAcctItems(condition);
                    isSum = false;
                    number = ic.getControlItemNumber(ass[0].getControl());
                    if (ic.getControlItem(ass[0].getControl()) instanceof Map && ((Map)ic.getControlItem(ass[0].getControl())).get(number) != null) {
                        isSum = true;
                    }
                    if (isSum) {
                        formula = null;
                        m2 = (Map)ic.getControlItem(ass[0].getControl());
                        formula = (String)((Map)m2.get(number)).get(FORMULA_KEY + number);
                        value = this.calculateSumItemFormula(formula, (Map)m2.get(number), itemValues);
                    } else {
                        BigDecimal bigDecimal = value = itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic)) == null ? new BigDecimal("0") : (BigDecimal)itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic));
                    }
                    if (value == null) continue;
                    sbSQL = new StringBuffer();
                    sbSQL.append(" Update t_csl_IIAssistant Set FNetProfitYear = ").append(CslRptUtil.getCastDecimalString(value));
                    sbSQL.append(" Where FOrgBoundId ='").append(param.getOrgTreeId()).append("' \r\n");
                    sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                    sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
                    sbSQL.append(" And FYear = ").append(param.getYear());
                    sbSQL.append(" And FPeriod = ").append(param.getPeriod());
                    sbSQL.append(" And FTargetCompanyId ='").append(rs.getString("FTargetCompanyId")).append("'");
                    st.addBatch(sbSQL.toString());
                }
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private void updateOwnerRightAssistant(Context ctx, InvestCheckCondition param, ItemControlHelper ic, IRowSet rs) throws BOSException, EASBizException {
        AssInsert[] ass = new AssInsert[]{ic.getHelper().getControlTempletInfo(1, 20, 4, true)};
        StringBuffer sbSQL = null;
        Connection conn = null;
        Statement st = null;
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            Map itemValues = null;
            IItemDataProvider idp = ItemDataProviderFactory.getLocalInstance(ctx);
            ItemDataCondition condition = new ItemDataCondition();
            condition.setOrgTreeId(param.getOrgTreeId());
            condition.setValueType(1);
            condition.setRptPeriodType(param.getPeriodType());
            condition.setRptYearStart(param.getYear());
            condition.setRptPeriodStart(param.getPeriod());
            condition.setRptYearEnd(param.getYear());
            condition.setRptPeriodEnd(param.getPeriod());
            Map m = ic.getUnionControlItemMap(ass);
            if (m != null) {
                rs.beforeFirst();
                BigDecimal value = null;
                while (rs.next()) {
                    condition.setDataElement(ass[0].getDataElement());
                    condition.setOrgUnit(CslRptUtil.arrOrgUnit(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? this.getStockCompanyUnitId(ctx, rs.getString("FTargetCompanyId"), param.getOrgTreeId()) : rs.getString("FTargetCompanyId")));
                    condition.setCurrency(rs.getString("FCurrencyId"));
                    condition.setTargetCurrency(rs.getString("FCurrencyId"));
                    condition.setDataSource(param.getMergeMode() && rs.getBoolean("FToIsStockControl") ? 3 : 1);
                    condition.setItemList(m);
                    condition.setCommitStatus(3);
                    itemValues = idp.getAcctItems(condition);
                    boolean isSum = false;
                    String number = ic.getControlItemNumber(ass[0].getControl());
                    if (ic.getControlItem(ass[0].getControl()) instanceof Map && ((Map)ic.getControlItem(ass[0].getControl())).get(number) != null) {
                        isSum = true;
                    }
                    if (isSum) {
                        String formula = null;
                        Map m2 = (Map)ic.getControlItem(ass[0].getControl());
                        formula = (String)((Map)m2.get(number)).get(FORMULA_KEY + number);
                        value = this.calculateSumItemFormula(formula, (Map)m2.get(number), itemValues);
                    } else {
                        value = itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic)) == null ? new BigDecimal("0") : (BigDecimal)itemValues.get(this.getControlItemNumber(ass[0].getControl(), ic));
                    }
                    sbSQL = new StringBuffer();
                    if (value == null) continue;
                    sbSQL.append(" Update t_csl_IIAssistant Set FNetAsset = ").append(CslRptUtil.getCastDecimalString(value));
                    sbSQL.append(" Where FOrgBoundId ='").append(param.getOrgTreeId()).append("' \r\n");
                    sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
                    sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
                    sbSQL.append(" And FYear = ").append(param.getYear());
                    sbSQL.append(" And FPeriod = ").append(param.getPeriod());
                    sbSQL.append(" And FTargetCompanyId ='").append(rs.getString("FTargetCompanyId")).append("'");
                    st.addBatch(sbSQL.toString());
                }
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private String getControlItemNumber(int control, ItemControlHelper ic) {
        Set key;
        Iterator it;
        Object obj = ic.getControlItem(control);
        if (obj != null && obj instanceof Map && (it = (key = ((Map)obj).keySet()).iterator()).hasNext()) {
            return (String)it.next();
        }
        return null;
    }

    private BigDecimal calculateSumItemFormula(String formula, Map items, Map itemValues) {
        BigDecimal b = null;
        Set keys = items.keySet();
        Iterator it = keys.iterator();
        HashMap<String, Object> col = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof String) || !((String)obj).startsWith(ITEMS_KEY)) continue;
            if (col == null) {
                col = new HashMap<String, Object>();
            }
            col.put(((String)obj).substring(6), null);
        }
        if (col != null) {
            keys = col.keySet();
            for (Object obj : keys) {
                b = this.calculateSumItemFormula((String)items.get(FORMULA_KEY + obj), (Map)items.get(ITEMS_KEY + obj), itemValues);
                itemValues.put(obj, b);
            }
        }
        return CslRptUtil.calculate(formula, itemValues);
    }

    private IRowSet GetDistillCompany(Context ctx, InvestCheckCondition param) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select a.FCurrencyID As FCurrencyId,'");
        sbSQL.append(param.getStockControlCompanyId()).append("' As FCompanyId,");
        sbSQL.append(" b.FUnitId As FTargetCompanyId, \r\n");
        sbSQL.append(" 0 As FToIsStockControl,0 As FIsChecked \r\n");
        sbSQL.append(" From \r\n");
        sbSQL.append(" (Select distinct FCurrencyId \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(") a, \r\n");
        sbSQL.append(" (select t1.FUnitId \r\n");
        sbSQL.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid \r\n");
        sbSQL.append(" where t1.ftreeid='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" and t1.flongnumber like '").append(param.getLongNumber()).append("%' \r\n");
        sbSQL.append(" and t1.funitid not in \r\n");
        sbSQL.append(" (select fstockcontrolcompanyid from t_org_oupartuniongroup \r\n");
        sbSQL.append(" where funitid='").append(param.getOrgBoundId()).append("'");
        sbSQL.append(" ) \r\n");
        sbSQL.append(" and t2.fiscompanyorgunit=1) b \r\n");
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
    }

    private IRowSet GetIIAssistantDataByCompany(Context ctx, InvestCheckCondition param, boolean isFillItemData, int netAsset) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" Select distinct FCurrencyId, FCompanyId, FTargetCompanyId, FToIsStockControl, FIsChecked \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        if (!isFillItemData) {
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            if (param.getCompanyId() != null) {
                sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And FTargetCompanyId ='").append(param.getTargetCompanyId()).append("' \r\n");
            }
        }
        if (netAsset != 0) {
            sbSQL.append(" And ").append(netAsset == 1 ? " FNetAsset >= 0" : "FNetAsset < 0");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
    }

    private IRowSet GetIIAssistantDataByTargetCompany(Context ctx, InvestCheckCondition param, boolean isFillItemData, int netAsset) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" Select distinct FCurrencyId, FTargetCompanyId as FTargetCompanyId, FToIsStockControl, FIsChecked \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        if (!isFillItemData) {
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            if (param.getCompanyId() != null) {
                sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And FTargetCompanyId ='").append(param.getTargetCompanyId()).append("' \r\n");
            }
        }
        if (netAsset != 0) {
            sbSQL.append(" And ").append(netAsset == 1 ? " FNetAsset >= 0" : "FNetAsset < 0");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
    }

    private IRowSet GetIIAssistantDataCompany(Context ctx, InvestCheckCondition param) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" Select distinct FCurrencyId, FTargetCompanyId as FTargetCompanyId, FToIsStockControl \r\n");
        sbSQL.append(" From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("' \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId ='").append(param.getTargetCompanyId()).append("' \r\n");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
    }

    private Map getIIAssistantRateInGroup(Context ctx, InvestCheckCondition param, boolean isFillItemData) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        Timestamp time = new Timestamp(param.getDay().getTime());
        IRowSet rs = null;
        HashMap<String, BigDecimal> ret = null;
        sbSQL.append(" select t1.FInvesteeCompanyId As FCompanyId, sum(t1.FShareScale) As FRateTotal from t_csl_sharerela t1, ");
        sbSQL.append(" (select FInvesteeCompanyId As FCompanyId, FShareHolderId, max(FChangeDate) As maxdate  \r\n");
        sbSQL.append(" from t_csl_sharerela \r\n");
        sbSQL.append(" Where FIsOut = 0 \r\n");
        sbSQL.append(" And FInvesteeCompanyId IN \r\n");
        sbSQL.append(" (Select FTargetCompanyId From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
        if (!isFillItemData) {
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
            }
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        sbSQL.append(" And FNetAsset >= 0) \r\n");
        sbSQL.append(" and FChangeDate <= TimeStamp'").append(time.toString()).append("'");
        sbSQL.append(" Group by FInvesteeCompanyId, FShareHolderId) t2 \r\n");
        sbSQL.append(" where t1.FInvesteeCompanyId = t2.FCompanyId and t1.FShareHolderId = t2.FShareHolderId");
        sbSQL.append(" and t1.FChangeDate = t2.maxdate Group by t1.FInvesteeCompanyId ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        try {
            while (rs.next()) {
                if (ret == null) {
                    ret = new HashMap<String, BigDecimal>();
                }
                ret.put(rs.getString("FCompanyId"), rs.getBigDecimal("FRateTotal"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private Map getIIAssistantRateInUnit(Context ctx, InvestCheckCondition param, boolean isFillItemData) throws BOSException {
        StringBuffer sbSQL = null;
        IRowSet rsCompany = null;
        HashMap<String, BigDecimal> ret = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" Select distinct FTargetCompanyId As FCompanyId,FIsChecked From t_csl_IIAssistant \r\n");
        sbSQL.append(" Where FOrgBoundId='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And FOrgUnitId='").append(param.getOrgBoundId()).append("' \r\n");
        if (!isFillItemData) {
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
            }
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        sbSQL.append(" And FNetAsset >= 0 \r\n");
        rsCompany = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        IRowSet rs = null;
        String longNumber = null;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            Timestamp time = new Timestamp(param.getDay().getTime());
            boolean isFilter = false;
            while (rsCompany.next()) {
                longNumber = null;
                sbSQL = new StringBuffer();
                sbSQL.append(" select FLongNumber,FLevel From t_org_structure \r\n");
                sbSQL.append(" where fid IN \r\n");
                sbSQL.append(" (select fparentid From t_org_structure where FTreeId= ? and fUnitId = ? ) \r\n");
                params.clear();
                params.add(param.getOrgTreeId());
                String companyId = rsCompany.getString("FCompanyId");
                params.add(companyId);
                rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params.toArray());
                if (rs.next()) {
                    longNumber = rs.getString("FLongNumber");
                    boolean bl = isFilter = param.getLevel() < rs.getInt("Flevel");
                }
                if (longNumber == null) continue;
                sbSQL = new StringBuffer();
                sbSQL.append(" select sum(sr.FShareScale) As FRate from t_csl_sharerela sr inner join ");
                sbSQL.append(" (select FShareHolderId, max(FChangeDate) as maxdate ");
                sbSQL.append(" from t_csl_sharerela \r\n");
                sbSQL.append(" where finvesteecompanyid= ? \r\n");
                if (isFilter) {
                    sbSQL.append(" And FShareHolderId Not IN \r\n");
                    sbSQL.append(" (Select FUnitId From t_org_Structure where FLongNumber like ? And FTreeId = ?)");
                }
                sbSQL.append(" And FShareHolderId IN \r\n");
                sbSQL.append(" (Select FCompanyId From t_csl_IIAssistant \r\n");
                sbSQL.append(" Where FOrgBoundId= ? And FOrgUnitId= ? \r\n");
                if (!isFillItemData) {
                    if (param.getCurrencyId() != null) {
                        sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                    }
                    if (param.getTargetCompanyId() != null) {
                        sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                    }
                }
                sbSQL.append(" And FPeriodType = ? And FYear = ? And FPeriod = ? And FNetAsset >= 0) \r\n");
                sbSQL.append(" And FInvesteeCompanyId IN \r\n");
                sbSQL.append(" (Select FTargetCompanyId From t_csl_IIAssistant \r\n");
                sbSQL.append(" Where FOrgBoundId= ? And FOrgUnitId= ? \r\n");
                if (!isFillItemData) {
                    if (param.getCurrencyId() != null) {
                        sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
                    }
                    if (param.getTargetCompanyId() != null) {
                        sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
                    }
                }
                sbSQL.append(" And FPeriodType = ? And FYear = ? And FPeriod = ? And FNetAsset >= 0) \r\n");
                sbSQL.append(" and FChangeDate <= TimeStamp'").append(time.toString()).append("'");
                sbSQL.append(" group by FShareHolderId) sr2 ");
                sbSQL.append(" on sr.FShareHolderId = sr2.FShareHolderId ");
                sbSQL.append(" and sr.FChangeDate = sr2.maxdate ");
                sbSQL.append(" where sr.finvesteecompanyid= ? ");
                params.clear();
                params.add(companyId);
                if (isFilter) {
                    params.add(longNumber + "%");
                    params.add(param.getOrgTreeId());
                }
                params.add(param.getOrgTreeId());
                params.add(param.getOrgBoundId());
                params.add(param.getPeriodType());
                params.add(param.getYear());
                params.add(param.getPeriod());
                params.add(param.getOrgTreeId());
                params.add(param.getOrgBoundId());
                params.add(param.getPeriodType());
                params.add(param.getYear());
                params.add(param.getPeriod());
                params.add(companyId);
                rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params.toArray());
                if (!rs.next()) continue;
                if (ret == null) {
                    ret = new HashMap<String, BigDecimal>();
                }
                ret.put(companyId, rs.getBigDecimal("FRate"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private void insertCompanyAndRate(Context ctx, InvestCheckCondition param, ItemControlHelper ic) throws BOSException, EASBizException {
        String temp_table1 = "temp_" + this.getCurTimeStr();
        this.createCompanyRelationTempTable(ctx, param, temp_table1);
        this.insertCompanyRelation(ctx, param, temp_table1);
        this.insertRelationRateIntoAssistant(ctx, param, temp_table1, ic);
    }

    private void checkIsExistsElimItemData(Context ctx, InvestCheckCondition param, String temptable) throws BOSException, EASBizException {
        IRowSet rs = null;
        IRowSet rs2 = null;
        IRowSet rs3 = null;
        boolean isExists = false;
        StringBuffer sbErr = null;
        StringBuffer companyList = new StringBuffer("");
        StringBuffer sbSQL = null;
        sbSQL = new StringBuffer();
        sbSQL.append("Select FFromCompanyId, FToCompanyId From ").append(temptable);
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            while (rs.next()) {
                if (!isExists) {
                    isExists = true;
                }
                sbSQL = new StringBuffer();
                sbSQL.append(" Select TOP 1 t1.FID \r\n");
                sbSQL.append(" From t_csl_InvestItemData t1 join t_csl_RptReceived t2 on t1.FReportId = t2.FReportId \r\n");
                sbSQL.append(" where t2.FOrgTreeId = '").append(param.getOrgTreeId()).append("'");
                sbSQL.append(" And t1.FCompanyId = '").append(rs.getString("FFromCompanyId")).append("'");
                sbSQL.append(" And t1.FPeriodType = ").append(param.getPeriodType());
                sbSQL.append(" And t1.FYear = ").append(param.getYear());
                sbSQL.append(" And t1.FPeriod = ").append(param.getPeriod());
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And t1.FCurrencyId = '").append(param.getCurrencyId()).append("'");
                }
                if ((rs2 = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString())).next()) continue;
                if (companyList.length() > 0) {
                    companyList.append(",");
                } else {
                    companyList.append("(");
                }
                companyList.append("'").append(rs.getString("FFromCompanyId")).append("'");
            }
            if (!isExists) {
                throw new InvestCheckException(InvestCheckException.NOTEXISTS_COMPANYRELATION);
            }
            if (companyList.length() > 0) {
                companyList.append(")");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (companyList.length() > 0) {
            sbSQL = new StringBuffer();
            sbSQL.append("select FName_" + ctx.getLocale() + " from t_org_baseUnit Where FIsCompanyOrgUnit = 1 And fid in ").append(companyList);
            try {
                rs3 = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
                while (rs3.next()) {
                    if (sbErr == null) {
                        sbErr = new StringBuffer("");
                    } else {
                        sbErr.append(",");
                    }
                    sbErr.append(rs3.getString("FName_" + ctx.getLocale() + ""));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sbErr != null) {
                throw new InvestCheckException(InvestCheckException.NOTEXISTS_INVESTITEMDATA, new Object[]{sbErr.toString()});
            }
        }
    }

    private String createCalculateRateTempTable(Context ctx) throws BOSException {
        String temp_table1 = "temp_" + this.getCurTimeStr();
        StringBuffer createTableSQL = null;
        createTableSQL = new StringBuffer("Create Table ");
        createTableSQL.append(temp_table1);
        createTableSQL.append("(flevel int, fcompanyID varchar(44), fstockRight NUMERIC(21,6)) \r\n");
        DbUtil.execute((Context)ctx, (String)createTableSQL.toString());
        return temp_table1;
    }

    private void createCompanyRelationTempTable(Context ctx, InvestCheckCondition param, String tempTable) throws BOSException {
        StringBuffer createTableSQL = null;
        createTableSQL = new StringBuffer("Create Table ");
        createTableSQL.append(tempTable);
        createTableSQL.append("( FFromCompanyId VARCHAR(44),  FToCompanyID VARCHAR(44) , \r\n");
        createTableSQL.append(" FToIsStockControl int, FRate NUMERIC(21,6)) \r\n");
        DbUtil.execute((Context)ctx, (String)createTableSQL.toString());
    }

    private void insertCompanyRelation(Context ctx, InvestCheckCondition param, String tempTable) throws BOSException, EASBizException {
        if (param.getMergeMode()) {
            this.insertCompanyRelationInStep(ctx, param, tempTable);
        } else {
            this.insertCompanyRelationParallel(ctx, param, tempTable);
        }
    }

    private void insertCompanyRelationParallel(Context ctx, InvestCheckCondition param, String tempTable) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        Timestamp time = new Timestamp(param.getDay().getTime());
        sbSQL = new StringBuffer(" insert into ").append(tempTable);
        sbSQL.append(" select sr.FShareHolderId As FFromCompanyId,sr.FInvesteeCompanyId As FToCompanyId, ");
        sbSQL.append(" sr2.FToIsStockControl As FToIsStockControl,sr.FShareScale As FRate from t_csl_ShareRela sr, ");
        sbSQL.append(" (select t1.FShareHolderId As FFromCompanyId, t1.FInvesteeCompanyId As FToCompanyId, \r\n");
        sbSQL.append(" Case t2.FStockControlCompanyId When '' THEN 0 ELSE 1 END As FToIsStockControl,max(t1.FChangeDate) as maxdate \r\n ");
        sbSQL.append(" From t_csl_ShareRela t1 left outer join t_org_OUPartUnionGroup t2 on t1.FInvesteeCompanyId=t2.FStockControlCompanyId \r\n");
        sbSQL.append(" Where FChangeDate <= TimeStamp'").append(time.toString()).append("'");
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FShareHolderId = '").append(param.getCompanyId()).append("' \r\n");
        } else {
            sbSQL.append(" And FShareHolderId IN \r\n");
            sbSQL.append(" (Select FUnitId From t_org_structure Where FTreeId='").append(param.getOrgTreeId()).append("') \r\n");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FInvesteeCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
        } else {
            sbSQL.append(" And FInvesteeCompanyId IN  \r\n");
            sbSQL.append(" (Select FUnitId From t_org_structure Where FTreeId='").append(param.getOrgTreeId()).append("') \r\n");
        }
        sbSQL.append(" group by t1.FShareHolderId, t1.FInvesteeCompanyId, t2.FStockControlCompanyId) sr2 ");
        sbSQL.append(" where sr.FShareHolderId = sr2.FFromCompanyId ");
        sbSQL.append(" and sr.FInvesteeCompanyId = sr2.FToCompanyId and sr.FChangeDate = sr2.maxdate ");
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    private void insertCompanyRelationInStep(Context ctx, InvestCheckCondition param, String tempTable) throws BOSException {
        StringBuffer sbSQL = null;
        IRowSet rs = null;
        try {
            sbSQL = new StringBuffer();
            sbSQL.append(" select distinct t1.FLongNumber \r\n");
            sbSQL.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
            sbSQL.append(" where t1.FTreeId = '").append(param.getOrgTreeId()).append("'");
            sbSQL.append(" And t1.FLongNumber like '").append(param.getLongNumber()).append("!%'");
            sbSQL.append(" And t1.FLevel = ").append(param.getLevel() + 1);
            sbSQL.append(" And t2.FIsCompanyOrgUnit = 0");
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append(" Insert into ").append(tempTable);
            sbSQL.append(" select sr.FShareHolderId As FFromCompanyId,sr.FInvesteeCompanyId As FToCompanyId, ");
            sbSQL.append(" sr2.FToIsStockControl As FToIsStockControl,sr.FShareScale As FRate from t_csl_ShareRela sr, ");
            sbSQL.append(" (select t1.FShareHolderId As FFromCompanyId, t1.FInvesteeCompanyId As FToCompanyId,  \r\n");
            sbSQL.append(" Case Isnull(t4.FStockControlCompanyId,'*') when '*' then 0 ELSE 1 END As FToIsStockControl, \r\n");
            sbSQL.append(" max(t1.FChangeDate) as maxdate");
            sbSQL.append(" From t_csl_ShareRela t1 INNER join t_org_structure t2 on t1.FShareHolderId=t2.FUnitId \r\n");
            sbSQL.append(" INNER join t_org_structure t3 on t1.FInvesteeCompanyId=t3.FUnitId \r\n");
            sbSQL.append(" Left join (select FID,FUnitID,FStockControlCompanyID,FVersionNumber \n");
            sbSQL.append(" From t_org_oupartuniongroup ou where  \n");
            sbSQL.append(" exists (select 'X' from t_org_structure s where s.funitid=ou.funitid and s.FTreeId = '").append(param.getOrgTreeId()).append("'))  t4 on t1.FInvesteeCompanyId=t4.FStockControlCompanyId \r\n");
            sbSQL.append(" Where t3.FTreeId = '").append(param.getOrgTreeId()).append("'");
            sbSQL.append(" And t2.FTreeId = '").append(param.getOrgTreeId()).append("'");
            sbSQL.append(" And FIsOut = 0 \r\n");
            sbSQL.append(" And t2.FLongNumber like '").append(param.getLongNumber()).append("!%' \r\n");
            sbSQL.append(" And t3.FLongNumber like '").append(param.getLongNumber()).append("!%' \r\n");
            if (param.getCompanyId() != null) {
                sbSQL.append(" And t1.FShareHolderId = '").append(param.getCompanyId()).append("' \r\n");
            } else {
                sbSQL.append(" And t1.FShareHolderId  \r\n");
                sbSQL.append(" IN (Select FUnitId From t_org_structure");
                sbSQL.append(" where FLongNumber like '").append(param.getLongNumber()).append("!%'");
                sbSQL.append(" AND FTreeId = '").append(param.getOrgTreeId()).append("')");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And t1.FInvesteeCompanyId = '").append(param.getTargetCompanyId()).append("' \r\n");
            } else {
                sbSQL.append(" And t1.FInvesteeCompanyId  \r\n");
                sbSQL.append(" IN (Select FUnitId From t_org_structure ");
                sbSQL.append(" where FLongNumber like '").append(param.getLongNumber()).append("!%'");
                sbSQL.append(" AND FTreeId = '").append(param.getOrgTreeId()).append("')");
            }
            while (rs.next()) {
                sbSQL.append(" and (Left(Replace(t2.FLongNumber,'").append(rs.getString("FLongNumber")).append("','@#$'),3)<>'@#$' \r\n");
                sbSQL.append(" or Left(Replace(t3.FLongNumber,'").append(rs.getString("FLongNumber")).append("','@#$'),3)<>'@#$') \r\n");
            }
            Timestamp time = new Timestamp(param.getDay().getTime());
            sbSQL.append(" and FChangeDate <= TimeStamp'").append(time.toString()).append("'");
            sbSQL.append(" group by t1.FShareHolderId, t1.FInvesteeCompanyId,t4.FStockControlCompanyId) sr2 ");
            sbSQL.append(" where sr.FShareHolderId = sr2.FFromCompanyId ");
            sbSQL.append(" and sr.FInvesteeCompanyId = sr2.FToCompanyId and sr.FChangeDate = sr2.maxdate ");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void insertRelationRateIntoAssistant(Context ctx, InvestCheckCondition param, String temptable, ItemControlHelper ic) throws BOSException {
        StringBuffer sbSQL = null;
        Connection conn = null;
        Statement st = null;
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        PreparedStatement ps = null;
        ResultSet rs = null;
        Set currencyList = this.getInvestItemDataCurrencyList(ctx, param, temptable);
        Iterator it = currencyList.iterator();
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            String currencyId = null;
            while (it.hasNext()) {
                currencyId = (String)it.next();
                sbSQL = new StringBuffer();
                sbSQL.append(" Select temp.* \r\n");
                sbSQL.append(" From ").append(temptable).append(" temp  \r\n");
                sbSQL.append(this.getLeftJoinSql(param, "invest", ic.getControlItem(1).toString(), 4, 3, currencyId, false));
                sbSQL.append(this.getLeftJoinSql(param, "diff", ic.getControlItem(6).toString(), 4, 3, currencyId, false));
                sbSQL.append(this.getLeftJoinSql(param, "yield1", ic.getControlItem(9).toString(), 2, 3, currencyId, false));
                sbSQL.append(this.getLeftJoinSql(param, "yield2", ic.getControlItem(9).toString(), 3, 3, currencyId, false));
                SQLUtils.cleanup(rs, ps);
                ps = conn.prepareStatement(sbSQL.toString());
                rs = ps.executeQuery();
                if (!rs.next()) continue;
                sbSQL = new StringBuffer();
                sbSQL.append(" Insert Into t_csl_IIAssistant(FId,FOrgBoundId,FOrgUnitId,");
                sbSQL.append(" FCompanyId,FTargetCompanyId,FPeriodType,FYear,FPeriod,FCurrencyId,FTargetCurrencyId, \r\n");
                sbSQL.append(" FRate,FToIsStockControl,FInvestLong,FInvestDiff,FInterest,FInterestYear,FDay,FMergeMode,FCreatorId,FCreateTime) \r\n ");
                sbSQL.append(" Select newBosId('").append(IIASSISTANT_BOSTYPE).append("'),'").append(param.getOrgTreeId()).append("' As FOrgBoundId, \r\n");
                sbSQL.append("'").append(param.getOrgBoundId()).append("' As FOrgUnitId, \r\n");
                sbSQL.append(" FFromCompanyId as FCompanyId, \r\n");
                sbSQL.append(" FToCompanyId as FTargetCompanyId, \r\n");
                sbSQL.append(param.getPeriodType()).append(" As FPeriodType,  \r\n");
                sbSQL.append(param.getYear()).append(" As FYear,  \r\n");
                sbSQL.append(param.getPeriod()).append(" As FPeriod, \r\n");
                sbSQL.append("'").append(currencyId).append("' As FCurrencyId, \r\n");
                sbSQL.append("'").append(currencyId).append("' As FTargetCurrencyId, \r\n");
                sbSQL.append(" FRate as FRate, \r\n");
                sbSQL.append(" FToIsStockControl as FToIsStockControl, \r\n");
                sbSQL.append(" IsNull(invest.FMoney,0) As FInvestLong, \r\n");
                sbSQL.append(" IsNull(diff.FMoney,0) As FInvestDiff, \r\n");
                sbSQL.append(" IsNull(yield1.FMoney,0) As FInterest, \r\n");
                sbSQL.append(" IsNull(yield2.FMoney,0) As FInterestYear, \r\n");
                sbSQL.append("TimeStamp'").append(new Timestamp(param.getDay().getTime()).toString()).append("' As FDay, \r\n");
                sbSQL.append(param.getMergeMode() ? 1 : 0).append(" As FMergeMode, \r\n");
                sbSQL.append(" '").append(ctx.getCaller()).append("' As FCreatorId, \r\n");
                sbSQL.append(" TimeStamp'").append(time.toString()).append("' As FCreateTime \r\n");
                sbSQL.append(" From ").append(temptable).append(" temp  \r\n");
                sbSQL.append(this.getLeftJoinSql(param, "invest", ic.getControlItem(1).toString(), 4, 3, currencyId, true));
                sbSQL.append(this.getLeftJoinSql(param, "diff", ic.getControlItem(6).toString(), 4, 3, currencyId, true));
                sbSQL.append(this.getLeftJoinSql(param, "yield1", ic.getControlItem(9).toString(), 2, 3, currencyId, true));
                sbSQL.append(this.getLeftJoinSql(param, "yield2", ic.getControlItem(9).toString(), 3, 3, currencyId, true));
                st.addBatch(sbSQL.toString());
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(ps);
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private String getLeftJoinSql(InvestCheckCondition param, String aliasTableName, String itemNumber, int dataElement, int commitStatus, String currencyId, boolean isSum) {
        String investAdjustDataSql = RelatingAdjustElimHelper.getInvestAdjustDataSql(param, itemNumber, dataElement);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" left outer join  \r\n");
        sbSQL.append(" (Select t2.FOrgTreeId As FOrgBoundId,t1.FCompanyId As FCompanyId, ");
        sbSQL.append("  t1.FTargetCompanyId As FTargetCompanyId,t1.FTargetCurrencyID As FCurrencyId, \r\n");
        sbSQL.append("  t1.FPeriodType As FPeriodType,t1.FYear As FYear,\t \t\t");
        sbSQL.append("  t1.FPeriod as FPeriod,t1.FItemNumber As FItemNumber, \t\r\n");
        if (isSum) {
            sbSQL.append("  sum(isnull(t1.FMoney,0)+isnull( investdata.adjustdata,0)) As FMoney, \t\r\n");
        } else {
            sbSQL.append("  isnull(t1.FMoney,0)+isnull( investdata.adjustdata,0) As FMoney, \t\r\n");
        }
        sbSQL.append("  t1.FDataElement As FDataElement,t1.FCommitStatus As FCommitStatus \r\n");
        sbSQL.append("  From t_csl_InvestItemData t1 join t_csl_RptReceived t2  \r\n");
        sbSQL.append("  \t on t1.FReportId=t2.FReportId\t\t\t\t\t\t\r\n");
        sbSQL.append(" left join ( ").append(investAdjustDataSql).append(" )  investdata on investdata.fid = t1.fid");
        if (isSum) {
            sbSQL.append(" group by t2.FOrgTreeId,t1.FCompanyId,t1.FTargetCompanyId,  \r\n");
            sbSQL.append(" t1.FTargetCurrencyId,t1.FPeriodType,t1.FYear, \t\t\t  \r\n");
            sbSQL.append(" t1.FPeriod,t1.FItemNumber,t1.FDataElement,t1.FCommitStatus \r\n");
        }
        sbSQL.append(" ) @aliasTableName@ \r\n");
        sbSQL.append(" on (@aliasTableName@.FCompanyId = temp.FFromCompanyId \r\n");
        sbSQL.append(" And @aliasTableName@.FTargetCompanyId = temp.FToCompanyId \r\n");
        sbSQL.append(" And @aliasTableName@.FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And @aliasTableName@.FCurrencyId = '").append(currencyId).append("' \r\n");
        sbSQL.append(" And @aliasTableName@.FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And @aliasTableName@.FYear = ").append(param.getYear());
        sbSQL.append(" And @aliasTableName@.FPeriod = ").append(param.getPeriod());
        sbSQL.append(" And @aliasTableName@.FDataElement = ").append(dataElement);
        sbSQL.append(" And @aliasTableName@.FCommitStatus =  ").append(commitStatus);
        sbSQL.append(" And @aliasTableName@.FItemNumber = '").append(itemNumber).append("')  \r\n");
        return sbSQL.toString().replaceAll("@aliasTableName@", aliasTableName);
    }

    private Set getInvestItemDataCurrencyList(Context ctx, InvestCheckCondition param, String temptable) throws BOSException {
        HashSet<String> currencyList = new HashSet<String>();
        StringBuffer sbSQL = null;
        IRowSet rs = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" select distinct FCurrencyId \r\n");
        sbSQL.append(" from t_csl_InvestItemData t1 join t_csl_RptReceived t2 on t1.FReportId=t2.FReportId \r\n");
        sbSQL.append(" where  t2.FOrgTreeId='").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL.append(" And t1.FCompanyId in (select distinct FFromCompanyId from ").append(temptable).append(")");
        sbSQL.append(" And t1.FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And t1.FYear = ").append(param.getYear());
        sbSQL.append(" And t1.FPeriod = ").append(param.getPeriod());
        sbSQL.append(" And t1.FCommitStatus =  ").append(3);
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            while (rs.next()) {
                currencyList.add(rs.getString("FCurrencyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return currencyList;
    }

    private void initCheckParam(Context ctx, InvestCheckCondition param) throws BOSException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer("Select FLongNumber,FLevel ");
        sbSQL.append(" from t_org_structure ");
        sbSQL.append(" Where FUnitId = '").append(param.getOrgBoundId()).append("'");
        sbSQL.append(" And FTreeId = '").append(param.getOrgTreeId()).append("'");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            while (rs.next()) {
                param.setLongNumber(rs.getString("FLongNumber"));
                param.setLevel(rs.getInt("FLevel"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkBusinessRule(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        if (this.IsExists(ctx, this.getCheckageRecordSQL(1, param))) {
            throw new InvestCheckException(InvestCheckException.EXISTS_INVESTCHECK);
        }
        if (this.IsExists(ctx, this.getCheckageRecordSQL(2, param))) {
            throw new InvestCheckException(InvestCheckException.EXISTS_INTERESTCHECK);
        }
        if (!param.getMergeMode() && !this.IsTopMergeGroup(ctx, param)) {
            throw new InvestCheckException(InvestCheckException.NOTTOPGROUP);
        }
    }

    private String checkHintBusinessRule(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        String hint = null;
        if (this.checkSubGroupChecked(ctx, param)) {
            hint = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"218_InvestCheckControllerBean", (Locale)ctx.getOriginLocale());
        }
        return hint;
    }

    private boolean IsTopMergeGroup(Context ctx, InvestCheckCondition param) throws BOSException {
        StringBuffer sbSQL = new StringBuffer("select FParentId from t_org_structure ");
        sbSQL.append(" Where FUnitId='").append(param.getOrgBoundId()).append("'");
        sbSQL.append(" AND FTreeId='").append(param.getOrgTreeId()).append("'");
        IRowSet rs = null;
        boolean bReturn = false;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                bReturn = rs.getString("FParentId") == null;
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return bReturn;
    }

    private boolean checkSubGroupChecked(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select FUnitId ");
        sbSQL.append(" from t_org_structure t1 join t_org_baseUnit t2 on t1.fUnitId = t2.fid ");
        sbSQL.append(" where t1.FLongNumber like '").append(param.getLongNumber()).append("%' ");
        sbSQL.append(" And t1.FTreeId = '").append(param.getOrgTreeId()).append("'");
        sbSQL.append(" And t2.FIsCompanyOrgUnit=0 ");
        sbSQL.append(" And t1.FLevel = ").append(param.getLevel() + 1);
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            while (rs.next()) {
                sbSQL = new StringBuffer();
                sbSQL.append(" select top 1 FId");
                sbSQL.append(" From t_csl_InvestCheckage ");
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
                sbSQL.append(" And FOrgUnitId ='").append(rs.getString("FUnitId")).append("'");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
                sbSQL.append(" And FPeriod = ").append(param.getPeriod());
                sbSQL.append(" And FYear = ").append(param.getYear());
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyID = '").append(param.getCurrencyId()).append("'");
                }
                if (!this.IsExists(ctx, sbSQL.toString())) {
                    return true;
                }
                sbSQL = new StringBuffer();
                sbSQL.append(" select top 1 FId");
                sbSQL.append(" From t_csl_InterestCheckage ");
                sbSQL.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
                sbSQL.append(" And FOrgUnitId ='").append(rs.getString("FUnitId")).append("'");
                sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
                sbSQL.append(" And FPeriod = ").append(param.getPeriod());
                sbSQL.append(" And FYear = ").append(param.getYear());
                if (param.getCurrencyId() != null) {
                    sbSQL.append(" And FCurrencyID = '").append(param.getCurrencyId()).append("'");
                }
                if (this.IsExists(ctx, sbSQL.toString())) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    private void clearOldData(Context ctx, InvestCheckCondition param) throws BOSException {
        DbUtil.execute((Context)ctx, (String)this.getClearDataSQL(1, param));
        DbUtil.execute((Context)ctx, (String)this.getClearDataSQL(2, param));
        DbUtil.execute((Context)ctx, (String)this.getClearDataSQL(3, param));
    }

    private String getClearDataSQL(int clearType, InvestCheckCondition param) {
        String tableName = null;
        StringBuffer sbSQL = new StringBuffer();
        switch (clearType) {
            case 1: {
                tableName = "t_Csl_InvestCheckage";
                break;
            }
            case 2: {
                tableName = "t_Csl_InterestCheckage";
                break;
            }
            case 3: {
                tableName = "t_Csl_IIAssistant";
                break;
            }
            case 4: {
                tableName = "t_Csl_IIAssistantItemData";
            }
        }
        return sbSQL.append("Delete From ").append(tableName).append(" WHERE ").append(this.getCommonWhereSQL(clearType, param)).toString();
    }

    private String getCheckageRecordSQL(int elimType, InvestCheckCondition param) {
        StringBuffer sbSQL = new StringBuffer(" SELECT TOP 1 FID ");
        sbSQL.append(" FROM ").append(elimType == 1 ? "t_csl_InvestCheckage" : "t_csl_InterestCheckage");
        sbSQL.append(" Where FCheckedStatus = ").append(2);
        sbSQL.append(" And ").append(this.getCommonWhereSQL(param));
        return sbSQL.toString();
    }

    private String getCommonWhereSQL(int clearType, InvestCheckCondition param) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("'");
        if (clearType != 4) {
            if (param.getCompanyId() != null) {
                sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("'");
            }
            if (param.getTargetCompanyId() != null) {
                sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("'");
            }
            if (param.getCurrencyId() != null) {
                sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("'");
            }
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        return sbSQL.toString();
    }

    private String getCommonWhereSQL(InvestCheckCondition param) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" FOrgBoundId = '").append(param.getOrgTreeId()).append("'");
        sbSQL.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("'");
        if (param.getCompanyId() != null) {
            sbSQL.append(" And FCompanyId = '").append(param.getCompanyId()).append("'");
        }
        if (param.getTargetCompanyId() != null) {
            sbSQL.append(" And FTargetCompanyId = '").append(param.getTargetCompanyId()).append("'");
        }
        if (param.getCurrencyId() != null) {
            sbSQL.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("'");
        }
        sbSQL.append(" And FPeriodType = ").append(param.getPeriodType());
        sbSQL.append(" And FYear = ").append(param.getYear());
        sbSQL.append(" And FPeriod = ").append(param.getPeriod());
        return sbSQL.toString();
    }

    private boolean IsExists(Context ctx, String strSQL) throws BOSException {
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)strSQL);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return false;
    }

    private String getCurTimeStr() {
        Timestamp curTime = new Timestamp(System.currentTimeMillis());
        String strTime = curTime.toString();
        StringBuffer sbTableName = new StringBuffer();
        sbTableName.append(strTime.substring(0, 4)).append(strTime.substring(5, 7)).append(strTime.substring(8, 10)).append(strTime.substring(11, 13)).append(strTime.substring(14, 16)).append(strTime.substring(17, 19)).append(strTime.substring(20));
        return sbTableName.toString();
    }

    private void doAudit(Context ctx, List idCollection, int checkedType, int elimType) throws BOSException, EASBizException {
        String strIDs = this.getCheckageIDCollection(idCollection);
        this.checkRule(ctx, strIDs, checkedType, elimType);
        this.updateAuditFlag(ctx, strIDs, checkedType, elimType);
    }

    private String getCheckageIDCollection(List idCollection) throws EASBizException {
        StringBuffer sb = new StringBuffer();
        if (idCollection.size() < 1) {
            throw new InterCheckException(InterCheckException.HAVE_NO_AUDIT);
        }
        Iterator it = idCollection.iterator();
        sb.append("(");
        boolean bfirst = true;
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null) continue;
            if (!bfirst) {
                sb.append(",");
            } else {
                bfirst = false;
            }
            sb.append("'").append(obj.toString()).append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    private void checkRule(Context ctx, String ids, int status, int elimType) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sbSQL = new StringBuffer("Select TOP 1 FID From ");
        sbSQL.append(elimType == 1 ? "t_csl_InvestCheckage" : "t_csl_InterestCheckage").append(" \r\n");
        sbSQL.append(" Where FID IN ").append(ids).append(" \r\n");
        sbSQL.append(" and FCheckedStatus=").append(status).append(" \r\n");
        StringBuffer sbSQL3 = new StringBuffer("Select top 1 FID From ");
        sbSQL3.append(elimType == 1 ? "t_csl_InvestCheckage" : "t_csl_InterestCheckage").append(" \r\n");
        sbSQL3.append(" Where FID in ").append(ids).append(" \r\n");
        sbSQL3.append(" And FCheckedStatus = ").append(1).append(" \r\n");
        sbSQL3.append(" And FAuditorID <> '").append(ctx.getCaller()).append("' \r\n");
        StringBuffer sbSQL4 = new StringBuffer("Select TOP 1 FID From T_CSL_ElimRecord \r\n");
        sbSQL4.append(" Where FCheckageDataID in ").append(ids).append(" \r\n");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next()) {
                if (status == 2) {
                    throw new InterCheckException(InterCheckException.NOT_REPEAT_AUDIT);
                }
                throw new InterCheckException(InterCheckException.NOT_REPEAT_UNAUDIT);
            }
            if (status == 1) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL3.toString());
                if (rs.next() && CslRptUtil.canUnAuditCheck(ctx)) {
                    throw new InterCheckException(InterCheckException.UNAUDIT_NOT_AUDIT);
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL4.toString());
                if (rs.next()) {
                    throw new InterCheckException(InterCheckException.EXISTS_ELIMINATION);
                }
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
    }

    private void updateAuditFlag(Context ctx, String ids, int status, int elimType) throws BOSException {
        Date d = new Date();
        Timestamp time = new Timestamp(d.getTime());
        StringBuffer sbSQL = new StringBuffer("Update ");
        sbSQL.append(elimType == 1 ? "t_csl_InvestCheckage" : "t_csl_InterestCheckage").append(" \r\n");
        sbSQL.append(" set FCheckedStatus = ").append(status).append(", \r\n");
        if (status == 2) {
            sbSQL.append("FAuditorID = '").append(ctx.getCaller()).append("', \r\n");
            sbSQL.append("FAuditDate = TimeStamp'").append(time.toString()).append("' \r\n");
        } else {
            sbSQL.append("FAuditorID = null, \r\n");
            sbSQL.append("FAuditDate = null \r\n");
        }
        sbSQL.append(" Where FID in ").append(ids);
        DbUtil.execute((Context)ctx, (String)sbSQL.toString());
    }

    @Override
    protected Map _getItemControlInRpt(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isNew = false;
        if (params != null && params.size() > 0) {
            isNew = params.containsKey("isNew") ? (Boolean)params.get("isNew") : false;
        }
        ItemControlHelper ic = new ItemControlHelper(new ControlAttrHelper(ctx, 1), isNew);
        Map rptItemMap = ic.getControlItemCollection();
        TreeMap<Integer, String> returnMap = new TreeMap<Integer, String>();
        String tempStr = null;
        if (rptItemMap.get(new Integer(1)) != null) {
            tempStr = (String)rptItemMap.get(new Integer(1));
            returnMap.put(new Integer(1), tempStr);
        }
        if (rptItemMap.get(new Integer(6)) != null) {
            tempStr = (String)rptItemMap.get(new Integer(6));
            returnMap.put(new Integer(6), tempStr);
        }
        if (rptItemMap.get(new Integer(9)) != null) {
            tempStr = (String)rptItemMap.get(new Integer(9));
            returnMap.put(new Integer(9), tempStr);
        }
        return returnMap;
    }

    @Override
    protected void _batchAudit(Context ctx, List idList, int elimType) throws BOSException, EASBizException {
        this.doAudit(ctx, idList, 2, elimType);
    }

    @Override
    protected void _batchUnAudit(Context ctx, List idList, int elimType) throws BOSException, EASBizException {
        this.doAudit(ctx, idList, 1, elimType);
    }

    @Override
    protected void _fillInvestItemData(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        ItemControlHelper ic = new ItemControlHelper(new ControlAttrHelper(ctx, 0, param.getMergeMode()), false);
        this.fillInvestItemData(ctx, param, ic);
    }

    @Override
    protected void _fillInterestItemData(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        ItemControlHelper ic = new ItemControlHelper(new ControlAttrHelper(ctx, 0, param.getMergeMode()), false);
        this.fillInterestItemData(ctx, param, ic);
    }

    @Override
    protected void _fillMoreItemData(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        ItemControlHelper ic = new ItemControlHelper(new ControlAttrHelper(ctx, 0, param.getMergeMode()), false);
        this.fillMoreItemData(ctx, param, ic);
    }

    @Override
    protected String _isExistsCheckage(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
        String hint = null;
        this.initCheckParam(ctx, param);
        this.checkBusinessRule(ctx, param);
        hint = this.checkHintBusinessRule(ctx, param);
        if (hint != null) {
            return hint;
        }
        if (this.isExistsCheckedRecord(ctx, param)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InvestCheck_IsContinueCheck", (Locale)ctx.getOriginLocale());
        }
        return null;
    }

    private boolean isExistsCheckedRecord(Context ctx, InvestCheckCondition param) throws BOSException {
        boolean isExists = false;
        StringBuffer sbSQL1 = new StringBuffer();
        sbSQL1.append(" Select Top 1 FId From t_csl_InvestCheckage \r\n");
        sbSQL1.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL1.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL1.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL1.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL1.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        if (param.getCurrencyId() != null) {
            sbSQL1.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        StringBuffer sbSQL2 = new StringBuffer();
        sbSQL2.append(" Select Top 1 FId From t_csl_InterestCheckage \r\n");
        sbSQL2.append(" Where FOrgBoundId = '").append(param.getOrgTreeId()).append("' \r\n");
        sbSQL2.append(" And FOrgUnitId = '").append(param.getOrgBoundId()).append("' \r\n");
        sbSQL2.append(" And FPeriodType = ").append(param.getPeriodType()).append(" \r\n");
        sbSQL2.append(" And FYear = ").append(param.getYear()).append(" \r\n");
        sbSQL2.append(" And FPeriod = ").append(param.getPeriod()).append(" \r\n");
        if (param.getCurrencyId() != null) {
            sbSQL2.append(" And FCurrencyId = '").append(param.getCurrencyId()).append("' \r\n");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL1.toString());
            if (rs.next()) {
                isExists = true;
            }
            if (!isExists && (rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL2.toString())).next()) {
                isExists = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isExists;
    }

    @Override
    protected void _fillInvestNetAssetBig(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInvestNetAssetSmall(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInvestMinparter(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInterestNetAssetBig(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInterestNetAssetSmall(Context ctx, InvestCheckCondition param) throws BOSException {
    }

    @Override
    protected void _fillInterestMinpartner(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInvestParallelBig(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInvestParallelSmall(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    @Override
    protected void _fillInvestDistill(Context ctx, InvestCheckCondition param) throws BOSException, EASBizException {
    }

    class ControlAttrHelper {
        private Context _ctx = null;
        private boolean _mergeMode = false;
        private int _returnType = 0;
        private IRowSet _rsControl = null;
        private IRowSet _rsTemplet = null;
        private HashSet h1 = null;
        private HashSet h3 = null;
        private Hashtable _spread = null;
        private HashMap m = new HashMap();

        public ControlAttrHelper(Context ctx, int returnType) throws BOSException {
            this._ctx = ctx;
            this._returnType = returnType;
            this.initItemControl();
            this.doInitHashSet();
        }

        public ControlAttrHelper(Context ctx, int returnType, boolean mergeMode) throws BOSException {
            this._ctx = ctx;
            this._returnType = returnType;
            this._mergeMode = mergeMode;
            this.initItemControl();
            this.doInitHashSet();
            this.initControlFieldMapping();
        }

        public Context getCtx() {
            return this._ctx;
        }

        public int getReturnType() {
            return this._returnType;
        }

        private void initControlFieldMapping() {
            if (this._returnType == 1) {
                return;
            }
            this.m.put(RPTItemControlEnum.MINPARTNER_INVEST.toString() + 4, "FInvestMinorityRight");
            this.m.put(RPTItemControlEnum.FUNDED_INVEST.toString() + 4, "FInvestLong");
            this.m.put(RPTItemControlEnum.DIFF_MERGEPRICE.toString() + 4, "FInvestMergeDiff");
            this.m.put(RPTItemControlEnum.MINPARTNER_PROFIT.toString() + 2, "FInterestMinorityRight");
            this.m.put(RPTItemControlEnum.INVEST_INCOME.toString() + 2, "FInterest");
            this.m.put(RPTItemControlEnum.MINPARTNER_PROFIT.toString() + 3, "FInterestMinorityRightYear");
            this.m.put(RPTItemControlEnum.INVEST_INCOME.toString() + 3, "FInterestYear");
            this.m.put(RPTItemControlEnum.UNINVESTLOSS_FOROWES.toString() + 4, "FNetAsset");
            this.m.put(RPTItemControlEnum.UNINVESTLOSS_FORGAIN.toString() + 2, "FNetProfit");
            this.m.put(RPTItemControlEnum.UNINVESTLOSS_FORGAIN.toString() + 3, "FNetProfitYear");
        }

        private void initItemControl() throws BOSException {
            String strSQL = "Select FId,FIsSingle,FIsSum,FControl,FType From t_csl_RptControl";
            this._rsControl = DbUtil.executeQuery((Context)this._ctx, (String)strSQL);
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append(" select t1.FTempletType,t2.* \r\n");
            sbSQL.append(" From t_csl_investtemplet t1 join t_csl_investtempletentry t2 on t1.fid = t2.ftempletid \r\n");
            sbSQL.append(" Where FElimType = ").append(4);
            this._rsTemplet = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
        }

        public boolean isBaseControl(int control) {
            return control == 1 || control == 6 || control == 9;
        }

        public boolean isSingleControl(int control) {
            return !this.isSumControl(control);
        }

        public boolean isSumControl(int control) {
            return this._spread.containsKey(new Integer(control));
        }

        public boolean isMinpartnerShareholderControl(int control) {
            return control == 3 || control == 13;
        }

        private int getControlRateFlag(int control) {
            return this.isMinpartnerShareholderControl(control) ? 2 : 0;
        }

        private String getControlFieldName(int control, int dataElement) {
            return (String)this.m.get(RPTItemControlEnum.getEnum(control).toString() + dataElement);
        }

        private void doInitHashSet() throws BOSException {
            try {
                this._spread = new Hashtable();
                this._rsControl.beforeFirst();
                while (this._rsControl.next()) {
                    if (this._rsControl.getBoolean("FIsSingle") && !this._rsControl.getBoolean("FIsSum")) {
                        if (this.h1 == null) {
                            this.h1 = new HashSet();
                        }
                        if (this.isBaseControl(this._rsControl.getInt("FControl"))) {
                            this.h1.add(new Integer(this._rsControl.getInt("FControl")));
                            continue;
                        }
                        if (this._returnType != 0) continue;
                        this.h1.add(new Integer(this._rsControl.getInt("FControl")));
                        continue;
                    }
                    if (!this._rsControl.getBoolean("FIsSum") || this._returnType != 0) continue;
                    if (this.h3 == null) {
                        this.h3 = new HashSet();
                    }
                    this.h3.add(new Integer(this._rsControl.getInt("FControl")));
                    this._spread.put(new Integer(this._rsControl.getInt("FControl")), "");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }

        public String getItemControlUnionSQL(int type) throws BOSException {
            Iterator it = null;
            switch (type) {
                case 1: {
                    it = this.h1.iterator();
                    break;
                }
                case 3: {
                    it = this.h3.iterator();
                }
            }
            if (it != null) {
                StringBuffer sbSQL = new StringBuffer("(");
                while (it.hasNext()) {
                    if (sbSQL.length() != 1) {
                        sbSQL.append(",");
                    }
                    sbSQL.append(it.next());
                }
                sbSQL.append(")");
                return sbSQL.toString();
            }
            throw new BOSException("Iterator it is null");
        }

        public AssInsert getControlTempletInfo(int templetType, int control, int dataElement, boolean isCurrentLevel) throws BOSException {
            AssInsert ass = null;
            try {
                this._rsTemplet.beforeFirst();
                while (this._rsTemplet.next()) {
                    if (this._rsTemplet.getInt("FTempletType") != templetType || this._rsTemplet.getInt("FControlAttr") != control || this._rsTemplet.getInt("FDataElement") != dataElement) continue;
                    ass = new AssInsert();
                    ass.setControl(this._rsTemplet.getInt("FControlAttr"));
                    ass.setDataElement(dataElement);
                    ass.setIsSpread(this._rsTemplet.getBoolean("FIsSumItemExtend"));
                    ass.setIsShareHolder(this._rsTemplet.getInt("FCompanyType") == 1);
                    ass.setNetAsset(this._rsTemplet.getInt("FIsNetAsset"));
                    ass.setFieldName(this.getControlFieldName(this._rsTemplet.getInt("FControlAttr"), dataElement));
                    ass.setIsByRate(!this._mergeMode);
                    ass.setRateFlag(this.getControlRateFlag(control));
                    ass.setIsCurrentLevel(isCurrentLevel);
                    ass.setDC(this._rsTemplet.getInt("FDCType"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return ass;
        }

        public AssInsert getControlTempletInfo(int templetType, int control, int dataElement, boolean isCurrentLevel, int flag) throws BOSException {
            AssInsert ass = null;
            try {
                this._rsTemplet.beforeFirst();
                while (this._rsTemplet.next()) {
                    if (this._rsTemplet.getInt("FTempletType") != templetType || this._rsTemplet.getInt("FControlAttr") != control || this._rsTemplet.getInt("FDataElement") != dataElement) continue;
                    ass = new AssInsert();
                    ass.setControl(this._rsTemplet.getInt("FControlAttr"));
                    ass.setDataElement(dataElement);
                    ass.setIsSpread(this._rsTemplet.getBoolean("FIsSumItemExtend"));
                    ass.setIsShareHolder(this._rsTemplet.getInt("FCompanyType") == 1);
                    ass.setNetAsset(this._rsTemplet.getInt("FIsNetAsset"));
                    ass.setFieldName(this.getControlFieldName(this._rsTemplet.getInt("FControlAttr"), dataElement));
                    ass.setIsByRate(!this._mergeMode);
                    ass.setRateFlag(this.getControlRateFlag(control));
                    ass.setIsCurrentLevel(isCurrentLevel);
                    ass.setDC(this._rsTemplet.getInt("FDCType"));
                    ass.setFlag(flag);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return ass;
        }

        public AssInsert[] getControlTempletInfos(int templetType, int controlType, int dataElement, boolean isCurrentLevel) throws BOSException {
            HashSet<Integer> entry = null;
            AssInsert[] asses = null;
            try {
                this._rsControl.beforeFirst();
                while (this._rsControl.next()) {
                    if (this._rsControl.getInt("FType") != controlType) continue;
                    if (entry == null) {
                        entry = new HashSet<Integer>();
                    }
                    entry.add(new Integer(this._rsControl.getInt("FControl")));
                }
                this._rsTemplet.beforeFirst();
                while (this._rsTemplet.next()) {
                    if (this._rsTemplet.getInt("FType") != controlType || this._rsTemplet.getInt("FDataElement") != dataElement) continue;
                    if (entry == null) {
                        return null;
                    }
                    if (asses == null) {
                        asses = new AssInsert[entry.size()];
                    }
                    Iterator it = entry.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        asses[i] = new AssInsert();
                        asses[i].setControl((Integer)obj);
                        asses[i].setDataElement(dataElement);
                        asses[i].setIsSpread(this._spread.containsKey(obj));
                        asses[i].setIsShareHolder(this._rsTemplet.getInt("FCompanyType") == 1);
                        asses[i].setNetAsset(this._rsTemplet.getInt("FIsNetAsset"));
                        asses[i].setFieldName(this.getControlFieldName((Integer)obj, dataElement));
                        asses[i].setIsByRate(!this._mergeMode);
                        asses[i].setRateFlag(this.getControlRateFlag((Integer)obj));
                        asses[i].setIsCurrentLevel(isCurrentLevel);
                        asses[i].setDC(this._rsTemplet.getInt("FdcType"));
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return asses;
        }

        public AssInsert[] getControlTempletInfos(int templetType, int controlType, int dataElement, boolean isCurrentLevel, int flag) throws BOSException {
            HashSet<Integer> entry = null;
            AssInsert[] asses = null;
            try {
                this._rsControl.beforeFirst();
                while (this._rsControl.next()) {
                    if (this._rsControl.getInt("FType") != controlType) continue;
                    if (entry == null) {
                        entry = new HashSet<Integer>();
                    }
                    entry.add(new Integer(this._rsControl.getInt("FControl")));
                }
                this._rsTemplet.beforeFirst();
                while (this._rsTemplet.next()) {
                    if (this._rsTemplet.getInt("FType") != controlType || this._rsTemplet.getInt("FDataElement") != dataElement) continue;
                    if (entry == null) {
                        return null;
                    }
                    if (asses == null) {
                        asses = new AssInsert[entry.size()];
                    }
                    Iterator it = entry.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        asses[i] = new AssInsert();
                        asses[i].setControl((Integer)obj);
                        asses[i].setDataElement(dataElement);
                        asses[i].setIsSpread(this._spread.containsKey(obj));
                        asses[i].setIsShareHolder(this._rsTemplet.getInt("FCompanyType") == 1);
                        asses[i].setNetAsset(this._rsTemplet.getInt("FIsNetAsset"));
                        asses[i].setFieldName(this.getControlFieldName((Integer)obj, dataElement));
                        asses[i].setIsByRate(!this._mergeMode);
                        asses[i].setRateFlag(this.getControlRateFlag((Integer)obj));
                        asses[i].setIsCurrentLevel(isCurrentLevel);
                        asses[i].setDC(this._rsTemplet.getInt("FdcType"));
                        asses[i].setFlag(flag);
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return asses;
        }
    }

    class ItemControlHelper {
        private Map _itemControl = null;
        private Context _ctx = null;
        private int _returnType = 0;
        ControlAttrHelper _helper = null;

        public ItemControlHelper(ControlAttrHelper helper, boolean isNew) throws BOSException, EASBizException {
            this._ctx = helper.getCtx();
            this._returnType = helper.getReturnType();
            this._helper = helper;
            this.setItemControlDictionry();
            if (!isNew) {
                this.checkItemControlRule();
            }
        }

        public ControlAttrHelper getHelper() {
            return this._helper;
        }

        public Map getControlItemCollection() {
            return this._itemControl;
        }

        public Object getControlItem(int control) {
            return this._itemControl.get(new Integer(control));
        }

        public Map getUnionControlItemMap(AssInsert[] objs) throws BOSException, EASBizException {
            ArrayList items = null;
            if (objs == null) {
                return null;
            }
            if (objs.length <= 0) {
                return null;
            }
            items = new ArrayList();
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                Object obj;
                if (objs[i].getControl() == 20 || objs[i].getControl() == 12 || objs[i].getControl() == 21) {
                    obj = this.getControlItem(objs[i].getControl());
                    if (obj == null) continue;
                    this.collectItemNumbers(items, obj);
                    continue;
                }
                if (this.getControlItem(objs[i].getControl()) == null || (obj = this.getControlItem(objs[i].getControl())) == null) continue;
                this.collectItemNumbers(items, obj);
            }
            Map itemLists = null;
            if (items != null && !items.isEmpty()) {
                IItemFieldMapped itemMap = ItemFieldMappedFactory.getLocalInstance(this._ctx);
                itemLists = itemMap.getHiberMapInfoByItemNumbers(items);
            }
            return itemLists;
        }

        private void collectItemNumbers(List items, Object obj) {
            if (obj instanceof List) {
                List l = (List)obj;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    items.add(it.next());
                }
            } else if (obj instanceof Map) {
                Set key = ((Map)obj).keySet();
                for (Object o : key) {
                    if (((Map)obj).get(o) == null) {
                        items.add(o);
                        continue;
                    }
                    if (!(((Map)obj).get(o) instanceof Map)) continue;
                    this.setItemMapList(items, (Map)((Map)obj).get(o));
                }
            } else if (obj instanceof String) {
                items.add(obj);
            }
        }

        private void setItemMapList(List items, Map temp) {
            Set keys = temp.keySet();
            for (Object obj : keys) {
                if (!(obj instanceof String)) continue;
                if (((String)obj).startsWith(InvestCheckControllerBean.ITEMS_KEY)) {
                    this.setItemMapList(items, (Map)temp.get(obj));
                    continue;
                }
                if (temp.get(obj) != null) continue;
                items.add(obj);
            }
        }

        public String getControlItemSQL(int control) {
            Object obj = this.getControlItem(control);
            StringBuffer itemSQL = new StringBuffer();
            String itemString = null;
            if (obj instanceof String) {
                itemSQL.append("'").append(obj.toString()).append("'");
            } else if (obj instanceof List) {
                Iterator it = ((List)obj).iterator();
                while (it.hasNext()) {
                    if (itemSQL.length() != 0) {
                        itemSQL.append(",");
                    }
                    itemSQL.append("'").append(it.next()).append("'");
                }
            }
            itemString = itemSQL.toString();
            return itemString;
        }

        private void checkItemControlRule() throws EASBizException {
            if (this.getControlItem(1) == null) {
                throw new InvestCheckException(InvestCheckException.NOTEXISTS_LONGINVEST);
            }
            if (this.getControlItem(6) == null) {
                throw new InvestCheckException(InvestCheckException.NOTEXISTS_INVESTDIFF);
            }
            if (this.getControlItem(9) == null) {
                throw new InvestCheckException(InvestCheckException.NOTEXISTS_INVESTINCOME);
            }
        }

        private void setItemControlDictionry() throws BOSException, EASBizException {
            this._itemControl = new HashMap();
            IRowSet rs = null;
            StringBuffer sbSQL = new StringBuffer(" SELECT ");
            sbSQL.append(" FControl, ").append("FName_" + this._ctx.getLocale()).append(",FNumber");
            sbSQL.append(" FROM t_csl_RptItem ");
            sbSQL.append(" WHERE FControl in ");
            sbSQL.append(this._helper.getItemControlUnionSQL(1));
            sbSQL.append(" and FItemGroup = ").append(2);
            sbSQL.append(" and FIsFreezed = 0 ");
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
                while (rs.next()) {
                    if (this._returnType == 1) {
                        this._itemControl.put(new Integer(rs.getInt("FControl")), rs.getString("FName_" + this._ctx.getLocale() + "") + "@@@" + rs.getString("FNumber"));
                        continue;
                    }
                    this._itemControl.put(new Integer(rs.getInt("FControl")), rs.getString("FNumber"));
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
            if (this._returnType == 1) {
                return;
            }
            sbSQL = new StringBuffer(" SELECT ");
            sbSQL.append(" FControl,FIsSumItem,FSumItemFormula,FId,FNumber");
            sbSQL.append(" FROM t_csl_RptItem ");
            sbSQL.append(" WHERE FControl in ");
            sbSQL.append(this._helper.getItemControlUnionSQL(3));
            sbSQL.append(" and FIsFreezed = 0 ");
            sbSQL.append(" order by FControl ");
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)sbSQL.toString());
                HashMap m = null;
                HashMap<String, String> m1 = null;
                int controlAttr = 0;
                int oldControl = 0;
                while (rs.next()) {
                    controlAttr = rs.getInt("FControl");
                    if (oldControl != rs.getInt("FControl")) {
                        if (m != null) {
                            this._itemControl.put(new Integer(oldControl), m);
                        }
                        m = new HashMap();
                    }
                    if (m != null) {
                        if (rs.getBoolean("FIsSumItem")) {
                            m1 = new HashMap<String, String>();
                            m1.put(InvestCheckControllerBean.FORMULA_KEY + rs.getString("FNumber"), rs.getString("FSumItemFormula"));
                            this.SetSumItemControlCircle(this._ctx, rs.getString("FId"), rs.getString("FNumber"), m1);
                            m.put(rs.getString("FNumber"), m1);
                        } else {
                            m.put(rs.getString("FNumber"), null);
                        }
                    }
                    oldControl = rs.getInt("FControl");
                }
                if (m != null) {
                    this._itemControl.put(new Integer(controlAttr), m);
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
        }

        private void SetSumItemControlCircle(Context ctx, String id, String number, Map retItems) throws BOSException {
            HashMap<String, String> retMap = new HashMap<String, String>();
            IRowSet rs = null;
            StringBuffer sbSQL = new StringBuffer(" SELECT t1.fid,t1.fnumber,t1.fisSumItem,t1.FSumItemFormula ");
            sbSQL.append(" FROM t_csl_Rptitem t1 join t_csl_rptitemmapping t2 on t1.fid=t2.fsourceitem ");
            sbSQL.append(" where t2.ftargetitem IN ");
            StringBuffer sbWhere = new StringBuffer();
            sbWhere.append("('" + id + "')");
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)(sbSQL.toString() + sbWhere.toString()));
                while (rs.next()) {
                    if (!rs.getBoolean("FIsSumItem")) {
                        retMap.put(rs.getString("FNumber"), null);
                        continue;
                    }
                    retMap.put(InvestCheckControllerBean.FORMULA_KEY + rs.getString("FNumber"), rs.getString("FSumItemFormula"));
                    this.SetSumItemControlCircle(ctx, rs.getString("fid"), rs.getString("FNumber"), retMap);
                }
            }
            catch (SQLException exc) {
                throw new SQLDataException(exc);
            }
            retItems.put(InvestCheckControllerBean.ITEMS_KEY + number, retMap);
        }

        public String getControlItemNumber(int control) throws BOSException {
            String number = null;
            String strSQL = "Select FNumber From t_csl_RptItem Where FControl = " + control;
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)this._ctx, (String)strSQL);
                if (rs.next()) {
                    number = rs.getString("FNumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            return number;
        }
    }

    class AssInsert {
        private boolean _isSpread = false;
        private int _control = 0;
        private int _dataElement = 0;
        private String _fieldName = null;
        private boolean _isCurrentLevel = false;
        private boolean _isGroup = false;
        private String _strGroupSQL = null;
        private int _netAsset = 0;
        private boolean _isByRate = false;
        private int _rateFlag = 0;
        private boolean _isShareHolder = false;
        private int _dc = 10;
        private int _flag = 0;

        public AssInsert() {
        }

        public AssInsert(boolean isFromReport, int control, boolean isSpread, int dataElement, boolean isShareHolder) {
            this._isSpread = isSpread;
            this._control = control;
            this._dataElement = dataElement;
            this._isShareHolder = isShareHolder;
        }

        public AssInsert(boolean isFromReport, int control, boolean isSpread, int dataElement, boolean isShareHolder, String fieldName, boolean isCurrentLevel, int netAsset) {
            this(isFromReport, control, isSpread, dataElement, isShareHolder);
            this._fieldName = fieldName;
            this._isCurrentLevel = isCurrentLevel;
            this._netAsset = netAsset;
        }

        public AssInsert(boolean isFromReport, int control, boolean isSpread, int dataElement, boolean isShareHolder, String fieldName, boolean isCurrentLevel, int netAsset, boolean isByRate, int rateFlag) {
            this(isFromReport, control, isSpread, dataElement, isShareHolder, fieldName, isCurrentLevel, netAsset);
            this._isByRate = isByRate;
            this._rateFlag = rateFlag;
        }

        public AssInsert(boolean isFromReport, int control, boolean isSpread, int dataElement, boolean isShareHolder, String fieldName, boolean isCurrentLevel, int netAsset, boolean isGroup, String strGroupSQL) {
            this(isFromReport, control, isSpread, dataElement, isShareHolder, fieldName, isCurrentLevel, netAsset);
            this._isGroup = isGroup;
            this._strGroupSQL = strGroupSQL;
        }

        public int getDC() {
            return this._dc;
        }

        public boolean getIsSpread() {
            return this._isSpread;
        }

        public int getControl() {
            return this._control;
        }

        public int getDataElement() {
            return this._dataElement;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public boolean getIsCurrentLevel() {
            return this._isCurrentLevel;
        }

        public boolean getIsGroup() {
            return this._isGroup;
        }

        public String getStrGroupSQL() {
            return this._strGroupSQL;
        }

        public int getNetAsset() {
            return this._netAsset;
        }

        public boolean getIsByRate() {
            return this._isByRate;
        }

        public int getRateFlag() {
            return this._rateFlag;
        }

        public boolean getIsShareHolder() {
            return this._isShareHolder;
        }

        public int getFlag() {
            return this._flag;
        }

        public void setDC(int value) {
            this._dc = value;
        }

        public void setIsSpread(boolean value) {
            this._isSpread = value;
        }

        public void setControl(int value) {
            this._control = value;
        }

        public void setDataElement(int value) {
            this._dataElement = value;
        }

        public void setFieldName(String value) {
            this._fieldName = value;
        }

        public void setIsCurrentLevel(boolean value) {
            this._isCurrentLevel = value;
        }

        public void setIsGroup(boolean value) {
            this._isGroup = value;
        }

        public void setStrGroupSQL(String value) {
            this._strGroupSQL = value;
        }

        public void setNetAsset(int value) {
            this._netAsset = value;
        }

        public void setIsByRate(boolean value) {
            this._isByRate = value;
        }

        public void setRateFlag(int value) {
            this._rateFlag = value;
        }

        public void setIsShareHolder(boolean value) {
            this._isShareHolder = value;
        }

        public void setFlag(int value) {
            this._flag = value;
        }
    }
}

