/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInvestItemDataControllerBean;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InvestItemDataControllerBean
extends AbstractInvestItemDataControllerBean {
    private static final int HASCHECKED = 1;
    private static final int BASEDATA = 2;
    private static final int CANDELETE = 0;
    private static final int NOTCURGROUP = 3;

    @Override
    protected Map _getImportData(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        int mergeMode = (Integer)params.get("MERGETYPE");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        boolean isUnReceive = false;
        if (params.get("isUnReceive") != null && params.get("isUnReceive") instanceof Boolean) {
            isUnReceive = (Boolean)params.get("isUnReceive");
        }
        List reportIds = CslRptUtil.getAllGroupNormalReports(ctx, orgTree, orgUnit, currencyId, mergeMode, year, period, periodType, fastMergeSoluId, isUnReceive);
        StringBuffer sql = new StringBuffer();
        sql.append("select to_char(b.FItemId) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement,");
        sql.append(" b.FValueType, b.FYear, b.FPeriod, b.FValue, b.FDynaItemType");
        sql.append(" from t_csl_dynaItemData a");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" where a.FReportId = ?");
        sql.append(" and b.FDynaItemType in (1, 2, 3)");
        sql.append(" and ((b.FDataElement = ").append(4);
        sql.append(" and i.FControl = ").append(1);
        sql.append(") or (b.FDataElement = ").append(4);
        sql.append(" and i.FControl = ").append(6);
        sql.append(") or (b.FDataElement = ").append(2);
        sql.append(" and i.FControl = ").append(9);
        sql.append(") or (b.FDataElement = ").append(3);
        sql.append(" and i.FControl = ").append(9);
        sql.append(")) and i.FId not in (select distinct FDynaItemId from t_csl_dynaItem2ElimItem)");
        sql.append(" union \r\n");
        sql.append("select to_char(i2.FNumber) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement,");
        sql.append(" b.FValueType, b.FYear, b.FPeriod, sum(b.FValue) as FValue, b.FDynaItemType");
        sql.append(" from t_csl_dynaItemData a");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" inner join t_csl_dynaItem2ElimItem de");
        sql.append(" on i.FId = de.FDynaItemId");
        sql.append(" inner join t_csl_rptItem i2");
        sql.append(" on de.FElimItemId = i2.FId");
        sql.append(" where a.FReportId = ?");
        sql.append(" and b.FDynaItemType in (1, 2, 3)");
        sql.append(" and ((b.FDataElement = ").append(4);
        sql.append(" and i2.FControl = ").append(1);
        sql.append(") or (b.FDataElement = ").append(4);
        sql.append(" and i2.FControl = ").append(6);
        sql.append(") or (b.FDataElement = ").append(2);
        sql.append(" and i2.FControl = ").append(9);
        sql.append(") or (b.FDataElement = ").append(3);
        sql.append(" and i2.FControl = ").append(9);
        sql.append("))");
        sql.append(" group by i2.FNumber, b.FKeyNumber, b.FKeyName, b.FDataElement, ");
        sql.append(" b.FValueType, b.FYear, b.FPeriod, b.FDynaItemType");
        HashMap result = new HashMap();
        for (int i = 0; i < reportIds.size(); ++i) {
            String reportId = (String)reportIds.get(i);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{reportId, reportId});
            try {
                ArrayList itemData = new ArrayList();
                while (rowSet.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = rowSet.getString("FItemId");
                    data.put("itemNumber", itemId);
                    String keyNumber = rowSet.getString("FkeyNumber");
                    data.put("ditemNumber", keyNumber);
                    String keyName = rowSet.getString("FKeyName");
                    data.put("ditemName", keyName);
                    int dataElement = rowSet.getInt("FDataElement");
                    data.put("dataElement", new Integer(dataElement));
                    int valueType = rowSet.getInt("FValueType");
                    data.put("valueType", new Integer(valueType));
                    int fyear = rowSet.getInt("Fyear");
                    data.put("year", new Integer(fyear));
                    int fperiod = rowSet.getInt("FPeriod");
                    data.put("period", new Integer(fperiod));
                    BigDecimal value = rowSet.getBigDecimal("FValue");
                    data.put("value", value);
                    int dynaItemType = rowSet.getInt("FDynaItemType");
                    data.put("dynaItemType", DynaItemTypeEnum.getEnum((int)dynaItemType));
                    itemData.add(data);
                }
                if (itemData.isEmpty()) continue;
                result.put(reportId, itemData);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected String _removeBatch(Context ctx, List list, Map param) throws BOSException, EASBizException {
        int result = 0;
        OrgTreeInfo tree = (OrgTreeInfo)param.get("KeyOrgTree");
        int mergeType = CslRptUtil.getMergeMode(ctx, tree.getId().toString()).getValue();
        if (list.size() == 1) {
            Map data = (Map)list.get(0);
            int b = this.tryToDelete(ctx, data, param, mergeType);
            if (b == 2) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SelectedData_NotImported", (Locale)ctx.getOriginLocale())));
            }
            if (b == 3) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"221_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale())));
            }
            return null;
        }
        StringBuffer error = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Map data = (Map)list.get(i);
            int b = this.tryToDelete(ctx, data, param, mergeType);
            if (b == 0) {
                ++result;
                continue;
            }
            error.append(data.get("companyName")).append(" ");
            error.append(data.get("targetCompanyName")).append(" ");
            error.append(data.get("currencyName")).append(" ");
            error.append(data.get("targetCurrencyName")).append(" ");
            if (b == 2) {
                error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"222_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                continue;
            }
            if (b != 3) continue;
            error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"223_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
        }
        return error.toString();
    }

    private int tryToDelete(Context ctx, Map data, Map params, int mergeType) throws BOSException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        StringBuffer oql = new StringBuffer();
        oql.append("select FSourceType, FImportedGroup from T_CSL_InvestItemData ");
        oql.append(" where FOrgBoundID = ? and FCompanyID = ?");
        oql.append(" and FTargetCompanyID = ? and FYear = ?");
        oql.append(" and FPeriod = ? and FPeriodType = ? and FCurrencyId = ?");
        oql.append(" and FTargetCurrencyID = ?");
        Object[] param = new Object[]{orgTree.getId().toString(), data.get("companyId"), data.get("targetCompanyId"), params.get("Year"), params.get("Period"), params.get("PeriodType"), data.get("currencyId"), data.get("targetCurrencyId")};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])param);
        try {
            if (rowSet.next()) {
                int sourceType = rowSet.getInt("FSourceType");
                String group = rowSet.getString("FImportedGroup");
                if (sourceType == 1) {
                    return 2;
                }
                if (mergeType == 1 && !StringUtils.equals((String)group, (String)orgUnit.getId().toString())) {
                    return 3;
                }
                StringBuffer delete = new StringBuffer();
                delete.append("delete T_CSL_InvestItemData ");
                delete.append(" where FOrgBoundID = ? ");
                delete.append(" and FCompanyID = ? and FTargetCompanyID = ?");
                delete.append(" and FYear = ? and FPeriod = ? and FPeriodType = ?");
                delete.append(" and FCurrencyID = ? and FTargetCurrencyId = ?");
                delete.append(" and FSourceType = ").append(2);
                DbUtil.execute((Context)ctx, (String)delete.toString(), (Object[])param);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return 0;
    }

    @Override
    protected String _importInvestItemData(Context ctx, boolean isCovert, Map reportDatas, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        Date day = (Date)params.get("Day");
        int periodType = (Integer)params.get("PeriodType");
        Connection conn = null;
        Statement st = null;
        StringBuffer error = new StringBuffer();
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            Iterator iter = reportDatas.keySet().iterator();
            while (iter.hasNext()) {
                String reportId = (String)iter.next();
                if (isCovert) {
                    StringBuffer oql = new StringBuffer();
                    oql.append("select distinct FImportedGroup from T_CSL_InvestItemData");
                    oql.append(" where FReportID = '").append(reportId).append("'");
                    oql.append(" or FReportID in (select fsourcerptid from t_csl_cslreport where fid='").append(reportId).append("' and fadjuststatus=1) ");
                    oql.append(" or FReportID in (select fid from t_csl_cslreport where fsourcerptid='").append(reportId).append("' and fadjuststatus=1) ");
                    oql.append(" and FSourceType = ").append(2);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
                    if (rowSet.next()) {
                        String importedGroup = rowSet.getString("FImportedGroup");
                        if (orgUnit.getId().toString().equals(importedGroup)) {
                            oql = new StringBuffer();
                            oql.append("delete T_CSL_InvestItemData ");
                            oql.append(" where FReportID = '").append(reportId).append("'");
                            oql.append(" or FReportID in (select fsourcerptid from t_csl_cslreport where fid='").append(reportId).append("' and fadjuststatus=1) ");
                            oql.append(" or FReportID in (select fid from t_csl_cslreport where fsourcerptid='").append(reportId).append("' and fadjuststatus=1) ");
                            oql.append(" and FSourceType = ").append(2);
                            st.addBatch(oql.toString());
                        } else {
                            reportDatas.put(reportId, null);
                            iter.remove();
                            CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo("select name, orgUnit.name, currency.name where id = '" + reportId + "'");
                            error.append(report.getName()).append(" ");
                            error.append(report.getOrgUnit().getName()).append(" ");
                            error.append(report.getCurrency().getName()).append("\n");
                            continue;
                        }
                    }
                }
                List itemDatas = (List)reportDatas.get(reportId);
                CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectStringPK(reportId));
                this.importDatas(ctx, isCovert, itemDatas, orgTree.getId().toString(), orgUnit.getId().toString(), report, year, period, periodType, day, st);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : When import dyna item data", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        if (error.length() > 0) {
            error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"224_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
            error.append("\n");
        }
        return error.toString();
    }

    private void importDatas(Context ctx, boolean isCovert, List itemDatas, String orgTreeId, String orgUnitId, CslReportInfo report, int year, int period, int periodType, Date day, Statement st) throws EASBizException, BOSException {
        String companyId = report.getOrgUnit().getId().toString();
        String currencyId = report.getCurrency().getId().toString();
        ArrayList excludeDItems = new ArrayList();
        for (int i = 0; i < itemDatas.size(); ++i) {
            String targetCompanyId;
            Map itemData = (Map)itemDatas.get(i);
            if (excludeDItems.contains(itemData.get("ditemNumber")) || (targetCompanyId = CslRptUtil.getTargetCompany(ctx, (String)itemData.get("ditemNumber"), (DynaItemTypeEnum)itemData.get("dynaItemType"))) == null || targetCompanyId.equals(companyId)) continue;
            String com = "select FId from t_org_structure where FTreeId = ? and FUnitId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)com, (Object[])new Object[]{orgTreeId, targetCompanyId});
            if (rowSet.size() <= 0) continue;
            String itemNumber = (String)itemData.get("itemNumber");
            int dataElement = (Integer)itemData.get("dataElement");
            if (!isCovert) {
                StringBuffer oql = new StringBuffer();
                oql.append("select FSourceType from T_CSL_InvestItemData ");
                oql.append(" where FOrgBoundID = ? and FCompanyID = ?");
                oql.append(" and FTargetCompanyID = ? and FItemNumber = ?");
                oql.append(" and FYear = ? and FPeriod = ? and FPeriodType = ?");
                oql.append(" and FDataElement = ?");
                oql.append(" and FTargetCurrencyID = ?");
                Object[] param = new Object[]{orgTreeId, companyId, targetCompanyId, itemNumber, new Integer(year), new Integer(period), new Integer(periodType), new Integer(dataElement), currencyId};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])param);
                try {
                    if (rowSet.next()) {
                        int sourceType = rowSet.getInt("FSourceType");
                        if (sourceType == 1) {
                            excludeDItems.add(itemData.get("ditemNumber"));
                            continue;
                        }
                        StringBuffer delete = new StringBuffer();
                        delete.append("delete T_CSL_InvestItemData ");
                        delete.append(" where FOrgBoundID = '").append(orgTreeId);
                        delete.append("' and FCompanyID = '").append(companyId);
                        delete.append("' and FTargetCompanyID = '").append(targetCompanyId);
                        delete.append("' and FItemNumber = '").append(itemNumber);
                        delete.append("' and FYear = ").append(year);
                        delete.append(" and FPeriod = ").append(period);
                        delete.append(" and FPeriodType = ").append(periodType);
                        delete.append(" and FTargetCurrencyId = '").append(currencyId).append("'");
                        delete.append(" and FDataElement = ").append(dataElement);
                        delete.append(" and FSourceType = ").append(2);
                        st.addBatch(delete.toString());
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_CSL_InvestItemData");
            sql.append(" (FID, FOrgBoundID, FOrgUnitID, FCompanyID, FTargetCompanyID,");
            sql.append(" FCurrencyID, FTargetCurrencyID, FReportId, FItemNumber, FYear,");
            sql.append(" FPeriod, FDay, FMoney, FPeriodType, FCommitStatus, FCommitDate,");
            sql.append(" FDataElement, FSourceType, FImportedGroup, FCreatorID, FCreateTime,");
            sql.append(" FLastUpdateUserId, FLastUpdateTime, FControlUnitID)");
            BOSUuid id = BOSUuid.create((BOSObjectType)new RPTInterItemDataInfo().getBOSType());
            sql.append(" values('").append(id.toString());
            sql.append("', '").append(orgTreeId);
            sql.append("', '").append(orgUnitId);
            sql.append("', '").append(companyId);
            sql.append("', '").append(targetCompanyId);
            sql.append("', '").append(report.getSourceCurrency().getId().toString());
            sql.append("', '").append(report.getCurrency().getId().toString());
            sql.append("', '").append(report.getId().toString());
            sql.append("', '").append(itemNumber);
            sql.append("', ").append(report.getYear());
            sql.append(", ").append(report.getPeriod());
            sql.append(", ").append(CslRptUtil.formatDateForSql(day));
            String value = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)itemData.get("value")));
            sql.append(", ").append(value);
            sql.append(", ").append(report.getPeriodType().getValue());
            if (report.getAdjustStatus().equals((Object)AdjustStatusEnum.ADJUSTED) && report.getSourceRpt() != null) {
                sql.append(", ").append(3);
            } else {
                sql.append(", ").append(report.getCommittedStatus().getValue());
            }
            sql.append(", ").append(CslRptUtil.formatDateForSql(report.getAuditTime()));
            sql.append(", ").append(itemData.get("dataElement"));
            sql.append(", ").append(2);
            sql.append(", '").append(orgUnitId);
            sql.append("', '").append(ctx.getCaller().toString());
            String now = CslRptUtil.formatDateForSql(new Date());
            sql.append("', ").append(now);
            sql.append(", '").append(ctx.getCaller().toString());
            sql.append("', ").append(now);
            sql.append(", '").append(this.getCU(ctx).getId().toString());
            sql.append("')");
            try {
                st.addBatch(sql.toString());
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private CtrlUnitInfo getCU(Context ctx) {
        InvestItemDataInfo model = new InvestItemDataInfo();
        if (model.getCU() != null) {
            return model.getCU();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }
}

