/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.BoundTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractItemHisExchgRateControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ItemHisExchgRateControllerBean
extends AbstractItemHisExchgRateControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkExists(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!"true".equals(model.get("isImport"))) {
            this.checkModel(ctx, (ItemHisExchgRateInfo)model);
            this.checkExists(ctx, model);
        }
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (!"true".equals(model.get("isImport"))) {
            this.checkModel(ctx, (ItemHisExchgRateInfo)model);
        }
        super._update(ctx, pk, model);
    }

    private void checkModel(Context ctx, ItemHisExchgRateInfo model) throws EASBizException, BOSException {
        if (model == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        StringBuffer param = new StringBuffer();
        String desc = null;
        RPTItemInfo rptItem = model.getItem();
        filterItems.add(new FilterItemInfo("item", (Object)rptItem.getId().toString()));
        param.append(rptItem.getName());
        BoundTypeEnum boundType = model.getBoundType();
        filterItems.add(new FilterItemInfo("boundType", (Object)new Integer(boundType.getValue())));
        if (boundType.getValue() == 1) {
            OrgTreeInfo orgBound = model.getOrgBound();
            filterItems.add(new FilterItemInfo("orgBound", (Object)orgBound.getId().toString()));
            FullOrgUnitInfo orgGroup = model.getOrgBoundGrp();
            filterItems.add(new FilterItemInfo("orgBoundGrp", (Object)orgGroup.getId().toString()));
            param.append(",").append(orgBound.getName());
            param.append(",").append(orgGroup.getName());
            desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemHisRateKey2", (Locale)ctx.getOriginLocale());
        } else {
            FullOrgUnitInfo company = model.getCompany();
            filterItems.add(new FilterItemInfo("company", (Object)company.getId().toString()));
            param.append(",").append(company.getName());
            desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemHisRateKey1", (Locale)ctx.getOriginLocale());
            FullOrgUnitInfo prmtTargetCompany = model.getPrmtTargetCompany();
            String prmtTargetCompanyId = null;
            if (prmtTargetCompany != null) {
                prmtTargetCompanyId = prmtTargetCompany.getId().toString();
                param.append(",").append(prmtTargetCompany.getName());
                desc = CslRptUtil.getString("ItemHisRateKey3");
            }
            filterItems.add(new FilterItemInfo("prmtTargetCompany", (Object)prmtTargetCompanyId));
        }
        String dataCollectNumber = model.getDataCollectNumber();
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            filterItems.add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(model.getChangeDate());
        Calendar checkDate = Calendar.getInstance();
        checkDate.setTime(new Date(0L));
        checkDate.set(1, calendar.get(1));
        checkDate.set(2, calendar.get(2));
        checkDate.set(5, calendar.get(5));
        checkDate.set(11, 0);
        filterItems.add(new FilterItemInfo("changeDate", (Object)checkDate.getTime()));
        param.append(",").append(model.getChangeDate());
        CurrencyInfo currency = model.getCurrency();
        filterItems.add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        param.append(",").append(currency.getName());
        if (model != null && model.getId() != null) {
            filterItems.add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filterInfo)) {
            NumericExceptionSubItem ex = new NumericExceptionSubItem("009", desc);
            throw new EASBizException(ex, new Object[]{param});
        }
    }

    private void checkExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            ItemHisExchgRateInfo itemHisExchgRateInfo = (ItemHisExchgRateInfo)model;
            FilterInfo filter = new FilterInfo();
            if (itemHisExchgRateInfo.getOrgBound() != null && itemHisExchgRateInfo.getOrgBoundGrp() != null) {
                filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)itemHisExchgRateInfo.getOrgBound().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("orgBoundGrp.id", (Object)itemHisExchgRateInfo.getOrgBoundGrp().getId().toString()));
            }
            if (itemHisExchgRateInfo.getCompany() != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)itemHisExchgRateInfo.getCompany().getId().toString()));
            }
            String prmtTargetCompanyId = null;
            if (itemHisExchgRateInfo.getPrmtTargetCompany() != null) {
                prmtTargetCompanyId = itemHisExchgRateInfo.getPrmtTargetCompany().getId().toString();
            }
            filter.getFilterItems().add(new FilterItemInfo("prmtTargetCompany.id", (Object)prmtTargetCompanyId));
            if (itemHisExchgRateInfo.getCurrency() != null) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)itemHisExchgRateInfo.getCurrency().getId().toString()));
            }
            if (itemHisExchgRateInfo.getItem() != null) {
                filter.getFilterItems().add(new FilterItemInfo("item.id", (Object)itemHisExchgRateInfo.getItem().getId().toString()));
            }
            if (itemHisExchgRateInfo.getChangeDate() != null) {
                filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)itemHisExchgRateInfo.getChangeDate()));
            }
            if (itemHisExchgRateInfo.getDataCollectNumber() != null) {
                filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)itemHisExchgRateInfo.getDataCollectNumber()));
            }
            StringBuffer strFilterMask = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (i > 0) {
                    strFilterMask.append(" and ");
                }
                strFilterMask.append("#").append(i);
            }
            filter.setMaskString(strFilterMask.toString());
            if (super.exists(ctx, filter)) {
                throw new ServerException(ServerException.DATA_DOUBLE);
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ItemHisExchgRateInfo info = this.getItemHisExchgRateInfo(ctx, "select company.name, orgBound.name, orgBoundGrp.name, item.name, currency.name, boundType where id = '" + pk.toString() + "'");
        if (info.getBoundType().getValue() == 2) {
            return info.getCompany().getName() + " " + info.getItem().getName() + " " + info.getCurrency().getName();
        }
        return info.getOrgBound().getName() + " " + info.getOrgBoundGrp().getName() + " " + info.getItem().getName() + " " + info.getCurrency().getName();
    }

    @Override
    protected Map _getAuthorizedOrgsNumber(Context ctx, RptProperties rptProperties) throws BOSException, EASBizException {
        IObjectPK userPK = (IObjectPK)rptProperties.getObject("userPK");
        IPermission permissionLocalInstance = PermissionFactory.getLocalInstance((Context)ctx);
        Map map = permissionLocalInstance.getAuthorizedOrgs(userPK, OrgType.Company, null, null, null);
        Map profitCenterMap = permissionLocalInstance.getAuthorizedOrgs(userPK, OrgType.ProfitCenter, null, null, null);
        map.putAll(profitCenterMap);
        map.put("orgCompany", this.getOrgCompanyNumber(ctx, map));
        OrgTreeCollection orgTreeCollection = permissionLocalInstance.getAllUnionTrees(userPK);
        Set setOrgRange = this.transformToSet(orgTreeCollection);
        map.put("orgRange", setOrgRange);
        Set setOrgUnit = this.getOrgUnit(ctx, orgTreeCollection, userPK);
        map.put("UnionDebt", setOrgUnit);
        return map;
    }

    private Set getOrgUnit(Context ctx, OrgTreeCollection orgTreccCollection, IObjectPK userPK) throws BOSException {
        int iSize = orgTreccCollection.size();
        HashSet<String> idSet = new HashSet<String>(iSize);
        if (null == orgTreccCollection || iSize == 0) {
            return idSet;
        }
        StringBuffer ids = new StringBuffer(iSize);
        for (int i = 0; i < iSize; ++i) {
            ids.append("'").append(orgTreccCollection.get(i).getId()).append("',");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT BaseUnit.FNumber As FNumber FROM T_ORG_BaseUnit BaseUnit ");
        buffer.append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ");
        buffer.append(" INNER JOIN T_PM_OrgRange OrgRange ON BaseUnit.FID = OrgRange.FOrgID  ");
        buffer.append(" WHERE Structure.FTreeId in (").append(ids.deleteCharAt(ids.length() - 1)).append(")");
        buffer.append("  AND BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? ");
        Object[] params = new Object[]{userPK.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        try {
            while (rs.next()) {
                String unitNumber = rs.getString("FNumber");
                idSet.add(unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return idSet;
    }

    private Set getOrgCompanyNumber(Context ctx, Map map) throws BOSException {
        HashSet<Object> idSet = new HashSet<Object>();
        if (map.isEmpty()) {
            return idSet;
        }
        idSet.addAll(map.keySet());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(viewInfo);
        idSet.clear();
        if (null != fullOrgUnitCollection && fullOrgUnitCollection.size() > 0) {
            int iSize = fullOrgUnitCollection.size();
            for (int i = 0; i < iSize; ++i) {
                idSet.add(fullOrgUnitCollection.get(i).getNumber());
            }
        }
        return idSet;
    }

    private Set transformToSet(OrgTreeCollection collection) {
        HashSet<String> idSet = new HashSet<String>();
        int iSize = collection.size();
        if (null != collection && iSize > 0) {
            for (int i = 0; i < iSize; ++i) {
                idSet.add(collection.get(i).getNumber());
            }
        }
        return idSet;
    }
}

