/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightCollection;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractOtherOwnerRightControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OtherOwnerRightControllerBean
extends AbstractOtherOwnerRightControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.OtherOwnerRightControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OtherOwnerRightInfo info = (OtherOwnerRightInfo)model;
        OtherOwnerRightEntryCollection col = info.getEntries();
        if (info.getCompany() == null) {
            throw new AdjustException(AdjustException.ORGUNIT_BLANK);
        }
        if (info.getCurrency() == null) {
            throw new AdjustException(AdjustException.CURRENCY_BLANK);
        }
        if (col.size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        for (int i = 0; i < col.size(); ++i) {
            OtherOwnerRightEntryInfo lineInfo = col.get(i);
            if (lineInfo.getItem() == null) {
                throw new AdjustException(AdjustException.ITEM_NOTNULL);
            }
            if (lineInfo.getChangeMoney() == null) {
                throw new AdjustException(AdjustException.CHANGEMONEY_ISNULL);
            }
            if (lineInfo.getFewStockholderAmount() == null) {
                throw new AdjustException(AdjustException.FEWMONEY);
            }
            if (lineInfo.getFewStockholderRate() != null) continue;
            throw new AdjustException(AdjustException.FEWRATE_ISNULL);
        }
        this.checkCompanyIsBasic(ctx, info.getCompany().getId().toString());
    }

    protected void checkCompanyIsBasic(Context ctx, String companyId) throws BOSException, AdjustException {
        StringBuffer s = new StringBuffer();
        s.append("select b.fname_" + ctx.getLocale() + " from t_org_baseUnit b inner join t_org_structure s on b.fid=s.funitid");
        s.append(" inner join t_org_tree t  on s.ftreeid = t.fid");
        s.append(" where t.fisbasic=1 and t.ftype = 8 and FIsForBudget=0 and t.fstatus = 1 and b.fid= ?");
        IRowSet rss = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{companyId});
        if (rss.size() < 1) {
            throw new AdjustException(AdjustException.COMP_NOTINBASE);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected void _removeBach(Context ctx, List list) throws BOSException, EASBizException {
        OtherOwnerRightCollection col = this.getOtherOwnerRightCollection(ctx);
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)itor.next().toString()));
            col.remove(this.getOtherOwnerRightInfo(ctx, (IObjectPK)pk));
        }
        for (int i = 0; i < col.size(); ++i) {
            this._submit(ctx, (IObjectValue)col.get(i));
        }
    }

    @Override
    protected BigDecimal _calFewStockHolder(Context ctx, String companyId, Date changeDate) throws BOSException, EASBizException {
        this.checkCompanyIsBasic(ctx, companyId);
        BigDecimal result = new BigDecimal("0");
        StringBuffer s = new StringBuffer();
        s.append(" select fchangedate from T_csl_shareRela where exists (");
        s.append(" select fchangedate from T_csl_shareRela r inner join  t_org_company c  \r\n ");
        s.append(" on  r.FInvesteeCompanyID = c.fid ");
        s.append(" inner join  t_org_baseunit b on b.fid = c.fid \r\n");
        s.append(" inner join  t_org_structure s  on s.funitid=b.fid \r\n");
        s.append(" inner join t_org_tree  t  on  s.ftreeId = t.fid \r\n");
        s.append(" where t.fisbasic=1 and t.ftype = 8 and t.fstatus = 1 and FIsForBudget=0 and r.fshareholderid is not null ");
        s.append(" and r.FInvesteeCompanyID= ? and fchangedate = ? )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{companyId, changeDate});
        try {
            if (rs.next()) {
                s = new StringBuffer();
                s.append(" select isnull(sum(r.fsharescale),0) as frate from T_csl_shareRela r inner join  t_org_company c  \r\n ");
                s.append(" on  r.FInvesteeCompanyID = c.fid ");
                s.append(" inner join  t_org_baseunit b on b.fid = c.fid \r\n");
                s.append(" inner join  t_org_structure s  on s.funitid=b.fid \r\n");
                s.append(" inner join t_org_tree  t  on  s.ftreeId = t.fid \r\n");
                s.append(" where t.fisbasic=1 and t.ftype = 8 and t.fstatus = 1  and FIsForBudget=0 and r.fshareholderid is not null ");
                s.append(" and r.FInvesteeCompanyID= ? and fchangedate = ? ");
                s.append(" and r.FIsOut =0");
                rs = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{companyId, changeDate});
                if (rs.next()) {
                    result = rs.getBigDecimal("frate");
                }
            } else {
                s = new StringBuffer();
                s.append(" select isnull(sum(r.fsharescale),0) as frate  from t_csl_sharerela r where r.fchangedate = (");
                s.append(" select top 1 r.fchangedate from T_csl_shareRela r inner join  t_org_company c   \r\n ");
                s.append(" on  r.FInvesteeCompanyID = c.fid ");
                s.append(" inner join  t_org_baseunit b on b.fid = c.fid \r\n");
                s.append(" inner join  t_org_structure s  on s.funitid=b.fid \r\n");
                s.append(" inner join t_org_tree  t  on  s.ftreeId = t.fid \r\n");
                s.append(" where t.fisbasic=1 and t.ftype = 8 and t.fstatus = 1  and FIsForBudget=0 and r.fshareholderid is not null ");
                s.append(" and r.FInvesteeCompanyID= ? and fchangedate < ? order by fchangedate desc )");
                s.append(" and r.FInvesteeCompanyID= ?");
                s.append(" and r.FIsOut =0");
                rs = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{companyId, changeDate, companyId});
                if (rs.next()) {
                    result = rs.getBigDecimal("frate");
                }
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        return result;
    }
}

